/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.tracker.ADAPUrlClicksHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class RestAPIHandler {
    private static volatile RestAPIHandler instance = null;
    private static final Logger CLIENT_LOGGER = Logger.getLogger("ClientLogger");
    private Hashtable<String, Hashtable<String, Object>> apiMapping = new Hashtable();
    private static final String CLASS_INSTANCE = "CLASS_INSTANCE";
    private static final String METHOD_INSTANCE = "METHOD_INSTANCE";
    private static final String GET_INSTANCE_METHOD = "getInstance";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RestAPIHandler getInstance() {
        if (instance != null) return instance;
        Class<RestAPIHandler> clazz = RestAPIHandler.class;
        synchronized (RestAPIHandler.class) {
            if (instance != null) return instance;
            instance = new RestAPIHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private RestAPIHandler() {
        try {
            this.initializeAPIMap();
        }
        catch (Exception ex) {
            CLIENT_LOGGER.log(Level.SEVERE, "Exception while initialing RestAPI map", ex);
        }
    }

    private void initializeAPIMap() {
        try {
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADAPRestApiMapping", (Row)null);
            Iterator iterator = dataObject.getRows("ADAPRestApiMapping");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String urlPath = (String)row.get("URL_PATH");
                String className = (String)row.get("CLASS_NAME");
                String methodName = (String)row.get("METHOD_NAME");
                Long accessId = (Long)row.get("ACCESS_ID");
                if (accessId == null) {
                    accessId = 0L;
                }
                Long accessType = (Long)row.get("ACCESS_TYPE");
                Long meTrackerFeatureId = (Long)row.get("ME_TRACKER_FEATURE_ID");
                Class<?> caller = Class.forName(className);
                Class[] argTypes = new Class[]{};
                Method getInstanceMethod = caller.getMethod(GET_INSTANCE_METHOD, argTypes);
                Object obj = getInstanceMethod.invoke(caller, new Object[0]);
                argTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
                Method executionMethod = caller.getMethod(methodName, argTypes);
                Hashtable<String, Object> mappingInfo = new Hashtable<String, Object>();
                mappingInfo.put(CLASS_INSTANCE, obj);
                mappingInfo.put(METHOD_INSTANCE, executionMethod);
                mappingInfo.put("ACCESS_ID", accessId);
                mappingInfo.put("ACCESS_TYPE", accessType);
                mappingInfo.put("ME_TRACKER_FEATURE_ID", meTrackerFeatureId);
                this.apiMapping.put(urlPath, mappingInfo);
            }
            CLIENT_LOGGER.log(Level.INFO, " Rest API map initialized in RestAPIHandler");
        }
        catch (Exception ex) {
            CLIENT_LOGGER.log(Level.SEVERE, "Exception while initialing RestAPI map", ex);
        }
    }

    public int execute(HttpServletRequest request, HttpServletResponse response) {
        int errCode = 200;
        String urlPath = request.getRequestURI().replaceFirst("/api/(json|xml)/", "/");
        try {
            Hashtable<String, Object> mappingInfo = this.apiMapping.get(urlPath);
            if (mappingInfo != null) {
                Long requiredAccessId = (Long)mappingInfo.get("ACCESS_ID");
                Long requiredAccessType = (Long)mappingInfo.get("ACCESS_TYPE");
                if (requiredAccessId != 0L) {
                    HttpSession session = request.getSession();
                    ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
                    HashMap actionAccesses = authObject.getAccesses();
                    if (!actionAccesses.containsKey(requiredAccessId)) {
                        errCode = 401;
                        throw new Exception("ACCESS DENIED for " + urlPath);
                    }
                    int userAccessType = (Integer)actionAccesses.get(requiredAccessId);
                    if (requiredAccessType == 32L && userAccessType != 32) {
                        errCode = 401;
                        throw new Exception("ACCESS DENIED for " + urlPath);
                    }
                    request.setAttribute("readOnly", (Object)(requiredAccessType == 1L && userAccessType != 32 ? 1 : 0));
                }
                Object obj = mappingInfo.get(CLASS_INSTANCE);
                Method executionMethod = (Method)mappingInfo.get(METHOD_INSTANCE);
                CLIENT_LOGGER.log(Level.INFO, "Accessing URL: {0}, Class: {1}, Method : {2}", new String[]{urlPath, obj.getClass().getName(), executionMethod.getName()});
                executionMethod.invoke(obj, request, response);
                Long meTrackerFeatureId = (Long)mappingInfo.get("ME_TRACKER_FEATURE_ID");
                if (meTrackerFeatureId != 0L) {
                    ADAPUrlClicksHandler.getInstance().updateEmberClientClicks(request, meTrackerFeatureId);
                }
            } else {
                CLIENT_LOGGER.log(Level.INFO, "RestAPI unavailable for " + urlPath);
                errCode = 404;
            }
        }
        catch (Exception ex) {
            CLIENT_LOGGER.log(Level.SEVERE, "Exception while executing RestAPI ", ex);
        }
        return errCode;
    }
}

