/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.admin;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.AuditEventAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.APIUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public class ADAuditExcludeHandler {
    private static volatile ADAuditExcludeHandler instance = null;
    private static Logger logger = Logger.getLogger(ADAuditExcludeHandler.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ADAuditExcludeHandler getInstance() {
        if (instance != null) return instance;
        Class<ADAuditExcludeHandler> clazz = ADAuditExcludeHandler.class;
        synchronized (ADAuditExcludeHandler.class) {
            if (instance != null) return instance;
            instance = new ADAuditExcludeHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void getData(HttpServletRequest request, HttpServletResponse response) {
        String ret = "";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String domainName = request.getParameter("domain");
            Criteria crit = new Criteria(Column.getColumn((String)"AUDServiceAccountFilter", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDServiceAccountFilter", crit);
            ArrayList excludeUsersDetails = new ArrayList();
            if (!dObj.isEmpty()) {
                Iterator iter = dObj.getRows("AUDServiceAccountFilter");
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("USER_NAME", (String)row.get("USER_NAME"));
                    map.put("OBJECT_GUID", (String)row.get("OBJECT_GUID"));
                    excludeUsersDetails.add(map);
                }
            }
            HashMap<Object, Object> excludeInfo = new HashMap<Object, Object>();
            excludeInfo.put("excludeUsersDetails", excludeUsersDetails);
            excludeInfo.put("domainName", domainName);
            ret = APIUtil.getInstance().mapToJSONString(excludeInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret);
    }

    public void setData(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            ret.put("message", (Object)rb.getString("adap.ConfigureServiceAccounts.Exception_While_adding_Removing_Users"));
            String strData = request.getParameter("data");
            JSONObject data = new JSONObject(strData);
            JSONArray excludeUsersDetails = data.optJSONArray("excludeUsersDetails");
            String domainName = data.getString("domainName");
            Criteria crit = new Criteria(Column.getColumn((String)"AUDServiceAccountFilter", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDServiceAccountFilter", crit);
            dObj.deleteRows("AUDServiceAccountFilter", crit);
            String newlyAddedUserNames = "";
            for (int i = 0; i < excludeUsersDetails.length(); ++i) {
                JSONObject obj = excludeUsersDetails.getJSONObject(i);
                Row userRow = new Row("AUDServiceAccountFilter");
                userRow.set("OBJECT_GUID", obj.get("OBJECT_GUID"));
                userRow.set("USER_NAME", obj.get("USER_NAME"));
                userRow.set("DOMAIN_NAME", (Object)domainName);
                newlyAddedUserNames = newlyAddedUserNames + obj.get("USER_NAME") + " ,";
                dObj.addRow(userRow);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(dObj);
            AuditEventAPI.getInstance();
            AuditEventAPI.getServiceAccountDetails();
            logger.log(Level.INFO, rb.getString("adap.ConfigureServiceAccounts.audit_entry.Successfully_excluded") + " Users : " + newlyAddedUserNames);
            ret.put("success", true);
            ret.put("message", (Object)rb.getString("adap.AlertsSettings.Successfully_saved_the_settings"));
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.ConfigureServiceAccounts.audit_entry.Successfully_excluded"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.service_account_settings_changed", rb.handleGetObject("adap.ConfigureServiceAccounts.audit_entryaddn.users_are", new String[]{newlyAddedUserNames})}));
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                ret.put("message", (Object)rb.getString("adap.ConfigureServiceAccounts.Exception_While_adding_Removing_Users"));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.ConfigureServiceAccounts.audit_entry.Failed_to_exclude_users"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.service_account_settings_changed", "-"}));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }
}

