/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.admin;

import com.adventnet.sym.adsm.auditing.server.archive.ArchiveFileAPI;
import com.adventnet.sym.adsm.auditing.server.archive.DataArchiver;
import com.adventnet.sym.adsm.auditing.server.backupdata.RestoreArchivedEventTable;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.BackupTableUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.JSONUtil;
import java.io.File;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public class ArchiveHandler {
    private static volatile ArchiveHandler instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArchiveHandler getInstance() {
        if (instance != null) return instance;
        Class<ArchiveHandler> clazz = ArchiveHandler.class;
        synchronized (ArchiveHandler.class) {
            if (instance != null) return instance;
            instance = new ArchiveHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void getArchiveData(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            ArrayList backupTableSettingsList = BackupTableUtil.getBackUpTableSettings();
            ret.put("storageData", (Object)JSONUtil.listToJSONArray((List)backupTableSettingsList));
            DataArchiver.getInstance();
            String baseArchiveDir = DataArchiver.getBaseArchiveDirectory();
            ret.put("archiveFolder", (Object)baseArchiveDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void setArchiveData(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            ret.put("message", (Object)rb.getString("adap.admin.DeleteReports.SaveFail"));
            String strData = request.getParameter("data");
            JSONObject data = new JSONObject(strData);
            String archiveFolder = data.getString("archiveFolder");
            JSONArray storageData = data.getJSONArray("storageData");
            ArrayList updateDetailsList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)storageData);
            String message = ArchiveFileAPI.getInstance().checkArchiveFolderPermission(archiveFolder);
            if (message != null && message.equalsIgnoreCase("Success")) {
                boolean b = BackupTableUtil.updateBackUpTableData((ArrayList)updateDetailsList, (String)archiveFolder);
                if (b) {
                    ret.put("success", true);
                    ret.put("message", (Object)rb.getString("adap.BackupTableSettings.audit_entry.Archive_settings_successfully_saved"));
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.BackupTableSettings.audit_entry.Archive_settings_successfully_saved"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.archive_settings_changed", rb.handleGetObject("adap.BackupTableSettings.audit_entry_addn.Details", new String[]{updateDetailsList.toString()})}));
                }
            } else {
                ret.put("message", (Object)message);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.BackupTableSettings.audit_entry.Failed_to_save_Archive_Settings", new String[]{message}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.archive_settings_changed", "-"}));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.BackupTableSettings.audit_entry.Failed_to_save_Archive_Settings", new String[]{e.getMessage()}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.archive_settings_changed", "-"}));
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void runnow(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            BackupTableUtil.archiveEvents();
            RestoreArchivedEventTable.deleteFromDB();
            String message = (String)rb.handleGetObject("adap.BackupTableSettings.Backup_table_start");
            ret.put("success", true);
            ret.put("message", (Object)message);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.manual_archived", "-"}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void getArchiveFolderSize(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        try {
            ret = ArchiveHandler.getArchiveFolderSize();
            String dbName = CommonUtil.getDBServerName();
            String dbFolder = null;
            if (dbName.equals("postgres")) {
                dbFolder = System.getProperty("user.dir").replaceAll("\\\\bin", "\\\\pgsql");
            } else if (dbName.equals("mysql")) {
                dbFolder = System.getProperty("user.dir").replaceAll("\\\\bin", "\\\\mysql");
            }
            if (dbFolder != null) {
                ret.put("dbFolder", (Object)dbFolder);
                ret.put("dbSize", (Object)ArchiveHandler.getFolderSize(Paths.get(dbFolder, new String[0])));
            }
            String path = System.getProperty("user.dir");
            DataArchiver.getInstance();
            ret.put("archiveFolder", (Object)DataArchiver.getBaseArchiveDirectory());
            ret.put("drive", (Object)(System.getProperty("user.dir").split("\\\\")[0] + File.separator));
            File file = new File(path);
            Long freeSize = file.getUsableSpace();
            ret.put("freeSpace", (Object)ArchiveHandler.getSizeStr(freeSize));
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                ret.put("errorMessage", (Object)("Error : " + e.getMessage()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static String getFolderSize(Path path) throws Exception {
        final AtomicLong size = new AtomicLong(0L);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                size.addAndGet(attrs.size());
                return FileVisitResult.CONTINUE;
            }
        });
        return ArchiveHandler.getSizeStr(size.get());
    }

    public static JSONObject getArchiveFolderSize() throws Exception {
        DataArchiver.getInstance();
        String baseArchiveDir = DataArchiver.getBaseArchiveDirectory();
        Path path = Paths.get(baseArchiveDir, new String[0]);
        JSONObject ret = new JSONObject();
        final AtomicLong size = new AtomicLong(0L);
        final AtomicLong zipSize = new AtomicLong(0L);
        final AtomicLong zipCount = new AtomicLong(0L);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (file.getFileName().toString().endsWith("zip")) {
                    zipSize.addAndGet(attrs.size());
                    zipCount.addAndGet(1L);
                }
                size.addAndGet(attrs.size());
                return FileVisitResult.CONTINUE;
            }
        });
        ret.put("size", (Object)ArchiveHandler.getSizeStr(size.get()));
        ret.put("zipCount", zipCount.get());
        ret.put("zipSize", (Object)ArchiveHandler.getSizeStr(zipSize.get()));
        return ret;
    }

    private static String getSizeStr(long size) {
        double ret = size;
        String retSizeStr = " bytes";
        if (ret > 1024.0) {
            ret /= 1024.0;
            retSizeStr = " KB";
        }
        if (ret > 1024.0) {
            ret /= 1024.0;
            retSizeStr = " MB";
        }
        if (ret > 1024.0) {
            ret /= 1024.0;
            retSizeStr = " GB";
        }
        ret *= 100.0;
        ret = Math.round(ret);
        retSizeStr = (ret /= 100.0) + retSizeStr;
        return retSizeStr;
    }
}

