/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.admin;

import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.admin.ConfigureDiskSpace;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;

public class ConfigureDiskFreeSpaceHandler {
    private static volatile ConfigureDiskFreeSpaceHandler instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigureDiskFreeSpaceHandler getInstance() {
        if (instance != null) return instance;
        Class<ConfigureDiskFreeSpaceHandler> clazz = ConfigureDiskFreeSpaceHandler.class;
        synchronized (ConfigureDiskFreeSpaceHandler.class) {
            if (instance != null) return instance;
            instance = new ConfigureDiskFreeSpaceHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void execute(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String requestString = request.getParameter("diskSpaceLimitDetails");
            JSONObject requestJson = new JSONObject(requestString);
            JSONObject responseJson = new JSONObject();
            Object message = null;
            Hashtable configureSetting = new Hashtable();
            String action = requestJson.getString("action");
            if (action != null && action.equals("recalCulate")) {
                ConfigureDiskSpace.calculateDiskSpace();
                String messageType = "success";
                configureSetting = ConfigureDiskSpace.getConfigureDiskSpace();
                Long configureSpace = (Long)configureSetting.get("CONFIGURE_SPACE");
                Long freeSpace = (Long)configureSetting.get("FREE_DISK_SPACE");
                ClientUtil.setStatusXMLElement(response, configureSpace.toString(), freeSpace.toString());
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ConfigureDiskFreeSpace.audit_entry.Recalculated_the_disk_space", new String[]{Long.toString(configureSpace), Long.toString(freeSpace)}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.recalculate_disk_space", "-"}));
            } else {
                configureSetting = ConfigureDiskSpace.getConfigureDiskSpace();
                responseJson.put("configureSettings", (Object)new JSONObject((Map)configureSetting));
                responseJson.put("message", message);
            }
            JsonResponse.getInstance().sendResponse(response, responseJson.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", "Failed to configure the Disk space configuration", 8, 16, "adap.ADAPUserAuditSeverities.audit_name.disk_space_config_changed", "-"}));
        }
    }

    public void saveAction(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String requestString = request.getParameter("diskSpaceLimitDetails");
            JSONObject requestJson = new JSONObject(requestString);
            JSONObject responseJson = new JSONObject();
            String message = null;
            Hashtable configureSetting = new Hashtable();
            String action = requestJson.getString("action");
            if (action != null && action.equals("recalCulate")) {
                ConfigureDiskSpace.calculateDiskSpace();
                String messageType = "success";
                configureSetting = ConfigureDiskSpace.getConfigureDiskSpace();
                Long configureSpace = (Long)configureSetting.get("CONFIGURE_SPACE");
                Long freeSpace = (Long)configureSetting.get("FREE_DISK_SPACE");
                ClientUtil.setStatusXMLElement(response, configureSpace.toString(), freeSpace.toString());
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ConfigureDiskFreeSpace.audit_entry.Recalculated_the_disk_space", new String[]{Long.toString(configureSpace), Long.toString(freeSpace)}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.recalculate_disk_space", "-"}));
            } else {
                String diskSpaceVal = requestJson.getString("diskSpaceVal");
                String enableVal = requestJson.getString("enableConf");
                String isNotificationEnabled = requestJson.getString("isNotificationEnabled");
                ConfigureDiskSpace.saveSettings((String)diskSpaceVal, (String)enableVal, (String)isNotificationEnabled);
                ConfigureDiskSpace.calculateDiskSpace();
                message = rb.getString("adap.common.text.status_msg.success");
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ConfigureDiskFreeSpace.audit_entry.Disk_space_configuration_Successfully", new String[]{diskSpaceVal, isNotificationEnabled}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.disk_space_config_changed", "-"}));
                configureSetting = ConfigureDiskSpace.getConfigureDiskSpace();
                responseJson.put("configureSettings", (Object)new JSONObject((Map)configureSetting));
                responseJson.put("message", (Object)message);
            }
            JsonResponse.getInstance().sendResponse(response, responseJson.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", "Failed to configure the Disk space configuration", 8, 16, "adap.ADAPUserAuditSeverities.audit_name.disk_space_config_changed", "-"}));
        }
    }
}

