/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.admin;

import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.APIUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.admin.EventErrorAlert;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.MailServerUtil;
import java.util.HashMap;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;

public class ConfigureEmailAddressHandler {
    private static volatile ConfigureEmailAddressHandler instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigureEmailAddressHandler getInstance() {
        if (instance != null) return instance;
        Class<ConfigureEmailAddressHandler> clazz = ConfigureEmailAddressHandler.class;
        synchronized (ConfigureEmailAddressHandler.class) {
            if (instance != null) return instance;
            instance = new ConfigureEmailAddressHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void execute(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Object message = null;
        String requestString = request.getParameter("alertMeDetails");
        JSONObject requestJson = new JSONObject(requestString);
        try {
            JSONObject resultantJson = new JSONObject();
            String action = requestJson.getString("action");
            Hashtable settingsTable = EventErrorAlert.getMailAddressConfig();
            HashMap<Object, Object> settingsMap = new HashMap<Object, Object>(settingsTable);
            JSONObject settingsObject = APIUtil.getInstance().mapToJSONObject(settingsMap);
            boolean mailConfigCheck = MailServerUtil.mailServerConfig();
            resultantJson.put("mailConfigCheck", mailConfigCheck);
            resultantJson.put("toAddressSettings", (Object)settingsObject);
            resultantJson.put("message", message);
            JsonResponse.getInstance().sendResponse(response, resultantJson.toString());
        }
        catch (Exception e) {
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ConfigureEmailAddress.audit_entry.Failed_to_configure_alert_mail", new String[]{requestJson.getString("toAddress")}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.alert_me_settings_changed", "-"}));
            e.printStackTrace();
        }
    }

    public void saveAction(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String message = null;
        String requestString = request.getParameter("alertMeDetails");
        JSONObject requestJson = new JSONObject(requestString);
        try {
            JSONObject resultantJson = new JSONObject();
            String action = requestJson.getString("action");
            String toAddress = requestJson.getString("toAddress");
            EventErrorAlert.saveSettings((String)toAddress);
            message = "success";
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ConfigureEmailAddress.audit_entry.Successfully_alert_mail_configured", new String[]{toAddress}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.alert_me_settings_changed", "-"}));
            Hashtable settingsTable = EventErrorAlert.getMailAddressConfig();
            HashMap<Object, Object> settingsMap = new HashMap<Object, Object>(settingsTable);
            JSONObject settingsObject = APIUtil.getInstance().mapToJSONObject(settingsMap);
            boolean mailConfigCheck = MailServerUtil.mailServerConfig();
            resultantJson.put("mailConfigCheck", mailConfigCheck);
            resultantJson.put("toAddressSettings", (Object)settingsObject);
            resultantJson.put("message", (Object)message);
            JsonResponse.getInstance().sendResponse(response, resultantJson.toString());
        }
        catch (Exception e) {
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ConfigureEmailAddress.audit_entry.Failed_to_configure_alert_mail", new String[]{requestJson.getString("toAddress")}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.alert_me_settings_changed", "-"}));
            e.printStackTrace();
        }
    }
}

