/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.admin;

import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.MailServerUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public class MailServerHandler {
    private static volatile MailServerHandler instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MailServerHandler getInstance() {
        if (instance != null) return instance;
        Class<MailServerHandler> clazz = MailServerHandler.class;
        synchronized (MailServerHandler.class) {
            if (instance != null) return instance;
            instance = new MailServerHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void getData(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            Properties prop = MailServerUtil.getMailServerSettings();
            prop.put("PASSWORD", "");
            for (Object object : prop.keySet()) {
                ret.put(String.valueOf(object), prop.get(String.valueOf(object)));
            }
            String useSecureConn = String.valueOf(ret.get("USE_SECURE_CONN"));
            if (useSecureConn.equals("false")) {
                ret.put("USE_SECURE_CONN", (Object)"none");
            }
            String[] stringArray = new String[]{"None", "SSL", "TLS/STARTTLS"};
            String[] value = new String[]{"none", "ssl", "tls"};
            JSONArray connectionType = new JSONArray();
            for (int i = 0; i < 3; ++i) {
                JSONObject obj = new JSONObject();
                obj.put("name", (Object)stringArray[i]);
                obj.put("value", (Object)value[i]);
                connectionType.put((Object)obj);
            }
            ret.put("connectionTypes", (Object)connectionType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void setData(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject ret = new JSONObject();
        Properties prop = new Properties();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            ret.put("message", (Object)rb.getString("adap.admin.DeleteReports.SaveFail"));
            String strData = request.getParameter("data");
            JSONObject data = new JSONObject(strData);
            Iterator iter = data.keys();
            while (iter.hasNext()) {
                String key = String.valueOf(iter.next());
                prop.put(key, String.valueOf(data.get(key)));
            }
            if (!prop.get("isEditingPassword").equals("true")) {
                Properties oldProp = MailServerUtil.getMailServerSettings();
                prop.put("PASSWORD", oldProp.get("PASSWORD"));
            }
            boolean b = MailServerUtil.setMailServerSettings((Properties)prop);
            prop.remove("PASSWORD");
            if (b) {
                ret.put("message", (Object)rb.getString("adap.admin.general.mail_server.message.configured_successfully"));
                ret.put("success", true);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ConfigureMailServer.audit_entry.SuccessFully_saved_mail_Server_settings", new String[]{prop.toString()}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.mail_server_settings_changed", "-"}));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ConfigureMailServer.audit_entry.Failed_to_update_mail_Server", new String[]{prop.getProperty("MAIL_SERVER"), e.getMessage()}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.mail_server_settings_changed", "-"}));
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void testMail(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        Properties prop = new Properties();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String strData = request.getParameter("data");
            JSONObject data = new JSONObject(strData);
            Iterator iter = data.keys();
            while (iter.hasNext()) {
                String key = String.valueOf(iter.next());
                prop.put(key, String.valueOf(data.get(key)));
            }
            if (!prop.get("isEditingPassword").equals("true")) {
                Properties oldProp = MailServerUtil.getMailServerSettings();
                prop.put("PASSWORD", oldProp.get("PASSWORD"));
            }
            String sentMail = MailServerUtil.sendTestMail((Properties)prop);
            ret.put("info", true);
            ret.put("tout", (Object)"5000");
            ret.put("message", (Object)(rb.getString("adap.admin.general.mail_server.message.send_mail_status") + " :" + sentMail));
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.admin.general.mail_server.message.send_mail_status") + " :" + sentMail, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.sent_test_mail", rb.handleGetObject("adap.ConfigureMailServer.audit_entry_addn.send_mail_Details", new String[]{(String)prop.get("TO_ADDRESS")})}));
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                ret.put("message", (Object)e.getMessage());
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ConfigureMailServer.audit_entry.failed_to_send_test_mail", new String[]{prop.getProperty("MAIL_SERVER"), prop.getProperty("TO_ADDRESS")}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.sent_test_mail", "-"}));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }
}

