/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.admin;

import com.adventnet.sym.adsm.auditing.server.backupdata.RestoreArchivedEventTable;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.common.EmberTableConfig;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.BackupTableUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public class RestoreBackupEventTablesHandler {
    private Logger logger = Logger.getLogger(RestoreBackupEventTablesHandler.class.getName());
    private static volatile RestoreBackupEventTablesHandler instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RestoreBackupEventTablesHandler getInstance() {
        if (instance != null) return instance;
        Class<RestoreBackupEventTablesHandler> clazz = RestoreBackupEventTablesHandler.class;
        synchronized (RestoreBackupEventTablesHandler.class) {
            if (instance != null) return instance;
            instance = new RestoreBackupEventTablesHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void showBackupEventTables(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String backupTableDetails = request.getParameter("backupTableDetails");
            JSONObject backupTableObject = new JSONObject(backupTableDetails);
            JSONObject resultantJson = new JSONObject();
            String sortColumn = backupTableObject.getString("sortColumn");
            String sortOrder = backupTableObject.getString("sortOrder");
            String rangestr = backupTableObject.optString("RANGE");
            String pageNumberStr = backupTableObject.optString("PAGE_NUMBER");
            String FROM_INDEX = backupTableObject.getString("FROM_INDEX");
            ArrayList categoriesList = BackupTableUtil.getCategoriesList();
            JSONArray categoryNames = new JSONArray();
            for (int i = 0; i < categoriesList.size(); ++i) {
                JSONObject categoryObject = new JSONObject();
                categoryObject.put("name", categoriesList.get(i));
                categoryObject.put("value", categoriesList.get(i));
                categoryNames.put((Object)categoryObject);
            }
            Integer range = 25;
            Integer pageNumber = 1;
            if (rangestr != "") {
                range = Integer.valueOf(rangestr);
            }
            if (pageNumberStr != "") {
                pageNumber = Integer.valueOf(pageNumberStr);
            }
            String loadType = backupTableObject.optString("loadType") != "" ? backupTableObject.getString("loadType") : "All";
            String category = backupTableObject.optString("category") != "" ? backupTableObject.getString("category") : "All";
            resultantJson.put("size", RestoreArchivedEventTable.getDataBaseSize());
            int count = RestoreArchivedEventTable.getBackupMetatableCount((String)category, (String)loadType);
            ArrayList backupMetaTableSettings = RestoreArchivedEventTable.getDumpEventTableSettings((String)sortColumn, (String)sortOrder, (Integer)Integer.valueOf(FROM_INDEX), (Integer)range, (Integer)count, (String)category, (String)loadType, (boolean)true);
            JSONObject tableInputParams = new JSONObject();
            JSONObject tableData = new JSONObject();
            String cvid = "16024";
            tableInputParams.put("startValue", (Object)FROM_INDEX);
            tableInputParams.put("totalCount", count);
            tableInputParams.put("sortColumn", (Object)sortColumn);
            tableInputParams.put("sortOrder", (Object)sortOrder);
            JSONArray rangeList = new JSONArray();
            for (int i = 0; i < 4; ++i) {
                JSONObject rangeItem = new JSONObject();
                rangeItem.put("value", (i + 1) * 25);
                rangeList.put((Object)rangeItem);
            }
            tableInputParams.put("rangeList", (Object)rangeList);
            tableInputParams.put("rangeValue", (Object)range);
            JSONObject ret = EmberTableConfig.getInstance().getEmberTableData(cvid, backupMetaTableSettings, tableInputParams, rb);
            tableInputParams = ret.getJSONObject("tableInputParams");
            tableInputParams.put("hideTopDivider", true);
            tableData = ret.getJSONObject("tableData");
            resultantJson.put("tableData", (Object)tableData);
            resultantJson.put("tableInputParams", (Object)tableInputParams);
            resultantJson.put("RANGE", (Object)range);
            resultantJson.put("FROM_INDEX", (Object)FROM_INDEX);
            resultantJson.put("count", count);
            resultantJson.put("PAGE_NUMBER", (Object)pageNumber);
            resultantJson.put("sortColumn", (Object)sortColumn);
            resultantJson.put("sortOrder", (Object)sortOrder);
            resultantJson.put("backupMetaTableSettings", (Object)backupMetaTableSettings);
            resultantJson.put("Category", (Object)category);
            resultantJson.put("categoryNames", (Object)categoryNames);
            JsonResponse.getInstance().sendResponse(response, resultantJson.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadBackupData(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String backupDataDetails = request.getParameter("backupDataDetails");
        JSONObject backupDataObject = new JSONObject(backupDataDetails);
        JSONObject responseJson = new JSONObject();
        try {
            String fileName = backupDataObject.getString("fileName");
            String action = backupDataObject.optString("action");
            String doAction = backupDataObject.optString("doAction");
            RestoreArchivedEventTable.getInstance().addToQueue(fileName, doAction);
            String messageType = "Success";
            String message = rb.getString("adap.RestoreBackupEventTables.Started_loading");
            if (action != null && action.equals("1")) {
                message = rb.getString("adap.RestoreBackupEventTables.Started_loading_archived_event_data");
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", message + "\n " + rb.handleGetObject("adap.RestoreBackupEventTables.audit_entry.FileName", new String[]{fileName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.restore_archived_Settings", "-"}));
            responseJson.put("message", (Object)message);
            JsonResponse.getInstance().sendResponse(response, responseJson.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", e.getMessage() + "\n " + rb.handleGetObject("adap.RestoreBackupEventTables.audit_entry.FileName", new String[]{backupDataObject.getString("fileName")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.restore_archived_Settings", "-"}));
        }
    }
}

