/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.admin;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchEmberUtil;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchFileIndexHandler;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchGlobalSearchHandler;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchLogCategoryHandler;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchReportManager;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class SearchArchivedEventsHandler {
    private static volatile SearchArchivedEventsHandler instance = null;
    private static Logger logger = Logger.getLogger(SearchArchivedEventsHandler.class.getName());

    private SearchArchivedEventsHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SearchArchivedEventsHandler getInstance() {
        if (instance != null) return instance;
        Class<SearchArchivedEventsHandler> clazz = SearchArchivedEventsHandler.class;
        synchronized (SearchArchivedEventsHandler.class) {
            if (instance != null) return instance;
            instance = new SearchArchivedEventsHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void getArchLeftTreeList(HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
            ArrayList actionList = authObject.getUserActins();
            JsonResponse.getInstance().sendResponse(response, ArchReportManager.getInstance().fetchReportList(actionList).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getArchIndexFileListCount(HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject jRequestParams = new JSONObject(request.getParameter("requestParams"));
            Integer logCategoryId = null;
            Long fromTime = null;
            Long toTime = null;
            Integer loadType = null;
            if (jRequestParams.has("logCategoryId")) {
                logCategoryId = jRequestParams.getInt("logCategoryId");
            }
            if (jRequestParams.has("fromTime") && jRequestParams.has("toTime")) {
                fromTime = jRequestParams.getLong("fromTime");
                toTime = jRequestParams.getLong("toTime");
            }
            if (jRequestParams.has("loadType")) {
                loadType = jRequestParams.getInt("loadType");
            }
            JSONObject fileListCount = ArchFileIndexHandler.fetchArchFileListCount((Integer)logCategoryId, (Long)fromTime, toTime, (Integer)loadType);
            JsonResponse.getInstance().sendResponse(response, fileListCount.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getArchIndexFileList(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject jRequestParams = new JSONObject(request.getParameter("requestParams"));
            Integer logCategoryId = null;
            Long fromTime = null;
            Long toTime = null;
            String sortColumn = null;
            String sortOrder = null;
            Integer fromIndex = null;
            Integer range = null;
            Integer loadType = null;
            if (jRequestParams.has("logCategoryId")) {
                logCategoryId = jRequestParams.getInt("logCategoryId");
            }
            if (jRequestParams.has("fromTime") && jRequestParams.has("toTime")) {
                fromTime = jRequestParams.getLong("fromTime");
                toTime = jRequestParams.getLong("toTime");
            }
            if (jRequestParams.has("sortColumn")) {
                sortColumn = jRequestParams.getString("sortColumn");
            }
            if (jRequestParams.has("sortOrder")) {
                sortOrder = jRequestParams.getString("sortOrder");
            }
            if (jRequestParams.has("FROM_INDEX")) {
                fromIndex = jRequestParams.getInt("FROM_INDEX");
            }
            if (jRequestParams.has("RANGE")) {
                range = jRequestParams.getInt("RANGE");
            }
            if (jRequestParams.has("loadType")) {
                loadType = jRequestParams.getInt("loadType");
            }
            JSONObject jFileList = new JSONObject();
            JSONObject jFileListCount = ArchFileIndexHandler.fetchArchFileListCount((Integer)logCategoryId, (Long)fromTime, (Long)toTime, (Integer)loadType);
            jFileList = ArchFileIndexHandler.fetchArchFileList((Integer)logCategoryId, (Long)fromTime, (Long)toTime, (String)sortColumn, (String)sortOrder, (Integer)fromIndex, (Integer)range, (Integer)loadType);
            jFileList.put("archIndexFileCount", (Object)jFileListCount.getJSONObject("archIndexFileCount"));
            jFileList.put("totalCount", jFileListCount.getJSONObject("archIndexFileCount").getInt("archTotalFileCount"));
            jFileList.put("startValue", (Object)fromIndex);
            jFileList.put("rangeValue", (Object)range);
            JSONObject jEmberTable = ArchEmberUtil.getArchIndexFileTableData((JSONObject)jFileList, (AdventNetResourceBundle)rb);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Admin", rb.getString("adap.AuditReportAction.audit_entry.archive_file_list_viewed"), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.archive_file_list_viewed", "-"}));
            JsonResponse.getInstance().sendResponse(response, jEmberTable.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getArchFileMinMaxTime(HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject jRequestParams = new JSONObject(request.getParameter("requestParams"));
            int logCategoryId = 0;
            if (jRequestParams.has("logCategoryId")) {
                logCategoryId = Integer.parseInt(jRequestParams.getString("logCategoryId"));
            }
            JSONObject jo = ArchFileIndexHandler.fetchArchFileMinMaxTime((int)logCategoryId);
            JsonResponse.getInstance().sendResponse(response, jo.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getLogCategories(HttpServletRequest request, HttpServletResponse response) {
        try {
            String appendAllStr = request.getParameter("appendAll");
            boolean appendAll = false;
            if (appendAllStr != null) {
                appendAll = Boolean.parseBoolean(appendAllStr);
            }
            JSONArray jArr = ArchReportManager.getInstance().fetchArchLogCategories(appendAll);
            JsonResponse.getInstance().sendResponse(response, jArr.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void indexArchiveFiles(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject resultObj = new JSONObject();
            JSONObject indexFileList = new JSONObject(request.getParameter("indexFileList"));
            String resultStr = ArchFileIndexHandler.indexArchFiles((JSONObject)indexFileList, (AdventNetResourceBundle)rb);
            if (resultStr.isEmpty()) {
                resultObj.put("success", true);
                resultObj.put("text", (Object)rb.getString("adap.archive.indexing_scheduled"));
            } else {
                resultObj.put("failure", true);
                resultObj.put("text", (Object)resultStr);
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.AuditReportAction.audit_entry.index_archive_file"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.index_archive_file", "-"}));
            JsonResponse.getInstance().sendResponse(response, resultObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getArchIndexSettings(HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject resultObj = ArchFileIndexHandler.getArchIndexSettings();
            JsonResponse.getInstance().sendResponse(response, resultObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateArchIndexSettings(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject newSettingsObj = new JSONObject(request.getParameter("settings"));
            JSONObject resultObj = new JSONObject();
            resultObj = ArchFileIndexHandler.updateArchIndexSettings((JSONObject)newSettingsObj);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.AuditReportAction.audit_entry.changed_archive_index_setting"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.changed_archive_index_setting", "-"}));
            JsonResponse.getInstance().sendResponse(response, resultObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getGlobalSearchSummary(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject jRequestParams = new JSONObject(request.getParameter("requestParams"));
            JSONObject jResponse = new JSONObject();
            String searchQueryStr = null;
            Long fromTime = null;
            Long toTime = null;
            if (jRequestParams.has("fromTime") && jRequestParams.has("toTime")) {
                fromTime = jRequestParams.getLong("fromTime");
                toTime = jRequestParams.getLong("toTime");
            }
            if (jRequestParams.has("searchQueryStr")) {
                searchQueryStr = jRequestParams.getString("searchQueryStr");
            }
            if ((jResponse = ArchGlobalSearchHandler.fetchReportSummary((String)searchQueryStr, fromTime, toTime)) != null && !jResponse.has("failure")) {
                jResponse = ArchEmberUtil.parseGSResultsIntoCols((JSONObject)jResponse);
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Admin", rb.getString("adap.AuditReportAction.audit_entry.globally_searched_archive"), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.globally_searched_archive", "-"}));
            JsonResponse.getInstance().sendResponse(response, jResponse.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getReport(HttpServletRequest request, HttpServletResponse response) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        JSONObject jResponse = new JSONObject();
        int reportId = -1;
        try {
            JSONObject jRequestParams = new JSONObject(request.getParameter("requestParams"));
            Long fromTime = null;
            Long toTime = null;
            String searchQueryStr = null;
            JSONObject filterList = null;
            int reportFromIndex = -1;
            int reportToIndex = -1;
            boolean isGlobalSearchPage = false;
            Credential cred = AuthUtil.getUserCredential();
            Long loggedOnUserId = cred.getUserId();
            reportId = jRequestParams.getInt("reportId");
            if (jRequestParams.has("fromTime") && jRequestParams.has("toTime")) {
                fromTime = jRequestParams.getLong("fromTime");
                toTime = jRequestParams.getLong("toTime");
            }
            if (jRequestParams.has("searchQuery")) {
                searchQueryStr = jRequestParams.getString("searchQuery");
            }
            if (jRequestParams.has("facetList")) {
                filterList = jRequestParams.getJSONObject("facetList");
            }
            if (jRequestParams.has("reportFromIndex") && jRequestParams.has("reportToIndex")) {
                reportFromIndex = jRequestParams.getInt("reportFromIndex");
                reportToIndex = jRequestParams.getInt("reportToIndex");
            }
            if (jRequestParams.has("isGlobalSearchPage")) {
                isGlobalSearchPage = jRequestParams.getBoolean("isGlobalSearchPage");
            }
            if (isGlobalSearchPage) {
                jResponse = ArchGlobalSearchHandler.fetchReport((int)reportId, (JSONObject)filterList, (String)searchQueryStr, (int)reportFromIndex, (int)reportToIndex, (Long)fromTime, (Long)toTime, (Long)loggedOnUserId);
                if (!jResponse.has("failure")) {
                    jResponse = ArchEmberUtil.getArchReportTableData((JSONObject)jResponse, (AdventNetResourceBundle)rb);
                    jResponse.put("reportName", (Object)ArchReportManager.getInstance().getGSReportName(reportId));
                }
            } else {
                jResponse = ArchReportManager.getInstance().getReport(reportId, filterList, searchQueryStr, reportFromIndex, reportToIndex, fromTime, toTime, loggedOnUserId);
                if (!jResponse.has("failure")) {
                    jResponse = ArchEmberUtil.getArchReportTableData((JSONObject)jResponse, (AdventNetResourceBundle)rb);
                    jResponse.put("reportName", (Object)ArchReportManager.getInstance().getReportName(reportId));
                    jResponse.put("logCategoryId", ArchReportManager.getInstance().getReportArchCategoryId(reportId));
                }
            }
            jResponse.put("reportId", reportId);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Admin", rb.handleGetObject("adap.AuditReportAction.audit_entry.archive_report_viewed", new String[]{ArchReportManager.getInstance().getReportName(reportId)}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.archive_report_viewed", "-"}));
            JsonResponse.getInstance().sendResponse(response, jResponse.toString());
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                jResponse = new JSONObject();
                jResponse.put("failure", true);
                jResponse.put("text", (Object)rb.getString("adap.archive.report_fetch_error"));
                jResponse.put("reportId", reportId);
                JsonResponse.getInstance().sendResponse(response, jResponse.toString());
            }
            catch (Exception je) {
                je.printStackTrace();
            }
        }
    }

    public void getFacets(HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject jResponse = new JSONObject();
            JSONObject jFacetObj = new JSONObject();
            Long fromTime = null;
            Long toTime = null;
            String searchQueryStr = null;
            boolean isGlobalSearchPage = false;
            JSONObject jRequestParams = new JSONObject(request.getParameter("requestParams"));
            int reportId = jRequestParams.getInt("reportId");
            if (jRequestParams.has("fromTime") && jRequestParams.has("toTime")) {
                fromTime = jRequestParams.getLong("fromTime");
                toTime = jRequestParams.getLong("toTime");
            }
            if (jRequestParams.has("isGlobalSearchPage")) {
                isGlobalSearchPage = jRequestParams.getBoolean("isGlobalSearchPage");
            }
            if (jRequestParams.has("searchQuery")) {
                searchQueryStr = jRequestParams.getString("searchQuery");
            }
            if (!(jFacetObj = isGlobalSearchPage ? ArchGlobalSearchHandler.fetchFacets((int)reportId, (String)searchQueryStr, (Long)fromTime, (Long)toTime) : ArchReportManager.getInstance().getFacets(reportId, searchQueryStr, fromTime, toTime)).has("failure")) {
                jResponse.put("facetsInfo", (Object)jFacetObj);
                jResponse.put("searchQuery", (Object)searchQueryStr);
            } else {
                jResponse = jFacetObj;
            }
            jResponse.put("reportId", reportId);
            JsonResponse.getInstance().sendResponse(response, jResponse.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getReportMinMaxTime(HttpServletRequest request, HttpServletResponse response) {
        JSONObject jResponse = null;
        try {
            jResponse = new JSONObject();
            JSONObject jRequestParams = new JSONObject(request.getParameter("requestParams"));
            if (jRequestParams.has("reportId")) {
                int reportId = jRequestParams.getInt("reportId");
                ArchLogCategoryHandler handler = ArchReportManager.getInstance().getArchCategoryHandler(reportId);
                JSONObject jTimeRange = handler.getMinMaxTime();
                jResponse.put("startDate", jTimeRange.get("minTime"));
                jResponse.put("endDate", jTimeRange.get("maxTime"));
                jResponse.put("reportId", reportId);
            } else {
                logger.log(Level.SEVERE, "SearchArchivedEventsHandler.fetchReportMinMaxTime :: reportId null!!");
            }
            JsonResponse.getInstance().sendResponse(response, jResponse.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getSearchableFields(HttpServletRequest request, HttpServletResponse response) {
        JSONArray jFieldList = null;
        try {
            JSONObject jRequestParams = new JSONObject(request.getParameter("requestParams"));
            if (jRequestParams.has("reportId")) {
                int reportId = jRequestParams.getInt("reportId");
                jFieldList = ArchReportManager.getInstance().getSearchableFields(reportId);
            } else {
                logger.log(Level.SEVERE, "SearchArchivedEventsHandler.fetchSearchFields :: reportId null!!");
            }
            JsonResponse.getInstance().sendResponse(response, jFieldList.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getSearchBoxSuggestions(HttpServletRequest request, HttpServletResponse response) {
        try {
            String fieldsStr = request.getParameter("sugFields");
            String sugKey = request.getParameter("sugKey");
            int reportId = Integer.parseInt(request.getParameter("reportId"));
            String result = ArchReportManager.getInstance().getSuggestions(reportId, fieldsStr, sugKey).getString("suggestions").toString();
            JsonResponse.getInstance().sendResponse(response, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addOrRemoveTableCols(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject resultObj = new JSONObject();
            JSONObject jRequestParams = new JSONObject(request.getParameter("requestParams"));
            int tableId = jRequestParams.getInt("tableId");
            int reportId = jRequestParams.getInt("reportId");
            JSONArray jSelColIds = jRequestParams.getJSONArray("selColIds");
            Credential cred = AuthUtil.getUserCredential();
            Long loggedOnUserId = cred.getUserId();
            if (ArchReportManager.getInstance().updateTableColumnList(loggedOnUserId, tableId, jSelColIds)) {
                resultObj.put("success", true);
                resultObj.put("text", (Object)rb.getString("adap.archive.table_columns_success"));
            } else {
                resultObj.put("failure", true);
                resultObj.put("text", (Object)rb.getString("adap.archive.table_columns_error"));
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.AuditReportAction.audit_entry.changed_archive_table_column", new String[]{ArchReportManager.getInstance().getReportName(reportId)}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.changed_archive_table_column", "-"}));
            JsonResponse.getInstance().sendResponse(response, resultObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

