/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.admin;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportParamsAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.common.EmberTableConfig;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.APIUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.TechnicianHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.ADAPUserActionsHandler;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDUtil;
import com.adventnet.sym.adsm.common.server.admin.delegation.TechnicianAuditHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class TechnicianConfigurationHandler {
    private static Logger logger = Logger.getLogger(TechnicianHandler.class.getName());
    private static volatile TechnicianConfigurationHandler instance = null;
    private static JSONObject exportData;
    private static Object exportLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TechnicianConfigurationHandler getInstance() {
        if (instance != null) return instance;
        Class<TechnicianConfigurationHandler> clazz = TechnicianConfigurationHandler.class;
        synchronized (TechnicianConfigurationHandler.class) {
            if (instance != null) return instance;
            instance = new TechnicianConfigurationHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyTechnician(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject responseJson;
        block26: {
            responseJson = new JSONObject();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            try {
                String action;
                JSONObject jsonObj = new JSONObject();
                if (request.getParameter("params") != null) {
                    jsonObj = new JSONObject(request.getParameter("params"));
                }
                if ((action = jsonObj.optString("action")) == "") break block26;
                String messageType = "success";
                String message = "";
                Long userId = null;
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                if (!action.equalsIgnoreCase("create")) {
                    userId = Long.parseLong(jsonObj.getString("userId"));
                }
                String samAccountName = null;
                try {
                    String userName;
                    if (action.equalsIgnoreCase("create")) {
                        String domainFlatName;
                        String name = jsonObj.getString("loginName");
                        String objectClass = jsonObj.getString("objectClass") != null ? jsonObj.getString("objectClass") : "";
                        samAccountName = name;
                        props.put("samAccountName", samAccountName);
                        String defaultNamingContext = jsonObj.getString("domainName");
                        if (!defaultNamingContext.equalsIgnoreCase("ADAP Authentication")) {
                            String domainName = DomainDetailsAPI.getDNCDomainName((String)defaultNamingContext);
                            logger.log(Level.INFO, "domain name in TechnicianConfiguration is :" + domainName);
                            Row row = DirectoryObjectAPI.getInstance().getObjectRow(domainName, name, "OBJECT_GUID", objectClass);
                            logger.log(Level.FINE, "row is " + row);
                            if (row != null) {
                                samAccountName = objectClass.equalsIgnoreCase("user") ? (String)row.get("SAM_ACCOUNT_NAME") : (String)row.get("NAME");
                            }
                            logger.log(Level.INFO, "samAccountName is " + samAccountName);
                            props.put("samAccountName", samAccountName);
                            logger.log(Level.INFO, "props is " + props);
                            if (objectClass != null && !objectClass.equalsIgnoreCase("user")) {
                                samAccountName = name;
                            }
                            logger.log(Level.INFO, "samAccountName is " + samAccountName);
                        }
                        if (!(domainFlatName = defaultNamingContext).equalsIgnoreCase("ADAP Authentication")) {
                            domainFlatName = DomainDetailsAPI.getDnFlatName((String)defaultNamingContext);
                            message = (String)rb.handleGetObject("adap.TechnicianConfiguration.Successfully_assigned_the_user");
                        } else {
                            message = (String)rb.handleGetObject("adap.TechnicianConfiguration.Successfully_created_and_assigned_the");
                        }
                        String delegatedDomain = TechnicianHandler.getDelegatedDomain((String)jsonObj.getString("delegatedDomain"), (AdventNetResourceBundle)rb);
                        userId = TechnicianHandler.createUser((String)domainFlatName, (String)samAccountName, (String)jsonObj.getString("password"), (Long)jsonObj.getLong("roleId"), (String)objectClass, (String)delegatedDomain);
                        props.put("objectClass", objectClass);
                        props.put("roleId", jsonObj.getLong("roleId"));
                        if (!domainFlatName.equalsIgnoreCase("ADAP Authentication")) {
                            props.put("domainFlatName", domainFlatName);
                        } else {
                            props.put("domainFlatName", (String)rb.handleGetObject("adap.TechnicianConfiguration.ADAuditPlus_Authentication"));
                        }
                        String roleName = TDHandler.getRoleName((Long)jsonObj.getLong("roleId"));
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Admin", rb.handleGetObject("adap.TechnicianConfiguration.audit_entry.tech_added", new String[]{TDHandler.getUserName((Long)userId, (String)objectClass), rb.getString(roleName)}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.tech_added", "-"}));
                    } else if (action.equalsIgnoreCase("changeRole")) {
                        Long roleId = jsonObj.getLong("roleId");
                        String delegatedDomain = TechnicianHandler.getDelegatedDomain((String)jsonObj.getString("delegatedDomain"), (AdventNetResourceBundle)rb);
                        TechnicianHandler.updateUser((Long)userId, (Long)roleId, (String)jsonObj.getString("objectClass"), (String)delegatedDomain);
                        message = (String)rb.handleGetObject("adap.TechnicianConfiguration.Successfully_updated_the_role");
                        String roleName = TDHandler.getRoleName((Long)roleId);
                        String userName2 = TDHandler.getUserName((Long)userId, (String)jsonObj.getString("objectClass"));
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.TechnicianConfiguration.audit_entry.tech_role_changed", new String[]{roleName, userName2}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.tech_role_changed", "-"}));
                    } else if (action.equalsIgnoreCase("changePassword")) {
                        TechnicianHandler.changePassword((Long)userId, (String)jsonObj.getString("password"));
                        message = (String)rb.handleGetObject("adap.TechnicianConfiguration.Successfully_updated_the_password");
                        userName = TDHandler.getUserName((Long)userId, (String)"user");
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.TechnicianConfiguration.audit_entry.tech_pwd_changed", new String[]{userName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.tech_password_changed", "-"}));
                    } else if (action.equalsIgnoreCase("delete")) {
                        userName = TDHandler.getUserName((Long)userId, (String)jsonObj.getString("objectClass"));
                        TechnicianHandler.deleteUser((Long)userId, (String)jsonObj.getString("objectClass"));
                        message = (String)rb.handleGetObject("adap.TechnicianConfiguration.Successfully_deleted_the_user");
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Admin", rb.handleGetObject("adap.TechnicianConfiguration.audit_entry.tech_deleted", new String[]{userName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.tech_deleted", "-"}));
                    } else if (action.equalsIgnoreCase("search")) {
                        String searchString = jsonObj.getString("SEARCH_STRING");
                    }
                    props.put("objectClass", jsonObj.getString("objectClass"));
                    props.put("userId", userId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    messageType = (String)rb.handleGetObject("adap.TechnicianConfiguration.error");
                    message = e.getMessage();
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.TechnicianConfiguration.audit_entry.problem_while_changing", new String[]{message}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.problem_while_updating_technician", rb.handleGetObject("adap.TechnicianConfiguration.Name_of_technician", new String[]{samAccountName})}));
                }
                responseJson.put("message", (Object)message);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            finally {
                ArrayList list = TechnicianHandler.getUsers();
                JSONObject ret = EmberTableConfig.getInstance().getEmberTableData("16027", list, new JSONObject(), rb);
                responseJson.put("technicianListTableData", (Object)ret.getJSONObject("tableData"));
                JSONObject tableInputParams = new JSONObject();
                tableInputParams = ret.getJSONObject("tableInputParams");
                tableInputParams.put("isSearch", true);
                responseJson.put("technicianListTableInputParams", (Object)tableInputParams);
                ArrayList domainList = DomainHandler.getConfiguredList((Long)new Long(1L));
                Iterator it = TechnicianHandler.getRoles();
                JSONArray configuredRoles = new JSONArray();
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    JSONObject roleObj = new JSONObject();
                    roleObj.put("value", (Object)((Long)r.get("ROLE_ID")));
                    roleObj.put("name", (Object)rb.getString((String)r.get("NAME")));
                    configuredRoles.put((Object)roleObj);
                }
                HttpSession session = request.getSession();
                ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
                Integer accessType = AdminHandler.getAccessType((String)"TechniciansSettings", (ADAPAuthObject)authObj);
                responseJson.put("domainList", (Object)APIUtil.getInstance().listToJSONArray(domainList));
                responseJson.put("configuredRoles", (Object)configuredRoles);
                responseJson.put("accessType", (Object)accessType);
                Credential cred = AuthUtil.getUserCredential();
                Long loggedOnUserId = cred.getUserId();
                responseJson.put("loginUserId", (Object)loggedOnUserId);
            }
        }
        JsonResponse.getInstance().sendResponse(response, responseJson.toString());
    }

    public void viewTechnicians(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        JSONObject responseJson = new JSONObject();
        ArrayList list = TechnicianHandler.getUsers();
        JSONObject ret = EmberTableConfig.getInstance().getEmberTableData("16027", list, new JSONObject(), rb);
        responseJson.put("technicianListTableData", (Object)ret.getJSONObject("tableData"));
        JSONObject tableInputParams = new JSONObject();
        tableInputParams = ret.getJSONObject("tableInputParams");
        tableInputParams.put("isSearch", true);
        responseJson.put("technicianListTableInputParams", (Object)tableInputParams);
        ArrayList domainList = DomainHandler.getConfiguredList((Long)new Long(1L));
        Iterator it = TechnicianHandler.getRoles();
        JSONArray configuredRoles = new JSONArray();
        while (it.hasNext()) {
            Row r = (Row)it.next();
            JSONObject roleObj = new JSONObject();
            roleObj.put("value", (Object)((Long)r.get("ROLE_ID")));
            roleObj.put("name", (Object)rb.getString((String)r.get("NAME")));
            configuredRoles.put((Object)roleObj);
        }
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"TechniciansSettings", (ADAPAuthObject)authObj);
        responseJson.put("domainList", (Object)APIUtil.getInstance().listToJSONArray(domainList));
        responseJson.put("configuredRoles", (Object)configuredRoles);
        responseJson.put("accessType", (Object)accessType);
        Credential cred = AuthUtil.getUserCredential();
        Long loggedOnUserId = cred.getUserId();
        responseJson.put("loginUserId", (Object)loggedOnUserId);
        JsonResponse.getInstance().sendResponse(response, responseJson.toString());
    }

    public void createRole(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        JSONObject responseJson = new JSONObject();
        try {
            JSONObject jsonObj = new JSONObject(request.getParameter("params"));
            String action = jsonObj.getString("action");
            if (action.equals("create")) {
                ArrayList roleActionsList = ADAPUserActionsHandler.getActionDetails((HttpServletRequest)request);
                JSONArray roleActionsArray = APIUtil.getInstance().listToJSONArray(roleActionsList);
                responseJson.put("roleActionsList", (Object)this.insertParentIds(roleActionsArray, "0"));
            } else if (action.equals("save")) {
                String roleName = jsonObj.getString("roleName");
                String description = jsonObj.getString("roleDescription");
                String selectedActions = jsonObj.getString("selectedActions");
                String message = TDUtil.createRole((String)roleName, (String)description, (String)selectedActions);
                responseJson.put("message", (Object)rb.getString(message));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Admin", rb.handleGetObject("adap.TechnicianRolesConfig.audit_entry.tech_role_created", new String[]{roleName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.tech_role_created", "-"}));
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Admin", rb.handleGetObject("adap.TechnicianRolesConfig.audit_entry.problem_created_tech_role", new String[]{ee.getMessage()}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.tech_role_created", "-"}));
        }
        JsonResponse.getInstance().sendResponse(response, responseJson.toString());
    }

    public void modifyRole(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        JSONObject responseJson = new JSONObject();
        try {
            JSONObject jsonObj = new JSONObject(request.getParameter("params"));
            String action = jsonObj.getString("action");
            Long roleId = Long.parseLong(jsonObj.getString("roleId"));
            boolean makeCheckboxDisable = false;
            if (action.equals("modify")) {
                ArrayList roleActionsList = ADAPUserActionsHandler.getActionDetails((HttpServletRequest)request);
                JSONArray roleActionsArray = APIUtil.getInstance().listToJSONArray(roleActionsList);
                JSONObject roleDetails = ADAPUserActionsHandler.getRoleDetails((Long)roleId);
                responseJson.put("roleDetails", (Object)roleDetails);
                String selectedActions = roleDetails.getString("selectedActions");
                if (roleId == 1L || roleId == 2L) {
                    makeCheckboxDisable = true;
                }
                HashMap<Object, Object> selectedActionsMap = new HashMap<Object, Object>();
                JSONArray newRoleActionsList = new JSONArray();
                String[] selectedActionsArray = selectedActions.split(",");
                for (int i = 0; i < selectedActionsArray.length; ++i) {
                    String[] actionVsAccess = selectedActionsArray[i].split("::");
                    selectedActionsMap.put(actionVsAccess[0], actionVsAccess[1]);
                }
                newRoleActionsList = this.insertCheckValues(roleActionsArray, selectedActionsMap, makeCheckboxDisable, "0");
                responseJson.put("roleActionsList", (Object)newRoleActionsList);
                responseJson.put("selectedActionsObj", (Object)APIUtil.getInstance().mapToJSONObject(selectedActionsMap));
            } else if (action.equals("update")) {
                String message = TDUtil.updateRole((Long)roleId, (String)jsonObj.getString("roleName"), (String)jsonObj.getString("description"), (String)jsonObj.getString("selectedActions"));
                ArrayList rolesList = TDUtil.getTDRolesDetails((AdventNetResourceBundle)rb, (String)request.getParameter("searchStr"));
                responseJson.put("message", (Object)rb.getString(message));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.TechnicianRolesConfig.audit_entry.tech_role_modified", new String[]{jsonObj.getString("roleName")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.tech_role_modified", "-"}));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.TechnicianRolesConfig.audit_entry.problem_updated_tech_role", new String[]{ex.getMessage()}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.tech_role_modified", "-"}));
        }
        JsonResponse.getInstance().sendResponse(response, responseJson.toString());
    }

    private JSONArray insertParentIds(JSONArray roleActionsArray, String parentId) {
        JSONArray newRoleActionsList = new JSONArray();
        try {
            for (int i = 0; i < roleActionsArray.length(); ++i) {
                JSONObject roleObj = roleActionsArray.getJSONObject(i);
                String currentId = parentId.equals("0") ? roleObj.getString("ACTION_ID") : parentId + "," + roleObj.getString("ACTION_ID");
                roleObj.put("parentIds", (Object)parentId);
                if (roleObj.has("CHILD_LIST")) {
                    roleObj.put("CHILD_LIST", (Object)this.insertParentIds(roleObj.getJSONArray("CHILD_LIST"), currentId));
                }
                newRoleActionsList.put((Object)roleObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newRoleActionsList;
    }

    private JSONArray insertCheckValues(JSONArray roleActionsArray, HashMap selectedActionsMap, boolean makeCheckboxDisable, String parentId) {
        JSONArray newRoleActionsList = new JSONArray();
        try {
            for (int i = 0; i < roleActionsArray.length(); ++i) {
                JSONObject roleObj = roleActionsArray.getJSONObject(i);
                String value = (String)selectedActionsMap.get(roleObj.getString("ACTION_ID"));
                String currentId = parentId.equals("0") ? roleObj.getString("ACTION_ID") : parentId + "," + roleObj.getString("ACTION_ID");
                roleObj.put("parentIds", (Object)parentId);
                roleObj.put("disabled", makeCheckboxDisable);
                if (value != null) {
                    if (value.equals("32")) {
                        roleObj.put("checked", true);
                        roleObj.put("readChecked", false);
                    } else if (value.equals("1")) {
                        roleObj.put("checked", false);
                        roleObj.put("readChecked", true);
                    }
                }
                if (roleObj.has("CHILD_LIST")) {
                    roleObj.put("CHILD_LIST", (Object)this.insertCheckValues(roleObj.getJSONArray("CHILD_LIST"), selectedActionsMap, makeCheckboxDisable, currentId));
                }
                newRoleActionsList.put((Object)roleObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newRoleActionsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyRole(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = "";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        JSONObject responseJson = new JSONObject();
        try {
            JSONObject jsonObj = new JSONObject(request.getParameter("params"));
            Long roleId = Long.parseLong(jsonObj.getString("roleId"));
            message = TDUtil.copyRole((Long)roleId, (String)jsonObj.getString("roleName"), (String)jsonObj.getString("description"));
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.TechnicianRolesConfig.audit_entry.tech_role_copied", new String[]{jsonObj.getString("roleName")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.tech_role_copied", "-"}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = "adap.TechnicianRolesConfig.Some_Problem_While_copying_role";
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.TechnicianRolesConfig.audit_entry.proble_role_copied", new String[]{ex.getMessage()}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.tech_role_copied", "-"}));
        }
        finally {
            responseJson.put("message", (Object)rb.getString(message));
            responseJson.put("rolesList", (Object)TDUtil.getTDRolesDetails((AdventNetResourceBundle)rb, null));
        }
        JsonResponse.getInstance().sendResponse(response, responseJson.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRole(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String message = "";
        JSONObject responseJson = new JSONObject();
        try {
            Long roleId = Long.parseLong(request.getParameter("roleId"));
            String roleName = TDHandler.getRoleName((Long)roleId);
            message = TDUtil.deleteRole((Long)roleId);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Admin", rb.handleGetObject("adap.TechnicianRolesConfig.audit_entry.tech_role_deleted", new String[]{roleName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.tech_role_deleted", "-"}));
        }
        catch (Exception ex) {
            message = "adap.TechnicianRoleConfig.Problem_While_deleting_Role";
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Admin", rb.handleGetObject("adap.TechnicianRolesConfig.audit_entry.problem_deleting_role", new String[]{ex.getMessage()}), 8, rb, 16, "adap.ADAPUserAuditSeverities.audit_name.tech_role_deleted", "-"}));
            ex.printStackTrace();
        }
        finally {
            responseJson.put("message", (Object)rb.getString(message));
            responseJson.put("rolesList", (Object)TDUtil.getTDRolesDetails((AdventNetResourceBundle)rb, null));
        }
        JsonResponse.getInstance().sendResponse(response, responseJson.toString());
    }

    public void viewTechnicianRoles(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject responseJson = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            ArrayList rolesList = TDUtil.getTDRolesDetails((AdventNetResourceBundle)rb, (String)request.getParameter("searchStr"));
            JSONObject ret = EmberTableConfig.getInstance().getEmberTableData("16028", rolesList, new JSONObject(), rb);
            responseJson.put("roleListTableData", (Object)ret.getJSONObject("tableData"));
            JSONObject tableInputParams = new JSONObject();
            tableInputParams = ret.getJSONObject("tableInputParams");
            tableInputParams.put("isSearch", true);
            responseJson.put("roleListTableInputParams", (Object)tableInputParams);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Admin", rb.getString("adap.ViewTechnicianRoles.audit_entry.Tech_role_viewed"), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.tech_role_Viewed", "-"}));
        }
        catch (Exception ee) {
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Admin", rb.getString("adap.ViewTechnicianRoles.audit_entry.Problem_Tech_role_viewed"), 4, 16, "adap.ADAPUserAuditSeverities.audit_name.tech_role_Viewed", ee.getMessage()}));
            ee.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, responseJson.toString());
    }

    public void report(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject responseJson = new JSONObject();
        Object resultantRows = null;
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject jsonObj = new JSONObject(request.getParameter("params"));
            JSONObject tableInputParams = new JSONObject();
            String loginName = jsonObj.getString("LOGIN_NAME");
            String objectClass = jsonObj.getString("OBJECT_CLASS");
            String searchCriteria = TechnicianAuditHandler.formSearchCriteria((String)jsonObj.getString("SEARCH_STRING"));
            searchCriteria = TechnicianAuditHandler.addActionInCriteria((String)searchCriteria, (String)jsonObj.getString("ACTION"));
            String inputDays = jsonObj.getString("TIME_PERIOD");
            HashMap<String, String> inputParams = new HashMap<String, String>();
            inputParams.put("inputDays", inputDays);
            if (inputDays.equals("customPeriod")) {
                inputParams.put("startTime", jsonObj.getString("START_TIME"));
                inputParams.put("startHour", jsonObj.getString("START_HOUR"));
                inputParams.put("endTime", jsonObj.getString("END_TIME"));
                inputParams.put("endHour", jsonObj.getString("END_HOUR"));
            }
            HashMap inputParamsMap = AuditReportParamsAPI.getInputParamsValues(inputParams, null);
            inputParamsMap.put("userId", TechnicianAuditHandler.getUserId((Long)jsonObj.getLong("USER_ID"), (String)jsonObj.getString("OBJECT_CLASS")));
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Admin", rb.handleGetObject("adap.TechnicianRolesConfig.audit_entry.technician_audit_log_was_generated_for_user", new String[]{loginName}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.tech_report_viewed", "-"}));
            int count = TechnicianAuditHandler.getAuditRowsCount((String)searchCriteria, (HashMap)inputParamsMap);
            ArrayList auditList = new ArrayList();
            if (count > 0) {
                auditList = TechnicianAuditHandler.getAuditRowsList((String)searchCriteria, (HashMap)inputParamsMap, (int)jsonObj.getInt("START_INDEX"), (int)jsonObj.getInt("LIMIT"), (int)count, (Boolean)true);
                responseJson.put("COLUMNS_LIST", (Object)this.changeColumnListToEmberFormat(APIUtil.getInstance().listToJSONArray(TechnicianAuditHandler.getVisibleColumns()), request));
                JSONObject availableColumnList = new JSONObject();
                availableColumnList = APIUtil.getInstance().mapToJSONObject(TechnicianAuditHandler.getCustomVisibleList());
                availableColumnList.put("nonVisibleList", (Object)this.changeColumnListToEmberFormat(availableColumnList.getJSONArray("nonVisibleList"), request));
                availableColumnList.put("visibleList", (Object)this.changeColumnListToEmberFormat(availableColumnList.getJSONArray("visibleList"), request));
                responseJson.put("AVAILABLE_COLUMNS_LIST", (Object)availableColumnList);
                tableInputParams.put("startValue", jsonObj.getInt("START_INDEX"));
            }
            tableInputParams.put("totalCount", count);
            JSONArray rangeList = new JSONArray();
            for (int i = 0; i < 4; ++i) {
                JSONObject rangeItem = new JSONObject();
                rangeItem.put("value", (i + 1) * 25);
                rangeList.put((Object)rangeItem);
            }
            tableInputParams.put("rangeList", (Object)rangeList);
            tableInputParams.put("rangeValue", jsonObj.getInt("LIMIT"));
            tableInputParams.put("showSearch", true);
            tableInputParams.put("showSearchMethod", (Object)"searchAction");
            tableInputParams.put("showSearchTooltip", (Object)"Search");
            tableInputParams.put("showAddOrRemove", true);
            if (!jsonObj.getString("SEARCH_STRING").equals("-")) {
                tableInputParams.put("isSearch", true);
                tableInputParams.put("searchData", (Object)jsonObj.getJSONObject("searchData"));
            }
            tableInputParams.put("emptyTableMessage", (Object)"No Data Available");
            responseJson.put("tableInputParams", (Object)tableInputParams);
            responseJson.put("ROWS_LIST", (Object)this.changeNumericKeysToValues(auditList, rb));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, responseJson.toString());
    }

    private JSONArray changeNumericKeysToValues(ArrayList auditList, AdventNetResourceBundle rb) {
        JSONArray auditArray = new JSONArray();
        try {
            auditArray = APIUtil.getInstance().listToJSONArray(auditList);
            for (int i = 0; i < auditArray.length(); ++i) {
                JSONObject rowObject = auditArray.getJSONObject(i);
                JSONArray columnValues = rowObject.getJSONArray("columnValues");
                for (int j = 0; j < columnValues.length(); ++j) {
                    JSONObject columnObject = columnValues.getJSONObject(j);
                    if (columnObject.getString("columnalias").equals("ACCESS_TYPE")) {
                        columnObject.put("columnValue", (Object)TDUtil.getAccessTypeText((int)columnObject.getInt("columnValue"), (AdventNetResourceBundle)rb));
                        continue;
                    }
                    if (columnObject.getString("columnalias").equals("EVENT_TYPE")) {
                        columnObject.put("columnValue", (Object)TDUtil.getEventTypeText((int)columnObject.getInt("columnValue"), (AdventNetResourceBundle)rb));
                        continue;
                    }
                    if (!columnObject.getString("columnalias").equals("SEVERITY")) continue;
                    if (columnObject.getInt("columnValue") == 1) {
                        columnObject.put("columnValue", (Object)rb.getString("adap.common.text.attention"));
                        continue;
                    }
                    if (columnObject.getInt("columnValue") == 2) {
                        columnObject.put("columnValue", (Object)rb.getString("adap.common.text.trouble"));
                        continue;
                    }
                    columnObject.put("columnValue", (Object)rb.getString("adap.common.text.critical"));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return auditArray;
    }

    private JSONArray changeColumnListToEmberFormat(JSONArray columnList, HttpServletRequest request) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        JSONArray changedColumnList = new JSONArray();
        try {
            for (int i = 0; i < columnList.length(); ++i) {
                JSONObject columnObject = columnList.getJSONObject(i);
                JSONObject changedColumn = new JSONObject();
                Iterator keys = columnObject.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    if (key.equalsIgnoreCase("displayname")) {
                        changedColumn.put(key.toLowerCase(), (Object)rb.getString(columnObject.get(key).toString()));
                        continue;
                    }
                    changedColumn.put(key.toLowerCase(), columnObject.get(key));
                }
                changedColumnList.put((Object)changedColumn);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return changedColumnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject jsonObj = null;
            Object object = exportLock;
            synchronized (object) {
                jsonObj = exportData;
                exportData = null;
            }
            String loginName = jsonObj.getString("LOGIN_NAME");
            String objectClass = jsonObj.getString("OBJECT_CLASS");
            String action = jsonObj.getString("ACTION");
            String searchString = jsonObj.getString("SEARCH_STRING");
            String searchCriteria = TechnicianAuditHandler.formSearchCriteria((String)searchString);
            searchCriteria = TechnicianAuditHandler.addActionInCriteria((String)searchCriteria, (String)action);
            String inputDays = jsonObj.getString("TIME_PERIOD");
            HashMap<String, String> inputParams = new HashMap<String, String>();
            inputParams.put("inputDays", inputDays);
            if (inputDays.equals("customPeriod")) {
                inputParams.put("startTime", jsonObj.getString("START_TIME"));
                inputParams.put("startHour", jsonObj.getString("START_HOUR"));
                inputParams.put("endTime", jsonObj.getString("END_TIME"));
                inputParams.put("endHour", jsonObj.getString("END_HOUR"));
            }
            HashMap inputParamsMap = AuditReportParamsAPI.getInputParamsValues(inputParams, null);
            inputParamsMap.put("DOMAIN_NAME", TDHandler.getDomainName((Long)Long.parseLong(jsonObj.getString("USER_ID")), (String)jsonObj.getString("OBJECT_CLASS")));
            inputParamsMap.put("userId", TechnicianAuditHandler.getUserId((Long)jsonObj.getLong("USER_ID"), (String)jsonObj.getString("OBJECT_CLASS")));
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Admin", rb.handleGetObject("adap.TechnicianRolesConfig.audit_entry.technician_audit_log_was_exported_for_user", new String[]{loginName}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.tech_report_viewed", "-"}));
            TechnicianAuditHandler.exportReport((HashMap)inputParamsMap, (String)searchCriteria, (String)loginName, (String)jsonObj.getString("EXPORT_TYPE"), (HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExportData(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject reportReqData = new JSONObject(request.getParameter("params"));
        Object object = exportLock;
        synchronized (object) {
            exportData = reportReqData;
        }
        JSONObject responseJson = new JSONObject();
        responseJson.put("exportStatus", (Object)"sucess");
        JsonResponse.getInstance().sendResponse(response, responseJson.toString());
    }

    public void resetColumns(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            JSONObject jsonObj = new JSONObject(request.getParameter("params"));
            Boolean status = TechnicianAuditHandler.resetColumns((Long[])ReportUtil.jsonArrayToLongArray((JSONArray)jsonObj.getJSONArray("VISIBLE_COLUMNS")));
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.TechnicianRolesConfig.audit_entry.technician_audit_column_reset_successfully", new String[]{jsonObj.getString("LOGIN_NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.tech_report_viewed", "-"}));
            JSONObject responseJson = new JSONObject();
            responseJson.put("status", (Object)status);
            JsonResponse.getInstance().sendResponse(response, responseJson.toString());
        }
        catch (Exception ex) {
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL")}));
            ex.printStackTrace();
        }
    }

    static {
        exportLock = new Object();
    }
}

