/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.admin.domainsettings;

import com.adventnet.sym.adsm.auditing.server.delegation.AuditDelegationHandler;
import com.adventnet.sym.adsm.auditing.server.delegation.GpoHandler;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONObject;

public class DomainPolicyHandler
extends DispatchAction {
    private static Logger logger = Logger.getLogger("DelegLogger");
    private static volatile DomainPolicyHandler instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DomainPolicyHandler getInstance() {
        if (instance != null) return instance;
        Class<DomainPolicyHandler> clazz = DomainPolicyHandler.class;
        synchronized (DomainPolicyHandler.class) {
            if (instance != null) return instance;
            instance = new DomainPolicyHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private DomainPolicyHandler() {
    }

    public void setAuditPolicy(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String message = "";
        String gpoStatus = "";
        String policyInput = request.getParameter("policyInput");
        JSONObject policyInputObj = new JSONObject(policyInput);
        JSONObject resultantPolicyStatus = new JSONObject();
        resultantPolicyStatus.put("IsPolicy", true);
        String domainName = policyInputObj.getString("DomainName");
        try {
            String gpoGUIDString = policyInputObj.getString("gpoGuids");
            logger.log(Level.INFO, "gpoGuids is" + gpoGUIDString);
            PolicyHandler phandler = new PolicyHandler();
            StringTokenizer guidTokenizer = new StringTokenizer(gpoGUIDString, ",");
            while (guidTokenizer.hasMoreTokens()) {
                String gpoGuid = guidTokenizer.nextToken();
                if (gpoGuid.equalsIgnoreCase("{6AC1786C-016F-11D2-945F-00C04fB984F9}")) {
                    phandler.writeAuditPolicy(domainName, gpoGuid);
                    PolicyHandler.addAuditPolicy((String)domainName, (String)gpoGuid);
                    message = rb.getString("adap.DomainPolicy.Successfully_configured_audit_policies");
                    resultantPolicyStatus.put("status", (Object)"info");
                    continue;
                }
                if (!gpoGuid.equalsIgnoreCase("{31B2F340-016D-11D2-945F-00C04FB984F9}")) continue;
                message = gpoStatus = GpoHandler.reConfigureGpo((String)domainName, (Integer)4);
                resultantPolicyStatus.put("status", (Object)"info");
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", message + "\n " + rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.audit_pol_set", "-"}));
        }
        catch (Exception e) {
            message = e.getMessage();
            resultantPolicyStatus.put("DomainPolicyError", (Object)message);
            resultantPolicyStatus.put("status", (Object)"failure");
            e.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", message + "\n " + rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.audit_pol_set", "-"}));
        }
        resultantPolicyStatus.put("DomainPolicyError", (Object)message);
        JsonResponse.getInstance().sendResponse(response, resultantPolicyStatus.toString());
    }

    public ActionForward setSystemACL(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String message = "";
        String gpoStatus = "";
        request.setAttribute("IsPolicy", (Object)false);
        String domainName = request.getParameter("DomainName");
        try {
            AuditDelegationHandler delegationHandler = new AuditDelegationHandler(domainName);
            delegationHandler.setSystemACLForDS();
            message = rb.getString("adap.DomainPolicy.Successfully_configured_systemACL");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", message + "\n " + rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.set_SACL", "-"}));
            request.setAttribute("Status_image", (Object)"images/info_icon1.gif");
        }
        catch (Exception e) {
            message = e.getMessage();
            if (message.toLowerCase().contains("error while setting object level ad auditing:access is denied - error code:0")) {
                message = rb.getString("adap.domainpolicy.Error_While_Setting_Object_Level_Ad_Access_Denied");
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", message + "\n " + rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.set_SACL", "-"}));
            request.setAttribute("DomainPolicyError", (Object)message);
            request.setAttribute("Status_image", (Object)"images/error_icon.gif");
            e.printStackTrace();
            return mapping.findForward("DomainPolicyWriteError");
        }
        request.setAttribute("DomainPolicyError", (Object)message);
        return mapping.findForward("DomainPolicyWriteError");
    }

    public ActionForward setWSAuditPolicy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = "";
        request.setAttribute("IsPolicy", (Object)true);
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String domainName = request.getParameter("DomainName");
        try {
            String gpoGUIDString = request.getParameter("gpoGuids");
            logger.log(Level.INFO, "gpoGuids is" + gpoGUIDString);
            message = GpoHandler.reConfigureGpo((String)domainName, (Integer)4096);
            request.setAttribute("Status_image", (Object)"images/info_icon1.gif");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", message + "\n " + rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.set_ws_SACL", "-"}));
        }
        catch (Exception e) {
            message = e.getMessage();
            request.setAttribute("DomainPolicyError", (Object)message);
            request.setAttribute("Status_image", (Object)"images/error_icon.gif");
            e.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", message + "\n " + rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.set_ws_SACL", "-"}));
            return mapping.findForward("DomainPolicyWriteError");
        }
        request.setAttribute("DomainPolicyError", (Object)message);
        return mapping.findForward("DomainPolicyWriteError");
    }
}

