/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.common;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.alert.AlertProfileAPI;
import com.adventnet.sym.adsm.auditing.server.config.GlobalExcludeConfig;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.JSONUtil;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EmberTableConfig {
    static final String TABLE_COLUMNCONFIG = "AUDColumnConfiguration";
    static final String TABLE_TABLEVIEW = "AUDTableViewConfig";
    static final String TABLE_EMBERACTIONSLIST = "EmberTableActionsList";
    static final String TABLE_EMBERACTIONSMAPPING = "EmberTableActionsMapping";
    static final String TABLE_AUDEVENTREAD = "AUDComputerEventRead";
    static final String COLUMN_CVID = "CV_ID";
    static final String COLUMN_COLINDEX = "COLUMNINDEX";
    static final String COLUMN_TABLE_ID = "TABLE_ID";
    static final String COLUMN_ACTION_ID = "ACTION_ID";
    static final String COLUMN_ACTION_TYPE = "ACTION_TYPE";
    static final String COLUMN_ACTION_NAME = "ACTION_NAME";
    static final String COLUMN_METHOD_VALUE = "METHOD_VALUE";
    static final String COLUMN_TOOLTIP_VALUE = "TOOLTIP_VALUE";
    static final String COLUMN_METHOD_NAME = "METHOD_NAME";
    static final String COLUMN_TOOLTIP_NAME = "TOOLTIP_NAME";
    static final String COLUMN_DEF_METHOD_VALUE = "DEFAULT_METHOD_VALUE";
    static final String COLUMN_DEF_TOOLTIP_VALUE = "DEFAULT_TOOLTIP_VALUE";
    static final String COLUMN_TABLEVIEWID = "TABLE_VIEW_ID";
    static final String COLUMN_SORTORDER = "SORTORDER";
    static final String COLUMN_SORTCOLUMN = "SORTCOLUMN";
    static final String COLUMN_PAGELENGTH = "PAGELENGTH";
    static final String COLUMN_EMPTYTABLEMESSAGE = "EMPTY_TABLE_MESSAGE";
    static final String COLUMN_OBJECT_GUID = "OBJECT_GUID";
    static HashMap actionsList = null;
    public static volatile EmberTableConfig emberTableConfig = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EmberTableConfig getInstance() {
        if (emberTableConfig != null) return emberTableConfig;
        Class<EmberTableConfig> clazz = EmberTableConfig.class;
        synchronized (EmberTableConfig.class) {
            if (emberTableConfig != null) return emberTableConfig;
            emberTableConfig = new EmberTableConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return emberTableConfig;
        }
    }

    public HashMap<String, String> getTableDetails(String cvid) {
        HashMap<String, String> tableDetails = new HashMap<String, String>();
        try {
            String uvhString = "AUDCVConfig:cv_id:" + cvid;
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
            Criteria crit = new Criteria(Column.getColumn((String)TABLE_TABLEVIEW, (String)COLUMN_CVID), (Object)cvId, 0);
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get(TABLE_TABLEVIEW, crit);
            Row r = dob.getFirstRow(TABLE_TABLEVIEW);
            List al = r.getColumns();
            for (int i = 0; i < al.size(); ++i) {
                String key = String.valueOf(al.get(i));
                String value = String.valueOf(r.get((String)al.get(i)));
                tableDetails.put(key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tableDetails;
    }

    public ArrayList<HashMap<String, String>> getColumnsList(String cvid, AdventNetResourceBundle rb) {
        ArrayList<HashMap<String, String>> retList = new ArrayList<HashMap<String, String>>();
        try {
            String uvhString = "AUDCVConfig:cv_id:" + cvid;
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
            Criteria crit = new Criteria(Column.getColumn((String)TABLE_COLUMNCONFIG, (String)COLUMN_CVID), (Object)cvId, 0);
            Table table = new Table(TABLE_COLUMNCONFIG);
            SelectQueryImpl sq = new SelectQueryImpl(table);
            sq.setCriteria(crit);
            ArrayList<Column> colList = new ArrayList<Column>();
            colList.add(Column.getColumn((String)TABLE_COLUMNCONFIG, (String)"*"));
            sq.addSelectColumns(colList);
            SortColumn sortColumn = new SortColumn(TABLE_COLUMNCONFIG, COLUMN_COLINDEX, true);
            sq.addSortColumn(sortColumn);
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            if (!dob.isEmpty()) {
                Iterator iter = dob.getRows(TABLE_COLUMNCONFIG);
                while (iter.hasNext()) {
                    HashMap<String, Object> rowMap = new HashMap<String, Object>();
                    Row r = (Row)iter.next();
                    List al = r.getColumns();
                    for (int i = 0; i < al.size(); ++i) {
                        Object key = al.get(i);
                        Object value = null;
                        value = (key.equals("DISPLAYNAME") || key.equals("displayname")) && r.get((String)key) != null ? rb.getString(r.get((String)key).toString()) : r.get((String)al.get(i));
                        rowMap.put(key.toString().toLowerCase(), value);
                    }
                    retList.add(rowMap);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retList;
    }

    private static void updateActionsList() {
        try {
            HashMap<Long, JSONObject> list = new HashMap<Long, JSONObject>();
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get(TABLE_EMBERACTIONSLIST, (Criteria)null);
            Iterator iter = dob.getRows(TABLE_EMBERACTIONSLIST);
            while (iter.hasNext()) {
                JSONObject rowMap = new JSONObject();
                Row r = (Row)iter.next();
                List al = r.getColumns();
                Long actionId = (Long)r.get(COLUMN_ACTION_ID);
                for (int i = 0; i < al.size(); ++i) {
                    String key = String.valueOf(al.get(i));
                    String value = String.valueOf(r.get((String)al.get(i)));
                    if (value.equals("null")) {
                        value = "";
                    }
                    rowMap.put(key, (Object)value);
                }
                list.put(actionId, rowMap);
            }
            actionsList = list;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JSONObject getActionsList(Long tableId, String actionType, JSONObject tableInputParams, AdventNetResourceBundle rb) {
        JSONObject retMap = new JSONObject();
        try {
            if (actionsList == null) {
                EmberTableConfig.updateActionsList();
            }
            tableInputParams = tableInputParams == null ? new JSONObject() : tableInputParams;
            Boolean readOnly = tableInputParams.optBoolean("readOnly");
            Criteria crit = new Criteria(Column.getColumn((String)TABLE_EMBERACTIONSMAPPING, (String)COLUMN_TABLE_ID), (Object)tableId, 0);
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get(TABLE_EMBERACTIONSMAPPING, crit);
            if (!dob.isEmpty()) {
                Iterator iter = dob.getRows(TABLE_EMBERACTIONSMAPPING);
                while (iter.hasNext()) {
                    Row mappingRow = (Row)iter.next();
                    Long actionId = (Long)mappingRow.get(COLUMN_ACTION_ID);
                    JSONObject mainMap = (JSONObject)actionsList.get(actionId);
                    String actionType1 = (String)mainMap.get(COLUMN_ACTION_TYPE);
                    if (!actionType1.equals(actionType)) continue;
                    String newMethod = (String)mappingRow.get(COLUMN_METHOD_VALUE);
                    String newTooltipKey = (String)mappingRow.get(COLUMN_TOOLTIP_VALUE);
                    if (newTooltipKey == null) {
                        newTooltipKey = "";
                    }
                    retMap.put((String)mainMap.get(COLUMN_ACTION_NAME), true);
                    retMap.put((String)mainMap.get(COLUMN_METHOD_NAME), mainMap.get(COLUMN_DEF_METHOD_VALUE));
                    retMap.put((String)mainMap.get(COLUMN_TOOLTIP_NAME), (Object)mainMap.getString(COLUMN_DEF_TOOLTIP_VALUE));
                    if (!(tableInputParams == null || readOnly != null && readOnly.booleanValue())) {
                        tableInputParams.put((String)mainMap.get(COLUMN_ACTION_NAME), true);
                        tableInputParams.put((String)mainMap.get(COLUMN_METHOD_NAME), mainMap.get(COLUMN_DEF_METHOD_VALUE));
                        tableInputParams.put((String)mainMap.get(COLUMN_TOOLTIP_NAME), (Object)rb.getString(mainMap.getString(COLUMN_DEF_TOOLTIP_VALUE)));
                    }
                    if (newMethod != null && !newMethod.equals("null") && !newMethod.trim().equals("")) {
                        retMap.put((String)mainMap.get(COLUMN_METHOD_NAME), (Object)newMethod);
                        if (!(tableInputParams == null || readOnly != null && readOnly.booleanValue())) {
                            tableInputParams.put((String)mainMap.get(COLUMN_METHOD_NAME), (Object)newMethod);
                        }
                    }
                    if (newTooltipKey == null || newTooltipKey.equals("null") || newTooltipKey.trim().equals("")) continue;
                    retMap.put((String)mainMap.get(COLUMN_TOOLTIP_NAME), (Object)newTooltipKey);
                    if (tableInputParams == null || readOnly != null && readOnly.booleanValue()) continue;
                    tableInputParams.put((String)mainMap.get(COLUMN_TOOLTIP_NAME), (Object)rb.getString(newTooltipKey));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retMap;
    }

    public JSONObject getEmberTableData1(Long tableId, ArrayList list, ArrayList colLit, JSONObject tableInputParams, AdventNetResourceBundle rb) {
        JSONObject retObject = new JSONObject();
        try {
            if (tableId != null) {
                this.getActionsList(tableId, "groupAction", tableInputParams, rb);
            }
            JSONObject tableData = new JSONObject();
            JSONArray tableDataList = null;
            tableDataList = this.getTableDataList(list, tableInputParams, colLit, tableId, rb);
            tableData.put("tableDataList", (Object)tableDataList);
            retObject.put("tableData", (Object)tableData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retObject;
    }

    public JSONObject getEmberTableData(String cvid, ArrayList list, JSONObject tableInputParams, AdventNetResourceBundle rb) {
        JSONObject retObject = new JSONObject();
        try {
            String uvhString = "AUDCVConfig:cv_id:" + cvid;
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
            Criteria crit = new Criteria(Column.getColumn((String)TABLE_TABLEVIEW, (String)COLUMN_CVID), (Object)cvId, 0);
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get(TABLE_TABLEVIEW, crit);
            HashMap<String, String> tableDetails = new HashMap<String, String>();
            if (!dob.isEmpty()) {
                Row r = dob.getFirstRow(TABLE_TABLEVIEW);
                List al = r.getColumns();
                for (int i = 0; i < al.size(); ++i) {
                    String key = String.valueOf(al.get(i));
                    String value = String.valueOf(r.get((String)al.get(i)));
                    tableDetails.put(key, value);
                }
            }
            Long tableId = Long.parseLong((String)tableDetails.get(COLUMN_TABLEVIEWID));
            this.getActionsList(tableId, "groupAction", tableInputParams, rb);
            String hideHeader = (String)tableDetails.get("HIDEHEADERANDNAVIG");
            if (hideHeader != null && hideHeader.equals("true")) {
                tableInputParams.put("hideTableOptions", true);
            }
            JSONObject searchData = new JSONObject();
            String rangeValueStr = (String)tableDetails.get(COLUMN_PAGELENGTH);
            Integer rangeValue = 0;
            if (rangeValueStr != null && !rangeValueStr.equals("null")) {
                rangeValue = Integer.parseInt(rangeValueStr);
            }
            String sortColumn = (String)tableDetails.get(COLUMN_SORTCOLUMN);
            String sortOrder = (String)tableDetails.get(COLUMN_SORTORDER);
            if (tableInputParams != null) {
                if (tableInputParams.has("sortColumn")) {
                    sortColumn = (String)tableInputParams.get("sortColumn");
                    sortOrder = (String)tableInputParams.get("sortOrder");
                }
                if (tableInputParams.has("rangeValue")) {
                    rangeValue = tableInputParams.getInt("rangeValue");
                }
                if (tableInputParams.has("searchData")) {
                    searchData = tableInputParams.getJSONObject("searchData");
                }
            }
            tableInputParams.put("sortColumn", (Object)sortColumn);
            tableInputParams.put("sortOrder", (Object)sortOrder);
            tableInputParams.put("rangeValue", (Object)rangeValue);
            String emptyTableMessages = (String)tableDetails.get(COLUMN_EMPTYTABLEMESSAGE);
            if (emptyTableMessages != null) {
                String[] mess = emptyTableMessages.split(";");
                tableInputParams.put("emptyTableMessage", (Object)rb.getString(mess[0]));
                if (mess.length > 1) {
                    tableInputParams.put("emptyTableMessage2", (Object)rb.getString(mess[1]));
                }
            }
            retObject.put("tableInputParams", (Object)tableInputParams);
            JSONObject tableData = new JSONObject();
            ArrayList<HashMap<String, String>> al = this.getColumnsList(cvid, rb);
            JSONArray tableColumnList = new JSONArray();
            for (int i = 0; i < al.size(); ++i) {
                JSONObject col = new JSONObject();
                HashMap<String, String> colMap = al.get(i);
                String columnAlias = colMap.get("columnalias");
                col.put("visible", (Object)colMap.get("visible"));
                col.put("displayname", (Object)colMap.get("displayname"));
                col.put("columnalias", (Object)colMap.get("columnalias"));
                col.put("sortenabled", (Object)colMap.get("sortenabled"));
                col.put("searchenabled", (Object)colMap.get("searchenabled"));
                if (colMap.get("viewname") != null) {
                    col.put(colMap.get("viewname"), true);
                }
                col.put("tablealias", (Object)colMap.get("tablealias"));
                if (columnAlias.equals(sortColumn)) {
                    col.put("isSortedColumn", true);
                    if (sortOrder.equals("ASC")) {
                        col.put("isSortASC", true);
                    }
                }
                if (searchData != null && searchData.has(colMap.get("columnalias"))) {
                    col.put("searchValue", searchData.get(colMap.get("columnalias")));
                    tableInputParams.put("searchDone", true);
                }
                tableColumnList.put((Object)col);
            }
            tableData.put("tableColumnList", (Object)tableColumnList);
            JSONArray tableDataList = this.getTableDataList(list, tableInputParams, al, tableId, rb);
            tableData.put("tableDataList", (Object)tableDataList);
            retObject.put("tableData", (Object)tableData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retObject;
    }

    public JSONArray getTableDataList(ArrayList list, JSONObject tableInputParams, ArrayList al, Long tableId, AdventNetResourceBundle rb) {
        JSONArray tableDataList = new JSONArray();
        try {
            Boolean readOnly = tableInputParams.optBoolean("readOnly");
            for (int i = 0; i < list.size(); ++i) {
                Object obj = list.get(i);
                HashMap rowMap = new HashMap();
                if (obj instanceof HashMap) {
                    rowMap = (HashMap)obj;
                } else if (obj instanceof Properties) {
                    Properties properties = (Properties)obj;
                    for (Object name : properties.keySet()) {
                        Object propertyObject = properties.get(name);
                        if (propertyObject instanceof Properties) {
                            Properties innerProperties = (Properties)propertyObject;
                            JSONObject innerPropertyObject = new JSONObject();
                            for (Object innerName : innerProperties.keySet()) {
                                innerPropertyObject.put(innerName.toString(), innerProperties.get(String.valueOf(innerName)));
                            }
                            rowMap.put(name, innerPropertyObject);
                            continue;
                        }
                        rowMap.put(name, properties.get(String.valueOf(name)));
                    }
                } else if (obj instanceof Hashtable) {
                    rowMap.putAll((Hashtable)obj);
                } else if (obj instanceof Row) {
                    Row tableDataRow = (Row)obj;
                    for (Object name : tableDataRow.getColumns()) {
                        rowMap.put(name, tableDataRow.get(String.valueOf(name)));
                    }
                }
                if (rowMap.get("SHARE_LIST") != null) {
                    rowMap.put("SHARE_LIST", JSONUtil.listToJSONArray((List)((ArrayList)rowMap.get("SHARE_LIST"))));
                }
                JSONObject row = new JSONObject((Map)rowMap);
                JSONArray colValues = new JSONArray();
                for (int j = 0; j < al.size(); ++j) {
                    String columnType;
                    JSONObject col = new JSONObject();
                    HashMap colMap = (HashMap)al.get(j);
                    String textConversion = (String)colMap.get("date_format");
                    Object columnValue = rowMap.get(colMap.get("columnalias"));
                    String columnAlias = colMap.get("columnalias").toString();
                    if (textConversion != null && textConversion.equals("TIMESTAMP")) {
                        columnValue = this.formatDate(String.valueOf(columnValue), rb);
                    } else if (textConversion != null && textConversion.equals("LANG")) {
                        columnValue = rb.getString((String)columnValue);
                    } else if (textConversion != null && textConversion.equals("STATUS")) {
                        String colClass;
                        if (String.valueOf(columnValue) == "null" || String.valueOf(columnValue) == "") {
                            columnValue = "-";
                        }
                        if ((colClass = this.getStatusCssClass(String.valueOf(columnValue), rb)).equals("text-danger")) {
                            columnValue = rb.getString("adap.domain_settings.view_domain.text.error") + " - " + columnValue;
                        }
                        col.put("colClass", (Object)colClass);
                    }
                    if (columnAlias != null && columnAlias.equals("TIME_PERIOD")) {
                        columnValue = this.getTimePeriodText((Long)rowMap.get(colMap.get("columnalias")), rb);
                    }
                    if ((columnType = (String)colMap.get("viewname")).equals("isLink")) {
                        if (colMap.get("suffix_text") != null) {
                            col.put("linkText", (Object)rb.getString((String)colMap.get("suffix_text")));
                        }
                        col.put("actionName", colMap.get("actionname"));
                    } else if (columnType.equals("isActions")) {
                        JSONObject actionsObject = this.getActionsList(tableId, "rowAction", null, rb);
                        Iterator iter = actionsObject.keys();
                        while (iter.hasNext()) {
                            String key = (String)iter.next();
                            String value = String.valueOf(actionsObject.get(key));
                            if (key.toLowerCase().contains("enabledisable")) {
                                key = EmberTableConfig.isEnabled(rowMap, tableInputParams) != false ? key.replace("enable", "") : key.replace("disable", "");
                            }
                            if (value.toLowerCase().contains("enabledisable")) {
                                value = EmberTableConfig.isEnabled(rowMap, tableInputParams) != false ? value.replace("enable", "") : value.replace("disable", "");
                            }
                            if (key.toLowerCase().contains("loadunload")) {
                                key = rowMap.get("ACTION").toString().equalsIgnoreCase("Loaded") ? key.replace("loadunload", "unload") : key.replace("unload", "");
                            }
                            if (value.toLowerCase().contains("loadunload")) {
                                value = rowMap.get("ACTION").toString().equalsIgnoreCase("Loaded") ? value.replace("loadunload", "unload") : value.replace("unload", "");
                            }
                            if (value.startsWith("adap.actions.")) {
                                value = rb.getString(value);
                            }
                            if (readOnly != null && readOnly.booleanValue()) continue;
                            col.put(key, (Object)value);
                            col.put("widthstyle", (Object)("min-width:" + 26 * actionsObject.length() / 3 + "px"));
                        }
                    } else if (columnType.equals("isComponent")) {
                        col.put("componentName", colMap.get("actionname"));
                    } else if (columnType.equals("isTrimText")) {
                        col.put("columnHover", columnValue);
                        if (String.valueOf(columnValue).length() > 25) {
                            columnValue = String.valueOf(columnValue).substring(0, 25) + "..";
                        }
                    }
                    String hiddenParameter = (String)colMap.get("prefix_text");
                    if (hiddenParameter != null) {
                        col.put("param", rowMap.get(hiddenParameter));
                    }
                    col.put("visible", colMap.get("visible"));
                    col.put("escapehtml", colMap.get("escape_html"));
                    col.put(columnType, true);
                    col.put("columnValue", columnValue);
                    String colTransformer = (String)colMap.get("transformer");
                    if (colTransformer != null && !colTransformer.equals("com.adventnet.client.components.table.web.DefaultTransformer")) {
                        try {
                            Class[] argTypes = new Class[]{JSONObject.class, HashMap.class, AdventNetResourceBundle.class};
                            Method method = this.getClass().getMethod(colTransformer, argTypes);
                            Object[] arglist = new Object[]{col, rowMap, rb};
                            String colStr = (String)method.invoke((Object)this, arglist);
                            col = new JSONObject(colStr);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    colValues.put((Object)col);
                }
                row.put("columnValues", (Object)colValues);
                tableDataList.put((Object)row);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tableDataList;
    }

    public String getTimePeriodText(Long msTimePeriod, AdventNetResourceBundle rb) {
        String msTimePeriodText = null;
        Long msHour = msTimePeriod / 60L;
        Long msMinute = 0L;
        if (msHour == 0L) {
            msTimePeriodText = rb.getString("adap.common.text.every") + " " + msTimePeriod + " " + rb.getString("adap.common.text.minutes");
        } else {
            msMinute = msTimePeriod % 60L;
            msTimePeriodText = rb.getString("adap.common.text.every") + " " + msHour + " " + rb.getString("adap.common.text.hours");
            if (msMinute != 0L) {
                msTimePeriodText = msTimePeriodText + " " + rb.getString("adap.common.text.and") + " " + msMinute + " " + rb.getString("adap.common.text.minutes");
            }
        }
        return msTimePeriodText;
    }

    public static Boolean isEnabled(HashMap rowMap, JSONObject tableInputParams) throws JSONException {
        if (rowMap.containsKey("IS_ENABLED")) {
            return (Boolean)rowMap.get("IS_ENABLED");
        }
        if (rowMap.containsKey("STATUS")) {
            int status = Integer.parseInt(String.valueOf(rowMap.get("STATUS")));
            if (status == 3) {
                return true;
            }
            return false;
        }
        if (rowMap.containsKey("ADMIN_STATUS")) {
            int status = Integer.parseInt(String.valueOf(rowMap.get("ADMIN_STATUS")));
            if (status == 3) {
                return true;
            }
            return false;
        }
        if (rowMap.containsKey("MACHINE_TYPE")) {
            int status = Integer.parseInt(String.valueOf(rowMap.get("MACHINE_TYPE")));
            Boolean isEnabled = false;
            if (tableInputParams.getString("serverType").equals("ms") && (status & 0x10) == 16) {
                isEnabled = true;
            } else if (tableInputParams.getString("serverType").equals("ws") && (status & 0x1000) == 4096) {
                isEnabled = true;
            } else if (tableInputParams.getString("serverType").equals("es") && (status & 0x400) == 1024) {
                isEnabled = true;
            } else if (tableInputParams.getString("serverType").equals("fs") && (status & 4) == 4) {
                isEnabled = true;
            } else if (tableInputParams.getString("serverType").equals("fc") && (status & 0x40) == 64) {
                isEnabled = true;
            } else if (tableInputParams.getString("serverType").equals("netapp") && (status & 0x100) == 256) {
                isEnabled = true;
            } else if (tableInputParams.getString("serverType").equals("emc") && (status & 0x20000) == 131072) {
                isEnabled = true;
            } else if (tableInputParams.getString("serverType").equals("netapp") && (status & 0x80000) == 524288) {
                isEnabled = true;
            }
            rowMap.put("IS_ENABLED", isEnabled);
            return isEnabled;
        }
        if (rowMap.containsKey("IS_CONFIGURED")) {
            int status = (Integer)rowMap.get("IS_CONFIGURED");
            if (status == 1) {
                return true;
            }
            return false;
        }
        return false;
    }

    public String formatDate(String timeStamp, AdventNetResourceBundle rb) {
        if (timeStamp == null || timeStamp.equals("null")) {
            return "-";
        }
        if (timeStamp.equals("0")) {
            return rb.getString("adap.common.text.status_msg.yet_to_fetch_event_data");
        }
        if (timeStamp.length() == 10) {
            timeStamp = timeStamp + "000";
        }
        String dateFormat = CommonUtil.getSysParams((String)"DATE_FORMAT");
        dateFormat = dateFormat + " " + CommonUtil.getSysParams((String)"TIME_FORMAT");
        SimpleDateFormat sdfDate = new SimpleDateFormat(dateFormat);
        sdfDate.setTimeZone(TimeZone.getTimeZone(CommonUtil.getSysParams((String)"TIMEZONE_ID")));
        return sdfDate.format(new Date(Long.parseLong(timeStamp)));
    }

    public String getStatusCssClass(String columnValue, AdventNetResourceBundle rb) {
        int i;
        String[] successStrings = new String[]{"Success", "Listening", "Running", rb.getString("adap.common.text.status_msg.success"), rb.getString("adap.common.text.status_msg.listening"), rb.getString("adap.common.text.status_msg.running"), rb.getString("adap.common.text.status_msg.event_collection_scheduled"), rb.getString("adap.ReportSchedulerHandler.Successfully_stored"), rb.getString("adap.ReportSchedulerHandler.Successfully_sent")};
        String[] infoStrings = new String[]{rb.getString("adap.common.text.status_msg.yet_to_fetch_event_data")};
        if (columnValue == null) {
            return "";
        }
        for (i = 0; i < successStrings.length; ++i) {
            if (!columnValue.contains(successStrings[i])) continue;
            return "primary-color";
        }
        for (i = 0; i < infoStrings.length; ++i) {
            if (!columnValue.contains(infoStrings[i])) continue;
            return "text-info";
        }
        if (columnValue.equals("-")) {
            return "primary-color";
        }
        return "text-danger";
    }

    public static String scheduleTypeTransformer(JSONObject col, HashMap rowMap, AdventNetResourceBundle rb) {
        try {
            if (((Boolean)rowMap.get("IS_ENABLED")).booleanValue()) {
                if (((Boolean)rowMap.get("IS_REALTIME")).booleanValue()) {
                    col.put("columnValue", (Object)"Real-Time");
                }
                col.put("linkText", (Object)"[edit]");
                col.put("actionName", (Object)"changeEventFetch");
            } else {
                col.put("columnValue", (Object)"-");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return col.toString();
    }

    public static String objectClassificationTransformer(JSONObject col, HashMap rowMap, AdventNetResourceBundle rb) {
        try {
            if (rowMap.get("OBJECT_CLASS").toString().equalsIgnoreCase("user")) {
                col.put("columnValue", (Object)("<div class='row'><i class='adap-icon icn-user col'></i><span class='col'>" + rowMap.get("NAME") + "</span></div>"));
            } else if (rowMap.get("OBJECT_CLASS").toString().equalsIgnoreCase("group")) {
                col.put("columnValue", (Object)("<div class='row'><i class='adap-icon icn-group col'></i><span class='col'>" + rowMap.get("NAME") + "</span></div>"));
            } else if (rowMap.get("OBJECT_CLASS").toString().equalsIgnoreCase("organizationalUnit")) {
                col.put("columnValue", (Object)("<div class='row'><i class='adap-icon icn-ou col'></i><span class='col'>" + rowMap.get("NAME") + "</span></div>"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return col.toString();
    }

    public static String importEvtRunNowTransformer(JSONObject col, HashMap rowMap, AdventNetResourceBundle rb) {
        try {
            if (!((Boolean)rowMap.get("STATUS")).booleanValue()) {
                col.put("linkText", (Object)"[RUN NOW]");
                col.put("actionName", (Object)"runEvtImport");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return col.toString();
    }

    public static String inheritedMemberServerTransformer(JSONObject col, HashMap rowMap, AdventNetResourceBundle rb) {
        try {
            if (rowMap.get("ISINHERITED").toString().equals("1")) {
                col.put("columnValue", (Object)("<td>" + rowMap.get("COMPUTER_NAME") + "   <i class='inherit-host-icon inherit-host-pos'></i>  </td>"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return col.toString();
    }

    public static String runEventFetchTransformer(JSONObject col, HashMap rowMap, AdventNetResourceBundle rb) {
        try {
            if (!((Boolean)rowMap.get("IS_ENABLED")).booleanValue() || rowMap.get("IS_REALTIME") != null && ((Boolean)rowMap.get("IS_REALTIME")).booleanValue()) {
                col.put("linkText", (Object)"");
            }
            if (rowMap.get("LISTENING") != null && ((Boolean)rowMap.get("LISTENING")).booleanValue()) {
                Boolean listening = (Boolean)rowMap.get("LISTENING");
                boolean enabled = (Boolean)rowMap.get("ENABLED");
                if (listening.booleanValue() || !enabled) {
                    col.put("linkText", (Object)"");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return col.toString();
    }

    public static String updateAlertEMailText(JSONObject json, HashMap row, AdventNetResourceBundle rb) {
        try {
            Long alertProfileId = (Long)row.get("ALERT_PROFILE_ID");
            boolean isMailEnabled = AlertProfileAPI.isMailEnabled((Long)alertProfileId);
            if (isMailEnabled) {
                json.put("linkText", (Object)rb.getString("adap.common.button.update"));
            } else {
                json.put("linkText", (Object)rb.getString("adap.common.text.configure"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json.toString();
    }

    public String excludeOperatorTransformer(JSONObject col, HashMap rowMap, AdventNetResourceBundle rb) {
        try {
            Integer operatorId = col.getInt("columnValue");
            for (int i = 0; i < GlobalExcludeConfig.getInstance().operatorStrings.length; ++i) {
                if (!operatorId.equals(GlobalExcludeConfig.getInstance().operatorIds[i])) continue;
                col.put("columnValue", (Object)GlobalExcludeConfig.getInstance().operatorStrings[i]);
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return col.toString();
    }

    public String machineTypeTransformer(JSONObject col, HashMap rowMap, AdventNetResourceBundle rb) {
        try {
            String machineTypeString = "";
            Integer machineTypeId = col.getInt("columnValue");
            for (int i = 0; i < GlobalExcludeConfig.getInstance().machineTypeStrings.length; ++i) {
                if ((machineTypeId & GlobalExcludeConfig.getInstance().machineTypeIds[i]) != GlobalExcludeConfig.getInstance().machineTypeIds[i]) continue;
                if (machineTypeString.length() > 0) {
                    machineTypeString = machineTypeString + ",";
                }
                machineTypeString = machineTypeString + GlobalExcludeConfig.getInstance().machineTypeStrings[i];
            }
            col.put("columnValue", (Object)machineTypeString);
            if (String.valueOf(machineTypeString).length() > 25) {
                col.put("columnHover", (Object)machineTypeString);
                col.put("isTrimText", true);
                col.put("isData", false);
                String tempMachineTypeString = String.valueOf(machineTypeString).substring(0, 25) + "..";
                col.put("columnValue", (Object)tempMachineTypeString);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return col.toString();
    }
}

