/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.common;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.alert.AlertAPI;
import com.adventnet.sym.adsm.auditing.server.fileintegrity.FileIntegrityManager;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportCategoryHandler;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.APIUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class LeftTreeHandler {
    private static volatile LeftTreeHandler instance = null;
    private static Logger logger = Logger.getLogger(LeftTreeHandler.class.getName());
    private static final Pattern CATEGORY_PATTERN = Pattern.compile("\\$\\{CATEGORY_ID:([^\\}]*)\\}");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LeftTreeHandler getInstance() {
        if (instance != null) return instance;
        Class<LeftTreeHandler> clazz = LeftTreeHandler.class;
        synchronized (LeftTreeHandler.class) {
            if (instance != null) return instance;
            instance = new LeftTreeHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LeftTreeHandler() {
    }

    public void getLeftTreeList(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Integer tabId = Integer.parseInt(request.getParameter("TAB_ID").toString());
            logger.log(Level.INFO, "getLeftTreeList " + request.getParameter("TAB_ID").toString());
            HttpSession session = request.getSession();
            ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
            ArrayList userActions = authObject.getUserActins();
            JSONArray reportList = new JSONArray();
            Integer categoryType = 1;
            if (tabId == 2) {
                LeftTreeHandler.getReportCategories(reportList, null, categoryType, tabId, request, rb);
            } else if (tabId == 3) {
                categoryType = 2;
                this.getStaticLeftTreeDetails(reportList, "ADAPTotalTabs:tab_id:7", userActions, rb);
                LeftTreeHandler.getReportCategories(reportList, null, categoryType, tabId, request, rb);
            } else if (tabId == 4) {
                categoryType = 3;
                this.getStaticLeftTreeDetails(reportList, "ADAPTotalTabs:tab_id:8", userActions, rb);
                LeftTreeHandler.getReportCategories(reportList, null, categoryType, tabId, request, rb);
            } else if (tabId == 5) {
                LeftTreeHandler.getAlertProfilesForLeftTree(request, response, rb, authObject);
            } else if (tabId == 6) {
                this.getAdminConfigTabList(request, response, "ADAPTotalTabs:tab_id:4", userActions, rb);
            } else if (tabId == 7) {
                this.getAdminConfigTabList(request, response, "ADAPTotalTabs:tab_id:5", userActions, rb);
            } else if (tabId == 8) {
                LeftTreeHandler.getFrequentlyViewedReports(request, response, rb);
            }
            if (tabId == 2 || tabId == 3 || tabId == 4) {
                this.getStaticLeftTreeDetails(request, reportList, categoryType, false, rb);
                JSONObject map = new JSONObject();
                map.put("treeRowsList", (Object)reportList);
                JsonResponse.getInstance().sendResponse(response, map.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getFrequentlyViewedReports(HttpServletRequest request, HttpServletResponse response, AdventNetResourceBundle rb) throws Exception {
        ArrayList<HashMap> reportList = new ArrayList<HashMap>();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        HttpSession session = request.getSession();
        HashMap reportCategoriesMap = AuditReportAPI.getInstance().getFrequentlyViewedReportsEmber(request, response, (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID"), true, 10, rb);
        reportList.add(reportCategoriesMap);
        map.put("treeRowsList", reportList);
        JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(map));
    }

    public JSONArray getStaticLeftTreeDetails(JSONArray retArray, String tabIdPattern, ArrayList<Long> userActions, AdventNetResourceBundle rb) {
        try {
            Long tabId = DBObjectUtil.getUVHValues((String)"ADAPTotalTabs", (String)tabIdPattern);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDLeftTreeComponents", (String)"TAB_ID"), (Object)tabId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"AUDLeftTreeComponents", (String)"ACTION_ID"), (Object)userActions.toArray(), 8));
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDLeftTreeComponents"));
            query.setCriteria(crit);
            query.addSelectColumn(Column.getColumn((String)"AUDLeftTreeComponents", (String)"*"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDLeftTreeComponents", (String)"PRIORITY_ID"), true));
            DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            LinkedHashMap tilesTables = new LinkedHashMap();
            Iterator iterator = dObj.getRows("AUDLeftTreeComponents", new Criteria(Column.getColumn((String)"AUDLeftTreeComponents", (String)"PARENT_ID"), (Object)0L, 0));
            while (iterator.hasNext()) {
                Row parentRow = (Row)iterator.next();
                JSONObject categoryObj = new JSONObject();
                categoryObj.put("name", (Object)rb.getString((String)parentRow.get("TILE_DISPLAY_NAME")));
                categoryObj.put("className", (Object)"open");
                categoryObj.put("hasDropdown", true);
                JSONArray itemArray = new JSONArray();
                Iterator iter = dObj.getRows("AUDLeftTreeComponents", new Criteria(Column.getColumn((String)"AUDLeftTreeComponents", (String)"PARENT_ID"), (Object)((Long)parentRow.get("TILE_ID")), 0));
                while (iter.hasNext()) {
                    Row detailsRow = (Row)iter.next();
                    String modelId = (String)detailsRow.get("TILE_MODEL_ID");
                    modelId = AdminHandler.categoryIdReplaceInURL((String)modelId);
                    JSONObject item = new JSONObject();
                    item.put("name", (Object)rb.getString((String)detailsRow.get("TILE_DISPLAY_NAME")));
                    item.put("routeName", (Object)rb.getString((String)detailsRow.get("TILE_ROUTE_NAME")));
                    item.put("modelId", (Object)modelId);
                    itemArray.put((Object)item);
                }
                categoryObj.put("list", (Object)itemArray);
                retArray.put((Object)categoryObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retArray;
    }

    public JSONArray getStaticLeftTreeDetails(HttpServletRequest request, JSONArray reportList, Integer categoryType, Boolean isServer, AdventNetResourceBundle rb) throws Exception {
        JSONObject b;
        JSONObject a;
        JSONArray fileList;
        JSONObject fileMap;
        ArrayList userActions;
        HttpSession session = request.getSession();
        ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        if (categoryType == 2 && !isServer.booleanValue() && (userActions = authObject.getUserActins()).contains(TDConstants.CONFIG_FS)) {
            fileMap = new JSONObject();
            fileList = new JSONArray();
            fileMap.put("name", (Object)rb.getString("adap.ADAPTotalTabs.Configuration"));
            fileMap.put("hasDropdown", true);
            a = new JSONObject();
            a.put("name", (Object)(rb.getString("adap.ADAPTotalTabs.File_Audit") + " " + rb.getString("adap.configuration.configure_alerts.report_profiles.text")));
            a.put("routeName", (Object)"fileaudit.viewreportprofiles");
            a.put("modelId", (Object)AdminHandler.categoryIdReplaceInURL((String)"${CATEGORY_ID:20}"));
            b = new JSONObject();
            b.put("name", (Object)rb.getString("adap.configuration.tree_component.advanced_configuration"));
            b.put("modelId", (Object)"2");
            b.put("routeName", (Object)"fileaudit.viewauditactions");
            JSONObject c = new JSONObject();
            c.put("name", (Object)rb.getString("adap.FileAuditTreeComponent.Exclude_Files"));
            c.put("routeName", (Object)"fileaudit.excludeconfig");
            c.put("modelId", (Object)"null");
            fileList.put((Object)a);
            fileList.put((Object)b);
            fileList.put((Object)c);
            fileMap.put("list", (Object)fileList);
            reportList.put((Object)fileMap);
        }
        if (categoryType == 3 && !isServer.booleanValue() && (userActions = authObject.getUserActins()).contains(TDConstants.CONFIG_FIM)) {
            fileMap = new JSONObject();
            fileList = new JSONArray();
            fileMap.put("name", (Object)rb.getString("adap.ADAPTotalTabs.Configuration"));
            fileMap.put("hasDropdown", true);
            a = new JSONObject();
            a.put("name", (Object)(rb.getString("adap.AUDCategories.category_name.File_Integrity") + " " + rb.getString("adap.configuration.configure_alerts.report_profiles.text")));
            a.put("routeName", (Object)"serveraudit.viewreportprofiles");
            a.put("modelId", (Object)AdminHandler.categoryIdReplaceInURL((String)"${CATEGORY_ID:34}"));
            b = new JSONObject();
            b.put("name", (Object)rb.getString("adap.configuration.tree_component.advanced_configuration"));
            b.put("modelId", (Object)"3");
            b.put("routeName", (Object)"serveraudit.viewauditactions");
            fileList.put((Object)a);
            fileList.put((Object)b);
            fileMap.put("list", (Object)fileList);
            reportList.put((Object)fileMap);
        }
        return reportList;
    }

    public static JSONArray getReportCategories(JSONArray reportList, String domainName, Integer categoryType, Integer tabId, HttpServletRequest request, AdventNetResourceBundle rb) throws Exception {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)request.getSession().getAttribute("ADAP_SESSION_LOGIN_ID");
            ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
            ArrayList actionList = authObject.getUserActins();
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDReportCategories"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDReportCategories", (String)"*"));
            ArrayList idList = AuditReportCategoryHandler.getExcludedReportCategoryIds();
            Integer[] categoryIds = idList.toArray(new Integer[idList.size()]);
            Criteria c = new Criteria(new Column("AUDReportCategories", "REPORT_CATEGORY_ID"), (Object)categoryIds, 9);
            selectQuery.setCriteria(c);
            selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)"AUDReportCategories", (String)"PRIORITY"), true));
            Criteria crit = new Criteria(Column.getColumn((String)"AUDReportCategories", (String)"ACTION_ID"), (Object)actionList.toArray(), 8);
            crit = crit.or(new Criteria(Column.getColumn((String)"AUDReportCategories", (String)"ACTION_ID"), null, 0));
            selectQuery.setCriteria(crit);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)selectQuery);
            boolean isFIMEnabled = domainName != null ? FileIntegrityManager.getInstance().isFIMEnabledInDomain(domainName) : false;
            Iterator iterator = dataObject.getRows("AUDReportCategories");
            while (iterator.hasNext()) {
                JSONObject reportCategoriesMap = new JSONObject();
                Row row = (Row)iterator.next();
                Long reportCategoryId = (Long)row.get("REPORT_CATEGORY_ID");
                reportCategoriesMap.put("REPORT_CATEGORY_ID", (Object)reportCategoryId);
                reportCategoriesMap.put("name", (Object)rb.getString((String)row.get("NAME")));
                reportCategoriesMap.put("hasDropdown", true);
                reportCategoriesMap.put("SR_NAME", (Object)rb.getString((String)row.get("SR_NAME")));
                if (reportCategoryId == 1L) {
                    HashMap loginUserDetails = authObject.getLoginUserDetails();
                    String delegatedDomain = null;
                    if (!"All Domains".equals((String)loginUserDetails.get("DELEGATED_DOMAIN"))) {
                        delegatedDomain = (String)loginUserDetails.get("DELEGATED_DOMAIN");
                    }
                    reportCategoriesMap.put("list", (Object)AuditReportCategoryHandler.getMonitorReports((Integer)categoryType, (Integer)tabId, (AdventNetResourceBundle)rb, (String)delegatedDomain, (Boolean)false));
                } else if (reportCategoryId == 7L) {
                    Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
                    hashtable.put("IS_CUSTOM_PROFILE", true);
                    reportCategoriesMap.put("list", (Object)AuditReportCategoryHandler.getMonitorReports((Integer)categoryType, hashtable, (AdventNetResourceBundle)rb, (Long)loginId));
                } else if (reportCategoryId == 20L) {
                    if (isFIMEnabled && categoryType == null || categoryType != null) {
                        reportCategoriesMap.put("list", (Object)AuditReportCategoryHandler.getCategoryReports((Long)reportCategoryId, (Integer)categoryType, (AdventNetResourceBundle)rb, (Long)loginId, (ArrayList)actionList));
                    } else {
                        reportCategoriesMap.put("list", (Object)new JSONArray());
                    }
                } else {
                    reportCategoriesMap.put("list", (Object)AuditReportCategoryHandler.getCategoryReports((Long)reportCategoryId, (Integer)categoryType, (AdventNetResourceBundle)rb, (Long)loginId, (ArrayList)actionList));
                }
                if (reportCategoriesMap.getJSONArray("list").length() <= 0) continue;
                reportList.put((Object)reportCategoriesMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reportList;
    }

    public static void getAlertProfilesForLeftTree(HttpServletRequest request, HttpServletResponse response, AdventNetResourceBundle rb, ADAPAuthObject authObject) {
        JSONObject ret = new JSONObject();
        JSONArray retArray = new JSONArray();
        JSONObject categoryObj = new JSONObject();
        try {
            categoryObj = new JSONObject();
            categoryObj.put("name", (Object)rb.getString("adap.alerts.audit.view_alerts.show_alert_status_text.all_alerts_text"));
            categoryObj.put("routeName", (Object)"alerts.viewalerts");
            categoryObj.put("modelId", (Object)"All");
            retArray.put((Object)categoryObj);
            categoryObj = new JSONObject();
            categoryObj.put("name", (Object)rb.getString("adap.alerts.audit.view_alert.tree_comp_headidng.alert_profile_based_alerts"));
            categoryObj.put("hasDropdown", true);
            categoryObj.put("className", (Object)"open");
            JSONArray profileCategories = new JSONArray();
            HashMap loginUserDetails = authObject.getLoginUserDetails();
            String domainName = (String)loginUserDetails.get("DELEGATED_DOMAIN");
            if (domainName.equalsIgnoreCase(rb.getString("adap.common.text.All_Domains")) || domainName.equalsIgnoreCase("All Domains")) {
                domainName = null;
            }
            AlertAPI.getInstance();
            HashMap profileMap = AlertAPI.getALertProfileList((String)domainName);
            for (Map.Entry entry : profileMap.entrySet()) {
                JSONObject domainObject = new JSONObject();
                domainObject.put("name", entry.getKey());
                domainObject.put("hasDropdown", true);
                JSONArray reportsArray = new JSONArray();
                ArrayList reportsList = (ArrayList)entry.getValue();
                for (int i = 0; i < reportsList.size(); ++i) {
                    HashMap report = (HashMap)reportsList.get(i);
                    JSONObject reportObject = new JSONObject();
                    reportObject.put("modelId", report.get("ALERT_PROFILE_ID"));
                    reportObject.put("name", report.get("ALERT_PROFILE_NAME"));
                    reportObject.put("routeName", (Object)"alerts.viewalerts");
                    reportsArray.put((Object)reportObject);
                }
                domainObject.put("list", (Object)reportsArray);
                profileCategories.put((Object)domainObject);
            }
            categoryObj.put("list", (Object)profileCategories);
            retArray.put((Object)categoryObj);
            ret.put("treeDataList", (Object)retArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public void getAdminConfigTabList(HttpServletRequest request, HttpServletResponse response, String tileId, ArrayList<Long> userActions, AdventNetResourceBundle rb) {
        JSONObject ret = new JSONObject();
        try {
            JSONArray retArray = new JSONArray();
            Long tabId = DBObjectUtil.getUVHValues((String)"ADAPTotalTabs", (String)tileId);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDLeftTreeComponents", (String)"TAB_ID"), (Object)tabId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"AUDLeftTreeComponents", (String)"ACTION_ID"), (Object)userActions.toArray(), 8));
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDLeftTreeComponents"));
            query.setCriteria(crit);
            query.addSelectColumn(Column.getColumn((String)"AUDLeftTreeComponents", (String)"*"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDLeftTreeComponents", (String)"PRIORITY_ID"), true));
            DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            LinkedHashMap tilesTables = new LinkedHashMap();
            Iterator iterator = dObj.getRows("AUDLeftTreeComponents", new Criteria(Column.getColumn((String)"AUDLeftTreeComponents", (String)"PARENT_ID"), (Object)0L, 0));
            while (iterator.hasNext()) {
                Row parentRow = (Row)iterator.next();
                JSONObject categoryObj = new JSONObject();
                categoryObj.put("name", (Object)rb.getString((String)parentRow.get("TILE_DISPLAY_NAME")));
                categoryObj.put("className", (Object)"open");
                categoryObj.put("hasDropdown", true);
                JSONArray itemArray = new JSONArray();
                Iterator iter = dObj.getRows("AUDLeftTreeComponents", new Criteria(Column.getColumn((String)"AUDLeftTreeComponents", (String)"PARENT_ID"), (Object)((Long)parentRow.get("TILE_ID")), 0));
                while (iter.hasNext()) {
                    Row detailsRow = (Row)iter.next();
                    String modelId = (String)detailsRow.get("TILE_MODEL_ID");
                    modelId = AdminHandler.categoryIdReplaceInURL((String)modelId);
                    JSONObject item = new JSONObject();
                    item.put("name", (Object)rb.getString((String)detailsRow.get("TILE_DISPLAY_NAME")));
                    item.put("routeName", (Object)rb.getString((String)detailsRow.get("TILE_ROUTE_NAME")));
                    item.put("modelId", (Object)modelId);
                    if (detailsRow.get("TILE_DISPLAY_NAME").toString().equals("adap.AdminController.Search_Archived_Events")) {
                        item.put("isNew", true);
                    }
                    itemArray.put((Object)item);
                }
                categoryObj.put("list", (Object)itemArray);
                retArray.put((Object)categoryObj);
            }
            ret.put("treeDataList", (Object)retArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }
}

