/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.common;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.config.ServerConfigAPI;
import com.adventnet.sym.adsm.auditing.server.fileintegrity.FileIntegrityManager;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportCategoryHandler;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.server.util.EventSchedulerUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.APIUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.MSHandler;
import com.adventnet.sym.adsm.common.server.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.ConfigureDiskSpace;
import com.adventnet.sym.adsm.common.server.admin.EventErrorAlert;
import com.adventnet.sym.adsm.common.server.admin.TechnicianHandler;
import com.adventnet.sym.adsm.common.server.admin.WrapperUtil;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.authentication.ADAPUserAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.JSONUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.LicenseUpgradeAction;
import com.adventnet.tools.prevalent.Validation;
import com.manageengine.ads.fw.api.RestAPIUtil;
import com.manageengine.ads.fw.reports.favourites.MyFavRepHandler;
import com.manageengine.ads.fw.util.jumpto.JumpToHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class TabConfigHandler {
    protected static Logger logger = Logger.getLogger("ReportLogger");
    private static volatile TabConfigHandler instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TabConfigHandler getInstance() {
        if (instance != null) return instance;
        Class<TabConfigHandler> clazz = TabConfigHandler.class;
        synchronized (TabConfigHandler.class) {
            if (instance != null) return instance;
            instance = new TabConfigHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void getConfiguredDomainDetails(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        try {
            HttpSession session = request.getSession();
            ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
            ArrayList list = authObject.getDomainsList();
            String defaultDomainName = DomainDetailsAPI.getDefaultDomainName();
            Boolean defaultDomainSet = false;
            JSONArray retArray = new JSONArray();
            for (int i = 0; i < list.size(); ++i) {
                JSONObject jo = new JSONObject();
                jo.put("name", list.get(i));
                jo.put("value", list.get(i));
                retArray.put((Object)jo);
                if (!defaultDomainName.equals(list.get(i))) continue;
                defaultDomainSet = true;
            }
            ret.put("domainsList", (Object)retArray);
            if (!defaultDomainSet.booleanValue() && !list.isEmpty()) {
                defaultDomainName = (String)list.get(0);
            }
            ret.put("defaultDomain", (Object)defaultDomainName);
            ret.put("fileServersCount", ServerConfigAPI.getConfiguredServerCount((int[])new int[]{4, 8, 64, 128, 256, 512, 131072, 262144, 524288, 0x100000}, (boolean)false));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public void getAuthVariables(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            Row r;
            Iterator iter;
            Credential cred;
            HttpSession session = request.getSession();
            ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
            if (session.getAttribute("CREDENTIAL") == null) {
                session.setAttribute("CREDENTIAL", (Object)AuthUtil.getUserCredential());
            }
            if (authObject.getFirstLogon() && (cred = (Credential)session.getAttribute("CREDENTIAL")) != null) {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{cred, 16, "Logon", rb.handleGetObject("adap.HomeAction.audit_entry.user_logged_in", new String[]{cred.getLoginName()}), 1024, 8, "adap.ADAPUserAuditSeverities.audit_name.login_success", "-"}));
                authObject.setFalseToFirstLogon();
            }
            JSONObject userRoleActions = new JSONObject();
            DataObject d1 = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADAPUserRoleActions", (Criteria)null);
            if (!d1.isEmpty()) {
                iter = d1.getRows("ADAPUserRoleActions");
                while (iter.hasNext()) {
                    r = (Row)iter.next();
                    userRoleActions.put(String.valueOf(r.get("ACTION_NAME")), (Object)String.valueOf(r.get("ACTION_ID")));
                }
            }
            if (!(d1 = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDLeftTreeComponents", (Criteria)null)).isEmpty()) {
                iter = d1.getRows("AUDLeftTreeComponents");
                while (iter.hasNext()) {
                    r = (Row)iter.next();
                    userRoleActions.put(String.valueOf(r.get("TILE_NAME")), (Object)String.valueOf(r.get("ACTION_ID")));
                }
            }
            ret.put("userRoleActions", (Object)userRoleActions);
            HashMap actionAccesses = authObject.getAccesses();
            JSONObject accesses = JSONUtil.mapToJSONObject((Map)actionAccesses);
            ret.put("actionAccesses", (Object)accesses);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public void getJsMessage(HttpServletRequest request, HttpServletResponse response) {
        String ret = "";
        try {
            Locale localeObj = ResourceBundleMgr.getInstance().getClientLocale(request);
            ret = ResourceBundleMgr.getInstance().getJsMessage2(localeObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret);
    }

    public void installService(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            ret.put("success", false);
            ret.put("message", (Object)"Failed to install service");
            WrapperUtil.installAsService();
            ret.put("success", true);
            ret.put("message", (Object)rb.getString("adap.HomeAlertDiv.text.InstalledService"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public void recalculateDiskSpace(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            ConfigureDiskSpace.calculateDiskSpace();
            Hashtable diskSettings = ConfigureDiskSpace.isLowDiskSpace();
            if (!diskSettings.isEmpty()) {
                ret.put("lowDiskSpace", (Object)(rb.getString("adap.disk_space_alert.alert_text.available_free_space") + " " + diskSettings.get("FREE_DISK_SPACE") + " MB,"));
                ret.put("lowDiskSpace2", (Object)(rb.getString("adap.tab.disk_space.alert_text_threshold") + " " + diskSettings.get("CONFIGURE_SPACE") + " MB."));
            } else {
                ret.put("success", true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public void logoutSession(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        session.invalidate();
    }

    private String storeFile(String fileName, File formFile) throws Exception {
        File saveFile = null;
        try (FileOutputStream fout = null;){
            FileInputStream fileInput = new FileInputStream(formFile);
            byte[] file = new byte[((InputStream)fileInput).available()];
            ((InputStream)fileInput).read(file);
            String currentPath = System.getProperty("user.dir");
            String directory = currentPath + File.separator + "license";
            File saveDir = new File(directory);
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            saveFile = new File(directory + File.separator + fileName);
            fout = new FileOutputStream(saveFile);
            fout.write(file);
            logger.log(Level.INFO, "The License File stored successfully...");
            String string = saveFile.getAbsolutePath();
            return string;
        }
    }

    public void upgradeLicense(HttpServletRequest request, HttpServletResponse response) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String licensePath = "";
        try {
            File formFile = ClientUtil.getFileFromRequest(request, "browse");
            String fileName = null;
            fileName = formFile.getName();
            Boolean upgradestatus = false;
            Boolean status = false;
            String upgradestatusmsg = "ERROR";
            if (fileName != null) {
                try {
                    LicenseUtil.resetLicenseType();
                    licensePath = this.storeFile(fileName, formFile);
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "Exception while storing the license file ", ex);
                }
            } else {
                upgradestatusmsg = "adap.LicenseUpgradeAction.License_is_not_Applied_properly";
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "License", upgradestatusmsg, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.login_success", "-"}));
            }
            PrintWriter out = response.getWriter();
            response.setContentType("text/html");
            if (!licensePath.equals("")) {
                upgradestatus = LicenseUpgradeAction.upgradeLicense(request, licensePath);
                if (upgradestatus.booleanValue() || (upgradestatus = Boolean.valueOf(LicenseUpgradeAction.upgradeAD360License(request, licensePath))).booleanValue()) {
                    upgradestatusmsg = rb.getString("adap.LicenseUpgradeAction.License_upgraded_Successfully");
                    upgradestatusmsg = upgradestatusmsg.replace("\n", "<br>");
                    status = true;
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "License", upgradestatusmsg, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.login_success", "-"}));
                } else {
                    upgradestatusmsg = rb.getString("adap.LicenseUpgradeAction.Please_Enter_a_valid_License");
                    status = false;
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "License", upgradestatusmsg, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.login_success", "-"}));
                    File tmpFile = new File(licensePath);
                    tmpFile.delete();
                }
            }
            LicenseUtil.resetValues();
            CommonUtil.updateSytemTime();
            String retScript = "<script> window.parent.$('#licenseMsg').removeClass('hide');window.parent.$('#licenseMsg').removeClass('alert-success');window.parent.$('#licenseMsg').removeClass('alert-danger');window.parent.$('#licenseMsg').html('" + upgradestatusmsg + "');";
            retScript = status != false ? retScript + "window.parent.$('#licenseMsg').addClass('alert-success');" : retScript + "window.parent.$('#licenseMsg').addClass('alert-danger');";
            retScript = retScript + "</script>";
            out.write(retScript);
        }
        catch (Exception e) {
            String upgradestatusmsg = rb.getString("adap.LicenseUpgradeAction.License_is_not_Applied_properly");
            try {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "License", upgradestatusmsg, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.login_success", "-"}));
                if (!licensePath.equals("")) {
                    File tmpFile = new File(licensePath);
                    tmpFile.delete();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            logger.log(Level.WARNING, "Exception while upgrading the license file ", e);
        }
    }

    public void listTabs(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HashMap<Object, Object> retMap = new HashMap<Object, Object>();
            HttpSession session = request.getSession();
            String loginName = request.getUserPrincipal().getName();
            boolean authizeCheck = request.isUserInRole("Admin");
            String licenseType = LicenseUtil.getLicenseType();
            Credential cred = AuthUtil.getUserCredential();
            Long loggedOnUserId = cred.getUserId();
            boolean showPassword = TechnicianHandler.personalizeCheck((String)loginName, (Long)loggedOnUserId);
            ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
            ArrayList userActions = authObject.getUserActins();
            HashMap<String, Object> loginDetails = new HashMap<String, Object>();
            loginDetails.put("loginName", loginName);
            loginDetails.put("loginId", loggedOnUserId);
            loginDetails.put("licenseType", licenseType);
            loginDetails.put("buildNumber", CommonUtil.getBuildNumber());
            loginDetails.put("productVersion", CommonUtil.getProductVersion());
            loginDetails.put("ip", request.getRemoteAddr());
            if (authizeCheck && showPassword) {
                loginDetails.put("canChangePass", true);
            }
            if (authizeCheck) {
                loginDetails.put("canJumpTo", true);
            }
            if (authizeCheck) {
                loginDetails.put("showLicenseDetails", true);
            }
            if (authizeCheck && userActions.contains(TDConstants.DOMAIN_SETTINGS)) {
                loginDetails.put("showDomainSettings", true);
            }
            if (userActions.contains(TDConstants.USER_SEARCH)) {
                loginDetails.put("showUserSearch", true);
            }
            retMap.put("loginDetails", loginDetails);
            if ((HashMap)session.getAttribute("AAA_DETAILS") == null) {
                session.setAttribute("AAA_DETAILS", (Object)ADAPUserAPI.getAAADetails((String)loginName, (Long)loggedOnUserId));
            }
            HashMap defaultRouteDetails = new HashMap();
            HashMap aaaDetails = (HashMap)session.getAttribute("AAA_DETAILS");
            ArrayList availableTabs = (ArrayList)authObject.getAAADetails().get("AVAILABLE_TABS");
            ArrayList<Properties> tabsList = new ArrayList<Properties>();
            HashMap<String, ArrayList<HashMap<String, Object>>> quickLinks = new HashMap<String, ArrayList<HashMap<String, Object>>>();
            Boolean isComplianceUrl = false;
            if (userActions.contains(TDConstants.AGGREGATE_REPORTS) && !userActions.contains(TDConstants.HOME_TAB_ID)) {
                isComplianceUrl = true;
            }
            for (int i = 0; i < availableTabs.size(); ++i) {
                ArrayList<HashMap<String, Object>> reportUIMap;
                Map tabRow = (Map)availableTabs.get(i);
                Properties tabProps = new Properties();
                String tabName = (String)tabRow.get("TAB_NAME");
                if (tabName.equals("adManagement") && !TabConfigHandler.isAD360Integrated()) continue;
                tabProps.put("TAB_NAME", tabName);
                tabProps.put("TAB_DISPLAY_NAME", rb.getString((String)tabRow.get("TAB_DISPLAY_NAME")));
                tabProps.put("TAB_URL", (String)tabRow.get("TAB_NAME"));
                Integer tabPriorityId = i;
                tabProps.put("tabId", "TabsTabId_" + tabPriorityId);
                tabProps.put("quickId", "quick" + tabProps.get("TAB_NAME"));
                if (TDConstants.HOME_TAB_ID.longValue() == ((Long)tabRow.get("ACTION_ID")).longValue() && isComplianceUrl.booleanValue()) {
                    tabProps.put("TAB_URL", "reports.aggregate");
                }
                if (tabRow.get("TAB_NAME").toString().equals("reports")) {
                    tabProps.put("TAB_URL", "reports");
                    reportUIMap = TabConfigHandler.getReportUICategories(null, new Integer(1), tabPriorityId, request);
                    tabProps.put("quickLinks", reportUIMap);
                    quickLinks.put(tabRow.get("TAB_NAME").toString(), reportUIMap);
                }
                if (tabRow.get("TAB_NAME").toString().equals("fileAudit")) {
                    tabProps.put("TAB_URL", "fileaudit");
                    reportUIMap = TabConfigHandler.getReportUICategories(null, new Integer(2), tabPriorityId, request);
                    tabProps.put("quickLinks", reportUIMap);
                    quickLinks.put(tabRow.get("TAB_NAME").toString(), reportUIMap);
                }
                if (tabRow.get("TAB_NAME").toString().equals("serverAudit")) {
                    tabProps.put("TAB_URL", "serveraudit");
                    reportUIMap = TabConfigHandler.getReportUICategories(null, new Integer(3), tabPriorityId, request);
                    tabProps.put("quickLinks", reportUIMap);
                    quickLinks.put(tabRow.get("TAB_NAME").toString(), reportUIMap);
                }
                if (tabRow.get("TAB_NAME").toString().equals("alert")) {
                    tabProps.put("TAB_URL", "alerts");
                }
                if (tabRow.get("TAB_NAME").toString().equals("adManagement")) continue;
                tabsList.add(tabProps);
                if (i != 0) continue;
                HashMap<String, Object> defaultTab = new HashMap<String, Object>();
                defaultTab.put("routeName", tabProps.get("TAB_URL"));
                defaultRouteDetails.put("defaultTab", defaultTab);
            }
            retMap.put("tabList", tabsList);
            logger.log(Level.INFO, " The Tabs List : " + tabsList);
            HashMap<String, Object> reportsRoute = new HashMap<String, Object>();
            reportsRoute.put("routeName", "reports.report");
            reportsRoute.put("modelId", authObject.getDefaultReport());
            defaultRouteDetails.put("reports", reportsRoute);
            HashMap<String, String> file = new HashMap<String, String>();
            file.put("routeName", "fileaudit.home");
            defaultRouteDetails.put("fileaudit", file);
            String pattern = "AUDReports:audit_report_id:10801";
            Long reportId = ReportUtil.getDefaultSAReportId((HttpSession)session, (Long)3L, (String)"AUDReports:audit_report_id:10801");
            HashMap<String, Object> server = new HashMap<String, Object>();
            server.put("routeName", "serveraudit.report");
            server.put("modelId", reportId);
            defaultRouteDetails.put("serveraudit", server);
            HashMap<String, String> alerts = new HashMap<String, String>();
            alerts.put("routeName", "alerts.viewalerts");
            alerts.put("modelId", "All");
            defaultRouteDetails.put("alerts", alerts);
            HashMap config = new HashMap();
            config.put("routeName", authObject.configDefaultRoute.get("routeName"));
            config.put("modelId", authObject.configDefaultRoute.get("modelId"));
            defaultRouteDetails.put("config", config);
            HashMap admin = new HashMap();
            admin.put("routeName", authObject.adminDefaultRoute.get("routeName"));
            admin.put("modelId", authObject.adminDefaultRoute.get("modelId"));
            defaultRouteDetails.put("admin", admin);
            HashMap<String, String> searchArchive = new HashMap<String, String>();
            searchArchive.put("routeName", "admin.search-archived-events.index-files");
            defaultRouteDetails.put("search-archived-events", searchArchive);
            retMap.put("defaultRouteDetails", defaultRouteDetails);
            retMap.put("isDemo", CommonUtil.isDemo());
            retMap.put("quickLinks", quickLinks);
            retMap.put("jumpToEntries", this.getJumpToEntries(request));
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(retMap));
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Exception while getting Tab List", ex);
            ex.printStackTrace();
        }
    }

    private JSONObject getJumpToEntries(HttpServletRequest request) {
        JSONObject jumpToEntries = new JSONObject();
        JSONArray productArray = new JSONArray();
        try {
            JSONObject integratedProducts = JumpToHandler.getProductSettingsWOP((HttpServletRequest)request);
            Iterator it = integratedProducts.keys();
            ArrayList<String> list = new ArrayList<String>();
            while (it.hasNext()) {
                list.add((String)it.next());
            }
            Collections.sort(list);
            it = list.iterator();
            boolean isAnyProductIntegrated = false;
            while (it.hasNext()) {
                String key = (String)it.next();
                JSONObject settings = integratedProducts.getJSONObject(key);
                String isIntegrated = settings.has("IS_INTEGRATED") ? settings.getString("IS_INTEGRATED") : "false";
                productArray.put((Object)settings);
                if (!isIntegrated.equals("true") || isAnyProductIntegrated) continue;
                isAnyProductIntegrated = true;
            }
            jumpToEntries.put("isAnyProductIntegrated", isAnyProductIntegrated);
            jumpToEntries.put("productArray", (Object)productArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jumpToEntries;
    }

    public void updateNotifications(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            PolicyHandler ph;
            boolean auditDDCPolicyState;
            HttpSession session = request.getSession();
            ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
            ArrayList userActions = authObject.getUserActins();
            boolean authizeCheck = request.isUserInRole("Admin");
            String licenseType = LicenseUtil.getLicenseType();
            Long expiryDays = LicenseUtil.getExpiryDays();
            JSONObject notificationDetails = new JSONObject();
            if (!WrapperUtil.isInstalledAsService()) {
                notificationDetails.put("showNotification", true);
                notificationDetails.put("serviceNotInstalled", true);
            }
            if (!EventErrorAlert.isAlertMailConfigured() && userActions.contains(TDConstants.ALERT_ME)) {
                notificationDetails.put("showNotification", true);
                notificationDetails.put("alertMailNotConfigured", true);
            }
            if (!CommonUtil.isArchiveConfigured() && userActions.contains(TDConstants.ARCHIVE_EVENTS)) {
                notificationDetails.put("showNotification", true);
                notificationDetails.put("archiveNotConfigured", true);
            }
            Hashtable diskSettings = ConfigureDiskSpace.isLowDiskSpace();
            notificationDetails.put("showLowDiskSpaceMsg", false);
            if (!diskSettings.isEmpty()) {
                notificationDetails.put("showNotification", true);
                notificationDetails.put("showLowDiskSpaceMsg", true);
                notificationDetails.put("lowDiskSpace", (Object)(rb.getString("adap.disk_space_alert.alert_text.available_free_space") + " " + diskSettings.get("FREE_DISK_SPACE") + " MB,"));
                notificationDetails.put("lowDiskSpace2", (Object)(rb.getString("adap.tab.disk_space.alert_text_threshold") + " " + diskSettings.get("CONFIGURE_SPACE") + " MB."));
            }
            String domainName = DomainDetailsAPI.getDefaultDomainName();
            boolean privilegeState = DomainDetailsAPI.isDomainPrivileged((String)domainName);
            notificationDetails.put("showAuthMsg", false);
            if (!privilegeState && !domainName.equals("")) {
                notificationDetails.put("showNotification", true);
                notificationDetails.put("authMessage", (Object)(rb.getString("adap.authentication.fetching_events.status_msg.providing_user_name_and_password") + domainName));
                notificationDetails.put("showAuthMsg", true);
                JSONObject domainDetails = DomainHandler.getDomainDetails((String)domainName);
                notificationDetails.put("domainName", (Object)domainDetails.getString("DOMAIN_NAME"));
                notificationDetails.put("userDistinguishedName", (Object)domainDetails.optString("USER_DISTINGUISHED_NAME"));
                notificationDetails.put("password", (Object)domainDetails.optString("PASSWORD"));
                notificationDetails.put("userName", (Object)domainDetails.optString("USER_NAME"));
                notificationDetails.put("isAuthenticationRequired", (Object)domainDetails.getString("IS_AUTHENTICATION_REQUIRED"));
            }
            if (!(auditDDCPolicyState = (ph = new PolicyHandler()).getDefaultAuditPolicy("{6AC1786C-016F-11D2-945F-00C04fB984F9}", false)) && !domainName.equals("")) {
                notificationDetails.put("showNotification", true);
                notificationDetails.put("policyMessage", (Object)(rb.getString("adap.domain_settings.view_domain.status_msg.ddcp_and_ddp") + " " + rb.getString("adap_application_not_conifgured_for") + " " + domainName));
            }
            if (licenseType.equals("F")) {
                notificationDetails.put("freeVersion", true);
            } else if (licenseType.equals("T") && authizeCheck) {
                notificationDetails.put("trialVersion", true);
            } else if (licenseType.equals("R") && authizeCheck && expiryDays != 0L) {
                notificationDetails.put("expiryDays", (Object)expiryDays);
            }
            notificationDetails.put("licenseType", (Object)licenseType);
            ret.put("notificationDetails", (Object)notificationDetails);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public void getQuickLinks(HttpServletRequest request, HttpServletResponse response) {
        HashMap<Object, Object> retMap = new HashMap<Object, Object>();
        try {
            HttpSession session = request.getSession();
            ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
            ArrayList userActions = authObject.getUserActins();
            HashMap aaaDetails = (HashMap)session.getAttribute("AAA_DETAILS");
            ArrayList availableTabs = (ArrayList)aaaDetails.get("AVAILABLE_TABS");
            HashMap<String, ArrayList<HashMap<String, Object>>> quickLinks = new HashMap<String, ArrayList<HashMap<String, Object>>>();
            for (int i = 0; i < availableTabs.size(); ++i) {
                ArrayList<HashMap<String, Object>> reportUIMap;
                Map tabRow = (Map)availableTabs.get(i);
                Integer tabPriorityId = i;
                if (tabRow.get("TAB_NAME").toString().equals("reports")) {
                    reportUIMap = TabConfigHandler.getReportUICategories(null, new Integer(1), tabPriorityId, request);
                    quickLinks.put(tabRow.get("TAB_NAME").toString(), reportUIMap);
                }
                if (tabRow.get("TAB_NAME").toString().equals("fileAudit")) {
                    reportUIMap = TabConfigHandler.getReportUICategories(null, new Integer(2), tabPriorityId, request);
                    quickLinks.put(tabRow.get("TAB_NAME").toString(), reportUIMap);
                }
                if (!tabRow.get("TAB_NAME").toString().equals("serverAudit")) continue;
                reportUIMap = TabConfigHandler.getReportUICategories(null, new Integer(3), tabPriorityId, request);
                quickLinks.put(tabRow.get("TAB_NAME").toString(), reportUIMap);
            }
            retMap.put("quickLinks", quickLinks);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(retMap));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList<HashMap<String, Object>> getReportUICategories(String domainName, Integer categoryType, Integer tabId, HttpServletRequest request) {
        LinkedHashMap<Long, JSONObject> reportUIMap = new LinkedHashMap<Long, JSONObject>();
        JSONArray reportList = new JSONArray();
        ArrayList<HashMap<String, Object>> ll1 = new ArrayList<HashMap<String, Object>>();
        try {
            ADAPAuthObject authObject = (ADAPAuthObject)request.getSession().getAttribute("ADAP_AUTH_OBJ");
            ArrayList actionList = authObject.getUserActins();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportMap = TabConfigHandler.getReportCategories(domainName, categoryType, tabId, request);
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDReportUICategories"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDReportUICategories", (String)"*"));
            selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)"AUDReportUICategories", (String)"REPORT_UI_CATEGORY_ID"), true));
            selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)"AUDReportUICategories", (String)"PRIORITY_ID"), true));
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDReportUICategories", (String)"REPORT_CATEGORY_TYPE"), (Object)categoryType, 0);
            selectQuery.setCriteria(criteria);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)selectQuery);
            JSONObject categoryUIMap = null;
            Iterator iterator = dataObject.getRows("AUDReportUICategories");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Long uIId = (Long)row.get("REPORT_UI_CATEGORY_ID");
                String uiName = rb.getString((String)row.get("REPORT_UI_CATEGORY_NAME"));
                if (reportUIMap.get(uIId) == null) {
                    if (uIId != 2L && uIId != 8L && uIId != 11L && uIId != 10L) {
                        categoryUIMap = new JSONObject();
                        reportList.put((Object)categoryUIMap);
                    }
                } else {
                    categoryUIMap = (JSONObject)reportUIMap.remove(uIId);
                }
                categoryUIMap.put("REPORT_UI_CATEGORY_ID", (Object)uIId);
                categoryUIMap.put("REPORT_UI_CATEGORY_NAME", (Object)uiName);
                JSONArray categoryMap = new JSONArray();
                if (categoryUIMap.has("UI_CATEGORIES") && categoryUIMap.get("UI_CATEGORIES") != null) {
                    categoryMap = (JSONArray)categoryUIMap.get("UI_CATEGORIES");
                }
                if (uIId == 5L) {
                    categoryMap = TabConfigHandler.getComplianceReports(tabId, actionList, rb);
                } else if (uIId == 1L || uIId == 7L) {
                    categoryMap.put((Object)TabConfigHandler.getCumulativeReports(uIId, categoryType, actionList, tabId, rb));
                } else if (uIId == 6L || uIId == 16L || uIId == 17L) {
                    categoryMap = TabConfigHandler.getInstance().getQuickLinksMyReports(request, tabId);
                } else if (reportMap.has(row.get("CATEGORY_ID").toString()) && reportMap.get(row.get("CATEGORY_ID").toString()) != null) {
                    categoryMap.put(reportMap.get(row.get("CATEGORY_ID").toString()));
                }
                if (uIId == 2L || uIId == 8L || uIId == 11L || uIId == 10L) continue;
                categoryUIMap.put("UI_CATEGORIES", (Object)categoryMap);
                reportUIMap.put(uIId, categoryUIMap);
            }
            for (int i = 0; i < reportList.length(); ++i) {
                HashMap<String, Object> mm1 = new HashMap<String, Object>();
                JSONObject m1 = (JSONObject)reportList.get(i);
                JSONArray l1 = (JSONArray)m1.get("UI_CATEGORIES");
                String s1 = (String)m1.get("REPORT_UI_CATEGORY_NAME");
                mm1.put("name", s1);
                if (i == 0 || i == 1) {
                    mm1.put("menuAlign", "pull-left");
                } else {
                    mm1.put("menuAlign", "pull-center");
                }
                ArrayList ll2 = new ArrayList();
                ArrayList ll3 = new ArrayList();
                for (int j = 0; j < l1.length(); ++j) {
                    HashMap<String, Object> mm3 = new HashMap<String, Object>();
                    HashMap<String, String> mm4 = new HashMap<String, String>();
                    JSONObject m2 = (JSONObject)l1.get(j);
                    if (!m2.has("NAME")) continue;
                    String s2 = (String)m2.get("NAME");
                    Object rcId = m2.get("REPORT_CATEGORY_ID");
                    if (rcId instanceof Long) {
                        rcId = rcId.toString();
                    }
                    if (rcId != null) {
                        mm4.put("rch", "#quickLinksId" + rcId.toString());
                        mm4.put("rcId", "quickLinksId" + rcId.toString());
                    }
                    mm4.put("name", s2);
                    ll2.add(mm4);
                    mm3.put("name", s2);
                    JSONArray l2 = (JSONArray)m2.get("CATEGORY_REPORTS");
                    ArrayList<JSONObject> listdata = new ArrayList<JSONObject>();
                    if (l2 != null) {
                        for (int m = 0; m < l2.length(); ++m) {
                            listdata.add((JSONObject)l2.get(m));
                        }
                    }
                    ArrayList parts = new ArrayList();
                    int N = listdata.size();
                    int L = 5;
                    for (int k = 0; k < N; k += 5) {
                        parts.add(new ArrayList(listdata.subList(k, Math.min(N, k + 5))));
                    }
                    mm3.put("list", parts);
                    if (rcId != null) {
                        mm3.put("rcId", "quickLinksId" + rcId.toString());
                    }
                    ll3.add(mm3);
                }
                if (ll3.size() == 0) {
                    mm1.put("isEmpty", true);
                }
                if (ll3.isEmpty()) continue;
                mm1.put("list", ll3);
                mm1.put("topList", ll2);
                ll1.add(mm1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ll1;
    }

    public static JSONObject getReportCategories(String domainName, Integer categoryType, Integer tabId, HttpServletRequest request) {
        JSONObject reportMap = new JSONObject();
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)request.getSession().getAttribute("ADAP_SESSION_LOGIN_ID");
            ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
            ArrayList actionList = authObject.getUserActins();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDReportCategories"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDReportCategories", (String)"*"));
            ArrayList idList = AuditReportCategoryHandler.getExcludedReportCategoryIds();
            Integer[] categoryIds = idList.toArray(new Integer[idList.size()]);
            Criteria c = new Criteria(new Column("AUDReportCategories", "REPORT_CATEGORY_ID"), (Object)categoryIds, 9);
            selectQuery.setCriteria(c);
            selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)"AUDReportCategories", (String)"PRIORITY"), true));
            Criteria crit = new Criteria(Column.getColumn((String)"AUDReportCategories", (String)"ACTION_ID"), (Object)actionList.toArray(), 8);
            crit = crit.or(new Criteria(Column.getColumn((String)"AUDReportCategories", (String)"ACTION_ID"), null, 0));
            selectQuery.setCriteria(crit);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)selectQuery);
            boolean isFIMEnabled = domainName != null ? FileIntegrityManager.getInstance().isFIMEnabledInDomain(domainName) : false;
            Iterator iterator = dataObject.getRows("AUDReportCategories");
            while (iterator.hasNext()) {
                JSONObject reportCategoriesMap = new JSONObject();
                Row row = (Row)iterator.next();
                Long reportCategoryId = (Long)row.get("REPORT_CATEGORY_ID");
                reportCategoriesMap.put("REPORT_CATEGORY_ID", (Object)reportCategoryId.toString());
                reportCategoriesMap.put("NAME", (Object)rb.getString((String)row.get("NAME")));
                reportCategoriesMap.put("SR_NAME", (Object)rb.getString((String)row.get("SR_NAME")));
                if (reportCategoryId == 1L) {
                    HashMap loginUserDetails = authObject.getLoginUserDetails();
                    String delegatedDomain = null;
                    if (!"All Domains".equals((String)loginUserDetails.get("DELEGATED_DOMAIN"))) {
                        delegatedDomain = (String)loginUserDetails.get("DELEGATED_DOMAIN");
                    }
                    reportCategoriesMap.put("CATEGORY_REPORTS", (Object)AuditReportCategoryHandler.getMonitorReports((Integer)categoryType, (Integer)tabId, (AdventNetResourceBundle)rb, (String)delegatedDomain, (Boolean)true));
                } else if (reportCategoryId == 7L) {
                    Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
                    hashtable.put("IS_CUSTOM_PROFILE", true);
                    reportCategoriesMap.put("CATEGORY_REPORTS", (Object)AuditReportCategoryHandler.getMonitorReports((Integer)categoryType, hashtable, (AdventNetResourceBundle)rb, (Long)loginId));
                } else if (reportCategoryId == 20L) {
                    if (isFIMEnabled && categoryType == null || categoryType != null) {
                        reportCategoriesMap.put("CATEGORY_REPORTS", (Object)AuditReportCategoryHandler.getCategoryReports((Long)reportCategoryId, (Integer)categoryType, (AdventNetResourceBundle)rb, (Long)loginId, (ArrayList)actionList));
                    } else {
                        reportCategoriesMap.put("CATEGORY_REPORTS", new ArrayList());
                    }
                } else {
                    reportCategoriesMap.put("CATEGORY_REPORTS", (Object)AuditReportCategoryHandler.getCategoryReports((Long)reportCategoryId, (Integer)categoryType, (AdventNetResourceBundle)rb, (Long)loginId, (ArrayList)actionList));
                }
                reportMap.put(reportCategoryId.toString(), (Object)reportCategoriesMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reportMap;
    }

    public JSONArray getQuickLinksMyReports(HttpServletRequest request, Integer tabId) throws Exception {
        JSONArray myReports = new JSONArray();
        HttpSession session = request.getSession();
        JSONObject jsonObj = MyFavRepHandler.getDataSource();
        ArrayList list = (ArrayList)jsonObj.get("repObj");
        ArrayList categoryList = (ArrayList)jsonObj.get("catObj");
        ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        ArrayList userActions = authObject.getUserActins();
        if (list.size() > 0 && userActions.contains(TDConstants.MY_REPORTS)) {
            HashMap details = authObject.getLoginUserDetails();
            String delegetedDomain = (String)details.get("DELEGATED_DOMAIN");
            JSONObject map1 = new JSONObject();
            JSONObject map2 = null;
            JSONArray reportList = null;
            for (int i = 0; i < list.size(); ++i) {
                JSONObject reportObj = (JSONObject)list.get(i);
                int productId = reportObj.getInt("PRODUCT_ID");
                Long categoryId = reportObj.getLong("CATEGORY_ID");
                if (productId != 3) continue;
                if (map1.has(categoryId.toString()) && map1.get(categoryId.toString()) != null) {
                    map2 = (JSONObject)map1.get(categoryId.toString());
                } else {
                    map2 = new JSONObject();
                    myReports.put((Object)map2);
                    for (int j = 0; j < categoryList.size(); ++j) {
                        JSONObject categoryMap = (JSONObject)categoryList.get(j);
                        if (categoryMap.getLong("CATEGORY_ID") != categoryId.longValue()) continue;
                        map2.put("NAME", (Object)categoryMap.getString("CATEGORY_NAME"));
                        break;
                    }
                }
                map2.put("REPORT_CATEGORY_ID", (Object)(tabId + "_" + categoryId));
                reportList = map2.has("CATEGORY_REPORTS") && map2.get("CATEGORY_REPORTS") != null ? (JSONArray)map2.get("CATEGORY_REPORTS") : new JSONArray();
                JSONObject params = (JSONObject)reportObj.get("param");
                String domainName = params.getString("domainName");
                if (!delegetedDomain.equals("All Domains") && !delegetedDomain.contains(domainName)) continue;
                JSONObject myReport = new JSONObject();
                myReport.put("name", (Object)reportObj.getString("DISPLAY_NAME"));
                myReport.put("modelId", params.getLong("reportId"));
                myReport.put("favRepId", params.getLong("favRepId"));
                myReport.put("isCustomizable", true);
                if (params.getString("selectedTab").equals("reports")) {
                    myReport.put("routeName", (Object)"reports.report");
                } else if (params.getString("selectedTab").equals("fileAudit")) {
                    myReport.put("routeName", (Object)"fileaudit.report");
                } else {
                    myReport.put("routeName", (Object)"serveraudit.report");
                }
                reportList.put((Object)myReport);
                map2.put("CATEGORY_REPORTS", (Object)reportList);
                map1.put(categoryId.toString(), (Object)map2);
            }
        }
        return myReports;
    }

    private static JSONArray getComplianceReports(Integer tabId, ArrayList<Long> actionList, AdventNetResourceBundle rb) throws Exception {
        Table complianceTable = Table.getTable((String)"AUDComplianceReportMapping");
        Table reportsTable = Table.getTable((String)"AUDReports");
        SelectQueryImpl selectQuery = new SelectQueryImpl(complianceTable);
        Join innerJoin = new Join(complianceTable, reportsTable, new String[]{"AUDIT_REPORT_ID"}, new String[]{"AUDIT_REPORT_ID"}, 2);
        selectQuery.addJoin(innerJoin);
        selectQuery.addSelectColumn(Column.getColumn((String)"AUDComplianceReportMapping", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"AUDReports", (String)"*"));
        selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)"AUDComplianceReportMapping", (String)"COMPLIANCE_ID"), true));
        selectQuery.setCriteria(new Criteria(Column.getColumn((String)"AUDReports", (String)"ACTION_ID"), (Object)actionList.toArray(), 8));
        DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)selectQuery);
        JSONObject complianceMap = new JSONObject();
        JSONObject complianceDetailsMap = null;
        JSONArray complianceList = new JSONArray();
        JSONArray reportList = null;
        Iterator iterator = dataObject.getRows("AUDComplianceReportMapping");
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            Long complianceId = (Long)row.get("COMPLIANCE_ID");
            String complianceName = (String)row.get("COMPLIANCE_NAME");
            Long reportId = (Long)row.get("AUDIT_REPORT_ID");
            String section = (String)row.get("SECTION");
            String description = rb.getString((String)row.get("DESCRIPTION"));
            if (complianceMap.has(complianceId.toString()) && complianceMap.get(complianceId.toString()) != null) {
                complianceDetailsMap = (JSONObject)complianceMap.get(complianceId.toString());
            } else {
                complianceDetailsMap = new JSONObject();
                complianceList.put((Object)complianceDetailsMap);
            }
            complianceDetailsMap.put("REPORT_CATEGORY_ID", (Object)(complianceId + "_" + reportId));
            complianceDetailsMap.put("NAME", (Object)complianceName);
            reportList = complianceDetailsMap.has("CATEGORY_REPORTS") && complianceDetailsMap.get("CATEGORY_REPORTS") != null ? (JSONArray)complianceDetailsMap.get("CATEGORY_REPORTS") : new JSONArray();
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0);
            Row reportRow = dataObject.getRow("AUDReports", criteria);
            JSONObject reportMap = new JSONObject();
            reportMap.put("SECTION", (Object)section);
            reportMap.put("DESCRIPTION", (Object)description);
            reportMap.put("AUDIT_REPORT_NAME", (Object)rb.getString((String)reportRow.get("AUDIT_REPORT_NAME")));
            reportMap.put("AUDIT_REPORT_ID", (Object)((Long)reportRow.get("AUDIT_REPORT_ID")));
            reportMap.put("PRIORITY", reportRow.get("PRIORITY"));
            reportMap.put("REPORT_CATEGORY_TYPE", (Object)((Integer)reportRow.get("REPORT_CATEGORY_TYPE")));
            reportMap.put("IS_CUSTOMIZABLE", reportRow.get("IS_CUSTOMIZABLE"));
            reportMap.put("modelId", (Object)((Long)row.get("AUDIT_REPORT_ID")));
            reportMap.put("name", (Object)rb.getString((String)reportRow.get("AUDIT_REPORT_NAME")));
            if ((Integer)reportRow.get("REPORT_CATEGORY_TYPE") == 2) {
                reportMap.put("routeName", (Object)"fileaudit.report");
            } else if ((Integer)reportRow.get("REPORT_CATEGORY_TYPE") == 3) {
                reportMap.put("routeName", (Object)"serveraudit.report");
            } else {
                reportMap.put("routeName", (Object)"reports.report");
            }
            reportList.put((Object)reportMap);
            complianceDetailsMap.put("CATEGORY_REPORTS", (Object)reportList);
            complianceMap.put(complianceId.toString(), (Object)complianceDetailsMap);
        }
        return complianceList;
    }

    private static JSONObject getCumulativeReports(Long uiID, Integer categoryType, ArrayList<Long> actionList, Integer tabId, AdventNetResourceBundle rb) throws Exception {
        Table reportsTable = Table.getTable((String)"AUDReports");
        SelectQueryImpl selectQuery = new SelectQueryImpl(reportsTable);
        selectQuery.addSelectColumn(Column.getColumn((String)"AUDReports", (String)"*"));
        Criteria criteria = new Criteria(Column.getColumn((String)"AUDReports", (String)"IS_CUMULATIVE_REPORT"), (Object)true, 0);
        criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDReports", (String)"REPORT_CATEGORY_TYPE"), (Object)categoryType, 0));
        criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDReports", (String)"ACTION_ID"), (Object)actionList.toArray(), 8));
        selectQuery.setCriteria(criteria);
        DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)selectQuery);
        JSONObject cumulativeMap = new JSONObject();
        JSONArray list = new JSONArray();
        JSONObject cumulativeDetailsMap = new JSONObject();
        Iterator iterator = dataObject.getRows("AUDReports");
        while (iterator.hasNext()) {
            JSONObject reportMap = new JSONObject();
            Row row = (Row)iterator.next();
            reportMap.put("AUDIT_REPORT_ID", (Object)((Long)row.get("AUDIT_REPORT_ID")));
            reportMap.put("AUDIT_REPORT_NAME", (Object)rb.getString((String)row.get("AUDIT_REPORT_NAME")));
            reportMap.put("REPORT_CATEGORY_TYPE", (Object)((Integer)row.get("REPORT_CATEGORY_TYPE")));
            reportMap.put("name", (Object)rb.getString((String)row.get("AUDIT_REPORT_NAME")));
            reportMap.put("modelId", (Object)((Long)row.get("AUDIT_REPORT_ID")));
            if ((Integer)row.get("REPORT_CATEGORY_TYPE") == 2) {
                reportMap.put("routeName", (Object)"fileaudit.report");
            } else if ((Integer)row.get("REPORT_CATEGORY_TYPE") == 3) {
                reportMap.put("routeName", (Object)"serveraudit.report");
            } else {
                reportMap.put("routeName", (Object)"reports.report");
            }
            list.put((Object)reportMap);
            cumulativeDetailsMap.put("CATEGORY_REPORTS", (Object)list);
            cumulativeDetailsMap.put("NAME", (Object)rb.getString("adap.AUDReportUICategories.report_ui_category_name.CUMULATIVE_REPORTS"));
            cumulativeDetailsMap.put("REPORT_CATEGORY_ID", (Object)(((Long)row.get("REPORT_CATEGORY_ID")).toString() + "_" + uiID));
            cumulativeMap.put(uiID.toString(), (Object)cumulativeDetailsMap);
        }
        return cumulativeDetailsMap;
    }

    private static boolean isAD360Integrated() {
        try {
            if (com.manageengine.ads.fw.util.CommonUtil.isProductIntegrated((String)"ManageEngine ADManager Plus")) {
                RestAPIUtil.getAPIURL((String)"ManageEngine ADManager Plus", (String)"LOAD_DASHBOARD_CONTAINERS");
            }
        }
        catch (Exception e) {
            return false;
        }
        return com.manageengine.ads.fw.util.CommonUtil.isProductIntegrated((String)"ManageEngine AD360");
    }

    public void showLicenseDetails(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String licenseType = Validation.getInstance().getUserType();
        try {
            String numberOfcifsServer;
            Properties cifsServer;
            String numberOfFileServer;
            Properties fileServer;
            String numberOfMemberServer;
            Properties memberServer;
            String numberOfDomainController;
            Properties domainController;
            HashMap<String, Object> licenseData = new HashMap<String, Object>();
            Validation w = Validation.getInstance();
            String productName = w.getProductName();
            String productExpiryDate = w.getEvaluationExpiryDate();
            String licenseType1 = LicenseUtil.getLicenseTypeString();
            licenseType = w.getUserType();
            long noOfDays = w.getEvaluationDays();
            String productVersion = CommonUtil.getProductVersion();
            String licenseMsg = "";
            String upgradeMsg = "";
            String noOfDaysToGo = String.valueOf(noOfDays);
            String licensedTo = w.getCompanyName();
            boolean adminUser = true;
            if (adminUser) {
                request.setAttribute("adminUser", (Object)Boolean.TRUE);
            }
            if (licenseType != null && licenseType.equals("T")) {
                licenseType = rb.getString("adap.LicenseUpgradeAction.Evaluation_Edition__Trial_Version");
                licenseMsg = rb.handleGetObject("adap.LicenseUpgradeAction.You_are_using_", new String[]{licenseType});
                upgradeMsg = rb.getString("adap.LicenseUpgradeAction.Extend_your_trial_period_or");
                request.setAttribute("noOfDaysToGo", (Object)noOfDaysToGo);
                licenseData.put("noOfDaysToGo", noOfDaysToGo);
                domainController = Validation.getInstance().getModuleProperties("DomainController");
                numberOfDomainController = domainController.getProperty("NumberOfDomainControllers");
                request.setAttribute("numberOfDomainControllers", (Object)numberOfDomainController);
                licenseData.put("numberOfDomainControllers", numberOfDomainController);
                memberServer = Validation.getInstance().getModuleProperties("MemberServer");
                numberOfMemberServer = MSHandler.getLicenseCount((Integer)16).toString();
                if (memberServer != null) {
                    numberOfMemberServer = memberServer.getProperty("NumberOfMemberServers");
                }
                request.setAttribute("numberOfMemberServers", (Object)numberOfMemberServer);
                licenseData.put("numberOfMemberServers", numberOfMemberServer);
                fileServer = Validation.getInstance().getModuleProperties("FileServer");
                numberOfFileServer = MSHandler.getLicenseCount((Integer)4).toString();
                if (fileServer != null) {
                    numberOfFileServer = fileServer.getProperty("NumberOfFileServers");
                }
                request.setAttribute("numberOfFileServers", (Object)numberOfFileServer);
                licenseData.put("numberOfFileServers", numberOfFileServer);
                cifsServer = Validation.getInstance().getModuleProperties("CIFSServer");
                numberOfcifsServer = MSHandler.getLicenseCount((Integer)256).toString();
                if (cifsServer != null) {
                    numberOfcifsServer = cifsServer.getProperty("NumberOfCIFSServers");
                }
                request.setAttribute("numberOfCIFSServers", (Object)numberOfcifsServer);
                licenseData.put("numberOfCIFSServers", numberOfcifsServer);
                Properties workStation = Validation.getInstance().getModuleProperties("WorkStation");
                String numberOfWorkStations = MSHandler.getLicenseCount((Integer)new Integer(4096)).toString();
                if (workStation != null) {
                    numberOfWorkStations = workStation.getProperty("NumberOfWorkStations");
                }
                logger.log(Level.INFO, "number of workstations " + numberOfWorkStations);
                request.setAttribute("numberOfWorkStations", (Object)numberOfWorkStations);
                licenseData.put("numberOfWorkStations", numberOfWorkStations);
            } else if (licenseType != null && licenseType.equals("F")) {
                licenseType = rb.getString("adap.LicenseUpgradeAction.Free_Edition");
                noOfDaysToGo = rb.getString("adap.LicenseUpgradeAction.Never");
                licenseMsg = rb.handleGetObject("adap.LicenseUpgradeAction.You_are_using__licenseType", new String[]{licenseType, noOfDaysToGo});
                upgradeMsg = rb.getString("adap.LicenseUpgradeAction._Upgrade_to_Professional_Edition");
                domainController = Validation.getInstance().getModuleProperties("DomainController");
                numberOfDomainController = domainController.getProperty("NumberOfDomainControllers");
                request.setAttribute("numberOfDomainControllers", (Object)numberOfDomainController);
                licenseData.put("numberOfDomainControllers", numberOfDomainController);
                memberServer = Validation.getInstance().getModuleProperties("MemberServer");
                numberOfMemberServer = "0";
                if (memberServer != null) {
                    numberOfMemberServer = memberServer.getProperty("NumberOfMemberServers");
                }
                request.setAttribute("numberOfMemberServers", (Object)numberOfMemberServer);
                licenseData.put("numberOfMemberServers", numberOfMemberServer);
                fileServer = Validation.getInstance().getModuleProperties("FileServer");
                numberOfFileServer = "0";
                if (fileServer != null) {
                    numberOfFileServer = fileServer.getProperty("NumberOfFileServers");
                }
                request.setAttribute("numberOfFileServers", (Object)numberOfFileServer);
                licenseData.put("numberOfFileServers", numberOfFileServer);
                cifsServer = Validation.getInstance().getModuleProperties("CIFSServer");
                numberOfcifsServer = "0";
                if (cifsServer != null) {
                    numberOfcifsServer = cifsServer.getProperty("NumberOfCIFSServers");
                }
                request.setAttribute("numberOfCIFSServers", (Object)numberOfcifsServer);
                licenseData.put("numberOfCIFSServers", numberOfcifsServer);
                Properties workStation = Validation.getInstance().getModuleProperties("WorkStation");
                String numberOfWorkStations = "0";
                if (workStation != null) {
                    numberOfWorkStations = workStation.getProperty("NumberOfWorkStations");
                }
                request.setAttribute("numberOfWorkStations", (Object)numberOfWorkStations);
                licenseData.put("numberOfWorkStations", numberOfWorkStations);
                logger.log(Level.INFO, "number of workstations " + numberOfWorkStations);
            } else if (licenseType != null && licenseType.equals("R")) {
                licenseType = rb.handleGetObject("adap.LicenseUpgradeAction.licenseType1___Registered_Version", new String[]{licenseType1});
                licenseMsg = rb.handleGetObject("adap.LicenseUpgradeAction.You_are_using__licenseType", new String[]{licenseType, productExpiryDate});
                domainController = Validation.getInstance().getModuleProperties("DomainController");
                numberOfDomainController = domainController.getProperty("NumberOfDomainControllers");
                memberServer = Validation.getInstance().getModuleProperties("MemberServer");
                numberOfMemberServer = MSHandler.getLicenseCount((Integer)16).toString();
                if (memberServer != null) {
                    numberOfMemberServer = memberServer.getProperty("NumberOfMemberServers");
                }
                request.setAttribute("numberOfMemberServers", (Object)numberOfMemberServer);
                licenseData.put("numberOfMemberServers", numberOfMemberServer);
                fileServer = Validation.getInstance().getModuleProperties("FileServer");
                numberOfFileServer = MSHandler.getLicenseCount((Integer)4).toString();
                if (fileServer != null) {
                    numberOfFileServer = fileServer.getProperty("NumberOfFileServers");
                }
                request.setAttribute("numberOfFileServers", (Object)numberOfFileServer);
                licenseData.put("numberOfFileServers", numberOfFileServer);
                cifsServer = Validation.getInstance().getModuleProperties("CIFSServer");
                numberOfcifsServer = MSHandler.getLicenseCount((Integer)256).toString();
                if (cifsServer != null && numberOfcifsServer.equals("0")) {
                    numberOfcifsServer = cifsServer.getProperty("NumberOfCIFSServers");
                }
                request.setAttribute("numberOfCIFSServers", (Object)numberOfcifsServer);
                licenseData.put("numberOfCIFSServers", numberOfcifsServer);
                Properties workStation = Validation.getInstance().getModuleProperties("WorkStation");
                String numberOfWorkStations = MSHandler.getLicenseCount((Integer)new Integer(4096)).toString();
                if (workStation != null) {
                    numberOfWorkStations = workStation.getProperty("NumberOfWorkStations");
                }
                request.setAttribute("numberOfWorkStations", (Object)numberOfWorkStations);
                licenseData.put("numberOfWorkStations", numberOfWorkStations);
                logger.log(Level.INFO, "number of workstations " + numberOfWorkStations);
                Calendar cal = Calendar.getInstance();
                StringTokenizer stt = new StringTokenizer(productExpiryDate, " ");
                if (stt.countTokens() == 3) {
                    int yyyy = Integer.parseInt(stt.nextToken());
                    int mm = Integer.parseInt(stt.nextToken());
                    int dd = Integer.parseInt(stt.nextToken());
                    cal.set(yyyy, mm, dd);
                    SimpleDateFormat sdf = new SimpleDateFormat("MMM dd, yyyy");
                    productExpiryDate = sdf.format(cal.getTime());
                }
                request.setAttribute("productExpiryDate", (Object)productExpiryDate);
                licenseData.put("productExpiryDate", productExpiryDate);
                request.setAttribute("licensedTo", (Object)licensedTo);
                licenseData.put("licensedTo", licensedTo);
                request.setAttribute("numberOfDomainControllers", (Object)numberOfDomainController);
                licenseData.put("numberOfDomainControllers", numberOfDomainController);
            }
            String isDemoMode = String.valueOf(CommonUtil.isDemo());
            request.setAttribute("isDemoMode", (Object)isDemoMode);
            if (isDemoMode.equals("true")) {
                request.setAttribute("demoModeMessage", (Object)"Running in restricted Mode");
            }
            int configuredDCCount = EventSchedulerUtil.getEnabledEventSchedulerCount();
            int configuredMSCount = ServerConfigAPI.getConfiguredServerCount((int[])new int[]{16});
            configuredMSCount += ServerConfigAPI.getPrintServerCount() - ServerConfigAPI.getPrintMemberServerCount((int)16);
            int configuredFSCount = ServerConfigAPI.getConfiguredServerCount((int[])new int[]{4, 64});
            int configuredCIFSCount = ServerConfigAPI.getConfiguredServerCount((int[])new int[]{256, 131072, 524288});
            int configuredWSCount = ServerConfigAPI.getConfiguredServerCount((int[])new int[]{4096});
            licenseData.put("configuredDCCount", configuredDCCount);
            licenseData.put("configuredMSCount", configuredMSCount);
            licenseData.put("configuredFSCount", configuredFSCount);
            licenseData.put("configuredCIFSCount", configuredCIFSCount);
            licenseData.put("configuredWSCount", configuredWSCount);
            request.setAttribute("licenseType", (Object)licenseType);
            request.setAttribute("licenseMsg", (Object)licenseMsg);
            request.setAttribute("upgradeMsg", (Object)upgradeMsg);
            request.setAttribute("productName", (Object)productName);
            request.setAttribute("productVersion", (Object)productVersion);
            String arch = System.getProperty("os.arch");
            if (arch.equalsIgnoreCase("x86")) {
                licenseData.put("architecture", "32 bit");
            } else {
                licenseData.put("architecture", "64 bit");
            }
            request.setAttribute("buildNumber", (Object)CommonUtil.getBuildNumber());
            licenseData.put("licenseType", licenseType);
            licenseData.put("licenseMsg", licenseMsg);
            licenseData.put("productName", productName);
            licenseData.put("productVersion", productVersion);
            licenseData.put("upgradeMsg", upgradeMsg);
            licenseData.put("buildNumber", CommonUtil.getBuildNumber());
            HashMap<String, HashMap<String, Object>> returnListMap = new HashMap<String, HashMap<String, Object>>();
            returnListMap.put("licenseData", licenseData);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.log(Level.WARNING, "Exception while loading upgrade license page ", ex);
        }
    }

    public void deleteReport(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String msgTxt = rb.getString("adap.DeleteCustomReport.Reports_Deleted_Successfully");
        boolean msgType = true;
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject customReportParams = null;
            customReportParams = reportReqData.getJSONObject("inputParams");
            Long reportId = customReportParams.getLong("reportId");
            MyFavRepHandler.deleteReport((String)Long.toString(reportId));
        }
        catch (Exception ex) {
            msgType = false;
            msgTxt = rb.getString("adap.DeleteCustomReport.Reports_Deleted_failed");
            ex.printStackTrace();
        }
        JSONObject returnListMap = new JSONObject();
        returnListMap.put("msgTxt", (Object)msgTxt);
        returnListMap.put("msgType", msgType);
        JsonResponse.getInstance().sendResponse(response, returnListMap.toString());
    }
}

