/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.config;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.common.EmberTableConfig;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.report.ReportHandlerUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.serveraudit.ServerConfigHandler;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.APIUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.objects.ObjectUpdateHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class ADObjectModalHandler {
    private static volatile ADObjectModalHandler instance = null;
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static Logger logger = Logger.getLogger(ADObjectModalHandler.class.getName());
    private static String ldapQuery = "";
    private static String base_DN = "";
    Long cvIDD = 0L;
    private static Long generationId = 0L;
    private String objClass = "";
    private static Long ldapQueryId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:15");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ADObjectModalHandler getInstance() {
        if (instance != null) return instance;
        Class<ADObjectModalHandler> clazz = ADObjectModalHandler.class;
        synchronized (ADObjectModalHandler.class) {
            if (instance != null) return instance;
            instance = new ADObjectModalHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ADObjectModalHandler() {
    }

    public ObjectClass setObjClass() {
        ObjectClass dirObjectClass = null;
        if (ldapQuery.toLowerCase().indexOf("objectcategory=person") != -1 && ldapQuery.toLowerCase().indexOf("objectclass=user") != -1) {
            dirObjectClass = DirectoryObjectAPI.getInstance().getObjectClass("user");
            this.objClass = "user";
            this.cvIDD = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:1");
        } else if (ldapQuery.toLowerCase().indexOf("objectcategory=group") != -1 || ldapQuery.toLowerCase().indexOf("objectclass=group") != -1) {
            dirObjectClass = DirectoryObjectAPI.getInstance().getObjectClass("group");
            this.objClass = "group";
            this.cvIDD = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:5");
        } else if (ldapQuery.toLowerCase().indexOf("objectcategory=organizationalunit") != -1 || ldapQuery.toLowerCase().indexOf("objectclass=organizationalunit") != -1) {
            dirObjectClass = DirectoryObjectAPI.getInstance().getObjectClass("organizationalUnit");
            this.objClass = "organizationalUnit";
            this.cvIDD = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:7");
        } else if (ldapQuery.toLowerCase().indexOf("objectcategory=computer") != -1 || ldapQuery.toLowerCase().indexOf("objectclass=computer") != -1) {
            dirObjectClass = DirectoryObjectAPI.getInstance().getObjectClass("computer");
            this.objClass = "computer";
            this.cvIDD = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:2");
        }
        return dirObjectClass;
    }

    public void executeQuery(HttpServletRequest request, HttpServletResponse response) throws Exception {
        generationId = -1L;
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        ldapQuery = reportReqData.getString("query");
        base_DN = reportReqData.getString("base_dn");
        base_DN = CommonUtil.escapeDN((String)base_DN);
        String domainName = reportReqData.getString("domainName");
        String CVID = reportReqData.getString("cvId");
        Long cvId = Long.valueOf(CVID);
        ArrayList<Integer> report_id = new ArrayList<Integer>();
        if (ldapQuery.toLowerCase().indexOf("objectclass=user") != -1 || ldapQuery.toLowerCase().indexOf("objectcategory=user") != -1) {
            report_id.add(15);
        }
        if (ldapQuery.toLowerCase().indexOf("objectcategory=group") != -1 || ldapQuery.toLowerCase().indexOf("objectclass=group") != -1) {
            report_id.add(109);
        }
        if (ldapQuery.toLowerCase().indexOf("objectcategory=organizationalunit") != -1 || ldapQuery.toLowerCase().indexOf("objectclass=organizationalunit") != -1) {
            report_id.add(701);
        }
        if (ldapQuery.toLowerCase().indexOf("objectcategory=computer") != -1 || ldapQuery.toLowerCase().indexOf("objectclass=computer") != -1) {
            report_id.add(210);
        }
        ObjectUpdateHandler.runDailyReport((String)domainName, (Long)1L, report_id, (boolean)false, null, null, null, (String)ldapQuery, (String)base_DN);
        generationId = ObjectUpdateHandler.getGenerationID();
        HashMap<String, JSONObject> returnListMap = new HashMap<String, JSONObject>();
        JSONObject reportInputParams = new JSONObject();
        reportInputParams.put("completed", (Object)ObjectUpdateHandler.getCompleted());
        returnListMap.put("inputParams", reportInputParams);
        JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
    }

    public void stopQuery(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        ObjectUpdateHandler.setCompleted();
        Long a = 0L;
        JsonResponse.getInstance().sendResponse(response, a.toString());
    }

    public void viewObjects(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Boolean isSelectAll;
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject reportInputParams = null;
            reportInputParams = reportReqData.getJSONObject("inputParams");
            String objectClass = reportInputParams.getString("objectClass");
            String domainName = reportInputParams.getString("domainName");
            String defaultNamingContext = DomainDetailsAPI.getDefaultNamingContext((String)domainName);
            ObjectClass dirObjectClass = null;
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)("AUDCVConfig:cv_id:" + reportInputParams.getString("cvId")));
            cvId = cvId == null ? Long.parseLong(reportInputParams.getString("cvId")) : cvId;
            Long[] cvIdArray = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String[])new String[]{"AUDCVConfig:cv_id:9", "AUDCVConfig:cv_id:10", "AUDCVConfig:cv_id:11", "AUDCVConfig:cv_id:12", "AUDCVConfig:cv_id:15", "AUDCVConfig:cv_id:18", "AUDCVConfig:cv_id:19", "AUDCVConfig:cv_id:20", "AUDCVConfig:cv_id:21", "AUDCVConfig:cv_id:23", "AUDCVConfig:cv_id:25"});
            ArrayList<Long> cvIds = new ArrayList<Long>(Arrays.asList(cvIdArray));
            String searchCriteria = null;
            JSONArray allowedQueries = new JSONArray();
            reportInputParams.put("completed", null);
            String invalidMessage = "Invalid objectClass or objectCategory(It should be ";
            if (cvIds.contains(cvId)) {
                cvId = ldapQueryId;
            }
            Long objectType = -1L;
            if (cvId == ldapQueryId) {
                Iterator iterator;
                String ldap = reportInputParams.getString("ldap");
                if (ldap.equalsIgnoreCase("true")) {
                    generationId = 0L;
                    base_DN = defaultNamingContext;
                } else {
                    String completed = ObjectUpdateHandler.getCompleted();
                    if (completed.equalsIgnoreCase("false")) {
                        reportInputParams.put("completed", (Object)completed);
                    }
                }
                String type = reportInputParams.getString("type");
                Criteria crit = new Criteria(Column.getColumn((String)"AUDCustomQuery", (String)"TYPE"), (Object)type, 0);
                if (type.equalsIgnoreCase("report")) {
                    int elementId = Integer.parseInt(reportInputParams.getString("elementId"));
                    crit = crit.and(new Criteria(Column.getColumn((String)"AUDCustomQuery", (String)"ELEMENT_ID"), (Object)elementId, 0));
                } else if (type.equalsIgnoreCase("machine_type")) {
                    int machine_type = Integer.parseInt(reportInputParams.getString("machineType"));
                    crit = crit.and(new Criteria(Column.getColumn((String)"AUDCustomQuery", (String)"MACHINE_TYPE"), (Object)machine_type, 0));
                } else if (type.equalsIgnoreCase("reportprofile")) {
                    int report_category_id = Integer.parseInt(reportInputParams.getString("report_category_id"));
                    crit = crit.and(new Criteria(Column.getColumn((String)"AUDCustomQuery", (String)"REPORT_CATEGORY_ID"), (Object)report_category_id, 0));
                }
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDCustomQuery", crit);
                String allowedType = null;
                Long defaultType = -1L;
                ArrayList<Integer> allowedTypes = new ArrayList<Integer>();
                if (!dataObj.isEmpty()) {
                    Row row = dataObj.getRow("AUDCustomQuery");
                    allowedType = (String)row.get("ALLOWED_TYPES");
                    defaultType = (Long)row.get("DEFAULT_TYPE");
                    StringTokenizer allowed = new StringTokenizer(allowedType, ";");
                    while (allowed.hasMoreTokens()) {
                        int id = Integer.parseInt(allowed.nextToken());
                        allowedTypes.add(id);
                    }
                }
                crit = new Criteria(Column.getColumn((String)"AUDObjectType", (String)"ID"), (Object)allowedTypes.toArray(), 8);
                dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDObjectType", crit);
                if (!dataObj.isEmpty() && (iterator = dataObj.getRows("AUDObjectType")) != null) {
                    while (iterator.hasNext()) {
                        Row row = (Row)iterator.next();
                        objectType = (Long)row.get("ID");
                        if (ldap.equalsIgnoreCase("true") && objectType.equals(defaultType)) {
                            ldapQuery = (String)row.get("QUERY");
                        }
                        allowedQueries.put((Object)((String)row.get("QUERY")));
                        invalidMessage = invalidMessage + (String)row.get("OBJECT_CLASS");
                        if (((String)row.get("OBJECT_CLASS")).equalsIgnoreCase("user")) {
                            invalidMessage = invalidMessage + "(objectCategory should be person)";
                        }
                        invalidMessage = invalidMessage + " or ";
                    }
                }
                dirObjectClass = this.setObjClass();
                reportInputParams.put("ldapQuery", (Object)ldapQuery);
                reportInputParams.put("base_DN", (Object)base_DN);
                reportInputParams.put("tableHeight", 350);
                invalidMessage = invalidMessage.substring(0, invalidMessage.length() - 4);
                invalidMessage = invalidMessage + " )";
                reportInputParams.put("allowedQueries", (Object)allowedQueries);
                reportInputParams.put("invalidMessage", (Object)invalidMessage);
            }
            if (objectClass.equals("share")) {
                reportInputParams.put("showUncLink", true);
            }
            Criteria crit = null;
            crit = cvIds.contains(cvId) ? new Criteria(Column.getColumn((String)"AUDTableViewConfig", (String)"CV_ID"), (Object)this.cvIDD, 0) : new Criteria(Column.getColumn((String)"AUDTableViewConfig", (String)"CV_ID"), (Object)cvId, 0);
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDTableViewConfig", crit);
            HashMap<String, String> tableDetails = new HashMap<String, String>();
            if (!dob.isEmpty()) {
                Row r = dob.getFirstRow("AUDTableViewConfig");
                List al = r.getColumns();
                for (int i = 0; i < al.size(); ++i) {
                    String key = String.valueOf(al.get(i));
                    String value = String.valueOf(r.get((String)al.get(i)));
                    tableDetails.put(key, value);
                }
            }
            Long tableId = Long.parseLong((String)tableDetails.get("TABLE_VIEW_ID"));
            ArrayList<HashMap<String, Object>> tableAllColumnList = null;
            tableAllColumnList = !cvIds.contains(cvId) ? ReportHandlerUtil.getInstance().getVisibleColumnList(cvId, true, true, true, null, null, rb) : ReportHandlerUtil.getInstance().getVisibleColumnList(this.cvIDD, true, true, true, null, null, rb);
            Boolean isSearch = false;
            searchCriteria = ServerConfigHandler.getInstance().getSearchCriteria(reportInputParams, tableAllColumnList, false, true);
            if (searchCriteria != null) {
                isSearch = true;
                if (cvIds.contains(cvId)) {
                    searchCriteria = searchCriteria.replace('%', '*');
                }
            }
            Long count = 0L;
            count = !cvIds.contains(cvId) ? Long.valueOf(DirectoryObjectAPI.getInstance().getObjectsCount(defaultNamingContext, objectClass, searchCriteria, cvId)) : Long.valueOf(DirectoryObjectAPI.getInstance().getObjectsCountGenerationId(this.objClass, searchCriteria, generationId, objectType));
            if (!reportInputParams.has("sortColumn")) {
                reportInputParams.put("sortColumn", tableDetails.get("SORTCOLUMN"));
                reportInputParams.put("sortOrder", tableDetails.get("SORTORDER"));
                reportInputParams.put("sortTableName", (Object)"ADSMComputerGeneralDetails");
            }
            reportInputParams.put("selObjNameIndex", (Object)"1");
            ReportHandlerUtil.getInstance().getReportTableRangeList(reportInputParams);
            reportInputParams.put("totalCount", (Object)count);
            reportInputParams.put("isSearch", (Object)isSearch);
            reportInputParams.put("tabId", (Object)("tabId_" + cvId));
            reportInputParams.put("tabIdh", (Object)("#tabId_" + cvId));
            reportInputParams.put("tabName", (Object)("tabName_" + cvId));
            ArrayList reportsList = new ArrayList();
            ArrayList rowList = new ArrayList();
            if (reportInputParams.has("isSelectAll") && (isSelectAll = Boolean.valueOf(reportInputParams.getBoolean("isSelectAll"))).booleanValue()) {
                reportsList = !cvIds.contains(cvId) ? DirectoryObjectAPI.getInstance().getObjects(defaultNamingContext, objectClass, searchCriteria, -1, 0, cvId, Long.valueOf(0L)) : DirectoryObjectAPI.getInstance().getObjectsGenerationId(this.objClass, searchCriteria, generationId, objectType);
                JSONArray selectedIdList = new JSONArray();
                JSONArray selectedNameList = new JSONArray();
                for (int i = 0; i < reportsList.size(); ++i) {
                    HashMap obj = (HashMap)reportsList.get(i);
                    selectedIdList.put((Object)obj.get("OBJECT_GUID").toString());
                    selectedNameList.put((Object)obj.get("NAME").toString());
                }
                reportInputParams.put("selectedObjectIdList", (Object)selectedIdList);
                reportInputParams.put("selectedObjectNameList", (Object)selectedNameList);
                reportInputParams.put("isSelectAll", false);
            }
            if (count > 0L) {
                if (!cvIds.contains(cvId)) {
                    reportsList = DirectoryObjectAPI.getInstance().getObjects(defaultNamingContext, objectClass, searchCriteria, Integer.parseInt(reportInputParams.getString("startValue")), Integer.parseInt(reportInputParams.getString("rangeValue")), cvId, count);
                } else {
                    rowList = DirectoryObjectAPI.getInstance().getObjectsGenerationId(this.objClass, searchCriteria, generationId, objectType);
                    int c = Integer.parseInt(reportInputParams.getString("startValue")) + Integer.parseInt(reportInputParams.getString("rangeValue"));
                    reportsList = new ArrayList();
                    for (int i = Integer.parseInt(reportInputParams.getString("startValue")); i < c && (long)i <= count; ++i) {
                        reportsList.add(rowList.get(i - 1));
                    }
                }
            }
            if (count == 0L) {
                reportInputParams.put("emptyTableMessage", (Object)rb.getString("adap_common.no_ad_objects_available"));
                if (isSearch.booleanValue()) {
                    reportInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                    reportInputParams.put("emptyTableMessage2", (Object)rb.getString("adap.common.text.policy_update_link.click_here"));
                } else if (!cvIds.contains(cvId)) {
                    reportInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                    reportInputParams.put("emptyTableMessage2", (Object)rb.getString("adap_ServerConfig.click_here_to_refresh"));
                }
            }
            reportInputParams.put("defaultNamingContext", (Object)defaultNamingContext);
            HashMap<String, Object> returnListMap = new HashMap<String, Object>();
            JSONObject resultObj = EmberTableConfig.getInstance().getEmberTableData1(tableId, reportsList, tableAllColumnList, reportInputParams, rb);
            if (cvIds.contains(cvId)) {
                reportInputParams.put("showRefresh", false);
            }
            JSONObject tableData = resultObj.getJSONObject("tableData");
            returnListMap.put("reportData", tableData.get("tableDataList"));
            returnListMap.put("reportColumnList", tableAllColumnList);
            returnListMap.put("inputParams", reportInputParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateObjects(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        JSONObject reportInputParams = null;
        reportInputParams = reportReqData.getJSONObject("inputParams");
        String objectClass = reportInputParams.getString("objectClass");
        String domainName = reportInputParams.getString("domainName");
        String message = "";
        String argObjectVal = "";
        String statusVal = "";
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        if (objectClass != null) {
            if (objectClass.equalsIgnoreCase("user")) {
                argObjectVal = "Users";
                statusVal = rb.getString("adap.domain_settings.update_domain_details.actionname.users");
            } else if (objectClass.equalsIgnoreCase("group")) {
                argObjectVal = "Group";
                statusVal = rb.getString("adap.domain_settings.update_domain_details.actionname.groups");
            } else if (objectClass.equalsIgnoreCase("computer")) {
                argObjectVal = "Computers";
                statusVal = rb.getString("adap.domain_settings.update_domain_details.actionname.computers");
            } else if (objectClass.equalsIgnoreCase("organizationalUnit")) {
                argObjectVal = "OU";
                statusVal = rb.getString("adap.domain_settings.update_domain_details.actionname.organizational_units");
            } else if (objectClass.equalsIgnoreCase("share")) {
                argObjectVal = "Share";
                statusVal = rb.getString("adap.domain_settings.update_domain_details.actionname.shares");
            } else {
                argObjectVal = "GPO";
                statusVal = rb.getString("adap.domain_settings.update_domain_details.actionname.group_policy_objects");
            }
        }
        String[] selectedUpdates = new String[]{argObjectVal};
        message = rb.handleGetObject("adap.ViewObjects.Reload_page_after_sometime_to", new String[]{statusVal});
        try {
            DomainHandler.updateDomain((String)domainName, (Long)loginId, (String[])selectedUpdates);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", message + "\n" + rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Objects_updated_manually", "-"}));
        }
        catch (Exception ex) {
            message = ex.getMessage();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ViewObjects.audit_entry.problem_updating_domain_objects", new String[]{domainName}), 8, 16, message, "adap.ADAPUserAuditSeverities.audit_name.Objects_updated_manually", "-"}));
            ex.printStackTrace();
        }
        reportInputParams.put("filterText", (Object)message);
        HashMap<String, JSONObject> returnListMap = new HashMap<String, JSONObject>();
        returnListMap.put("inputParams", reportInputParams);
        JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
    }
}

