/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.config;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.alert.AlertAPI;
import com.adventnet.sym.adsm.auditing.server.alert.AlertProfileAPI;
import com.adventnet.sym.adsm.auditing.server.alert.AlertProfileHandler;
import com.adventnet.sym.adsm.auditing.server.alert.GPOAlertProfileAPI;
import com.adventnet.sym.adsm.auditing.server.alert.GPOAlertProfileListener;
import com.adventnet.sym.adsm.auditing.server.alert.PrintAlertProfileAPI;
import com.adventnet.sym.adsm.auditing.server.alert.PrintAlertProfileListener;
import com.adventnet.sym.adsm.auditing.server.monitor.ActionConstants;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditCatgoryAPI;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditMonitorAPI;
import com.adventnet.sym.adsm.auditing.server.monitor.Category;
import com.adventnet.sym.adsm.auditing.server.monitor.MonitorManager;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.common.EmberTableConfig;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.report.CustomReportConfigUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.admin.BusinessServerSettings;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.JSONUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseUtil;
import com.adventnet.sym.adsm.common.server.util.MailServerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AlertProfilesHandler {
    private static volatile AlertProfilesHandler instance = null;
    private static Logger logger = Logger.getLogger(AlertProfilesHandler.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AlertProfilesHandler getInstance() {
        if (instance != null) return instance;
        Class<AlertProfilesHandler> clazz = AlertProfilesHandler.class;
        synchronized (AlertProfilesHandler.class) {
            if (instance != null) return instance;
            instance = new AlertProfilesHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void viewAlertProfiles(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String cvid = "15006";
            String selectedDomain = request.getParameter("selectedDomain");
            HashMap map = AlertAPI.getALertProfileList((String)selectedDomain);
            ArrayList profileList = (ArrayList)map.get(selectedDomain);
            JSONObject addnParams = new JSONObject();
            addnParams.put("readOnly", request.getAttribute("readOnly"));
            ret = EmberTableConfig.getInstance().getEmberTableData(cvid, profileList, addnParams, rb);
            Boolean mailConficCheck = MailServerUtil.mailServerConfig();
            ret.put("mailServerConfigured", (Object)mailConficCheck);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void enableDisableAlertProfiles(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String ids = request.getParameter("data");
            JSONObject ids1 = new JSONObject(ids);
            JSONArray ids2 = ids1.optJSONArray("ids");
            Long[] alertProfileId = new Long[ids2.length()];
            for (int i = 0; i < ids2.length(); ++i) {
                alertProfileId[i] = ids2.getLong(i);
            }
            DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDAlertProfile", new Criteria(Column.getColumn((String)"AUDAlertProfile", (String)"ALERT_PROFILE_ID"), (Object)alertProfileId, 8));
            StringBuilder sb = new StringBuilder();
            Iterator iterator = dObj.getRows("AUDAlertProfile");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                sb.append(rb.getString((String)row.get("ALERT_PROFILE_NAME"))).append("\n");
            }
            String action = ids1.getString("action");
            ret.put("message", (Object)rb.getString("adap.common.failureoccured"));
            boolean b = AlertProfileAPI.getInstance().enableDisableAlertProfile(alertProfileId, action);
            MonitorManager.getInstance().updateAlertProfileInMonitorMap(alertProfileId);
            PrintAlertProfileListener.getInstance().refreshAlertProfileMaps();
            if (b) {
                ret.put("success", true);
                String message = "";
                message = action.equals("Enable") ? rb.getString("adap.EnableDisableAlertProfile.Successfully_enabled_alert_profile") : rb.getString("adap.EnableDisableAlertProfile.Successfully_disabled_alert_profile");
                ret.put("message", (Object)message);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.changed_alert_profiles", rb.handleGetObject("adap.EnableDisableAlertProfile.audit_entry.Alert_Profiles", new String[]{sb.toString()})}));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void deleteAlertProfiles(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        Object[] alertProfileId = new Long[]{};
        StringBuilder sb = new StringBuilder();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String ids = request.getParameter("data");
            JSONObject ids1 = new JSONObject(ids);
            JSONArray ids2 = ids1.optJSONArray("ids");
            alertProfileId = new Long[ids2.length()];
            for (int i = 0; i < ids2.length(); ++i) {
                alertProfileId[i] = ids2.getLong(i);
            }
            Iterator iterator = ReportUtil.getRows((String)"AUDAlertProfile", (String)"ALERT_PROFILE_ID", (Object[])alertProfileId);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                sb.append(rb.getString((String)row.get("ALERT_PROFILE_NAME"))).append("\n");
            }
            ret.put("message", (Object)rb.getString("adap.DeleteAlertProfileAction.Error_in_deleting_the_alert"));
            boolean status1 = AlertProfileHandler.deleteNotificationAndMap((Long[])alertProfileId);
            boolean status = AlertProfileHandler.deleteAlertProfile((Long[])alertProfileId);
            if (status && status1) {
                GPOAlertProfileListener.getInstance().refreshGPOAlertMaps();
                PrintAlertProfileListener.getInstance().refreshAlertProfileMaps();
                ret.put("success", true);
                ret.put("message", (Object)rb.getString("adap.DeleteAlertProfileAction.Successfully_deleted_the_alert_profile"));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Configuration", rb.handleGetObject("adap.DeleteAlertProfileAction.audit_entry.Successfully_deleted", new String[]{String.valueOf(alertProfileId.length)}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.deleted_alert_profiles", rb.handleGetObject("adap.audit_entry_addn.Details", new String[]{sb.toString()})}));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                ret.put("message", (Object)(rb.getString("adap.DeleteAlertProfileAction.Error_in_deleting_the_alert") + "  " + e.getMessage()));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Configuration", rb.handleGetObject("adap.DeleteAlertProfileAction.audit_entry.Error_while_deleting", new String[]{String.valueOf(alertProfileId.length)}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.deleted_alert_profiles", rb.handleGetObject("adap.audit_entry_addn.Details", new String[]{sb.toString()})}));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void updateEMail(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String statusMessage = rb.getString("adap.common.failureoccured");
        try {
            String ids = request.getParameter("data");
            JSONObject ids1 = new JSONObject(ids);
            JSONArray ids2 = ids1.optJSONArray("ids");
            Object[] alertProfileId = new Long[ids2.length()];
            for (int i = 0; i < ids2.length(); ++i) {
                alertProfileId[i] = ids2.getLong(i);
            }
            ret.put("message", (Object)statusMessage);
            String values = ids1.getString("values");
            Boolean status = AlertProfileHandler.updateAlertProfileByOptions((Long[])alertProfileId, (String)"mailCheck", (String)values);
            if (status.booleanValue()) {
                ret.put("success", true);
                ret.put("message", (Object)rb.getString("adap.UpdateAlertProfileAction.Successfully_Updated_the_Alert_Profile"));
                statusMessage = rb.getString("adap.UpdateAlertProfileAction.Successfully_Updated_the_Alert_Profile");
                String profileNames = ReportUtil.getColumnFromRows((Iterator)ReportUtil.getRows((String)"AUDAlertProfile", (String)"ALERT_PROFILE_ID", (Object[])alertProfileId), (String)"ALERT_PROFILE_NAME", (AdventNetResourceBundle)rb);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", statusMessage + "\n " + rb.handleGetObject("adap.audit_entry_addn.Alert_Profile_name", new String[]{profileNames}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.modified_alert_profiles", "-"}));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                ret.put("message", (Object)(rb.getString("adap.common.failureoccured") + "  " + e.getMessage()));
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void getAlertConfig(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String fromTime;
            JSONArray rpCategoryList = new JSONArray();
            JSONObject item2 = new JSONObject();
            item2.put("name", (Object)"All");
            item2.put("value", (Object)"All");
            rpCategoryList.put((Object)item2);
            for (int i = 1; i <= 3; ++i) {
                LinkedHashMap categories = AuditCatgoryAPI.getInstance().getCategories(Integer.valueOf(i));
                Set keySet = categories.keySet();
                for (Long categoryId : keySet) {
                    Category category = (Category)categories.get(categoryId);
                    if (category.getName().equalsIgnoreCase("adap.AUDBackupDataConfig.Print_Server_Auditing") || category.getName().equalsIgnoreCase("adap.AUDCategories.category_name.TerminalServicesGateway")) continue;
                    JSONObject item = new JSONObject();
                    item.put("name", (Object)rb.getString(category.getName()));
                    item.put("value", (Object)categoryId);
                    rpCategoryList.put((Object)item);
                }
            }
            ret.put("rpCategoryList", (Object)rpCategoryList);
            ret.put("addRPChosenCategory", (Object)"All");
            Boolean mailConficCheck = MailServerUtil.mailServerConfig();
            ret.put("mailServerNotConfigured", mailConficCheck == false);
            HashMap settingsMap = BusinessServerSettings.getBusinessHourSettings();
            String string = fromTime = settingsMap.isEmpty() ? "" : (String)settingsMap.get("FromTime");
            if (fromTime.equals("")) {
                ret.put("bussinessHourConfigured", false);
            } else {
                ret.put("bussinessHourConfigured", true);
            }
            String licenseTypeStr = LicenseUtil.getLicenseTypeString();
            boolean isEvalPeriod = LicenseUtil.isProfEvalPeriod();
            if (licenseTypeStr.equals("Standard") && !isEvalPeriod) {
                ret.put("hideAdvancedAlerts", true);
            }
            ret.put("chosenIDList", (Object)new JSONArray());
            ret.put("chosenNameList", (Object)new JSONArray());
            ret.put("selectedCategory", (Object)"All");
            ret.put("SEVERITY", (Object)"1");
            ret.put("ALERT_MESSAGE", (Object)"%FORMAT_MESSAGE%");
            ret.put("thresholdBasedAlert", false);
            ret.put("userBasedAlert", false);
            ret.put("hourBasedAlert", false);
            ret.put("thresholdInterval", (Object)"5");
            ret.put("thresholdCount", (Object)"10");
            ret.put("userMap", (Object)new JSONObject());
            ret.put("isSave", true);
            ret.put("isAdvConfig", false);
            ret.put("contentType", (Object)"html");
            ret.put("alertMsgNeeded", true);
            ret.put("eventDetails", true);
            ret.put("filterList", (Object)new JSONArray());
            ret.put("alertFilter", false);
            HashMap relationalOperatorsList = ActionConstants.getRelationalOperaionsEmber();
            ArrayList logicalOperationsList = ActionConstants.getLogicalOperaions();
            ret.put("relationalOperators", (Object)JSONUtil.mapToJSONObject((Map)relationalOperatorsList));
            ret.put("logicalOperators", (Object)JSONUtil.listToJSONArray((List)logicalOperationsList));
            HashMap<Long, Object> elementsMap = CustomReportConfigUtil.getCriteriaDetails(rb);
            ret.put("elementsMap", (Object)JSONUtil.mapToJSONObject(elementsMap));
            String alertProfileIdString = request.getParameter("alertProfileId");
            if (alertProfileIdString != null && !alertProfileIdString.equals("new")) {
                HashMap map;
                Row row;
                DataObject dataObj;
                HashMap thresholdMap;
                ret.put("isSave", false);
                Long alertProfileId = Long.parseLong(alertProfileIdString);
                String[] ignoreKeyStrings = new String[]{"CREATION_TIME", "MODIFICATION_TIME", "IS_ENABLED", "IS_BUSINESS_HOUR_ENABLED", "thresholdDetails", "UserNameAlert", "businessHourDetails"};
                HashMap alertProfileMap = AlertProfileHandler.getAlertProfile((Long)alertProfileId);
                Set keySet = alertProfileMap.keySet();
                List<String> ignoreKeyList = Arrays.asList(ignoreKeyStrings);
                for (Object object : keySet) {
                    String key = (String)object;
                    if (ignoreKeyList.contains(key)) continue;
                    ret.put(key, alertProfileMap.get(key));
                }
                ArrayList monitorList = (ArrayList)ret.get("monitorList");
                JSONArray jmonitorNameList = new JSONArray();
                JSONArray jmonitorIdList = new JSONArray();
                if (monitorList == null) {
                    monitorList = new ArrayList();
                    ret.put("monitorList", monitorList);
                }
                for (Object object2 : monitorList) {
                    Long monitorId = (Long)object2;
                    jmonitorNameList.put((Object)rb.getString((String)AuditMonitorAPI.getInstance().getMonitorProperty(monitorId, "MONITOR_NAME")));
                    jmonitorIdList.put((Object)monitorId);
                }
                ret.put("chosenNameList", (Object)jmonitorNameList);
                ret.put("chosenIDList", (Object)jmonitorIdList);
                HashMap notificationMap = AlertProfileHandler.getAlertNotification((Long)alertProfileId);
                if (!notificationMap.isEmpty()) {
                    ret.put("TO_ADDRESS1", notificationMap.get("toAddress"));
                    ret.put("MAIL_SUBJECT", notificationMap.get("MAIL_SUBJECT"));
                    ret.put("contentType", notificationMap.get("BODY_CONTENT_TYPE"));
                    ret.put("alertMsgNeeded", notificationMap.get("ALERT_MSG_NEEDED"));
                    ret.put("eventDetails", notificationMap.get("EVT_DETAILS_NEEDED"));
                    ret.put("moreRecipients", notificationMap.get("ADDNL_MAIL_ADDRESSES"));
                }
                if (!(thresholdMap = (HashMap)alertProfileMap.get("thresholdDetails")).isEmpty()) {
                    ret.put("thresholdBasedAlert", true);
                    ret.put("isAdvConfig", true);
                    ret.put("thresholdInterval", thresholdMap.get("thresholdInterval"));
                    ret.put("thresholdCount", thresholdMap.get("thresholdCount"));
                } else {
                    ret.put("thresholdBasedAlert", false);
                }
                HashMap CallerUserNameMap = (HashMap)alertProfileMap.get("UserNameAlert");
                if (!CallerUserNameMap.isEmpty()) {
                    ret.put("userBasedAlert", true);
                    ret.put("isAdvConfig", true);
                    ret.put("userMap", (Object)JSONUtil.mapToJSONObject((Map)CallerUserNameMap));
                } else {
                    ret.put("userBasedAlert", false);
                }
                HashMap businessHourMap = (HashMap)alertProfileMap.get("businessHourDetails");
                if (businessHourMap.size() > 0) {
                    ret.put("hourBasedAlert", true);
                    ret.put("isAdvConfig", true);
                    if (((Boolean)businessHourMap.get("included")).booleanValue()) {
                        ret.put("businessHourType", (Object)"included");
                    } else if (!((Boolean)businessHourMap.get("included")).booleanValue()) {
                        ret.put("businessHourType", (Object)"excluded");
                    }
                } else {
                    ret.put("hourBasedAlert", false);
                }
                Boolean b = GPOAlertProfileAPI.isGPOAlertProfile((Long)alertProfileId);
                if (b.booleanValue()) {
                    dataObj = GPOAlertProfileAPI.getAlertCriteriaDO((Long)alertProfileId);
                    row = dataObj.getRow("AUDAlertCriteria");
                    ret.put("domainName", row.get("DOMAIN_NAME"));
                    map = GPOAlertProfileAPI.getGPONameGuidMap2((Long)alertProfileId);
                    ret.put("chosenNameList", map.get("chosenNameList"));
                    ret.put("chosenIDList", map.get("chosenIDList"));
                    ret.put("selectedCategory", (Object)"GPO");
                }
                if (PrintAlertProfileAPI.isPrinterAlertProfile((Long)alertProfileId).booleanValue()) {
                    dataObj = PrintAlertProfileAPI.getAlertCriteriaDO((Long)alertProfileId);
                    row = dataObj.getRow("AUDPrinterAlertCriteria");
                    ret.put("domainName", row.get("DOMAIN_NAME"));
                    map = PrintAlertProfileAPI.getPrinterNameMap2((Long)alertProfileId);
                    ret.put("chosenNameList", map.get("chosenNameList"));
                    ret.put("chosenIDList", map.get("chosenIDList"));
                    ret.put("selectedCategory", (Object)"Printer");
                }
                ret.put("selectedObjectsMap", (Object)AlertProfileHandler.getAlertDetails((Object)alertProfileId));
                ret.put("alertFilter", false);
                JSONArray variablesArray = AlertProfileHandler.getAlertVariables2(monitorList, null);
                JSONObject colOpeMap = new JSONObject();
                JSONObject colElementMap = new JSONObject();
                for (int i = 0; i < variablesArray.length(); ++i) {
                    JSONObject variable = (JSONObject)variablesArray.get(i);
                    colOpeMap.put(String.valueOf(variable.get("COLUMN_ID")), variable.get("COLUMN_DATA_TYPE"));
                    colElementMap.put(String.valueOf(variable.get("COLUMN_ID")), variable.get("ELEMENT_ID"));
                }
                ret.put("variablesArray", (Object)variablesArray);
                JSONArray filterList = AlertProfilesHandler.getCriteriaList(alertProfileId, JSONUtil.mapToJSONObject((Map)relationalOperatorsList), elementsMap, colElementMap, colOpeMap, variablesArray);
                ret.put("filterList", (Object)filterList);
                if (filterList.length() > 0) {
                    ret.put("isAdvConfig", true);
                    ret.put("alertFilter", true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void saveAlertProfile(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        Boolean isSave = false;
        JSONObject data = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            boolean userAdded;
            ret.put("message", (Object)rb.getString("adap.common.failureoccured"));
            String strData = request.getParameter("data");
            data = new JSONObject(strData);
            isSave = data.getBoolean("isSave");
            HashMap map = new HashMap();
            HashMap<String, Object> propsMap = new HashMap<String, Object>();
            propsMap.put("ALERT_PROFILE_NAME", data.get("alertName"));
            propsMap.put("ALERT_PROFILE_DESCRIPTION", data.get("alertDescription"));
            propsMap.put("ALERT_MESSAGE", data.get("alertMsg"));
            propsMap.put("SEVERITY", Integer.parseInt(String.valueOf(data.get("alertSeverity"))));
            if (isSave.booleanValue()) {
                propsMap.put("CREATION_TIME", System.currentTimeMillis());
            }
            propsMap.put("MODIFICATION_TIME", System.currentTimeMillis());
            propsMap.put("IS_ENABLED", true);
            propsMap.put("CRITERIA_PATTERN", data.get("criteriaValue"));
            map.put("AlertProfileDetails", propsMap);
            propsMap = new HashMap();
            propsMap.put("IS_MAIL_NOTIFICATION", data.get("alertIsMailNotify"));
            if (((Boolean)data.get("alertIsMailNotify")).booleanValue()) {
                propsMap.put("TO_ADDRESS", data.get("alertMailAddress"));
                propsMap.put("MAIL_SUBJECT", data.get("alertMailSubject"));
                propsMap.put("BODY_CONTENT_TYPE", data.get("contentType"));
                propsMap.put("ALERT_MSG_NEEDED", data.get("alertMsgNeeded"));
                propsMap.put("EVT_DETAILS_NEEDED", data.get("eventDetails"));
                propsMap.put("ADDNL_MAIL_ADDRESSES", data.get("moreRecipients"));
            }
            map.put("NotificationProfileDetails", propsMap);
            HashMap calluserMap = new HashMap();
            boolean flag = data.getBoolean("userBasedAlert");
            JSONObject userObj = data.getJSONObject("userMap");
            JSONArray userArr = userObj.optJSONArray("user");
            JSONArray groupArr = userObj.optJSONArray("group");
            boolean bl = userAdded = userArr != null && userArr.length() > 0 || groupArr != null && groupArr.length() > 0;
            if (flag && userAdded) {
                calluserMap = JSONUtil.JSONObjectToMap((JSONObject)userObj);
                ArrayList<String> domainNameList = new ArrayList<String>();
                domainNameList.add((String)data.get("domainName"));
                calluserMap.put("domainName", domainNameList);
                map.put("CallerUserName", calluserMap);
            }
            propsMap = new HashMap();
            propsMap.put("IS_THRESHOLD_NOTIFICATION", (Boolean)data.get("thresholdBasedAlert"));
            propsMap.put("THRES_COUNT", data.get("thresholdCount"));
            propsMap.put("TIME_INTERVAL", data.get("thresholdInterval"));
            map.put("ThresholdProfileDetails", propsMap);
            if (((Boolean)data.get("hourBasedAlert")).booleanValue()) {
                propsMap = new HashMap();
                if (((String)data.get("businessHourType")).equalsIgnoreCase("included")) {
                    propsMap.put("included", "true");
                }
                map.put("BusinessHourMap", propsMap);
                map.put("BusinessHourAlert", propsMap);
            }
            JSONArray monitorIdList = (JSONArray)data.get("monitorList");
            boolean isReportProfileAlert = false;
            String selectedCategory = (String)data.get("selectedCategory");
            if (selectedCategory.equals("GPO")) {
                isReportProfileAlert = true;
                propsMap = new HashMap();
                String gpoGuids = "";
                for (int i = 0; i < monitorIdList.length(); ++i) {
                    gpoGuids = gpoGuids + monitorIdList.getString(i) + ",";
                }
                gpoGuids = gpoGuids.substring(0, gpoGuids.length() - 1);
                monitorIdList = new JSONArray();
                String domainName = (String)data.get("domainName");
                HashMap gpoGuIdMap = GPOAlertProfileAPI.alertGPOSettingsmap((String)gpoGuids, (String)domainName);
                ArrayList guidList = (ArrayList)gpoGuIdMap.get("guidList");
                String objectClass = (String)gpoGuIdMap.get("objectClass");
                propsMap.put("GPO_GUIDS", guidList);
                propsMap.put("OBJECT_CLASS", objectClass);
                propsMap.put("DOMAIN_NAME", domainName);
                map.put("AlertCriteriaDetails", propsMap);
            }
            if (selectedCategory.equals("Printer")) {
                isReportProfileAlert = true;
                propsMap = new HashMap();
                ArrayList printerNamesList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)monitorIdList);
                monitorIdList = new JSONArray();
                propsMap.put("PRINTER_NAMES", printerNamesList);
                propsMap.put("DOMAIN_NAME", (String)data.get("domainName"));
                propsMap.put("PRINT_SERVER", "ALL");
                map.put("PrinterCriteriaDetails", propsMap);
                PrintAlertProfileListener.getInstance().refreshAlertProfileMaps();
            }
            ArrayList<Long> listdata = new ArrayList<Long>();
            for (int i = 0; i < monitorIdList.length(); ++i) {
                listdata.add(Long.parseLong(String.valueOf(monitorIdList.get(i))));
            }
            LinkedHashMap<Integer, HashMap<String, Object>> filterMap = CustomReportConfigUtil.formCriteriaMap(request, data);
            map.put("filterDetails", filterMap);
            Boolean status = false;
            if (isSave.booleanValue()) {
                status = AlertProfileHandler.saveAlertProfile(map, (ArrayList)(isReportProfileAlert ? new ArrayList<Long>() : listdata));
                if (status.booleanValue()) {
                    ret.put("success", true);
                    ret.put("message", rb.handleGetObject("adap.SaveAlertProfileAction.Successfully_Saved_the_Alert_Profile"));
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Configuration", rb.handleGetObject("adap.SaveAlertProfileAction.Successfully_Saved_the_Alert_Profile") + "\n " + rb.handleGetObject("adap.audit_entry_addn.Alert_Profile_name", new String[]{(String)data.get("alertName")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.saved_alert_profiles", "-"}));
                }
            } else {
                Long alertProfileId = data.getLong("alertProfileId");
                HashMap selectedMap = (HashMap)map.get("CallerUserName");
                if (selectedMap != null && selectedMap.containsKey("domainName")) {
                    selectedMap.remove("domainName");
                }
                HashMap<String, HashMap> selectedObjectsMap = new HashMap<String, HashMap>();
                selectedObjectsMap.put("selectedObjectsMap", selectedMap);
                map.put("callerUserName", selectedObjectsMap);
                status = AlertProfileHandler.updateAlertProfile((Object)alertProfileId, map, listdata);
                if (status.booleanValue()) {
                    ret.put("success", true);
                    ret.put("message", (Object)rb.getString("adap.updateAlertProfile.Successfully_Updated_the_Alert_Profile"));
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.getString("adap.updateAlertProfile.Successfully_Updated_the_Alert_Profile") + "\n " + rb.handleGetObject("adap.audit_entry_addn.Alert_Profile_name", new String[]{(String)data.get("alertName")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.modified_alert_profiles", "-"}));
                }
            }
            if (selectedCategory.equals("Printer")) {
                PrintAlertProfileListener.getInstance().refreshAlertProfileMaps();
                AlertAPI.getInstance().getPrinterAlertProfile();
            }
            if (selectedCategory.equals("GPO")) {
                GPOAlertProfileListener.getInstance().refreshGPOAlertMaps();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                ret.put("message", (Object)(rb.getString("adap.common.failureoccured") + "  " + e.getMessage()));
                if (isSave.booleanValue()) {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Configuration", rb.handleGetObject("adap.SaveAlertProfileAction.audit_entry.problem_saving_alert_profile", new String[]{(String)data.get("alertName")}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.saved_alert_profiles", "-"}));
                } else {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.handleGetObject("adap.UpdateAlertProfileAction.Problem_while_updating_alert_prfile", new String[]{(String)data.get("alertName")}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.modified_alert_profiles", "-"}));
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void getRPList(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String cvid = "15009";
            String categoryIdStr = request.getParameter("reportCategoryId");
            String domainName = request.getParameter("domainName");
            JSONArray actionsArray = new JSONArray();
            ArrayList monitorsList = AuditMonitorAPI.getInstance().getMonitorsList(null, domainName, categoryIdStr, null, null, "enableMonitor");
            JSONObject emberTableData = EmberTableConfig.getInstance().getEmberTableData(cvid, monitorsList, new JSONObject(), rb);
            JSONObject navigationObject = emberTableData.optJSONObject("tableInputParams");
            navigationObject.put("selObjNameIndex", (Object)"1");
            JSONObject tableData = emberTableData.optJSONObject("tableData");
            ret.put("tableData", (Object)tableData);
            ret.put("tableInputParams", (Object)navigationObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void getAlertVariables(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        try {
            String strData = request.getParameter("data");
            JSONObject data = new JSONObject(strData);
            JSONArray monitorIdList = (JSONArray)data.get("monitorList");
            String objectClass = data.getString("objectClass");
            ArrayList<Long> idList = new ArrayList<Long>();
            for (int i = 0; i < monitorIdList.length(); ++i) {
                idList.add(monitorIdList.getLong(i));
            }
            ret.put("variablesArray", (Object)AlertProfileHandler.getAlertVariables2(idList, (String)("".equals(objectClass) ? null : objectClass)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static JSONArray getCriteriaList(Long alertProfileId, JSONObject relationaloperators, HashMap elementsMap, JSONObject colElementMap, JSONObject colOpeMap, JSONArray variablesArray) throws Exception {
        ArrayList criteriaList = new ArrayList();
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDAlertProfileFilterMapping"));
        query.addSelectColumn(Column.getColumn((String)"AUDAlertProfileFilterMapping", (String)"*"));
        query.setCriteria(new Criteria(Column.getColumn((String)"AUDAlertProfileFilterMapping", (String)"ALERT_PROFILE_ID"), (Object)alertProfileId, 0));
        query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDAlertProfileFilterMapping", (String)"PRIORITY_ID"), true));
        DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        JSONArray filterList = new JSONArray();
        if (dataObj.size("AUDAlertProfileFilterMapping") > 0) {
            int i = 0;
            int j = 1;
            Iterator iterator = dataObj.getRows("AUDAlertProfileFilterMapping");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                JSONObject filter = new JSONObject();
                HashMap<String, Object> detailsMap = new HashMap<String, Object>();
                detailsMap.put("columnField", row.get("COLUMN_ID"));
                detailsMap.put("logicalOper", row.get("LOGICAL_OPERATOR"));
                detailsMap.put("relOper", row.get("RELATIONAL_OPERATOR"));
                String[] val = ((String)row.get("VALUE")).split(";;;");
                filter.put("columnId", (Object)AlertProfilesHandler.getColumnNameFromId(variablesArray, (Long)row.get("COLUMN_ID")));
                Long elementId = colElementMap.getLong(row.get("COLUMN_ID").toString());
                JSONObject elementMap = JSONUtil.mapToJSONObject((Map)((HashMap)elementsMap.get(elementId)));
                String operatorId = colOpeMap.getString(row.get("COLUMN_ID").toString());
                JSONArray relOperators = relationaloperators.getJSONArray(operatorId);
                filter.put("logOperator", row.get("LOGICAL_OPERATOR"));
                filter.put("relOperator", row.get("RELATIONAL_OPERATOR"));
                filter.put("filterNo", j);
                filter.put("elementMap", (Object)elementMap);
                filter.put("relationalOperators", (Object)relOperators);
                if (j > 1) {
                    filter.put("showLogicOperator", true);
                }
                ++j;
                filter.put("objectClass", (Object)"-");
                if (val.length > 1) {
                    detailsMap.put("objectClass", val[0]);
                    detailsMap.put("object_guid", val[1]);
                    filter.put("objectClass", (Object)val[0]);
                    JSONArray objectGuidArray = new JSONArray();
                    String[] val2 = val[1].split(",");
                    for (int k = 0; k < val2.length; ++k) {
                        objectGuidArray.put((Object)val2[k]);
                    }
                    filter.put("objectGuid", (Object)objectGuidArray);
                    filter.put("disabledText", true);
                    if ("share".equalsIgnoreCase(val[0])) {
                        detailsMap.put("names", val[1]);
                        filter.put("value", (Object)val[1]);
                    } else {
                        ArrayList<String> list = new ArrayList<String>();
                        list.addAll(Arrays.asList(val[1].split(",")));
                        Iterator iter = DirectoryObjectAPI.getInstance().getObjectRows(null, list, val[0]);
                        String names = "";
                        if (iter != null) {
                            while (iter.hasNext()) {
                                Row objectRow = (Row)iter.next();
                                names = names != "" ? names + "," + (String)objectRow.get("NAME") : (String)objectRow.get("NAME");
                            }
                        } else {
                            names = val[1];
                        }
                        detailsMap.put("names", names);
                        filter.put("value", (Object)names);
                    }
                } else {
                    detailsMap.put("names", val[0]);
                    filter.put("value", (Object)val[0]);
                }
                criteriaList.add(detailsMap);
                filterList.put((Object)filter);
                ++i;
            }
        }
        return filterList;
    }

    private static String getColumnNameFromId(JSONArray variablesArray, Long columnId) throws Exception {
        String columnName = "";
        for (int i = 0; i < variablesArray.length(); ++i) {
            JSONObject variable = (JSONObject)variablesArray.get(i);
            Long id = (Long)variable.get("COLUMN_ID");
            if (id.longValue() != columnId.longValue()) continue;
            columnName = (String)variable.get("value");
        }
        return columnName;
    }
}

