/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.config;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditActionHandler;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditCategoryHandler;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditCatgoryAPI;
import com.adventnet.sym.adsm.auditing.server.monitor.Category;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.common.EmberTableConfig;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.JSONUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class AuditActionsHandler {
    private static volatile AuditActionsHandler instance = null;
    private static Logger logger = Logger.getLogger(AuditActionsHandler.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuditActionsHandler getInstance() {
        if (instance != null) return instance;
        Class<AuditActionsHandler> clazz = AuditActionsHandler.class;
        synchronized (AuditActionsHandler.class) {
            if (instance != null) return instance;
            instance = new AuditActionsHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void viewAuditActions(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String cvid = "15008";
            JSONObject auditActions = new JSONObject();
            JSONArray actionCategories = new JSONArray();
            String category = request.getParameter("categoryType");
            int categoryType = 1;
            if (category != null) {
                categoryType = Integer.parseInt(category);
            }
            LinkedHashMap categories = AuditCatgoryAPI.getInstance().getCategories(Integer.valueOf(categoryType));
            Set keySet = categories.keySet();
            for (Long categoryId : keySet) {
                Category categoryObj = (Category)categories.get(categoryId);
                if (categoryObj.getName().equalsIgnoreCase("adap.AUDBackupDataConfig.Print_Server_Auditing") || categoryObj.getName().equalsIgnoreCase("adap.AUDCategories.category_name.TerminalServicesGateway")) continue;
                String categoryName = rb.getString(categoryObj.getName());
                ArrayList actionsList = AuditCategoryHandler.getInstance().getActionsForCategory(categoryId);
                JSONObject actionCategory = new JSONObject();
                actionCategory.put("categoryId", (Object)categoryId);
                actionCategory.put("categoryName", (Object)categoryName);
                actionCategory.put("itemId", (Object)"new");
                for (int i = 0; i < actionsList.size(); ++i) {
                    JSONObject emberTableData = EmberTableConfig.getInstance().getEmberTableData(cvid, actionsList, null, rb);
                    JSONObject navigationObject = emberTableData.getJSONObject("tableInputParams");
                    JSONObject tableData = emberTableData.getJSONObject("tableData");
                    actionCategory.put("tableData", (Object)tableData);
                    actionCategory.put("tableInputParams", (Object)navigationObject);
                }
                actionCategories.put((Object)actionCategory);
            }
            auditActions.put("categories", (Object)actionCategories);
            ret.put("auditActions", (Object)auditActions);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static int getAuditActionCategoryAccessType(HttpServletRequest request, HttpServletResponse response, int categoryType) {
        HttpSession session = request.getSession();
        ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        HashMap actionAccesses = authObject.getAccesses();
        if (categoryType == 1) {
            if (actionAccesses.containsKey(TDConstants.ADV_CONFIG_FS)) {
                return (Integer)actionAccesses.get(TDConstants.ADV_CONFIG_FS);
            }
            return 0;
        }
        if (categoryType == 2) {
            if (actionAccesses.containsKey(TDConstants.CONFIG_FS)) {
                return (Integer)actionAccesses.get(TDConstants.CONFIG_FS);
            }
            return 0;
        }
        if (actionAccesses.containsKey(TDConstants.CONFIG_FIM)) {
            return (Integer)actionAccesses.get(TDConstants.CONFIG_FIM);
        }
        return 0;
    }

    public static void getActionCategories(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            JSONArray actionCategories = new JSONArray();
            String cate = request.getParameter("categoryType");
            String selectedCategory = null;
            int categoryType = 1;
            if (cate != null) {
                categoryType = Integer.parseInt(cate);
            }
            LinkedHashMap categories = AuditCatgoryAPI.getInstance().getCategories(Integer.valueOf(categoryType));
            Set keySet = categories.keySet();
            for (Long categoryId : keySet) {
                Category category = (Category)categories.get(categoryId);
                if (category.getName().equalsIgnoreCase("adap.AUDBackupDataConfig.Print_Server_Auditing") || category.getName().equalsIgnoreCase("adap.AUDCategories.category_name.TerminalServicesGateway")) continue;
                JSONObject item = new JSONObject();
                item.put("name", (Object)rb.getString(category.getName()));
                item.put("value", (Object)categoryId);
                actionCategories.put((Object)item);
                if (selectedCategory != null) continue;
                selectedCategory = String.valueOf(categoryId);
            }
            ret.put("actionCategories", (Object)actionCategories);
            ret.put("selectedCategory", selectedCategory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void getActionsForCategory(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String cvid = "15008";
            String category = request.getParameter("categoryId");
            String categoryTypeStr = request.getParameter("categoryType");
            int categoryType = Integer.parseInt(categoryTypeStr);
            Long categoryId = Long.parseLong(category);
            LinkedHashMap categories = AuditCatgoryAPI.getInstance().getCategories(Integer.valueOf(categoryType));
            int accessId = AuditActionsHandler.getAuditActionCategoryAccessType(request, response, categoryType);
            if (accessId == 0) {
                response.sendError(401);
                throw new Exception("ACCESS DENIED");
            }
            Category categoryObj = (Category)categories.get(categoryId);
            String categoryName = rb.getString(categoryObj.getName());
            ArrayList actionsList = AuditCategoryHandler.getInstance().getActionsForCategory(categoryId);
            JSONObject actionCategory = new JSONObject();
            actionCategory.put("categoryId", (Object)categoryId);
            actionCategory.put("categoryName", (Object)categoryName);
            actionCategory.put("categoryType", (Object)categoryTypeStr);
            JSONObject modifyJSON = actionCategory;
            modifyJSON.put("itemId", (Object)"new");
            modifyJSON.put("itemName", (Object)categoryName);
            JSONObject addnParamsMap = new JSONObject();
            if (accessId == 1) {
                addnParamsMap.put("readOnly", true);
            }
            for (int i = 0; i < actionsList.size(); ++i) {
                JSONObject emberTableData = EmberTableConfig.getInstance().getEmberTableData(cvid, actionsList, addnParamsMap, rb);
                JSONObject navigationObject = emberTableData.getJSONObject("tableInputParams");
                JSONObject tableData = emberTableData.getJSONObject("tableData");
                actionCategory.put("tableData", (Object)tableData);
                actionCategory.put("tableInputParams", (Object)navigationObject);
            }
            ret.put("actionCategory", (Object)actionCategory);
            ret.put("modifyJSON", (Object)modifyJSON);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void copyAction(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        String newActionName = "";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            JSONObject data = new JSONObject(request.getParameter("data"));
            Long id = data.getLong("id");
            newActionName = data.getString("newName");
            boolean status = AuditActionHandler.copyAction((Long)id, (String)newActionName);
            if (status) {
                ret.put("success", true);
                ret.put("message", (Object)rb.getString("adap.config.actions.copysuccess"));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.handleGetObject("adap.CopyAuditAction.audit_entry.copy_action_successfully", new String[]{newActionName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.copy_audit_actoin", "-"}));
            } else {
                ret.put("message", (Object)rb.getString("adap.config.actions.copyfail"));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.handleGetObject("adap.CopyAuditAction.audit_entry.copy_action_failed", new String[]{newActionName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.copy_audit_actoin", "-"}));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                ret.put("message", (Object)rb.getString("adap.config.actions.copyfail"));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.handleGetObject("adap.CopyAuditAction.audit_entry.copy_action_failed", new String[]{newActionName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.copy_audit_actoin", "-"}));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void deleteAction(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            JSONObject data = new JSONObject(request.getParameter("data"));
            Long actionId = data.getLong("id");
            String action = data.getString("action");
            Boolean status = false;
            if (action.equals("check")) {
                status = AuditActionHandler.deleteCheck((Long)actionId);
                if (status.booleanValue()) {
                    ret.put("canDelete", true);
                } else {
                    ret.put("message", (Object)rb.getString("adap.AUDMESSAGE.delete_response_no"));
                }
            } else {
                Row row = ReportUtil.getFirstRow((String)"AUDAction", (String)"ACTION_ID", (Object)actionId, (int)0);
                status = AuditActionHandler.deleteAction((Long)actionId);
                if (status.booleanValue()) {
                    ret.put("success", true);
                    ret.put("message", (Object)rb.getString("adap.AUDMESSAGE.delete_response_yes"));
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Configuration", rb.handleGetObject("adap.DeleteAuditAction.audit_entry.Action_Deleted_successfully", new String[]{rb.getString((String)row.get("ACTION_NAME"))}), 16, 8, "adap.ADAPUserAuditSeverities.audit_name.deleted_audit_actions", "-"}));
                } else {
                    ret.put("message", (Object)rb.getString("adap.AUDMESSAGE.delete_response_no"));
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Configuration", rb.handleGetObject("adap.DeleteAuditAction.audit_entry.Error_while_Deleting", new String[]{rb.getString((String)row.get("ACTION_NAME"))}), 16, 16, "adap.ADAPUserAuditSeverities.audit_name.deleted_audit_actions", "-"}));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Configuration", rb.getString("adap.DeleteAuditAction.audit_entry.Failed_to_delete_action"), 16, 16, "adap.ADAPUserAuditSeverities.audit_name.deleted_audit_actions", "-"}));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void getActionConfig(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String actionIdStr = request.getParameter("actionId");
            Long categoryId = Long.parseLong(request.getParameter("categoryId"));
            int categoryType = Integer.parseInt(request.getParameter("categoryType"));
            int accessId = AuditActionsHandler.getAuditActionCategoryAccessType(request, response, categoryType);
            if (accessId != 32) {
                response.sendError(401);
                throw new Exception("ACCESS DENIED");
            }
            LinkedHashMap categories = AuditCatgoryAPI.getInstance().getCategories(Integer.valueOf(categoryType));
            Category categoryObj = (Category)categories.get(categoryId);
            String categoryName = rb.getString(categoryObj.getName());
            if (actionIdStr != null && !actionIdStr.equals("new")) {
                Long actionId = Long.parseLong(actionIdStr);
                JSONObject actionTable = AuditActionHandler.getActionDetails2((Long)actionId, (Long)categoryId);
                actionTable.put("categoryName", (Object)categoryName);
                ret.put("actionTable", (Object)actionTable);
            } else {
                JSONObject actionTable = AuditActionHandler.getActionDetails2(null, (Long)categoryId);
                actionTable.put("categoryName", (Object)categoryName);
                ret.put("actionTable", (Object)actionTable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void saveAction(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        String actionName = "";
        Boolean isSave = false;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            ret.put("message", (Object)rb.getString("adap.config.actions.savefail"));
            String strData = request.getParameter("data");
            JSONObject data = new JSONObject(strData);
            isSave = data.getBoolean("isSave");
            HashMap actionMap = JSONUtil.JSONObjectToMap((JSONObject)data);
            actionName = (String)actionMap.get("ACTION_NAME");
            if (!isSave.booleanValue()) {
                Long actionId = data.getLong("ACTION_ID");
                boolean status = AuditActionHandler.updateAction((HashMap)actionMap, (Long)actionId);
                if (status) {
                    ret.put("success", true);
                    ret.put("message", (Object)rb.getString("adap.config.actions.updatesuccess"));
                    logger.log(Level.INFO, "Action Updated " + actionName);
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.handleGetObject("adap.UpdateAuditAction.audit_entry.successfully_updated_action", new String[]{actionName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.updated_audit_actions", "-"}));
                }
            } else {
                boolean status = AuditActionHandler.saveAction((HashMap)actionMap);
                if (status) {
                    ret.put("success", true);
                    ret.put("message", (Object)rb.getString("adap.config.actions.savesuccess"));
                    logger.log(Level.INFO, "Action Saved " + actionName);
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Configuration", rb.handleGetObject("adap.SaveAuditAction.audit_entry.successfully_saved_action", new String[]{actionName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.saved_audit_action", "-"}));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                ret.put("message", (Object)(rb.getString("adap.config.actions.savefail") + "  " + e.getMessage()));
                if (!isSave.booleanValue()) {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.handleGetObject("adap.UpdateAuditAction.audit_entry.failed_to_update_action", new String[]{actionName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.updated_audit_actions", "-"}));
                } else {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Configuration", rb.handleGetObject("adap.SaveAuditAction.audit_entry.Failed_to_save_action", new String[]{actionName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.saved_audit_action", "-"}));
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }
}

