/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.config;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.config.GlobalExcludeConfig;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.common.EmberTableConfig;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.serveraudit.ServerConfigHandler;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.APIUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.JSONUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public class GlobalExcludeConfigHandler {
    private static volatile GlobalExcludeConfigHandler instance = null;
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static Logger logger = Logger.getLogger(GlobalExcludeConfigHandler.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GlobalExcludeConfigHandler getInstance() {
        if (instance != null) return instance;
        Class<GlobalExcludeConfigHandler> clazz = GlobalExcludeConfigHandler.class;
        synchronized (GlobalExcludeConfigHandler.class) {
            if (instance != null) return instance;
            instance = new GlobalExcludeConfigHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private GlobalExcludeConfigHandler() {
    }

    public void getExcudeConfigData(HttpServletRequest request, HttpServletResponse response) {
        try {
            GlobalExcludeConfigHandler.getInstance().getExcludeConfig(request, response, null, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void getExcludeConfig(HttpServletRequest request, HttpServletResponse response, String message, Boolean msgType) throws Exception {
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        JSONObject excludeTableInputParams = null;
        excludeTableInputParams = reportReqData.optJSONObject("excludeTableInputParams");
        if (excludeTableInputParams == null) {
            excludeTableInputParams = new JSONObject();
        }
        JSONObject excludeConfigData = new JSONObject();
        String uvhString = "AUDCVConfig:cv_id:15041";
        Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
        Criteria crit = new Criteria(Column.getColumn((String)"AUDTableViewConfig", (String)"CV_ID"), (Object)cvId, 0);
        DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDTableViewConfig", crit);
        HashMap<String, String> tableDetails = new HashMap<String, String>();
        if (!dob.isEmpty()) {
            Row r = dob.getFirstRow("AUDTableViewConfig");
            List al = r.getColumns();
            for (int i = 0; i < al.size(); ++i) {
                String key = String.valueOf(al.get(i));
                String value = String.valueOf(r.get((String)al.get(i)));
                tableDetails.put(key, value);
            }
        }
        Long tableId = Long.parseLong((String)tableDetails.get("TABLE_VIEW_ID"));
        if (!excludeTableInputParams.has("sortColumn")) {
            excludeTableInputParams.put("sortColumn", tableDetails.get("SORTCOLUMN"));
            excludeTableInputParams.put("sortOrder", tableDetails.get("SORTORDER"));
            excludeTableInputParams.put("sortTableName", (Object)"AUDExcludeRules");
        }
        ServerConfigHandler.getInstance().getRangeList(excludeTableInputParams);
        ArrayList<HashMap<String, Object>> tableAllColumnList = ServerConfigHandler.getInstance().getVisibleColumnList(cvId, true, true, true, null, null, rb);
        Integer count = GlobalExcludeConfig.getInstance().getExcludeDataCount(excludeTableInputParams, tableAllColumnList);
        excludeTableInputParams.put("totalCount", (Object)count);
        ArrayList excludeDataList = GlobalExcludeConfig.getInstance().getExcludeData(excludeTableInputParams, tableAllColumnList);
        HashMap returnListMap = new HashMap();
        JSONObject resultObj = EmberTableConfig.getInstance().getEmberTableData1(tableId, excludeDataList, tableAllColumnList, excludeTableInputParams, rb);
        JSONObject tableData = resultObj.getJSONObject("tableData");
        JSONArray variableList = GlobalExcludeConfig.getInstance().getVariableList();
        JSONArray eventIdList = GlobalExcludeConfig.getInstance().getEventNumberist();
        JSONArray operatorList = GlobalExcludeConfig.getInstance().getOperatorList();
        JSONArray machineTypeList = GlobalExcludeConfig.getInstance().getMachineTypeList();
        excludeConfigData.put("variableList", (Object)variableList);
        excludeConfigData.put("operatorList", (Object)operatorList);
        excludeConfigData.put("eventNumberList", (Object)eventIdList);
        excludeConfigData.put("machineTypeList", (Object)machineTypeList);
        JSONObject excludeRuleData = new JSONObject();
        excludeRuleData.put("selectedOperatorId", (Object)operatorList.getJSONObject(1).getString("value"));
        excludeRuleData.put("selectedVariableId", (Object)variableList.getJSONObject(1).getString("value"));
        excludeRuleData.put("selectedMachineType", 21);
        excludeRuleData.put("selectedMachineTypeText", (Object)(machineTypeList.getJSONObject(0).getString("value") + "," + machineTypeList.getJSONObject(1).getString("value") + "," + machineTypeList.getJSONObject(2).getString("value")));
        if (message != null) {
            excludeTableInputParams.put("message", (Object)message);
            excludeTableInputParams.put("type", (Object)msgType);
        }
        HashMap<String, Object> excludeTableData = new HashMap<String, Object>();
        excludeTableData.put("tableDataList", tableData.get("tableDataList"));
        excludeTableData.put("tableColumnList", tableAllColumnList);
        returnListMap.put("excludeTableData", excludeTableData);
        returnListMap.put("excludeTableInputParams", excludeTableInputParams);
        returnListMap.put("excludeConfigData", excludeConfigData);
        returnListMap.put("excludeRuleData", excludeRuleData);
        JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
    }

    public void saveExcudeConfigData(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = rb.getString("adap.config.excludeconfig.successfully.updated.the.exclude.rule");
        Boolean msgType = true;
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject excludeRuleData = reportReqData.optJSONObject("excludeRuleData");
            if (excludeRuleData.get("action").equals("add")) {
                Criteria criteria = new Criteria(Column.getColumn((String)"AUDExcludeRules", (String)"EVENT_NUMBER"), excludeRuleData.get("selectedEventNumber"), 0);
                criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDExcludeRules", (String)"VARIABLE_NAME"), excludeRuleData.get("selectedVariableId"), 2));
                criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDExcludeRules", (String)"VALUE"), excludeRuleData.get("ruleValue"), 2));
                criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDExcludeRules", (String)"OPERATOR"), excludeRuleData.get("selectedOperatorId"), 0));
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDExcludeRules", criteria);
                if (dataObj.isEmpty()) {
                    DataObject newDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                    Row ruleRow = new Row("AUDExcludeRules");
                    ruleRow.set("EVENT_NUMBER", excludeRuleData.get("selectedEventNumber"));
                    ruleRow.set("VARIABLE_NAME", excludeRuleData.get("selectedVariableId"));
                    ruleRow.set("VALUE", excludeRuleData.get("ruleValue"));
                    ruleRow.set("OPERATOR", excludeRuleData.get("selectedOperatorId"));
                    if (excludeRuleData.get("selectedEventNumber").toString().length() > 3) {
                        ruleRow.set("OS_VERSION", (Object)6);
                    } else {
                        ruleRow.set("OS_VERSION", (Object)5);
                    }
                    ruleRow.set("MACHINE_TYPE", excludeRuleData.get("selectedMachineType"));
                    newDataObj.addRow(ruleRow);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).add(newDataObj);
                } else {
                    message = rb.getString("adap.config.excludeconfig.already.the.same.exlude.exists");
                    msgType = false;
                }
            } else if (excludeRuleData.get("action").equals("modify")) {
                Criteria criteria = new Criteria(Column.getColumn((String)"AUDExcludeRules", (String)"EVENT_NUMBER"), excludeRuleData.get("selectedEventNumber"), 0);
                criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDExcludeRules", (String)"VARIABLE_NAME"), excludeRuleData.get("selectedVariableId"), 2));
                criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDExcludeRules", (String)"VALUE"), excludeRuleData.get("ruleValue"), 2));
                criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDExcludeRules", (String)"OPERATOR"), excludeRuleData.get("selectedOperatorId"), 0));
                criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDExcludeRules", (String)"RULE_ID"), excludeRuleData.get("selectedRuleId"), 1));
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDExcludeRules", criteria);
                if (dataObj.isEmpty()) {
                    Criteria ruleCriteria = new Criteria(Column.getColumn((String)"AUDExcludeRules", (String)"RULE_ID"), excludeRuleData.get("selectedRuleId"), 0);
                    DataObject newDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDExcludeRules", ruleCriteria);
                    Row ruleRow = newDataObj.getFirstRow("AUDExcludeRules");
                    ruleRow.set("EVENT_NUMBER", excludeRuleData.get("selectedEventNumber"));
                    ruleRow.set("VARIABLE_NAME", excludeRuleData.get("selectedVariableId"));
                    ruleRow.set("VALUE", excludeRuleData.get("ruleValue"));
                    ruleRow.set("OPERATOR", excludeRuleData.get("selectedOperatorId"));
                    if (excludeRuleData.get("selectedEventNumber").toString().length() > 3) {
                        ruleRow.set("OS_VERSION", (Object)6);
                    } else {
                        ruleRow.set("OS_VERSION", (Object)5);
                    }
                    ruleRow.set("MACHINE_TYPE", excludeRuleData.get("selectedMachineType"));
                    newDataObj.updateRow(ruleRow);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update(newDataObj);
                } else {
                    message = rb.getString("adap.config.excludeconfig.already.the.same.exlude.exists");
                    msgType = false;
                }
            } else if (excludeRuleData.get("action").equals("delete")) {
                ArrayList selectedRuleList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)excludeRuleData.getJSONArray("selectedRuleIdList"));
                Long[] id = new Long[excludeRuleData.getJSONArray("selectedRuleIdList").length()];
                for (int i = 0; i < excludeRuleData.getJSONArray("selectedRuleIdList").length(); ++i) {
                    Integer temp = (Integer)selectedRuleList.get(i);
                    id[i] = temp.longValue();
                }
                Criteria criteria = new Criteria(Column.getColumn((String)"AUDExcludeRules", (String)"RULE_ID"), (Object)selectedRuleList.toArray(), 8);
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(criteria);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = rb.getString("adap.config.excludeconfig.error.while.updating.the.rule");
            msgType = false;
        }
        GlobalExcludeConfigHandler.getInstance().getExcludeConfig(request, response, message, msgType);
    }
}

