/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.config;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditCategoryHandler;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditCatgoryAPI;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditMonitorAPI;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditMonitorHandler;
import com.adventnet.sym.adsm.auditing.server.monitor.Category;
import com.adventnet.sym.adsm.auditing.server.monitor.MonitorManager;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.common.EmberTableConfig;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReportProfilesHandler {
    private static volatile ReportProfilesHandler instance = null;
    private static Logger logger = Logger.getLogger(ReportProfilesHandler.class.getName());
    private static HashMap actionCategoryMapping = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReportProfilesHandler getInstance() {
        if (instance != null) return instance;
        Class<ReportProfilesHandler> clazz = ReportProfilesHandler.class;
        synchronized (ReportProfilesHandler.class) {
            if (instance != null) return instance;
            instance = new ReportProfilesHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void viewReportProfiles(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String cvid = "15007";
            String domainName = request.getParameter("selectedDomain");
            String categoryId = request.getParameter("CategoryId");
            String sortColumn = request.getParameter("sortColumn");
            String sortOrder = request.getParameter("sortOrder");
            int accessId = ReportProfilesHandler.isReportProfileAccessible(request, response, categoryId);
            if (accessId == 0) {
                response.sendError(401);
                throw new Exception("ACCESS DENIED");
            }
            HashMap<String, String> tableDetails = EmberTableConfig.getInstance().getTableDetails(cvid);
            if (sortColumn == null) {
                sortColumn = tableDetails.get("SORTCOLUMN");
            }
            if (sortOrder == null) {
                sortOrder = tableDetails.get("SORTORDER");
            }
            String categoryName = "Report Profiles";
            if (!categoryId.equalsIgnoreCase("All")) {
                LinkedHashMap categories = AuditCatgoryAPI.getInstance().getCategories();
                Category category = (Category)categories.get(Long.parseLong(categoryId));
                categoryName = rb.getString(category.getName()) + " " + rb.getString("adap.configuration.configure_alerts.report_profiles.text");
            } else {
                categoryName = rb.getString("adap.configuration.tree_component.my_report_profiles");
            }
            HashMap<String, String> addnParamsMap = new HashMap<String, String>();
            JSONObject addnParamsMap2 = new JSONObject();
            addnParamsMap.put("sortColumn", sortColumn);
            addnParamsMap.put("sortOrder", sortOrder);
            addnParamsMap2.put("sortColumn", (Object)sortColumn);
            addnParamsMap2.put("sortOrder", (Object)sortOrder);
            if (accessId == 1) {
                addnParamsMap2.put("readOnly", true);
            }
            ArrayList monitorsList = new ArrayList();
            monitorsList = categoryId.equals("All") ? AuditMonitorAPI.getInstance().getMonitorsList(null, "All", "All", addnParamsMap, "true", null) : AuditMonitorAPI.getInstance().getMonitorsList(null, domainName, categoryId, addnParamsMap, null, null);
            ret = EmberTableConfig.getInstance().getEmberTableData(cvid, monitorsList, addnParamsMap2, rb);
            ret.put("headingLabel", (Object)categoryName);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Configuration", rb.handleGetObject("adap.ViewMonitor.audit_entry.Report_profiles_viewed", new String[]{categoryName, domainName}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.report_profiles_viewed", "-"}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static int isReportProfileAccessible(HttpServletRequest request, HttpServletResponse response, String categoryId) {
        int ret = 0;
        try {
            Long id;
            if (actionCategoryMapping.size() == 0) {
                actionCategoryMapping = new HashMap();
                Criteria crit = new Criteria(Column.getColumn((String)"AUDLeftTreeComponents", (String)"TILE_ROUTE_NAME"), (Object)"config.viewreportprofiles", 0);
                DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDLeftTreeComponents", crit);
                Iterator iter = dataObject.getRows("AUDLeftTreeComponents");
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    String modelId = AdminHandler.categoryIdReplaceInURL((String)((String)row.get("TILE_MODEL_ID")));
                    actionCategoryMapping.put(modelId, row.get("ACTION_ID"));
                }
                String modelId = AdminHandler.categoryIdReplaceInURL((String)"${CATEGORY_ID:20}");
                actionCategoryMapping.put(modelId, TDConstants.CONFIG_FS);
                modelId = AdminHandler.categoryIdReplaceInURL((String)"${CATEGORY_ID:34}");
                actionCategoryMapping.put(modelId, TDConstants.CONFIG_FIM);
            }
            HttpSession session = request.getSession();
            ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
            HashMap actionAccesses = authObject.getAccesses();
            String actionId = String.valueOf(actionCategoryMapping.get(categoryId));
            if (actionId != null && actionAccesses.containsKey(id = Long.valueOf(Long.parseLong(actionId)))) {
                ret = (Integer)actionAccesses.get(id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void enableDisableMonitor(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String data = request.getParameter("data");
            JSONObject data2 = new JSONObject(data);
            Long monitorId = data2.getLong("monitorId");
            String action = data2.getString("action");
            ret.put("message", (Object)rb.getString("adap.common.failureoccured"));
            boolean b = AuditMonitorHandler.getInstance().enableDisableMonitor(monitorId, action);
            if (monitorId != null) {
                ArrayList<Long> monitorList = new ArrayList<Long>();
                monitorList.add(monitorId);
                MonitorManager.getInstance().updateMonitorMap(monitorList, action);
            }
            if (b) {
                String message = "";
                ret.put("success", true);
                message = action.equals("Enable") ? rb.getString("adap.EnableDisableMonitor.Successfully_enabled_report_profile") : rb.getString("adap.EnableDisableMonitor.Successfully_disabled_report_profile");
                ret.put("message", (Object)message);
                Row row = ReportUtil.getFirstRow((String)"AUDMonitor", (String)"MONITOR_ID", (Object)monitorId, (int)0);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", message + "\n" + rb.handleGetObject("adap.EnableDisableMonitor.audit_entry_addn.Monitor_and_domain", new String[]{rb.getString((String)row.get("MONITOR_NAME")), data2.getString("domainName")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.changed_report_profile", "-"}));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                ret.put("message", (Object)e.getMessage());
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void deleteMonitor(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String data = request.getParameter("data");
            JSONObject data2 = new JSONObject(data);
            Long monitorId = data2.getLong("monitorId");
            ret.put("message", (Object)rb.getString("adap.DeleteMonitor.Error_in_deleting_the_Report"));
            boolean status = AuditMonitorHandler.getInstance().canDelete(monitorId);
            Row row = ReportUtil.getFirstRow((String)"AUDMonitor", (String)"MONITOR_ID", (Object)monitorId, (int)0);
            String monitorName = (String)row.get("MONITOR_NAME");
            if (status) {
                status = AuditMonitorHandler.getInstance().deleteMonitor(monitorId);
                if (status) {
                    ret.put("success", true);
                    ret.put("message", (Object)rb.getString("adap.DeleteMonitor.Successfully_deleted_the_Report_Profile"));
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Configuration", rb.handleGetObject("adap.DeleteMonitor.audit_entry.Successfully_deleted_the_Report_Profile", new String[]{monitorName}), 16, 8, "adap.ADAPUserAuditSeverities.audit_name.deleted_monitor", "-"}));
                } else {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Configuration", rb.handleGetObject("adap.DeleteMonitor.audit_entry.Error_in_deleting_the_Report", new String[]{monitorName}), 16, 16, "adap.ADAPUserAuditSeverities.audit_name.deleted_monitor", "-"}));
                }
            } else {
                ret.put("message", (Object)rb.getString("adap.admin.reportprofiles.defaultprofilecantbedeleted"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                ret.put("message", (Object)e.getMessage());
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Configuration", rb.getString("adap.DeleteMonitor.Error_in_deleting_the_Report"), 16, 16, "adap.ADAPUserAuditSeverities.audit_name.deleted_monitor", e.getMessage()}));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void getReportConfig(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            JSONObject reportProfileData = new JSONObject();
            JSONArray categoryArray = new JSONArray();
            String categoryTypeStr = request.getParameter("categoryType");
            int categoryType = Integer.parseInt(categoryTypeStr);
            Long selectedCategory = null;
            LinkedHashMap categories = AuditCatgoryAPI.getInstance().getCategories(Integer.valueOf(categoryType));
            Set keySet = categories.keySet();
            for (Long categoryId : keySet) {
                Category category = (Category)categories.get(categoryId);
                if (category.getName().equalsIgnoreCase("adap.AUDBackupDataConfig.Print_Server_Auditing") || category.getName().equalsIgnoreCase("adap.AUDCategories.category_name.TerminalServicesGateway")) continue;
                JSONObject item = new JSONObject();
                if (ReportProfilesHandler.isReportProfileAccessible(request, response, String.valueOf(categoryId)) != 32) continue;
                item.put("name", (Object)rb.getString(category.getName()));
                item.put("value", (Object)categoryId);
                categoryArray.put((Object)item);
                if (selectedCategory != null) continue;
                selectedCategory = categoryId;
            }
            reportProfileData.put("categoryArray", (Object)categoryArray);
            reportProfileData.put("selectedCategory", selectedCategory);
            reportProfileData.put("selectedActionsText", (Object)"NO ACTION SELECTED");
            reportProfileData.put("selectedActionsList", (Object)new JSONArray());
            reportProfileData.put("selectedNamesList", (Object)new JSONArray());
            reportProfileData.put("isSave", true);
            reportProfileData.put("selectedObjectsArray", (Object)new JSONArray());
            String categoryIdStr = request.getParameter("categoryId");
            if (categoryIdStr != null) {
                Long monitorId = Long.parseLong(categoryIdStr);
                HashMap monitorMap = AuditMonitorAPI.getInstance().getMonitorDetails(monitorId);
                reportProfileData.put("name", (Object)rb.getString((String)monitorMap.get("MONITOR_NAME")));
                reportProfileData.put("description", monitorMap.get("MONITOR_DESCRIPTION"));
                reportProfileData.put("selectedCategory", monitorMap.get("CATEGORY_ID"));
                ArrayList selectedActionsList = (ArrayList)monitorMap.get("selectedActionsList");
                JSONArray selectedActionsArray = new JSONArray();
                for (int i = 0; i < selectedActionsList.size(); ++i) {
                    selectedActionsArray.put(selectedActionsList.get(i));
                }
                reportProfileData.put("selectedActionsList", (Object)selectedActionsArray);
                Category category = AuditCatgoryAPI.getInstance().getCategoryObject(monitorMap.get("CATEGORY_ID"));
                ObjectClass monitorResultObjectClass = category.getResultObjectClass();
                String resultObjectClass = monitorResultObjectClass.getDisplayText();
                HashMap selectedObjectsMap = (HashMap)monitorMap.get("selectedObjectsMap");
                JSONArray selectedObjectsArray = new JSONArray();
                Set keys = selectedObjectsMap.keySet();
                if (categoryType == 1) {
                    for (String objClassStr : keys) {
                        ObjectClass objClass = DirectoryObjectAPI.getInstance().getObjectClass(objClassStr);
                        ArrayList groupList = (ArrayList)selectedObjectsMap.get(objClass.getObjectClass());
                        JSONObject groupObject = new JSONObject();
                        groupObject.put("name", (Object)objClass.getDisplayText());
                        groupObject.put("objectClass", (Object)objClass.getObjectClass());
                        if (objClass.getDisplayText().equals("Domain")) {
                            groupObject.put("displayText", (Object)rb.handleGetObject("adap.ADSelectObjects.all_of_domain", new String[]{resultObjectClass}));
                        } else if (objClass.getDisplayText().equals(resultObjectClass)) {
                            groupObject.put("displayText", (Object)(objClass.getDisplayText() + "s"));
                        } else {
                            groupObject.put("displayText", (Object)rb.handleGetObject("adap.Configuration.Monitor.all_object_of_objects", new String[]{resultObjectClass, objClass.getDisplayText()}));
                        }
                        JSONArray membersArray = new JSONArray();
                        for (int j = 0; j < groupList.size(); ++j) {
                            HashMap memberMap = (HashMap)groupList.get(j);
                            JSONObject memberObject = new JSONObject();
                            memberObject.put("name", memberMap.get("NAME"));
                            if (objClass.getDisplayText().equals("Domain")) {
                                memberObject.put("value", (Object)"allobjects");
                            } else {
                                memberObject.put("value", memberMap.get("OBJECT_GUID"));
                            }
                            membersArray.put((Object)memberObject);
                        }
                        groupObject.put("objects", (Object)membersArray);
                        selectedObjectsArray.put((Object)groupObject);
                    }
                } else if (categoryType == 2) {
                    for (String serverName : keys) {
                        ArrayList sharesList = (ArrayList)selectedObjectsMap.get(serverName);
                        JSONObject groupObject = new JSONObject();
                        groupObject.put("name", (Object)serverName);
                        groupObject.put("objectClass", (Object)"share");
                        groupObject.put("displayText", (Object)"Shares");
                        JSONArray membersArray = new JSONArray();
                        for (int j = 0; j < sharesList.size(); ++j) {
                            String shareName = (String)sharesList.get(j);
                            JSONObject memberObject = new JSONObject();
                            memberObject.put("name", (Object)shareName);
                            membersArray.put((Object)memberObject);
                        }
                        groupObject.put("objects", (Object)membersArray);
                        selectedObjectsArray.put((Object)groupObject);
                    }
                }
                reportProfileData.put("selectedObjectsArray", (Object)selectedObjectsArray);
                JSONObject domainData = new JSONObject();
                JSONArray retArray = new JSONArray();
                JSONObject jo = new JSONObject();
                jo.put("name", monitorMap.get("DOMAIN_NAME"));
                jo.put("value", monitorMap.get("DOMAIN_NAME"));
                retArray.put((Object)jo);
                domainData.put("domainsList", (Object)retArray);
                domainData.put("selectedDomain", monitorMap.get("DOMAIN_NAME"));
                reportProfileData.put("domainData", (Object)domainData);
                reportProfileData.put("isSave", false);
            }
            ret.put("reportProfileData", (Object)reportProfileData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void getActionsForCategory(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String categoryIdStr = request.getParameter("selectedCategory");
            Long categoryId = Long.parseLong(categoryIdStr);
            JSONArray actionsArray = new JSONArray();
            AuditCategoryHandler categoryHandler = AuditCategoryHandler.getInstance();
            ArrayList availableActionsList = categoryHandler.getActionsForCategory(categoryId);
            Category category = AuditCatgoryAPI.getInstance().getCategoryObject((Object)categoryId);
            ObjectClass[] monitorSelectObjectClasses = category.getCategorySelectObjects();
            ObjectClass monitorResultObjectClass = category.getResultObjectClass();
            for (int i = 0; i < availableActionsList.size(); ++i) {
                JSONObject action = new JSONObject();
                action.put("columnValue", ((Hashtable)availableActionsList.get(i)).get("ACTION_ID"));
                action.put("actionName", (Object)rb.getString((String)((Hashtable)availableActionsList.get(i)).get("ACTION_NAME")));
                actionsArray.put((Object)action);
            }
            ret.put("categoryActions", (Object)actionsArray);
            JSONObject selectObjectOptions = new JSONObject();
            selectObjectOptions.put("showObjectSelect", (Object)Boolean.valueOf(category.getShowSelectObjects()));
            selectObjectOptions.put("selectObjectsText", (Object)rb.handleGetObject("adap.ADSelectObjects.Select_s", new String[]{monitorResultObjectClass.getDisplayText()}));
            selectObjectOptions.put("resultObjectClass", (Object)monitorResultObjectClass.getObjectClass());
            JSONArray selectObjectClassesArray = new JSONArray();
            for (int i = 0; monitorSelectObjectClasses != null && i < monitorSelectObjectClasses.length; ++i) {
                String cv_id;
                JSONObject selectObjectClass = new JSONObject();
                String url = monitorSelectObjectClasses[i].getObjectSelectURL();
                String[] cvids = url.split("&cv_id=");
                if (url.toLowerCase().indexOf("objectclass=ldapquery") != -1) {
                    cv_id = "-1";
                    if (monitorResultObjectClass.getObjectClass().equalsIgnoreCase("user")) {
                        cv_id = "15";
                    } else if (monitorResultObjectClass.getObjectClass().equalsIgnoreCase("computer")) {
                        cv_id = "12";
                    } else if (monitorResultObjectClass.getObjectClass().equalsIgnoreCase("group")) {
                        cv_id = "25";
                    } else if (monitorResultObjectClass.getObjectClass().equalsIgnoreCase("organizationalUnit")) {
                        cv_id = "23";
                    }
                    if (!cv_id.equals("-1")) {
                        selectObjectClass.put("cvId", (Object)cv_id);
                        selectObjectClassesArray.put((Object)selectObjectClass);
                    }
                }
                if (cvids.length <= 1) continue;
                cv_id = url.split("&cv_id=")[1];
                selectObjectClass.put("cvId", (Object)cv_id);
                selectObjectClassesArray.put((Object)selectObjectClass);
            }
            selectObjectOptions.put("selectObjectClassesArray", (Object)selectObjectClassesArray);
            ret.put("selectObjectOptions", (Object)selectObjectOptions);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void saveMonitor(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            int j;
            JSONArray membersArray;
            JSONObject groupObject;
            int i;
            ret.put("message", (Object)"Unable to save monitor");
            String strData = request.getParameter("data");
            JSONObject data1 = new JSONObject(strData);
            JSONObject data = data1.optJSONObject("createReportJSON");
            boolean isSave = data.getBoolean("isSave");
            Long categoryId = data.getLong("categoryId");
            Long categoryType = data.getLong("categoryType");
            HashMap<String, Object> propsMap = new HashMap<String, Object>();
            propsMap.put("MONITOR_NAME", data.getString("name"));
            propsMap.put("MONITOR_DESCRIPTION", data.getString("description"));
            propsMap.put("CATEGORY_ID", data.getLong("categoryId"));
            propsMap.put("MONITOR_TYPE", data.getInt("categoryType"));
            propsMap.put("DOMAIN_NAME", data.getString("domain"));
            HashMap selectedObjectsMap = new HashMap();
            JSONArray selectedObjectsArray = data.optJSONArray("selectedObjectsArray");
            if (categoryType == 1L) {
                for (i = 0; i < selectedObjectsArray.length(); ++i) {
                    ArrayList groupList = new ArrayList();
                    groupObject = selectedObjectsArray.getJSONObject(i);
                    String objClass = groupObject.getString("objectClass");
                    membersArray = groupObject.getJSONArray("objects");
                    for (j = 0; j < membersArray.length(); ++j) {
                        HashMap<String, String> memberMap = new HashMap<String, String>();
                        JSONObject member = membersArray.getJSONObject(j);
                        String memberName = member.getString("name");
                        String memberGUID = member.getString("value");
                        memberMap.put("NAME", memberName);
                        memberMap.put("OBJECT_GUID", memberGUID);
                        groupList.add(memberMap);
                    }
                    selectedObjectsMap.put(objClass, groupList);
                    if (!objClass.equals("domainDNS")) continue;
                    selectedObjectsMap = null;
                    break;
                }
            } else if (categoryType == 2L) {
                for (i = 0; i < selectedObjectsArray.length(); ++i) {
                    ArrayList<String> shareList = new ArrayList<String>();
                    groupObject = selectedObjectsArray.getJSONObject(i);
                    String serverName = groupObject.getString("name");
                    membersArray = groupObject.getJSONArray("objects");
                    for (j = 0; j < membersArray.length(); ++j) {
                        JSONObject member = membersArray.getJSONObject(j);
                        String memberName = member.getString("name");
                        shareList.add(memberName);
                    }
                    selectedObjectsMap.put(serverName, shareList);
                }
            }
            ArrayList<Long> actionsList = new ArrayList<Long>();
            JSONArray actionsArray = data.optJSONArray("actionsArray");
            for (int i2 = 0; i2 < actionsArray.length(); ++i2) {
                actionsList.add(Long.parseLong(String.valueOf(actionsArray.get(i2))));
            }
            HashMap categoryColumnMap = AuditCategoryHandler.getInstance().getCategoryReportColumns((Object)categoryId);
            HashMap categoryElementColumnMap = AuditCategoryHandler.getInstance().getCategoryElementMapColumns((Object)categoryId);
            String defaultSortColumn = AuditCategoryHandler.getInstance().getDeafultSortColumn(categoryId);
            Boolean status = false;
            if (isSave) {
                status = AuditMonitorHandler.getInstance().saveMonitor(propsMap, actionsList, selectedObjectsMap, categoryColumnMap, defaultSortColumn, categoryElementColumnMap);
                if (status.booleanValue()) {
                    ret.put("success", true);
                    ret.put("message", (Object)rb.getString("adap.SaveMonitor.Successfully_Saved_the_Report_Profile"));
                    logger.log(Level.INFO, rb.getString("adap.SaveMonitor.Successfully_Saved_the_Report_Profile") + "  " + propsMap.get("MONITOR_NAME"));
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Configuration", rb.handleGetObject("adap.SaveMonitor.audit_entry.Successfully_saved_the_report_profile", new String[]{(String)propsMap.get("MONITOR_NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.saved_report_profiles", "-"}));
                }
            } else {
                Long monitorId = data.getLong("monitorId");
                status = AuditMonitorHandler.getInstance().updateMonitor(monitorId, propsMap, actionsList, selectedObjectsMap);
                if (status.booleanValue()) {
                    ret.put("success", true);
                    ret.put("message", (Object)rb.getString("adap.UpdateMonitor.Successfully_Updated_the_Report_Profile"));
                    logger.log(Level.INFO, rb.getString("adap.UpdateMonitor.Successfully_Updated_the_Report_Profile") + "  " + propsMap.get("MONITOR_NAME"));
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.handleGetObject("adap.UpdateMonitor.audit_entry.Successfully_update_report_profiles", new String[]{(String)propsMap.get("MONITOR_NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.updated_report_profiles", "-"}));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }
}

