/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.fileaudit;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.EventDataHandler;
import com.adventnet.sym.adsm.auditing.server.delegation.AuditDelegationUtil;
import com.adventnet.sym.adsm.auditing.server.fileaudit.FileServerHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.cluster.ClusterHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.cluster.ClusterMonitorCriteria;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.common.EmberTableConfig;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.serveraudit.ServerConfigHandler;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.APIUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.ntfs.FileSystemAPI;
import com.adventnet.sym.adsm.common.server.ntfs.cluster.ClusterConfigAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.JSONUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public class FileClusterConfigHandler {
    private static volatile FileClusterConfigHandler instance = null;
    public static final String CLUSTER_TABLE_NAME = "AUDClusterDetails";
    public static final String CLUSTER_NODE_TABLE_NAME = "AUDClusterNodeDetails";
    public static final String CLUSTER_CAP_TABLE_NAME = "AUDClusterCAPDetails";
    public static final String CLUSTER_CONFIG_TABLE_NAME = "AUDClusterConfiguration";
    public static final String CLUSTER_CAP_CONFIG_TABLE_NAME = "AUDClusterCAPConfiguration";
    public static final String CLUSTER_NODE_CONFIG_TABLE_NAME = "AUDClusterNodeConfiguration";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileClusterConfigHandler getInstance() {
        if (instance != null) return instance;
        Class<FileClusterConfigHandler> clazz = FileClusterConfigHandler.class;
        synchronized (FileClusterConfigHandler.class) {
            if (instance != null) return instance;
            instance = new FileClusterConfigHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private FileClusterConfigHandler() {
    }

    public void validateCluster(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = null;
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        JSONObject clusterInputParams = null;
        clusterInputParams = reportReqData.getJSONObject("inputParams");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String CLUSTER_NAME = clusterInputParams.getString("clusterName");
            String domainName = clusterInputParams.getString("domainName");
            Long clusterId = ClusterConfigAPI.validateClusterName((String)CLUSTER_NAME, (String)domainName);
            if (clusterId == null || clusterId.equals("")) {
                throw new Exception(rb.getString("adap.ClusterAction.Error_occured_ClusterID_could_not_be_null"));
            }
            clusterInputParams.put("clusterId", (Object)clusterId);
            clusterInputParams.put("clusterName", (Object)CLUSTER_NAME);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = ex.getMessage();
        }
        HashMap<String, JSONObject> returnListMap = new HashMap<String, JSONObject>();
        clusterInputParams.put("message", (Object)message);
        clusterInputParams.put("type", (Object)"failure");
        returnListMap.put("inputParams", clusterInputParams);
        JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
    }

    public void getClusterNodes(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = null;
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        JSONObject clusterNodeInputParams = null;
        clusterNodeInputParams = reportReqData.getJSONObject("clusterNodeConfigInputParams");
        JSONObject clusterConfigInputParams = reportReqData.getJSONObject("clusterConfigInputParams");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String clusterName = clusterConfigInputParams.getString("clusterName");
            String domainName = clusterConfigInputParams.getString("domainName");
            Long clusterId = clusterConfigInputParams.getLong("clusterId");
            String refresh = clusterNodeInputParams.getString("refresh");
            ArrayList nodeList = new ArrayList();
            String uvhString = "AUDCVConfig:cv_id:15018";
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDTableViewConfig", (String)"CV_ID"), (Object)cvId, 0);
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDTableViewConfig", crit);
            HashMap<String, String> tableDetails = new HashMap<String, String>();
            if (!dob.isEmpty()) {
                Row r = dob.getFirstRow("AUDTableViewConfig");
                List al = r.getColumns();
                for (int i = 0; i < al.size(); ++i) {
                    String key = String.valueOf(al.get(i));
                    String value = String.valueOf(r.get((String)al.get(i)));
                    tableDetails.put(key, value);
                }
            }
            Long tableId = Long.parseLong((String)tableDetails.get("TABLE_VIEW_ID"));
            ArrayList<HashMap<String, Object>> tableAllColumnList = ServerConfigHandler.getInstance().getVisibleColumnList(cvId, true, true, true, null, null, rb);
            Boolean isSearch = false;
            String searchTxt = this.getSearchCriteria(clusterNodeInputParams, tableAllColumnList, false);
            if (searchTxt != null) {
                isSearch = true;
            }
            if (clusterConfigInputParams.opt("pageList") == null) {
                this.getClusterConfigPageInputParams(clusterConfigInputParams, rb);
            }
            clusterNodeInputParams.put("changeAction", (Object)"getClusterNodes");
            clusterNodeInputParams.put("refreshAction", (Object)"refreshClusterNodes");
            clusterNodeInputParams.put("emptyTableAction", (Object)"clusterNodesEmpty");
            clusterNodeInputParams.put("hideTopDivider", true);
            clusterNodeInputParams.put("hideBorder", true);
            Hashtable nodeTable = ClusterConfigAPI.getInstance().getClusterNodeInfo(domainName, clusterName, clusterId, searchTxt, refresh);
            nodeList = (ArrayList)nodeTable.get("Nodes");
            int nodeCount = nodeList.size();
            message = (String)nodeTable.get("message");
            clusterNodeInputParams.put("refresh", false);
            if (message != null) {
                clusterNodeInputParams.put("filterText", (Object)message);
                clusterNodeInputParams.put("showFilterText", true);
            }
            if (nodeCount == 0) {
                if (message != null) {
                    clusterNodeInputParams.put("emptyTableMessage", (Object)message);
                } else {
                    clusterNodeInputParams.put("emptyTableMessage", (Object)rb.getString((String)tableDetails.get("EMPTY_TABLE_MESSAGE")));
                }
                if (isSearch.booleanValue()) {
                    clusterNodeInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                    clusterNodeInputParams.put("emptyTableMessage2", (Object)rb.getString("adap.common.text.policy_update_link.click_here"));
                } else {
                    clusterNodeInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                    clusterNodeInputParams.put("emptyTableMessage2", (Object)rb.getString("adap_ServerConfig.click_here_to_refresh"));
                }
            }
            clusterNodeInputParams.put("totalCount", nodeList.size());
            clusterNodeInputParams.put("isSearch", (Object)isSearch);
            clusterNodeInputParams.put("tableName", (Object)"clusterNodeTable");
            clusterNodeInputParams.put("selObjNameIndex", (Object)"1");
            HashMap<String, Object> returnListMap = new HashMap<String, Object>();
            JSONObject resultObj = EmberTableConfig.getInstance().getEmberTableData1(tableId, nodeList, tableAllColumnList, clusterNodeInputParams, rb);
            JSONObject tableData = resultObj.getJSONObject("tableData");
            returnListMap.put("clusterNodeData", tableData.get("tableDataList"));
            returnListMap.put("clusterNodeColumnList", tableAllColumnList);
            returnListMap.put("clusterNodeConfigInputParams", clusterNodeInputParams);
            returnListMap.put("clusterConfigInputParams", clusterConfigInputParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = ex.getMessage();
        }
    }

    public void getClusterCAPS(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = null;
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        JSONObject clusterCAPInputParams = null;
        clusterCAPInputParams = reportReqData.getJSONObject("clusterCAPConfigInputParams");
        JSONObject clusterConfigInputParams = reportReqData.getJSONObject("clusterConfigInputParams");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String domainName = clusterConfigInputParams.getString("domainName");
            String clusterName = clusterConfigInputParams.getString("clusterName");
            Long clusterId = clusterConfigInputParams.getLong("clusterId");
            String refresh = clusterCAPInputParams.getString("refresh");
            String uvhString = "AUDCVConfig:cv_id:15019";
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDTableViewConfig", (String)"CV_ID"), (Object)cvId, 0);
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDTableViewConfig", crit);
            HashMap<String, String> tableDetails = new HashMap<String, String>();
            if (!dob.isEmpty()) {
                Row r = dob.getFirstRow("AUDTableViewConfig");
                List al = r.getColumns();
                for (int i = 0; i < al.size(); ++i) {
                    String key = String.valueOf(al.get(i));
                    String value = String.valueOf(r.get((String)al.get(i)));
                    tableDetails.put(key, value);
                }
            }
            Long tableId = Long.parseLong((String)tableDetails.get("TABLE_VIEW_ID"));
            ArrayList<HashMap<String, Object>> tableAllColumnList = ServerConfigHandler.getInstance().getVisibleColumnList(cvId, true, true, true, null, null, rb);
            Boolean isSearch = false;
            String searchTxt = this.getSearchCriteria(clusterCAPInputParams, tableAllColumnList, false);
            if (searchTxt != null) {
                isSearch = true;
            }
            if (clusterConfigInputParams.opt("pageList") == null) {
                this.getClusterConfigPageInputParams(clusterConfigInputParams, rb);
            }
            clusterCAPInputParams.put("changeAction", (Object)"getClusterCAPS");
            clusterCAPInputParams.put("refreshAction", (Object)"refreshClusterCAPS");
            clusterCAPInputParams.put("emptyTableAction", (Object)"clusterCAPSEmpty");
            clusterCAPInputParams.put("hideTopDivider", true);
            clusterCAPInputParams.put("hideBorder", true);
            ServerConfigHandler.getInstance().getRangeList(clusterCAPInputParams);
            ArrayList capList = new ArrayList();
            Hashtable capTable = ClusterConfigAPI.getInstance().getClusterResourceInfo(domainName, clusterName, clusterId, searchTxt, null, null, refresh);
            capList = (ArrayList)capTable.get("Caps");
            int count = capList.size();
            message = (String)capTable.get("message");
            if (count > 0) {
                refresh = "false";
                capTable = ClusterConfigAPI.getInstance().getClusterResourceInfo(domainName, clusterName, clusterId, searchTxt, Integer.valueOf(clusterCAPInputParams.getInt("startValue")), Integer.valueOf(clusterCAPInputParams.getInt("rangeValue")), refresh);
                capList = (ArrayList)capTable.get("Caps");
            }
            clusterCAPInputParams.put("refresh", false);
            count = capList.size();
            if (message != null) {
                clusterCAPInputParams.put("filterText", (Object)message);
                clusterCAPInputParams.put("showFilterText", true);
            }
            if (count == 0) {
                if (message != null) {
                    clusterCAPInputParams.put("emptyTableMessage", (Object)message);
                } else {
                    clusterCAPInputParams.put("emptyTableMessage", (Object)rb.getString((String)tableDetails.get("EMPTY_TABLE_MESSAGE")));
                }
                if (isSearch.booleanValue()) {
                    clusterCAPInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                    clusterCAPInputParams.put("emptyTableActionText", (Object)rb.getString("adap.common.text.policy_update_link.click_here"));
                } else {
                    clusterCAPInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                    clusterCAPInputParams.put("emptyTableActionText", (Object)rb.getString("adap_ServerConfig.click_here_to_refresh"));
                }
            }
            clusterCAPInputParams.put("totalCount", capList.size());
            clusterCAPInputParams.put("isSearch", (Object)isSearch);
            clusterCAPInputParams.put("tableName", (Object)"clusterCAPTable");
            clusterCAPInputParams.put("selObjNameIndex", (Object)"1");
            HashMap<String, Object> returnListMap = new HashMap<String, Object>();
            JSONObject resultObj = EmberTableConfig.getInstance().getEmberTableData1(tableId, capList, tableAllColumnList, clusterCAPInputParams, rb);
            JSONObject tableData = resultObj.getJSONObject("tableData");
            returnListMap.put("clusterCAPData", tableData.get("tableDataList"));
            returnListMap.put("clusterCAPColumnList", tableAllColumnList);
            returnListMap.put("clusterCAPConfigInputParams", clusterCAPInputParams);
            returnListMap.put("clusterConfigInputParams", clusterConfigInputParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void getClusterShares(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = null;
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        JSONObject clusterShareConfigInputParams = null;
        clusterShareConfigInputParams = reportReqData.getJSONObject("clusterShareConfigInputParams");
        JSONObject clusterConfigInputParams = reportReqData.getJSONObject("clusterConfigInputParams");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String hostName = clusterShareConfigInputParams.getString("selectedCAP");
            String domainName = clusterConfigInputParams.getString("domainName");
            String refresh = clusterShareConfigInputParams.getString("refresh");
            String operation = clusterConfigInputParams.getString("operation");
            String shareAction = "";
            if (operation.equals("addcap") || operation.equals("addnew")) {
                shareAction = "ALL";
            } else if (operation.equals("addshare")) {
                shareAction = "ADD";
            }
            HashMap<String, String> shareMap = new HashMap<String, String>();
            shareMap.put("HOST_NAME", hostName);
            shareMap.put("REFRESH", refresh);
            shareMap.put("DOMAIN_NAME", domainName);
            shareMap.put("SHARE_ACTION", shareAction);
            String uvhString = "AUDCVConfig:cv_id:15020";
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDTableViewConfig", (String)"CV_ID"), (Object)cvId, 0);
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDTableViewConfig", crit);
            HashMap<String, String> tableDetails = new HashMap<String, String>();
            if (!dob.isEmpty()) {
                Row r = dob.getFirstRow("AUDTableViewConfig");
                List al = r.getColumns();
                for (int i = 0; i < al.size(); ++i) {
                    String key = String.valueOf(al.get(i));
                    String value = String.valueOf(r.get((String)al.get(i)));
                    tableDetails.put(key, value);
                }
            }
            Long tableId = Long.parseLong((String)tableDetails.get("TABLE_VIEW_ID"));
            ArrayList<HashMap<String, Object>> tableAllColumnList = ServerConfigHandler.getInstance().getVisibleColumnList(cvId, true, true, true, null, null, rb);
            Boolean isSearch = false;
            String searchTxt = this.getSearchCriteria(clusterShareConfigInputParams, tableAllColumnList, false);
            if (searchTxt != null) {
                isSearch = true;
            }
            if (clusterConfigInputParams.opt("pageList") == null) {
                this.getClusterConfigPageInputParams(clusterConfigInputParams, rb);
            }
            clusterShareConfigInputParams.put("changeAction", (Object)"getClusterShares");
            clusterShareConfigInputParams.put("refreshAction", (Object)"refreshClusterShares");
            clusterShareConfigInputParams.put("emptyTableAction", (Object)"clusterSharesEmpty");
            clusterShareConfigInputParams.put("hideTopDivider", true);
            clusterShareConfigInputParams.put("hideBorder", true);
            Hashtable shareTable = FileSystemAPI.getInstance().getSharesForServer(null, shareMap, searchTxt, Integer.valueOf(0));
            ArrayList shareList = (ArrayList)shareTable.get("Shares");
            int shareCount = shareList.size();
            message = (String)shareTable.get("message");
            clusterShareConfigInputParams.put("refresh", false);
            if (message != null) {
                clusterShareConfigInputParams.put("filterText", (Object)message);
                clusterShareConfigInputParams.put("showFilterText", true);
            }
            if (shareCount == 0) {
                if (message != null) {
                    clusterShareConfigInputParams.put("emptyTableMessage", (Object)message);
                } else {
                    clusterShareConfigInputParams.put("emptyTableMessage", (Object)rb.getString((String)tableDetails.get("EMPTY_TABLE_MESSAGE")));
                }
                if (isSearch.booleanValue()) {
                    clusterShareConfigInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                    clusterShareConfigInputParams.put("emptyTableMessage2", (Object)rb.getString("adap.common.text.policy_update_link.click_here"));
                } else {
                    clusterShareConfigInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                    clusterShareConfigInputParams.put("emptyTableMessage2", (Object)rb.getString("adap_ServerConfig.click_here_to_refresh"));
                }
            }
            clusterShareConfigInputParams.put("totalCount", shareList.size());
            clusterShareConfigInputParams.put("isSearch", (Object)isSearch);
            clusterShareConfigInputParams.put("tableName", (Object)"clusterShareTable");
            clusterShareConfigInputParams.put("selObjNameIndex", (Object)"1");
            HashMap<String, Object> returnListMap = new HashMap<String, Object>();
            JSONObject resultObj = EmberTableConfig.getInstance().getEmberTableData1(tableId, shareList, tableAllColumnList, clusterShareConfigInputParams, rb);
            JSONObject tableData = resultObj.getJSONObject("tableData");
            returnListMap.put("clusterShareData", tableData.get("tableDataList"));
            returnListMap.put("clusterShareColumnList", tableAllColumnList);
            returnListMap.put("clusterShareConfigInputParams", clusterShareConfigInputParams);
            returnListMap.put("clusterConfigInputParams", clusterConfigInputParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = ex.getMessage();
        }
    }

    public void getClusters(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            FileClusterConfigHandler.getConfiguredClusters(request, response, null, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addCluster(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = "";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject clusterConfigInputParams = reportReqData.getJSONObject("clusterConfigInputParams");
            JSONObject clusterNodeConfigInputParams = reportReqData.optJSONObject("clusterNodeConfigInputParams");
            JSONObject clusterShareConfigInputParams = reportReqData.optJSONObject("clusterShareConfigInputParams");
            ArrayList clusterNodeDataList = null;
            if (reportReqData.has("clusterNodeData")) {
                clusterNodeDataList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)reportReqData.optJSONArray("clusterNodeData"));
            }
            String operation = clusterConfigInputParams.getString("operation");
            String clusterName = clusterConfigInputParams.getString("clusterName");
            String domainName = clusterConfigInputParams.getString("domainName");
            Long clusterId = clusterConfigInputParams.getLong("clusterId");
            ArrayList clusterNodeIdList = null;
            ArrayList clusterNodeDetails = new ArrayList();
            if ((operation.equals("addnode") || operation.equals("addnew")) && reportReqData.has("clusterNodeConfigInputParams")) {
                clusterNodeIdList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)clusterNodeConfigInputParams.optJSONArray("selectedObjectIdList"));
                ArrayList clusterNodeNameList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)clusterNodeConfigInputParams.optJSONArray("selectedObjectNameList"));
                for (int i = 0; i < clusterNodeIdList.size(); ++i) {
                    Hashtable<String, String> obj = new Hashtable<String, String>();
                    for (int j = 0; j < clusterNodeDataList.size(); ++j) {
                        HashMap clusterNodeObj = (HashMap)clusterNodeDataList.get(j);
                        if (!clusterNodeObj.get("OBJECT_GUID").equals(clusterNodeIdList.get(i))) continue;
                        obj.put("OBJECT_GUID", clusterNodeObj.get("OBJECT_GUID").toString());
                        obj.put("NODE_NAME", clusterNodeNameList.get(i).toString());
                        clusterNodeDetails.add(obj);
                    }
                }
            }
            String clusterResourceName = null;
            ArrayList clusterShareList = null;
            if ((operation.equals("addshare") || operation.equals("addcap") || operation.equals("addnew")) && reportReqData.has("clusterShareConfigInputParams")) {
                clusterResourceName = clusterShareConfigInputParams.optString("selectedCAP");
                clusterShareList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)clusterShareConfigInputParams.optJSONArray("selectedObjectIdList"));
            }
            ArrayList<String> shareUNCNameList = new ArrayList<String>();
            String isSacl = clusterConfigInputParams.getString("isSACL");
            String isGpo = clusterConfigInputParams.getString("isGPO");
            if (clusterShareList != null) {
                for (int k = 0; k < clusterShareList.size(); ++k) {
                    String shareUNCName = (String)clusterShareList.get(k);
                    if (shareUNCNameList.contains(shareUNCName)) continue;
                    shareUNCNameList.add(shareUNCName);
                }
            }
            if (operation.equals("addnew")) {
                message = ClusterHandler.addClusterConfig((String)domainName, (String)clusterName, (Long)clusterId, clusterNodeDetails, (String)clusterResourceName, shareUNCNameList, (String)operation, (String)isSacl, (String)isGpo);
            } else if (operation.equals("addnode")) {
                message = ClusterHandler.addClusterConfig((String)domainName, (String)clusterName, (Long)clusterId, clusterNodeDetails, null, null, (String)operation, null, (String)isGpo);
            } else if (operation.equals("addcap")) {
                message = ClusterHandler.addClusterConfig((String)domainName, (String)clusterName, (Long)clusterId, null, (String)clusterResourceName, shareUNCNameList, (String)operation, (String)isSacl, null);
            } else if (operation.equals("addshare")) {
                message = ClusterHandler.addClusterConfig((String)domainName, (String)clusterName, (Long)clusterId, null, (String)clusterResourceName, shareUNCNameList, (String)operation, (String)isSacl, null);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = rb.getString("adap_ServerConfig.error_while_updating_cluster_resources");
        }
        HashMap<String, String> returnListMap = new HashMap<String, String>();
        returnListMap.put("msgTxt", message);
        JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
    }

    public void updateClusterNodes(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = "";
        String msgType = "success";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject clusterInputParams = null;
            clusterInputParams = reportReqData.getJSONObject("clusterInputParams");
            JSONObject clusterNodeInputParams = reportReqData.getJSONObject("clusterNodeInputParams");
            Long clusterId = null;
            ArrayList objectGuidList = null;
            objectGuidList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)clusterNodeInputParams.optJSONArray("selectedObjectIdList"));
            String domainName = clusterInputParams.getString("domainName");
            String clusterName = clusterInputParams.getString("clusterName");
            String EFI = clusterNodeInputParams.optString("timePeriod");
            String action = clusterNodeInputParams.getString("nodeAction");
            clusterId = clusterInputParams.getLong("clusterId");
            ArrayList<Long> nodeList = new ArrayList<Long>();
            for (int i = 0; i < objectGuidList.size(); ++i) {
                Long id = Long.parseLong(objectGuidList.get(i).toString());
                nodeList.add(id);
            }
            try {
                message = ClusterHandler.updateClusterNodes((String)domainName, (String)clusterName, (Long)clusterId, nodeList, (String)action, (String)EFI);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                msgType = "failure";
                message = rb.getString("adap_ServerConfig.error_while_updating_cluster_nodes");
            }
            FileClusterConfigHandler.getConfiguredClusters(request, response, message, msgType);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateClusterCAPS(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = "";
        String msgType = "success";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject clusterInputParams = null;
            clusterInputParams = reportReqData.getJSONObject("clusterInputParams");
            JSONObject clusterCAPInputParams = reportReqData.getJSONObject("clusterCAPInputParams");
            String domainName = clusterInputParams.getString("domainName");
            String clusterName = clusterInputParams.getString("clusterName");
            String action = clusterCAPInputParams.getString("capAction");
            ArrayList objectGuidList = null;
            objectGuidList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)clusterCAPInputParams.optJSONArray("selectedObjectIdList"));
            ArrayList<Long> capList = new ArrayList<Long>();
            for (int i = 0; i < objectGuidList.size(); ++i) {
                Long id = Long.parseLong(objectGuidList.get(i).toString());
                capList.add(id);
            }
            try {
                message = ClusterHandler.updateClusterResources((String)domainName, (String)clusterName, capList, (String)action);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                msgType = "failure";
                message = ex.getMessage();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            msgType = "failure";
            message = rb.getString("adap_ServerConfig.error_while_updating_cluster_resources");
        }
        FileClusterConfigHandler.getConfiguredClusters(request, response, message, msgType);
    }

    public static ArrayList<Properties> getConfiguredClusters(HttpServletRequest request, HttpServletResponse response, String message, String msgType) throws Exception {
        ArrayList<Properties> ret = new ArrayList<Properties>();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject clusterDataInputParams = null;
            clusterDataInputParams = reportReqData.getJSONObject("clusterDataInputParams");
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)CLUSTER_CONFIG_TABLE_NAME));
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            Join clusterConfigJoin = new Join(CLUSTER_CONFIG_TABLE_NAME, CLUSTER_TABLE_NAME, new String[]{"CLUSTER_ID"}, new String[]{"CLUSTER_ID"}, 2);
            query.addJoin(clusterConfigJoin);
            Criteria cri = new Criteria(Column.getColumn((String)CLUSTER_TABLE_NAME, (String)"DOMAIN_NAME"), (Object)clusterDataInputParams.getString("domainName"), 0);
            query.setCriteria(cri);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            Iterator it = dataObject.getRows(CLUSTER_TABLE_NAME);
            String domainName = clusterDataInputParams.getString("domainName");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String clusterName = (String)r.get("CLUSTER_NAME");
                String domainNameCluster = (String)r.get("DOMAIN_NAME");
                Long clusterId = (Long)r.get("CLUSTER_ID");
                HashMap<String, Object> clusterData = new HashMap<String, Object>();
                HashMap<String, Object> clusterInputParams = new HashMap<String, Object>();
                Properties p = new Properties();
                p.put("CLUSTER_NAME", clusterName);
                p.put("DOMAIN_NAME", domainNameCluster);
                p.put("CLUSTER_ID", clusterId);
                p.put("MESSAGE", "Success");
                clusterInputParams.put("clusterId", clusterId);
                clusterInputParams.put("clusterName", clusterName);
                clusterInputParams.put("domainName", domainNameCluster);
                clusterInputParams.put("tabName", "tabName_" + clusterId);
                clusterInputParams.put("tabId", "tabId_" + clusterId);
                clusterInputParams.put("tabDisplayName", clusterName);
                clusterInputParams.put("serverType", "fc");
                clusterData.put("clusterName", clusterName);
                clusterData.put("clusterId", clusterId);
                p.put("clusterData", clusterData);
                p.put("clusterInputParams", clusterInputParams);
                Criteria cri2 = new Criteria(Column.getColumn((String)CLUSTER_CAP_CONFIG_TABLE_NAME, (String)"CLUSTER_ID"), (Object)clusterId, 0);
                ArrayList<Properties> clusterCaps = new ArrayList<Properties>();
                JSONObject clusterCAPInputParams = new JSONObject();
                DataObject capDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(CLUSTER_CAP_CONFIG_TABLE_NAME, cri2);
                Iterator ite = capDataObj.getRows(CLUSTER_CAP_CONFIG_TABLE_NAME, cri2);
                while (ite.hasNext()) {
                    Row rw = (Row)ite.next();
                    Long clusterConfigId = (Long)rw.get("CLUSTER_CAP_CONFIG_ID");
                    String clusterCapName = (String)rw.get("CLUSTER_CAP_NAME");
                    Properties capProps = new Properties();
                    capProps.put("CLUSTER_CAP_CONFIG_ID", clusterConfigId);
                    capProps.put("CLUSTER_CAP_NAME", clusterCapName);
                    capProps.put("COMPUTER_ID", clusterConfigId);
                    ArrayList shareList = FileServerHandler.getConfiguredShares((String)clusterCapName, (String)domainName);
                    shareList = AuditDelegationUtil.getShareSACLStatus((String)clusterCapName, (String)domainName, (ArrayList)shareList);
                    if (shareList != null) {
                        capProps.put("SHARE_LIST", shareList);
                    }
                    clusterCaps.add(capProps);
                }
                clusterCAPInputParams.put("totalCount", clusterCaps.size());
                clusterCAPInputParams.put("tableName", (Object)"clusterCAPTable");
                clusterCAPInputParams.put("tabId", (Object)("tabId_" + clusterId));
                if (!clusterCAPInputParams.has("selectedObjectIdList")) {
                    JSONArray a = new JSONArray();
                    JSONArray b = new JSONArray();
                    clusterCAPInputParams.put("selectedObjectIdList", (Object)a);
                    clusterCAPInputParams.put("selectedObjectNameList", (Object)b);
                }
                clusterCAPInputParams.put("isHideOverFlowX", true);
                clusterCAPInputParams.put("selObjNameIndex", (Object)"2");
                String uvhString = "AUDCVConfig:cv_id:15017";
                Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
                Criteria crit = new Criteria(Column.getColumn((String)"AUDTableViewConfig", (String)"CV_ID"), (Object)cvId, 0);
                DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDTableViewConfig", crit);
                HashMap<String, String> tableDetails = new HashMap<String, String>();
                if (!dob.isEmpty()) {
                    Row r1 = dob.getFirstRow("AUDTableViewConfig");
                    List al = r1.getColumns();
                    for (int i = 0; i < al.size(); ++i) {
                        String key = String.valueOf(al.get(i));
                        String value = String.valueOf(r1.get((String)al.get(i)));
                        tableDetails.put(key, value);
                    }
                }
                Long tableId = Long.parseLong((String)tableDetails.get("TABLE_VIEW_ID"));
                ArrayList<HashMap<String, Object>> tableAllColumnList = ServerConfigHandler.getInstance().getVisibleColumnList(cvId, true, true, true, null, null, rb);
                HashMap<String, Object> clusterCAPMap = new HashMap<String, Object>();
                JSONObject resultObj = EmberTableConfig.getInstance().getEmberTableData1(tableId, clusterCaps, tableAllColumnList, clusterCAPInputParams, rb);
                JSONObject tableData = resultObj.getJSONObject("tableData");
                clusterCAPMap.put("tableDataList", tableData.get("tableDataList"));
                clusterCAPMap.put("tableColumnList", tableAllColumnList);
                p.put("CLUSTER_CAPS", clusterCaps);
                p.put("clusterCAPData", clusterCAPMap);
                p.put("clusterCAPInputParams", clusterCAPInputParams);
                Criteria cri3 = new Criteria(Column.getColumn((String)CLUSTER_NODE_CONFIG_TABLE_NAME, (String)"CLUSTER_ID"), (Object)clusterId, 0);
                ArrayList<Properties> clusterNodes = new ArrayList<Properties>();
                JSONObject clusterNodeInputParams = new JSONObject();
                DataObject nodeDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(CLUSTER_NODE_CONFIG_TABLE_NAME, cri3);
                Iterator iter = nodeDataObj.getRows(CLUSTER_NODE_CONFIG_TABLE_NAME, cri3);
                while (iter.hasNext()) {
                    String nodeGuid;
                    String clusterNodeName;
                    Row row = (Row)iter.next();
                    Long clusterNodeId = (Long)row.get("CLUSTER_NODE_CONFIG_ID");
                    Long clusterIdNode = (Long)row.get("CLUSTER_ID");
                    Properties nodeProps = ClusterHandler.getConfiguredClusterNodes((Long)clusterIdNode, (Long)clusterNodeId, (String)(clusterNodeName = (String)row.get("CLUSTER_NODE_NAME")), (String)(nodeGuid = (String)row.get("OBJECT_GUID")));
                    if (nodeProps == null) continue;
                    clusterNodes.add(nodeProps);
                }
                clusterNodeInputParams.put("totalCount", clusterNodes.size());
                clusterNodeInputParams.put("isSearch", false);
                clusterNodeInputParams.put("tableName", (Object)"clusterNodeTable");
                clusterNodeInputParams.put("tabId", (Object)("tabId_" + clusterId));
                clusterNodeInputParams.put("serverType", (Object)"fc");
                if (!clusterNodeInputParams.has("selectedObjectIdList")) {
                    JSONArray a = new JSONArray();
                    JSONArray b = new JSONArray();
                    clusterNodeInputParams.put("selectedObjectIdList", (Object)a);
                    clusterNodeInputParams.put("selectedObjectNameList", (Object)b);
                }
                clusterNodeInputParams.put("selObjNameIndex", (Object)"2");
                String uvhString2 = "AUDCVConfig:cv_id:15016";
                Long cvId2 = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString2);
                Criteria crit2 = new Criteria(Column.getColumn((String)"AUDTableViewConfig", (String)"CV_ID"), (Object)cvId2, 0);
                DataObject dob2 = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDTableViewConfig", crit2);
                HashMap<String, String> tableDetails2 = new HashMap<String, String>();
                if (!dob2.isEmpty()) {
                    Row r2 = dob2.getFirstRow("AUDTableViewConfig");
                    List al2 = r2.getColumns();
                    for (int i = 0; i < al2.size(); ++i) {
                        String key1 = String.valueOf(al2.get(i));
                        String value1 = String.valueOf(r2.get((String)al2.get(i)));
                        tableDetails2.put(key1, value1);
                    }
                }
                Long tableId2 = Long.parseLong((String)tableDetails2.get("TABLE_VIEW_ID"));
                ArrayList<HashMap<String, Object>> tableAllColumnList2 = ServerConfigHandler.getInstance().getVisibleColumnList(cvId2, true, true, true, null, null, rb);
                HashMap<String, Object> clusterNodeMap = new HashMap<String, Object>();
                JSONObject resultObj2 = EmberTableConfig.getInstance().getEmberTableData1(tableId2, clusterNodes, tableAllColumnList2, clusterNodeInputParams, rb);
                JSONObject tableData2 = resultObj2.getJSONObject("tableData");
                clusterNodeMap.put("tableDataList", tableData2.get("tableDataList"));
                clusterNodeMap.put("tableColumnList", tableAllColumnList2);
                p.put("CLUSTER_NODES", clusterNodes);
                p.put("clusterNodeData", clusterNodeMap);
                p.put("clusterNodeInputParams", clusterNodeInputParams);
                ret.add(p);
            }
            HashMap<String, ArrayList<Properties>> returnListMap = new HashMap<String, ArrayList<Properties>>();
            returnListMap.put("clusterData", ret);
            JSONArray ho = new JSONArray(ServerConfigHandler.getInstance().hours);
            JSONArray mi = new JSONArray(ServerConfigHandler.getInstance().minutes);
            clusterDataInputParams.put("hours", (Object)ho);
            clusterDataInputParams.put("minutes", (Object)mi);
            if (ret.size() == 0) {
                clusterDataInputParams.put("emptyTableMessage", (Object)rb.getString("adap_ServerConfig.no_clusters_are_configured"));
                clusterDataInputParams.put("emptyTableMessage2", (Object)rb.getString("adap_ServerConfig.click_here_to_configure"));
                clusterDataInputParams.put("emptyTableAction", (Object)"addCluster");
            }
            if (message != null) {
                clusterDataInputParams.put("message", (Object)message);
                clusterDataInputParams.put("type", (Object)msgType);
            }
            returnListMap.put("clusterDataInputParams", (ArrayList<Properties>)clusterDataInputParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    public void getClusterConfigInputParams(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject clusterConfigInputParams = reportReqData.getJSONObject("clusterConfigInputParams");
            this.getClusterConfigPageInputParams(clusterConfigInputParams, rb);
            HashMap<String, JSONObject> returnListMap = new HashMap<String, JSONObject>();
            returnListMap.put("clusterConfigInputParams", clusterConfigInputParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void getClusterConfigPageInputParams(JSONObject pageInputParams, AdventNetResourceBundle rb) throws Exception {
        JSONArray pageList = new JSONArray();
        String operation = pageInputParams.getString("operation");
        if (operation.equals("addnew")) {
            JSONObject page1 = new JSONObject();
            page1.put("displayName", (Object)rb.getString("adap.Description.Cluster_Name"));
            page1.put("pageNo", (Object)"1");
            page1.put("pageId", (Object)"failover-cluster-nameh");
            JSONObject page2 = new JSONObject();
            page2.put("displayName", (Object)rb.getString("adap_ServerConfig.cluster_nodes"));
            page2.put("pageNo", (Object)"2");
            page2.put("pageId", (Object)"ClusterNodesh");
            JSONObject page3 = new JSONObject();
            page3.put("displayName", (Object)rb.getString("adap_ServerConfig.cluster_access_points"));
            page3.put("pageNo", (Object)"3");
            page3.put("pageId", (Object)"caph");
            JSONObject page4 = new JSONObject();
            page4.put("displayName", (Object)rb.getString("adap_ServerConfig.cluster_shares"));
            page4.put("pageNo", (Object)"4");
            page4.put("pageId", (Object)"CSh");
            JSONObject page5 = new JSONObject();
            page5.put("displayName", (Object)rb.getString("adap_ServerConfig.review_summary"));
            page5.put("pageNo", (Object)"5");
            page5.put("pageId", (Object)"rsh");
            pageList.put((Object)page1);
            pageList.put((Object)page2);
            pageList.put((Object)page3);
            pageList.put((Object)page4);
            pageList.put((Object)page5);
        } else if (operation.equals("addshare")) {
            JSONObject page2 = new JSONObject();
            page2.put("displayName", (Object)rb.getString("adap_ServerConfig.cluster_shares"));
            page2.put("pageNo", (Object)"1");
            page2.put("pageId", (Object)"CSh");
            JSONObject page3 = new JSONObject();
            page3.put("displayName", (Object)rb.getString("adap_ServerConfig.review_summary"));
            page3.put("pageNo", (Object)"2");
            page3.put("pageId", (Object)"rsh");
            pageList.put((Object)page2);
            pageList.put((Object)page3);
        } else if (operation.equals("addnode")) {
            JSONObject page2 = new JSONObject();
            page2.put("displayName", (Object)rb.getString("adap_ServerConfig.cluster_nodes"));
            page2.put("pageNo", (Object)"1");
            page2.put("pageId", (Object)"ClusterNodesh");
            JSONObject page3 = new JSONObject();
            page3.put("displayName", (Object)rb.getString("adap_ServerConfig.review_summary"));
            page3.put("pageNo", (Object)"2");
            page3.put("pageId", (Object)"rsh");
            pageList.put((Object)page2);
            pageList.put((Object)page3);
        } else if (operation.equals("addcap")) {
            JSONObject page1 = new JSONObject();
            page1.put("displayName", (Object)rb.getString("adap_ServerConfig.cluster_access_points"));
            page1.put("pageNo", (Object)"1");
            page1.put("pageId", (Object)"caph");
            JSONObject page2 = new JSONObject();
            page2.put("displayName", (Object)rb.getString("adap_ServerConfig.cluster_shares"));
            page2.put("pageNo", (Object)"2");
            page2.put("pageId", (Object)"CSh");
            JSONObject page3 = new JSONObject();
            page3.put("displayName", (Object)rb.getString("adap_ServerConfig.review_summary"));
            page3.put("pageNo", (Object)"3");
            page3.put("pageId", (Object)"rsh");
            pageList.put((Object)page1);
            pageList.put((Object)page2);
            pageList.put((Object)page3);
        }
        pageInputParams.put("pageList", (Object)pageList);
    }

    public void deleteCluster(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = "";
        String msgType = "success";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject clusterInputParams = null;
            clusterInputParams = reportReqData.getJSONObject("clusterInputParams");
            String domainName = clusterInputParams.getString("domainName");
            String clusterName = clusterInputParams.getString("clusterName");
            String clusterId = clusterInputParams.getString("clusterId");
            try {
                ClusterHandler.deleteClusterNodes((String)domainName, (String)clusterName, (Long)Long.parseLong(clusterId));
                ClusterHandler.deleteClusterResources((String)domainName, (String)clusterName, (Long)Long.parseLong(clusterId));
                message = ClusterHandler.deleteCluster((String)domainName, (String)clusterName, (String)clusterId);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                message = ex.getMessage();
            }
            ClusterMonitorCriteria.getInstance().setConfiguredClusters();
            FileClusterConfigHandler.getConfiguredClusters(request, response, message, msgType);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = rb.getString("adap_ServerConfig.error_while_deleting_cluster");
        }
    }

    public void runNodeEventScheduler(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = "";
        String msgType = "success";
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        JSONObject reportInputParams = null;
        reportInputParams = reportReqData.getJSONObject("inputParams");
        String msIdStr = reportInputParams.getString("computerId");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        if (msIdStr != null) {
            Long msId = Long.parseLong(msIdStr);
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"COMPUTER_ID"), (Object)msId, 0);
            ArrayList<String> list = new ArrayList<String>();
            list.add("ADSMComputerGeneralDetails");
            list.add("AUDComputerEventRead");
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(list, criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("ADSMComputerGeneralDetails");
                String domainName = (String)row.get("DOMAIN_NAME");
                Row eventRow = dataObject.getRow("AUDComputerEventRead");
                Integer machineType = (Integer)eventRow.get("MACHINE_TYPE");
                if (FileServerHandler.checkIsDomainController((String)domainName, (String)((String)row.get("OBJECT_GUID")))) {
                    machineType = machineType | 1;
                }
                try {
                    EventDataHandler.getInstance().getEventDataFromDC((String)row.get("DOMAIN_NAME"), (String)row.get("NAME"), machineType.intValue(), (String)row.get("OBJECT_GUID"));
                    message = rb.handleGetObject("adap.ConfiguredClusterAction.Started_fetching_Event_Data_from_File_Server", new String[]{(String)row.get("NAME")});
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.fetching_fs_data_manuallay", "-"}));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    msgType = "failure";
                    message = e.getMessage();
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.fetching_fs_data_manuallay", "-"}));
                }
            }
        }
        reportInputParams.put("msgTxt", (Object)message);
        reportInputParams.put("msgType", (Object)msgType);
        HashMap<String, JSONObject> returnListMap = new HashMap<String, JSONObject>();
        returnListMap.put("inputParams", reportInputParams);
        JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
    }

    private String getSearchCriteria(JSONObject reportReqData, ArrayList<HashMap<String, Object>> tableAllColumnList, Boolean needSearchCriteria) throws Exception {
        String searchCriteria = null;
        JSONObject searchData = null;
        if (reportReqData.has("searchData")) {
            searchData = reportReqData.getJSONObject("searchData");
            for (HashMap<String, Object> tableconfig : tableAllColumnList) {
                String column_value = tableconfig.get("columnalias").toString();
                if (!searchData.has(column_value)) continue;
                String columnSearchValue = searchData.get(column_value).toString();
                tableconfig.put("searchValue", searchData.get(column_value).toString());
                if (columnSearchValue == null || columnSearchValue.equalsIgnoreCase("")) continue;
                searchCriteria = columnSearchValue;
            }
        }
        return searchCriteria;
    }
}

