/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.report;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.accountLockout.AccountLockoutHistory;
import com.adventnet.sym.adsm.auditing.server.accountLockout.AccountLockoutUtil;
import com.adventnet.sym.adsm.auditing.server.accountLockout.IISHandler;
import com.adventnet.sym.adsm.auditing.server.delegation.DelegationConstants;
import com.adventnet.sym.adsm.auditing.server.gpo.GPODetailsAPI;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.GPSettingsHandler;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.auditing.server.useractivity.UserActivityUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.report.ReportHandlerUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.serveraudit.ServerConfigHandler;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.APIUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ProcessObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.ADAPObjectCacheAPI;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.objects.ObjectAttributeDetails;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.jtds.jdbc.ClobImpl;
import org.json.JSONObject;

public class SubReportHandler {
    private static volatile SubReportHandler instance = null;
    private static final ADAPObjectCacheAPI ADAP_OBJECT_CACHE_API = ADAPObjectCacheAPI.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SubReportHandler getInstance() {
        if (instance != null) return instance;
        Class<SubReportHandler> clazz = SubReportHandler.class;
        synchronized (SubReportHandler.class) {
            if (instance != null) return instance;
            instance = new SubReportHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SubReportHandler() {
    }

    public void getGPOSettingsChanges(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject reportInputParams = null;
            reportInputParams = reportReqData.getJSONObject("inputParams");
            String uniqueId = reportInputParams.getString("unique_id");
            String colName = reportInputParams.getString("column_name");
            String minUvhString = "AUDCVConfig:cv_id:15040";
            Long minCvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)minUvhString);
            String uvhString = "AUDCVConfig:cv_id:15031";
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDTableViewConfig", (String)"CV_ID"), (Object)cvId, 0);
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDTableViewConfig", crit);
            HashMap<String, String> tableDetails = new HashMap<String, String>();
            if (!dob.isEmpty()) {
                Row r = dob.getFirstRow("AUDTableViewConfig");
                List al = r.getColumns();
                for (int i = 0; i < al.size(); ++i) {
                    String key = String.valueOf(al.get(i));
                    String value = String.valueOf(r.get((String)al.get(i)));
                    tableDetails.put(key, value);
                }
            }
            ArrayList<HashMap<String, Object>> tableAllColumnList = ReportHandlerUtil.getInstance().getVisibleColumnList(cvId, true, true, true, null, null, rb);
            ArrayList<HashMap<String, Object>> tableMinColumnList = ReportHandlerUtil.getInstance().getVisibleColumnList(minCvId, true, true, true, null, null, rb);
            HashMap<String, HashMap<String, Object>> setMap = SubReportHandler.getSettingsChangeRow(colName, uniqueId, tableAllColumnList);
            HashMap<String, Object> returnListMap = new HashMap<String, Object>();
            Iterator<Map.Entry<String, HashMap<String, Object>>> it = setMap.entrySet().iterator();
            ArrayList m1List = new ArrayList();
            int i = 0;
            while (it.hasNext()) {
                Map.Entry<String, HashMap<String, Object>> pair = it.next();
                HashMap<String, Object> tableMap = new HashMap<String, Object>();
                HashMap<String, Object> tableDataMap = new HashMap<String, Object>();
                HashMap<String, Object> table = pair.getValue();
                if (!((Boolean)table.get("isAdminTemplate")).booleanValue()) {
                    tableDataMap.put("tableColumnList", tableMinColumnList);
                } else {
                    tableDataMap.put("tableColumnList", tableAllColumnList);
                }
                tableDataMap.put("tableDataList", table.get("list"));
                tableMap.put("path", table.get("path"));
                tableMap.put("tableData", tableDataMap);
                ++i;
                tableMap.put("tableInputParams", reportInputParams);
                reportInputParams.put("hideTopDivider", true);
                reportInputParams.put("hideBorder", true);
                reportInputParams.put("hideTableOptions", true);
                reportInputParams.put("miniTable", true);
                m1List.add(tableMap);
            }
            if (m1List.isEmpty()) {
                reportInputParams.put("emptyTableMessage", (Object)rb.getString((String)tableDetails.get("EMPTY_TABLE_MESSAGE")));
            }
            returnListMap.put("gpoInputParams", reportInputParams);
            returnListMap.put("subReportList", m1List);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, HashMap<String, Object>> getSettingsChangeRow(String columnName, String queryValues, ArrayList<HashMap<String, Object>> tableAllColumnList) {
        HashMap<String, HashMap<String, Object>> settingsMap = new HashMap<String, HashMap<String, Object>>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            String query = GPSettingsHandler.getSelectQuery((String)columnName, (String)queryValues);
            resultSet = QueryUtil.executeQuery((String)"GPO Settings Change Report", (Statement)statement, (String)query);
            int count = 0;
            while (resultSet.next()) {
                ArrayList rowList;
                boolean isAdmTemplate = false;
                String policyPath = resultSet.getString("POLICY_PATH");
                HashMap rowMap = new HashMap();
                HashMap<String, Object> settingsChangeMap = settingsMap.get(policyPath);
                if (settingsChangeMap == null) {
                    settingsChangeMap = new HashMap();
                }
                if ((rowList = (ArrayList)settingsChangeMap.get("list")) == null) {
                    rowList = new ArrayList();
                }
                ArrayList columnList = new ArrayList();
                for (HashMap<String, Object> tableColumn : tableAllColumnList) {
                    HashMap<String, Object> columnMap = new HashMap<String, Object>();
                    columnMap.put("isData", tableColumn.get("isData"));
                    columnMap.put("visible", tableColumn.get("visible"));
                    String value = "-";
                    Object obj = resultSet.getObject(tableColumn.get("columnalias").toString());
                    if (obj != null && obj.getClass().getName().equalsIgnoreCase("net.sourceforge.jtds.jdbc.ClobImpl")) {
                        ClobImpl clobObj = (ClobImpl)obj;
                        value = clobObj.getSubString(1L, (int)clobObj.length());
                    } else if (obj != null) {
                        value = obj.toString();
                    }
                    columnMap.put("columnValue", value);
                    columnMap.put("COLUMNALIAS", tableColumn.get("columnalias").toString());
                    if (tableColumn.get("columnalias").toString().equals("CHANGE_TYPE_TEXT")) {
                        if (columnMap.get("columnValue").toString().equals("Added")) {
                            columnMap.put("colClass", "primary-color");
                        } else if (columnMap.get("columnValue").toString().equals("Removed")) {
                            columnMap.put("colClass", "text-danger");
                        }
                    }
                    if (tableColumn.get("columnalias").toString().equals("IS_ADM_TEMPLATE")) {
                        isAdmTemplate = (Boolean)resultSet.getObject(tableColumn.get("columnalias").toString());
                    }
                    if (!isAdmTemplate && (tableColumn.get("columnalias").toString().equals("COMMENT_OLD_VALUE") || tableColumn.get("columnalias").toString().equals("COMMENT_NEW_VALUE"))) {
                        isAdmTemplate = false;
                        continue;
                    }
                    columnList.add(columnMap);
                }
                rowMap.put("columnValues", columnList);
                rowList.add(rowMap);
                settingsChangeMap.put("list", rowList);
                settingsChangeMap.put("path", policyPath);
                settingsChangeMap.put("isAdminTemplate", isAdmTemplate);
                settingsMap.put(policyPath, settingsChangeMap);
                ++count;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return settingsMap;
    }

    public void getPermissionAttriubtes(HttpServletRequest request, HttpServletResponse response) {
        try {
            Row row;
            Criteria criteria;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject reportInputParams = null;
            reportInputParams = reportReqData.getJSONObject("inputParams");
            Properties inputParamsProp = SubReportHandler.getNavigationInfo(reportInputParams);
            String correlationStr = inputParamsProp.get("correlationId").toString();
            Long action = Long.parseLong(inputParamsProp.get("action").toString());
            String type = inputParamsProp.get("type").toString();
            ArrayList<Object> aclList = new ArrayList();
            DataObject dataObject = null;
            String stringSD = null;
            String domainName = "";
            String uvhString = "AUDCVConfig:cv_id:15032";
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDTableViewConfig", (String)"CV_ID"), (Object)cvId, 0);
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDTableViewConfig", crit);
            HashMap<String, String> tableDetails = new HashMap<String, String>();
            if (!dob.isEmpty()) {
                Row r = dob.getFirstRow("AUDTableViewConfig");
                List al = r.getColumns();
                for (int i = 0; i < al.size(); ++i) {
                    String key = String.valueOf(al.get(i));
                    String value = String.valueOf(r.get((String)al.get(i)));
                    tableDetails.put(key, value);
                }
            }
            if (type.equalsIgnoreCase("object")) {
                if (correlationStr != null) {
                    criteria = new Criteria(Column.getColumn((String)"AUDACLVALUES", (String)"CORRELATION_ID"), (Object)correlationStr, 0, false);
                    dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDACLVALUES", criteria);
                }
                if (dataObject != null) {
                    row = dataObject.getRow("AUDACLVALUES");
                    stringSD = action.equals(1L) ? (String)row.get("ATTRIBUTES_NEW_VALUE") : (String)row.get("ATTRIBUTES_OLD_VALUE");
                    domainName = (String)row.get("ACCOUNT_DOMAIN");
                }
            } else if (type.equalsIgnoreCase("fimFolder")) {
                if (correlationStr != null) {
                    criteria = new Criteria(Column.getColumn((String)"AUDFIMFolderACLValues", (String)"UNIQUE_ID"), (Object)correlationStr, 0, false);
                    dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDFIMFolderACLValues", criteria);
                }
                if (dataObject != null) {
                    row = dataObject.getRow("AUDFIMFolderACLValues");
                    stringSD = action.equals(1L) ? (String)row.get("NEW_SEC_DESC") : (String)row.get("ORIGINAL_SEC_DESC");
                    domainName = (String)row.get("ACCOUNT_DOMAIN");
                }
            } else {
                if (correlationStr != null) {
                    criteria = new Criteria(Column.getColumn((String)"AUDFolderACLValues", (String)"UNIQUE_ID"), (Object)correlationStr, 0, false);
                    dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDFolderACLValues", criteria);
                }
                if (dataObject != null) {
                    row = dataObject.getRow("AUDFolderACLValues");
                    stringSD = action.equals(1L) ? (String)row.get("NEW_SEC_DESC") : (String)row.get("ORIGINAL_SEC_DESC");
                    domainName = (String)row.get("ACCOUNT_DOMAIN");
                }
            }
            ArrayList<HashMap<String, Object>> tableColumnList = ReportHandlerUtil.getInstance().getVisibleColumnList(cvId, true, true, true, null, null, rb);
            String message = null;
            if (stringSD != null && !stringSD.equals("")) {
                String attributeText;
                Hashtable table = null;
                try {
                    table = ADHandler.getSecurityDescriptorFromStringSD((String)domainName, (String)stringSD);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    message = ex.getMessage();
                }
                String string = attributeText = request.getParameter("attributeText") != null ? request.getParameter("attributeText") : "NT-Security-Descriptor";
                if (message == null) {
                    message = rb.getString((String)tableDetails.get("EMPTY_TABLE_MESSAGE"));
                }
                aclList = SubReportHandler.getACLList(domainName, table, attributeText, inputParamsProp, tableColumnList, message, rb);
            }
            HashMap returnListMap = new HashMap();
            returnListMap.put("subReportList", aclList);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static ArrayList<HashMap<String, Object>> getACLList(String domainName, Hashtable<String, Object> aclTable, String type, Properties inputParams, ArrayList<HashMap<String, Object>> colList, String message, AdventNetResourceBundle rb) {
        ArrayList<HashMap<String, Object>> tabList = new ArrayList<HashMap<String, Object>>();
        try {
            ArrayList daclList;
            ArrayList saclList;
            Properties saclInputParams = (Properties)inputParams.clone();
            saclInputParams.put("cvId", (Object)2);
            saclInputParams.put("tabId", "tabId_2");
            saclInputParams.put("tabIdh", "#tabId_2");
            saclInputParams.put("tabName", "tabName_2");
            saclInputParams.put("tabDisplayName", "SACL");
            HashMap tabMap = new HashMap();
            ArrayList rowList = new ArrayList();
            if (aclTable != null && (saclList = (ArrayList)aclTable.get("Sacl")) != null) {
                for (Object saclObject : saclList) {
                    Hashtable saclTable = (Hashtable)saclObject;
                    HashMap<String, ArrayList<HashMap<String, Object>>> rowMap = new HashMap<String, ArrayList<HashMap<String, Object>>>();
                    ArrayList<HashMap<String, Object>> columnList = SubReportHandler.getACLTable(domainName, saclTable, type, colList, rb);
                    rowMap.put("columnValues", columnList);
                    rowList.add(rowMap);
                }
            }
            if (rowList.isEmpty()) {
                saclInputParams.put("emptyTableMessage", message);
            }
            HashMap<String, ArrayList<HashMap<Object, Object>>> tableData = new HashMap<String, ArrayList<HashMap<Object, Object>>>();
            tableData.put("tableDataList", rowList);
            tableData.put("tableColumnList", colList);
            tabMap.put("tabData", tableData);
            tabMap.put("tabInputParams", saclInputParams);
            tabList.add(tabMap);
            HashMap tabMap2 = new HashMap();
            Properties daclInputParams = (Properties)inputParams.clone();
            daclInputParams.put("cvId", (Object)1);
            daclInputParams.put("tabId", "tabId_1");
            daclInputParams.put("tabIdh", "#tabId_1");
            daclInputParams.put("tabName", "tabName_1");
            daclInputParams.put("tabDisplayName", "DACL");
            ArrayList rowList2 = new ArrayList();
            if (aclTable != null && (daclList = (ArrayList)aclTable.get("Dacl")) != null) {
                for (Object daclObject : daclList) {
                    Hashtable daclTable = (Hashtable)daclObject;
                    HashMap<String, ArrayList<HashMap<String, Object>>> rowMap = new HashMap<String, ArrayList<HashMap<String, Object>>>();
                    ArrayList<HashMap<String, Object>> columnList = SubReportHandler.getACLTable(domainName, daclTable, type, colList, rb);
                    rowMap.put("columnValues", columnList);
                    rowList2.add(rowMap);
                }
            }
            if (rowList2.isEmpty()) {
                daclInputParams.put("emptyTableMessage", message);
            }
            HashMap<String, ArrayList<HashMap<Object, Object>>> tableData2 = new HashMap<String, ArrayList<HashMap<Object, Object>>>();
            tableData2.put("tableDataList", rowList2);
            tableData2.put("tableColumnList", colList);
            tabMap2.put("tabData", tableData2);
            tabMap2.put("tabInputParams", daclInputParams);
            tabList.add(tabMap2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return tabList;
    }

    public static ArrayList<HashMap<String, Object>> getACLTable(String domainName, Hashtable<String, Object> aclTable, String type, ArrayList<HashMap<String, Object>> colList, AdventNetResourceBundle rb) {
        ArrayList<HashMap<String, Object>> columnList = new ArrayList<HashMap<String, Object>>();
        Integer aclType = (Integer)aclTable.get("AceType");
        Integer aclFlags = (Integer)aclTable.get("AceFlags");
        for (int i = 0; i < colList.size(); ++i) {
            String colValue;
            HashMap<String, Object> columnMap = new HashMap<String, Object>();
            HashMap<String, Object> colConfigMap = colList.get(i);
            if (colConfigMap.get("columnalias").equals("SECURITY_PRINCIPAL")) {
                String trustee = (String)aclTable.get("Trustee");
                String name = ADAP_OBJECT_CACHE_API.getObjectNameFromSID(domainName, trustee, "NAME", null);
                if (name == null) {
                    name = trustee;
                }
                columnMap.put("isData", true);
                columnMap.put("visible", true);
                columnMap.put("columnValue", name);
                columnMap.put("columnalias", "SECURITY_PRINCIPAL");
                columnMap.put("SECURITY_PRINCIPAL", name);
            } else if (colConfigMap.get("columnalias").equals("PERMISSION")) {
                colValue = !type.equalsIgnoreCase("NT-Security-Descriptor") ? DelegationConstants.getAccessMaskString((String)aclTable.get("AccessMask").toString(), (String)"MB") : DelegationConstants.getPermissionString(aclTable, (String)domainName);
                columnMap.put("isData", true);
                columnMap.put("visible", true);
                columnMap.put("columnValue", colValue);
                columnMap.put("columnalias", "SECURITY_PRINCIPAL");
                columnMap.put("SECURITY_PRINCIPAL", colValue);
            } else if (colConfigMap.get("columnalias").equals("ACE_TYPE")) {
                colValue = DelegationConstants.getFileAceTypeString((Integer)aclType, (Integer)aclFlags);
                columnMap.put("isData", true);
                columnMap.put("visible", true);
                columnMap.put("columnValue", colValue);
                columnMap.put("columnalias", "ACE_TYPE");
                columnMap.put("SECURITY_PRINCIPAL", colValue);
            } else if (colConfigMap.get("columnalias").equals("APPLIES_TO")) {
                colValue = DelegationConstants.getAppliesToString(aclTable, (String)domainName);
                columnMap.put("isData", true);
                columnMap.put("visible", true);
                columnMap.put("columnValue", colValue);
                columnMap.put("columnalias", "APPLIES_TO");
                columnMap.put("APPLIES_TO", colValue);
            } else if (colConfigMap.get("columnalias").equals("INHERITED_ACE")) {
                colValue = DelegationConstants.isInheritedString((Integer)aclFlags);
                String colValueI18 = colValue.equals("true") ? rb.getString("adap.ObjectDetails.view_props.user.common.statmsg.true") : rb.getString("adap.ObjectDetails.view_props.user.common.statmsg.false");
                columnMap.put("isData", true);
                columnMap.put("visible", true);
                columnMap.put("columnValue", colValueI18);
                columnMap.put("columnalias", "INHERITED_ACE");
                columnMap.put("INHERITED_ACE", colValueI18);
            }
            columnList.add(columnMap);
        }
        return columnList;
    }

    public static Properties getNavigationInfo(JSONObject jPropObject) {
        Properties navigationProperties = new Properties();
        try {
            if (jPropObject != null) {
                Iterator it = jPropObject.keys();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    navigationProperties.put(key, jPropObject.get(key));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return navigationProperties;
    }

    public ArrayList<HashMap<String, Object>> getPermissionChangesList(String uniqueId, String action, ArrayList<HashMap<String, Object>> tableAllColumnList) throws DataAccessException {
        Criteria criteria = null;
        DataObject dataObject = null;
        String tableName = null;
        String columnName = null;
        ArrayList<HashMap<String, Object>> rowList = new ArrayList<HashMap<String, Object>>();
        if (action != null) {
            if (action.equals("userAttribute")) {
                tableName = "AUDACLChanges";
                columnName = "CORRELATION_ID";
            } else if (action.equals("fileAudit")) {
                tableName = "AUDFolderACLChanges";
                columnName = "UNIQUE_ID";
            } else if (action.equals("serverAudit")) {
                tableName = "AUDFIMFolderACLChanges";
                columnName = "UNIQUE_ID";
            }
            criteria = new Criteria(Column.getColumn((String)tableName, (String)columnName), (Object)uniqueId, 0);
            dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, criteria);
            Iterator itr = dataObject.getRows(tableName);
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                ArrayList colList = new ArrayList();
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                for (int j = 0; j < tableAllColumnList.size(); ++j) {
                    String rowValue;
                    HashMap<String, Object> columnMap = new HashMap<String, Object>();
                    HashMap<String, Object> colConfigMap = tableAllColumnList.get(j);
                    if (colConfigMap.get("columnalias").equals("MODIFICATION_TYPE")) {
                        rowValue = (String)row.get(colConfigMap.get("columnalias").toString());
                        columnMap.put("isData", true);
                        columnMap.put("visible", true);
                        columnMap.put("columnValue", rowValue);
                        columnMap.put("columnalias", colConfigMap.get("columnalias"));
                        if (rowValue.equals("Added")) {
                            columnMap.put("colClass", "primary-color");
                        } else if (rowValue.equals("Removed")) {
                            columnMap.put("colClass", "text-danger");
                        }
                        columnMap.put(colConfigMap.get("columnalias").toString(), rowValue);
                    } else if (colConfigMap.get("columnalias").equals("ACE_TYPE")) {
                        rowValue = (String)row.get(colConfigMap.get("columnalias").toString());
                        columnMap.put("isData", true);
                        columnMap.put("visible", true);
                        columnMap.put("columnValue", rowValue);
                        columnMap.put("columnalias", colConfigMap.get("columnalias"));
                        columnMap.put(colConfigMap.get("columnalias").toString(), rowValue);
                    } else if (colConfigMap.get("columnalias").equals("SECURITY_PRINCIPAL")) {
                        rowValue = (String)row.get(colConfigMap.get("columnalias").toString());
                        columnMap.put("isData", true);
                        columnMap.put("visible", true);
                        columnMap.put("columnValue", rowValue);
                        columnMap.put("columnalias", colConfigMap.get("columnalias"));
                        columnMap.put(colConfigMap.get("columnalias").toString(), rowValue);
                    } else if (colConfigMap.get("columnalias").equals("PERMISSION")) {
                        rowValue = (String)row.get(colConfigMap.get("columnalias").toString());
                        columnMap.put("isData", true);
                        columnMap.put("visible", true);
                        columnMap.put("columnValue", rowValue);
                        columnMap.put("columnalias", colConfigMap.get("columnalias"));
                        columnMap.put(colConfigMap.get("columnalias").toString(), rowValue);
                    } else if (colConfigMap.get("columnalias").equals("APPLIES_TO")) {
                        rowValue = (String)row.get(colConfigMap.get("columnalias").toString());
                        columnMap.put("isData", true);
                        columnMap.put("visible", true);
                        columnMap.put("columnValue", rowValue);
                        columnMap.put("columnalias", colConfigMap.get("columnalias"));
                        columnMap.put(colConfigMap.get("columnalias").toString(), rowValue);
                    } else if (colConfigMap.get("columnalias").equals("INHERITED_ACE")) {
                        rowValue = (String)row.get(colConfigMap.get("columnalias").toString());
                        columnMap.put("isData", true);
                        columnMap.put("visible", true);
                        columnMap.put("columnValue", rowValue);
                        columnMap.put("columnalias", colConfigMap.get("columnalias"));
                        columnMap.put(colConfigMap.get("columnalias").toString(), rowValue);
                    }
                    colList.add(columnMap);
                }
                rowMap.put("columnValues", colList);
                rowMap.put("rowId", row.get("SECURITY_PRINCIPAL"));
                rowList.add(rowMap);
            }
        }
        return rowList;
    }

    public void getPermissionChanges(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject reportInputParams = null;
            reportInputParams = reportReqData.getJSONObject("inputParams");
            String uniqueId = reportInputParams.getString("uniqueId");
            String action = reportInputParams.getString("action");
            String uvhString = "AUDCVConfig:cv_id:15033";
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDTableViewConfig", (String)"CV_ID"), (Object)cvId, 0);
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDTableViewConfig", crit);
            HashMap<String, String> tableDetails = new HashMap<String, String>();
            if (!dob.isEmpty()) {
                Row r = dob.getFirstRow("AUDTableViewConfig");
                List al = r.getColumns();
                for (int i = 0; i < al.size(); ++i) {
                    String key = String.valueOf(al.get(i));
                    String value = String.valueOf(r.get((String)al.get(i)));
                    tableDetails.put(key, value);
                }
            }
            ArrayList<HashMap<String, Object>> tableAllColumnList = ReportHandlerUtil.getInstance().getVisibleColumnList(cvId, true, true, true, null, null, rb);
            ArrayList<HashMap<String, Object>> reportList = this.getPermissionChangesList(uniqueId, action, tableAllColumnList);
            HashMap<String, ArrayList<HashMap<String, Object>>> returnListMap = new HashMap<String, ArrayList<HashMap<String, Object>>>();
            if (reportList.size() == 0) {
                reportInputParams.put("emptyTableMessage", (Object)rb.getString("adap_common.no_ad_objects_available"));
            }
            returnListMap.put("tableDataList", reportList);
            returnListMap.put("tableColumnList", tableAllColumnList);
            reportInputParams.put("cvId", (Object)cvId);
            reportInputParams.put("tabId", (Object)("tabId_" + cvId));
            reportInputParams.put("tabIdh", (Object)("#tabId_" + cvId));
            reportInputParams.put("tabName", (Object)("tabName_" + cvId));
            reportInputParams.put("tabDisplayName", (Object)"Permission Changes");
            ArrayList tabList = new ArrayList();
            HashMap<String, HashMap<String, ArrayList<HashMap<String, Object>>>> tabMap = new HashMap<String, HashMap<String, ArrayList<HashMap<String, Object>>>>();
            tabMap.put("tabData", returnListMap);
            tabMap.put("tabInputParams", (HashMap<String, ArrayList<HashMap<String, Object>>>)reportInputParams);
            tabList.add(tabMap);
            HashMap subReportListMap = new HashMap();
            subReportListMap.put("subReportList", tabList);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(subReportListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void getObjectDetails(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Properties objectProps = null;
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject reportInputParams = null;
            reportInputParams = reportReqData.getJSONObject("inputParams");
            String domainName = reportInputParams.getString("domainName");
            String msgTxt = null;
            String sid = reportInputParams.getString("accountSid");
            reportInputParams.put("hideTopDivider", true);
            reportInputParams.put("hideBorder", true);
            reportInputParams.put("hideTableOptions", true);
            reportInputParams.put("miniTable", true);
            try {
                objectProps = ObjectAttributeDetails.getInstance().getObjectDetailsFromSID(domainName, sid, new Long(1L), "SID_STRING", "user");
            }
            catch (Exception ex) {
                msgTxt = ex.getMessage();
                ex.printStackTrace();
            }
            ArrayList m1List = new ArrayList();
            if (objectProps != null && !objectProps.isEmpty()) {
                String[] a = new String[]{"adap.ObjectDetails.view_props.user.heading.user_details", "adap.ObjectDetails.view_props.common.heading.contact_details", "adap.ObjectDetails.view_props.user.heading.exch_server_details", "adap.ObjectDetails.view_props.common.heading.object_details", "adap.ObjectDetails.view_props.user.heading.terminal_server_details", "adap.ObjectDetails.view_props.user.heading.account_details"};
                String uvhString = "AUDCVConfig:cv_id:15034";
                Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
                Criteria crit = new Criteria(Column.getColumn((String)"AUDTableViewConfig", (String)"CV_ID"), (Object)cvId, 0);
                DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDTableViewConfig", crit);
                HashMap<String, String> tableDetails = new HashMap<String, String>();
                if (!dob.isEmpty()) {
                    Row r = dob.getFirstRow("AUDTableViewConfig");
                    List al = r.getColumns();
                    for (int i = 0; i < al.size(); ++i) {
                        String key = String.valueOf(al.get(i));
                        String value = String.valueOf(r.get((String)al.get(i)));
                        tableDetails.put(key, value);
                    }
                }
                ArrayList<HashMap<String, Object>> tableAllColumnList = ReportHandlerUtil.getInstance().getVisibleColumnList(cvId, true, true, true, null, null, rb);
                for (int i = 0; i < a.length; ++i) {
                    ArrayList<HashMap<String, Object>> rowList1 = null;
                    if (i == 0) {
                        rowList1 = this.getObjectGeneralDetails(objectProps, rb);
                    } else if (i == 1) {
                        rowList1 = this.getObjectContactDetails(objectProps, rb);
                    } else if (i == 2) {
                        rowList1 = this.getObjectExchangeDetails(objectProps, rb);
                    } else if (i == 3) {
                        rowList1 = this.getObjectDetails(objectProps, rb);
                    } else if (i == 4) {
                        rowList1 = this.getTerminalDetails(objectProps, rb);
                    } else if (i == 5) {
                        rowList1 = this.getAccountDetails(objectProps, rb);
                    }
                    HashMap<String, Object> tableMap = new HashMap<String, Object>();
                    HashMap<String, ArrayList<HashMap<String, Object>>> tableDataMap = new HashMap<String, ArrayList<HashMap<String, Object>>>();
                    tableDataMap.put("tableColumnList", tableAllColumnList);
                    tableDataMap.put("tableDataList", rowList1);
                    tableMap.put("path", rb.getString(a[i]));
                    tableMap.put("tableData", tableDataMap);
                    tableMap.put("tableInputParams", reportInputParams);
                    m1List.add(tableMap);
                }
            }
            if (m1List.size() == 0) {
                if (msgTxt == null || msgTxt == "") {
                    msgTxt = "No Data Available";
                }
                reportInputParams.put("boldMessage", (Object)msgTxt);
                reportInputParams.put("type", (Object)"emptyTable");
            }
            HashMap returnListMap = new HashMap();
            returnListMap.put("subReportList", m1List);
            returnListMap.put("objectInputParams", reportInputParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public HashMap<String, Object> getColMap(String colValue, String colAlias) {
        HashMap<String, Object> columnMap = new HashMap<String, Object>();
        columnMap.put(colAlias, colValue);
        columnMap.put("isData", true);
        columnMap.put("visible", true);
        columnMap.put("columnValue", colValue);
        columnMap.put("COLUMNALIAS", colAlias);
        return columnMap;
    }

    public ArrayList<HashMap<String, Object>> getObjectGeneralDetails(Properties objectProps, AdventNetResourceBundle rb) {
        ArrayList<HashMap<String, Object>> rowList = new ArrayList<HashMap<String, Object>>();
        String[] a = new String[]{"displayName", "userPrincipalName", "accountDisabled", "profilePath", "scriptPath", "PrimaryGroup", "printDuplexSupported", "printDuplexSupported", "printDuplexSupported", "printDuplexSupported"};
        String[] b = new String[]{"General", "Account", "Account", "Profile", "Profile", "Groups", "Groups", "Groups", "Groups", "Groups"};
        String[] c = new String[]{"adap.ObjectDetails.view_props.common.attrib_disp_name.display_name", "adap.ObjectDetails.view_props.user.attrib_disp_name.user_logon_name", "adap.ObjectDetails.view_props.user.attrib_disp_name.account_status", "adap.ObjectDetails.view_props.user.attrib_disp_name.user_profile_path", "adap.ObjectDetails.view_props.user.attrib_disp_name.logon_script", "adap.ObjectDetails.view_props.user.attrib_disp_name.member_of", "adap.ObjectDetails.view_props.user.attrib_disp_name.starting_program_at_logon", "adap.ObjectDetails.view_props.user.attrib_disp_name.ts_profile", "adap.ObjectDetails.view_props.user.attrib_disp_name.logon_to_workstation", "adap.ObjectDetails.view_props.user.attrib_disp_name.exchange_mail_box_info"};
        String columnAlias1 = "NAME";
        String columnAlias2 = "VALUE";
        for (int i = 0; i < a.length; ++i) {
            HashMap rowMap = new HashMap();
            ArrayList<HashMap<String, Object>> columnList1 = new ArrayList<HashMap<String, Object>>();
            Properties tabMap = (Properties)objectProps.get(b[i]);
            HashMap<String, Object> colMap1 = null;
            HashMap<String, Object> colMap2 = null;
            if (tabMap != null && tabMap.get(a[i]) != null) {
                Boolean result;
                String col2Value = "";
                col2Value = a[i].equals("accountDisabled") ? ((result = Boolean.valueOf(tabMap.get(a[i]).toString())).booleanValue() ? rb.getString("adap.ObjectDetails.view_props.user.common.statmsg.disable") : rb.getString("adap.ObjectDetails.view_props.user.common.statmsg.enabled")) : (a[i].equals("printDuplexSupported") ? ((result = Boolean.valueOf(tabMap.get(a[i]).toString())).booleanValue() ? rb.getString("adap.ObjectDetails.view_props.user.common.statmsg.enabled") : rb.getString("adap.ObjectDetails.view_props.user.common.statmsg.disabled")) : tabMap.get(a[i]).toString());
                colMap1 = this.getColMap(rb.getString(c[i]), columnAlias1);
                colMap2 = this.getColMap(col2Value, columnAlias2);
            } else {
                colMap1 = this.getColMap(rb.getString(c[i]), columnAlias1);
                colMap2 = a[i].equals("printDuplexSupported") ? this.getColMap(rb.getString("adap.ObjectDetails.view_props.user.common.statmsg.disabled"), columnAlias2) : this.getColMap(rb.getString("adap.common.text.not_applicable"), columnAlias2);
            }
            columnList1.add(colMap1);
            columnList1.add(colMap2);
            rowMap.put("columnValues", columnList1);
            rowList.add(rowMap);
        }
        return rowList;
    }

    public ArrayList<HashMap<String, Object>> getObjectContactDetails(Properties objectProps, AdventNetResourceBundle rb) {
        ArrayList<HashMap<String, Object>> rowList = new ArrayList<HashMap<String, Object>>();
        String[] a = new String[]{"fullName", "physicalDeliveryOfficeName", "lastName", "emailAddress", "displayName", "streetAddress", "postOfficeBox", "postalCode", "st", "co", "homePhone", "mobile", "facsimileTelephoneNumber", "pager", "ipPhone", "company", "department", "title"};
        String[] b = new String[]{"General", "General", "General", "General", "General", "Address", "Address", "Address", "Address", "Address", "Telephones", "Telephones", "Telephones", "Telephones", "Telephones", "Organization", "Organization", "Organization"};
        String[] c = new String[]{"adap.ObjectDetails.view_props.user.attrib_disp_name.name", "adap.ObjectDetails.view_props.common.attrib_disp_name.office", "adap.ObjectDetails.view_props.user.attrib_disp_name.last_name", "adap.ObjectDetails.view_props.common.attrib_disp_name.email_address", "adap.ObjectDetails.view_props.common.attrib_disp_name.display_name", "adap.ObjectDetails.view_props.common.attrib_disp_name.street_address", "adap.ObjectDetails.view_props.user.attrib_disp_name.po_box", "adap.ObjectDetails.view_props.user.attrib_disp_name.postal_code", "adap.ObjectDetails.view_props.common.attrib_disp_name.state_province", "adap.ObjectDetails.view_props.common.attrib_disp_name.country", "adap.ObjectDetails.view_props.user.attrib_disp_name.home_phone", "adap.ObjectDetails.view_props.user.attrib_disp_name.mobile", "adap.ObjectDetails.view_props.common.attrib_disp_name.fax", "adap.ObjectDetails.view_props.common.attrib_disp_name.pager", "adap.ObjectDetails.view_props.user.attrib_disp_name.ip_phone", "adap.ObjectDetails.view_props.user.attrib_disp_name.company_name", "adap.ObjectDetails.view_props.user.attrib_disp_name.dept", "adap.ObjectDetails.view_props.user.attrib_disp_name.title"};
        String columnAlias1 = "NAME";
        String columnAlias2 = "VALUE";
        for (int i = 0; i < a.length; ++i) {
            HashMap rowMap = new HashMap();
            ArrayList<HashMap<String, Object>> columnList1 = new ArrayList<HashMap<String, Object>>();
            Properties tabMap = (Properties)objectProps.get(b[i]);
            HashMap<String, Object> colMap1 = null;
            HashMap<String, Object> colMap2 = null;
            if (tabMap.get(a[i]) != null) {
                String col2Value = "";
                col2Value = tabMap.get(a[i]).toString();
                colMap1 = this.getColMap(rb.getString(c[i]), columnAlias1);
                colMap2 = this.getColMap(col2Value, columnAlias2);
            } else {
                colMap1 = this.getColMap(rb.getString(c[i]), columnAlias1);
                colMap2 = this.getColMap(rb.getString("adap.common.text.not_applicable"), columnAlias2);
            }
            columnList1.add(colMap1);
            columnList1.add(colMap2);
            rowMap.put("columnValues", columnList1);
            rowList.add(rowMap);
        }
        return rowList;
    }

    public ArrayList<HashMap<String, Object>> getObjectDetails(Properties objectProps, AdventNetResourceBundle rb) {
        ArrayList<HashMap<String, Object>> rowList = new ArrayList<HashMap<String, Object>>();
        String[] a = new String[]{"msNPCallingStationID", "msRADIUSCallbackNumber", "msNPAllowDialin", "msRASSavedFramedIPAddress", "PrimaryGroup", "Groups", "FQDN", "whenCreated", "whenChanged", "objectClass", "uSNCreated", "uSNChanged", "profilePath", "scriptPath", "homeDrive"};
        String[] b = new String[]{"DialIn", "DialIn", "DialIn", "DialIn", "Groups", "Groups", "Object", "Object", "Object", "Object", "Object", "Object", "Profile", "Profile", "Profile"};
        String[] c = new String[]{"adap.ObjectDetails.view_props.user.attrib_disp_name.verifying_caller_station_id", "adap.ObjectDetails.view_props.user.attrib_disp_name.call_back_option", "adap.ObjectDetails.view_props.user.attrib_disp_name.remote_access_permission", "adap.ObjectDetails.view_props.user.attrib_disp_name.assign_static_ip_address", "adap.ObjectDetails.view_props.user.attrib_disp_name.primary_group", "adap.ObjectDetails.view_props.user.attrib_disp_name.groups", "adap.ObjectDetails.view_props.common.attrib_disp_name.fully_qualified_name", "adap.ObjectDetails.view_props.common.attrib_disp_name.object_created", "adap.ObjectDetails.view_props.common.attrib_disp_name.object_modified", "adap.ObjectDetails.view_props.common.attrib_disp_name.object_class", "adap.ObjectDetails.view_props.common.attrib_disp_name.usn_created", "adap.ObjectDetails.view_props.common.attrib_disp_name.usn_changed", "adap.ObjectDetails.view_props.user.attrib_disp_name.profile_path", "adap.ObjectDetails.view_props.user.attrib_disp_name.script_path", "adap.ObjectDetails.view_props.user.attrib_disp_name.local_path"};
        String columnAlias1 = "NAME";
        String columnAlias2 = "VALUE";
        for (int i = 0; i < a.length; ++i) {
            String col2Value;
            HashMap rowMap = new HashMap();
            ArrayList<HashMap<String, Object>> columnList1 = new ArrayList<HashMap<String, Object>>();
            Properties tabMap = (Properties)objectProps.get(b[i]);
            HashMap<String, Object> colMap1 = null;
            HashMap<String, Object> colMap2 = null;
            if (tabMap.get(a[i]) != null) {
                Constable result;
                col2Value = "";
                col2Value = a[i].equals("msNPCallingStationID") ? ((Integer)(result = Integer.valueOf(Integer.parseInt(tabMap.get(a[i]).toString()))) == 0 ? rb.getString("adap.ObjectDetails.view_props.user.statmsg.nothing") : ((Integer)result).toString()) : (a[i].equals("msRADIUSCallbackNumber") ? ((Integer)(result = Integer.valueOf(Integer.parseInt(tabMap.get(a[i]).toString()))) == 0 ? ((Integer)(result = Integer.valueOf(Integer.parseInt(tabMap.get("msRADIUSServiceType").toString()))) == 0 ? rb.getString("adap.ObjectDetails.view_props.user.dialin.statmsg.no_callback") : rb.getString("adap.ObjectDetails.view_props.user.dialin.statmsg.set_by_caller")) : ((Integer)result).toString()) : (a[i].equals("msNPAllowDialin") ? (!((Boolean)(result = Boolean.valueOf(Boolean.parseBoolean(tabMap.get(a[i]).toString())))).booleanValue() ? rb.getString("adap.ObjectDetails.view_props.user.dialin.statmsg.deny_access") : rb.getString("adap.ObjectDetails.view_props.user.dialin.statmsg.allow_access")) : (a[i].equals("msRASSavedFramedIPAddress") ? ((Integer)(result = Integer.valueOf(Integer.parseInt(tabMap.get(a[i]).toString()))) != 0 ? rb.getString("adap.ObjectDetails.view_props.user.statmsg.ip_address_assigned") : rb.getString("adap.common.text.not_applicable")) : tabMap.get(a[i]).toString())));
                colMap1 = this.getColMap(rb.getString(c[i]), columnAlias1);
                colMap2 = this.getColMap(col2Value, columnAlias2);
            } else {
                col2Value = "";
                colMap1 = this.getColMap(rb.getString(c[i]), columnAlias1);
                col2Value = a[i].equals("msRASSavedFramedIPAddress") ? rb.getString("adap.ObjectDetails.view_props.user.statmsg.ip_address_assigned") : rb.getString("adap.common.text.not_applicable");
                colMap2 = this.getColMap(col2Value, columnAlias2);
            }
            columnList1.add(colMap1);
            columnList1.add(colMap2);
            rowMap.put("columnValues", columnList1);
            rowList.add(rowMap);
        }
        return rowList;
    }

    public ArrayList<HashMap<String, Object>> getTerminalDetails(Properties objectProps, AdventNetResourceBundle rb) {
        ArrayList<HashMap<String, Object>> rowList = new ArrayList<HashMap<String, Object>>();
        String[] a = new String[]{"tsIntialProgram", "tsWorkingDir", "tsDeviceClientDrives", "tsDeviceClientPrinters", "tsDeviceClientDefaultPrinter", "tsTimeOutSettingsDisConnections", "tsTimeOutSettingsConnections", "tsTimeOutSettingsIdle", "tsReConnectSettings", "tsBrokenTimeOutSettings", "tsShadowSettings", "tsShadowSettings", "tsShadowSettings"};
        String[] b = new String[]{"TerminalService", "TerminalService", "TerminalService", "TerminalService", "TerminalService", "TerminalService", "TerminalService", "TerminalService", "TerminalService", "TerminalService", "TerminalService", "TerminalService", "TerminalService"};
        String[] c = new String[]{"adap.ObjectDetails.view_props.user.attrib_disp_name.program_logon", "adap.ObjectDetails.view_props.user.attrib_disp_name.working_dir", "adap.ObjectDetails.view_props.user.attrib_disp_name.connect_client_drive_at_logon", "adap.ObjectDetails.view_props.user.attrib_disp_name.connect_client_printer_at_logon", "adap.ObjectDetails.view_props.user.attrib_disp_name.default_main_client_printers", "adap.ObjectDetails.view_props.user.attrib_disp_name.end_disconnected_session", "adap.ObjectDetails.view_props.user.attrib_disp_name.active_session_limit", "adap.ObjectDetails.view_props.user.attrib_disp_name.idle_session_limit", "adap.ObjectDetails.view_props.user.attrib_disp_name.reconnection_settings", "adap.ObjectDetails.view_props.user.attrib_disp_name.when_session_limit_reached_or_connection_broken", "adap.ObjectDetails.view_props.user.attrib_disp_name.enable_remote_control", "adap.ObjectDetails.view_props.user.attrib_disp_name.requires_user_permission", "adap.ObjectDetails.view_props.user.attrib_disp_name.level_of_control"};
        String columnAlias1 = "NAME";
        String columnAlias2 = "VALUE";
        for (int i = 0; i < a.length; ++i) {
            HashMap rowMap = new HashMap();
            ArrayList<HashMap<String, Object>> columnList1 = new ArrayList<HashMap<String, Object>>();
            Properties tabMap = (Properties)objectProps.get(b[i]);
            HashMap<String, Object> colMap1 = null;
            HashMap<String, Object> colMap2 = null;
            if (tabMap.get(a[i]) != null) {
                Integer result;
                String col2Value = "";
                if (a[i].equals("tsDeviceClientDrives")) {
                    result = Integer.parseInt(tabMap.get(a[i]).toString());
                    col2Value = result == 1 ? rb.getString("adap.common.text.filter_link.enabled") : rb.getString("adap.ObjectDetails.view_props.user.attrib_disp_name.client_not_connect_at_logon");
                } else if (a[i].equals("tsDeviceClientPrinters")) {
                    result = Integer.parseInt(tabMap.get(a[i]).toString());
                    col2Value = result == 1 ? rb.getString("adap.common.text.filter_link.enabled") : rb.getString("adap.ObjectDetails.view_props.user.attrib_disp_name.client_printer_not_connected_at_logon");
                } else if (a[i].equals("tsDeviceClientDefaultPrinter")) {
                    result = Integer.parseInt(tabMap.get(a[i]).toString());
                    col2Value = result == 1 ? rb.getString("adap.common.text.filter_link.enabled") : rb.getString("adap.ObjectDetails.view_props.user.exch_props.statmsg.not_connected_default_client_printer");
                } else if (a[i].equals("tsTimeOutSettingsDisConnections")) {
                    result = Integer.parseInt(tabMap.get(a[i]).toString());
                    if (result != 0) {
                        result = result / 60000;
                        col2Value = result.toString() + " (in Mins)";
                    } else {
                        col2Value = rb.getString("adap.ObjectDetails.view_props.user.exch_props.statmsg.never");
                    }
                } else if (a[i].equals("tsTimeOutSettingsConnections")) {
                    result = Integer.parseInt(tabMap.get(a[i]).toString());
                    if (result != 0) {
                        result = result / 60000;
                        col2Value = result.toString() + " (in Mins)";
                    } else {
                        col2Value = rb.getString("adap.ObjectDetails.view_props.user.exch_props.statmsg.never");
                    }
                } else if (a[i].equals("tsTimeOutSettingsIdle")) {
                    result = Integer.parseInt(tabMap.get(a[i]).toString());
                    if (result != 0) {
                        result = result / 60000;
                        col2Value = result.toString() + " (in Mins)";
                    } else {
                        col2Value = rb.getString("adap.ObjectDetails.view_props.user.exch_props.statmsg.never");
                    }
                } else {
                    col2Value = a[i].equals("tsReConnectSettings") ? ((result = Integer.valueOf(Integer.parseInt(tabMap.get(a[i]).toString()))) == 1 ? rb.getString("adap.ObjectDetails.view_props.user.common.statmsg.allow_from_any_client.allow_from_originating_client") : (result == 0 ? rb.getString("adap.ObjectDetails.view_props.user.common.statmsg.allow_from_any_client.allow_from_any_client") : rb.getString("adap.common.text.not_applicable"))) : (a[i].equals("tsBrokenTimeOutSettings") ? ((result = Integer.valueOf(Integer.parseInt(tabMap.get(a[i]).toString()))) == 1 ? rb.getString("adap.ObjectDetails.view_props.user.common.statmsg.allow_from_any_client.end_session") : (result == 0 ? rb.getString("adap.ObjectDetails.view_props.user.common.statmsg.allow_from_any_client.disconnect_session") : rb.getString("adap.common.text.not_applicable"))) : (c[i].equals("adap.ObjectDetails.view_props.user.attrib_disp_name.enable_remote_control") ? ((result = Integer.valueOf(Integer.parseInt(tabMap.get(a[i]).toString()))) == 0 ? rb.getString("adap.ObjectDetails.view_props.user.common.statmsg.disabled") : rb.getString("adap.ObjectDetails.view_props.user.common.statmsg.enabled")) : (c[i].equals("adap.ObjectDetails.view_props.user.attrib_disp_name.requires_user_permission") ? ((result = Integer.valueOf(Integer.parseInt(tabMap.get(a[i]).toString()))) == 1 || result == 3 ? rb.getString("adap.ObjectDetails.view_props.user.common.statmsg.enabled") : (result == 2 || result == 4 ? rb.getString("adap.ObjectDetails.view_props.user.common.statmsg.disabled") : rb.getString("adap.common.text.not_applicable"))) : (c[i].equals("adap.ObjectDetails.view_props.user.attrib_disp_name.level_of_control") ? ((result = Integer.valueOf(Integer.parseInt(tabMap.get(a[i]).toString()))) == 3 || result == 4 ? rb.getString("adap.ObjectDetails.view_props.user.common.statmsg.view_users_session") : (result == 2 || result == 1 ? rb.getString("adap.ObjectDetails.view_props.user.common.statmsg.interact_with_session") : rb.getString("adap.common.text.not_applicable"))) : tabMap.get(a[i]).toString()))));
                }
                colMap1 = this.getColMap(rb.getString(c[i]), columnAlias1);
                colMap2 = this.getColMap(col2Value, columnAlias2);
            } else {
                colMap1 = this.getColMap(rb.getString(c[i]), columnAlias1);
                colMap2 = this.getColMap(rb.getString("adap.common.text.not_applicable"), columnAlias2);
            }
            columnList1.add(colMap1);
            columnList1.add(colMap2);
            rowMap.put("columnValues", columnList1);
            rowList.add(rowMap);
        }
        return rowList;
    }

    public ArrayList<HashMap<String, Object>> getAccountDetails(Properties objectProps, AdventNetResourceBundle rb) {
        ArrayList<HashMap<String, Object>> rowList = new ArrayList<HashMap<String, Object>>();
        String[] a = new String[]{"userPrincipalName", "accountExpirationDate", "changePasswordNextLogon", "passwordExpired", "dontExpirePassword", "encryptTextPasswordAllowed", "accountDisabled", "smartCardRequired", "trustedForDelegation", "notDelegated", "useDESKeyOnly", "requirePreAuthentication"};
        String[] b = new String[]{"Account", "Account", "Account", "Account", "Account", "Account", "Account", "Account", "Account", "Account", "Account", "Account"};
        String[] c = new String[]{"adap.ObjectDetails.view_props.user.attrib_disp_name.user_principle_name", "adap.ObjectDetails.view_props.user.attrib_disp_name.account_expiration_date", "adap.ObjectDetails.view_props.user.attrib_disp_name.user_must_change_pwd_next_logon", "adap.ObjectDetails.view_props.user.attrib_disp_name.user_cant_change_pwd", "adap.ObjectDetails.view_props.user.attrib_disp_name.pwd_never_expires", "adap.ObjectDetails.view_props.user.attrib_disp_name.store_pwd_using_reversible_encrypt", "adap.ObjectDetails.view_props.user.attrib_disp_name.account_disabled", "adap.ObjectDetails.view_props.user.attrib_disp_name.smart_card_required", "adap.ObjectDetails.view_props.user.attrib_disp_name.account_trusted_for_delegation", "adap.ObjectDetails.view_props.user.attrib_disp_name.account_cant_delegated", "adap.ObjectDetails.view_props.user.attrib_disp_name.use_des_encrypt_types_for_this_account", "adap.ObjectDetails.view_props.user.attrib_disp_name.do_not_require_kerberos_preauthentication"};
        String columnAlias1 = "NAME";
        String columnAlias2 = "VALUE";
        for (int i = 0; i < a.length; ++i) {
            HashMap rowMap = new HashMap();
            ArrayList<HashMap<String, Object>> columnList1 = new ArrayList<HashMap<String, Object>>();
            Properties tabMap = (Properties)objectProps.get(b[i]);
            HashMap<String, Object> colMap1 = null;
            HashMap<String, Object> colMap2 = null;
            if (tabMap.get(a[i]) != null) {
                Boolean result;
                String col2Value = "";
                col2Value = a[i].equals("accountExpirationDate") || a[i].equals("userPrincipalName") ? tabMap.get(a[i]).toString() : ((result = Boolean.valueOf(tabMap.get(a[i]).toString())) != false ? rb.getString("adap.ObjectDetails.view_props.user.common.statmsg.disable") : rb.getString("adap.ObjectDetails.view_props.user.common.statmsg.enabled"));
                colMap1 = this.getColMap(rb.getString(c[i]), columnAlias1);
                colMap2 = this.getColMap(col2Value, columnAlias2);
            } else {
                colMap1 = this.getColMap(rb.getString(c[i]), columnAlias1);
                colMap2 = this.getColMap(rb.getString("adap.common.text.not_applicable"), columnAlias2);
            }
            columnList1.add(colMap1);
            columnList1.add(colMap2);
            rowMap.put("columnValues", columnList1);
            rowList.add(rowMap);
        }
        return rowList;
    }

    public ArrayList<HashMap<String, Object>> getObjectExchangeDetails(Properties objectProps, AdventNetResourceBundle rb) {
        ArrayList<HashMap<String, Object>> rowList = new ArrayList<HashMap<String, Object>>();
        String[] a = new String[]{"displayNamePrintable", "extensionAttribute5", "protocolSettings", "autoReplyMessage", "msExchHidefromAddressLists", "deliverAndRedirect", "homeMDB", "mailNickName", "submissionContlength", "delivContLength", "authOrig", "publicDelegates", "altRecipient", "deliverAndRedirect", "msExchRecipLimit", "mdbusedefaults", "deletedItemflags"};
        String[] b = new String[]{"ExchangeServer", "ExchangeServer", "ExchangeServer", "ExchangeServer", "ExchangeServer", "ExchangeServer", "ExchangeServer", "ExchangeServer", "ExchangeServer", "ExchangeServer", "ExchangeServer", "ExchangeServer", "ExchangeServer", "ExchangeServer", "ExchangeServer", "ExchangeServer", "ExchangeServer", "ExchangeServer"};
        String[] c = new String[]{"adap.ObjectDetails.view_props.user.attrib_disp_name.simple_display_name", "adap.ObjectDetails.view_props.user.attrib_disp_name.custom_attribs", "adap.ObjectDetails.view_props.user.attrib_disp_name.protocol_setting", "adap.ObjectDetails.view_props.user.attrib_disp_name.ils_setting", "adap.ObjectDetails.view_props.user.attrib_disp_name.hide_from_exch_address_list", "adap.ObjectDetails.view_props.user.attrib_disp_name.downgrade_high_priority_mail_bound_x400", "adap.ObjectDetails.view_props.user.attrib_disp_name.mailbox_store", "adap.ObjectDetails.view_props.user.attrib_disp_name.alias", "adap.ObjectDetails.view_props.user.attrib_disp_name.sending_message_size", "adap.ObjectDetails.view_props.user.attrib_disp_name.delivery_message_size", "adap.ObjectDetails.view_props.user.attrib_disp_name.message_restrictions", "adap.ObjectDetails.view_props.user.attrib_disp_name.send_message_on_behalf", "adap.ObjectDetails.view_props.user.attrib_disp_name.forward_address", "adap.ObjectDetails.view_props.user.attrib_disp_name.deliver_message_both_forwarding_address_and_mailbox", "adap.ObjectDetails.view_props.user.attrib_disp_name.recipient_limits", "adap.ObjectDetails.view_props.user.heading.storage_limit", "adap.ObjectDetails.view_props.user.attrib_disp_name.keep_deleted_items_for_days"};
        String columnAlias1 = "NAME";
        String columnAlias2 = "VALUE";
        for (int i = 0; i < a.length; ++i) {
            HashMap rowMap = new HashMap();
            ArrayList<HashMap<String, Object>> columnList1 = new ArrayList<HashMap<String, Object>>();
            Properties tabMap = (Properties)objectProps.get(b[i]);
            HashMap<String, Object> colMap1 = null;
            HashMap<String, Object> colMap2 = null;
            if (tabMap.get(a[i]) != null) {
                Boolean result;
                String col2Value = "";
                col2Value = a[i].equals("accountDisabled") ? ((result = (Boolean)tabMap.get(a[i])).booleanValue() ? rb.getString("adap.ObjectDetails.view_props.user.common.statmsg.disable") : rb.getString("adap.ObjectDetails.view_props.user.common.statmsg.enabled")) : tabMap.get(a[i]).toString();
                colMap1 = this.getColMap(rb.getString(c[i]), columnAlias1);
                colMap2 = this.getColMap(col2Value, columnAlias2);
            } else {
                colMap1 = this.getColMap(rb.getString(c[i]), columnAlias1);
                colMap2 = this.getColMap(rb.getString("adap.common.text.not_applicable"), columnAlias2);
            }
            columnList1.add(colMap1);
            columnList1.add(colMap2);
            rowMap.put("columnValues", columnList1);
            rowList.add(rowMap);
        }
        return rowList;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private ArrayList<HashMap<String, Object>> getHistoryTabList(HttpServletRequest request, HttpServletResponse response, String fl, boolean data) throws Exception {
        rb = ResourceBundleMgr.getInstance().getBundle(request);
        divName = new ArrayList<String>();
        divName.add("dc");
        divName.add("ws");
        divName.add("sync");
        divName.add("nps");
        reportReqData = new JSONObject(request.getParameter("JSONString"));
        reportReqData2 = new JSONObject(request.getParameter("JSONString"));
        reportInputParams = null;
        reportReqData3 = new JSONObject(request.getParameter("JSONString"));
        reportInputParams = reportReqData.getJSONObject("inputParams");
        reportInputParams2 = null;
        reportInputParams2 = reportReqData2.getJSONObject("inputParams");
        reportInputParams3 = null;
        reportReqData4 = new JSONObject(request.getParameter("JSONString"));
        reportInputParams4 = null;
        reportInputParams3 = reportReqData3.getJSONObject("inputParams");
        reportInputParams4 = reportReqData4.getJSONObject("inputParams");
        owa = false;
        nps = false;
        npsMessage = rb.getString("adap.HistoryDetails.not_part_of_domain");
        machineType = "";
        inputParams = new HashMap<String, Object>();
        inputParamsMap = null;
        domainName = reportInputParams.getString("domainName");
        workstation = reportInputParams.getString("workstation");
        timeGenerated = reportInputParams.getString("timeGenerated");
        accountName = reportInputParams.getString("accountName");
        reportId = reportInputParams.getLong("reportId");
        reportcvId = reportInputParams.getLong("cvId");
        nameBuilder = new StringBuilder();
        nameBuilder.append("'");
        nameBuilder.append(accountName);
        nameBuilder.append("'");
        inputParams.put("domainName", domainName);
        tabList = new ArrayList<HashMap<String, Object>>();
        flag = true;
        if (data) {
            ServerConfigHandler.getInstance().getRangeList(reportInputParams);
            ServerConfigHandler.getInstance().getRangeList(reportInputParams2);
            ServerConfigHandler.getInstance().getRangeList(reportInputParams3);
            ServerConfigHandler.getInstance().getRangeList(reportInputParams4);
            criteria = new Criteria(Column.getColumn((String)"ADSMExchangeServerDetails", (String)"NAME"), (Object)workstation, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMExchangeServerDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0));
            dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMExchangeServerDetails", criteria);
            if (!dataObj.isEmpty()) {
                r = dataObj.getFirstRow("ADSMExchangeServerDetails");
                role = (Integer)r.get("SERVER_ROLE");
                if (role == null) {
                    ProcessObject.updateExchangeServerDetails((String)domainName);
                    dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMExchangeServerDetails", criteria);
                    if (!dataObj.isEmpty()) {
                        r = dataObj.getFirstRow("ADSMExchangeServerDetails");
                        role = (Integer)r.get("SERVER_ROLE");
                    } else {
                        role = 1;
                    }
                }
                if ((role & 4) == 4) {
                    owa = true;
                }
            }
            if (!workstation.equalsIgnoreCase("") && !workstation.equalsIgnoreCase("-")) {
                flag = AccountLockoutHistory.checkIfMachineConfigured((String)domainName, (String)workstation, new HashMap<K, V>());
                if (flag) {
                    nps = true;
                } else {
                    criteria = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"NAME"), (Object)workstation, 0);
                    criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DOMAIN_NAME"), (Object)reportInputParams.getString("domainName"), 0));
                    d = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMComputerGeneralDetails", criteria);
                    if (d.isEmpty()) {
                        npsMessage = rb.getString("adap.HistoryDetails.not_part_of_domain");
                    } else {
                        row = d.getFirstRow("ADSMComputerGeneralDetails");
                        role = (String)row.get("ROLE");
                        os = (String)row.get("OPERATING_SYSTEM");
                        if (os == null || !os.toLowerCase().contains("windows")) {
                            npsMessage = rb.getString("adap.LockoutDetails.Not_windows_os");
                        } else if (role != null && role.toLowerCase().contains("domaincontroller")) {
                            npsMessage = rb.getString("adap.HistoryDetails.Configure_caller_machine_as") + "Domain Controller";
                            machineType = "DC";
                        } else if (role != null) {
                            if (os.toLowerCase().contains("server")) {
                                npsMessage = rb.getString("adap.HistoryDetails.Configure_caller_machine_as") + "Member Server";
                                machineType = "MS";
                            } else {
                                npsMessage = rb.getString("adap.HistoryDetails.Configure_caller_machine_as") + "Workstation";
                                machineType = "WS";
                            }
                        } else {
                            npsMessage = rb.getString("adap.LockoutDetails.Not_windows_os");
                        }
                    }
                }
            }
        }
        for (String name : divName) {
            block48: {
                block50: {
                    block54: {
                        block51: {
                            block52: {
                                block55: {
                                    block53: {
                                        block49: {
                                            block44: {
                                                block47: {
                                                    block45: {
                                                        block46: {
                                                            tabMap = new HashMap<String, HashMap<K, V>>();
                                                            columnList /* !! */  = new ArrayList<E>();
                                                            reportsList = new ArrayList();
                                                            if (workstation.equalsIgnoreCase("") || workstation.equalsIgnoreCase("-") || !name.equalsIgnoreCase("ws")) break block44;
                                                            count = 0;
                                                            startTime = Long.parseLong(timeGenerated) - 86400L;
                                                            if (!data) break block45;
                                                            workstation = this.getWorkstationName(workstation);
                                                            if (!flag) {
                                                                startTime = Long.parseLong(timeGenerated) - 900L;
                                                            }
                                                            row = DirectoryObjectAPI.getInstance().getComputerObjectRow("computer", null, workstation, domainName);
                                                            objectGuid = "";
                                                            if (row != null) {
                                                                objectGuid = row.get("OBJECT_GUID").toString();
                                                            }
                                                            if (objectGuid.equalsIgnoreCase("")) break block46;
                                                            objectList = new ArrayList<String>();
                                                            objectList.add(objectGuid);
                                                            inputParams.put("objectName", workstation);
                                                            inputParams.put("objectClass", "computer");
                                                            inputParams.put("object_guid", objectList);
                                                            inputParams.put("isLockoutHistory", true);
                                                            inputParamsMap = ReportHandlerUtil.getInstance().getInputParamsValues(inputParams, domainName, reportId);
                                                            inputParamsMap.put("TO", Long.valueOf(Long.parseLong(timeGenerated) + 240L).toString());
                                                            inputParamsMap.put("FROM", startTime.toString());
                                                            inputParamsMap.put("userName", nameBuilder.toString());
                                                            reportcvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:30000");
                                                            count = AuditReportAPI.getInstance().getReportCount(reportcvId, null, inputParamsMap);
                                                            reportsList = AuditReportAPI.getInstance().getReportRows(reportcvId, null, inputParamsMap, "TIME_GENERATED", "DESC", reportInputParams.getInt("startValue"), reportInputParams.getInt("rangeValue"), null, count, Boolean.valueOf(true));
                                                            columnList /* !! */  = ReportHandlerUtil.getInstance().getVisibleColumnList(reportcvId, true, true, false, null, null, rb);
                                                            AccountLockoutHistory.getInstance();
                                                            if (AccountLockoutHistory.workstationStatus.get(workstation) == null) ** GOTO lbl-1000
                                                            AccountLockoutHistory.getInstance();
                                                            if ((Integer)AccountLockoutHistory.workstationStatus.get(workstation) == 1) {
                                                                request.setAttribute("message", (Object)rb.handleGetObject("adap.EventDataHandler.Fetching_data_for_", new String[]{workstation}));
                                                                reportInputParams.put("emptyTableMessage", (Object)rb.handleGetObject("adap.EventDataHandler.Fetching_data_for_", new String[]{workstation}));
                                                                reportInputParams.put("emptyTableMessage2", (Object)rb.getString("adap_ServerConfig.click_here_to_refresh"));
                                                            } else lbl-1000:
                                                            // 2 sources

                                                            {
                                                                AccountLockoutHistory.getInstance();
                                                                if (AccountLockoutHistory.errorMessage.get(workstation) != null) {
                                                                    AccountLockoutHistory.getInstance();
                                                                    reportInputParams.put("emptyTableMessage", AccountLockoutHistory.errorMessage.get(workstation));
                                                                    reportInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                                                                    reportInputParams.put("emptyTableMessage2", (Object)rb.getString("adap_ServerConfig.click_here_to_refresh"));
                                                                } else {
                                                                    reportInputParams.put("emptyTableMessage", (Object)rb.getString("adap.HistoryDetails.No_History_Found"));
                                                                    reportInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                                                                    reportInputParams.put("emptyTableMessage2", (Object)rb.getString("adap_ServerConfig.click_here_to_refresh"));
                                                                }
                                                            }
                                                            break block47;
                                                        }
                                                        reportInputParams.put("emptyTableMessage", (Object)rb.getString("adap.HistoryDetails.No_History_Found"));
                                                        reportInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                                                        reportInputParams.put("emptyTableMessage2", (Object)rb.getString("adap_ServerConfig.click_here_to_refresh"));
                                                        break block47;
                                                    }
                                                    reportInputParams.put("emptyTableMessage", (Object)"Loading Data");
                                                }
                                                reportInputParams.put("cvId", (Object)reportcvId);
                                                reportInputParams.put("tabId", (Object)("tabId_" + name + "_" + reportcvId + fl));
                                                reportInputParams.put("tabIdh", (Object)("#tabId_" + name + "_" + reportcvId));
                                                reportInputParams.put("tabDisplayName", (Object)rb.getString("adap.reports.view_computers.tab_heading.Local_Logon"));
                                                reportInputParams.put("tabName", (Object)("tabName_" + reportcvId));
                                                reportInputParams.put("totalCount", count);
                                                FROM = new Date(startTime * 1000L);
                                                TO = new Date(Long.parseLong(timeGenerated) * 1000L);
                                                headingString = "(" + rb.handleGetObject("adap.Reports.AuditReports.From_Time_To_Time", new String[]{TimeUtil.getSimpleDateFormat((Date)FROM), TimeUtil.getSimpleDateFormat((Date)TO)});
                                                workstationStr = workstation;
                                                if (workstationStr != null && workstationStr.length() > 13) {
                                                    workstationStr = workstationStr.substring(0, 13) + "..";
                                                }
                                                headingString = headingString + ")" + rb.getString("adap.logonHistory.Displaying_History_from") + workstationStr;
                                                reportInputParams.put("filterText", (Object)headingString);
                                                reportInputParams.put("hideFilterTextClose", true);
                                                AccountLockoutHistory.getInstance();
                                                reportInputParams.put("workstationStatus", AccountLockoutHistory.workstationStatus.get(workstation));
                                                tableData = new HashMap<String, ArrayList<E>>();
                                                tableData.put("tableDataList", reportsList);
                                                tableData.put("tableColumnList", columnList /* !! */ );
                                                tabMap.put("tabData", tableData);
                                                tabMap.put("tabInputParams", reportInputParams);
                                                break block48;
                                            }
                                            if (!name.equalsIgnoreCase("dc")) break block49;
                                            startTime = Long.parseLong(timeGenerated) - 86400L;
                                            inputParamsMap = ReportHandlerUtil.getInstance().getInputParamsValues(inputParams, domainName, reportId);
                                            inputParamsMap.put("TO", Long.valueOf(Long.parseLong(timeGenerated) + 240L).toString());
                                            inputParamsMap.put("FROM", startTime.toString());
                                            inputParamsMap.put("userName", nameBuilder.toString());
                                            reportcvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:30002");
                                            count = 0;
                                            if (data) {
                                                count = AuditReportAPI.getInstance().getReportCount(reportcvId, null, inputParamsMap);
                                                reportsList = AuditReportAPI.getInstance().getReportRows(reportcvId, null, inputParamsMap, "TIME_GENERATED", "DESC", reportInputParams2.getInt("startValue"), reportInputParams2.getInt("rangeValue"), null, count, Boolean.valueOf(true));
                                                columnList /* !! */  = ReportHandlerUtil.getInstance().getVisibleColumnList(reportcvId, true, true, false, null, null, rb);
                                                if (count == 0) {
                                                    reportInputParams2.put("emptyTableMessage", (Object)rb.getString("adap.ChartUtil.No_Data_Available"));
                                                    reportInputParams2.put("emptyTableAction", (Object)"emptyTableAction");
                                                    reportInputParams2.put("emptyTableMessage2", (Object)rb.getString("adap.Reports.ReportResultRows.Click_here_to_TroubleShoot"));
                                                }
                                            } else {
                                                reportInputParams2.put("emptyTableMessage", (Object)"Loading Data");
                                            }
                                            reportInputParams2.put("cvId", (Object)reportcvId);
                                            reportInputParams2.put("tabId", (Object)("tabId_" + name + "_" + reportcvId + fl));
                                            reportInputParams2.put("tabIdh", (Object)("#tabId_" + name + "_" + reportcvId));
                                            reportInputParams2.put("tabName", (Object)("tabName" + reportcvId));
                                            reportInputParams2.put("tabDisplayName", (Object)rb.getString("adap.reports.view_computers.tab_heading.Account_Logon"));
                                            reportInputParams2.put("totalCount", count);
                                            FROM = new Date(startTime * 1000L);
                                            TO = new Date(Long.parseLong(timeGenerated) * 1000L);
                                            headingString = rb.handleGetObject("adap.Reports.AuditReports.From_Time_To_Time", new String[]{TimeUtil.getSimpleDateFormat((Date)FROM), TimeUtil.getSimpleDateFormat((Date)TO)});
                                            reportInputParams2.put("filterText", (Object)headingString);
                                            reportInputParams2.put("hideFilterTextClose", true);
                                            tabMap.put("tabInputParams", reportInputParams2);
                                            tableData = new HashMap<String, ArrayList<E>>();
                                            tableData.put("tableDataList", reportsList);
                                            tableData.put("tableColumnList", columnList /* !! */ );
                                            tabMap.put("tabData", tableData);
                                            break block48;
                                        }
                                        if (!name.equalsIgnoreCase("sync")) break block50;
                                        count = 0;
                                        startTime = Long.parseLong(timeGenerated) - 900L;
                                        reportcvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:30003");
                                        inputParamsMap = ReportHandlerUtil.getInstance().getInputParamsValues(inputParams, domainName, reportId);
                                        FROM = new Date((Long.parseLong(timeGenerated) - 900L) * 1000L);
                                        TO = new Date(Long.parseLong(timeGenerated) * 1000L);
                                        inputParamsMap.put("TO", Long.valueOf(Long.parseLong(timeGenerated) + 240L).toString());
                                        inputParamsMap.put("FROM", startTime.toString());
                                        inputParamsMap.put("userName", nameBuilder.toString());
                                        headingString = "(" + rb.handleGetObject("adap.Reports.AuditReports.From_Time_To_Time", new String[]{TimeUtil.getSimpleDateFormat((Date)FROM), TimeUtil.getSimpleDateFormat((Date)TO)});
                                        workstationStr = workstation;
                                        if (workstationStr != null && workstationStr.length() > 13) {
                                            workstationStr = workstationStr.substring(0, 13) + "..";
                                        }
                                        headingString = headingString + ") " + rb.getString("adap.logonHistory.Displaying_History_from") + workstationStr;
                                        reportInputParams3.put("filterText", (Object)headingString);
                                        reportInputParams3.put("hideFilterTextClose", true);
                                        reportInputParams3.put("cvId", (Object)reportcvId);
                                        reportInputParams3.put("tabId", (Object)("tabId_" + name + "_" + reportcvId + fl));
                                        AccountLockoutHistory.getInstance();
                                        reportInputParams3.put("activeSyncStatus", AccountLockoutHistory.activeSyncStatus.get(workstation));
                                        reportInputParams3.put("tabIdh", (Object)("#tabId_" + name + "_" + reportcvId));
                                        reportInputParams3.put("tabName", (Object)("tabName" + reportcvId));
                                        reportInputParams3.put("tabDisplayName", (Object)rb.getString("adap.SERVER_CONFIG_CONSTANTS.Owa_activesync"));
                                        reportInputParams3.remove("toBeConfigured");
                                        reportInputParams3.put("showRefresh", true);
                                        tableData = new HashMap<K, V>();
                                        if (!data) break block51;
                                        if (!owa) break block52;
                                        count = AuditReportAPI.getInstance().getReportCount(reportcvId, null, inputParamsMap);
                                        reportsList = AuditReportAPI.getInstance().getReportRows(reportcvId, null, inputParamsMap, "TIME_GENERATED", "DESC", reportInputParams3.getInt("startValue"), reportInputParams3.getInt("rangeValue"), null, count, Boolean.valueOf(true));
                                        columnList /* !! */  = ReportHandlerUtil.getInstance().getVisibleColumnList(reportcvId, true, true, false, null, null, rb);
                                        AccountLockoutHistory.getInstance();
                                        if (AccountLockoutHistory.activeSyncStatus.get(workstation) == null) break block53;
                                        AccountLockoutHistory.getInstance();
                                        if ((Integer)AccountLockoutHistory.activeSyncStatus.get(workstation) != 1) break block53;
                                        request.setAttribute("message", (Object)rb.handleGetObject("adap.EventDataHandler.Fetching_data_for_", new String[]{workstation}));
                                        reportInputParams3.put("emptyTableMessage", (Object)rb.handleGetObject("adap.EventDataHandler.Fetching_data_for_", new String[]{workstation}));
                                        break block54;
                                    }
                                    AccountLockoutHistory.getInstance();
                                    if (AccountLockoutHistory.activeSyncErrorMessage.get(workstation) == null) break block55;
                                    AccountLockoutHistory.getInstance();
                                    if (((String)AccountLockoutHistory.activeSyncErrorMessage.get(workstation)).contains("Error Code:")) {
                                        reportInputParams3.put("errorConfigure", true);
                                    }
                                    AccountLockoutHistory.getInstance();
                                    reportInputParams3.put("emptyTableMessage", AccountLockoutHistory.activeSyncErrorMessage.get(workstation));
                                    reportInputParams3.put("emptyTableAction", (Object)"emptyTableAction");
                                    AccountLockoutHistory.getInstance();
                                    if (!AccountLockoutHistory.iisConfigure.containsKey(workstation)) ** GOTO lbl-1000
                                    AccountLockoutHistory.getInstance();
                                    if (((Boolean)AccountLockoutHistory.iisConfigure.get(workstation)).booleanValue()) {
                                        reportInputParams3.put("toBeConfigured", true);
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        AccountLockoutHistory.getInstance();
                                        if (((String)AccountLockoutHistory.activeSyncErrorMessage.get(workstation)).contains("80005000")) {
                                            reportInputParams3.put("iisFeature", true);
                                        }
                                        reportInputParams3.put("emptyTableMessage2", (Object)rb.getString("adap_ServerConfig.click_here_to_refresh"));
                                    }
                                    break block54;
                                }
                                reportInputParams3.put("emptyTableMessage", (Object)rb.getString("adap.HistoryDetails.No_History_Found"));
                                reportInputParams3.put("emptyTableAction", (Object)"emptyTableAction");
                                reportInputParams3.put("emptyTableMessage2", (Object)rb.getString("adap_ServerConfig.click_here_to_refresh"));
                                break block54;
                            }
                            reportInputParams3.put("emptyTableMessage", (Object)rb.getString("adap.HistoryDetails.Caller_machine_must_be_Client_Access_Enabled_Exchange_Server"));
                            break block54;
                        }
                        reportInputParams3.put("emptyTableMessage", (Object)"Loading Data");
                    }
                    reportInputParams3.put("totalCount", count);
                    tabMap.put("tabInputParams", reportInputParams3);
                    tableData.put("tableDataList", reportsList);
                    tableData.put("tableColumnList", columnList /* !! */ );
                    tabMap.put("tabData", tableData);
                    break block48;
                }
                if (name.equalsIgnoreCase("nps")) {
                    startTime = Long.parseLong(timeGenerated) - 86400L;
                    inputParamsMap = ReportHandlerUtil.getInstance().getInputParamsValues(inputParams, domainName, reportId);
                    inputParamsMap.put("TO", Long.valueOf(Long.parseLong(timeGenerated) + 240L).toString());
                    inputParamsMap.put("FROM", startTime.toString());
                    inputParamsMap.put("userName", nameBuilder.toString());
                    reportcvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:30004");
                    count = 0;
                    if (data) {
                        if (!nps) {
                            if (machineType.length() > 0) {
                                reportInputParams4.put("npsMachineType", (Object)machineType);
                            }
                            reportInputParams4.put("emptyTableMessage", (Object)npsMessage);
                            reportInputParams4.put("emptyTableAction", (Object)"emptyTableAction");
                            reportInputParams4.put("emptyTableMessage2", null);
                        } else if (count == 0) {
                            reportInputParams4.put("emptyTableMessage", (Object)rb.getString("adap.ChartUtil.No_Data_Available"));
                            reportInputParams4.put("emptyTableAction", (Object)"emptyTableAction");
                            reportInputParams4.put("emptyTableMessage2", null);
                        }
                        if (nps) {
                            count = AuditReportAPI.getInstance().getReportCount(reportcvId, null, inputParamsMap);
                            reportsList = AuditReportAPI.getInstance().getReportRows(reportcvId, null, inputParamsMap, "TIME_GENERATED", "DESC", reportInputParams4.getInt("startValue"), reportInputParams4.getInt("rangeValue"), null, count, Boolean.valueOf(true));
                            columnList /* !! */  = ReportHandlerUtil.getInstance().getVisibleColumnList(reportcvId, true, true, false, null, null, rb);
                        }
                    } else {
                        reportInputParams4.put("emptyTableMessage", (Object)"Loading Data");
                    }
                    reportInputParams4.put("cvId", (Object)reportcvId);
                    reportInputParams4.put("tabId", (Object)("tabId_" + name + "_" + reportcvId + fl));
                    reportInputParams4.put("tabIdh", (Object)("#tabId_" + name + "_" + reportcvId));
                    reportInputParams4.put("tabName", (Object)("tabName" + reportcvId));
                    reportInputParams4.put("tabDisplayName", (Object)rb.getString("adap.SERVER_CONFIG_CONSTANTS.Radius"));
                    reportInputParams4.put("totalCount", count);
                    FROM = new Date(startTime * 1000L);
                    TO = new Date(Long.parseLong(timeGenerated) * 1000L);
                    workstationStr = workstation;
                    if (workstationStr != null && workstationStr.length() > 13) {
                        workstationStr = workstationStr.substring(0, 13) + "..";
                    }
                    headingString = "(" + rb.handleGetObject("adap.Reports.AuditReports.From_Time_To_Time", new String[]{TimeUtil.getSimpleDateFormat((Date)FROM), TimeUtil.getSimpleDateFormat((Date)TO)});
                    headingString = headingString + ") " + rb.getString("adap.logonHistory.Displaying_History_from") + workstationStr;
                    reportInputParams4.put("filterText", (Object)headingString);
                    reportInputParams4.put("hideFilterTextClose", true);
                    tabMap.put("tabInputParams", reportInputParams4);
                    tableData = new HashMap<K, V>();
                    tableData.put("tableDataList", reportsList);
                    tableData.put("tableColumnList", columnList /* !! */ );
                    tabMap.put("tabData", tableData);
                }
            }
            if ((workstation.equalsIgnoreCase("") || workstation.equalsIgnoreCase("-")) && name.equalsIgnoreCase("ws")) continue;
            tabList.add(tabMap);
        }
        return tabList;
    }

    public void getLockoutHistory(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            ArrayList<HashMap<String, Object>> tabList = this.getHistoryTabList(request, response, "a", true);
            HashMap<String, ArrayList<HashMap<String, Object>>> returnListMap = new HashMap<String, ArrayList<HashMap<String, Object>>>();
            returnListMap.put("subReportList", tabList);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void getLockoutHistoryData(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            block23: {
                block25: {
                    block27: {
                        block28: {
                            block26: {
                                block24: {
                                    block22: {
                                        rb = ResourceBundleMgr.getInstance().getBundle(request);
                                        reportReqData = new JSONObject(request.getParameter("JSONString"));
                                        reportInputParams = null;
                                        reportInputParams = reportReqData.getJSONObject("inputParams");
                                        inputParams = new HashMap<String, Object>();
                                        inputParamsMap = null;
                                        domainName = reportInputParams.getString("domainName");
                                        workstation = reportInputParams.getString("workstation");
                                        timeGenerated = reportInputParams.getString("timeGenerated");
                                        accountName = reportInputParams.getString("accountName");
                                        reportId = reportInputParams.getLong("reportId");
                                        reportcvId = reportInputParams.getLong("cvId");
                                        tabId = reportInputParams.getString("tabId");
                                        ServerConfigHandler.getInstance().getRangeList(reportInputParams);
                                        nameBuilder = new StringBuilder();
                                        nameBuilder.append("'");
                                        nameBuilder.append(accountName);
                                        nameBuilder.append("'");
                                        inputParams.put("domainName", domainName);
                                        tabList = new ArrayList<HashMap<K, V>>();
                                        reportInputParams.put("showNavigation", true);
                                        tabMap = new HashMap<String, Object>();
                                        if (workstation.equalsIgnoreCase("") || workstation.equalsIgnoreCase("-") || !tabId.toLowerCase().startsWith("tabid_ws_" + reportcvId)) break block22;
                                        startTime = Long.parseLong(timeGenerated) - 86400L;
                                        flag = AccountLockoutHistory.checkIfMachineConfigured((String)domainName, (String)(workstation = this.getWorkstationName(workstation)), new HashMap<K, V>());
                                        if (!flag) {
                                            startTime = Long.parseLong(timeGenerated) - 900L;
                                        }
                                        row = DirectoryObjectAPI.getInstance().getComputerObjectRow("computer", null, workstation, domainName);
                                        objectGuid = "";
                                        if (row != null) {
                                            objectGuid = row.get("OBJECT_GUID").toString();
                                        }
                                        count = 0;
                                        columnList = null;
                                        reportsList = null;
                                        if (!objectGuid.equalsIgnoreCase("")) {
                                            objectList = new ArrayList<String>();
                                            objectList.add(objectGuid);
                                            inputParams.put("objectName", workstation);
                                            inputParams.put("objectClass", "computer");
                                            inputParams.put("object_guid", objectList);
                                            inputParams.put("isLockoutHistory", true);
                                            inputParamsMap = ReportHandlerUtil.getInstance().getInputParamsValues(inputParams, domainName, reportId);
                                            inputParamsMap.put("TO", Long.valueOf(Long.parseLong(timeGenerated) + 240L).toString());
                                            inputParamsMap.put("FROM", startTime.toString());
                                            inputParamsMap.put("userName", nameBuilder.toString());
                                            reportcvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:30000");
                                            count = AuditReportAPI.getInstance().getReportCount(reportcvId, null, inputParamsMap);
                                            reportsList = AuditReportAPI.getInstance().getReportRows(reportcvId, null, inputParamsMap, "TIME_GENERATED", "DESC", reportInputParams.getInt("startValue"), reportInputParams.getInt("rangeValue"), null, count, Boolean.valueOf(true));
                                            columnList = ReportHandlerUtil.getInstance().getVisibleColumnList(reportcvId, true, true, false, null, null, rb);
                                        }
                                        AccountLockoutHistory.getInstance();
                                        if (AccountLockoutHistory.workstationStatus.get(workstation) == null) ** GOTO lbl-1000
                                        AccountLockoutHistory.getInstance();
                                        if ((Integer)AccountLockoutHistory.workstationStatus.get(workstation) == 1) {
                                            request.setAttribute("message", (Object)rb.handleGetObject("adap.EventDataHandler.Fetching_data_for_", new String[]{workstation}));
                                            reportInputParams.put("emptyTableMessage", (Object)rb.handleGetObject("adap.EventDataHandler.Fetching_data_for_", new String[]{workstation}));
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            AccountLockoutHistory.getInstance();
                                            if (AccountLockoutHistory.errorMessage.get(workstation) != null) {
                                                AccountLockoutHistory.getInstance();
                                                reportInputParams.put("emptyTableMessage", AccountLockoutHistory.errorMessage.get(workstation));
                                                reportInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                                                reportInputParams.put("emptyTableMessage2", (Object)rb.getString("adap.Reports.ReportResultRows.Click_here_to_TroubleShoot"));
                                                AccountLockoutHistory.getInstance();
                                                request.setAttribute("errorMessage", AccountLockoutHistory.errorMessage.get(workstation));
                                            } else {
                                                reportInputParams.put("emptyTableMessage", (Object)rb.getString("adap.HistoryDetails.No_History_Found"));
                                                reportInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                                                reportInputParams.put("emptyTableMessage2", (Object)rb.getString("adap_ServerConfig.click_here_to_refresh"));
                                            }
                                        }
                                        reportInputParams.put("objectClass", (Object)"computer");
                                        reportInputParams.put("cvId", (Object)reportcvId);
                                        reportInputParams.put("tabId", (Object)tabId);
                                        reportInputParams.put("tabIdh", (Object)("#tabId_ws_" + reportcvId));
                                        reportInputParams.put("tabDisplayName", (Object)rb.getString("adap.reports.view_computers.tab_heading.Local_Logon"));
                                        reportInputParams.put("tabName", (Object)("tabName_" + reportcvId));
                                        reportInputParams.put("totalCount", count);
                                        FROM = new Date(startTime * 1000L);
                                        TO = new Date(Long.parseLong(timeGenerated) * 1000L);
                                        headingString = "(" + rb.handleGetObject("adap.Reports.AuditReports.From_Time_To_Time", new String[]{TimeUtil.getSimpleDateFormat((Date)FROM), TimeUtil.getSimpleDateFormat((Date)TO)});
                                        workstationStr = workstation;
                                        if (workstationStr != null && workstationStr.length() > 13) {
                                            workstationStr = workstationStr.substring(0, 13) + "..";
                                        }
                                        headingString = headingString + ") " + rb.getString("adap.logonHistory.Displaying_History_from") + workstationStr;
                                        reportInputParams.put("filterText", (Object)headingString);
                                        reportInputParams.put("hideFilterTextClose", true);
                                        AccountLockoutHistory.getInstance();
                                        reportInputParams.put("workstationStatus", AccountLockoutHistory.workstationStatus.get(workstation));
                                        tableData = new HashMap<String, ArrayList<HashMap<String, Object>>>();
                                        tableData.put("tableDataList", reportsList);
                                        tableData.put("tableColumnList", columnList);
                                        tabMap.put("tabName", "Workstation");
                                        tabMap.put("tabData", tableData);
                                        tabMap.put("tabInputParams", reportInputParams);
                                        break block23;
                                    }
                                    if (!tabId.toLowerCase().startsWith("tabid_dc_" + reportcvId)) break block24;
                                    startTime = Long.parseLong(timeGenerated) - 86400L;
                                    inputParamsMap = ReportHandlerUtil.getInstance().getInputParamsValues(inputParams, domainName, reportId);
                                    inputParamsMap.put("TO", Long.valueOf(Long.parseLong(timeGenerated) + 240L).toString());
                                    inputParamsMap.put("FROM", startTime.toString());
                                    inputParamsMap.put("userName", nameBuilder.toString());
                                    reportcvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:30002");
                                    count = AuditReportAPI.getInstance().getReportCount(reportcvId, null, inputParamsMap);
                                    reportsList = AuditReportAPI.getInstance().getReportRows(reportcvId, null, inputParamsMap, "TIME_GENERATED", "DESC", reportInputParams.getInt("startValue"), reportInputParams.getInt("rangeValue"), null, count, Boolean.valueOf(true));
                                    columnList = ReportHandlerUtil.getInstance().getVisibleColumnList(reportcvId, true, true, false, null, null, rb);
                                    reportInputParams.put("objectClass", (Object)"computer");
                                    reportInputParams.put("cvId", (Object)reportcvId);
                                    reportInputParams.put("tabId", (Object)tabId);
                                    reportInputParams.put("tabIdh", (Object)("#tabId_dc_" + reportcvId));
                                    reportInputParams.put("tabName", (Object)("tabName" + reportcvId));
                                    reportInputParams.put("tabDisplayName", (Object)rb.getString("adap.reports.view_computers.tab_heading.Account_Logon"));
                                    reportInputParams.put("totalCount", count);
                                    FROM = new Date(startTime * 1000L);
                                    TO = new Date(Long.parseLong(timeGenerated) * 1000L);
                                    headingString = rb.handleGetObject("adap.Reports.AuditReports.From_Time_To_Time", new String[]{TimeUtil.getSimpleDateFormat((Date)FROM), TimeUtil.getSimpleDateFormat((Date)TO)});
                                    reportInputParams.put("filterText", (Object)headingString);
                                    reportInputParams.put("hideFilterTextClose", true);
                                    if (count == 0) {
                                        reportInputParams.put("emptyTableMessage", (Object)rb.getString("adap.ChartUtil.No_Data_Available"));
                                        reportInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                                        reportInputParams.put("emptyTableMessage2", (Object)rb.getString("adap.Reports.ReportResultRows.Click_here_to_TroubleShoot"));
                                    }
                                    tabMap.put("tabInputParams", reportInputParams);
                                    tableData = new HashMap<String, ArrayList<HashMap<String, Object>>>();
                                    tableData.put("tableDataList", reportsList);
                                    tableData.put("tableColumnList", columnList);
                                    tabMap.put("tabName", "Domain Controllers");
                                    tabMap.put("tabData", tableData);
                                    break block23;
                                }
                                if (!tabId.toLowerCase().startsWith("tabid_sync_" + reportcvId)) break block25;
                                startTime = Long.parseLong(timeGenerated) - 900L;
                                serverBuilder = new StringBuilder();
                                serverBuilder.append("'");
                                serverBuilder.append(workstation);
                                serverBuilder.append("'");
                                inputParamsMap = ReportHandlerUtil.getInstance().getInputParamsValues(inputParams, domainName, reportId);
                                inputParamsMap.put("TO", Long.valueOf(Long.parseLong(timeGenerated) + 240L).toString());
                                inputParamsMap.put("FROM", startTime.toString());
                                inputParamsMap.put("userName", nameBuilder.toString());
                                inputParamsMap.put("objectName", serverBuilder.toString());
                                reportcvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:30003");
                                count = 0;
                                reportsList = new ArrayList();
                                columnList /* !! */  = new ArrayList<E>();
                                reportInputParams.put("cvId", (Object)reportcvId);
                                reportInputParams.put("tabId", (Object)tabId);
                                reportInputParams.put("tabIdh", (Object)("#tabId_sync_" + reportcvId));
                                reportInputParams.put("tabName", (Object)("tabName" + reportcvId));
                                reportInputParams.put("tabDisplayName", (Object)rb.getString("adap.SERVER_CONFIG_CONSTANTS.Owa_activesync"));
                                AccountLockoutHistory.getInstance();
                                reportInputParams.put("activeSyncStatus", AccountLockoutHistory.activeSyncStatus.get(workstation));
                                reportInputParams.put("showRefresh", true);
                                FROM = new Date(startTime * 1000L);
                                TO = new Date(Long.parseLong(timeGenerated) * 1000L);
                                headingString = "(" + rb.handleGetObject("adap.Reports.AuditReports.From_Time_To_Time", new String[]{TimeUtil.getSimpleDateFormat((Date)FROM), TimeUtil.getSimpleDateFormat((Date)TO)});
                                workstationStr = workstation;
                                if (workstationStr != null && workstationStr.length() > 13) {
                                    workstationStr = workstationStr.substring(0, 13) + "..";
                                }
                                headingString = headingString + ") " + rb.getString("adap.logonHistory.Displaying_History_from") + workstationStr;
                                reportInputParams.put("filterText", (Object)headingString);
                                reportInputParams.put("hideFilterTextClose", true);
                                count = AuditReportAPI.getInstance().getReportCount(reportcvId, null, inputParamsMap);
                                reportInputParams.put("totalCount", count);
                                reportInputParams.remove("toBeConfigured");
                                AccountLockoutHistory.getInstance();
                                if (AccountLockoutHistory.activeSyncStatus.get(workstation) == null) break block26;
                                AccountLockoutHistory.getInstance();
                                if ((Integer)AccountLockoutHistory.activeSyncStatus.get(workstation) != 1) break block26;
                                request.setAttribute("message", (Object)rb.handleGetObject("adap.EventDataHandler.Fetching_data_for_", new String[]{workstation}));
                                reportInputParams.put("emptyTableMessage", (Object)rb.handleGetObject("adap.EventDataHandler.Fetching_data_for_", new String[]{workstation}));
                                reportInputParams.remove("emptyTableMessage2");
                                break block27;
                            }
                            AccountLockoutHistory.getInstance();
                            if (AccountLockoutHistory.activeSyncErrorMessage.get(workstation) == null) break block28;
                            AccountLockoutHistory.getInstance();
                            if (((String)AccountLockoutHistory.activeSyncErrorMessage.get(workstation)).contains("Error Code:")) {
                                reportInputParams.put("errorConfigure", true);
                            }
                            AccountLockoutHistory.getInstance();
                            reportInputParams.put("emptyTableMessage", AccountLockoutHistory.activeSyncErrorMessage.get(workstation));
                            reportInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                            AccountLockoutHistory.getInstance();
                            request.setAttribute("errorMessage", AccountLockoutHistory.activeSyncErrorMessage.get(workstation));
                            AccountLockoutHistory.getInstance();
                            if (!AccountLockoutHistory.iisConfigure.containsKey(workstation)) ** GOTO lbl-1000
                            AccountLockoutHistory.getInstance();
                            if (((Boolean)AccountLockoutHistory.iisConfigure.get(workstation)).booleanValue()) {
                                reportInputParams.put("toBeConfigured", true);
                            } else lbl-1000:
                            // 2 sources

                            {
                                AccountLockoutHistory.getInstance();
                                if (((String)AccountLockoutHistory.activeSyncErrorMessage.get(workstation)).contains("80005000")) {
                                    reportInputParams.put("iisFeature", true);
                                }
                                reportInputParams.put("emptyTableMessage2", (Object)rb.getString("adap_ServerConfig.click_here_to_refresh"));
                            }
                            break block27;
                        }
                        reportInputParams.put("emptyTableMessage", (Object)rb.getString("adap.HistoryDetails.No_History_Found"));
                        reportInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                        reportInputParams.put("emptyTableMessage2", (Object)rb.getString("adap_ServerConfig.click_here_to_refresh"));
                    }
                    if (count > 0) {
                        reportInputParams.remove("errorConfigure");
                        reportInputParams.remove("toBeConfigured");
                    }
                    reportsList = AuditReportAPI.getInstance().getReportRows(reportcvId, null, inputParamsMap, "TIME_GENERATED", "DESC", reportInputParams.getInt("startValue"), reportInputParams.getInt("rangeValue"), null, count, Boolean.valueOf(true));
                    columnList /* !! */  = ReportHandlerUtil.getInstance().getVisibleColumnList(reportcvId, true, true, false, null, null, rb);
                    tabMap.put("tabInputParams", reportInputParams);
                    tableData = new HashMap<String, ArrayList<E>>();
                    tableData.put("tableDataList", reportsList);
                    tableData.put("tableColumnList", columnList /* !! */ );
                    tabMap.put("tabName", "Domain Controllers");
                    tabMap.put("tabData", tableData);
                    break block23;
                }
                if (tabId.toLowerCase().startsWith("tabid_nps_" + reportcvId)) {
                    startTime = Long.parseLong(timeGenerated) - 86400L;
                    row = DirectoryObjectAPI.getInstance().getComputerObjectRow("computer", null, workstation, domainName);
                    objectGuid = "";
                    if (row != null) {
                        objectGuid = row.get("OBJECT_GUID").toString();
                    }
                    count = 0;
                    columnList = null;
                    reportsList = null;
                    if (!objectGuid.equalsIgnoreCase("")) {
                        objectList = new ArrayList<String>();
                        objectList.add(objectGuid);
                        inputParams.put("objectName", workstation);
                        inputParams.put("objectClass", "computer");
                        inputParams.put("object_guid", objectList);
                        inputParams.put("isLockoutHistory", true);
                        inputParamsMap = ReportHandlerUtil.getInstance().getInputParamsValues(inputParams, domainName, reportId);
                        inputParamsMap.put("TO", Long.valueOf(Long.parseLong(timeGenerated) + 240L).toString());
                        inputParamsMap.put("FROM", startTime.toString());
                        inputParamsMap.put("userName", nameBuilder.toString());
                        reportcvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:30004");
                        count = AuditReportAPI.getInstance().getReportCount(reportcvId, null, inputParamsMap);
                        reportsList = AuditReportAPI.getInstance().getReportRows(reportcvId, null, inputParamsMap, "TIME_GENERATED", "DESC", reportInputParams.getInt("startValue"), reportInputParams.getInt("rangeValue"), null, count, Boolean.valueOf(true));
                        columnList = ReportHandlerUtil.getInstance().getVisibleColumnList(reportcvId, true, true, false, null, null, rb);
                        reportInputParams.put("objectClass", (Object)"computer");
                    }
                    reportInputParams.put("cvId", (Object)reportcvId);
                    reportInputParams.put("tabId", (Object)tabId);
                    reportInputParams.put("tabIdh", (Object)("#tabId_dc_" + reportcvId));
                    reportInputParams.put("tabName", (Object)("tabName" + reportcvId));
                    reportInputParams.put("tabDisplayName", (Object)rb.getString("adap.SERVER_CONFIG_CONSTANTS.Radius"));
                    reportInputParams.put("totalCount", count);
                    FROM = new Date(startTime * 1000L);
                    TO = new Date(Long.parseLong(timeGenerated) * 1000L);
                    workstationStr = workstation;
                    if (workstationStr != null && workstationStr.length() > 13) {
                        workstationStr = workstationStr.substring(0, 13) + "..";
                    }
                    headingString = "(" + rb.handleGetObject("adap.Reports.AuditReports.From_Time_To_Time", new String[]{TimeUtil.getSimpleDateFormat((Date)FROM), TimeUtil.getSimpleDateFormat((Date)TO)});
                    headingString = headingString + ") " + rb.getString("adap.logonHistory.Displaying_History_from") + workstationStr;
                    reportInputParams.put("filterText", (Object)headingString);
                    reportInputParams.put("hideFilterTextClose", true);
                    if (count == 0) {
                        reportInputParams.put("emptyTableMessage", (Object)rb.getString("adap.ChartUtil.No_Data_Available"));
                        reportInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                        reportInputParams.put("emptyTableMessage2", null);
                    }
                    tabMap.put("tabInputParams", reportInputParams);
                    tableData = new HashMap<String, ArrayList<HashMap<String, Object>>>();
                    tableData.put("tableDataList", reportsList);
                    tableData.put("tableColumnList", columnList);
                    tabMap.put("tabName", "RADIUS(NPS)");
                    tabMap.put("tabData", tableData);
                }
            }
            tabList.add(tabMap);
            returnListMap = new HashMap<String, V>();
            returnListMap.put("tabData", tabMap.get("tabData"));
            returnListMap.put("tabInputParams", tabMap.get("tabInputParams"));
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getWorkstationName(String workstation) throws Exception {
        if (null != workstation && (workstation.contains("\\") || workstation.contains("\\\\"))) {
            workstation = workstation.replace("\\\\", "");
            workstation = workstation.replace("\\", "");
        }
        return workstation;
    }

    public void syncIIS(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject reportInputParams = null;
            reportInputParams = reportReqData.getJSONObject("inputParams");
            String domainName = reportInputParams.getString("domainName");
            String workstation = reportInputParams.getString("workstation");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("workstation", workstation);
            map.put("domainName", domainName);
            map.put("sync", "true");
            IISHandler.checkAndGetIISDetails(map);
            AccountLockoutHistory.getInstance();
            AccountLockoutHistory.activeSyncErrorMessage.put(workstation, (String)map.get("err"));
            if (map.containsKey("errorConfigure")) {
                AccountLockoutHistory.getInstance();
                if (((String)AccountLockoutHistory.activeSyncErrorMessage.get(workstation)).contains("80005000")) {
                    map.put("iisFeature", true);
                }
            }
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(map)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void configureIIS(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject reportInputParams = null;
            reportInputParams = reportReqData.getJSONObject("inputParams");
            String domainName = reportInputParams.getString("domainName");
            String workstation = reportInputParams.getString("workstation");
            HashMap<String, Boolean> returnListMap = new HashMap<String, Boolean>();
            IISHandler.configureIIS((String)workstation, (String)domainName, returnListMap);
            AccountLockoutHistory.getInstance();
            AccountLockoutHistory.activeSyncErrorMessage.put(workstation, (String)returnListMap.get("errorMessage"));
            if (returnListMap.containsKey("errorConfigure")) {
                AccountLockoutHistory.getInstance();
                if (((String)AccountLockoutHistory.activeSyncErrorMessage.get(workstation)).contains("80005000")) {
                    returnListMap.put("iisFeature", true);
                }
            }
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void refreshHistoryDetails(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            block7: {
                block6: {
                    rb = ResourceBundleMgr.getInstance().getBundle(request);
                    reportReqData = new JSONObject(request.getParameter("JSONString"));
                    reportInputParams = null;
                    reportInputParams = reportReqData.getJSONObject("inputParams");
                    domainName = reportInputParams.getString("domainName");
                    workstation = reportInputParams.getString("workstation");
                    timeGenerated = reportInputParams.getString("timeGenerated");
                    accountName = reportInputParams.getString("accountName");
                    uniqueId = reportInputParams.getString("uniqueId");
                    map = new HashMap<String, String>();
                    map.put("workstation", workstation);
                    map.put("accountName", accountName);
                    map.put("domainName", domainName);
                    map.put("timeGenerated", timeGenerated);
                    map.put("uniqueId", uniqueId);
                    if (!reportInputParams.getString("tabId").contains("tabId_ws_")) break block6;
                    AccountLockoutHistory.getInstance();
                    if (AccountLockoutHistory.workstationStatus.get(workstation) == null) ** GOTO lbl-1000
                    AccountLockoutHistory.getInstance();
                    if ((Integer)AccountLockoutHistory.workstationStatus.get(workstation) == 0) lbl-1000:
                    // 2 sources

                    {
                        AccountLockoutHistory.getInstance().fetchEventData(map);
                        request.setAttribute("message", (Object)rb.handleGetObject("adap.AccountLockoutAction.Started_fetching_Event_Data_from", new String[]{workstation}));
                        reportInputParams.put("emptyTableMessage", (Object)rb.handleGetObject("adap.AccountLockoutAction.Started_fetching_Event_Data_from", new String[]{workstation}));
                        reportInputParams.remove("emptyTableMessage2");
                    } else {
                        request.setAttribute("message", (Object)rb.handleGetObject("adap.EventDataHandler.Fetching_data_for_", new String[]{workstation}));
                        reportInputParams.put("emptyTableMessage", (Object)rb.handleGetObject("adap.EventDataHandler.Fetching_data_for_", new String[]{workstation}));
                    }
                    AccountLockoutHistory.getInstance();
                    reportInputParams.put("workstationStatus", AccountLockoutHistory.workstationStatus.get(workstation));
                    break block7;
                }
                if (!reportInputParams.getString("tabId").contains("tabId_sync_")) break block7;
                reportInputParams.remove("toBeConfigured");
                AccountLockoutHistory.getInstance();
                if (AccountLockoutHistory.activeSyncStatus.get(workstation) == null) ** GOTO lbl-1000
                AccountLockoutHistory.getInstance();
                if ((Integer)AccountLockoutHistory.activeSyncStatus.get(workstation) == 0) lbl-1000:
                // 2 sources

                {
                    AccountLockoutHistory.getInstance();
                    AccountLockoutHistory.activeSyncErrorMessage.remove(workstation);
                    AccountLockoutHistory.getInstance().fetchOwaActiveSyncHistory(map);
                    request.setAttribute("message", (Object)rb.handleGetObject("adap.AccountLockoutAction.Started_fetching_Event_Data_from", new String[]{workstation}));
                    reportInputParams.put("emptyTableMessage", (Object)rb.handleGetObject("adap.AccountLockoutAction.Started_fetching_Event_Data_from", new String[]{workstation}));
                    reportInputParams.remove("emptyTableMessage2");
                } else {
                    request.setAttribute("message", (Object)rb.handleGetObject("adap.EventDataHandler.Fetching_data_for_", new String[]{workstation}));
                    reportInputParams.put("emptyTableMessage", (Object)rb.handleGetObject("adap.EventDataHandler.Fetching_data_for_", new String[]{workstation}));
                    reportInputParams.remove("emptyTableMessage2");
                }
                AccountLockoutHistory.getInstance();
                reportInputParams.put("activeSyncStatus", AccountLockoutHistory.activeSyncStatus.get(workstation));
            }
            tableData = new HashMap<String, Object>();
            tableData.put("tableDataList", null);
            tableData.put("tableColumnList", null);
            tabMap = new HashMap<String, HashMap<String, Object>>();
            tabMap.put("tabData", tableData);
            returnListMap = new HashMap<String, V>();
            returnListMap.put("tabData", tabMap.get("tabData"));
            returnListMap.put("tabInputParams", reportInputParams);
            a = APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap));
            JsonResponse.getInstance().sendResponse(response, a);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void GPOFilePathInfo(HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject gpoInputParams = null;
            gpoInputParams = reportReqData.getJSONObject("gpoInputParams");
            String objectGUID = gpoInputParams.getString("gpoObjectGUID");
            String versionFileName = GPOUtil.getFileInfo((String)objectGUID, null, (String)"html", (boolean)false);
            HashMap map = GPODetailsAPI.getInstance().getGPODetails(objectGUID);
            String domainName = (String)map.get("DOMAIN_NAME");
            String gpoName = (String)map.get("GPO_NAME");
            gpoInputParams.put("version", (Object)versionFileName);
            gpoInputParams.put("domainName", (Object)domainName);
            gpoInputParams.put("gpoName", (Object)gpoName.toLowerCase());
            HashMap<String, JSONObject> returnListMap = new HashMap<String, JSONObject>();
            returnListMap.put("gpoInputParams", gpoInputParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getFileObjectDetails(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        JSONObject reportInputParams = null;
        reportInputParams = reportReqData.getJSONObject("inputParams");
        Properties inputParamsProp = SubReportHandler.getNavigationInfo(reportInputParams);
        String uncPath = reportInputParams.getString("uncPath");
        String domainName = reportInputParams.getString("domainName");
        String[] daclKeys = new String[]{"trustee", "permission", "aceType", "appliesTo", "isInherited"};
        String[] daclKeyStrings = new String[]{"SECURITY_PRINCIPAL", "PERMISSION", "ACE_TYPE", "APPLIES_TO", "INHERITED_ACE", "ACL"};
        String[] alKeys = new String[]{"uncPath", "owner", "size", "ct", "lat", "lwt"};
        String[] alKeyStrings = new String[]{"adap.FolderAttributes.uncPath", "adap.FolderAttributes.owner", "adap.FolderAttributes.size", "adap.FolderAttributes.ct", "adap.FolderAttributes.lat", "adap.FolderAttributes.lwt"};
        String table_SystemParams = "SystemParams";
        String col_ParamName = "PARAM_NAME";
        String col_ParamValue = "PARAM_VALUE";
        String message = "No Data Available";
        try {
            uncPath = "\\" + uncPath.split("'\\\\")[1];
            uncPath = uncPath.substring(0, uncPath.lastIndexOf("'"));
            Hashtable ht = null;
            try {
                ht = ADHandler.getFolderPermissions((String)uncPath, (String)domainName);
            }
            catch (Exception ex) {
                message = ex.getMessage();
                ex.printStackTrace();
            }
            ArrayList tabList = new ArrayList();
            String uvhString = "AUDCVConfig:cv_id:15036";
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
            ArrayList<HashMap<String, Object>> tableAllColumnList = ReportHandlerUtil.getInstance().getVisibleColumnList(cvId, true, true, true, null, null, rb);
            HashMap tabMap = new HashMap();
            Properties daclInputParams = (Properties)inputParamsProp.clone();
            daclInputParams.put("cvId", (Object)1);
            daclInputParams.put("tabId", "tabId_1_" + cvId);
            daclInputParams.put("tabIdh", "#tabId_1_" + cvId);
            daclInputParams.put("tabName", "tabName_1_" + cvId);
            daclInputParams.put("tabDisplayName", rb.getString("adap.PermissionChanges.Permission"));
            ArrayList rowList = new ArrayList();
            if (ht != null && ht.get("dacl") != null) {
                ArrayList daclList = (ArrayList)ht.get("dacl");
                for (Properties props : daclList) {
                    HashMap rowMap = new HashMap();
                    ArrayList columnList = new ArrayList();
                    HashMap<String, Object> columnMap = new HashMap<String, Object>();
                    String name = ADAPObjectCacheAPI.getInstance().getObjectNameFromSID(domainName, props.getProperty(daclKeys[0]), null);
                    columnMap.put("isData", true);
                    columnMap.put("visible", true);
                    columnMap.put("columnValue", name);
                    columnMap.put("columnalias", daclKeyStrings[0]);
                    columnList.add(columnMap);
                    StringTokenizer dst = new StringTokenizer(props.getProperty(daclKeys[1]), ",");
                    String dValue = "";
                    String dTrimValue = null;
                    while (dst.hasMoreTokens()) {
                        if ((dValue = dValue + " " + rb.getString(dst.nextToken())).length() <= 25) continue;
                        dTrimValue = dValue.substring(0, 24) + "...";
                    }
                    if (dTrimValue == null) {
                        dTrimValue = dValue;
                    }
                    HashMap<String, Object> columnMap2 = new HashMap<String, Object>();
                    columnMap2.put("isTrimText", true);
                    columnMap2.put("visible", true);
                    columnMap2.put("columnValue", dTrimValue);
                    columnMap2.put("columnalias", daclKeyStrings[1]);
                    columnMap2.put("columnHover", dValue);
                    columnList.add(columnMap2);
                    for (int c = 2; c < 5; ++c) {
                        HashMap<String, Object> columnMap3 = new HashMap<String, Object>();
                        columnMap3.put("isData", true);
                        columnMap3.put("visible", true);
                        columnMap3.put("columnValue", rb.getString(props.getProperty(daclKeys[c])));
                        columnMap3.put("columnalias", daclKeyStrings[c]);
                        columnList.add(columnMap3);
                    }
                    rowMap.put("columnValues", columnList);
                    rowList.add(rowMap);
                }
            }
            if (rowList.isEmpty()) {
                daclInputParams.put("emptyTableMessage", message);
            }
            HashMap<String, ArrayList<HashMap<Object, Object>>> tableData = new HashMap<String, ArrayList<HashMap<Object, Object>>>();
            tableData.put("tableDataList", rowList);
            tableData.put("tableColumnList", tableAllColumnList);
            tabMap.put("tabData", tableData);
            tabMap.put("tabInputParams", daclInputParams);
            tabList.add(tabMap);
            HashMap tabMap2 = new HashMap();
            Properties saclInputParams = (Properties)inputParamsProp.clone();
            saclInputParams.put("cvId", (Object)2);
            saclInputParams.put("tabId", "tabId_2_" + cvId);
            saclInputParams.put("tabName", "tabName_2_" + cvId);
            saclInputParams.put("tabIdh", "#tabId_2_" + cvId);
            saclInputParams.put("tabDisplayName", rb.getString("adap_common.auditing"));
            ArrayList rowList2 = new ArrayList();
            if (ht != null && ht.get("sacl") != null) {
                ArrayList saclList = (ArrayList)ht.get("sacl");
                for (Object obj : saclList) {
                    Properties props = (Properties)obj;
                    HashMap rowMap2 = new HashMap();
                    ArrayList columnList2 = new ArrayList();
                    HashMap<String, Object> columnMap = new HashMap<String, Object>();
                    String name = ADAPObjectCacheAPI.getInstance().getObjectNameFromSID(domainName, props.getProperty(daclKeys[0]), null);
                    columnMap.put("isData", true);
                    columnMap.put("visible", true);
                    columnMap.put("columnValue", name);
                    columnMap.put("columnalias", daclKeyStrings[0]);
                    columnList2.add(columnMap);
                    StringTokenizer dst = new StringTokenizer(props.getProperty(daclKeys[1]), ",");
                    String dValue = "";
                    String dTrimValue = null;
                    while (dst.hasMoreTokens()) {
                        if ((dValue = dValue + " " + rb.getString(dst.nextToken())).length() <= 25) continue;
                        dTrimValue = dValue.substring(0, 24) + "...";
                    }
                    if (dTrimValue == null) {
                        dTrimValue = dValue;
                    }
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("isTrimText", true);
                    hashMap.put("visible", true);
                    hashMap.put("columnValue", dTrimValue);
                    hashMap.put("columnHover", dValue);
                    hashMap.put("columnalias", daclKeyStrings[1]);
                    columnList2.add(hashMap);
                    for (int c = 2; c < 5; ++c) {
                        HashMap<String, Object> columnMap3 = new HashMap<String, Object>();
                        columnMap3.put("isData", true);
                        columnMap3.put("visible", true);
                        columnMap3.put("columnValue", rb.getString(props.getProperty(daclKeys[c])));
                        columnMap3.put("columnalias", daclKeyStrings[c]);
                        columnList2.add(columnMap3);
                    }
                    rowMap2.put("columnValues", columnList2);
                    rowList2.add(rowMap2);
                }
            }
            if (rowList2.isEmpty()) {
                saclInputParams.put("emptyTableMessage", message);
            }
            HashMap<String, ArrayList<HashMap<Object, Object>>> tableData2 = new HashMap<String, ArrayList<HashMap<Object, Object>>>();
            tableData2.put("tableDataList", rowList2);
            tableData2.put("tableColumnList", tableAllColumnList);
            tabMap2.put("tabData", tableData2);
            tabMap2.put("tabInputParams", saclInputParams);
            tabList.add(tabMap2);
            String uvhString2 = "AUDCVConfig:cv_id:15035";
            Long cvId2 = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString2);
            HashMap tabMap3 = new HashMap();
            ArrayList rowList3 = new ArrayList();
            Properties genInputParams = (Properties)inputParamsProp.clone();
            genInputParams.put("cvId", cvId2);
            genInputParams.put("tabId", "tabId_" + cvId2);
            genInputParams.put("tabIdh", "#tabId_" + cvId2);
            genInputParams.put("tabName", "tabName_" + cvId2);
            genInputParams.put("tabDisplayName", rb.getString("adap.FolderAttributes.General"));
            ArrayList<HashMap<String, Object>> tableAllColumnList2 = ReportHandlerUtil.getInstance().getVisibleColumnList(cvId2, true, true, true, null, null, rb);
            if (ht != null && ht.get("dacl") != null) {
                block16: for (int c = 0; c < 6; ++c) {
                    HashMap rowMap2 = new HashMap();
                    ArrayList columnList2 = new ArrayList();
                    String key = rb.getString(alKeyStrings[c]);
                    Object v = ht.get(alKeys[c]);
                    switch (c) {
                        case 0: {
                            String uncPath1 = (String)v;
                            if (uncPath1.length() > 25) {
                                uncPath1 = uncPath1.substring(0, 24) + "...";
                            }
                            HashMap<String, Object> columnMap = new HashMap<String, Object>();
                            columnMap.put("isData", true);
                            columnMap.put("visible", true);
                            columnMap.put("columnValue", key);
                            columnMap.put("columnalias", "NAME");
                            HashMap<String, Object> columnMap1 = new HashMap<String, Object>();
                            columnMap1.put("isTrimText", true);
                            columnMap1.put("visible", true);
                            columnMap1.put("columnValue", uncPath1);
                            columnMap1.put("columnHover", v);
                            columnMap1.put("columnalias", "VALUE");
                            columnList2.add(columnMap);
                            columnList2.add(columnMap1);
                            break;
                        }
                        case 1: {
                            String sidString = (String)v;
                            String string = ADAPObjectCacheAPI.getInstance().getObjectNameFromSID(domainName, sidString, null);
                            HashMap<String, Object> columnMap2 = new HashMap<String, Object>();
                            columnMap2.put("isData", true);
                            columnMap2.put("visible", true);
                            columnMap2.put("columnValue", key);
                            columnMap2.put("columnalias", "NAME");
                            HashMap<String, Object> columnMap3 = new HashMap<String, Object>();
                            columnMap3.put("isData", true);
                            columnMap3.put("visible", true);
                            columnMap3.put("columnValue", string);
                            columnMap3.put("columnalias", "VALUE");
                            columnList2.add(columnMap2);
                            columnList2.add(columnMap3);
                            break;
                        }
                        case 2: {
                            Double fSize = Double.parseDouble((String)v);
                            String[] sparr = uncPath.split("\\\\");
                            if (!sparr[sparr.length - 1].contains(".")) continue block16;
                            fSize = fSize / 1024.0;
                            String string = String.format("%.3f", fSize) + " KB (" + ht.get(alKeys[c]) + " bytes)";
                            HashMap<String, Object> columnMap4 = new HashMap<String, Object>();
                            columnMap4.put("isData", true);
                            columnMap4.put("visible", true);
                            columnMap4.put("columnValue", key);
                            columnMap4.put("columnalias", "NAME");
                            HashMap<String, Object> columnMap5 = new HashMap<String, Object>();
                            columnMap5.put("isData", true);
                            columnMap5.put("visible", true);
                            columnMap5.put("columnValue", string);
                            columnMap5.put("columnalias", "VALUE");
                            columnList2.add(columnMap4);
                            columnList2.add(columnMap5);
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            String dateFormat = "";
                            DataObject dateFormatDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get(table_SystemParams, new Criteria(Column.getColumn((String)table_SystemParams, (String)col_ParamName), (Object)"DATE_FORMAT", 0));
                            dateFormat = !dateFormatDO.isEmpty() ? (String)dateFormatDO.getFirstRow(table_SystemParams).get(col_ParamValue) + " , " : "yyyy-MM-dd ";
                            dateFormatDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get(table_SystemParams, new Criteria(Column.getColumn((String)table_SystemParams, (String)col_ParamName), (Object)"TIME_FORMAT", 0));
                            dateFormat = !dateFormatDO.isEmpty() ? dateFormat + (String)dateFormatDO.getFirstRow(table_SystemParams).get(col_ParamValue) : dateFormat + "HH:mm:ss ";
                            dateFormatDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get(table_SystemParams, new Criteria(Column.getColumn((String)table_SystemParams, (String)col_ParamName), (Object)"TIMEZONE_ID", 0));
                            SimpleDateFormat sdfDate = new SimpleDateFormat(dateFormat);
                            if (!dateFormatDO.isEmpty()) {
                                sdfDate.setTimeZone(TimeZone.getTimeZone((String)dateFormatDO.getFirstRow(table_SystemParams).get(col_ParamValue)));
                            } else {
                                sdfDate.setTimeZone(TimeZone.getTimeZone("GMT"));
                            }
                            Date d1 = new Date(Long.parseLong((String)v) * 1000L);
                            String string = sdfDate.format(d1);
                            HashMap<String, Object> columnMap6 = new HashMap<String, Object>();
                            columnMap6.put("isData", true);
                            columnMap6.put("visible", true);
                            columnMap6.put("columnValue", key);
                            columnMap6.put("columnalias", "NAME");
                            HashMap<String, Object> columnMap7 = new HashMap<String, Object>();
                            columnMap7.put("isData", true);
                            columnMap7.put("visible", true);
                            columnMap7.put("columnValue", string);
                            columnMap7.put("columnalias", "VALUE");
                            columnList2.add(columnMap6);
                            columnList2.add(columnMap7);
                        }
                    }
                    rowMap2.put("columnValues", columnList2);
                    rowList3.add(rowMap2);
                }
            }
            if (rowList3.isEmpty()) {
                genInputParams.put("emptyTableMessage", message);
            }
            HashMap<String, ArrayList<HashMap<Object, Object>>> tableData3 = new HashMap<String, ArrayList<HashMap<Object, Object>>>();
            tableData3.put("tableDataList", rowList3);
            tableData3.put("tableColumnList", tableAllColumnList2);
            tabMap3.put("tabData", tableData3);
            tabMap3.put("tabInputParams", genInputParams);
            tabList.add(tabMap3);
            HashMap returnListMap = new HashMap();
            returnListMap.put("subReportList", tabList);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList<HashMap<String, Object>> getLockoutTableData(HashMap<String, String> map, ArrayList<HashMap<String, Object>> tableAllColumnList, String computerName, AdventNetResourceBundle rb) throws Exception {
        ArrayList<HashMap<String, Object>> rowList = new ArrayList<HashMap<String, Object>>();
        try {
            if (!map.isEmpty()) {
                int i = 0;
                for (String key : map.keySet()) {
                    ArrayList colList = new ArrayList();
                    HashMap rowMap = new HashMap();
                    String dataList = map.get(AccountLockoutUtil.COMPONENT_NAME[i]);
                    for (int j = 0; j < tableAllColumnList.size(); ++j) {
                        HashMap<String, Object> columnMap = new HashMap<String, Object>();
                        HashMap<String, Object> colConfigMap = tableAllColumnList.get(j);
                        if (colConfigMap.get("columnalias").equals("COMPONENT_NAME")) {
                            String rowValue = rb.getString(AccountLockoutUtil.COMPONENT_NAME[i]);
                            columnMap.put("isData", true);
                            columnMap.put("visible", true);
                            columnMap.put("columnValue", rowValue);
                            columnMap.put("analyzeName", rowValue);
                            columnMap.put("columnalias", colConfigMap.get("columnalias"));
                            columnMap.put(colConfigMap.get("columnalias").toString(), rowValue);
                        } else if (colConfigMap.get("columnalias").equals("COMPUTER_NAME")) {
                            columnMap.put("isData", true);
                            columnMap.put("visible", true);
                            columnMap.put("columnValue", computerName);
                            columnMap.put("columnalias", colConfigMap.get("columnalias"));
                            columnMap.put(colConfigMap.get("columnalias").toString(), computerName);
                        } else if (colConfigMap.get("columnalias").equals("RESULTS")) {
                            columnMap.put("isData", true);
                            columnMap.put("visible", true);
                            columnMap.put("columnValue", dataList);
                            columnMap.put("columnalias", colConfigMap.get("columnalias"));
                            columnMap.put(colConfigMap.get("columnalias").toString(), dataList);
                        }
                        colList.add(columnMap);
                    }
                    ++i;
                    rowMap.put("columnValues", colList);
                    rowList.add(rowMap);
                }
            } else {
                for (int i = 0; i < AccountLockoutUtil.COMPONENT_NAME.length; ++i) {
                    ArrayList colList = new ArrayList();
                    HashMap rowMap = new HashMap();
                    for (int j = 0; j < tableAllColumnList.size(); ++j) {
                        HashMap<String, Object> columnMap = new HashMap<String, Object>();
                        HashMap<String, Object> colConfigMap = tableAllColumnList.get(j);
                        if (colConfigMap.get("columnalias").equals("COMPONENT_NAME")) {
                            String rowValue = rb.getString(AccountLockoutUtil.COMPONENT_NAME[i]);
                            columnMap.put("isData", true);
                            columnMap.put("visible", true);
                            columnMap.put("columnValue", rowValue);
                            columnMap.put("columnalias", colConfigMap.get("columnalias"));
                            columnMap.put(colConfigMap.get("columnalias").toString(), rowValue);
                        } else if (colConfigMap.get("columnalias").equals("COMPUTER_NAME")) {
                            columnMap.put("isData", true);
                            columnMap.put("visible", true);
                            columnMap.put("columnValue", computerName);
                            columnMap.put("columnalias", colConfigMap.get("columnalias"));
                            columnMap.put(colConfigMap.get("columnalias").toString(), computerName);
                        } else if (colConfigMap.get("columnalias").equals("RESULTS")) {
                            columnMap.put("isData", true);
                            columnMap.put("visible", true);
                            columnMap.put("columnValue", "Fetching data");
                            columnMap.put("columnalias", colConfigMap.get("columnalias"));
                            columnMap.put(colConfigMap.get("columnalias").toString(), "Fetching Data");
                        }
                        colList.add(columnMap);
                    }
                    rowMap.put("columnValues", colList);
                    rowList.add(rowMap);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rowList;
    }

    public void getLockoutDetailsTabList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject reportInputParams = null;
            reportInputParams = reportReqData.getJSONObject("inputParams");
            String userName = reportInputParams.getString("userName");
            HashMap returnListMap = new HashMap();
            returnListMap.put("tableDataList", new ArrayList());
            returnListMap.put("tableColumnList", new ArrayList());
            reportInputParams.put("cvId", 1);
            reportInputParams.put("tabId", (Object)"tabId_1");
            reportInputParams.put("tabIdh", (Object)"#tabId_1");
            reportInputParams.put("tabName", (Object)"tabName_1");
            reportInputParams.put("tabDisplayName", (Object)("Lockout Analyzer for User:" + userName));
            reportInputParams.put("showRefresh", true);
            reportInputParams.put("analyzer", true);
            reportInputParams.put("showHelp", true);
            ArrayList tabList = new ArrayList();
            HashMap<String, HashMap<String, ArrayList<Object>>> tabMap = new HashMap<String, HashMap<String, ArrayList<Object>>>();
            tabMap.put("tabData", returnListMap);
            tabMap.put("tabInputParams", (HashMap<String, ArrayList<Object>>)reportInputParams);
            tabList.add(tabMap);
            ArrayList<HashMap<String, Object>> tabList1 = this.getHistoryTabList(request, response, "b", false);
            for (int i = 0; i < tabList1.size(); ++i) {
                tabList.add(tabList1.get(i));
            }
            HashMap subReportListMap = new HashMap();
            subReportListMap.put("subReportList", tabList);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(subReportListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void getLockoutDetails(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject reportInputParams = null;
            reportInputParams = reportReqData.getJSONObject("inputParams");
            String uniqueId = reportInputParams.getString("uniqueId");
            String computerName = reportInputParams.getString("computerName");
            String userName = reportInputParams.getString("userName");
            Boolean retry = reportInputParams.getBoolean("retry");
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"NAME"), (Object)computerName, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DOMAIN_NAME"), (Object)reportInputParams.getString("domainName"), 0));
            DataObject d = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMComputerGeneralDetails", criteria);
            boolean flag = false;
            if (d.isEmpty()) {
                reportInputParams.put("emptyTableMessage", (Object)(rb.getString("adap.HistoryDetails.not_part_of_domain") + "(Caller Machine Name: " + computerName + ")"));
                retry = true;
                flag = true;
            } else {
                Row row = d.getFirstRow("ADSMComputerGeneralDetails");
                String os = (String)row.get("OPERATING_SYSTEM");
                if (os == null || !os.toLowerCase().contains("windows")) {
                    reportInputParams.put("emptyTableMessage", (Object)(rb.getString("adap.LockoutDetails.Not_windows_os") + "(Caller Machine Name: " + computerName + ")"));
                    retry = true;
                    flag = true;
                }
            }
            HashMap<String, String> map = null;
            map = retry == false ? AccountLockoutUtil.getInstance().getFromDBEmber(uniqueId) : new HashMap<String, String>();
            String uvhString = "AUDCVConfig:cv_id:15037";
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDTableViewConfig", (String)"CV_ID"), (Object)cvId, 0);
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDTableViewConfig", crit);
            HashMap<String, String> tableDetails = new HashMap<String, String>();
            if (!dob.isEmpty()) {
                Row r = dob.getFirstRow("AUDTableViewConfig");
                List al = r.getColumns();
                for (int i = 0; i < al.size(); ++i) {
                    String key = String.valueOf(al.get(i));
                    String value = String.valueOf(r.get((String)al.get(i)));
                    tableDetails.put(key, value);
                }
            }
            ArrayList<HashMap<String, Object>> tableAllColumnList = ReportHandlerUtil.getInstance().getVisibleColumnList(cvId, true, true, true, null, null, rb);
            ArrayList<Object> reportList = new ArrayList();
            if (!flag) {
                reportList = this.getLockoutTableData(map, tableAllColumnList, computerName, rb);
            }
            HashMap returnListMap = new HashMap();
            returnListMap.put("tableDataList", reportList);
            returnListMap.put("tableColumnList", tableAllColumnList);
            reportInputParams.put("cvId", 1);
            reportInputParams.put("tabId", (Object)"tabId_1");
            reportInputParams.put("tabIdh", (Object)"#tabId_1");
            reportInputParams.put("tabName", (Object)"tabName_1");
            reportInputParams.put("tabDisplayName", (Object)("Lockout Analyzer for User:" + userName));
            reportInputParams.put("showRefresh", true);
            reportInputParams.put("analyzer", true);
            reportInputParams.put("showHelp", true);
            ArrayList tabList = new ArrayList();
            HashMap<String, HashMap<String, ArrayList<Object>>> tabMap = new HashMap<String, HashMap<String, ArrayList<Object>>>();
            tabMap.put("tabData", returnListMap);
            tabMap.put("tabInputParams", (HashMap<String, ArrayList<Object>>)reportInputParams);
            tabList.add(tabMap);
            ArrayList<HashMap<String, Object>> tabList1 = this.getHistoryTabList(request, response, "b", true);
            for (int i = 0; i < tabList1.size(); ++i) {
                tabList.add(tabList1.get(i));
            }
            HashMap<String, Serializable> subReportListMap = new HashMap<String, Serializable>();
            subReportListMap.put("subReportList", tabList);
            if (map.isEmpty() && !flag) {
                subReportListMap.put("dataIsEmpty", Boolean.valueOf(true));
            } else {
                subReportListMap.put("dataIsEmpty", Boolean.valueOf(false));
            }
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(subReportListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void getLockoutDetailsFromNative(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject reportInputParams = null;
            reportInputParams = reportReqData.getJSONObject("inputParams");
            String uniqueId = reportInputParams.getString("uniqueId");
            String computerName = reportInputParams.getString("computerName");
            String userName = reportInputParams.getString("userName");
            String domainName = reportInputParams.getString("domainName");
            String analyzeName = reportInputParams.getString("analyzeName");
            HashMap resultMap = ADHandler.getComponentList((String)domainName, (String)userName, (String)computerName, (String)analyzeName);
            AccountLockoutUtil.getInstance();
            HashMap map = AccountLockoutUtil.getUIStringEmber((String)domainName, (HashMap)resultMap, (String)analyzeName);
            if (!resultMap.containsKey("errorMessage")) {
                AccountLockoutUtil.getInstance().addInDBEmber(resultMap, domainName, uniqueId);
            }
            HashMap<String, Object> subReportListMap = new HashMap<String, Object>();
            subReportListMap.put("analyzeName", analyzeName);
            subReportListMap.put("analyzeValue", map.get("resultString"));
            subReportListMap.put("index", reportInputParams.get("index"));
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(subReportListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void getLogonDuration(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject jsnObject = reportReqData.getJSONObject("inputParams");
            String userName = "";
            String sourceName = "";
            Iterator it = jsnObject.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (key.equalsIgnoreCase("userName")) {
                    userName = jsnObject.get(key).toString();
                    continue;
                }
                if (!key.equalsIgnoreCase("sourceName")) continue;
                sourceName = jsnObject.get(key).toString();
            }
            ArrayList list = UserActivityUtil.getInstance().getSubReportList(userName, sourceName);
            HashMap returnListMap = new HashMap();
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void getLogonSubReports(HttpServletRequest request, HttpServletResponse response) {
        try {
            String userName = "";
            String sourceName = "";
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject jsnObject = reportReqData.getJSONObject("inputParams");
            Iterator it = jsnObject.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (key.equalsIgnoreCase("userName")) {
                    userName = jsnObject.get(key).toString();
                    continue;
                }
                if (!key.equalsIgnoreCase("sourceName")) continue;
                sourceName = jsnObject.get(key).toString();
            }
            ArrayList list = UserActivityUtil.getInstance().getSubReportList(userName, sourceName);
            ArrayList rowList = new ArrayList();
            String[] columnKey = new String[]{"LOCKTIME", "UNLOCKTIME", "DURATION", "STATUS"};
            for (HashMap rowMap : list) {
                HashMap cloneRowMap = (HashMap)rowMap.clone();
                HashMap columnValsMap = new HashMap();
                ArrayList rowValList = new ArrayList();
                for (String keyName : columnKey) {
                    HashMap rowValMap = new HashMap();
                    Object columnValue = cloneRowMap.get(keyName);
                    rowValMap.put("columnValue", columnValue);
                    rowValMap.put("isData", true);
                    rowValMap.put("visible", true);
                    rowValMap.put("columnalias", keyName);
                    rowValList.add(rowValMap);
                }
                columnValsMap.put("columnValues", rowValList);
                rowList.add(columnValsMap);
            }
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:15052");
            ArrayList<HashMap<String, Object>> columnList = ReportHandlerUtil.getInstance().getVisibleColumnList(cvId, true, true, true, null, null, rb);
            jsnObject.put("cvId", (Object)cvId);
            jsnObject.put("tabId", (Object)("tabId_" + cvId));
            jsnObject.put("tabIdh", (Object)("#tabId_" + cvId));
            jsnObject.put("tabName", (Object)("tabName_" + cvId));
            jsnObject.put("tabDisplayName", (Object)rb.getString("adap.AUDReports.title.User_Active_Idle_Time"));
            ArrayList tabList = new ArrayList();
            HashMap tabMap = new HashMap();
            HashMap<String, ArrayList<HashMap<Object, Object>>> map = new HashMap<String, ArrayList<HashMap<Object, Object>>>();
            map.put("tableDataList", rowList);
            map.put("tableColumnList", columnList);
            tabMap.put("tabData", map);
            tabMap.put("tabInputParams", jsnObject);
            tabList.add(tabMap);
            HashMap subReportListMap = new HashMap();
            subReportListMap.put("subReportList", tabList);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(subReportListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

