/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.serveraudit;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.fileintegrity.FIMConstants;
import com.adventnet.sym.adsm.auditing.server.fileintegrity.FileIntegrityManager;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.common.EmberTableConfig;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.serveraudit.ServerConfigHandler;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.APIUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.JSONUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class FIMConfigHandler
implements FIMConstants {
    private static volatile FIMConfigHandler instance = null;
    private static final Logger REPORT_LOGGER = Logger.getLogger("ReportLogger");
    private static final FileIntegrityManager FILE_INTEGRITY_MANAGER = FileIntegrityManager.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FIMConfigHandler getInstance() {
        if (instance != null) return instance;
        Class<FIMConfigHandler> clazz = FIMConfigHandler.class;
        synchronized (FIMConfigHandler.class) {
            if (instance != null) return instance;
            instance = new FIMConfigHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private FIMConfigHandler() {
    }

    public void updateFIMDomains(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String msgTxt = null;
        String msgType = "success";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject serverInputParams = null;
            serverInputParams = reportReqData.getJSONObject("inputParams");
            ArrayList objectGuidList = null;
            objectGuidList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)serverInputParams.optJSONArray("selectedObjectIdList"));
            if (serverInputParams.getString("action").equalsIgnoreCase("delete")) {
                long uniqueId = Long.parseLong(objectGuidList.get(0).toString());
                Boolean result = FILE_INTEGRITY_MANAGER.deleteWithUniqueId(Long.valueOf(uniqueId), "AUDFIMDomainConfiguration");
                if (result.booleanValue()) {
                    msgTxt = rb.getString("adap_ServerConfig_domain_deleted_from_fim");
                }
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "File Integrity", rb.handleGetObject("adap.ConfigureFileIntegrity.audit_entry.Domain_deleted_from_FIM", new String[]{serverInputParams.getString("domainName")}), 16, 8, "adap.ADAPUserAuditSeverities.audit_name.deleted_FIM_Domain", "-"}));
            } else {
                long uniqueId = Long.parseLong(objectGuidList.get(0).toString());
                String action = serverInputParams.getString("action");
                int isEnabled = 0;
                String message = rb.handleGetObject("adap.ConfigureFileIntegrity.audit_entry.domain_disabled_for_FIM", new String[]{serverInputParams.getString("domainName")});
                if (action.equalsIgnoreCase("enable")) {
                    isEnabled = 1;
                    message = rb.handleGetObject("adap.ConfigureFileIntegrity.audit_entry.domain_enabled_for_FIM", new String[]{serverInputParams.getString("domainName")});
                }
                Boolean result = FILE_INTEGRITY_MANAGER.changeDomainStatusInFIM(Long.valueOf(uniqueId), isEnabled);
                if (action.equalsIgnoreCase("enable")) {
                    if (result.booleanValue()) {
                        msgTxt = rb.getString("adap_ServerConfig_domain_enabled_for_fim");
                    } else {
                        msgTxt = rb.getString("adap_ServerConfig_error_domain_enabled_for_fim");
                        msgType = "failure";
                    }
                } else if (result.booleanValue()) {
                    msgTxt = rb.getString("adap_ServerConfig_domain_disabled_for_fim");
                } else {
                    msgTxt = rb.getString("adap_ServerConfig_error_domain_disabled_for_fim");
                    msgType = "failure";
                }
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Integrity", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.updated_FIM", "-"}));
            }
            FILE_INTEGRITY_MANAGER.setFimEnabledDomainList();
            this.getServers(request, response, msgTxt, msgType);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void getServers(HttpServletRequest request, HttpServletResponse response, String msgTxt, String msgType) throws Exception {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject serverInputParams = null;
            serverInputParams = reportReqData.getJSONObject("inputParams");
            String uvhString = "AUDCVConfig:cv_id:15015";
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDTableViewConfig", (String)"CV_ID"), (Object)cvId, 0);
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDTableViewConfig", crit);
            HashMap<String, String> tableDetails = new HashMap<String, String>();
            if (!dob.isEmpty()) {
                Row r = dob.getFirstRow("AUDTableViewConfig");
                List al = r.getColumns();
                for (int i = 0; i < al.size(); ++i) {
                    String key = String.valueOf(al.get(i));
                    String value = String.valueOf(r.get((String)al.get(i)));
                    tableDetails.put(key, value);
                }
            }
            Long tableId = Long.parseLong((String)tableDetails.get("TABLE_VIEW_ID"));
            if (!serverInputParams.has("sortColumn")) {
                serverInputParams.put("sortColumn", tableDetails.get("SORTCOLUMN"));
                serverInputParams.put("sortOrder", tableDetails.get("SORTORDER"));
                serverInputParams.put("sortTableName", (Object)"ADSMComputerGeneralDetails");
            }
            ArrayList<HashMap<String, Object>> tableAllColumnList = ServerConfigHandler.getInstance().getVisibleColumnList(cvId, true, true, true, null, null, rb);
            serverInputParams.put("showDomainFilter", false);
            serverInputParams.put("showAuditPolicyFilter", false);
            serverInputParams.put("pageHeaderText", (Object)"FIM Configuration");
            serverInputParams.put("tabHeaderText", (Object)"FIM Configured Domains");
            serverInputParams.put("addServerTxt", (Object)rb.getString("adap.domain_settings.view_domain.text.add_domain"));
            ArrayList<Object> reportsList = new ArrayList();
            reportsList = this.getConfiguredDomainList(rb);
            int count = reportsList.size();
            HashMap<String, Object> returnListMap = new HashMap<String, Object>();
            serverInputParams.put("totalCount", count);
            if (count == 0) {
                serverInputParams.put("emptyTableMessage", (Object)rb.getString("adap_ServerConfig.fim_not_configured_for_available_domain"));
                serverInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                serverInputParams.put("emptyTableMessage2", (Object)rb.getString("adap_ServerConfig.click_here_to_configure"));
            }
            if (msgTxt != null) {
                serverInputParams.put("message", (Object)msgTxt);
                serverInputParams.put("type", (Object)msgType);
            }
            JSONObject resultObj = EmberTableConfig.getInstance().getEmberTableData1(tableId, reportsList, tableAllColumnList, serverInputParams, rb);
            JSONObject tableData = resultObj.getJSONObject("tableData");
            returnListMap.put("serverData", tableData.get("tableDataList"));
            returnListMap.put("serverColumnList", tableAllColumnList);
            returnListMap.put("serverInputParams", serverInputParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ArrayList<HashMap<String, Object>> getConfiguredDomainList(AdventNetResourceBundle rb) {
        Hashtable configuredDomainProps = new Hashtable();
        ArrayList<HashMap<String, Object>> rowList = new ArrayList<HashMap<String, Object>>();
        try {
            Column col = Column.getColumn((String)"AUDFIMDomainConfiguration", (String)"UNIQUE_ID");
            Criteria criteria = new Criteria(col, null, 1);
            DataObject defaultDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDFIMDomainConfiguration", criteria);
            if (defaultDO.isEmpty()) {
                boolean a = false;
            } else {
                int rowCount = defaultDO.size("AUDFIMDomainConfiguration");
                Iterator iterator = defaultDO.getRows("AUDFIMDomainConfiguration");
                for (int i = 0; i < rowCount; ++i) {
                    HashMap<String, Object> colMap = new HashMap<String, Object>();
                    Row row = (Row)iterator.next();
                    ArrayList<Object> props = new ArrayList<Object>();
                    props.add(row.get("IS_CONFIGURED"));
                    colMap.put("IS_CONFIGURED", row.get("IS_CONFIGURED"));
                    String domainName = (String)row.get("DOMAIN_NAME");
                    props.add(domainName);
                    colMap.put("DOMAIN_NAME", domainName);
                    Hashtable fimEnabledOn = FileIntegrityManager.getInstance().getFimEnabledMachineTypes(domainName);
                    Hashtable serverProps = (Hashtable)fimEnabledOn.get(MACHINE_TYPES_STRING[0]);
                    Integer isFimEnabled = (Integer)serverProps.get("IS_SELECTED");
                    int[] dcCount = FileIntegrityManager.getInstance().getConfiguredDCCount(domainName, "");
                    if (isFimEnabled == 0) {
                        props.add(rb.getString("adap.common.text.filter_link.disabled"));
                        colMap.put("DOMAIN_CONTROLLERS", rb.getString("adap.common.text.filter_link.disabled"));
                    } else {
                        props.add(dcCount[1] + " " + rb.getString("adap.configureFIM.Out_Of") + " " + dcCount[0]);
                        colMap.put("DOMAIN_CONTROLLERS", dcCount[1] + " " + rb.getString("adap.configureFIM.Out_Of") + " " + dcCount[0]);
                    }
                    serverProps = (Hashtable)fimEnabledOn.get(MACHINE_TYPES_STRING[1]);
                    isFimEnabled = (Integer)serverProps.get("IS_SELECTED");
                    int[] msCount = FileIntegrityManager.getInstance().getConfiguredMemberServersCount(domainName, "");
                    if (isFimEnabled == 0) {
                        props.add(rb.getString("adap.common.text.filter_link.disabled"));
                        colMap.put("MEMBER_SERVERS", rb.getString("adap.common.text.filter_link.disabled"));
                    } else {
                        props.add(msCount[1] + " " + rb.getString("adap.configureFIM.Out_Of") + " " + msCount[0]);
                        colMap.put("MEMBER_SERVERS", msCount[1] + " " + rb.getString("adap.configureFIM.Out_Of") + " " + msCount[0]);
                    }
                    props.add(rb.getString((String)row.get("GPO_CREATION")));
                    colMap.put("GPO_CREATION", rb.getString((String)row.get("GPO_CREATION")));
                    colMap.put("UNIQUE_ID", row.get("UNIQUE_ID"));
                    rowList.add(colMap);
                    configuredDomainProps.put((Long)row.get("UNIQUE_ID"), props);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rowList;
    }

    public void viewFIMConfiguredDomains(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Hashtable configuredDomainProps = FILE_INTEGRITY_MANAGER.getConfiguredDomainList();
        JSONObject resultantJson = new JSONObject();
        resultantJson.put("configuredDomain", (Object)configuredDomainProps);
        JsonResponse.getInstance().sendResponse(response, resultantJson.toString());
    }

    public void addNewDomain(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        ArrayList domainList = DomainHandler.getConfiguredList((Long)loginId);
        Hashtable configuredDomainProps = FILE_INTEGRITY_MANAGER.getConfiguredDomainList();
        ArrayList<String> fimConfiguredDomains = new ArrayList<String>();
        Enumeration keys = configuredDomainProps.keys();
        while (keys.hasMoreElements()) {
            Long key = (Long)keys.nextElement();
            ArrayList props = (ArrayList)configuredDomainProps.get(key);
            fimConfiguredDomains.add((String)props.get(1));
        }
        ArrayList<String> fimUnConfiguredDomains = new ArrayList<String>();
        String[] domainNames = new String[domainList.size()];
        for (int i = 0; i < domainList.size(); ++i) {
            Properties domainProp = (Properties)domainList.get(i);
            domainNames[i] = domainProp.getProperty("DOMAIN_NAME");
            if (fimConfiguredDomains.contains(domainNames[i])) continue;
            fimUnConfiguredDomains.add(domainNames[i]);
        }
        JSONArray fimUnConfiguredDomainsArray = new JSONArray();
        JSONObject resultantJson = new JSONObject();
        fimUnConfiguredDomainsArray = APIUtil.getInstance().listToJSONArray(fimUnConfiguredDomains);
        resultantJson.put("domainList", (Object)fimUnConfiguredDomainsArray);
        if (!fimUnConfiguredDomains.isEmpty()) {
            resultantJson.put("selectedDomain", fimUnConfiguredDomains.get(0));
        } else {
            response.sendError(52);
        }
        JsonResponse.getInstance().sendResponse(response, resultantJson.toString());
    }

    public void viewFIMDomainBasedConf(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String domainName = request.getParameter("domainName");
        Hashtable fileConfTable = FILE_INTEGRITY_MANAGER.getConfiguration(domainName, "File");
        Hashtable folderConfTable = FILE_INTEGRITY_MANAGER.getConfiguration(domainName, "Folder");
        this.addKeyInHashtableToValue(fileConfTable, "UNIQUE_KEY");
        this.addKeyInHashtableToValue(folderConfTable, "UNIQUE_KEY");
        ArrayList fileConfList = new ArrayList(fileConfTable.values());
        ArrayList folderConfList = new ArrayList(folderConfTable.values());
        HashMap<Object, Object> fimEnabledOnMap = new HashMap<Object, Object>(FILE_INTEGRITY_MANAGER.getFimEnabledMachineTypes(domainName));
        JSONObject fimEnabledOn = APIUtil.getInstance().mapToJSONObject(fimEnabledOnMap);
        JSONArray folderConf = APIUtil.getInstance().listToJSONArray(folderConfList);
        JSONArray fileConf = APIUtil.getInstance().listToJSONArray(fileConfList);
        JSONObject resultantJson = new JSONObject();
        resultantJson.put("folderConf", (Object)folderConf);
        resultantJson.put("fileConf", (Object)fileConf);
        resultantJson.put("fimEnabledOn", (Object)fimEnabledOn);
        resultantJson.put("selectedDomain", (Object)domainName);
        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "File Integrity", rb.handleGetObject("adap.ConfigureFileIntegrity.audit_entry.FIM_Configuration_viewd", new String[]{domainName}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.view_FIM", "-"}));
        JsonResponse.getInstance().sendResponse(response, resultantJson.toString());
    }

    private void addKeyInHashtableToValue(Hashtable table, String keyName) {
        try {
            Enumeration enumKey = table.keys();
            while (enumKey.hasMoreElements()) {
                Long key = (Long)enumKey.nextElement();
                Hashtable valTable = (Hashtable)table.get(key);
                valTable.put(keyName, key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createFIMConfiguration(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        JSONObject jsonObj = new JSONObject(request.getParameter("FIMparams"));
        JSONObject resultantJson = new JSONObject();
        String domainName = jsonObj.getString("domainName");
        JSONObject fileMapJSON = jsonObj.getJSONObject("fileMap");
        JSONObject folderMapJSON = jsonObj.getJSONObject("folderMap");
        JSONObject fimEnabledOnMapJSON = jsonObj.getJSONObject("fimEnabledOnMap");
        JSONObject changedMSSelection = jsonObj.getJSONObject("changedMSSelection");
        JSONObject changedDCSelection = jsonObj.getJSONObject("changedDCSelection");
        JSONObject newFileTypes = jsonObj.getJSONObject("newFileTypes");
        JSONObject newFolders = jsonObj.getJSONObject("newFolders");
        String deletedFileTypes = jsonObj.getString("deletedFileTypes");
        String deletedFolders = jsonObj.getString("deletedFolders");
        StringTokenizer deletedList = new StringTokenizer(deletedFileTypes, ",");
        while (deletedList.hasMoreTokens()) {
            FILE_INTEGRITY_MANAGER.deleteWithUniqueId(Long.valueOf(deletedList.nextToken()), "AUDFIMFileConf");
            FILE_INTEGRITY_MANAGER.setConfiguredList("AUDFIMFileConf");
        }
        deletedList = new StringTokenizer(deletedFolders, ",");
        while (deletedList.hasMoreTokens()) {
            FILE_INTEGRITY_MANAGER.deleteWithUniqueId(Long.valueOf(deletedList.nextToken()), "AUDFIMFolderConf");
            FILE_INTEGRITY_MANAGER.setConfiguredList("AUDFIMFolderConf");
        }
        FILE_INTEGRITY_MANAGER.insertOrUpdateFimDomainConfTable(domainName, "adap.common.text.status_msg.success", Integer.valueOf(1));
        if (folderMapJSON.length() != 0) {
            FILE_INTEGRITY_MANAGER.setConfiguration(domainName, folderMapJSON, "AUDFIMFolderConf");
            FILE_INTEGRITY_MANAGER.setConfiguredList("AUDFIMFolderConf");
            REPORT_LOGGER.log(Level.INFO, "FIM->folderMap" + folderMapJSON);
        }
        if (fileMapJSON.length() != 0) {
            FILE_INTEGRITY_MANAGER.setConfiguration(domainName, fileMapJSON, "AUDFIMFileConf");
            FILE_INTEGRITY_MANAGER.setConfiguredList("AUDFIMFileConf");
            REPORT_LOGGER.log(Level.INFO, "FIM->fileMap" + fileMapJSON);
        }
        if (fimEnabledOnMapJSON.length() != 0) {
            FILE_INTEGRITY_MANAGER.setConfiguration(domainName, fimEnabledOnMapJSON, "AUDFIMSeverConf");
            REPORT_LOGGER.log(Level.INFO, "FIM->fimEnabledOnMap" + fimEnabledOnMapJSON);
        }
        if (changedMSSelection.length() != 0) {
            FILE_INTEGRITY_MANAGER.updateServerSelectionForFIM("AUDComputerEventRead", "COMPUTER_ID", changedMSSelection);
            REPORT_LOGGER.log(Level.INFO, "FIM->fimEnabledOnMap" + changedMSSelection);
        }
        if (changedDCSelection.length() != 0) {
            FILE_INTEGRITY_MANAGER.updateServerSelectionForFIM("AUDDCEventRead", "DOMAIN_CONTROLLER_ID", changedDCSelection);
            REPORT_LOGGER.log(Level.INFO, "FIM->fimEnabledOnMap" + changedDCSelection);
        }
        if (changedMSSelection.length() != 0 || changedDCSelection.length() != 0) {
            EventDataUtil.updateFIMFlag((String)domainName);
        }
        if (newFileTypes.length() != 0) {
            FILE_INTEGRITY_MANAGER.addNewData("AUDFIMFileConf", domainName, newFileTypes);
            FILE_INTEGRITY_MANAGER.setConfiguredList("AUDFIMFileConf");
            REPORT_LOGGER.log(Level.INFO, "FIM->newFileTypes" + newFileTypes);
        }
        if (newFolders.length() != 0) {
            FILE_INTEGRITY_MANAGER.addNewData("AUDFIMFolderConf", domainName, newFolders);
            FILE_INTEGRITY_MANAGER.setConfiguredList("AUDFIMFolderConf");
            REPORT_LOGGER.log(Level.INFO, "FIM->newFolders" + newFolders);
        }
        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Integrity", rb.handleGetObject("adap.ConfigureFileIntegrity.audit_entry.FIM_configured_successfully", new String[]{domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.confured_FIM", "-"}));
        FILE_INTEGRITY_MANAGER.setFIMEnabledServers();
        FILE_INTEGRITY_MANAGER.setFimEnabledDomainList();
        resultantJson.put("status", (Object)"success");
        JsonResponse.getInstance().sendResponse(response, resultantJson.toString());
    }

    public void viewConfiguredServers(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArrayList configuredServersList;
        int[] count;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        JSONObject jsonObj = new JSONObject(request.getParameter("params"));
        String domainName = jsonObj.getString("domainName");
        String searchString = jsonObj.getString("searchString");
        int startIndex = jsonObj.getInt("startIndex");
        int range = jsonObj.getInt("range");
        int machineType = jsonObj.getInt("machineType");
        JSONObject inputParamsDetails = jsonObj.getJSONObject("inputParamsDetails");
        if (machineType == 0) {
            count = FILE_INTEGRITY_MANAGER.getConfiguredDCCount(domainName, searchString);
            configuredServersList = FILE_INTEGRITY_MANAGER.getConfiguredDCs(domainName, searchString, startIndex, range);
        } else {
            count = FILE_INTEGRITY_MANAGER.getConfiguredMemberServersCount(domainName, searchString);
            configuredServersList = FILE_INTEGRITY_MANAGER.getConfiguredMemberServers(domainName, searchString, startIndex, range);
        }
        String cvid = "15025";
        JSONArray rangeList = new JSONArray();
        for (int i = 0; i < 4; ++i) {
            JSONObject rangeItem = new JSONObject();
            rangeItem.put("value", (i + 1) * 25);
            rangeList.put((Object)rangeItem);
        }
        inputParamsDetails.put("rangeList", (Object)rangeList);
        inputParamsDetails.put("startValue", startIndex);
        inputParamsDetails.put("rangeValue", range);
        inputParamsDetails.put("totalCount", count[0]);
        inputParamsDetails.put("showRefresh", true);
        if (!searchString.equals("")) {
            inputParamsDetails.put("isSearch", true);
        } else {
            inputParamsDetails.put("isSearch", false);
        }
        JSONObject ret = EmberTableConfig.getInstance().getEmberTableData(cvid, configuredServersList, inputParamsDetails, rb);
        JSONObject tableData = ret.getJSONObject("tableData");
        JSONObject serverInitialEnabledState = new JSONObject();
        for (int i = 0; i < configuredServersList.size(); ++i) {
            Properties serverProp = (Properties)configuredServersList.get(i);
            serverInitialEnabledState.put(serverProp.getProperty("UniqueId").toString(), (Object)serverProp.getProperty("IsFIMEnabled").toString());
        }
        JSONObject resultantJson = new JSONObject();
        resultantJson.put("tableData", (Object)tableData);
        resultantJson.put("tableInputParams", (Object)inputParamsDetails);
        resultantJson.put("serverInitialEnabledState", (Object)serverInitialEnabledState);
        JsonResponse.getInstance().sendResponse(response, resultantJson.toString());
    }

    public void selectFolder(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String folderDetails = request.getParameter("folderDetails");
        JSONObject folderDetailsObj = new JSONObject(folderDetails);
        String loadAll = folderDetailsObj.getString("loadAll");
        String folderPath = folderDetailsObj.getString("folderPath");
        JSONObject resultantJson = new JSONObject();
        String id = request.getParameter("id");
        try {
            TreeMap<String, String> dirList = new TreeMap<String, String>();
            if (id.equals("#")) {
                File[] roots = File.listRoots();
                for (int i = 0; i < roots.length; ++i) {
                    dirList.put(roots[i].toString(), roots[i].toString());
                }
            } else {
                File dir = new File(id);
                File[] listDir = dir.listFiles();
                if (listDir != null) {
                    for (int i = 0; i < listDir.length; ++i) {
                        if (!listDir[i].isDirectory()) continue;
                        dirList.put(listDir[i].getName(), listDir[i].getPath());
                    }
                }
            }
            ArrayList<JSONObject> dirArrayList = new ArrayList<JSONObject>();
            JSONObject pathObj = new JSONObject();
            for (Map.Entry entry : dirList.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                pathObj = new JSONObject();
                pathObj.put("text", (Object)key);
                pathObj.put("id", (Object)value);
                pathObj.put("children", true);
                JSONObject stateObj = new JSONObject();
                stateObj.put("opened", false);
                pathObj.put("state", (Object)stateObj);
                dirArrayList.add(pathObj);
            }
            JSONArray dirListArray = APIUtil.getInstance().listToJSONArray(dirArrayList);
            if (dirList.isEmpty()) {
                response.sendError(50);
            }
            JsonResponse.getInstance().sendResponse(response, dirListArray.toString());
        }
        catch (Exception e) {
            response.sendError(50);
            e.printStackTrace();
        }
    }

    public void validatefolder(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String sysroot = System.getenv("SystemDrive");
            String folderDetails = request.getParameter("folderDetails");
            JSONObject folderDetailsObj = new JSONObject(folderDetails);
            String folderName = folderDetailsObj.getString("folderName");
            String domainName = folderDetailsObj.getString("domainName");
            String[] localString = new String[]{"Program Files", "Program Files (x86)", "windows", ""};
            String[] replaceString = new String[]{"%ProgramFiles%", "%ProgramFiles% (x86)", "%SystemRoot%", "%SystemDrive%\\"};
            folderName = folderName.toLowerCase();
            for (int i = 0; i < localString.length; ++i) {
                String path = sysroot.toLowerCase() + "\\" + localString[i].toLowerCase();
                if (!folderName.startsWith(path)) continue;
                folderName = folderName.replace(path, replaceString[i]);
                break;
            }
            JSONObject resultantJson = new JSONObject();
            resultantJson.put("folderName", (Object)folderName);
            JsonResponse.getInstance().sendResponse(response, resultantJson.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void validateFileType(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String fileType = request.getParameter("fileType");
            String domainName = request.getParameter("domainName");
            String deletedList = request.getParameter("deletedList");
            fileType = fileType.toLowerCase();
            if (FILE_INTEGRITY_MANAGER.isDuplicate(domainName, "AUDFIMFileConf", "FILE_TYPE", fileType, deletedList)) {
                response.sendError(51);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

