/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.serveraudit;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.common.EmberTableConfig;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.serveraudit.ServerConfigHandler;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.APIUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.ntfs.PrintHandler;
import com.adventnet.sym.adsm.common.server.ntfs.PrintSystemAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.JSONUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public class PrintServerConfigHandler {
    private static volatile PrintServerConfigHandler instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PrintServerConfigHandler getInstance() {
        if (instance != null) return instance;
        Class<PrintServerConfigHandler> clazz = PrintServerConfigHandler.class;
        synchronized (PrintServerConfigHandler.class) {
            if (instance != null) return instance;
            instance = new PrintServerConfigHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private PrintServerConfigHandler() {
    }

    public JSONObject getServerInputModalList(String type, AdventNetResourceBundle rb) throws Exception {
        JSONArray tabList = new JSONArray();
        JSONObject serverTabMap = new JSONObject();
        if (type.equals("servers")) {
            String uvhString = "AUDCVConfig:cv_id:15029";
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
            JSONObject b = new JSONObject();
            JSONObject b1 = new JSONObject();
            b1.put("tabDisplayName", (Object)rb.getString("adap.reports.view_computers.tab_heading.member_servers"));
            b1.put("cvId", (Object)cvId);
            b1.put("objectClass", (Object)"computer");
            b.put("tabInputParams", (Object)b1);
            b.put("tabData", (Object)new JSONObject());
            tabList.put((Object)b);
        }
        serverTabMap.put("inputModalList", (Object)tabList);
        return serverTabMap;
    }

    public JSONObject getPrinterInputModalList(String type, AdventNetResourceBundle rb) throws Exception {
        JSONArray tabList = new JSONArray();
        JSONObject serverTabMap = new JSONObject();
        if (type.equals("servers")) {
            JSONObject b = new JSONObject();
            JSONObject b1 = new JSONObject();
            b1.put("tabDisplayName", (Object)rb.getString("adap.AUDGPPolicyPathMapping.policy_path.Preferences.Printers"));
            b1.put("cvId", 4L);
            b1.put("objectClass", (Object)"printer");
            b.put("tabInputParams", (Object)b1);
            b.put("tabData", (Object)new JSONObject());
            tabList.put((Object)b);
        }
        serverTabMap.put("inputModalList", (Object)tabList);
        return serverTabMap;
    }

    public void listPrintServers(HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrintServerConfigHandler.getInstance().listPrintServers(request, response, null, null);
    }

    public void viewPrinterAction(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.listPrintServers(request, response, null, null);
    }

    public void updatePrintServers(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.listPrintServers(request, response, null, null);
    }

    public void listPrintServers(HttpServletRequest request, HttpServletResponse response, String msgTxt, String msgType) throws Exception {
        try {
            String machineName;
            ArrayList guidList;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject serverInputParams = null;
            serverInputParams = reportReqData.getJSONObject("inputParams");
            String domainName = serverInputParams.getString("domainName");
            String uvhString = "AUDCVConfig:cv_id:15012";
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDTableViewConfig", (String)"CV_ID"), (Object)cvId, 0);
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDTableViewConfig", crit);
            HashMap<String, String> tableDetails = new HashMap<String, String>();
            if (!dob.isEmpty()) {
                Row r = dob.getFirstRow("AUDTableViewConfig");
                List al = r.getColumns();
                for (int i = 0; i < al.size(); ++i) {
                    String key = String.valueOf(al.get(i));
                    String value = String.valueOf(r.get((String)al.get(i)));
                    tableDetails.put(key, value);
                }
            }
            Long tableId = Long.parseLong((String)tableDetails.get("TABLE_VIEW_ID"));
            if (!serverInputParams.has("sortColumn")) {
                serverInputParams.put("sortColumn", tableDetails.get("SORTCOLUMN"));
                serverInputParams.put("sortOrder", tableDetails.get("SORTORDER"));
                serverInputParams.put("sortTableName", (Object)"ADSMComputerGeneralDetails");
            }
            serverInputParams.put("selObjNameIndex", (Object)"1");
            ArrayList<HashMap<String, Object>> tableAllColumnList = ServerConfigHandler.getInstance().getVisibleColumnList(cvId, true, true, true, serverInputParams.getString("sortColumn"), serverInputParams.getString("sortOrder"), rb);
            Boolean isSearch = false;
            String searchCriteria = null;
            searchCriteria = ServerConfigHandler.getInstance().getSearchCriteria(serverInputParams, tableAllColumnList, false, false);
            if (searchCriteria != null) {
                isSearch = true;
            }
            ServerConfigHandler.getInstance().getRangeList(serverInputParams);
            JSONObject serverTabMap = this.getServerInputModalList("servers", rb);
            serverInputParams.put("tabList", serverTabMap.get("inputModalList"));
            JSONObject printerTabTempMap = this.getPrinterInputModalList("servers", rb);
            JSONObject printerTabMap = new JSONObject();
            printerTabMap.put("tabList", printerTabTempMap.get("inputModalList"));
            HashMap<String, Object> addnParamsMap = new HashMap<String, Object>();
            addnParamsMap.put("sortColumn", serverInputParams.getString("sortColumn"));
            addnParamsMap.put("sortOrder", serverInputParams.getString("sortOrder"));
            addnParamsMap.put("sortTableName", serverInputParams.getString("sortTableName"));
            addnParamsMap.put("noOfObjects", serverInputParams.get("rangeValue"));
            addnParamsMap.put("startIndex", serverInputParams.get("startValue"));
            String action = "view";
            if (serverInputParams.has("action")) {
                action = serverInputParams.getString("action");
            }
            if (action.equalsIgnoreCase("enable") || action.equalsIgnoreCase("disable")) {
                guidList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)serverInputParams.getJSONArray("selectedObjectIdList"));
                Boolean isEnabled = PrintHandler.enableDiablePrintServers((action.equalsIgnoreCase("enable") ? 1 : 0) != 0, (ArrayList)guidList, (String)domainName, null);
                machineName = PrintHandler.GetComputerName((String)guidList.get(0).toString(), (String)"OBJECT_GUID", (String)"NAME");
                if (action.equalsIgnoreCase("enable")) {
                    if (isEnabled.booleanValue()) {
                        msgTxt = rb.getString("adap_print_server_success_enabled_auditing");
                    } else {
                        msgTxt = rb.getString("adap.DomainAction.License_Level_Exceed_Printer");
                        msgType = "info";
                    }
                } else {
                    msgTxt = rb.getString("adap_print_server_success_disabled_auditing");
                }
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Printers", "Successfully changed the Printer " + machineName + "\n Action : " + action, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Updated_printer_details", "-"}));
            } else if (action.equalsIgnoreCase("delete")) {
                guidList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)serverInputParams.getJSONArray("selectedObjectIdList"));
                Boolean isDeleted = PrintHandler.deletePrintServer((String)guidList.get(0).toString());
                machineName = PrintHandler.GetComputerName((String)guidList.get(0).toString(), (String)"OBJECT_GUID", (String)"NAME");
                if (isDeleted.booleanValue()) {
                    msgTxt = rb.getString("adap_print_server_success_deleted");
                }
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Printers", "Successfully deleted the Printers in the Server " + machineName, 16, 8, "adap.ADAPUserAuditSeverities.audit_name.deleted_printers", "-"}));
            }
            JSONArray a = new JSONArray();
            JSONArray b = new JSONArray();
            serverInputParams.put("selectedObjectIdList", (Object)a);
            serverInputParams.put("selectedObjectNameList", (Object)b);
            serverInputParams.remove("action");
            int count = PrintHandler.getConfiguredServerCount((String)domainName, (String)searchCriteria);
            serverInputParams.put("totalCount", count);
            serverInputParams.put("isSearch", (Object)isSearch);
            serverInputParams.put("tableName", (Object)("serverTable_" + cvId));
            serverInputParams.put("showDomainFilter", true);
            serverInputParams.put("showAuditPolicyFilter", false);
            serverInputParams.put("pageHeaderText", (Object)rb.getString("adap_ServerConfig.printer_configuration"));
            serverInputParams.put("tabHeaderText", (Object)rb.getString("adap.common.Printer_Configured_Servers"));
            serverInputParams.put("addServerTxt", (Object)rb.getString("adap.common.Add_Printers"));
            ArrayList printersList = new ArrayList();
            addnParamsMap.put("count", count);
            if (count > 0) {
                printersList = PrintHandler.getConfiguredServersEmber((String)domainName, addnParamsMap);
            }
            if (count == 0) {
                serverInputParams.put("emptyTableMessage", (Object)rb.getString((String)tableDetails.get("EMPTY_TABLE_MESSAGE")));
                serverInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                serverInputParams.put("emptyTableMessage2", (Object)rb.getString("adap_ServerConfig.click_here_to_configure"));
            }
            if (msgTxt != null) {
                serverInputParams.put("message", (Object)msgTxt);
                serverInputParams.put("type", (Object)msgType);
            }
            serverInputParams.put("readOnly", request.getAttribute("readOnly"));
            serverInputParams.put("totalCount", printersList.size());
            HashMap<String, Object> returnListMap = new HashMap<String, Object>();
            JSONObject resultObj = EmberTableConfig.getInstance().getEmberTableData1(tableId, printersList, tableAllColumnList, serverInputParams, rb);
            JSONObject tableData = resultObj.getJSONObject("tableData");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Configuration", rb.handleGetObject("adap.ConfiguredPrintServerAction.audit_entry_Print_servers_viewed", new String[]{domainName}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.view_print_servers", "-"}));
            returnListMap.put("serverData", tableData.get("tableDataList"));
            returnListMap.put("serverColumnList", tableAllColumnList);
            returnListMap.put("serverInputParams", serverInputParams);
            returnListMap.put("printServerInputParams", printerTabMap);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void getPrinters(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject serverInputParams = null;
            serverInputParams = reportReqData.getJSONObject("inputParams");
            String domainName = serverInputParams.getString("domainName");
            String hostName = serverInputParams.getString("hostName");
            String hostGuid = serverInputParams.getString("hostGuid");
            String searchCriteria = null;
            if (!serverInputParams.has("sortColumn")) {
                serverInputParams.put("sortColumn", (Object)"NAME");
                serverInputParams.put("sortOrder", (Object)"ASC");
                serverInputParams.put("sortTableName", (Object)"ADSMComputerGeneralDetails");
            }
            serverInputParams.put("selObjNameIndex", (Object)"2");
            String uvhString = "AUDCVConfig:cv_id:15013";
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
            ArrayList<HashMap<String, Object>> tableAllColumnList = ServerConfigHandler.getInstance().getVisibleColumnList(cvId, true, true, true, serverInputParams.getString("sortColumn"), serverInputParams.getString("sortOrder"), rb);
            Boolean isSearch = false;
            searchCriteria = ServerConfigHandler.getInstance().getSearchCriteria(serverInputParams, tableAllColumnList, false, false);
            if (searchCriteria != null) {
                isSearch = true;
            }
            ServerConfigHandler.getInstance().getRangeList(serverInputParams);
            HashMap<String, Object> addnParamsMap = new HashMap<String, Object>();
            addnParamsMap.put("sortColumn", serverInputParams.getString("sortColumn"));
            addnParamsMap.put("sortOrder", serverInputParams.getString("sortOrder"));
            addnParamsMap.put("sortTableName", serverInputParams.getString("sortTableName"));
            addnParamsMap.put("noOfObjects", serverInputParams.get("rangeValue"));
            addnParamsMap.put("startIndex", serverInputParams.get("startValue"));
            String action = serverInputParams.optString("action");
            if (action == null) {
                action = "All";
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("FROM_INDEX", serverInputParams.get("startValue"));
            params.put("RANGE", serverInputParams.get("rangeValue"));
            HashMap<String, String> shareMap = new HashMap<String, String>();
            String isRefresh = "false";
            if (serverInputParams.has("isRefresh")) {
                isRefresh = serverInputParams.getString("isRefresh");
            }
            shareMap.put("HOST_NAME", hostName);
            shareMap.put("REFRESH", isRefresh);
            shareMap.put("DOMAIN_NAME", domainName);
            shareMap.put("SHARE_ACTION", action);
            shareMap.put("HOST_GUID", hostGuid);
            Hashtable shareTable = PrintSystemAPI.getInstance().getSharesForServer(new HashMap(), shareMap, searchCriteria, Integer.valueOf(0));
            ArrayList shareList = (ArrayList)shareTable.get("printers");
            int count = shareList.size();
            serverInputParams.put("totalCount", count);
            serverInputParams.put("isSearch", (Object)isSearch);
            serverInputParams.put("tableName", (Object)("serverTable_" + cvId));
            serverInputParams.put("tabId", (Object)("tabId_" + cvId));
            serverInputParams.put("tabIdh", (Object)("#tabId_" + cvId));
            serverInputParams.put("tabName", (Object)("tabName_" + cvId));
            ArrayList printersList = new ArrayList();
            if (count > 0) {
                shareTable = PrintSystemAPI.getInstance().getSharesForServer(params, shareMap, searchCriteria, Integer.valueOf(count));
                printersList = (ArrayList)shareTable.get("printers");
                if (shareTable.get("message") != null) {
                    serverInputParams.put("showFilterText", true);
                    serverInputParams.put("filterText", shareTable.get("message"));
                }
            }
            if (count == 0) {
                serverInputParams.put("emptyTableMessage", shareTable.get("message"));
                if (isSearch.booleanValue()) {
                    serverInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                    serverInputParams.put("emptyTableMessage2", (Object)rb.getString("adap.common.text.policy_update_link.click_here"));
                } else {
                    serverInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                    serverInputParams.put("emptyTableMessage2", (Object)rb.getString("adap_ServerConfig.click_here_to_refresh"));
                }
            }
            serverInputParams.put("isRefresh", false);
            HashMap<String, Object> returnListMap = new HashMap<String, Object>();
            JSONObject resultObj = EmberTableConfig.getInstance().getEmberTableData("15013", printersList, serverInputParams, rb);
            JSONObject tableData = resultObj.getJSONObject("tableData");
            returnListMap.put("objectData", tableData.get("tableDataList"));
            returnListMap.put("objectColumnList", tableData.get("tableColumnList"));
            returnListMap.put("objectInputParams", resultObj.get("tableInputParams"));
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void savePrinters(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String msgTxt = rb.getString("adap_print_server_successfuly_added_updated_print_server");
        String msgType = "success";
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject printerInputParams = null;
            printerInputParams = reportReqData.getJSONObject("printerInputParams");
            JSONObject serverInputParams = reportReqData.getJSONObject("inputParams");
            String domainName = serverInputParams.getString("domainName");
            String hostName = printerInputParams.getString("hostName");
            String hostGuid = printerInputParams.getString("hostGuid");
            HashMap<String, Object> seletedObjectsMap = new HashMap<String, Object>();
            String shareAction = printerInputParams.getString("action");
            seletedObjectsMap.put("selectedObjectsList", (ArrayList)JSONUtil.JSONArrayToList((JSONArray)printerInputParams.getJSONArray("selectedObjectIdList")));
            seletedObjectsMap.put("seletedPortList", (ArrayList)JSONUtil.JSONArrayToList((JSONArray)printerInputParams.getJSONArray("selectedObjectNameList")));
            seletedObjectsMap.put("hostName", hostName);
            seletedObjectsMap.put("guidName", hostGuid);
            Boolean isLicensed = PrintHandler.addOrUpdatePrintersEmber(seletedObjectsMap, (String)shareAction, (String)domainName);
            if (!isLicensed.booleanValue()) {
                msgTxt = rb.getString("adap.DomainAction.License_Level_Exceed_Printer");
                msgType = "info";
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Printers", rb.handleGetObject("adap.ConfiguredPrintServerAction.audit_entry.Successfully_saved_printer", new String[]{hostName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Printers_Saved", "-"}));
        }
        catch (Exception e) {
            e.printStackTrace();
            msgTxt = "Error whils adding/updaing print server";
            msgType = "failure";
        }
        this.listPrintServers(request, response, msgTxt, msgType);
    }

    public void startPrintServerListener(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String msgTxt = rb.getString("adap_serverconfig_printer_listener");
        String msgType = "success";
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject serverInputParams = reportReqData.getJSONObject("inputParams");
            PrintSystemAPI.startThread((String)serverInputParams.getString("guidName"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            msgType = "failure";
        }
        HashMap<String, String> returnListMap = new HashMap<String, String>();
        returnListMap.put("msgTxt", msgTxt);
        returnListMap.put("msgType", msgType);
        JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
    }
}

