/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.serveraudit;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.EventDataHandler;
import com.adventnet.sym.adsm.auditing.server.config.ServerConfigAPI;
import com.adventnet.sym.adsm.auditing.server.delegation.GpoHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.FileServerHandler;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.server.util.FileAuditIpResolverUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.common.EmberTableConfig;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.serveraudit.FIMConfigHandler;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.APIUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.MSHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.JSONUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseUtil;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ServerConfigHandler {
    private static volatile ServerConfigHandler instance = null;
    public String workStationHours = "[{value:6,name:6},{value:12,name:12},{value:18,name:18},{value:24,name:24}]";
    public String hours = "[{value:0,name:0},{value:1,name:1},{value:2,name:2},{value:3,name:3},{value:4,name:4},{value:5,name:5},{value:6,name:6},{value:7,name:7},{value:8,name:8},{value:9,name:9},{value:10,name:10},{value:11,name:11},{value:12,name:12},{value:13,name:13},{value:14,name:14},{value:15,name:15},{value:16,name:16},{value:17,name:17},{value:18,name:18},{value:19,name:19},{value:20,name:20},{value:21,name:21},{value:22,name:22},{value:23,name:23}]";
    public String minutes = "[{value:0,name:0},{value:30,name:30}]";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServerConfigHandler getInstance() {
        if (instance != null) return instance;
        Class<ServerConfigHandler> clazz = ServerConfigHandler.class;
        synchronized (ServerConfigHandler.class) {
            if (instance != null) return instance;
            instance = new ServerConfigHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ServerConfigHandler() {
    }

    public void getRangeList(JSONObject inputParams) throws JSONException {
        if (!inputParams.has("rangeList")) {
            Integer pagelength = 25;
            inputParams.put("rangeValue", 25);
            inputParams.put("startValue", 1);
            JSONArray rangeList = new JSONArray();
            for (int i = 1; i <= 4; ++i) {
                JSONObject rangevalue = new JSONObject();
                rangevalue.put("value", pagelength * i);
                rangeList.put((Object)rangevalue);
            }
            inputParams.put("rangeList", (Object)rangeList);
        }
    }

    public String getSearchCriteria(JSONObject reportReqData, ArrayList<HashMap<String, Object>> tableAllColumnList, Boolean isMultipleSearchColumn, Boolean needSearchPatern) throws Exception {
        String searchCriteria = null;
        JSONObject searchData = null;
        if (reportReqData.has("searchData")) {
            searchData = reportReqData.getJSONObject("searchData");
            for (HashMap<String, Object> tableconfig : tableAllColumnList) {
                String column_value = tableconfig.get("columnalias").toString();
                if (!searchData.has(column_value)) continue;
                String columnSearchValue = searchData.get(column_value).toString();
                tableconfig.put("searchValue", searchData.get(column_value).toString());
                if (columnSearchValue == null || columnSearchValue.equalsIgnoreCase("")) continue;
                if (isMultipleSearchColumn.booleanValue()) {
                    columnSearchValue = CommonUtil.getSearchString((String)columnSearchValue);
                    searchCriteria = searchCriteria == null ? new String() : searchCriteria + " AND ";
                    searchCriteria = searchCriteria + ServerConfigHandler.getSearchString(column_value, columnSearchValue, null);
                    continue;
                }
                if (needSearchPatern.booleanValue()) {
                    searchCriteria = CommonUtil.getSearchString((String)columnSearchValue);
                    continue;
                }
                searchCriteria = columnSearchValue;
            }
        }
        return searchCriteria;
    }

    public static String getSearchString(String columnName, String val, String dataType) {
        if (dataType == null) {
            return columnName + " LIKE '" + val + "'";
        }
        if (dataType.toLowerCase().indexOf("char") != -1) {
            return columnName + " LIKE '" + val + "'";
        }
        val = val.replaceAll("%", "");
        return columnName + " = " + val;
    }

    public ArrayList<HashMap<String, Object>> getVisibleColumnList(Long cvId, Boolean visible, boolean isMandatory, boolean all, String sortColumn, String sortOrder, AdventNetResourceBundle rb) {
        ArrayList<HashMap<String, Object>> columnList = new ArrayList<HashMap<String, Object>>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDColumnConfiguration", (String)"CV_ID"), (Object)cvId, 0);
            if (!all) {
                criteria = criteria.and(Column.getColumn((String)"AUDColumnConfiguration", (String)"VISIBLE"), (Object)visible, 0);
                if (!isMandatory) {
                    criteria = criteria.and(Column.getColumn((String)"AUDColumnConfiguration", (String)"MANDATORY"), (Object)isMandatory, 0);
                }
            }
            Table table = Table.getTable((String)"AUDColumnConfiguration");
            SelectQueryImpl query = new SelectQueryImpl(table);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn((String)"AUDColumnConfiguration", (String)"*"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDColumnConfiguration", (String)"COLUMNINDEX"), true));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                Iterator iterator = dataObject.getRows("AUDColumnConfiguration");
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    HashMap<String, Object> columnDetailsMap = new HashMap<String, Object>();
                    List list = row.getColumns();
                    for (String columnName : list) {
                        if (columnName.equals("COLUMNALIAS") && sortColumn != null && row.get(columnName).toString().equals(sortColumn)) {
                            columnDetailsMap.put("isSortedColumn", true);
                            if (sortOrder.equals("ASC")) {
                                columnDetailsMap.put("isSortASC", true);
                            } else {
                                columnDetailsMap.put("isSortASC", false);
                            }
                        }
                        if (columnName.equals("VIEWNAME")) {
                            columnDetailsMap.put(row.get(columnName).toString(), true);
                        }
                        if (columnName.equals("DISPLAYNAME") && row.get(columnName) != null) {
                            columnDetailsMap.put(columnName.toLowerCase(), rb.getString(row.get(columnName).toString()));
                            continue;
                        }
                        columnDetailsMap.put(columnName.toLowerCase(), row.get(columnName));
                    }
                    columnList.add(columnDetailsMap);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columnList;
    }

    public static int[] getMachineTypes(String selectedTile, String action) {
        int[] machineTypes = new int[]{};
        if (selectedTile.equalsIgnoreCase("16")) {
            machineTypes = action.equalsIgnoreCase("Enable") ? new int[]{16} : (action.equalsIgnoreCase("Disable") ? new int[]{32} : new int[]{16, 32});
        } else if (selectedTile.equalsIgnoreCase("1024")) {
            machineTypes = action.equalsIgnoreCase("Enable") ? new int[]{1024} : (action.equalsIgnoreCase("Disable") ? new int[]{2048} : new int[]{1024, 2048});
        } else if (selectedTile.equalsIgnoreCase("4096")) {
            machineTypes = action.equalsIgnoreCase("Enable") ? new int[]{4096} : (action.equalsIgnoreCase("Disable") ? new int[]{8192} : new int[]{4096, 8192});
        }
        return machineTypes;
    }

    public JSONObject getServerInputModalList(Integer machineType, AdventNetResourceBundle rb) throws Exception {
        JSONObject b1;
        JSONObject b;
        JSONArray tabList = new JSONArray();
        JSONObject serverTabMap = new JSONObject();
        JSONObject b2 = new JSONObject();
        if (machineType.equals(16)) {
            b = new JSONObject();
            b1 = new JSONObject();
            b1.put("tabDisplayName", (Object)rb.getString("adap.reports.view_computers.tab_heading.member_servers"));
            b1.put("cvId", 4L);
            b1.put("objectClass", (Object)"computer");
            b.put("tabInputParams", (Object)b1);
            tabList.put((Object)b);
            b2.put("cvId", 15L);
        }
        if (machineType.equals(1024)) {
            b = new JSONObject();
            b1 = new JSONObject();
            b1.put("tabDisplayName", (Object)rb.getString("adap_ServerConfig.event_collectors"));
            b1.put("cvId", 900L);
            b1.put("objectClass", (Object)"computer");
            b.put("tabInputParams", (Object)b1);
            tabList.put((Object)b);
        }
        if (machineType.equals(4096)) {
            JSONObject a = new JSONObject();
            JSONObject a1 = new JSONObject();
            a1.put("tabDisplayName", (Object)rb.getString("adap.reports.view_computers.tab_heading.work_stations"));
            a1.put("cvId", 895L);
            a1.put("objectClass", (Object)"computer");
            a.put("tabInputParams", (Object)a1);
            b2.put("cvId", 15L);
            tabList.put((Object)a);
        }
        if (machineType.equals(4096) || machineType.equals(16)) {
            JSONObject bb = new JSONObject();
            b2.put("tabDisplayName", (Object)rb.getString("adap.ADMPObjects.display_text.ldap_Query"));
            b2.put("objectClass", (Object)"ldapQuery");
            bb.put("tabInputParams", (Object)b2);
            tabList.put((Object)bb);
        }
        serverTabMap.put("inputModalList", (Object)tabList);
        return serverTabMap;
    }

    public void listMemberServers(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getServers(request, response, null, null);
    }

    public void listWorkstations(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getServers(request, response, null, null);
    }

    public void listECServers(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getServers(request, response, null, null);
    }

    public void listFIMDomains(HttpServletRequest request, HttpServletResponse response) throws Exception {
        FIMConfigHandler.getInstance().getServers(request, response, null, null);
    }

    public void getServers(HttpServletRequest request, HttpServletResponse response, String message, String msgType) throws Exception {
        try {
            JSONArray mi;
            JSONArray ho;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject serverInputParams = null;
            serverInputParams = reportReqData.getJSONObject("inputParams");
            String domainName = serverInputParams.getString("domainName");
            String uvhString = "AUDCVConfig:cv_id:15038";
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDTableViewConfig", (String)"CV_ID"), (Object)cvId, 0);
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDTableViewConfig", crit);
            HashMap<String, String> tableDetails = new HashMap<String, String>();
            if (!dob.isEmpty()) {
                Row r = dob.getFirstRow("AUDTableViewConfig");
                List al = r.getColumns();
                for (int i = 0; i < al.size(); ++i) {
                    String key = String.valueOf(al.get(i));
                    String value = String.valueOf(r.get((String)al.get(i)));
                    tableDetails.put(key, value);
                }
            }
            serverInputParams.put("readOnly", request.getAttribute("readOnly"));
            Long tableId = Long.parseLong((String)tableDetails.get("TABLE_VIEW_ID"));
            String searchCriteria = null;
            if (!serverInputParams.has("sortColumn")) {
                serverInputParams.put("sortColumn", tableDetails.get("SORTCOLUMN"));
                serverInputParams.put("sortOrder", tableDetails.get("SORTORDER"));
                serverInputParams.put("sortTableName", (Object)"ADSMComputerGeneralDetails");
            }
            JSONArray a = new JSONArray();
            JSONArray b = new JSONArray();
            serverInputParams.put("selectedObjectIdList", (Object)a);
            serverInputParams.put("selectedObjectNameList", (Object)b);
            Long machineType = serverInputParams.getLong("machineType");
            String licenseMsg = null;
            if (machineType == 16L) {
                serverInputParams.put("serverType", (Object)"ms");
                ho = new JSONArray(this.hours);
                mi = new JSONArray(this.minutes);
                serverInputParams.put("hours", (Object)ho);
                serverInputParams.put("minutes", (Object)mi);
                licenseMsg = "adap.configuration.view_servers.view_member_servers.need_to_purchase.text";
            } else if (machineType == 1024L) {
                serverInputParams.put("serverType", (Object)"es");
                ho = new JSONArray(this.hours);
                mi = new JSONArray(this.minutes);
                serverInputParams.put("hours", (Object)ho);
                serverInputParams.put("minutes", (Object)mi);
            } else if (machineType == 4096L) {
                serverInputParams.put("serverType", (Object)"ws");
                ho = new JSONArray(this.workStationHours);
                mi = new JSONArray(this.minutes);
                serverInputParams.put("hours", (Object)ho);
                serverInputParams.put("minutes", (Object)mi);
                licenseMsg = "adap.configuration.view_work_stations.need_to_purchase.text";
            }
            Integer licenseCount = MSHandler.getLicenseCount((Integer)new Integer(machineType.toString()));
            String licenseType = LicenseUtil.getLicenseType();
            JSONObject alertInputParams = new JSONObject();
            if ((licenseType != null && (licenseType.equals("F") || licenseType.equals("T")) || licenseCount == 0) && machineType != 1024L) {
                alertInputParams.put("message", (Object)rb.getString(licenseMsg));
                alertInputParams.put("type", (Object)"info");
                alertInputParams.put("linkMessage", (Object)rb.getString("adap.configuratoin.view_servers.view_member_servers.learn_more.button_text"));
                alertInputParams.put("actionName", (Object)"openFreeLicenseHelp");
            }
            serverInputParams.put("alertInputParams", (Object)alertInputParams);
            ArrayList<HashMap<String, Object>> tableAllColumnList = this.getVisibleColumnList(cvId, true, true, true, serverInputParams.getString("sortColumn"), serverInputParams.getString("sortOrder"), rb);
            Boolean isSearch = false;
            searchCriteria = this.getSearchCriteria(serverInputParams, tableAllColumnList, true, false);
            if (searchCriteria != null) {
                isSearch = true;
            }
            this.getRangeList(serverInputParams);
            HashMap<String, Object> addnParamsMap = new HashMap<String, Object>();
            addnParamsMap.put("sortColumn", serverInputParams.get("sortColumn"));
            addnParamsMap.put("sortOrder", serverInputParams.getString("sortOrder"));
            addnParamsMap.put("tableName", serverInputParams.get("sortTableName"));
            addnParamsMap.put("noOfObjects", serverInputParams.get("rangeValue"));
            addnParamsMap.put("startIndex", serverInputParams.get("startValue"));
            String action = serverInputParams.optString("filterAction");
            if (action == null) {
                action = "All";
            }
            int[] machineTypes = ServerConfigHandler.getMachineTypes(serverInputParams.getString("machineType"), action);
            Boolean gpoStatus = false;
            Boolean readOnly = serverInputParams.optBoolean("readOnly");
            if (!((machineTypes[0] & 0x10) != 16 && (machineTypes[0] & 0x1000) != 4096 || readOnly != null && readOnly.booleanValue())) {
                gpoStatus = GpoHandler.getGpoStatus((String)domainName, (Integer)machineTypes[0]);
            }
            serverInputParams.put("gpoStatus", (Object)gpoStatus);
            JSONObject serverTabMap = this.getServerInputModalList(serverInputParams.getInt("machineType"), rb);
            serverInputParams.put("tabList", serverTabMap.get("inputModalList"));
            int count = ServerConfigAPI.getConfiguredServerCount((String)domainName, (String)searchCriteria, null, (int[])machineTypes, null);
            serverInputParams.put("totalCount", count);
            serverInputParams.put("isSearch", (Object)isSearch);
            serverInputParams.put("tableName", (Object)("serverTable_" + cvId));
            serverInputParams.put("addServerTxt", (Object)rb.getString("adap.SelectFileServer.Add_Server"));
            if (serverInputParams.getString("machineType").equalsIgnoreCase("16")) {
                serverInputParams.put("showDomainFilter", true);
                if (readOnly == null || !readOnly.booleanValue()) {
                    serverInputParams.put("showAuditPolicyFilter", true);
                }
                serverInputParams.put("pageHeaderText", (Object)rb.getString("adap_ServerConfig.member_server_configuration"));
                serverInputParams.put("tabHeaderText", (Object)rb.getString("adap.Configuration.tree_component.configured_member_servers"));
            } else if (serverInputParams.getString("machineType").equalsIgnoreCase("1024")) {
                serverInputParams.put("showDomainFilter", true);
                serverInputParams.put("showAuditPolicyFilter", false);
                serverInputParams.put("pageHeaderText", (Object)rb.getString("adap_ServerConfig.event_subscription_configuration"));
                serverInputParams.put("tabHeaderText", (Object)rb.getString("adap.Configuration.tree_component.configured_evt_collectors"));
            } else if (serverInputParams.getString("machineType").equalsIgnoreCase("4096")) {
                serverInputParams.put("showDomainFilter", true);
                if (readOnly == null || !readOnly.booleanValue()) {
                    serverInputParams.put("showAuditPolicyFilter", true);
                }
                serverInputParams.put("pageHeaderText", (Object)rb.getString("adap_ServerConfig.workstation_configuration"));
                serverInputParams.put("tabHeaderText", (Object)rb.getString("adap_ServerConfig.configured_workstations"));
                serverInputParams.put("addServerTxt", (Object)rb.getString("adap.common.text.add_work_stations"));
            }
            ArrayList serverList = new ArrayList();
            if (count > 0) {
                serverList = ServerConfigAPI.getConfiguredServersEmber((String)domainName, addnParamsMap, (String)searchCriteria, null, null, (int[])machineTypes, (Integer)count);
            }
            if (count == 0) {
                serverInputParams.put("emptyTableMessage", (Object)rb.getString((String)tableDetails.get("EMPTY_TABLE_MESSAGE")));
                serverInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                serverInputParams.put("emptyTableMessage2", (Object)rb.getString("adap_ServerConfig.click_here_to_configure"));
                serverInputParams.put("showAuditPolicyFilter", false);
            }
            if (message != null) {
                serverInputParams.put("message", (Object)message);
                serverInputParams.put("type", (Object)msgType);
            }
            HashMap<String, Object> returnListMap = new HashMap<String, Object>();
            JSONObject resultObj = EmberTableConfig.getInstance().getEmberTableData1(tableId, serverList, tableAllColumnList, serverInputParams, rb);
            JSONObject tableData = resultObj.getJSONObject("tableData");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.handleGetObject("adap.ConfigureComputerAction.audit_entry.get_configured_server", new String[]{domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.view_list_of_computers", "-"}));
            returnListMap.put("serverData", tableData.get("tableDataList"));
            returnListMap.put("serverColumnList", tableAllColumnList);
            returnListMap.put("serverInputParams", serverInputParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addServers(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = null;
        String msgType = "success";
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        JSONObject serverInputParams = null;
        serverInputParams = reportReqData.getJSONObject("inputParams");
        Integer mType = serverInputParams.getInt("machineType");
        ArrayList msNameList = null;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String domainName = serverInputParams.getString("domainName");
            ArrayList objectGuidList = null;
            objectGuidList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)serverInputParams.optJSONArray("selectedObjectIdList"));
            String userSelection = null;
            userSelection = serverInputParams.getBoolean("isAuditPolicy") ? "yes" : "no";
            ArrayList guidList = new ArrayList();
            for (int i = 0; i < objectGuidList.size(); ++i) {
                HashMap<String, String> computerMap = new HashMap<String, String>();
                computerMap.put("OBJECT_GUID", objectGuidList.get(i).toString());
                guidList.add(computerMap);
            }
            int[] machineTypes = ServerConfigHandler.getMachineTypes(serverInputParams.getString("machineType"), "Enable");
            message = MSHandler.addORUpdateServers((String)domainName, guidList, (String)userSelection, (int)machineTypes[0], (boolean[])new boolean[0]);
            if (!message.contains("success")) {
                msgType = "info";
            }
            msNameList = ReportUtil.getMSNamesFromId(guidList, (String)"OBJECT_GUID");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.add_computers", rb.handleGetObject("adap.ConfigureComputerAction.audit_entry.Added_Computers", new String[]{msNameList.toString()})}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = mType == 16 || mType == 1024 ? rb.getString("adap.ConfigureComputerAction.Error_While_Adding_Member_Servers") : rb.getString("adap.ConfigureComputerAction.Error_While_Adding_work_stations");
            msgType = "failure";
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.add_computers", rb.handleGetObject("adap.ConfigureComputerAction.audit_entry.Added_Computers", new String[]{msNameList.toString()})}));
        }
        this.getServers(request, response, message, msgType);
    }

    public void addMemberServers(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.addServers(request, response);
    }

    public void addWorkStations(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.addServers(request, response);
    }

    public void addECServers(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.addServers(request, response);
    }

    public void updateMemberServers(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.updateADServers(request, response);
    }

    public void updateWorkStations(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.updateADServers(request, response);
    }

    public void updateECServers(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.updateADServers(request, response);
    }

    public void updateFIMDomains(HttpServletRequest request, HttpServletResponse response) throws Exception {
        FIMConfigHandler.getInstance().updateFIMDomains(request, response);
    }

    public void updateADServers(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String msgTxt = null;
        String msgType = "info";
        AbstractCollection msNameList = null;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String[] successStrings = new String[]{"The event collection from the selected computer(s) has been stopped", "Successfully deleted", "Successfully Changed the Event Fetch Interval", "Successfully scheduled the event collection from selected computer(s)"};
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject serverInputParams = null;
            serverInputParams = reportReqData.getJSONObject("inputParams");
            String domainName = serverInputParams.getString("domainName");
            String manageAction = serverInputParams.getString("manageAction");
            String timePeriod = serverInputParams.optString("timePeriod");
            ArrayList objectGuidList = null;
            objectGuidList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)serverInputParams.optJSONArray("selectedObjectIdList"));
            ArrayList<Long> guidList = new ArrayList<Long>();
            for (int i = 0; i < objectGuidList.size(); ++i) {
                guidList.add(Long.parseLong(objectGuidList.get(i).toString()));
            }
            int[] machineTypes = ServerConfigHandler.getMachineTypes(serverInputParams.getString("machineType"), "Enable");
            msgTxt = MSHandler.updateMemberServers((String)domainName, (String)manageAction, guidList, (String)timePeriod, (Integer)machineTypes[0], (boolean[])new boolean[0]);
            for (int i = 0; i < successStrings.length; ++i) {
                if (!msgTxt.contains(successStrings[i])) continue;
                msgType = "success";
                break;
            }
            msNameList = ReportUtil.getMSNamesFromId(guidList, (String)"COMPUTER_ID");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.handleGetObject("adap.ConfigureComputerAction.audit_entry.Modified_Servers_successfully", new String[]{Long.toString(guidList.size()), manageAction}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.changed_computers_successfully", rb.handleGetObject("adap.ConfigureComputerAction.audit_entry.Changed_Computers", new String[]{msNameList.toString()})}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            msgTxt = rb.getString("adap_ServerConfig.error_while_updating_servers");
            msgType = "failure";
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.handleGetObject("adap.ConfigureComputerAction.audit_entry.Problem_modifying_computers", new String[]{msgTxt}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.changed_computers_successfully", rb.handleGetObject("adap.ConfigureComputerAction.audit_entry.Changed_Computers", new String[]{msNameList.toString()})}));
        }
        this.getServers(request, response, msgTxt, msgType);
    }

    public void runMSEventScheduler(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String message = "";
        String msgType = "success";
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        JSONObject serverInputParams = null;
        serverInputParams = reportReqData.getJSONObject("inputParams");
        String msIdStr = serverInputParams.getString("computerId");
        Integer mType = serverInputParams.getInt("machineType");
        Long requiredAccessCvId = null;
        if ((mType & 4) == 4 || (mType & 0x40) == 64 || (mType & 0x100) == 256 || (mType & 0x20000) == 131072) {
            requiredAccessCvId = 3152L;
        } else if ((mType & 0x10) == 16) {
            requiredAccessCvId = 3151L;
        } else if ((mType & 0x1000) == 4096) {
            requiredAccessCvId = 3153L;
        } else if ((mType & 0x400) == 1024) {
            requiredAccessCvId = 3154L;
        }
        Long requiredAccessId = DBObjectUtil.getUVHValues((String)"ADAPUserRoleActions", (String)("ADAPUserRoleActions:action_id:" + requiredAccessCvId));
        Long requiredAccessType = 32L;
        HttpSession session = request.getSession();
        ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        HashMap actionAccesses = authObject.getAccesses();
        if (!actionAccesses.containsKey(requiredAccessId)) {
            response.sendError(401);
            throw new Exception("ACCESS DENIED");
        }
        int userAccessType = (Integer)actionAccesses.get(requiredAccessId);
        if (requiredAccessType == 32L && userAccessType != 32) {
            response.sendError(401);
            throw new Exception("ACCESS DENIED");
        }
        request.setAttribute("readOnly", (Object)(requiredAccessType == 1L && userAccessType != 32 ? 1 : 0));
        if (msIdStr != null) {
            Long msId = Long.parseLong(msIdStr);
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"COMPUTER_ID"), (Object)msId, 0);
            ArrayList<String> list = new ArrayList<String>();
            list.add("ADSMComputerGeneralDetails");
            list.add("AUDComputerEventRead");
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(list, criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("ADSMComputerGeneralDetails");
                String domainName = (String)row.get("DOMAIN_NAME");
                String dcName = (String)row.get("NAME");
                Row eventRow = dataObject.getRow("AUDComputerEventRead");
                Integer machineType = (Integer)eventRow.get("MACHINE_TYPE");
                if (FileServerHandler.checkIsDomainController((String)domainName, (String)((String)row.get("OBJECT_GUID")))) {
                    machineType = machineType | 1;
                }
                try {
                    int fetchMode = (Integer)eventRow.get("EVENT_FETCH_MODE");
                    if (fetchMode == 2 && ((machineType & 4) == 4 || (machineType & 0x40) == 64)) {
                        FileAuditIpResolverUtil.getInstance().tableCountCheck(domainName, dcName);
                    }
                    EventDataHandler.getInstance().getEventDataFromDC((String)row.get("DOMAIN_NAME"), (String)row.get("NAME"), machineType.intValue(), (String)row.get("OBJECT_GUID"));
                    message = rb.handleGetObject("adap.ConfigureFileServerAction.Started_fetching_Event_Data_from_File_Server", new String[]{(String)row.get("NAME")});
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.handleGetObject("adap.ConfigureComputerAction.Started_fetching_Event_Data_from", new String[]{(String)row.get("NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Run_Ms_scheduler_manually", "-"}));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    msgType = "failure";
                    message = e.getMessage();
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.handleGetObject("Error while fetching event data from computer : ") + (String)row.get("NAME") + " \"" + e.getMessage() + "\"", 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Run_Ms_scheduler_manually", "-"}));
                }
                serverInputParams.put("message", (Object)message);
                serverInputParams.put("type", (Object)msgType);
                HashMap<String, JSONObject> returnListMap = new HashMap<String, JSONObject>();
                returnListMap.put("inputParams", serverInputParams);
                JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
            }
        }
    }

    public void setAuditPolicy(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        JSONObject serverInputParams = null;
        serverInputParams = reportReqData.getJSONObject("inputParams");
        String msgTxt = "";
        Boolean msgType = true;
        String domainName = serverInputParams.getString("domainName");
        Integer machineType = serverInputParams.getInt("machineType");
        Boolean gpoStatus = false;
        try {
            msgTxt = GpoHandler.reConfigureGpo((String)domainName, (Integer)machineType);
            gpoStatus = GpoHandler.getGpoStatus((String)domainName, (Integer)machineType);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", msgTxt + "\n " + rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.set_ws_SACL", "-"}));
        }
        catch (Exception e) {
            msgTxt = e.getMessage();
            e.printStackTrace();
            msgType = false;
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", msgTxt + "\n " + rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.set_ws_SACL", "-"}));
        }
        HashMap<String, Object> returnListMap = new HashMap<String, Object>();
        returnListMap.put("msgTxt", msgTxt);
        returnListMap.put("msgType", msgType);
        returnListMap.put("gpoStatus", gpoStatus);
        JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
    }
}

