/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.fileaudit;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.EventDataHandler;
import com.adventnet.sym.adsm.auditing.server.config.ServerConfigAPI;
import com.adventnet.sym.adsm.auditing.server.delegation.GpoHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.FileServerHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.ModifySaclThread;
import com.adventnet.sym.adsm.auditing.server.fileaudit.netapp.NetAppHandler;
import com.adventnet.sym.adsm.auditing.server.monitor.AudFileMonitorCriteriaHandler;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.server.util.FileAuditIpResolverUtil;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.ntfs.FileSystemAPI;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.EscapeUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;

public class ConfiguredFileServerAction
extends DispatchAction {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    protected static Logger logger = Logger.getLogger(ConfiguredFileServerAction.class.getName());

    public ActionForward getDefaultNamingContext(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward = "selectFileServers";
        try {
            logger.log(Level.FINE, "*******************Inside getDefaultNamingContext******************");
            String[] strObjClass = request.getParameter("strType").split(";;;");
            ObjectClass[] objectClass = new ObjectClass[strObjClass.length];
            for (int i = 0; i < strObjClass.length; ++i) {
                objectClass[i] = DirectoryObjectAPI.getInstance().getObjectClass(strObjClass[i]);
            }
            String domainName = request.getParameter("domainName");
            String defaultNamingContext = DomainDetailsAPI.getDefaultNamingContext((String)domainName);
            String cv_id = request.getParameter("cv_id");
            request.setAttribute("cv_id", (Object)cv_id);
            request.setAttribute("domainName", (Object)domainName);
            request.setAttribute("defaultNamingContext", (Object)defaultNamingContext);
            request.setAttribute("objectClass", (Object)objectClass);
            request.setAttribute("selectType", (Object)"radio");
            request.setAttribute("guidName", (Object)request.getParameter("guidName"));
            logger.log(Level.FINE, "*******************Leaving getDefaultNamingContext******************");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward(forward);
    }

    public ActionForward addFileServers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        String message = null;
        DynaActionForm bean = (DynaActionForm)form;
        String messageType = "Success";
        String shareAction = null;
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"fileServers", (ADAPAuthObject)authObj);
        try {
            Hashtable<String, Object> fsDetails = new Hashtable<String, Object>();
            String hostGuid = request.getParameter("hostGuid");
            String hostName = request.getParameter("hostName");
            String domainName = request.getParameter("domain");
            String shareLocations = request.getParameter("SHARE_LOCATIONS");
            logger.log(Level.INFO, "shareLocations" + shareLocations);
            shareAction = request.getParameter("shareAction");
            String userSelection = request.getParameter("userSelection");
            fsDetails.put("OBJECT_GUID", hostGuid);
            fsDetails.put("serverName", hostName);
            fsDetails.put("domainName", domainName);
            fsDetails.put("SHARE_ACTION", shareAction);
            fsDetails.put("MACHINE_TYPE", 4);
            if (!shareAction.equalsIgnoreCase("SACL")) {
                ArrayList<String> shareLocationList = new ArrayList<String>();
                StringTokenizer st = new StringTokenizer(shareLocations, ",");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    logger.log(Level.INFO, "sharename is  in ConfiguredFileServerAction is : " + token);
                    if (CommonUtil.getDBServerName().equalsIgnoreCase("mssql")) {
                        token = EscapeUtil.escSplCharsAsMSSQL((Object)token);
                    }
                    if (shareLocationList.contains(token)) continue;
                    shareLocationList.add(token);
                }
                logger.log(Level.INFO, "shareLocationList" + shareLocationList);
                fsDetails.put("LOCATIONS", shareLocationList);
            }
            if (accessType == 32) {
                if (shareAction.equalsIgnoreCase("ALL")) {
                    message = FileServerHandler.addFileServer(fsDetails, (String)userSelection);
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "File Audit", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.added_file_shares", rb.handleGetObject("adap.audit_entry_addn.Details", new String[]{fsDetails.toString()})}));
                } else if (shareAction.equalsIgnoreCase("ADD")) {
                    AudFileMonitorCriteriaHandler.addFileServersShares((String)((String)fsDetails.get("domainName")), (String)((String)fsDetails.get("serverName")), (ArrayList)((ArrayList)fsDetails.get("LOCATIONS")));
                    message = rb.getString("adap.ConfigureFileServerAction.Successfully_added_File_Shares_for_auditng");
                    if (userSelection != null) {
                        if (userSelection.equalsIgnoreCase("yes")) {
                            new ModifySaclThread(fsDetails);
                            message = message + " " + rb.getString("adap.ConfiguredFileServerAction.configuring_audit_permission_on_file_shares_is_started_successfully");
                        } else {
                            message = message + "<div id=\"commentForm\" style=\"display:block\"> " + rb.getString("adap.ConfiguredFileServerAction.note_sacl_permissions") + "</a></div>";
                        }
                    }
                    FileServerHandler.addFileUpdateDetails(fsDetails, (boolean)false);
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.added_file_shares", rb.handleGetObject("adap.audit_entry_addn.Details", new String[]{fsDetails.toString()})}));
                } else if (shareAction.equalsIgnoreCase("REMOVE")) {
                    FileServerHandler.deleteConfiguredShares((ArrayList)((ArrayList)fsDetails.get("LOCATIONS")), (String)hostName, (String)domainName);
                    message = rb.getString("adap.ConfigureFileServerAction.Successfully_removed_File_Shares_for_auditng");
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "File Audit", message, 16, 8, "adap.ADAPUserAuditSeverities.audit_name.remove_fs_Shares", rb.handleGetObject("adap.audit_entry_addn.Details", new String[]{fsDetails.toString()})}));
                } else if (shareAction.equalsIgnoreCase("SACL")) {
                    ArrayList conShareList = FileServerHandler.getConfiguredShares((String)((String)fsDetails.get("serverName")), (String)((String)fsDetails.get("domainName")));
                    fsDetails.put("LOCATIONS", conShareList);
                    new ModifySaclThread(fsDetails);
                    message = rb.handleGetObject("adap.ConfigureFileServerAction.Configuring_audit_settings_(SACL)_for_File_Shares", new String[]{(String)fsDetails.get("serverName")});
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message, 16, 8, "adap.ADAPUserAuditSeverities.audit_name.configured_FS_SACL", rb.handleGetObject("adap.audit_entry_addn.Details", new String[]{conShareList.toString()})}));
                }
            } else {
                message = rb.getString("adap.access_denied.ConfiguredFileServerAction.add");
                messageType = "Error";
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message, 16, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            }
        }
        catch (DataAccessException ex) {
            ex.printStackTrace();
            messageType = "Error";
            message = ex.getMessage();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message, 16, 16, "adap.ADAPUserAuditSeverities.audit_name.Error_Adding_FS", "-"}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            messageType = "Error";
            message = ex.getMessage();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message, 16, 16, "adap.ADAPUserAuditSeverities.audit_name.Error_Adding_FS", "-"}));
        }
        if (shareAction.equalsIgnoreCase("REMOVE") || shareAction.equalsIgnoreCase("SACL")) {
            ClientUtil.setStatusXMLElement(response, messageType, message);
            return mapping.findForward(null);
        }
        String domainName = (String)session.getAttribute("MONITOR_DOMAIN_NAME");
        this.getConfiguredFileServers(bean, request, domainName);
        request.setAttribute("message", (Object)message);
        return mapping.findForward("viewServers");
    }

    private void getConfiguredFileServers(DynaActionForm bean, HttpServletRequest request, String domainName) throws Exception {
        String action;
        bean.set("searchString", (Object)"");
        bean.set("action", (Object)"All");
        bean.set("FROM_INDEX", (Object)1);
        bean.set("PAGE_NUMBER", (Object)"1");
        HashMap<String, Object> addnParamsMap = new HashMap<String, Object>();
        addnParamsMap.put("sortColumn", (String)bean.get("sortColumn"));
        addnParamsMap.put("sortOrder", (String)bean.get("sortOrder"));
        addnParamsMap.put("noOfObjects", bean.get("RANGE"));
        addnParamsMap.put("startIndex", bean.get("FROM_INDEX"));
        addnParamsMap.put("tableName", (String)bean.get("tableName"));
        logger.log(Level.FINE, "Bean object is" + bean);
        int count = ServerConfigAPI.getConfiguredServerCount((String)domainName, null, null, (int[])new int[]{4, 8}, null);
        ArrayList list = new ArrayList();
        if (count > 0) {
            list = ServerConfigAPI.getConfiguredServers((String)domainName, addnParamsMap, null, null, null, (int[])new int[]{4, 8}, (Integer)count);
        }
        if ((action = (String)bean.get("action")) == null) {
            action = "All";
        }
        int[] machineTypes = action.equalsIgnoreCase("Enable") ? new int[]{4} : (action.equalsIgnoreCase("Disable") ? new int[]{8} : new int[]{4, 8});
        Boolean gpoStatus = null;
        if ((machineTypes[0] & 4) == 4 || (machineTypes[0] & 8) == 8) {
            gpoStatus = GpoHandler.getGpoStatus((String)domainName, (Integer)machineTypes[0]);
        }
        ArrayList columnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(Long.valueOf(100000L), Boolean.valueOf(true));
        String gpoGuids = "";
        if (gpoStatus != null) {
            PolicyHandler polHandler = new PolicyHandler();
            boolean auditDDCPolicyState = polHandler.getAuditPolicy(domainName, "{6AC1786C-016F-11D2-945F-00C04fB984F9}", false);
            if (!auditDDCPolicyState && !gpoStatus.booleanValue()) {
                gpoGuids = gpoGuids + "{6AC1786C-016F-11D2-945F-00C04fB984F9}";
                gpoGuids = gpoGuids + ",";
                gpoGuids = gpoGuids + "{31B2F340-016D-11D2-945F-00C04FB984F9}";
            } else if (!gpoStatus.booleanValue()) {
                gpoGuids = gpoGuids + "{31B2F340-016D-11D2-945F-00C04FB984F9}";
            } else if (!auditDDCPolicyState) {
                gpoGuids = gpoGuids + "{6AC1786C-016F-11D2-945F-00C04fB984F9}";
            }
        }
        request.setAttribute("gpoGuids", (Object)gpoGuids);
        request.setAttribute("columnList", (Object)columnList);
        request.setAttribute("list", (Object)list);
        request.setAttribute("count", (Object)count);
        request.setAttribute("PolicyStatus", (Object)gpoStatus);
        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "File Audit", rb.handleGetObject("adap.ConfiguredFileServerAction.View_FS_domain", new String[]{domainName}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.View_Listof_FS", "-"}));
    }

    public ActionForward updateFileServers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        DynaActionForm bean = (DynaActionForm)form;
        String domainName = (String)bean.get("DOMAIN_NAME");
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"fileServers", (ADAPAuthObject)authObj);
        try {
            if (accessType == 32) {
                logger.log(Level.FINE, "Inside updateFileServers");
                String msIdStr = request.getParameter("msId");
                logger.log(Level.FINE, "domainName is " + domainName);
                StringTokenizer st = new StringTokenizer(msIdStr, ";;;");
                ArrayList<Long> msList = new ArrayList<Long>();
                while (st.hasMoreTokens()) {
                    String msId = st.nextToken();
                    msList.add(Long.parseLong(msId));
                }
                String action = request.getParameter("manageAction");
                String message = FileServerHandler.updateFileServers((String)domainName, (String)action, msList, (String)request.getParameter("timePeriod"));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message + rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Update_File_Server", "-"}));
                request.setAttribute("message", (Object)message);
                this.getConfiguredFileServers(bean, request, domainName);
                logger.log(Level.FINE, "Leaving updateFileServers");
            } else {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", rb.getString("adap.access_denied.ConfiguredFileServerAction.update"), 16, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", ex.getMessage() + rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.Update_File_Server", "-"}));
        }
        return mapping.findForward("viewServers");
    }

    public ActionForward getShares(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardName = "viewShares";
        String displayText = rb.getString("adap.ConfiguredFileServerAction.File_Share");
        String searchPattern = null;
        try {
            String deselectedObjectsStr;
            HashMap<String, String> objectMap;
            String selectedObjectsStr;
            logger.log(Level.FINE, "***********************Inside getShares of ConfiguredFileServerAction******************************");
            DynaActionForm bean = (DynaActionForm)form;
            logger.log(Level.FINE, "Bean Object is" + bean);
            if (request.getParameter("init") != null) {
                bean.initialize(mapping);
            }
            String objectClass = request.getParameter("objectClass");
            String hostName = request.getParameter("hostName");
            String hostGuid = request.getParameter("hostGuid");
            String domainName = request.getParameter("domainName");
            String defaultNamingContext = request.getParameter("defaultNamingContext");
            String refresh = request.getParameter("refresh");
            String shareAction = request.getParameter("shareAction");
            String selectType = request.getParameter("selectType");
            String searchTxt = request.getParameter("searchTxt");
            HashMap selectedObjectsMap = (HashMap)bean.get("selectedObjectsMap");
            ArrayList selectedObjectsList = (ArrayList)selectedObjectsMap.get(objectClass);
            if (selectedObjectsList == null) {
                selectedObjectsList = new ArrayList();
            }
            if ((selectedObjectsStr = request.getParameter("selectedObjectsStr")) != null && !"".equals(selectedObjectsStr)) {
                StringTokenizer objectTokenizer = new StringTokenizer(selectedObjectsStr, ",");
                ArrayList<String> list = new ArrayList<String>();
                while (objectTokenizer.hasMoreTokens()) {
                    list.add(objectTokenizer.nextToken());
                }
                Iterator iter = FileSystemAPI.getInstance().getShareRows(domainName, list, objectClass, hostName);
                if (iter != null) {
                    while (iter.hasNext()) {
                        Row row = (Row)iter.next();
                        objectMap = new HashMap<String, String>();
                        objectMap.put("selectedObjects", (String)row.get("SHARE_NAME"));
                        objectMap.put("selectedObjectNames", (String)row.get("LOCATION"));
                        if (selectedObjectsList.contains(objectMap)) continue;
                        selectedObjectsList.add(objectMap);
                    }
                }
            }
            if ((deselectedObjectsStr = request.getParameter("deselectedObjectsStr")) != null && selectedObjectsList.size() > 0) {
                StringTokenizer deselectTokenizer = new StringTokenizer(request.getParameter("deselectedObjectsStr"), ",");
                while (deselectTokenizer.hasMoreTokens()) {
                    String deselectedGUID = deselectTokenizer.nextToken();
                    for (int i = 0; i < selectedObjectsList.size(); ++i) {
                        objectMap = (HashMap<String, String>)selectedObjectsList.get(i);
                        if (!deselectedGUID.equals((String)objectMap.get("selectedObjects"))) continue;
                        selectedObjectsList.remove(i);
                    }
                }
            }
            selectedObjectsMap.put(objectClass, selectedObjectsList);
            bean.set("selectedObjectsMap", (Object)selectedObjectsMap);
            if (searchTxt != null && !"".equalsIgnoreCase(searchTxt) && searchTxt.indexOf("%") == -1) {
                searchPattern = "%" + searchTxt + "%";
            }
            logger.log(Level.FINE, "searchTxt is" + searchTxt);
            logger.log(Level.FINE, "searchPattern is" + searchPattern);
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            params.put("FROM_INDEX", (Integer)bean.get("FROM_INDEX"));
            params.put("RANGE", (Integer)bean.get("RANGE"));
            HashMap<String, String> shareMap = new HashMap<String, String>();
            shareMap.put("HOST_NAME", hostName);
            shareMap.put("REFRESH", refresh);
            shareMap.put("DOMAIN_NAME", domainName);
            shareMap.put("SHARE_ACTION", shareAction);
            Hashtable shareTable = FileSystemAPI.getInstance().getSharesForServer(new HashMap(), shareMap, searchTxt, Integer.valueOf(0));
            ArrayList shareList = (ArrayList)shareTable.get("Shares");
            String errMessage = (String)shareTable.get("message");
            int shareCount = shareList.size();
            if (shareCount < (Integer)bean.get("FROM_INDEX")) {
                bean.set("FROM_INDEX", (Object)1);
                bean.set("PAGE_NUMBER", (Object)"1");
                params.put("FROM_INDEX", (Integer)bean.get("FROM_INDEX"));
                params.put("RANGE", (Integer)bean.get("RANGE"));
            }
            if (shareCount > 0) {
                shareMap.put("REFRESH", "false");
                shareTable = FileSystemAPI.getInstance().getSharesForServer(params, shareMap, searchTxt, Integer.valueOf(shareCount));
                shareList = (ArrayList)shareTable.get("Shares");
            }
            Long countL = shareCount;
            HashMap<String, String> shareParams = new HashMap<String, String>();
            shareParams.put("displayText", displayText);
            shareParams.put("selectType", selectType);
            shareParams.put("refresh", refresh);
            shareParams.put("shareAction", shareAction);
            shareParams.put("objectClass", objectClass);
            shareParams.put("defaultNamingContext", defaultNamingContext);
            shareParams.put("domainName", domainName);
            shareParams.put("hostName", hostName);
            shareParams.put("hostGuid", hostGuid);
            request.setAttribute("searchTxt", (Object)searchTxt);
            request.setAttribute("count", (Object)countL);
            request.setAttribute("rowsList", (Object)shareList);
            request.setAttribute("shareParams", shareParams);
            if (errMessage != null) {
                request.setAttribute("errMessage", (Object)errMessage);
            }
            logger.log(Level.FINE, "BeanObject is" + bean);
            logger.log(Level.FINE, "***********************Leaving getShares ConfiguredFileServerAction******************************");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward(forwardName);
    }

    public ActionForward getNetAppDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardName = "netappDetails";
        String displayText = rb.getString("adap.ConfiguredFileServerAction.File_Share");
        Object searchPattern = null;
        try {
            DynaActionForm bean = (DynaActionForm)form;
            logger.log(Level.INFO, "Bean Object is" + bean);
            if (request.getParameter("init") != null) {
                bean.initialize(mapping);
            }
            String objectClass = request.getParameter("objectClass");
            String hostName = request.getParameter("hostName");
            String hostGuid = request.getParameter("hostGuid");
            String domainName = request.getParameter("domainName");
            String shareAction = request.getParameter("shareAction");
            String defaultNamingContext = request.getParameter("defaultNamingContext");
            HashMap selectedObjectsMap = (HashMap)bean.get("selectedObjectsMap");
            ArrayList selectedObjectsList = (ArrayList)selectedObjectsMap.get(objectClass);
            bean.set("selectedObjectsMap", (Object)selectedObjectsMap);
            HashMap<String, String> shareParams = new HashMap<String, String>();
            shareParams.put("shareAction", shareAction);
            shareParams.put("objectClass", objectClass);
            shareParams.put("domainName", domainName);
            shareParams.put("hostName", hostName);
            shareParams.put("hostGuid", hostGuid);
            shareParams.put("defaultNamingContext", defaultNamingContext);
            shareParams.put("naVserverDefRotType", (String)NetAppHandler.getNaVserverDefaultAuditConfig().get("ROTATE_TYPE"));
            shareParams.put("naVserverDefFileCnt", (String)NetAppHandler.getNaVserverDefaultAuditConfig().get("ROTATE_LIMIT"));
            shareParams.put("naVserverDefFileSize", (String)NetAppHandler.getNaVserverDefaultAuditConfig().get("ROTATE_SIZE_STR"));
            shareParams.put("naVserverDefFilePath", (String)NetAppHandler.getNaVserverDefaultAuditConfig().get("EVT_FILE_JUNCTION_PATH"));
            request.setAttribute("shareParams", shareParams);
            request.setAttribute("FILE_SERVER_TYPE", (Object)"NetApp Server");
            logger.log(Level.INFO, "BeanObject is" + bean);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward(forwardName);
    }

    public ActionForward getEMCDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardName = "netappDetails";
        String displayText = rb.getString("adap.ConfiguredFileServerAction.File_Share");
        Object searchPattern = null;
        try {
            DynaActionForm bean = (DynaActionForm)form;
            logger.log(Level.INFO, "Bean Object is" + bean);
            if (request.getParameter("init") != null) {
                bean.initialize(mapping);
            }
            String objectClass = request.getParameter("objectClass");
            String hostName = request.getParameter("hostName");
            String hostGuid = request.getParameter("hostGuid");
            String domainName = request.getParameter("domainName");
            String shareAction = request.getParameter("shareAction");
            String defaultNamingContext = request.getParameter("defaultNamingContext");
            HashMap selectedObjectsMap = (HashMap)bean.get("selectedObjectsMap");
            ArrayList selectedObjectsList = (ArrayList)selectedObjectsMap.get(objectClass);
            bean.set("selectedObjectsMap", (Object)selectedObjectsMap);
            HashMap<String, String> shareParams = new HashMap<String, String>();
            shareParams.put("shareAction", shareAction);
            shareParams.put("objectClass", objectClass);
            shareParams.put("domainName", domainName);
            shareParams.put("hostName", hostName);
            shareParams.put("hostGuid", hostGuid);
            shareParams.put("defaultNamingContext", defaultNamingContext);
            request.setAttribute("shareParams", shareParams);
            request.setAttribute("FILE_SERVER_TYPE", (Object)"EMC Server");
            logger.log(Level.INFO, "BeanObject is" + bean);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward(forwardName);
    }

    public ActionForward runMSEventScheduler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String msIdStr = request.getParameter("msId");
        String message = "";
        String messageType = "Success";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        if (msIdStr != null) {
            Long msId = Long.parseLong(msIdStr);
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"COMPUTER_ID"), (Object)msId, 0);
            ArrayList<String> list = new ArrayList<String>();
            list.add("ADSMComputerGeneralDetails");
            list.add("AUDComputerEventRead");
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(list, criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("ADSMComputerGeneralDetails");
                String domainName = (String)row.get("DOMAIN_NAME");
                String dcName = (String)row.get("NAME");
                Row eventRow = dataObject.getRow("AUDComputerEventRead");
                Integer machineType = (Integer)eventRow.get("MACHINE_TYPE");
                if (FileServerHandler.checkIsDomainController((String)domainName, (String)((String)row.get("OBJECT_GUID")))) {
                    machineType = machineType | 1;
                }
                try {
                    int fetchMode = (Integer)eventRow.get("EVENT_FETCH_MODE");
                    if (fetchMode == 2 && ((machineType & 4) == 4 || (machineType & 0x40) == 64)) {
                        FileAuditIpResolverUtil.getInstance().tableCountCheck(domainName, dcName);
                    }
                    EventDataHandler.getInstance().getEventDataFromDC((String)row.get("DOMAIN_NAME"), (String)row.get("NAME"), machineType.intValue(), (String)row.get("OBJECT_GUID"));
                    message = rb.handleGetObject("adap.ConfigureFileServerAction.Started_fetching_Event_Data_from_File_Server", new String[]{(String)row.get("NAME")});
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Run_Ms_scheduler_manually", "-"}));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    messageType = "Error";
                    message = e.getMessage();
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message + rb.handleGetObject("adap.audit_entry.Server_name", new String[]{(String)row.get("NAME")}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.Run_Ms_scheduler_manually", "-"}));
                }
            }
        }
        ClientUtil.setStatusXMLElement(response, messageType, message);
        return mapping.findForward(null);
    }
}

