/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.fileaudit;

import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.util.GraphUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONObject;

public class FileAuditHomeAction
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
            ArrayList domainsList = authObject.getConfiguredDomainList();
            LinkedHashMap graphMap = GraphUtil.getHomeGraphList((int)2);
            Set graphIDSet = graphMap.keySet();
            for (int i = 0; i < domainsList.size(); ++i) {
                Properties p = (Properties)domainsList.get(i);
                String domainName = p.getProperty("DOMAIN_NAME");
                String dirName = System.getProperty("server.home");
                String baseChartDirectory = dirName + File.separator + "webapps" + File.separator + "adap" + File.separator + "cewolf_charts";
                HashMap<String, JSONObject> frameURLMap = new HashMap<String, JSONObject>();
                for (Long graphOptId : graphIDSet) {
                    HashMap detailsMap = (HashMap)graphMap.get(graphOptId);
                    Long firstGraphDuration = (Long)detailsMap.get("FIRST_GRAPH_DURATION");
                    String chartId = graphOptId + "_" + domainName + "_" + firstGraphDuration + "day";
                    String chartName = chartId + "_Data";
                    File htmlFile = new File(baseChartDirectory + File.separator + chartName + ".html");
                    if (htmlFile.exists()) {
                        frameURLMap.put(chartId + "_graph_frame", FileAuditHomeAction.getDataModel(htmlFile, chartName));
                    }
                    Long secondGraphDuration = (Long)detailsMap.get("SECOND_GRAPH_DURATION");
                    chartId = graphOptId + "_" + domainName + "_" + secondGraphDuration + "day";
                    chartName = chartId + "_Data";
                    htmlFile = new File(baseChartDirectory + File.separator + chartName + ".html");
                    if (!htmlFile.exists()) continue;
                    frameURLMap.put(chartId + "_graph_frame", FileAuditHomeAction.getDataModel(htmlFile, chartName));
                }
                p.put("frameURLMap", frameURLMap);
            }
            request.setAttribute("domainsList", (Object)domainsList);
            request.setAttribute("graphMap", (Object)graphMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (request.getParameter("tabId") != null) {
            request.setAttribute("tabId", (Object)Long.parseLong(request.getParameter("tabId")));
        }
        return mapping.findForward("fileAuditHomePage");
    }

    private static JSONObject getDataModel(File htmlFile, String chartName) {
        JSONObject dataModel = new JSONObject();
        try {
            String imageMap = "";
            String readLine = "";
            BufferedReader br = new BufferedReader(new FileReader(htmlFile));
            while ((readLine = br.readLine()) != null) {
                imageMap = imageMap + readLine;
            }
            dataModel.put("IMAGE_SRC", (Object)("cewolf_charts/" + chartName + ".png"));
            dataModel.put("IMAGE_TOOLTIP", (Object)imageMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataModel;
    }
}

