/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.fileaudit;

import com.adventnet.sym.adsm.auditing.server.config.ServerConfigAPI;
import com.adventnet.sym.adsm.auditing.server.delegation.GpoHandler;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;

public class ViewFileServers
extends Action {
    protected static Logger logger = Logger.getLogger(ViewFileServers.class.getName());

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String forwardPage = "viewServers";
        String[] fileServerTypes = new String[]{"Windows File Server", "Windows FailOver Cluster", "NetApp Server", "EMC Server"};
        DynaActionForm bean = (DynaActionForm)form;
        HttpSession session = request.getSession();
        String domainName = request.getParameter("domainName");
        if (domainName == null) {
            domainName = (String)bean.get("DOMAIN_NAME");
        }
        if (domainName == null) {
            domainName = DomainDetailsAPI.getDefaultDomainName();
        }
        if (request.getParameter("init") != null) {
            bean.initialize(mapping);
        }
        if ("".equals(domainName)) {
            domainName = (String)session.getAttribute("MONITOR_DOMAIN_NAME");
        } else {
            session.setAttribute("MONITOR_DOMAIN_NAME", (Object)domainName);
        }
        if (request.getParameter("sortColumn") != null) {
            bean.set("sortColumn", (Object)request.getParameter("sortColumn"));
            bean.set("sortOrder", (Object)request.getParameter("sortOrder"));
            bean.set("PAGE_NUMBER", (Object)"1");
            bean.set("FROM_INDEX", (Object)1);
        }
        if (request.getParameter("clearSearch") != null) {
            bean.set("searchString", (Object)"");
            bean.set("PAGE_NUMBER", (Object)"1");
            bean.set("FROM_INDEX", (Object)1);
        }
        Long cvID = 100000L;
        String searchCriteria = this.getColumnSearchCriteria(request, cvID, bean);
        HashMap<String, Object> addnParamsMap = new HashMap<String, Object>();
        addnParamsMap.put("sortColumn", (String)bean.get("sortColumn"));
        addnParamsMap.put("sortOrder", (String)bean.get("sortOrder"));
        addnParamsMap.put("tableName", (String)bean.get("tableName"));
        addnParamsMap.put("noOfObjects", bean.get("RANGE"));
        addnParamsMap.put("startIndex", bean.get("FROM_INDEX"));
        logger.log(Level.FINE, "HashMap addnParamsMap values" + addnParamsMap);
        String action = (String)bean.get("action");
        if (action == null) {
            action = "All";
        }
        int[] machineTypes = action.equalsIgnoreCase("Enable") ? new int[]{4} : (action.equalsIgnoreCase("Disable") ? new int[]{8} : new int[]{4, 8});
        Boolean gpoStatus = null;
        if ((machineTypes[0] & 4) == 4 || (machineTypes[0] & 8) == 8) {
            gpoStatus = GpoHandler.getGpoStatus((String)domainName, (Integer)machineTypes[0]);
        }
        request.setAttribute("PolicyStatus", (Object)gpoStatus);
        int count = ServerConfigAPI.getConfiguredServerCount((String)domainName, (String)searchCriteria, null, (int[])machineTypes, null);
        ArrayList list = new ArrayList();
        if (count > 0) {
            list = ServerConfigAPI.getConfiguredServers((String)domainName, addnParamsMap, (String)searchCriteria, null, null, (int[])machineTypes, (Integer)count);
        }
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        ArrayList domainList = authObject.getConfiguredDomainList();
        String[] domainNames = new String[domainList.size()];
        for (int i = 0; i < domainList.size(); ++i) {
            Properties domainProp = (Properties)domainList.get(i);
            domainNames[i] = domainProp.getProperty("DOMAIN_NAME");
        }
        ArrayList columnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvID, Boolean.valueOf(true));
        String gpoGuids = "";
        if (gpoStatus != null) {
            PolicyHandler polHandler = new PolicyHandler();
            boolean auditDDCPolicyState = polHandler.getAuditPolicy(domainName, "{6AC1786C-016F-11D2-945F-00C04fB984F9}", false);
            if (!auditDDCPolicyState && !gpoStatus.booleanValue()) {
                gpoGuids = gpoGuids + "{6AC1786C-016F-11D2-945F-00C04fB984F9}";
                gpoGuids = gpoGuids + ",";
                gpoGuids = gpoGuids + "{31B2F340-016D-11D2-945F-00C04FB984F9}";
            } else if (!gpoStatus.booleanValue()) {
                gpoGuids = gpoGuids + "{31B2F340-016D-11D2-945F-00C04FB984F9}";
            } else if (!auditDDCPolicyState) {
                gpoGuids = gpoGuids + "{6AC1786C-016F-11D2-945F-00C04fB984F9}";
            }
        }
        request.setAttribute("gpoGuids", (Object)gpoGuids);
        request.setAttribute("columnList", (Object)columnList);
        bean.set("domainNames", (Object)domainNames);
        bean.set("DOMAIN_NAME", (Object)domainName);
        bean.set("FILE_SERVER_TYPE", (Object)"Windows File Server");
        bean.set("fileServerTypes", (Object)fileServerTypes);
        request.setAttribute("count", (Object)count);
        request.setAttribute("list", (Object)list);
        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "File Audit", rb.handleGetObject("adap.ViewFileServers.audit_entry.file_server_viewed", new String[]{domainName}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.file_server_Viewed", "-"}));
        return mapping.findForward(forwardPage);
    }

    public String getColumnSearchCriteria(HttpServletRequest request, Long cvId, DynaActionForm bean) {
        String searchCriteria = null;
        String columnName = "";
        String tableName = "";
        try {
            String searchString = (String)bean.get("searchString");
            boolean search = false;
            if (request.getParameter("search") != null) {
                searchString = "";
                search = true;
            }
            Boolean visible = true;
            ArrayList columnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvId, visible);
            for (int i = 0; i < columnList.size(); ++i) {
                HashMap columnMap = (HashMap)columnList.get(i);
                tableName = (String)columnMap.get("TABLEALIAS");
                columnName = (String)columnMap.get("COLUMNALIAS");
                Long columnConfId = (Long)columnMap.get("COLUMN_CONF_ID");
                String val = null;
                if (search) {
                    if (request.getParameter("search_" + columnConfId.toString()) != null) {
                        val = request.getParameter("search_" + columnConfId);
                        if (!searchString.equalsIgnoreCase("")) {
                            searchString = searchString + "&";
                        }
                        searchString = searchString + "search_" + columnConfId + "=" + val;
                    }
                } else {
                    val = ViewFileServers.getSearchString(searchString, columnConfId);
                }
                if (val == null || val.equalsIgnoreCase("")) continue;
                val = CommonUtil.getSearchString((String)val);
                searchCriteria = searchCriteria == null ? new String() : searchCriteria + " AND ";
                searchCriteria = searchCriteria + columnName + " LIKE '" + val + "'";
            }
            if (search) {
                bean.set("searchString", (Object)searchString);
                bean.set("PAGE_NUMBER", (Object)"1");
                bean.set("FROM_INDEX", (Object)1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return searchCriteria;
    }

    public static String getSearchString(String searchString, Long id) throws Exception {
        String val = "";
        int index = searchString.indexOf("search_" + id + "=");
        if (index != -1) {
            val = searchString.indexOf("&", index) != -1 ? searchString.substring(searchString.indexOf("=", index) + 1, searchString.indexOf("&", index)) : searchString.substring(searchString.indexOf("=", index) + 1);
        }
        return val;
    }
}

