/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.fileaudit.cluster;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.EventDataHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.FileServerHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.ModifySaclThread;
import com.adventnet.sym.adsm.auditing.server.fileaudit.cluster.ClusterHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.cluster.ClusterMonitorCriteria;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.EscapeUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;

public class ConfiguredClusterAction
extends DispatchAction {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static Logger logger = Logger.getLogger(ConfiguredClusterAction.class.getName());

    public ActionForward runNodeEventScheduler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String msIdStr = request.getParameter("msId");
        String clusterName = request.getParameter("clusterName");
        String message = "";
        String messageType = "Success";
        DynaActionForm bean = (DynaActionForm)form;
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"fileClusters", (ADAPAuthObject)authObj);
        if (msIdStr != null) {
            Long msId = Long.parseLong(msIdStr);
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"COMPUTER_ID"), (Object)msId, 0);
            ArrayList<String> list = new ArrayList<String>();
            list.add("ADSMComputerGeneralDetails");
            list.add("AUDComputerEventRead");
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(list, criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("ADSMComputerGeneralDetails");
                String domainName = (String)row.get("DOMAIN_NAME");
                String dcName = (String)row.get("NAME");
                Row eventRow = dataObject.getRow("AUDComputerEventRead");
                Integer machineType = (Integer)eventRow.get("MACHINE_TYPE");
                if (FileServerHandler.checkIsDomainController((String)domainName, (String)((String)row.get("OBJECT_GUID")))) {
                    machineType = machineType | 1;
                }
                try {
                    EventDataHandler.getInstance().getEventDataFromDC((String)row.get("DOMAIN_NAME"), (String)row.get("NAME"), machineType.intValue(), (String)row.get("OBJECT_GUID"));
                    message = rb.handleGetObject("adap.ConfiguredClusterAction.Started_fetching_Event_Data_from_File_Server", new String[]{(String)row.get("NAME")});
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.fetching_fs_data_manuallay", "-"}));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    messageType = "Error";
                    message = e.getMessage();
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.fetching_fs_data_manuallay", "-"}));
                }
            }
        }
        ClientUtil.setStatusXMLElement(response, messageType, message);
        bean.set("monitorClusterName", (Object)clusterName);
        return mapping.findForward(null);
    }

    public ActionForward clusterShareAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = null;
        DynaActionForm bean = (DynaActionForm)form;
        String messageType = "Success";
        String shareAction = null;
        String domainName = null;
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"fileClusters", (ADAPAuthObject)authObj);
        try {
            if (accessType == 32) {
                ArrayList<String> shareLocationList = null;
                domainName = (String)bean.get("DOMAIN_NAME");
                String clusterName = request.getParameter("clusterName");
                String capName = request.getParameter("capName");
                String shares = request.getParameter("capShares");
                shareAction = request.getParameter("shareAction");
                if (shares != null) {
                    StringTokenizer st = new StringTokenizer(shares, ",");
                    shareLocationList = new ArrayList<String>();
                    while (st.hasMoreTokens()) {
                        String shareName = st.nextToken();
                        logger.log(Level.INFO, "shareName  in ConfiguredClusterAction is : " + shareName);
                        if (CommonUtil.getDBServerName().equalsIgnoreCase("mssql")) {
                            shareName = EscapeUtil.escSplCharsAsMSSQL((Object)shareName);
                        }
                        shareLocationList.add(shareName);
                    }
                    logger.log(Level.INFO, "shareLocationList in ConfiguredClusterAction is : " + shareLocationList);
                }
                if (shareAction.equalsIgnoreCase("REMOVE")) {
                    FileServerHandler.deleteConfiguredShares(shareLocationList, (String)capName, (String)domainName);
                    message = rb.getString("adap.ConfiguredClusterAction.Successfully_removed_File_Share_from_auditng");
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.deleted_shares", rb.handleGetObject("adap.ConfiguredClusterAction.audit_entry_addn.details_share_with_doamin", new String[]{shareLocationList.toString(), domainName})}));
                } else if (shareAction.equalsIgnoreCase("SACL")) {
                    ArrayList conShareList = FileServerHandler.getConfiguredShares((String)capName, (String)domainName);
                    Hashtable<String, Object> shareDetails = new Hashtable<String, Object>();
                    shareDetails.put("serverName", capName);
                    shareDetails.put("domainName", domainName);
                    shareDetails.put("LOCATIONS", conShareList);
                    shareDetails.put("MACHINE_TYPE", 64);
                    new ModifySaclThread(shareDetails);
                    message = rb.handleGetObject("adap.ConfiguredClusterAction.Configuring_audit_settings_for_File_Shares_in_capName_is_in_progress", new String[]{capName});
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.SACL_set", rb.handleGetObject("adap.ConfiguredClusterAction.audit_entry_addn.share_details ", new String[]{shareDetails.toString()})}));
                }
                bean.set("monitorClusterName", (Object)clusterName);
            } else {
                messageType = "Error";
                message = rb.getString("adap.access_denied.ConfiguredClusterAction.updateShare");
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            messageType = "Error";
            message = ex.getMessage();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.SACL_set", "-"}));
        }
        if (shareAction.equalsIgnoreCase("REMOVE") || shareAction.equalsIgnoreCase("SACL")) {
            ClientUtil.setStatusXMLElement(response, messageType, message);
            return mapping.findForward(null);
        }
        ArrayList list = ClusterHandler.getConfiguredClusters((String)domainName);
        request.setAttribute("list", (Object)list);
        request.setAttribute("message", (Object)message);
        return mapping.findForward("viewClusters");
    }

    public ActionForward updateClusterResources(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = "";
        String messageType = "Success";
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"fileClusters", (ADAPAuthObject)authObj);
        try {
            String clusterCapConfigIdStr = request.getParameter("capConfigId");
            DynaActionForm bean = (DynaActionForm)form;
            String domainName = (String)bean.get("DOMAIN_NAME");
            String clusterName = request.getParameter("clusterName");
            String action = request.getParameter("capAction");
            StringTokenizer st = new StringTokenizer(clusterCapConfigIdStr, ";;;");
            ArrayList<Long> capList = new ArrayList<Long>();
            while (st.hasMoreTokens()) {
                String capId = st.nextToken();
                capList.add(Long.parseLong(capId));
            }
            try {
                if (accessType == 32) {
                    message = ClusterHandler.updateClusterResources((String)domainName, (String)clusterName, capList, (String)action);
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Update_cluster_resource_details", rb.handleGetObject("adap.ConfiguredClusterAction.audit_entry_addn.Domain_cluster_name_CAP", new String[]{domainName, clusterName, capList.toString()})}));
                } else {
                    messageType = "Error";
                    message = rb.getString("adap.access_denied.ConfiguredClusterAction.updateClusterResources");
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                messageType = "Error";
                message = ex.getMessage();
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.Update_cluster_resource_details", rb.handleGetObject("adap.ConfiguredClusterAction.audit_entry_addn.Domain_cluster_name_CAP", new String[]{domainName, clusterName, capList.toString()})}));
            }
            ArrayList list = ClusterHandler.getConfiguredClusters((String)domainName);
            request.setAttribute("list", (Object)list);
            bean.set("monitorClusterName", (Object)clusterName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            messageType = "Error";
            message = ex.getMessage();
        }
        request.setAttribute("message", (Object)message);
        return mapping.findForward("viewClusters");
    }

    public ActionForward deleteCluster(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = "";
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"fileClusters", (ADAPAuthObject)authObj);
        try {
            DynaActionForm bean = (DynaActionForm)form;
            String domainName = (String)bean.get("DOMAIN_NAME");
            String clusterName = request.getParameter("clusterName");
            String clusterId = request.getParameter("clusterId");
            try {
                if (accessType == 32) {
                    ClusterHandler.deleteClusterNodes((String)domainName, (String)clusterName, (Long)Long.parseLong(clusterId));
                    ClusterHandler.deleteClusterResources((String)domainName, (String)clusterName, (Long)Long.parseLong(clusterId));
                    message = ClusterHandler.deleteCluster((String)domainName, (String)clusterName, (String)clusterId);
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "File Audit", message, 16, 8, "adap.ADAPUserAuditSeverities.audit_name.delete_cluster", rb.handleGetObject("adap.ConfiguredClusterAction.audit_entry_addn.Domain_ClusterName", new String[]{domainName, clusterName})}));
                } else {
                    message = rb.getString("adap.access_denied.ConfiguredClusterAction.deleteCluster");
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                message = ex.getMessage();
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "File Audit", message, 16, 16, "adap.ADAPUserAuditSeverities.audit_name.delete_cluster", rb.handleGetObject("adap.ConfiguredClusterAction.audit_entry_addn.Domain_ClusterName", new String[]{domainName, clusterName})}));
            }
            ClusterMonitorCriteria.getInstance().setConfiguredClusters();
            ArrayList list = ClusterHandler.getConfiguredClusters((String)domainName);
            request.setAttribute("list", (Object)list);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = ex.getMessage();
        }
        request.setAttribute("message", (Object)message);
        return mapping.findForward("viewClusters");
    }

    public ActionForward updateClusterNodes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = "";
        String messageType = "Success";
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"fileClusters", (ADAPAuthObject)authObj);
        try {
            Long clusterId = null;
            String nodeIdsStr = request.getParameter("scheduleId");
            DynaActionForm bean = (DynaActionForm)form;
            String domainName = (String)bean.get("DOMAIN_NAME");
            String clusterName = request.getParameter("clusterName");
            String EFI = request.getParameter("timePeriod");
            String action = request.getParameter("nodeAction");
            if (action.equalsIgnoreCase("Delete")) {
                clusterId = Long.parseLong(request.getParameter("clusterId"));
            }
            StringTokenizer st = new StringTokenizer(nodeIdsStr, ";;;");
            ArrayList<Long> nodeList = new ArrayList<Long>();
            while (st.hasMoreTokens()) {
                String nodeId = st.nextToken();
                nodeList.add(Long.parseLong(nodeId));
            }
            try {
                if (accessType == 32) {
                    message = ClusterHandler.updateClusterNodes((String)domainName, (String)clusterName, (Long)clusterId, nodeList, (String)action, (String)EFI);
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.update_cluster_nodes", rb.handleGetObject("adap.ConfiguredClusterAction.audit_entry_addn.Domain_ClusterName", new String[]{domainName, clusterName})}));
                } else {
                    messageType = "Error";
                    message = rb.getString("adap.access_denied.ConfiguredClusterAction.updateCluster");
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                messageType = "Error";
                message = ex.getMessage();
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.update_cluster_nodes", rb.handleGetObject("adap.ConfiguredClusterAction.audit_entry_addn.Domain_ClusterName", new String[]{domainName, clusterName})}));
            }
            ArrayList list = ClusterHandler.getConfiguredClusters((String)domainName);
            request.setAttribute("list", (Object)list);
            bean.set("monitorClusterName", (Object)clusterName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        request.setAttribute("message", (Object)message);
        return mapping.findForward("viewClusters");
    }
}

