/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.fileaudit.cluster;

import com.adventnet.sym.adsm.auditing.server.fileaudit.cluster.ClusterHandler;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;

public class ViewClusterAction
extends Action {
    private static Logger logger = Logger.getLogger(ViewClusterAction.class.getName());

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int i;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String forwardPage = "viewClusters";
        String[] fileServerTypes = new String[]{"Windows File Server", "Windows FailOver Cluster", "NetApp Server", "EMC Server"};
        DynaActionForm bean = (DynaActionForm)form;
        HttpSession session = request.getSession();
        String domainName = request.getParameter("domainName");
        String monitorClusterName = (String)bean.get("monitorClusterName");
        if (domainName == null) {
            domainName = (String)bean.get("DOMAIN_NAME");
        }
        if (domainName == null) {
            domainName = DomainDetailsAPI.getDefaultDomainName();
        }
        if (request.getParameter("init") != null) {
            bean.initialize(mapping);
        }
        if ("".equals(domainName)) {
            domainName = (String)session.getAttribute("MONITOR_DOMAIN_NAME");
        } else {
            session.setAttribute("MONITOR_DOMAIN_NAME", (Object)domainName);
        }
        ArrayList list = ClusterHandler.getConfiguredClusters((String)domainName);
        if ((monitorClusterName == null || monitorClusterName.equals("")) && list != null && list.size() > 0 && (i = 0) < list.size()) {
            Properties prop = (Properties)list.get(i);
            monitorClusterName = prop.getProperty("CLUSTER_NAME");
        }
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        ArrayList domainList = authObject.getConfiguredDomainList();
        String[] domainNames = new String[domainList.size()];
        for (int i2 = 0; i2 < domainList.size(); ++i2) {
            Properties domainProp = (Properties)domainList.get(i2);
            domainNames[i2] = domainProp.getProperty("DOMAIN_NAME");
        }
        bean.set("fileServerTypes", (Object)fileServerTypes);
        bean.set("FILE_SERVER_TYPE", (Object)"Windows FailOver Cluster");
        bean.set("domainNames", (Object)domainNames);
        bean.set("DOMAIN_NAME", (Object)domainName);
        bean.set("monitorClusterName", (Object)monitorClusterName);
        request.setAttribute("list", (Object)list);
        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "File Audit", rb.handleGetObject("adap.ViewClusterAction.audit_entry.Windows_FailOver_Cluster_viewed_for_the_Domain", new String[]{domainName, monitorClusterName}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.cluster_viewed", "-"}));
        return mapping.findForward(forwardPage);
    }
}

