/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.fileaudit.netapp;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.EventDataHandler;
import com.adventnet.sym.adsm.auditing.server.config.ServerConfigAPI;
import com.adventnet.sym.adsm.auditing.server.fileaudit.FileServerHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.ModifySaclThread;
import com.adventnet.sym.adsm.auditing.server.fileaudit.emc.EMCHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.netapp.NetAppHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.netapp.NetAppVserver;
import com.adventnet.sym.adsm.auditing.server.monitor.AudFileMonitorCriteriaHandler;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.EscapeUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import netapp.manage.NaAuthenticationException;
import netapp.manage.NaProtocolException;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;

public class ConfiguredNetAppFilers
extends DispatchAction {
    private static Logger logger = Logger.getLogger(ConfiguredNetAppFilers.class.getName());

    public ActionForward getDefaultNamingContext(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward = "selectNetAppFiler";
        try {
            String[] strObjClass = request.getParameter("strType").split(";;;");
            ObjectClass[] objectClass = new ObjectClass[strObjClass.length];
            for (int i = 0; i < strObjClass.length; ++i) {
                objectClass[i] = DirectoryObjectAPI.getInstance().getObjectClass(strObjClass[i]);
            }
            String domainName = request.getParameter("domainName");
            String defaultNamingContext = DomainDetailsAPI.getDefaultNamingContext((String)domainName);
            String cv_id = request.getParameter("cv_id");
            request.setAttribute("cv_id", (Object)cv_id);
            request.setAttribute("domainName", (Object)domainName);
            request.setAttribute("defaultNamingContext", (Object)defaultNamingContext);
            request.setAttribute("objectClass", (Object)objectClass);
            request.setAttribute("selectType", (Object)"radio");
            request.setAttribute("guidName", (Object)request.getParameter("guidName"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward(forward);
    }

    public ActionForward addNetAppFiler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"fileServers", (ADAPAuthObject)authObj);
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String message = null;
        DynaActionForm bean = (DynaActionForm)form;
        String messageType = "Success";
        String shareAction = "ALL";
        String fileServerType = request.getParameter("FILE_SERVER_TYPE");
        String isNetAppCifsVserver = request.getParameter("isNetAppCifsVserver");
        try {
            Hashtable<String, Object> fsDetails = new Hashtable<String, Object>();
            String userSelection = request.getParameter("userSelection");
            String hostGuid = request.getParameter("hostGuid");
            String hostName = request.getParameter("hostName");
            String domainName = request.getParameter("domain");
            String shareLocations = request.getParameter("SHARE_LOCATIONS");
            logger.log(Level.FINE, "shareLocations" + shareLocations);
            shareAction = request.getParameter("shareAction");
            fsDetails.put("OBJECT_GUID", hostGuid);
            fsDetails.put("serverName", hostName);
            fsDetails.put("domainName", domainName);
            fsDetails.put("SHARE_ACTION", shareAction);
            if (fileServerType.equals("NetApp Server")) {
                if (isNetAppCifsVserver.trim().equalsIgnoreCase("true")) {
                    fsDetails.put("MACHINE_TYPE", 524288);
                } else {
                    fsDetails.put("MACHINE_TYPE", 256);
                }
            } else {
                fsDetails.put("MACHINE_TYPE", 131072);
            }
            if (!shareAction.equalsIgnoreCase("SACL")) {
                StringTokenizer st = new StringTokenizer(shareLocations, ",");
                ArrayList<String> shareLocationList = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    logger.log(Level.INFO, "sharename  in ConfiguredNetAppFilers is : " + token);
                    if (CommonUtil.getDBServerName().equalsIgnoreCase("mssql")) {
                        token = EscapeUtil.escSplCharsAsMSSQL((Object)token);
                    }
                    if (shareLocationList.contains(token)) continue;
                    shareLocationList.add(token);
                }
                logger.log(Level.INFO, "shareLocationList in ConfiguredNetAppFilers is : " + shareLocationList);
                fsDetails.put("LOCATIONS", shareLocationList);
            }
            if (accessType == 32) {
                if (shareAction.equalsIgnoreCase("ALL")) {
                    String PFilerName;
                    String Password;
                    String userName;
                    if (fileServerType.equals("NetApp Server")) {
                        userName = request.getParameter("UserName");
                        Password = request.getParameter("Password");
                        PFilerName = request.getParameter("PFilerName");
                        String isVFiler = request.getParameter("IsVFiler");
                        String VFilerName = request.getParameter("VFilerName");
                        String isPolicy = request.getParameter("IsPolicy");
                        String isSACL = request.getParameter("IsSACL");
                        String portNo = request.getParameter("PortNo");
                        String isHttp = request.getParameter("IsHttp");
                        fsDetails.put("USER_NAME", userName);
                        fsDetails.put("PASSWORD", Password);
                        fsDetails.put("PORT_NO", Integer.parseInt(portNo));
                        fsDetails.put("IS_HTTP", Boolean.valueOf(isHttp));
                        fsDetails.put("IS_POLICY", isPolicy);
                        fsDetails.put("IS_SACL", isSACL);
                        if (fsDetails.get("MACHINE_TYPE").equals(524288)) {
                            message = NetAppHandler.addNetAppVserver((NetAppVserver)new NetAppVserver(request));
                        } else {
                            String evtFileSharePath = "\\\\" + hostName + "\\etc$\\log\\";
                            String msgDllPath = "\\\\" + hostName + "\\etc$\\OnTapAuditE.dll";
                            fsDetails.put("EVT_FILE_NAME", "adtlog.evt");
                            fsDetails.put("MSG_DLL_NAME", "OnTapAuditE.dll");
                            fsDetails.put("EVT_FILE_SHARE_PATH", evtFileSharePath);
                            fsDetails.put("MSG_DLL_SHARE_PATH", msgDllPath);
                            fsDetails.put("PFILER_NAME", PFilerName);
                            if (isVFiler.equals("true")) {
                                fsDetails.put("IS_VFILER", true);
                                fsDetails.put("VFILER_NAME", VFilerName);
                            } else {
                                fsDetails.put("IS_VFILER", false);
                            }
                            message = NetAppHandler.addNetAppFiler(fsDetails);
                        }
                        if (!message.toLowerCase().contains("successfully")) {
                            request.setAttribute("errHandler", (Object)"1");
                        }
                    } else {
                        userName = request.getParameter("UserName");
                        Password = request.getParameter("Password");
                        PFilerName = request.getParameter("PFilerName");
                        String isPolicy = request.getParameter("IsPolicy");
                        String isSACL = request.getParameter("IsSACL");
                        String portNo = request.getParameter("PortNo");
                        fsDetails.put("USER_NAME", userName);
                        fsDetails.put("PASSWORD", Password);
                        fsDetails.put("EMC_CONTROL_STATION_IP", PFilerName);
                        fsDetails.put("PORT_NO", Integer.parseInt(portNo));
                        fsDetails.put("IS_POLICY", isPolicy);
                        fsDetails.put("IS_SACL", isSACL);
                        message = EMCHandler.addEMCServer(fsDetails);
                        if (!message.contains("Successfully")) {
                            request.setAttribute("errHandler", (Object)"1");
                        }
                    }
                } else if (shareAction.equalsIgnoreCase("ADD")) {
                    AudFileMonitorCriteriaHandler.addFileServersShares((String)((String)fsDetails.get("domainName")), (String)((String)fsDetails.get("serverName")), (ArrayList)((ArrayList)fsDetails.get("LOCATIONS")));
                    message = rb.getString("adap.ConfigureFileServerAction.Successfully_added_File_Shares_for_auditng");
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Configuration", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.add_netapp_filer", rb.handleGetObject("adap.audit_entry_addn.Details", new String[]{fsDetails.toString()})}));
                    if (userSelection != null && userSelection.equalsIgnoreCase("yes")) {
                        new ModifySaclThread(fsDetails);
                        message = message + " " + rb.getString("adap.ConfiguredFileServerAction.configuring_audit_permission_on_file_shares_is_started_successfully");
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Configuration", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.config_audit_SACL_for_Netapp", rb.handleGetObject("adap.audit_entry_addn.Details", new String[]{fsDetails.toString()})}));
                    } else {
                        message = message + "<div id=\"commentForm\" style=\"display:block\"> " + rb.getString("adap.ConfiguredFileServerAction.note_sacl_permissions") + "</a></div>";
                    }
                    if (fileServerType.equals("NetApp Server")) {
                        FileServerHandler.addFileUpdateDetails(fsDetails, (boolean)false);
                    }
                } else if (shareAction.equalsIgnoreCase("REMOVE")) {
                    FileServerHandler.deleteConfiguredShares((ArrayList)((ArrayList)fsDetails.get("LOCATIONS")), (String)hostName, (String)domainName);
                    message = rb.getString("adap.ConfigureFileServerAction.Successfully_removed_File_Shares_for_auditng");
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Configuration", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Remove_NEtapp_shares", rb.handleGetObject("adap.ConfiguredNetAppFilers.audit_entry_addn.Domain_host_location", new String[]{domainName, hostName, ((ArrayList)fsDetails.get("LOCATIONS")).toString()})}));
                } else if (shareAction.equalsIgnoreCase("SACL")) {
                    ArrayList conShareList = FileServerHandler.getConfiguredShares((String)((String)fsDetails.get("serverName")), (String)((String)fsDetails.get("domainName")));
                    fsDetails.put("LOCATIONS", conShareList);
                    new ModifySaclThread(fsDetails);
                    message = rb.handleGetObject("adap.ConfigureFileServerAction.Configuring_audit_settings_(SACL)_for_File_Shares", new String[]{(String)fsDetails.get("serverName")});
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Netapp_SACL_set", "-"}));
                }
            } else {
                message = rb.getString("adap.access_denied.ConfiguredNetAppFilers.action");
                messageType = "Error";
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            }
        }
        catch (DataAccessException ex) {
            ex.printStackTrace();
            messageType = "Error";
            message = ex.getMessage();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.Updating_netapp_failed", "-"}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            messageType = "Error";
            message = ex.getMessage();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.Updating_netapp_failed", "-"}));
        }
        if (shareAction.equalsIgnoreCase("REMOVE") || shareAction.equalsIgnoreCase("SACL")) {
            ClientUtil.setStatusXMLElement(response, messageType, message);
            return mapping.findForward(null);
        }
        String domainName = (String)session.getAttribute("MONITOR_DOMAIN_NAME");
        this.getConfiguredNetAppFilers(bean, request, domainName, fileServerType);
        request.setAttribute("message", (Object)message);
        return mapping.findForward("viewNetApps");
    }

    private void getConfiguredNetAppFilers(DynaActionForm bean, HttpServletRequest request, String domainName, String fileServerType) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        bean.set("searchString", (Object)"");
        bean.set("action", (Object)"All");
        bean.set("FROM_INDEX", (Object)1);
        bean.set("PAGE_NUMBER", (Object)"1");
        HashMap<String, Object> addnParamsMap = new HashMap<String, Object>();
        addnParamsMap.put("sortColumn", (String)bean.get("sortColumn"));
        addnParamsMap.put("sortOrder", (String)bean.get("sortOrder"));
        addnParamsMap.put("noOfObjects", bean.get("RANGE"));
        addnParamsMap.put("startIndex", bean.get("FROM_INDEX"));
        addnParamsMap.put("tableName", (String)bean.get("tableName"));
        logger.log(Level.FINE, "Bean object is" + bean);
        String filterAction = (String)bean.get("action");
        if (filterAction == null) {
            filterAction = "All";
        }
        int[] machineTypes = NetAppHandler.getMachineTypes((String)fileServerType, (String)filterAction);
        int count = ServerConfigAPI.getConfiguredServerCount((String)domainName, null, null, (int[])machineTypes, null);
        ArrayList list = new ArrayList();
        if (count > 0) {
            list = ServerConfigAPI.getConfiguredServers((String)domainName, addnParamsMap, null, null, null, (int[])machineTypes, (Integer)count);
        }
        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Configuration", rb.handleGetObject("adap.ConfiguredNetAppFilers.audit_entry.View_List_of_Netapp_filer", new String[]{domainName}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.View_Listof_Netapp", "-"}));
        ArrayList columnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(Long.valueOf(100000L), Boolean.valueOf(true));
        request.setAttribute("columnList", (Object)columnList);
        request.setAttribute("list", (Object)list);
        request.setAttribute("count", (Object)count);
    }

    public ActionForward updateNetAppFilers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"fileServers", (ADAPAuthObject)authObj);
        try {
            String message;
            DynaActionForm bean = (DynaActionForm)form;
            String domainName = (String)bean.get("DOMAIN_NAME");
            String fileServerType = (String)bean.get("FILE_SERVER_TYPE");
            logger.log(Level.FINE, "domainName is " + domainName);
            if (accessType == 32) {
                String msIdStr = request.getParameter("msId");
                StringTokenizer st = new StringTokenizer(msIdStr, ";;;");
                ArrayList<Long> msList = new ArrayList<Long>();
                while (st.hasMoreTokens()) {
                    String msId = st.nextToken();
                    msList.add(Long.parseLong(msId));
                }
                String action = request.getParameter("manageAction");
                if (fileServerType.equals("NetApp Server")) {
                    message = NetAppHandler.updateNetAppFilers((String)domainName, (String)action, msList, (String)request.getParameter("timePeriod"));
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Update_Netapp", "-"}));
                } else {
                    message = EMCHandler.updateEMCServers((String)domainName, (String)action, msList, (String)request.getParameter("timePeriod"));
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Update_EMC", "-"}));
                }
            } else {
                message = rb.getString("adap.access_denied.ConfiguredNetAppFilers.action");
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            }
            request.setAttribute("message", (Object)message);
            this.getConfiguredNetAppFilers(bean, request, domainName, fileServerType);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward("viewNetApps");
    }

    public ActionForward runMSEventScheduler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String msIdStr = request.getParameter("msId");
        String message = "";
        String messageType = "Success";
        if (msIdStr != null) {
            Long msId = Long.parseLong(msIdStr);
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"COMPUTER_ID"), (Object)msId, 0);
            ArrayList<String> list = new ArrayList<String>();
            list.add("ADSMComputerGeneralDetails");
            list.add("AUDComputerEventRead");
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(list, criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("ADSMComputerGeneralDetails");
                String domainName = (String)row.get("DOMAIN_NAME");
                String dcName = (String)row.get("NAME");
                Row eventRow = dataObject.getRow("AUDComputerEventRead");
                Integer machineType = (Integer)eventRow.get("MACHINE_TYPE");
                if (FileServerHandler.checkIsDomainController((String)domainName, (String)((String)row.get("OBJECT_GUID")))) {
                    machineType = machineType | 1;
                }
                try {
                    EventDataHandler.getInstance().getEventDataFromDC((String)row.get("DOMAIN_NAME"), (String)row.get("NAME"), machineType.intValue(), (String)row.get("OBJECT_GUID"));
                    message = rb.handleGetObject("adap.ConfigureFileServerAction.Started_fetching_Event_Data_from_File_Server", new String[]{(String)row.get("NAME")});
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Run_Ms_scheduler_manually", "-"}));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    messageType = "Error";
                    message = e.getMessage();
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", message + "\n " + rb.handleGetObject("adap.audit_entry.Server_name", new String[]{(String)row.get("NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Run_Ms_scheduler_manually", "-"}));
                }
            }
        }
        ClientUtil.setStatusXMLElement(response, messageType, message);
        return mapping.findForward(null);
    }

    public ActionForward updateNetAppDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message;
        String messageType;
        block34: {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
            Integer accessType = AdminHandler.getAccessType((String)"fileServers", (ADAPAuthObject)authObj);
            messageType = "Success";
            message = rb.getString("adap.ConfiguredNetAppFilers.Successfully_updated_NetApp_Filer_Auditing_Details");
            String netappAuditMsg = rb.getString("adap.NetAppHandler.Error_while_enabling_netapp_audit_options");
            Hashtable<String, Object> netApp = new Hashtable<String, Object>();
            DynaActionForm bean = (DynaActionForm)form;
            String fileServerType = (String)bean.get("FILE_SERVER_TYPE");
            Boolean isNetAppVserver = Boolean.valueOf(request.getParameter("isNetAppVserver"));
            try {
                if (accessType == 32) {
                    if (isNetAppVserver.booleanValue()) {
                        NetAppVserver naVserver;
                        String isSync = request.getParameter("isSyncNetApp");
                        String isUpdateNetApp = request.getParameter("isUpdateNetApp");
                        String isApplyDefaultPolicy = request.getParameter("IsPolicy");
                        String hostGuid = request.getParameter("hostGuid");
                        String hostName = request.getParameter("hostName");
                        if (isSync != null && isSync.equals("true")) {
                            naVserver = new NetAppVserver(hostGuid, null, hostName);
                            if (naVserver.syncAuditPolicyWithDevice(true)) {
                                message = naVserver.getJSONString();
                            } else {
                                message = naVserver.errMessage;
                                messageType = "Error";
                            }
                        }
                        if (isUpdateNetApp != null && isUpdateNetApp.equals("true")) {
                            naVserver = new NetAppVserver(request);
                            boolean isSuccess = naVserver.updateEntryInDB();
                            if (isSuccess) {
                                if (isApplyDefaultPolicy != null && isApplyDefaultPolicy.equals("true")) {
                                    isSuccess = naVserver.applyAuditPolicyInDevice(true, true);
                                }
                                if (isSuccess) {
                                    isSuccess = naVserver.syncAuditPolicyWithDevice(true);
                                }
                            }
                            if (!isSuccess) {
                                messageType = "Error";
                            }
                            message = naVserver.errMessage;
                        }
                        break block34;
                    }
                    if (fileServerType.equals("NetApp Server")) {
                        String evtFileSharePath = request.getParameter("evtFileSharePath");
                        String msgDllSharePath = request.getParameter("msgDllSharePath");
                        String pFilerName = request.getParameter("pFilerName");
                        String vFilerName = request.getParameter("vFilerName");
                        String isVFiler = request.getParameter("isVFiler");
                        String userName = request.getParameter("UserName");
                        String password = request.getParameter("Password");
                        String hostGuid = request.getParameter("hostGuid");
                        String isSync = request.getParameter("isSyncNetApp");
                        String isPolicy = request.getParameter("isPolicy");
                        String isHttp = request.getParameter("IsHttp");
                        String portNo = request.getParameter("PortNo");
                        Row row = ReportUtil.getFirstRow((String)"ADSMComputerGeneralDetails", (String)"OBJECT_GUID", (Object)hostGuid, (int)0);
                        int lastIndex = evtFileSharePath.lastIndexOf("\\");
                        String evtLocation = evtFileSharePath.substring(0, lastIndex + 1);
                        String evtFileName = evtFileSharePath.substring(lastIndex + 1, evtFileSharePath.length());
                        int lastIndex1 = msgDllSharePath.lastIndexOf("\\");
                        String msgDllName = msgDllSharePath.substring(lastIndex1 + 1, msgDllSharePath.length());
                        netApp.put("OBJECT_GUID", hostGuid);
                        netApp.put("EVT_FILE_SHARE_PATH", evtLocation);
                        netApp.put("EVT_FILE_NAME", evtFileName);
                        netApp.put("MSG_DLL_SHARE_PATH", msgDllSharePath);
                        netApp.put("MSG_DLL_NAME", msgDllName);
                        netApp.put("USER_NAME", userName);
                        netApp.put("PASSWORD", password);
                        netApp.put("PFILER_NAME", pFilerName);
                        netApp.put("PORT_NO", Integer.parseInt(portNo));
                        if (isVFiler.equals("true")) {
                            netApp.put("IS_VFILER", true);
                            netApp.put("VFILER_NAME", vFilerName);
                        } else {
                            netApp.put("IS_VFILER", false);
                        }
                        if (isHttp.equals("true")) {
                            netApp.put("IS_HTTP", true);
                        } else {
                            netApp.put("IS_HTTP", false);
                        }
                        NetAppHandler.addNetAppDetails(netApp);
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", message + "\n " + rb.handleGetObject("adap.audit_entry_addn.Host_name", new String[]{(String)row.get("NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.add_netapp_filer", "-"}));
                        if (isPolicy.equals("true")) {
                            try {
                                NetAppHandler.SetAuditSettings((String)((String)netApp.get("PFILER_NAME")), (String)((String)netApp.get("VFILER_NAME")), (String)((String)netApp.get("USER_NAME")), (String)((String)netApp.get("PASSWORD")), (Boolean)((Boolean)netApp.get("IS_VFILER")), (Boolean)((Boolean)netApp.get("IS_HTTP")), (Integer)((Integer)netApp.get("PORT_NO")));
                                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.handleGetObject("adap.ConfiguredNetAppFilers.audit_entry.Audit_settings_successfully_configured", new String[]{(String)row.get("NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.config_audit_SACL_for_Netapp", "-"}));
                            }
                            catch (NaAuthenticationException na) {
                                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.getString("adap.NetAppHandler.Bad_username_or_password") + "\n " + rb.handleGetObject("adap.audit_entry_addn.Host_name", new String[]{(String)row.get("NAME")}), 8, rb, 16, "adap.ADAPUserAuditSeverities.audit_name.Updating_netapp_failed", "-"}));
                                throw new Exception(rb.getString("adap.NetAppHandler.Bad_username_or_password"));
                            }
                            catch (SocketException se) {
                                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol") + "\n " + rb.handleGetObject("adap.audit_entry_addn.Host_name", new String[]{(String)row.get("NAME")}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.Updating_netapp_failed", "-"}));
                                throw new Exception(rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol"));
                            }
                            catch (NaProtocolException nap) {
                                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol") + "\n " + rb.handleGetObject("adap.audit_entry_addn.Host_name", new String[]{(String)row.get("NAME")}), 8, rb, 16, "adap.ADAPUserAuditSeverities.audit_name.Updating_netapp_failed", "-"}));
                                throw new Exception(rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol"));
                            }
                            catch (Throwable ex) {
                                throw ex;
                            }
                        }
                        if (!isSync.equals("true") && !isPolicy.equals("true")) break block34;
                        HashMap auditOptions = null;
                        try {
                            auditOptions = NetAppHandler.getAuditSettings((String)((String)netApp.get("OBJECT_GUID")), (String)((String)netApp.get("PFILER_NAME")), (String)((String)netApp.get("VFILER_NAME")), (String)((String)netApp.get("USER_NAME")), (String)((String)netApp.get("PASSWORD")), (Boolean)((Boolean)netApp.get("IS_VFILER")), (Boolean)((Boolean)netApp.get("IS_HTTP")), (Integer)((Integer)netApp.get("PORT_NO")));
                        }
                        catch (NaAuthenticationException na) {
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.getString("adap.NetAppHandler.Bad_username_or_password") + "\n " + rb.handleGetObject("adap.audit_entry_addn.Host_name", new String[]{(String)row.get("NAME")}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.Updating_netapp_failed", "-"}));
                            throw new Exception(rb.getString("adap.NetAppHandler.Bad_username_or_password"));
                        }
                        catch (SocketException se) {
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol") + "\n " + rb.handleGetObject("adap.audit_entry_addn.Host_name", new String[]{(String)row.get("NAME")}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.Updating_netapp_failed", "-"}));
                            throw new Exception(rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol"));
                        }
                        catch (NaProtocolException nap) {
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol") + "\n " + rb.handleGetObject("adap.audit_entry_addn.Host_name", new String[]{(String)row.get("NAME")}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.Updating_netapp_failed", "-"}));
                            throw new Exception(rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol"));
                        }
                        catch (Throwable ex) {
                            throw ex;
                        }
                        logger.log(Level.INFO, "auditOptions:" + auditOptions);
                        if (auditOptions != null) {
                            NetAppHandler.updateAuditOptions((String)((String)netApp.get("OBJECT_GUID")), (HashMap)auditOptions);
                        }
                        break block34;
                    }
                    message = rb.getString(rb.getString("adap.ConfiguredNetAppFilers.Successfully_updated_EMC_Details"));
                    netappAuditMsg = "";
                    String emcControlStationIP = request.getParameter("pFilerName");
                    String userName = request.getParameter("UserName");
                    String password = request.getParameter("Password");
                    String hostGuid = request.getParameter("hostGuid");
                    String isSync = request.getParameter("isSyncNetApp");
                    String portNo = request.getParameter("PortNo");
                    String hostName = request.getParameter("hostName");
                    String domainName = request.getParameter("domain");
                    netApp.put("OBJECT_GUID", hostGuid);
                    EMCHandler.addEMCCIFSDetails((String)hostGuid, (String)hostName, (String)domainName, (String)emcControlStationIP, (String)userName, (String)password, (String)portNo);
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", message + "\n " + rb.handleGetObject("adap.audit_entry_addn.Host_name", new String[]{hostName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.added_EMC_CIFS", "-"}));
                    if (!isSync.equals("true")) break block34;
                    try {
                        EMCHandler.addDMDetails((String)hostGuid, (String)hostName, (String)domainName, (String)emcControlStationIP, (String)userName, (String)password, (String)portNo);
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.handleGetObject("adap.ConfiguredNetAppFilers.audit_entry.DMDetails_Config_successfully_for_netapp", new String[]{hostName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.DM_Details_Configured", "-"}));
                    }
                    catch (ConnectException ex) {
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.getString("adap.NetAppHandler.Unable_to_contact_EMC_Control_Station_Connection_Refused") + "\n " + rb.handleGetObject("adap.audit_entry_addn.Host_name", new String[]{hostName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.EMC_Ctrl_station_refused", "-"}));
                        throw new Exception(rb.getString("adap.EMCHandler.Unable_to_contact_EMC_Control_Station_Connection_Refused"));
                    }
                    catch (UnknownHostException ex) {
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.getString("adap.NetAppHandler.Unable_to_contact_EMC_Control_Station_Incorrect_EMC_IP") + "\n " + rb.handleGetObject("adap.audit_entry_addn.Host_name", new String[]{hostName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.EMC_Ctrl_station_refused", "-"}));
                        throw new Exception(rb.getString("adap.ConfiguredNetAppFilers.Unable_to_contact_EMC_Control_Station_Incorrect_EMC_IP"));
                    }
                    catch (Throwable ex) {
                        throw ex;
                    }
                    EMCHandler.getDMAuditSettings((String)hostGuid, (String)hostName, (String)domainName, (boolean)true);
                    break block34;
                }
                message = rb.getString("adap.access_denied.ConfiguredNetAppFilers.action");
                messageType = "Error";
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            }
            catch (Throwable e) {
                e.printStackTrace();
                messageType = "Error";
                if (e.getMessage() != null) {
                    netappAuditMsg = netappAuditMsg + e.getMessage();
                }
                message = netappAuditMsg + "<div id=\"commentForm\" style=\"display:block\"> <a class=\"greenlinktxt\" href=\"javascript:void(0)\" " + "onclick=\"yreg_popLayer('updateNetAppDetails_" + (String)netApp.get("OBJECT_GUID") + "',this, -75, 18) \">" + rb.getString("adap.common.text.policy_update_link.click_here") + "</a></div>";
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", netappAuditMsg, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.Failed_To_configure_EMC", "-"}));
            }
        }
        ClientUtil.setStatusXMLElement(response, messageType, message);
        return mapping.findForward(null);
    }
}

