/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.monitor;

import com.adventnet.sym.adsm.auditing.server.fileintegrity.FIMConstants;
import com.adventnet.sym.adsm.auditing.server.fileintegrity.FileIntegrityManager;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONObject;

public class ConfigureFileIntegrity
extends DispatchAction
implements FIMConstants {
    private static final Logger REPORT_LOGGER = Logger.getLogger("ReportLogger");
    private static final FileIntegrityManager FILE_INTEGRITY_MANAGER = FileIntegrityManager.getInstance();
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();

    public ActionForward viewFIMConfiguredDomains(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "FIMConfiguredDomains";
        if (request.getParameter("statusMessage") != null) {
            forwardPage = "AJAXFIMConfiguredDomains";
        }
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID");
        Hashtable configuredDomainProps = FILE_INTEGRITY_MANAGER.getConfiguredDomainList();
        request.setAttribute("configuredDomain", (Object)configuredDomainProps);
        request.setAttribute("statusMessage", (Object)request.getParameter("statusMessage"));
        return mapping.findForward(forwardPage);
    }

    public ActionForward addNewDomain(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"fileInteg", (ADAPAuthObject)authObj);
        String forwardPage = "ConfigureFileIntegrity";
        Long loginId = (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID");
        ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        ArrayList domainList = authObject.getConfiguredDomainList();
        Hashtable configuredDomainProps = FILE_INTEGRITY_MANAGER.getConfiguredDomainList();
        ArrayList<String> fimConfiguredDomains = new ArrayList<String>();
        Enumeration keys = configuredDomainProps.keys();
        while (keys.hasMoreElements()) {
            Long key = (Long)keys.nextElement();
            ArrayList props = (ArrayList)configuredDomainProps.get(key);
            fimConfiguredDomains.add((String)props.get(1));
        }
        ArrayList<String> fimUnConfiguredDomains = new ArrayList<String>();
        String[] domainNames = new String[domainList.size()];
        for (int i = 0; i < domainList.size(); ++i) {
            Properties domainProp = (Properties)domainList.get(i);
            domainNames[i] = domainProp.getProperty("DOMAIN_NAME");
            if (fimConfiguredDomains.contains(domainNames[i])) continue;
            fimUnConfiguredDomains.add(domainNames[i]);
        }
        request.setAttribute("domainList", fimUnConfiguredDomains);
        if (!fimUnConfiguredDomains.isEmpty()) {
            request.setAttribute("selectedDomain", fimUnConfiguredDomains.get(0));
        } else {
            response.sendError(52);
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward editDomain(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "ConfigureFileIntegrity";
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID");
        request.setAttribute("selectedDomain", (Object)request.getParameter("domainName"));
        request.setAttribute("option", (Object)"edit");
        return mapping.findForward(forwardPage);
    }

    public ActionForward deleteDomainFromFIM(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"fileInteg", (ADAPAuthObject)authObj);
        String forwardPage = "FIMConfiguredDomains";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Long loginId = (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID");
        Long uniqueId = Long.valueOf(request.getParameter("params"));
        String domainName = FileIntegrityManager.getDomainName((Long)uniqueId);
        if (accessType == 32) {
            FILE_INTEGRITY_MANAGER.deleteWithUniqueId(uniqueId, "AUDFIMDomainConfiguration");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "File Integrity", rb.handleGetObject("adap.ConfigureFileIntegrity.audit_entry.Domain_deleted_from_FIM", new String[]{domainName}), 16, 8, "adap.ADAPUserAuditSeverities.audit_name.deleted_FIM_Domain", "-"}));
        } else {
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "File Integrity", rb.handleGetObject("adap.access_denied.ConfigureFileIntegrity.audit_entry.Domain_deleted_from_FIM", new String[]{domainName}), 16, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
        }
        Hashtable configuredDomainProps = FILE_INTEGRITY_MANAGER.getConfiguredDomainList();
        request.setAttribute("configuredDomain", (Object)configuredDomainProps);
        FILE_INTEGRITY_MANAGER.setFimEnabledDomainList();
        return mapping.findForward(forwardPage);
    }

    public ActionForward changeDomainStatusInFIM(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"fileInteg", (ADAPAuthObject)authObj);
        String forwardPage = "FIMConfiguredDomains";
        long uniqueId = Long.valueOf(request.getParameter("uniqueId"));
        int isEnabled = Integer.valueOf(request.getParameter("isEnabled"));
        String domainName = FileIntegrityManager.getDomainName((Long)uniqueId);
        Long loginId = (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID");
        if (accessType == 32) {
            FILE_INTEGRITY_MANAGER.changeDomainStatusInFIM(Long.valueOf(uniqueId), isEnabled);
            String message = rb.handleGetObject("adap.ConfigureFileIntegrity.audit_entry.domain_enabled_for_FIM", new String[]{domainName});
            if (isEnabled == 0) {
                message = rb.handleGetObject("adap.ConfigureFileIntegrity.audit_entry.domain_disabled_for_FIM", new String[]{domainName});
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Integrity", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.updated_FIM", "-"}));
        } else {
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Integrity", rb.getString("adap.access_denied.ConfigureFileIntegrity.domain_enabled_for_fim"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
        }
        Hashtable configuredDomainProps = FILE_INTEGRITY_MANAGER.getConfiguredDomainList();
        request.setAttribute("configuredDomain", (Object)configuredDomainProps);
        FILE_INTEGRITY_MANAGER.setFimEnabledDomainList();
        return mapping.findForward(forwardPage);
    }

    public ActionForward viewFIMDomainBasedConf(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String forwardPage = "FileFolderDivFIM";
        String domainName = request.getParameter("params");
        Hashtable fimEnabledOn = FILE_INTEGRITY_MANAGER.getFimEnabledMachineTypes(domainName);
        Hashtable folderConf = FILE_INTEGRITY_MANAGER.getConfiguration(domainName, "Folder");
        Hashtable fileConf = FILE_INTEGRITY_MANAGER.getConfiguration(domainName, "File");
        request.setAttribute("folderConf", (Object)folderConf);
        request.setAttribute("fileConf", (Object)fileConf);
        request.setAttribute("fimEnabledOn", (Object)fimEnabledOn);
        request.setAttribute("selectedDomain", (Object)domainName);
        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "File Integrity", rb.handleGetObject("adap.ConfigureFileIntegrity.audit_entry.FIM_Configuration_viewd", new String[]{domainName}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.view_FIM", "-"}));
        return mapping.findForward(forwardPage);
    }

    public ActionForward createFIMConfiguration(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"fileInteg", (ADAPAuthObject)authObj);
        JSONObject jsonObj = new JSONObject(request.getParameter("params"));
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String domainName = jsonObj.getString("domainName");
        JSONObject fileMapJSON = jsonObj.getJSONObject("fileMap");
        JSONObject folderMapJSON = jsonObj.getJSONObject("folderMap");
        JSONObject fimEnabledOnMapJSON = jsonObj.getJSONObject("fimEnabledOnMap");
        JSONObject changedMSSelection = jsonObj.getJSONObject("changedMSSelection");
        JSONObject changedDCSelection = jsonObj.getJSONObject("changedDCSelection");
        JSONObject newFileTypes = jsonObj.getJSONObject("newFileTypes");
        JSONObject newFolders = jsonObj.getJSONObject("newFolders");
        String deletedFileTypes = jsonObj.getString("deletedFileTypes");
        String deletedFolders = jsonObj.getString("deletedFolders");
        StringTokenizer deletedList = new StringTokenizer(deletedFileTypes, ",");
        if (accessType == 32) {
            while (deletedList.hasMoreTokens()) {
                FILE_INTEGRITY_MANAGER.deleteWithUniqueId(Long.valueOf(deletedList.nextToken()), "AUDFIMFileConf");
                FILE_INTEGRITY_MANAGER.setConfiguredList("AUDFIMFileConf");
            }
            deletedList = new StringTokenizer(deletedFolders, ",");
            while (deletedList.hasMoreTokens()) {
                FILE_INTEGRITY_MANAGER.deleteWithUniqueId(Long.valueOf(deletedList.nextToken()), "AUDFIMFolderConf");
                FILE_INTEGRITY_MANAGER.setConfiguredList("AUDFIMFolderConf");
            }
            FILE_INTEGRITY_MANAGER.insertOrUpdateFimDomainConfTable(domainName, "adap.common.text.status_msg.success", Integer.valueOf(1));
            if (folderMapJSON.length() != 0) {
                FILE_INTEGRITY_MANAGER.setConfiguration(domainName, folderMapJSON, "AUDFIMFolderConf");
                FILE_INTEGRITY_MANAGER.setConfiguredList("AUDFIMFolderConf");
                REPORT_LOGGER.log(Level.INFO, "FIM->folderMap" + folderMapJSON);
            }
            if (fileMapJSON.length() != 0) {
                FILE_INTEGRITY_MANAGER.setConfiguration(domainName, fileMapJSON, "AUDFIMFileConf");
                FILE_INTEGRITY_MANAGER.setConfiguredList("AUDFIMFileConf");
                REPORT_LOGGER.log(Level.INFO, "FIM->fileMap" + fileMapJSON);
            }
            if (fimEnabledOnMapJSON.length() != 0) {
                FILE_INTEGRITY_MANAGER.setConfiguration(domainName, fimEnabledOnMapJSON, "AUDFIMSeverConf");
                REPORT_LOGGER.log(Level.INFO, "FIM->fimEnabledOnMap" + fimEnabledOnMapJSON);
            }
            if (changedMSSelection.length() != 0) {
                FILE_INTEGRITY_MANAGER.updateServerSelectionForFIM("AUDComputerEventRead", "COMPUTER_ID", changedMSSelection);
                REPORT_LOGGER.log(Level.INFO, "FIM->fimEnabledOnMap" + changedMSSelection);
            }
            if (changedDCSelection.length() != 0) {
                FILE_INTEGRITY_MANAGER.updateServerSelectionForFIM("AUDDCEventRead", "DOMAIN_CONTROLLER_ID", changedDCSelection);
                REPORT_LOGGER.log(Level.INFO, "FIM->fimEnabledOnMap" + changedDCSelection);
            }
            if (changedMSSelection.length() != 0 || changedDCSelection.length() != 0) {
                EventDataUtil.updateFIMFlag((String)domainName);
            }
            if (newFileTypes.length() != 0) {
                FILE_INTEGRITY_MANAGER.addNewData("AUDFIMFileConf", domainName, newFileTypes);
                FILE_INTEGRITY_MANAGER.setConfiguredList("AUDFIMFileConf");
                REPORT_LOGGER.log(Level.INFO, "FIM->newFileTypes" + newFileTypes);
            }
            if (newFolders.length() != 0) {
                FILE_INTEGRITY_MANAGER.addNewData("AUDFIMFolderConf", domainName, newFolders);
                FILE_INTEGRITY_MANAGER.setConfiguredList("AUDFIMFolderConf");
                REPORT_LOGGER.log(Level.INFO, "FIM->newFolders" + newFolders);
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Integrity", rb.handleGetObject("adap.ConfigureFileIntegrity.audit_entry.FIM_configured_successfully", new String[]{domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.confured_FIM", "-"}));
        } else {
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Integrity", rb.getString("adap.access_denied.ConfigureFileIntegrity.audit_entry.FIM_configured_successfully"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.confured_FIM", "-"}));
        }
        FILE_INTEGRITY_MANAGER.setFIMEnabledServers();
        FILE_INTEGRITY_MANAGER.setFimEnabledDomainList();
        return mapping.findForward(null);
    }

    public ActionForward viewConfiguredServers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArrayList configuredServersList;
        int[] count;
        String forwardPage = "ViewConfiguredServers";
        JSONObject jsonObj = new JSONObject(request.getParameter("params"));
        String domainName = jsonObj.getString("domainName");
        String searchString = jsonObj.getString("searchString");
        int startIndex = jsonObj.getInt("startIndex");
        int range = jsonObj.getInt("range");
        int machineType = jsonObj.getInt("machineType");
        if (machineType == 0) {
            count = FILE_INTEGRITY_MANAGER.getConfiguredDCCount(domainName, searchString);
            configuredServersList = FILE_INTEGRITY_MANAGER.getConfiguredDCs(domainName, searchString, startIndex, range);
        } else {
            count = FILE_INTEGRITY_MANAGER.getConfiguredMemberServersCount(domainName, searchString);
            configuredServersList = FILE_INTEGRITY_MANAGER.getConfiguredMemberServers(domainName, searchString, startIndex, range);
        }
        request.setAttribute("configuredServersList", (Object)configuredServersList);
        request.setAttribute("domainName", (Object)domainName);
        request.setAttribute("searchString", (Object)searchString);
        request.setAttribute("totalRowcount", (Object)count[0]);
        request.setAttribute("fimConfiguredCount", (Object)count[1]);
        request.setAttribute("startIndex", (Object)startIndex);
        request.setAttribute("range", (Object)range);
        request.setAttribute("machineType", (Object)machineType);
        return mapping.findForward(forwardPage);
    }

    public ActionForward selectFolder(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String loadAll = request.getParameter("loadAll");
        String folderPath = request.getParameter("folderPath");
        String forward = "selectFolder";
        try {
            TreeMap<String, String> dirList = new TreeMap<String, String>();
            if (loadAll.equalsIgnoreCase("true")) {
                File[] roots = File.listRoots();
                for (int i = 0; i < roots.length; ++i) {
                    dirList.put(roots[i].toString(), roots[i].toString());
                }
            } else {
                File dir = new File(folderPath);
                File[] listDir = dir.listFiles();
                if (listDir != null) {
                    for (int i = 0; i < listDir.length; ++i) {
                        if (!listDir[i].isDirectory()) continue;
                        dirList.put(listDir[i].getName(), listDir[i].getPath());
                    }
                }
            }
            request.setAttribute("directoryList", dirList);
            request.setAttribute("loadAll", (Object)loadAll);
            if (dirList.isEmpty()) {
                response.sendError(50);
                forward = null;
            }
        }
        catch (Exception e) {
            response.sendError(50);
            forward = null;
            e.printStackTrace();
        }
        return mapping.findForward(forward);
    }

    public ActionForward validatefolder(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String sysroot = System.getenv("SystemDrive");
            String folderName = request.getParameter("folderName");
            String domainName = request.getParameter("domainName");
            String deletedList = request.getParameter("deletedList");
            String[] localString = new String[]{"Program Files", "Program Files (x86)", "windows", ""};
            String[] replaceString = new String[]{"%ProgramFiles%", "%ProgramFiles% (x86)", "%SystemRoot%", "%SystemDrive%\\"};
            folderName = folderName.toLowerCase();
            for (int i = 0; i < localString.length; ++i) {
                String path = sysroot.toLowerCase() + "\\" + localString[i].toLowerCase();
                if (!folderName.startsWith(path)) continue;
                folderName = folderName.replace(path, replaceString[i]);
                break;
            }
            if (FILE_INTEGRITY_MANAGER.isDuplicate(domainName, "AUDFIMFolderConf", "FOLDER_PATH", folderName, deletedList)) {
                response.sendError(51);
            }
            response.getWriter().println(folderName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(null);
    }

    public ActionForward validateFileType(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String fileType = request.getParameter("fileType");
            String domainName = request.getParameter("domainName");
            String deletedList = request.getParameter("deletedList");
            fileType = fileType.toLowerCase();
            if (FILE_INTEGRITY_MANAGER.isDuplicate(domainName, "AUDFIMFileConf", "FILE_TYPE", fileType, deletedList)) {
                response.sendError(51);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(null);
    }
}

