/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.monitor;

import com.adventnet.sym.adsm.auditing.server.monitor.AuditActionHandler;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.monitor.model.AuditActionBean;
import com.adventnet.sym.adsm.auditing.webclient.monitor.util.AuditActionClientUtil;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class UpdateAuditAction
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuditActionBean bean = (AuditActionBean)form;
        String forwardString = "modify";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"advConf", (ADAPAuthObject)authObj);
        String selectedTab = request.getParameter("selectedTab");
        if (selectedTab != null && selectedTab.equalsIgnoreCase("fileAudit")) {
            forwardString = "modifyFileAction";
        }
        try {
            if (accessType == 32) {
                Long actionId = (Long)bean.get("ACTION_ID");
                Long categoryId = (Long)bean.get("CATEGORY_ID");
                Enumeration enumeration = request.getParameterNames();
                TreeMap actionGroupsMap = AuditActionClientUtil.getProperties(enumeration, request);
                HashMap<String, Object> actionMap = new HashMap<String, Object>();
                actionMap.put("ACTION_NAME", (String)bean.get("ACTION_NAME"));
                actionMap.put("ACTION_DESCRIPTION", (String)bean.get("ACTION_DESCRIPTION"));
                actionMap.put("ACTION_GROUPS", actionGroupsMap);
                bean.setCorrelationProperties(request, actionMap);
                boolean status = AuditActionHandler.updateAction(actionMap, (Long)actionId);
                if (status) {
                    forwardString = "view";
                    request.setAttribute("categoryId", (Object)categoryId);
                    if (selectedTab != null && selectedTab.equalsIgnoreCase("fileAudit")) {
                        forwardString = "viewFileAction";
                    }
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.handleGetObject("adap.UpdateAuditAction.audit_entry.successfully_updated_action", new String[]{(String)bean.get("ACTION_NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.updated_audit_actions", "-"}));
                }
            } else {
                forwardString = "view";
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.getString("adap.access_denied.UpdateAuditAction.audit_entry.updated_action"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            }
        }
        catch (Exception e) {
            request.setAttribute("errorMsg", rb.handleGetObject("adap.SaveAuditAction.Error_in_saving_action_details"));
            e.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.handleGetObject("adap.UpdateAuditAction.audit_entry.failed_to_update_action", new String[]{(String)bean.get("ACTION_NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.updated_audit_actions", "-"}));
        }
        return mapping.findForward(forwardString);
    }
}

