/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.monitor;

import com.adventnet.sym.adsm.auditing.server.config.ServerConfigAPI;
import com.adventnet.sym.adsm.auditing.server.delegation.GpoHandler;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.MSHandler;
import com.adventnet.sym.adsm.common.server.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.webclient.util.CommonBeanUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;

public class ViewComputers
extends Action {
    protected static Logger logger = Logger.getLogger("ReportLogger");

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String forwardPage = "viewComputers";
        DynaActionForm bean = (DynaActionForm)form;
        HttpSession session = request.getSession();
        String domainName = request.getParameter("domainName");
        if (domainName == null) {
            domainName = (String)bean.get("DOMAIN_NAME");
        }
        String selectedTile = request.getParameter("selectedTile");
        logger.log(Level.INFO, "selectedTile is " + selectedTile);
        if (request.getParameter("init") != null) {
            bean.initialize(mapping);
            if (selectedTile.equalsIgnoreCase("listofWS")) {
                bean.set("RANGE", (Object)100);
                bean.set("TO_INDEX", (Object)100);
            }
        }
        if ("".equals(domainName) || DomainDetailsAPI.getDomainName((String)domainName) == null) {
            domainName = DomainDetailsAPI.getDefaultDomainName();
        }
        if ("".equals(domainName)) {
            domainName = (String)session.getAttribute("MONITOR_DOMAIN_NAME");
        } else {
            session.setAttribute("MONITOR_DOMAIN_NAME", (Object)domainName);
        }
        if (request.getParameter("clearSearch") != null) {
            bean.set("searchString", (Object)"");
            bean.set("PAGE_NUMBER", (Object)"1");
            bean.set("FROM_INDEX", (Object)1);
        }
        HashMap valueMap = ViewComputers.getSearchString(request, bean);
        HashMap<String, Object> addnParamsMap = new HashMap<String, Object>();
        addnParamsMap.put("sortColumn", (String)bean.get("sortColumn"));
        addnParamsMap.put("sortOrder", (String)bean.get("sortOrder"));
        addnParamsMap.put("tableName", (String)bean.get("tableName"));
        addnParamsMap.put("noOfObjects", bean.get("RANGE"));
        addnParamsMap.put("startIndex", bean.get("FROM_INDEX"));
        String action = (String)bean.get("action");
        if (action == null) {
            action = "All";
        }
        int[] machineTypes = MSHandler.getMachineTypes((String)selectedTile, (String)action);
        int count = ServerConfigAPI.getConfiguredServerCount((String)domainName, (String)((String)valueMap.get("searchCriteria")), (String)((String)valueMap.get("searchMsgCri")), (int[])machineTypes, null);
        ArrayList list = new ArrayList();
        if (count > 0) {
            list = ServerConfigAPI.getConfiguredServers((String)domainName, addnParamsMap, (String)((String)valueMap.get("searchCriteria")), (String)((String)valueMap.get("searchMsgCri")), null, (int[])machineTypes, (Integer)count);
        }
        Boolean gpoStatus = null;
        if ((machineTypes[0] & 0x1000) == 4096 || (machineTypes[0] & 0x2000) == 8192 || (machineTypes[0] & 0x10) == 16 || (machineTypes[0] & 0x20) == 32) {
            gpoStatus = GpoHandler.getGpoStatus((String)domainName, (Integer)machineTypes[0]);
        }
        Long loginId = (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID");
        ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        ArrayList domainList = authObject.getConfiguredDomainList();
        String[] domainNames = new String[domainList.size()];
        for (int i = 0; i < domainList.size(); ++i) {
            Properties domainProp = (Properties)domainList.get(i);
            domainNames[i] = domainProp.getProperty("DOMAIN_NAME");
        }
        String uvhString = "AUDCVConfig:cv_id:10003";
        Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
        ArrayList columnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvId, Boolean.valueOf(true));
        String gpoGuids = "";
        if (gpoStatus != null) {
            PolicyHandler polHandler = new PolicyHandler();
            boolean auditDDCPolicyState = polHandler.getAuditPolicy(domainName, "{6AC1786C-016F-11D2-945F-00C04fB984F9}", false);
            if (!auditDDCPolicyState && !gpoStatus.booleanValue()) {
                gpoGuids = gpoGuids + "{6AC1786C-016F-11D2-945F-00C04fB984F9}";
                gpoGuids = gpoGuids + ",";
                gpoGuids = gpoGuids + "{31B2F340-016D-11D2-945F-00C04FB984F9}";
            } else if (!gpoStatus.booleanValue()) {
                gpoGuids = gpoGuids + "{31B2F340-016D-11D2-945F-00C04FB984F9}";
            } else if (!auditDDCPolicyState) {
                gpoGuids = gpoGuids + "{6AC1786C-016F-11D2-945F-00C04fB984F9}";
            }
        }
        request.setAttribute("gpoGuids", (Object)gpoGuids);
        request.setAttribute("columnList", (Object)columnList);
        bean.set("domainNames", (Object)domainNames);
        bean.set("DOMAIN_NAME", (Object)domainName);
        request.setAttribute("PolicyStatus", (Object)gpoStatus);
        request.setAttribute("count", (Object)count);
        request.setAttribute("list", (Object)list);
        if (selectedTile.equalsIgnoreCase("listofWS")) {
            ArrayList<String> rangeList = new ArrayList<String>();
            rangeList.add("100");
            rangeList.add("200");
            rangeList.add("500");
            rangeList.add("1000");
            request.setAttribute("RangeList", rangeList);
        }
        if (request.getParameter("charSearch") != null) {
            request.setAttribute("charSearch", (Object)"true");
        }
        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Configuration", rb.getString("adap.ViewComputers.audit_entry.Configuration_tab_Viewd"), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.configured_computers_viewed", "-"}));
        return mapping.findForward(forwardPage);
    }

    public static HashMap getSearchString(HttpServletRequest request, DynaActionForm bean) throws Exception {
        String uvhString = "AUDCVConfig:cv_id:10003";
        Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
        HashMap valueMap = CommonBeanUtil.getMSSearchString(request, bean, cvId);
        String searchString = (String)valueMap.get("searchString");
        logger.log(Level.INFO, "Search valueMap" + valueMap);
        if (searchString != null) {
            bean.set("searchString", (Object)searchString);
        }
        return valueMap;
    }
}

