/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.monitor;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.compliance.DataCruncher;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ExportUtil;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.compliance.ComplianceReportHandler;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.objects.ObjectUpdateHandler;
import com.adventnet.sym.adsm.common.server.util.ADSMPersUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class ViewObjects
extends DispatchAction {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static String ldapQuery = "";
    private static String base_DN = "";
    private static Long generationId = 0L;
    private String objClass = "";
    private static String select = "";

    public ObjectClass setObjClass() {
        ObjectClass dirObjectClass = null;
        if (ldapQuery.toLowerCase().indexOf("objectcategory=person") != -1 && ldapQuery.toLowerCase().indexOf("objectclass=user") != -1) {
            dirObjectClass = DirectoryObjectAPI.getInstance().getObjectClass("user");
            this.objClass = "user";
        } else if (ldapQuery.toLowerCase().indexOf("objectcategory=group") != -1 || ldapQuery.toLowerCase().indexOf("objectclass=group") != -1) {
            dirObjectClass = DirectoryObjectAPI.getInstance().getObjectClass("group");
            this.objClass = "group";
        } else if (ldapQuery.toLowerCase().indexOf("objectcategory=organizationalunit") != -1 || ldapQuery.toLowerCase().indexOf("objectclass=organizationalunit") != -1) {
            dirObjectClass = DirectoryObjectAPI.getInstance().getObjectClass("organizationalUnit");
            this.objClass = "organizationalUnit";
        } else if (ldapQuery.toLowerCase().indexOf("objectcategory=computer") != -1 || ldapQuery.toLowerCase().indexOf("objectclass=computer") != -1) {
            dirObjectClass = DirectoryObjectAPI.getInstance().getObjectClass("computer");
            this.objClass = "computer";
        }
        return dirObjectClass;
    }

    public ActionForward viewObjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String reportId = "";
        String objectClass = request.getParameter("objectClass");
        HttpSession session = request.getSession();
        String domainName = request.getParameter("domainName");
        String selectType = request.getParameter("selectType");
        String tableName = "";
        String displayText = "";
        ObjectClass dirObjectClass = null;
        String defaultNamingContext = request.getParameter("defaultNamingContext");
        if (domainName != null) {
            session.setAttribute("MONITOR_DOMAIN_NAME", (Object)domainName);
        }
        String forwardName = "viewObjects";
        String searchPattern = null;
        String que = request.getParameter("que");
        String ldapQ = request.getParameter("ldapQ");
        if (que == null) {
            que = "0";
        }
        try {
            String deselectedObjectsStr;
            HashMap<String, String> objectMap;
            String selectedObjectsStr;
            DynaActionForm bean = (DynaActionForm)form;
            String cvIdStr = request.getParameter("cv_id");
            Long cvID = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)("AUDCVConfig:cv_id:" + cvIdStr));
            Long[] cvIdsDetails = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String[])new String[]{"AUDCVConfig:cv_id:9", "AUDCVConfig:cv_id:10", "AUDCVConfig:cv_id:11", "AUDCVConfig:cv_id:12", "AUDCVConfig:cv_id:15", "AUDCVConfig:cv_id:18", "AUDCVConfig:cv_id:19", "AUDCVConfig:cv_id:20", "AUDCVConfig:cv_id:21", "AUDCVConfig:cv_id:23", "AUDCVConfig:cv_id:25"});
            ArrayList<Long> cvIds = new ArrayList<Long>(Arrays.asList(cvIdsDetails));
            if (request.getParameter("init") != null) {
                bean.initialize(mapping);
                if (cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:895") || cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:18")) {
                    bean.set("RANGE", (Object)100);
                    bean.set("TO_INDEX", (Object)100);
                }
            }
            reportId = request.getParameter("reportId");
            if (cvIds.contains(cvID)) {
                String ldap = request.getParameter("ldap");
                if (ldap != null) {
                    if (cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:15")) {
                        ldapQuery = "(&(objectCategory=person)(objectClass=user))";
                        ldapQ = "15";
                    } else if (cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:9") || cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:10") || cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:11") || cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:12") || cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:18") || cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:19") || cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:20") || cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:21")) {
                        ldapQuery = "(objectCategory=computer)";
                        ldapQ = "9";
                    } else if (cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:23")) {
                        ldapQuery = "(objectCategory=organizationalunit)";
                        ldapQ = "23";
                    } else if (cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:25")) {
                        ldapQuery = "(objectCategory=group)";
                        ldapQ = "25";
                    }
                    generationId = 0L;
                    base_DN = defaultNamingContext;
                } else {
                    String completed = ObjectUpdateHandler.getCompleted();
                    request.setAttribute("completed", (Object)completed);
                }
                request.setAttribute("ldap", (Object)ldap);
            } else {
                request.setAttribute("completed", null);
                request.setAttribute("ldap", null);
            }
            if (objectClass != null) {
                if (!cvIds.contains(cvID)) {
                    dirObjectClass = DirectoryObjectAPI.getInstance().getObjectClass(objectClass);
                    displayText = dirObjectClass.getDisplayText();
                    tableName = dirObjectClass.getBaseTable();
                } else {
                    if (cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:15")) {
                        dirObjectClass = this.setObjClass();
                        if (dirObjectClass == null) {
                            displayText = rb.getString("adap.ADMPObjects.display_text.User");
                            this.objClass = "user";
                        }
                    } else if (cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:23")) {
                        dirObjectClass = this.setObjClass();
                        if (dirObjectClass == null) {
                            displayText = rb.getString("adap.ADMPObjects.display_text.Organizational_Unit");
                            this.objClass = "organizationalUnit";
                        }
                    } else if (cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:25")) {
                        dirObjectClass = this.setObjClass();
                        if (dirObjectClass == null) {
                            displayText = rb.getString("adap.ADMPObjects.display_text.Group");
                            this.objClass = "group";
                        }
                    } else if ((cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:12") || cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:9") || cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:10") || cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:11") || cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:18") || cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:19") || cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:20") || cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:21")) && (dirObjectClass = this.setObjClass()) == null) {
                        displayText = rb.getString("adap.common.text.computer");
                        this.objClass = "computer";
                    }
                    if (dirObjectClass != null) {
                        displayText = dirObjectClass.getDisplayText();
                        tableName = dirObjectClass.getBaseTable();
                    }
                }
            }
            HashMap selectedObjectsMap = new HashMap();
            if (!selectType.equalsIgnoreCase("radio")) {
                selectedObjectsMap = (HashMap)bean.get("selectedObjectsMap");
            }
            ArrayList selectedObjectsList = new ArrayList();
            selectedObjectsList = !cvIds.contains(cvID) ? (ArrayList)selectedObjectsMap.get(objectClass) : (ArrayList)selectedObjectsMap.get(this.objClass);
            if (selectedObjectsList == null) {
                selectedObjectsList = new ArrayList();
            }
            if ((selectedObjectsStr = request.getParameter("selectedObjectsStr")) != null && !"".equals(selectedObjectsStr)) {
                DataObject ob;
                StringTokenizer objectTokenizer = new StringTokenizer(request.getParameter("selectedObjectsStr"), ",");
                ArrayList<String> list = new ArrayList<String>();
                while (objectTokenizer.hasMoreTokens()) {
                    list.add(objectTokenizer.nextToken());
                }
                Iterator iter = null;
                if (!cvIds.contains(cvID)) {
                    iter = DirectoryObjectAPI.getInstance().getObjectRows(null, list, objectClass);
                } else if (dirObjectClass != null && !(ob = DirectoryObjectAPI.getInstance().getObjectRowsGenerationId(list, this.objClass, generationId, cvID, null)).isEmpty()) {
                    iter = ob.getRows(tableName);
                }
                if (iter != null) {
                    while (iter.hasNext()) {
                        Row row = (Row)iter.next();
                        objectMap = new HashMap<String, String>();
                        if (row.getTableName().contains("ADSMShareGeneralDetails")) {
                            objectMap.put("selectedObjects", (String)row.get("LOCATION"));
                            objectMap.put("selectedObjectNames", (String)row.get("LOCATION"));
                        } else if (row.getTableName().contains("ADSMPrinterGeneralDetails")) {
                            objectMap.put("selectedObjects", (String)row.get("PRINTER_NAME"));
                            objectMap.put("selectedObjectNames", (String)row.get("PRINTER_NAME"));
                        } else {
                            objectMap.put("selectedObjects", (String)row.get("OBJECT_GUID"));
                            objectMap.put("selectedObjectNames", (String)row.get("NAME"));
                        }
                        if (selectedObjectsList.contains(objectMap)) continue;
                        selectedObjectsList.add(objectMap);
                    }
                } else {
                    HashMap<String, String> objectMap2 = new HashMap<String, String>();
                    objectMap2.put("selectedObjects", selectedObjectsStr);
                    objectMap2.put("selectedObjectNames", selectedObjectsStr);
                    selectedObjectsList.add(objectMap2);
                }
            }
            if ((deselectedObjectsStr = request.getParameter("deselectedObjectsStr")) != null && selectedObjectsList.size() > 0) {
                StringTokenizer deselectTokenizer = new StringTokenizer(request.getParameter("deselectedObjectsStr"), ",");
                while (deselectTokenizer.hasMoreTokens()) {
                    String deselectedGUID = deselectTokenizer.nextToken();
                    for (int i = 0; i < selectedObjectsList.size(); ++i) {
                        objectMap = (HashMap<String, String>)selectedObjectsList.get(i);
                        if (!deselectedGUID.equals((String)objectMap.get("selectedObjects"))) continue;
                        selectedObjectsList.remove(i);
                    }
                }
            }
            if (request.getParameter("allObjectSelected") != null && request.getParameter("allObjectSelected").equalsIgnoreCase("true")) {
                ArrayList objectsList = new ArrayList();
                objectsList = !cvIds.contains(cvID) ? DirectoryObjectAPI.getInstance().getObjects(defaultNamingContext, objectClass, searchPattern, -1, 0, cvID, Long.valueOf(0L)) : DirectoryObjectAPI.getInstance().getObjectsGenerationId(this.objClass, searchPattern, generationId, cvID);
                selectedObjectsList = new ArrayList();
                for (int i = 0; i < objectsList.size(); ++i) {
                    HashMap listMap = (HashMap)objectsList.get(i);
                    HashMap<String, String> objMap = new HashMap<String, String>();
                    objMap.put("selectedObjects", objectClass.equalsIgnoreCase("printer") ? (String)listMap.get("NAME") : (String)listMap.get("OBJECT_GUID"));
                    objMap.put("selectedObjectNames", (String)listMap.get("NAME"));
                    selectedObjectsList.add(objMap);
                }
            } else if (request.getParameter("allObjectSelected") != null && request.getParameter("allObjectSelected").equalsIgnoreCase("false")) {
                selectedObjectsList = new ArrayList();
            }
            if (!cvIds.contains(cvID)) {
                selectedObjectsMap.put(objectClass, selectedObjectsList);
            } else {
                selectedObjectsMap.put(this.objClass, selectedObjectsList);
            }
            bean.set("selectedObjectsMap", (Object)selectedObjectsMap);
            String guidName = request.getParameter("guidName");
            String searchTxt = request.getParameter("searchTxt");
            if (searchTxt != null && !"".equalsIgnoreCase(searchTxt)) {
                searchPattern = !cvIds.contains(cvID) ? CommonUtil.getSearchString((String)searchTxt) : (searchTxt.contains("*") ? searchTxt : "*" + searchTxt + "*");
            }
            ArrayList rowsList = new ArrayList();
            ArrayList rowList = new ArrayList();
            Long count = 0L;
            count = !cvIds.contains(cvID) ? Long.valueOf(DirectoryObjectAPI.getInstance().getObjectsCount(defaultNamingContext, objectClass, searchPattern, cvID)) : Long.valueOf(DirectoryObjectAPI.getInstance().getObjectsCountGenerationId(this.objClass, searchPattern, generationId, cvID));
            if (bean.get("totalObjects") == null) {
                bean.set("totalObjects", (Object)count.intValue());
            }
            if (count < (long)((Integer)bean.get("FROM_INDEX")).intValue()) {
                bean.set("FROM_INDEX", (Object)1);
                bean.set("PAGE_NUMBER", (Object)"1");
            }
            if (count > 0L) {
                if (!cvIds.contains(cvID)) {
                    rowsList = DirectoryObjectAPI.getInstance().getObjects(defaultNamingContext, objectClass, searchPattern, ((Integer)bean.get("FROM_INDEX")).intValue(), ((Integer)bean.get("RANGE")).intValue(), cvID, count);
                } else {
                    int c = (Integer)bean.get("FROM_INDEX") + (Integer)bean.get("RANGE");
                    rowList = DirectoryObjectAPI.getInstance().getObjectsGenerationId(this.objClass, searchPattern, generationId, cvID);
                    rowsList = new ArrayList();
                    for (int i = ((Integer)bean.get("FROM_INDEX")).intValue(); i < c && (long)i <= count; ++i) {
                        rowsList.add(rowList.get(i - 1));
                    }
                }
            }
            bean.set("selectType", (Object)selectType);
            request.setAttribute("objectClass", (Object)objectClass);
            request.setAttribute("displayText", (Object)displayText);
            request.setAttribute("tableName", (Object)tableName);
            request.setAttribute("selectType", (Object)selectType);
            request.setAttribute("cvId", (Object)Long.parseLong(cvIdStr));
            request.setAttribute("reportId", (Object)reportId);
            request.setAttribute("guidName", (Object)guidName);
            request.setAttribute("defaultNamingContext", (Object)defaultNamingContext);
            request.setAttribute("searchTxt", (Object)searchTxt);
            request.setAttribute("count", (Object)count);
            request.setAttribute("rowsList", rowsList);
            request.setAttribute("ldapQuery", (Object)ldapQuery);
            request.setAttribute("base_dn", (Object)base_DN);
            request.setAttribute("que", (Object)que);
            request.setAttribute("ldapQ", (Object)ldapQ);
            request.setAttribute("select", (Object)select);
            request.setAttribute("cvIds", cvIds);
            if (cvIds.contains(cvID)) {
                request.setAttribute("isLdap", (Object)true);
            } else {
                request.setAttribute("isLdap", (Object)false);
            }
            if (cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:895") || cvID == DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:18")) {
                ArrayList<String> rangeList = new ArrayList<String>();
                rangeList.add("100");
                rangeList.add("200");
                rangeList.add("500");
                rangeList.add("1000");
                request.setAttribute("isWorkStation", (Object)true);
                request.setAttribute("RangeList", rangeList);
            } else {
                request.setAttribute("isWorkStation", (Object)false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (request.getParameter("status") != null) {
            return null;
        }
        return mapping.findForward(forwardName);
    }

    public void stopQuery(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ObjectUpdateHandler.setCompleted();
    }

    public void executeQuery(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ldapQuery = request.getParameter("query");
        base_DN = request.getParameter("base_dn");
        select = request.getParameter("select");
        base_DN = CommonUtil.escapeDN((String)base_DN);
        String CVID = request.getParameter("cvId");
        Long cvId = Long.valueOf(CVID);
        ArrayList<Integer> report_id = new ArrayList<Integer>();
        if (ldapQuery.toLowerCase().indexOf("objectclass=user") != -1 || ldapQuery.toLowerCase().indexOf("objectcategory=user") != -1) {
            report_id.add(15);
        }
        if (ldapQuery.toLowerCase().indexOf("objectcategory=group") != -1 || ldapQuery.toLowerCase().indexOf("objectclass=group") != -1) {
            report_id.add(109);
        }
        if (ldapQuery.toLowerCase().indexOf("objectcategory=organizationalunit") != -1 || ldapQuery.toLowerCase().indexOf("objectclass=organizationalunit") != -1) {
            report_id.add(701);
        }
        if (ldapQuery.toLowerCase().indexOf("objectcategory=computer") != -1 || ldapQuery.toLowerCase().indexOf("objectclass=computer") != -1) {
            report_id.add(210);
        }
        HttpSession session = request.getSession();
        String domainName = (String)session.getAttribute("MONITOR_DOMAIN_NAME");
        ObjectUpdateHandler.runDailyReport((String)domainName, (Long)1L, report_id, (boolean)false, null, null, null, (String)ldapQuery, (String)base_DN);
        generationId = ObjectUpdateHandler.getGenerationID();
    }

    public ActionForward updateObjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = "";
        String messageType = "Success";
        String argObjectVal = "";
        String statusVal = "";
        String forwardStr = "updateObject";
        HttpSession session = request.getSession();
        String domainName = (String)session.getAttribute("MONITOR_DOMAIN_NAME");
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String objectType = request.getParameter("objectType");
        if (objectType != null) {
            if (objectType.equalsIgnoreCase("user")) {
                argObjectVal = "Users";
                statusVal = rb.getString("adap.domain_settings.update_domain_details.actionname.users");
            } else if (objectType.equalsIgnoreCase("group")) {
                argObjectVal = "Group";
                statusVal = rb.getString("adap.domain_settings.update_domain_details.actionname.groups");
            } else if (objectType.equalsIgnoreCase("computer")) {
                argObjectVal = "Computers";
                statusVal = rb.getString("adap.domain_settings.update_domain_details.actionname.computers");
            } else if (objectType.equalsIgnoreCase("organizationalUnit")) {
                argObjectVal = "OU";
                statusVal = rb.getString("adap.domain_settings.update_domain_details.actionname.organizational_units");
            } else if (objectType.equalsIgnoreCase("share")) {
                argObjectVal = "Share";
                statusVal = rb.getString("adap.domain_settings.update_domain_details.actionname.shares");
            } else {
                argObjectVal = "GPO";
                statusVal = rb.getString("adap.domain_settings.update_domain_details.actionname.group_policy_objects");
            }
        }
        String[] selectedUpdates = new String[]{argObjectVal};
        message = rb.handleGetObject("adap.ViewObjects.Reload_page_after_sometime_to", new String[]{statusVal});
        try {
            DomainHandler.updateDomain((String)domainName, (Long)loginId, (String[])selectedUpdates);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", message + "\n" + rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Objects_updated_manually", "-"}));
        }
        catch (Exception ex) {
            message = ex.getMessage();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ViewObjects.audit_entry.problem_updating_domain_objects", new String[]{domainName}), 8, 16, message, "adap.ADAPUserAuditSeverities.audit_name.Objects_updated_manually", "-"}));
            ex.printStackTrace();
        }
        ClientUtil.setStatusXMLElement(response, messageType, message);
        return null;
    }

    public ActionForward getViewObjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        int startindex = Integer.parseInt(request.getParameter("startindex"));
        int pagesize = Integer.parseInt(request.getParameter("pagesize"));
        String searchStr = "%" + request.getParameter("searchval") + "%";
        String domainName = (String)session.getAttribute("MONITOR_DOMAIN_NAME");
        String defaultNamingContext = DomainDetailsAPI.getDefaultNamingContext((String)domainName);
        int totalDomainObj = DirectoryObjectAPI.getInstance().getDomainObjectsCount((String)session.getAttribute("MONITOR_DOMAIN_NAME"), "user", null, Long.valueOf(1L));
        int totalObj = DirectoryObjectAPI.getInstance().getObjectsCount(defaultNamingContext, "user", searchStr, Long.valueOf(1L));
        Long total = totalDomainObj;
        ArrayList rowsList = DirectoryObjectAPI.getInstance().getObjects(defaultNamingContext, "user", searchStr, startindex, pagesize, Long.valueOf(1L), total);
        ClientUtil.setACLROWSXMLElement(response, rowsList, totalObj);
        return null;
    }

    public ActionForward getCustomTimePeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String searchStr = request.getParameter("searchval");
        ArrayList list = new ArrayList();
        try {
            Criteria crit = null;
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDCustomPeriod", crit);
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDCustomPeriod", (String)"CLIENT_NAME"), (Object)searchStr, 12);
            Iterator reportIterator = dataObject.getRows("AUDCustomPeriod", criteria);
            while (reportIterator.hasNext()) {
                Row row = (Row)reportIterator.next();
                HashMap<String, Object> favMap = new HashMap<String, Object>();
                favMap.put("UNIQUE_ID", (Long)row.get("UNIQUE_ID"));
                favMap.put("CLIENT_NAME", (String)row.get("CLIENT_NAME"));
                favMap.put("SERVER_NAME", (String)row.get("SERVER_NAME"));
                favMap.put("START_TIME", (String)row.get("START_TIME"));
                favMap.put("START_HOUR", (String)row.get("START_HOUR"));
                favMap.put("END_TIME", (String)row.get("END_TIME"));
                favMap.put("END_HOUR", (String)row.get("END_HOUR"));
                list.add(favMap);
            }
            ClientUtil.setACLROWSXMLElement(response, list, 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward getUserSearch(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String domainName = null;
        if (request.getParameter("domainName") != null) {
            domainName = request.getParameter("domainName");
            request.getSession().setAttribute("MONITOR_DOMAIN_NAME", (Object)domainName);
        } else {
            domainName = (String)request.getSession().getAttribute("MONITOR_DOMAIN_NAME");
        }
        String searchString = request.getParameter("searchString");
        try {
            String jsonText = ComplianceReportHandler.getUsersList(domainName, searchString, request).toString();
            response.setContentType("text/xml");
            PrintWriter writer = response.getWriter();
            writer.print(jsonText);
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward getCategoriesSum(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String domainName = request.getParameter("domainName");
        request.getSession().setAttribute("MONITOR_DOMAIN_NAME", (Object)domainName);
        int timePeriod = Integer.parseInt(request.getParameter("timePeriod"));
        Long categoryType = Long.parseLong(request.getParameter("categoryType"));
        try {
            HashMap<String, Object> paramsMap = ComplianceReportHandler.getParamsMap(domainName, timePeriod, categoryType, false, 0L, 0L);
            String jsonText = ComplianceReportHandler.getCategorySum(domainName, categoryType, paramsMap, false, request);
            response.setContentType("text/xml");
            PrintWriter writer = response.getWriter();
            writer.print(jsonText);
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward getSearchResults(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String domainName = request.getParameter("domainName");
        request.getSession().setAttribute("MONITOR_DOMAIN_NAME", (Object)domainName);
        int timePeriod = Integer.parseInt(request.getParameter("timePeriod"));
        try {
            HashMap<String, Object> paramsMap = ComplianceReportHandler.getParamsMap(domainName, timePeriod, 5L, false, 0L, 0L);
            String jsonText = ComplianceReportHandler.getCategorySum(domainName, 0L, paramsMap, true, request);
            response.setContentType("text/xml");
            PrintWriter writer = response.getWriter();
            writer.print(jsonText);
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward getCategorySumOnChange(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String domainName = request.getParameter("domainName");
        request.getSession().setAttribute("MONITOR_DOMAIN_NAME", (Object)domainName);
        int timePeriod = Integer.parseInt(request.getParameter("timePeriod"));
        Long categoryType = Long.parseLong(request.getParameter("categoryType"));
        Long categoryId = Long.parseLong(request.getParameter("categoryId"));
        String categoryName = request.getParameter("categoryName");
        try {
            HashMap<String, Object> paramsMap = ComplianceReportHandler.getParamsMap(domainName, timePeriod, categoryType, false, 0L, 0L);
            String jsonText = ComplianceReportHandler.getreportsSum(domainName, categoryId, categoryName, paramsMap).toString();
            response.setContentType("text/xml");
            PrintWriter writer = response.getWriter();
            writer.print(jsonText);
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward getCategoriesReports(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String domainName = request.getParameter("domainName");
        request.getSession().setAttribute("MONITOR_DOMAIN_NAME", (Object)domainName);
        int timePeriod = Integer.parseInt(request.getParameter("timePeriod"));
        Long categoryType = Long.parseLong(request.getParameter("categoryType"));
        Long categoryId = Long.parseLong(request.getParameter("categoryId"));
        boolean allReports = Boolean.parseBoolean(request.getParameter("allReports"));
        try {
            HashMap<String, Object> paramsMap = ComplianceReportHandler.getParamsMap(domainName, timePeriod, categoryType, true, 5L, 0L);
            String jsonText = ComplianceReportHandler.getCategoryReports(domainName, categoryId, categoryType, paramsMap, allReports, false, request);
            response.setContentType("text/xml");
            PrintWriter writer = response.getWriter();
            writer.print(jsonText);
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward refreshAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            boolean firstRefreshCrunch = Boolean.parseBoolean(request.getParameter("firstRefreshCrunch"));
            String refreshCrunch = ADSMPersUtil.getSyMParameter((String)"refreshCrunch");
            if (refreshCrunch.equals("false")) {
                ADSMPersUtil.updateSyMParameter((String)"refreshCrunch", (String)"true");
                if (!firstRefreshCrunch) {
                    DataCruncher.refreshCruncher();
                } else {
                    DataCruncher.oneTimeCrunch((boolean)true);
                }
                ADSMPersUtil.updateSyMParameter((String)"refreshCrunch", (String)"false");
            }
            response.setContentType("text/xml");
            PrintWriter writer = response.getWriter();
            writer.print(rb.getString("adap.common.button.done"));
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward exportSummaryReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String domainName = request.getParameter("domainName");
            int timePeriod = Integer.parseInt(request.getParameter("timePeriod"));
            Long from = TimeUtil.getFromFloor((Integer)timePeriod);
            Long to = TimeUtil.getToFloor((Integer)timePeriod) - 1L;
            Long categoryType = Long.parseLong(request.getParameter("categoryType"));
            Long offset = 0L;
            Long limit = -1L;
            String orderBy = request.getParameter("orderBy");
            HashMap<String, Object> paramsMap = ComplianceReportHandler.getParamsMap(domainName, timePeriod, categoryType, true, limit, offset, orderBy);
            paramsMap.put("FROM", from.toString());
            paramsMap.put("TO", to.toString());
            paramsMap.put("objectName", null);
            Long cvID = Long.parseLong(request.getParameter("cvID"));
            String searchCriteria = null;
            HashMap<String, String> reportMap = new HashMap<String, String>();
            reportMap.put("TITLE", request.getParameter("reportName"));
            reportMap.put("DESCRIPTION", request.getParameter("description"));
            reportMap.put("JASPER_NAME", "UserDetails.xml");
            ExportUtil.exportReport((Long)cvID, reportMap, (String)domainName, searchCriteria, (String)request.getParameter("reportType"), paramsMap, null, (HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward exportFullSummaryReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String domainName = request.getParameter("domainName");
            int timePeriod = Integer.parseInt(request.getParameter("timePeriod"));
            boolean isSearch = Boolean.parseBoolean(request.getParameter("isSearch"));
            Long from = TimeUtil.getFromFloor((Integer)timePeriod);
            Long to = TimeUtil.getToFloor((Integer)timePeriod) - 1L;
            Long categoryType = Long.parseLong(request.getParameter("categoryType"));
            String orderBy = request.getParameter("orderBy");
            HashMap<String, Object> paramsMap = ComplianceReportHandler.getParamsMap(domainName, timePeriod, categoryType, false, 0L, 0L);
            ArrayList<HashMap<String, Object>> exportList = ComplianceReportHandler.getFullExportData(domainName, categoryType, paramsMap, isSearch, request);
            if (exportList.size() > 0) {
                paramsMap.put("FROM", from.toString());
                paramsMap.put("TO", to.toString());
                paramsMap.put("objectName", null);
                paramsMap.put("isComplianceSummaryReport", exportList);
                if (isSearch) {
                    paramsMap.put("searchObj", request.getParameter("username"));
                }
                Long cvID = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:54000");
                String searchCriteria = null;
                HashMap<String, String> reportMap = new HashMap<String, String>();
                reportMap.put("JASPER_NAME", "UserDetails.xml");
                ExportUtil.exportReport((Long)cvID, reportMap, (String)domainName, searchCriteria, (String)request.getParameter("reportType"), paramsMap, null, (HttpServletRequest)request, (HttpServletResponse)response);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward getIndividualReports(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String domainName = request.getParameter("domainName");
        request.getSession().setAttribute("MONITOR_DOMAIN_NAME", (Object)domainName);
        int timePeriod = Integer.parseInt(request.getParameter("timePeriod"));
        Long categoryType = Long.parseLong(request.getParameter("categoryType"));
        Long offset = Long.parseLong(request.getParameter("offset"));
        Long limit = Long.parseLong(request.getParameter("limit"));
        String cvIdString = request.getParameter("cvIds");
        Boolean isInitial = Boolean.valueOf(request.getParameter("initialView"));
        boolean initialView = isInitial;
        try {
            JSONArray cvIdJSON = new JSONArray(cvIdString);
            Long[] cvIds = new Long[cvIdJSON.length()];
            for (int i = 0; i < cvIdJSON.length(); ++i) {
                cvIds[i] = Long.parseLong(cvIdJSON.get(i).toString());
            }
            JSONArray jsonArray = new JSONArray();
            String searchCriteria = null;
            HashMap<Object, Object> paramsMap = new HashMap();
            if (initialView) {
                paramsMap = ComplianceReportHandler.getParamsMap(domainName, timePeriod, categoryType, true, limit, offset);
            } else {
                searchCriteria = request.getParameter("searchCriteria");
                String orderBy = request.getParameter("orderBy");
                paramsMap = ComplianceReportHandler.getParamsMap(domainName, timePeriod, categoryType, true, limit, offset, orderBy);
            }
            Long sum = 0L;
            sum = initialView ? Long.valueOf(AuditReportAPI.getInstance().getReportCount(cvIds[0], null, paramsMap, null)) : (sum == 0L ? Long.valueOf(AuditReportAPI.getInstance().getReportCount(cvIds[0], searchCriteria, paramsMap, null)) : Long.valueOf(Long.parseLong(request.getParameter("others"))));
            if (sum > 0L) {
                for (int i = 0; i < cvIds.length; ++i) {
                    jsonArray.put((Object)ComplianceReportHandler.getComplianceReportRows(cvIds[i], searchCriteria, paramsMap, sum));
                }
            } else {
                JSONObject reportObj = new JSONObject();
                reportObj.put("reportSum", (Object)sum);
                jsonArray.put((Object)reportObj);
            }
            response.setContentType("text/xml");
            PrintWriter writer = response.getWriter();
            writer.print(jsonArray.toString());
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward getCvIdColumnData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String jsonText = null;
        String domainName = request.getParameter("domainName");
        request.getSession().setAttribute("MONITOR_DOMAIN_NAME", (Object)domainName);
        int timePeriod = Integer.parseInt(request.getParameter("timePeriod"));
        Long categoryType = Long.parseLong(request.getParameter("categoryType"));
        Long cvId = Long.parseLong(request.getParameter("cvId"));
        try {
            HashMap<String, Object> paramsMap = ComplianceReportHandler.getParamsMap(domainName, timePeriod, categoryType, true, 5L, 0L);
            Long sum = AuditReportAPI.getInstance().getReportCount(cvId, null, paramsMap, null);
            if (sum > 0L) {
                jsonText = ComplianceReportHandler.getComplianceReportRows(cvId, null, paramsMap, sum).toString();
            }
            response.setContentType("text/xml");
            PrintWriter writer = response.getWriter();
            writer.print(jsonText);
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward getFromTo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int timePeriod = Integer.parseInt(request.getParameter("timePeriod"));
        try {
            Long from = TimeUtil.getFromFloor((Integer)timePeriod);
            Long to = TimeUtil.getToFloor((Integer)timePeriod) - 1L;
            String fromToText = rb.handleGetObject("adap.Reports.AuditReports.From_Time_To_Time", new String[]{TimeUtil.formatDefaultTimeZoneDate((Long)(from * 1000L)), TimeUtil.formatDefaultTimeZoneDate((Long)(to * 1000L))});
            response.setContentType("text/xml");
            PrintWriter writer = response.getWriter();
            writer.print(fromToText);
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward deleteValues(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = "";
        boolean status = true;
        int success = 0;
        int failure = 0;
        String values = request.getParameter("values");
        JSONArray json_arr = new JSONArray(values);
        int length = json_arr.length();
        String name = "";
        String uid = "";
        for (int j = 0; j < json_arr.length(); ++j) {
            JSONObject jObj = json_arr.getJSONObject(j);
            Iterator it = jObj.keys();
            int i = 0;
            String key = null;
            while (it.hasNext()) {
                key = it.next().toString();
                if (key.equals("NAME")) {
                    name = jObj.getString(key);
                } else {
                    uid = jObj.getString(key);
                }
                ++i;
            }
            if (ViewObjects.updateFavourites(uid, name) == 1) {
                ++success;
                continue;
            }
            ++failure;
        }
        if (success > 0) {
            message = message + rb.handleGetObject("adap.ViewObjects.Successful_Period_deletion", new String[]{Integer.toString(success)});
        }
        if (failure > 0) {
            message = message + rb.handleGetObject("adap.ViewObjects.UnSuccessful_Period_deletion", new String[]{Integer.toString(failure)});
        }
        ClientUtil.setFormatXMLElement(response, message);
        return null;
    }

    public static int updateFavourites(String uid, String name) throws Exception {
        int message = 1;
        try {
            Criteria crit = null;
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDFavourites", crit);
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDFavourites", (String)"REPORT_PERIOD"), (Object)name, 0);
            Iterator reportIterator = dataObject.getRows("AUDFavourites", criteria);
            if (reportIterator.hasNext()) {
                Criteria c = new Criteria(Column.getColumn((String)"AUDCustomPeriod", (String)"UNIQUE_ID"), (Object)uid, 0);
                DataObject d = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDCustomPeriod", c);
                if (!d.isEmpty()) {
                    Row row = d.getRow("AUDCustomPeriod");
                    String start_time = (String)row.get("START_TIME");
                    String start_hour = (String)row.get("START_HOUR");
                    String end_time = (String)row.get("END_TIME");
                    String end_hour = (String)row.get("END_HOUR");
                    while (reportIterator.hasNext()) {
                        Row r = (Row)reportIterator.next();
                        r.set("REPORT_PERIOD", (Object)"customPeriod");
                        r.set("START_TIME", (Object)start_time);
                        r.set("START_HOUR", (Object)start_hour);
                        r.set("END_TIME", (Object)end_time);
                        r.set("END_HOUR", (Object)end_hour);
                        dataObject.updateRow(r);
                        CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
                    }
                }
            }
            message = ViewObjects.deleteCustomPeriod(uid);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = 0;
        }
        return message;
    }

    public static int deleteCustomPeriod(String uid) throws Exception {
        int message = 1;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDCustomPeriod", (String)"UNIQUE_ID"), (Object)uid, 0);
            CommonUtil.getPersistenceLite().delete(criteria);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = 0;
        }
        return message;
    }
}

