/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.monitor.model;

import com.adventnet.sym.adsm.auditing.server.monitor.ActionConstants;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditCatgoryAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.schema.SchemaAPI;
import com.adventnet.sym.adsm.common.server.schema.SchemaClass;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;

public class AuditActionBean
extends DynaValidatorForm {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        String string = "USE_ADV_CORRELATIONS";
        Map map = this.getMap();
        if (map.containsKey(string)) {
            map.put(string, false);
        }
        super.reset(mapping, request);
    }

    public void init() {
        HashMap relationalOperators = ActionConstants.getRelationalOperaions();
        ArrayList logicOperationsList = ActionConstants.getLogicalOperaions();
        this.set("logicOperationsList", logicOperationsList);
        this.set("relationalOperators", relationalOperators);
    }

    public void modify() {
        this.init();
    }

    public void setSelectValues(Long categoryId) {
        ArrayList variablesList = (ArrayList)this.get("variablesList");
        for (Object object : variablesList) {
            SchemaClass schemaClass;
            String[] schemaClasses;
            Hashtable variableTable = (Hashtable)object;
            if (!variableTable.get("INPUT_TYPE").toString().equalsIgnoreCase("SINGLE_SELECT")) continue;
            String variableName = (String)variableTable.get("VARIABLE_NAME");
            HashMap selectValueMap = new HashMap();
            ArrayList<String> valueList = new ArrayList<String>();
            ArrayList<String> textList = new ArrayList<String>();
            if (variableName.equalsIgnoreCase("ObjectClass") || variableName.contains("ObjectClass")) {
                for (String schemaIdGuid : schemaClasses = AuditCatgoryAPI.getInstance().getCategoryObject((Object)categoryId).getCategorySchemaClasses()) {
                    schemaClass = SchemaAPI.getInstance().getSchemaClass(schemaIdGuid);
                    valueList.add(schemaIdGuid);
                    textList.add(schemaClass.getCommonDisplayName());
                }
            } else if (variableName.equalsIgnoreCase("adap.AUDRuleVariables.variable_name.Access_Mask")) {
                ArrayList accessMaskList = SchemaAPI.getInstance().getAccessMaskList(categoryId);
                for (int i = 0; i < accessMaskList.size(); ++i) {
                    Properties properties = (Properties)accessMaskList.get(i);
                    if (!properties.getProperty("VISIBLE").equalsIgnoreCase("true")) continue;
                    valueList.add(properties.getProperty("ACCESS_MASK"));
                    textList.add(properties.getProperty("DISPLAY_NAME"));
                }
            } else if (variableName.equalsIgnoreCase("adap.AUDRuleVariables.variable_name.Attributes")) {
                for (String schemaClassName : schemaClasses = AuditCatgoryAPI.getInstance().getCategoryObject((Object)categoryId).getCategorySchemaClasses()) {
                    schemaClass = SchemaAPI.getInstance().getSchemaClass(schemaClassName);
                    ArrayList attributesList = schemaClass.getAttributeList();
                    for (String systemIdGuid : attributesList) {
                        try {
                            if (valueList.contains(systemIdGuid)) continue;
                            valueList.add(systemIdGuid);
                            textList.add(SchemaAPI.getInstance().getAttribute(systemIdGuid).getCommonName());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            selectValueMap.put("VALUE", valueList);
            selectValueMap.put("TEXT", textList);
            variableTable.put("SELECT_VALUE_MAP", selectValueMap);
        }
        this.set("variablesList", variablesList);
    }

    public void setCorrelationProperties(HttpServletRequest request, HashMap actionMap) {
        Boolean useAdvCorrelations = (Boolean)this.get("USE_ADV_CORRELATIONS");
        actionMap.put("USE_ADV_CORRELATIONS", useAdvCorrelations);
        if (useAdvCorrelations.booleanValue()) {
            Long timeInterval = (Long)this.get("TIME_INTERVAL");
            ArrayList<String> correlationVariables = new ArrayList<String>();
            Enumeration enumeration = request.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String paramName = (String)enumeration.nextElement();
                if (!paramName.startsWith("CORRELATION_RULES") || !paramName.endsWith("VARIABLE_ID")) continue;
                correlationVariables.add(request.getParameter(paramName));
            }
            System.out.println("correlationVariables : " + correlationVariables);
            this.set("correlationVariables", correlationVariables);
            actionMap.put("TIME_INTERVAL", timeInterval);
            actionMap.put("correlationVariables", correlationVariables);
        }
    }

    public void copy() {
    }

    public void save() {
    }

    public void delete() {
    }
}

