/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.monitor.model;

import com.adventnet.sym.adsm.auditing.server.monitor.AuditCategoryHandler;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditCatgoryAPI;
import com.adventnet.sym.adsm.auditing.server.monitor.Category;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.validator.DynaValidatorForm;

public class MonitorBean
extends DynaValidatorForm {
    public void init(Long loginId, HttpServletRequest request) {
        ArrayList categoryIdsList = (ArrayList)this.get("categoryIdsList");
        String categoryTypeString = request.getParameter("categoryType");
        if (categoryTypeString != null) {
            Integer categoryType = Integer.parseInt(categoryTypeString);
            this.set("categoryType", categoryType);
        }
        if (categoryIdsList == null || categoryIdsList.isEmpty()) {
            this.initCategories();
        }
        this.set("selectedObjectsMap", new HashMap());
        this.initDomainDetails(loginId, request);
    }

    public void initCategories() {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        ArrayList<Long> categoryIdsList = new ArrayList<Long>();
        ArrayList<String> categoryNamesList = new ArrayList<String>();
        Integer categoryType = (Integer)this.get("categoryType");
        LinkedHashMap categories = AuditCatgoryAPI.getInstance().getCategories(categoryType);
        Set keySet = categories.keySet();
        for (Long categoryId : keySet) {
            Category category = (Category)categories.get(categoryId);
            categoryIdsList.add(categoryId);
            categoryNamesList.add(rb.getString(category.getName()));
        }
        this.set("categoryIdsList", categoryIdsList);
        this.set("categoryNamesList", categoryNamesList);
    }

    public void initDomainDetails(Long loginId, HttpServletRequest request) {
        HttpSession session = request.getSession();
        ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        ArrayList configuredDomainsList = authObject.getConfiguredDomainList();
        ArrayList<String> domainList = new ArrayList<String>();
        ArrayList<String> defaultNamingContextList = new ArrayList<String>();
        if (!((String)this.get("operation")).equals("modify")) {
            for (Object object : configuredDomainsList) {
                Properties properties = (Properties)object;
                domainList.add(properties.getProperty("DOMAIN_NAME"));
                defaultNamingContextList.add(properties.getProperty("DEFAULT_NAMING_CONTEXT"));
            }
            this.set("domainList", domainList);
            this.set("defaultNamingContextList", defaultNamingContextList);
            String domainName = (String)session.getAttribute("MONITOR_DOMAIN_NAME");
            this.set("DEFAULT_NAMING_CONTEXT", DomainDetailsAPI.getDefaultNamingContext((String)domainName));
        }
    }

    public void setCategoryDetails(Object categoryId) {
        AuditCategoryHandler categoryHandler = AuditCategoryHandler.getInstance();
        ArrayList availableActionsList = categoryHandler.getActionsForCategory((Long)categoryId);
        this.set("availableActionsList", availableActionsList);
        Category category = AuditCatgoryAPI.getInstance().getCategoryObject(categoryId);
        this.set("showObjectSelect", category.getShowSelectObjects());
        this.set("monitorResultObjectClass", category.getResultObjectClass());
        ObjectClass[] monitorSelectObjectClasses = category.getCategorySelectObjects();
        if (monitorSelectObjectClasses != null) {
            this.set("monitorSelectObjectClasses", monitorSelectObjectClasses);
        }
    }

    public void modify() {
    }

    public void copy() {
    }

    public void save() {
    }

    public void delete() {
    }
}

