/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.reports;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.gpo.PDCHandler;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportParamsAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ReportSchedulerUtil;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.server.reports.SearchReports;
import com.adventnet.sym.adsm.auditing.server.reports.customreport.MatrixReportHandler;
import com.adventnet.sym.adsm.auditing.server.reports.customreport.MatrixReportParams;
import com.adventnet.sym.adsm.auditing.server.transformers.MultiRowTransformer;
import com.adventnet.sym.adsm.auditing.server.useractivity.UserActivityUtil;
import com.adventnet.sym.adsm.auditing.webclient.reports.AuditReportBean;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.ntfs.PrintHandler;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.objects.ObjectAttributeDetails;
import com.adventnet.sym.adsm.common.server.objects.ObjectUpdateHandler;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryAPI;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.EscapeUtil;
import com.adventnet.sym.adsm.common.server.util.JSONUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import com.adventnet.sym.adsm.common.server.wengine.FileUpdateScheduler;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.taskengine.TaskContext;
import com.manageengine.ads.fw.reports.favourites.MyFavRepHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONObject;

public class AuditReportAction
extends DispatchAction {
    protected static Logger logger = Logger.getLogger("ReportLogger");
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public ActionForward report(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuditReportBean reportBean = (AuditReportBean)form;
        HttpSession session = request.getSession();
        String forward = "report";
        Long loginId = 1L;
        TreeMap inputValue = new TreeMap();
        HashMap inputParamsMap = new HashMap();
        HashMap inputParams = new HashMap();
        try {
            if (request.getParameter("init") != null) {
                reportBean.initializeBean(request);
            } else {
                reportBean.initParams(request);
            }
            Long reportId = (Long)reportBean.get("reportId");
            String substring = (String)reportBean.get("substring");
            forward = (String)reportBean.get("forward");
            inputParams = (HashMap)reportBean.get("inputParams");
            String domainName = request.getParameter("domains") != null ? request.getParameter("domains") : request.getParameter("domainName");
            String desc = (String)reportBean.get("desc");
            boolean printerReportCondition = inputParams.get("objectClass") != null && ((String)inputParams.get("objectClass")).equalsIgnoreCase("printer");
            boolean isMyreport = false;
            boolean bl = printerReportCondition = printerReportCondition && inputParams.get("objectName") != null;
            if (request.getParameter("favouriteId") == null) {
                inputParams.put("domainName", domainName);
            } else if (inputParams.get("objectClass") != null && ((String)inputParams.get("objectClass")).equalsIgnoreCase("printer")) {
                printerReportCondition = true;
                isMyreport = true;
            }
            if (printerReportCondition) {
                ArrayList printerList;
                String printerNames = "";
                if (inputParams.get("printer_name") != null) {
                    ArrayList namesPrintList = (ArrayList)inputParams.get("printer_name");
                    for (int i = 0; i < namesPrintList.size(); ++i) {
                        printerNames = printerNames + (String)namesPrintList.get(i) + (i != namesPrintList.size() - 1 ? "," : "");
                    }
                }
                if (printerNames.equalsIgnoreCase("")) {
                    printerNames = (String)inputParams.get("objectName");
                }
                ArrayList arrayList = printerList = (printerNames = PrintHandler.escapeRevert((String)printerNames)) != null ? AuditReportParamsAPI.getPrintersList((String)printerNames) : new ArrayList();
                if (printerNames == null && request.getParameter("favouriteId") != null) {
                    printerList = (ArrayList)inputParams.get("printer_name");
                }
                if (printerList.size() > 0) {
                    inputParams.put("objectName", printerNames);
                } else {
                    inputParams.put("objectName", null);
                }
                HashMap<String, ArrayList> selectedObjectsMap = new HashMap<String, ArrayList>();
                boolean bl2 = isMyreport = isMyreport || printerNames != null && !printerNames.equalsIgnoreCase("allobjects");
                if (isMyreport) {
                    selectedObjectsMap.put("printer_name", printerList);
                    if (printerList.size() > 0) {
                        reportBean.set("selectedObjectsMap", selectedObjectsMap);
                        inputParams.put("printer_name", printerList);
                    }
                }
            }
            if (request.getParameter("selectedPrinterName") != null) {
                HashMap<String, ArrayList> selectedObjectsMap = new HashMap<String, ArrayList>();
                String printerName = "\\\\" + PrintHandler.escapeRevert((String)request.getParameter("selectedPrinterName"));
                if (request.getParameter("objectType").equalsIgnoreCase("printer")) {
                    ArrayList<String> printerList = new ArrayList<String>();
                    printerList.add(printerName);
                    inputParams.put("printer_name", printerList);
                    inputParams.put("objectName", printerName);
                    if (inputParams.get("allObjectSelected") != null) {
                        inputParams.remove("allObjectSelected");
                    }
                    selectedObjectsMap.put("printer_name", printerList);
                } else {
                    inputParams.put("objectName", "'" + request.getParameter("selectedPrinterName") + "'");
                    selectedObjectsMap.put("object_guid", DirectoryObjectAPI.getInstance().getObjectGuid(domainName, request.getParameter("objectType"), request.getParameter("selectedPrinterName")));
                    inputParams.put("object_guid", DirectoryObjectAPI.getInstance().getObjectGuid(domainName, request.getParameter("objectType"), request.getParameter("selectedPrinterName")));
                    inputParams.put("objectClass", request.getParameter("objectType"));
                }
                reportBean.set("selectedObjectsMap", selectedObjectsMap);
                HashMap tableViewConfig = AuditReportAPI.getInstance().getTableViewConfig(reportId);
                reportBean.set("sortColumn", (String)tableViewConfig.get("SORTCOLUMN"));
            }
            if (request.getParameter("reportSearch") != null) {
                String str = reportBean.getSearchCriteria(reportBean.getColumnSearchCriteria(request, AUDCustomViewAPI.getInstance().getReportCVId(reportId), false));
                reportBean.set("searchCriteria", str.replaceAll("%", ""));
            }
            inputParamsMap = reportBean.getInputParamsValues(inputParams, request);
            inputValue = reportBean.getFormElements(reportId, inputParams, request);
            reportBean.set("desc", desc);
            reportBean.set("inputValue", inputValue);
            reportBean.set("inputParamsMap", inputParamsMap);
            reportBean.initDomainDetails(loginId, session);
            if (request.getParameter("business") != null) {
                session.setAttribute("business", (Object)request.getParameter("business"));
                reportBean.set("BUSINESS_HOUR", request.getParameter("business"));
            }
            ArrayList countResultList = AUDCustomViewAPI.getInstance().getReportCVIdArray(reportId);
            request.setAttribute("countResultList", (Object)countResultList);
            request.setAttribute("inputValue", (Object)inputValue);
            Integer reportCategoryType = (Integer)reportBean.get("reportCategoryType");
            if (reportCategoryType == 2) {
                forward = "fileReport";
            } else if (reportCategoryType == 3) {
                forward = "serverReport";
            }
            request.setAttribute("reportId", (Object)reportId.toString());
            request.setAttribute("reportName", (Object)rb.getString((String)reportBean.get("reportName")));
            request.setAttribute("Categories", (Object)MyFavRepHandler.getCategoryList());
            request.setAttribute("isBookmarked", (Object)false);
            request.setAttribute("displayBookmark", (Object)false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Reports", rb.handleGetObject("adap.AuditReportAction.audit_entry.report_viewed", new String[]{rb.getString((String)reportBean.get("reportName")), (String)session.getAttribute("MONITOR_DOMAIN_NAME")}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.Report_generated", "-"}));
        logger.log(Level.FINE, "report Forward :" + forward);
        return mapping.findForward(forward);
    }

    public ActionForward changeLimitValue(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long cv_id = Long.valueOf(request.getParameter("cvID"));
        String limitValue = request.getParameter("limitValue");
        AuditReportAPI.getInstance().changeChartDefault("LIMIT_VALUE", limitValue, cv_id);
        return null;
    }

    public ActionForward customColumns(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward = "customColumns";
        AuditReportBean bean = (AuditReportBean)form;
        Long reportId = (Long)bean.get("reportId");
        Long cvID = 0L;
        String strID = request.getParameter("cvID");
        cvID = Long.parseLong(strID);
        try {
            HashMap customColumnMap = AuditReportAPI.getInstance().getCustomVisibleList(cvID);
            request.setAttribute("cutomColumnMap", (Object)customColumnMap);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String inputData = request.getParameter("inputData");
        request.setAttribute("reportId", (Object)reportId);
        request.setAttribute("cvID", (Object)cvID);
        request.setAttribute("inputData", (Object)inputData);
        return mapping.findForward(forward);
    }

    public ActionForward saveTable(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward = "customColumns";
        AuditReportBean bean = (AuditReportBean)form;
        Long cvID = 0L;
        HttpSession session = request.getSession();
        try {
            Long reportId = (Long)bean.get("reportId");
            String cusViewID = request.getParameter("cvID");
            cvID = Long.parseLong(cusViewID);
            String substring = request.getParameter("substring");
            String[] col_id = substring.split(",");
            Long[] visibleColumns = new Long[col_id.length];
            for (int i = 0; i < col_id.length; ++i) {
                visibleColumns[i] = Long.valueOf(col_id[i]);
                logger.log(Level.FINE, "From Action : Updatable Row is :" + visibleColumns[i]);
            }
            String inputData = request.getParameter("inputData");
            AUDCustomViewAPI.getInstance().updateColumnList(cvID, visibleColumns);
            request.setAttribute("reportId", (Object)reportId);
            request.setAttribute("cvID", (Object)cvID);
            request.setAttribute("inputData", (Object)inputData);
            request.setAttribute("message", (Object)"Successfully Saved");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", rb.handleGetObject("adap.AuditReportAction.audit_entry.report_column_changed", new String[]{rb.getString((String)bean.get("reportName"))}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Column_changed", "-"}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forward);
    }

    public ActionForward getListOfObjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward = "dispList";
        try {
            String[] strObjClass = request.getParameter("strType").split(";;;");
            ObjectClass[] objectClass = new ObjectClass[strObjClass.length];
            for (int i = 0; i < strObjClass.length; ++i) {
                objectClass[i] = DirectoryObjectAPI.getInstance().getObjectClass(strObjClass[i]);
                if (strObjClass[i].equalsIgnoreCase("share")) {
                    request.setAttribute("selectType", (Object)"radio");
                    continue;
                }
                request.setAttribute("selectType", (Object)"checkbox");
            }
            String domainName = request.getParameter("domainName");
            domainName = domainName != null ? domainName : (String)request.getSession().getAttribute("MONITOR_DOMAIN_NAME");
            logger.log(Level.FINE, "domainName in Action :" + domainName);
            String defaultNamingContext = DomainDetailsAPI.getDefaultNamingContext((String)domainName);
            request.setAttribute("domainName", (Object)domainName);
            request.setAttribute("defaultNamingContext", (Object)defaultNamingContext);
            request.setAttribute("objectClass", (Object)objectClass);
            request.setAttribute("guidName", (Object)request.getParameter("guidName"));
            request.setAttribute("action", (Object)request.getParameter("action"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward(forward);
    }

    public ActionForward addObjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuditReportBean bean = (AuditReportBean)form;
        try {
            String objectClass = request.getParameter("objectClass");
            String guidName = request.getParameter("guidName");
            String selectedObjects = request.getParameter("selectedObjects");
            HashMap selectedObjectsMap = (HashMap)bean.get("selectedObjectsMap");
            ArrayList<String> selectedObjectsList = (ArrayList<String>)selectedObjectsMap.get(guidName);
            if (selectedObjectsList == null) {
                selectedObjectsList = new ArrayList<String>();
            }
            logger.log(Level.FINE, "Testing .... ");
            HttpSession session = request.getSession();
            DynaActionForm viewObjectsBean = (DynaActionForm)session.getAttribute("ViewObjectsBean");
            HashMap objectMap = (HashMap)viewObjectsBean.get("selectedObjectsMap");
            String selectType = (String)viewObjectsBean.get("selectType");
            ArrayList list = (ArrayList)objectMap.get(objectClass);
            if (selectType.equalsIgnoreCase("radio")) {
                selectedObjectsList = new ArrayList();
            }
            for (int i = 0; i < list.size(); ++i) {
                HashMap map = (HashMap)list.get(i);
                String str = (String)map.get("selectedObjects");
                if (selectedObjectsList.contains(str)) continue;
                selectedObjectsList.add(str);
            }
            selectedObjectsMap.put(guidName, selectedObjectsList);
            bean.set("selectedObjectsMap", selectedObjectsMap);
            ClientUtil.setStatusXMLElement(response, "Success", "");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", "");
        }
        return null;
    }

    public ActionForward addObjectsToCriteria(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String objectClass = request.getParameter("objectClass");
            String guidName = request.getParameter("guidName");
            String selectedObjects = request.getParameter("selectedObjects");
            String allObjectSelected = request.getParameter("allObjectSelected");
            HttpSession session = request.getSession();
            DynaActionForm viewObjectsBean = (DynaActionForm)session.getAttribute("ViewObjectsBean");
            ArrayList list = new ArrayList();
            if (allObjectSelected.equalsIgnoreCase("true")) {
                HashMap<String, String> allObjMap = new HashMap<String, String>();
                allObjMap.put("selectedObjects", "AllObjects");
                allObjMap.put("selectedObjectNames", "AllObjects");
                list.add(allObjMap);
            } else {
                HashMap objectMap = (HashMap)viewObjectsBean.get("selectedObjectsMap");
                list = (ArrayList)objectMap.get(objectClass);
            }
            String jsonStr = JSONUtil.convertListMapToJSON((List)list);
            ClientUtil.setStatusXMLElement(response, "Success", jsonStr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", "");
        }
        return null;
    }

    public ActionForward getRowColumnList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        AuditReportBean reportBean = (AuditReportBean)form;
        ArrayList reportsList = new ArrayList();
        String forward = "reportPageFrame";
        Long reportId = 0L;
        Long cvID = 0L;
        try {
            String tileName = (String)reportBean.get("tileName");
            HashMap inputParams = (HashMap)reportBean.get("inputParams");
            HashMap inputParamsMap = (HashMap)reportBean.get("inputParamsMap");
            reportId = (Long)reportBean.get("reportId");
            String strID = request.getParameter("cvID");
            cvID = Long.parseLong(strID);
            if (tileName.equalsIgnoreCase("report")) {
                String guidStr;
                String inputData = request.getParameter("inputData");
                String countSqlString = null;
                String unionSqlString = null;
                if (request.getParameter("message") != null && request.getParameter("message").toString().equalsIgnoreCase("DefaultColumns")) {
                    this.getDefaultColumns(cvID);
                    reportBean.set("defaultflag", true);
                }
                if (request.getParameter("sortColumn") != null) {
                    reportBean.set("sortColumn", request.getParameter("sortColumn"));
                    reportBean.set("sortOrder", request.getParameter("sortOrder"));
                    reportBean.set("PAGE_NUMBER", "1");
                    reportBean.set("FROM_INDEX", 1);
                }
                if (request.getParameter("clearSearch") != null) {
                    reportBean.set("searchString", "");
                    reportBean.set("searchCriteria", "");
                    reportBean.set("xColumnValue", "");
                    reportBean.set("PAGE_NUMBER", "1");
                    reportBean.set("FROM_INDEX", 1);
                    reportBean.set("criteriaString", "");
                    reportBean.set("BUSINESS_HOUR", "false");
                }
                if (request.getParameter("business") != null) {
                    reportBean.set("BUSINESS_HOUR", request.getParameter("business"));
                } else {
                    reportBean.set("BUSINESS_HOUR", session.getAttribute("business") != null ? session.getAttribute("business") : "false");
                }
                String searchCriteria = reportBean.getColumnSearchCriteria(request, cvID, true);
                ArrayList guidList = (ArrayList)inputParams.get("object_guid");
                inputParamsMap = ReportSchedulerUtil.formInputParamsMap((HashMap)inputParams, (HashMap)inputParamsMap, (Long)reportId);
                Long gpoCvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:7016");
                if (cvID.equals(gpoCvId) && (guidStr = (String)inputParamsMap.get("guidStr")) != null) {
                    guidStr = guidStr.replaceAll("\\%", "");
                    inputParamsMap.put("guidStr", guidStr);
                }
                int count = 0;
                String objectName = (String)inputParamsMap.get("objectName");
                if (CommonUtil.getDBServerName().equalsIgnoreCase("mysql")) {
                    objectName = objectName != null ? objectName.replace("\\\\", "\\") : null;
                    String string = objectName = objectName != null ? objectName.replace("\\", "\\\\") : null;
                }
                if (objectName != null) {
                    StringTokenizer sto = new StringTokenizer(objectName, ",");
                    int quotCountIdeal = sto.countTokens() * 2;
                    int quotCountActual = objectName.length() - objectName.replaceAll("'", "").length();
                    if (quotCountActual > quotCountIdeal) {
                        objectName = "";
                        while (sto.hasMoreElements()) {
                            String temp = sto.nextToken();
                            quotCountActual = temp.length() - temp.replaceAll("'", "").length();
                            if (quotCountActual > 2) {
                                temp = temp.trim();
                                temp = temp.substring(1, temp.length() - 1);
                                temp = temp.replaceAll("'", "''");
                                temp = "'" + temp + "'";
                            }
                            objectName = objectName + temp + ",";
                        }
                        objectName = objectName.substring(0, objectName.length() - 1);
                    }
                }
                inputParamsMap.put("objectName", objectName);
                boolean isCompliancePopup = false;
                if (request.getParameterMap().containsKey("isCompliancePopup")) {
                    isCompliancePopup = true;
                }
                ArrayList columnList = AuditReportAPI.getInstance().getVisibleColumnList(cvID);
                boolean condition = guidList == null && objectName == null;
                boolean bl = condition = condition || guidList != null && !guidList.isEmpty();
                if (condition || objectName != null && objectName.length() > 0) {
                    logger.log(Level.FINE, "am inside the condition");
                    if (inputData != null) {
                        DataObject cvDO = AUDCustomViewAPI.getInstance().getGraphDO(cvID);
                        Row row = cvDO.getRow("AUDSQLQuery");
                        long queryId = (Long)row.get("QUERY_ID");
                        countSqlString = ADAPSQLQueryUtil.getUnionQueryStackedBarChart((String)inputData, (String)"countString", (Long)queryId);
                        unionSqlString = ADAPSQLQueryUtil.getUnionQueryStackedBarChart((String)inputData, (String)"sqlString", (Long)queryId);
                    }
                    if (isCompliancePopup) {
                        String domain = request.getParameter("domain");
                        int timePeriod = Integer.parseInt(request.getParameter("timePeriod"));
                        inputParamsMap.put("domainFlatName", DomainDetailsAPI.getDomainFlatName((String)domain, (boolean)true));
                        inputParamsMap.put("domainDNSName", DomainDetailsAPI.getDomainDNSName((String)domain));
                        inputParamsMap.put("RDNC", DomainDetailsAPI.getRootDomainNamingContext((String)domain));
                        inputParamsMap.put("FROM", TimeUtil.getFromFloor((Integer)timePeriod).toString());
                        inputParamsMap.put("TO", TimeUtil.getToFloor((Integer)timePeriod).toString());
                        searchCriteria = request.getParameter("searchCriteria");
                        HashMap<String, Object> reportInputMap = new HashMap<String, Object>();
                        reportInputMap.put("isCompliancePopup", "true");
                        reportInputMap.put("domain", domain);
                        reportInputMap.put("time", timePeriod);
                        reportInputMap.put("searchCriteria", searchCriteria);
                        if (searchCriteria != null) {
                            searchCriteria = searchCriteria + " AND " + request.getParameter("addnsearchCriteria");
                        }
                        reportInputMap.put("addnsearchCriteria", request.getParameter("addnsearchCriteria"));
                        request.setAttribute("reportInputMap", reportInputMap);
                    }
                    if (countSqlString != null) {
                        count = AuditReportAPI.getInstance().getReportCount(cvID, searchCriteria, inputParamsMap, countSqlString);
                    } else {
                        if (!isCompliancePopup) {
                            searchCriteria = reportBean.getSearchCriteria(searchCriteria);
                        }
                        count = AuditReportAPI.getInstance().getReportCount(cvID, searchCriteria, inputParamsMap);
                    }
                    if (request.getParameter("message") != null && request.getParameter("message").toString().equalsIgnoreCase("DefaultColumns") || reportBean.get("defaultflag") == null || request.getParameter("message") != null && request.getParameter("message").toString().equalsIgnoreCase("Add or Remove Columns")) {
                        block3: for (int i = 0; i < columnList.size() && !reportBean.get("sortColumn").toString().equalsIgnoreCase(((HashMap)columnList.get(i)).get("COLUMNALIAS").toString()); ++i) {
                            if (i != columnList.size() - 1) continue;
                            for (int j = 0; j < columnList.size(); ++j) {
                                if (!((HashMap)columnList.get(j)).get("SORTENABLED").toString().equalsIgnoreCase("true")) continue;
                                reportBean.set("sortColumn", ((HashMap)columnList.get(j)).get("COLUMNALIAS").toString());
                                continue block3;
                            }
                        }
                    }
                    if (count > 0) {
                        reportsList = AuditReportAPI.getInstance().getReportRows(cvID, searchCriteria, inputParamsMap, (String)reportBean.get("sortColumn"), (String)reportBean.get("sortOrder"), ((Integer)reportBean.get("FROM_INDEX")).intValue(), ((Integer)reportBean.get("RANGE")).intValue(), unionSqlString, count, Boolean.valueOf(false));
                    }
                }
                reportBean.set("searchCriteria", searchCriteria);
                request.setAttribute("count", (Object)count);
                request.setAttribute("cvID", (Object)cvID);
                Long subReportId = MultiRowTransformer.getSubReportCvId((ArrayList)columnList);
                if (null != subReportId && subReportId != 0L) {
                    request.setAttribute("SUBREPORT_CV_ID", (Object)subReportId);
                    boolean visible = !subReportId.equals(DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:15051"));
                    ArrayList subcolumnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(subReportId, Boolean.valueOf(visible), true, null);
                    request.setAttribute("subColumnList", (Object)subcolumnList);
                    AuditReportAPI.getInstance();
                    if (AuditReportAPI.subReportList.contains(subReportId)) {
                        for (HashMap map : subcolumnList) {
                            columnList.add(map);
                        }
                    }
                    if (!visible) {
                        reportsList = UserActivityUtil.getInstance().getLogonDurationSubReport(reportsList, subcolumnList);
                    }
                }
                request.setAttribute("reportsList", reportsList);
                request.setAttribute("columnList", (Object)columnList);
                request.setAttribute("inputData", (Object)inputData);
                if ((request.getParameter("message") == null || !request.getParameter("message").toString().equalsIgnoreCase("DefaultColumns")) && (reportBean.get("defaultflag") == null || request.getParameter("message") != null && request.getParameter("message").toString().equalsIgnoreCase("Add or Remove Columns")) && count > 0) {
                    Boolean defaultflag = true;
                    Criteria c = new Criteria(Column.getColumn((String)"AUDColumnConfiguration", (String)"CV_ID"), (Object)cvID, 0);
                    DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDColumnConfiguration", c);
                    if (!dObj.isEmpty()) {
                        Iterator it = dObj.getRows("AUDColumnConfiguration", (Criteria)null);
                        while (it.hasNext()) {
                            Row s = (Row)it.next();
                            int defaultColumnIndexInDB = Integer.parseInt(s.get("DEFAULTCOLUMNINDEX").toString());
                            if (s.get("VISIBLE") == s.get("DEFAULTVISIBLE") || defaultColumnIndexInDB == -1) continue;
                            defaultflag = false;
                            break;
                        }
                    }
                    reportBean.set("defaultflag", defaultflag);
                }
            } else if (tileName.equalsIgnoreCase("matrix")) {
                forward = "simpleMatrixPage";
                String searchCriteria = reportBean.getColumnSearchCriteria(request, cvID, true);
                HashMap<String, Object> addnSQLPropsMap = new HashMap<String, Object>();
                addnSQLPropsMap.put("sortOrder", reportBean.get("sortOrder"));
                reportBean.set("RANGE", request.getParameter("RANGE") != null ? Integer.parseInt(request.getParameter("RANGE")) : new Integer(200));
                MatrixReportHandler.generateMatrixReport((HttpServletRequest)request, (Long)reportId, (HashMap)inputParamsMap, (String)searchCriteria, addnSQLPropsMap, (Long)cvID);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward(forward);
    }

    public ActionForward reportGraphUnderlyingData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward = "reportPageFrame";
        Long cvID = 0L;
        Long graphOptID = 0L;
        try {
            AuditReportBean bean = (AuditReportBean)form;
            bean.set("searchString", "");
            HashMap inputParamsMap = (HashMap)bean.get("inputParamsMap");
            cvID = Long.parseLong(request.getParameter("cvID"));
            graphOptID = Long.parseLong(request.getParameter("graphOptID"));
            String inputData1 = request.getParameter("inputData").toString();
            String inputData = EscapeUtil.escSplCharsAsSQL((Object)inputData1);
            String xColumnValue = AuditReportAPI.getInstance().getXColumnValue(cvID, graphOptID, inputData);
            bean.set("xColumnValue", xColumnValue);
            String businessCriteria = ADAPSQLQueryAPI.getInstance().getBusinessSearchCriteria((String)bean.get("BUSINESS_HOUR"), true);
            if (businessCriteria != null) {
                request.setAttribute("businessSearchString", (Object)((String)bean.get("BUSINESS_HOUR")));
                if (xColumnValue != null) {
                    xColumnValue = xColumnValue + " AND " + businessCriteria;
                }
            }
            int count = AuditReportAPI.getInstance().getRowsCount(cvID, graphOptID, inputData, inputParamsMap, xColumnValue);
            ArrayList columnList = AuditReportAPI.getInstance().getVisibleColumnList(cvID);
            ArrayList reportsList = AuditReportAPI.getInstance().getReportRows(cvID, graphOptID, inputData, inputParamsMap, xColumnValue, (String)bean.get("sortColumn"), (String)bean.get("sortOrder"), 1, ((Integer)bean.get("RANGE")).intValue(), count, Boolean.valueOf(false));
            request.setAttribute("count", (Object)count);
            request.setAttribute("columnList", (Object)columnList);
            request.setAttribute("reportsList", (Object)reportsList);
            request.setAttribute("cvID", (Object)cvID);
            request.setAttribute("inputData", (Object)inputData1);
            if (request.getParameter("xlabel").equals("HOUR")) {
                inputData = "( HOURS " + inputData + " To " + (Integer.parseInt(inputData) + 1) + " )";
            }
            if (inputData.contains(";;")) {
                inputData = inputData.replace(";;", "-");
            }
            bean.set("criteriaString", inputData1);
            bean.set("PAGE_NUMBER", "1");
            bean.set("FROM_INDEX", 1);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Reports", rb.handleGetObject("adap.AuditReportAction.audit_entry.Report_Graph_underlying_data_generated", new String[]{rb.getString((String)bean.get("reportName"))}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.Generate_Report_graph_underlying_data", "-"}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward(forward);
    }

    public ActionForward exportReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArrayList columnList = new ArrayList();
        AuditReportBean bean = (AuditReportBean)form;
        try {
            bean.exportReport(request, response);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward updateDescription(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        try {
            AuditReportBean bean = (AuditReportBean)form;
            Long reportId = Long.parseLong(request.getParameter("reportId"));
            String desc = request.getParameter("description");
            AuditReportAPI.getInstance().updateDescription(reportId, desc);
            bean.set("desc", desc);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", rb.handleGetObject("adap.AuditReportAction.audit_entry.report_description_update", new String[]{rb.getString((String)bean.get("reportName")), desc}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.descriptoin_updated", "-"}));
            ClientUtil.setStatusXMLElement(response, "Success", "");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward removeObjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuditReportBean bean = (AuditReportBean)form;
        try {
            HashMap selectedObjectsMap = (HashMap)bean.get("selectedObjectsMap");
            String guidName = request.getParameter("guidName");
            ArrayList guidList = (ArrayList)selectedObjectsMap.remove(guidName);
            String removedObjects = request.getParameter("removedObjects");
            StringTokenizer removeTokenizer = new StringTokenizer(removedObjects, ",");
            while (removeTokenizer.hasMoreTokens()) {
                String object = removeTokenizer.nextToken();
                if (!guidList.contains(object)) continue;
                guidList.remove(object);
            }
            if (guidList.size() > 0) {
                selectedObjectsMap.put(guidName, guidList);
            }
            bean.set("selectedObjectsMap", selectedObjectsMap);
            ClientUtil.setStatusXMLElement(response, "Success", "");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", "");
        }
        return null;
    }

    public ActionForward addORRemoveFavorites(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuditReportBean bean = (AuditReportBean)form;
        HttpSession session = request.getSession();
        String message = rb.getString("adap.AuditReportAction.Failure_to_add_to_Favourites");
        try {
            String action = request.getParameter("action");
            if (action.equalsIgnoreCase("remove")) {
                Long favouriteId = Long.parseLong(request.getParameter("favouriteId"));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", rb.handleGetObject("adap.AuditReportAction.audit_entry.report_Removed_from_favourties", new String[]{rb.getString((String)bean.get("reportName"))}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Report_Removed_from_favourites", "-"}));
                AuditReportAPI.getInstance();
                message = AuditReportAPI.removeFavourites((Long)favouriteId);
            } else if (request.getParameter("reportId") != null) {
                Long reportId = Long.parseLong(request.getParameter("reportId"));
                Long loginId = (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID");
                String favName = request.getParameter("favouritesName");
                HashMap inputParams = (HashMap)bean.get("inputParams");
                message = AuditReportAPI.getInstance().addToFavorites(reportId, favName, inputParams, loginId);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", rb.handleGetObject("adap.AuditReportAction.audit_entry.report_added_to_favourites", new String[]{rb.getString((String)bean.get("reportName"))}), 8, rb, 8, "adap.ADAPUserAuditSeverities.audit_name.Reports_Added_To_favourites", "-"}));
            }
            ClientUtil.setStatusXMLElement(response, "Success", message);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", message);
        }
        return null;
    }

    public ActionForward getDNC(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String domainName = request.getParameter("domainName");
            String message = DomainDetailsAPI.getDefaultNamingContext((String)domainName);
            ClientUtil.setStatusXMLElement(response, "Success", message);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward savePDCName(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String messageType = "";
        String message = "";
        HttpSession session = request.getSession();
        String pdcName = request.getParameter("pdcName");
        String domainName = request.getParameter("domainName");
        try {
            Long dcId = PDCHandler.getInstance().getDCIdFromDB(domainName, pdcName);
            if (dcId == 0L) {
                ArrayList<String> dcList = new ArrayList<String>();
                dcList.add(pdcName);
                Properties domainProperties = DomainHandler.getConfiguredValuesForModify((String)domainName);
                domainProperties.put("DOMAIN_CONTROLLER_LIST", dcList);
                DomainHandler.getDomainDetails((Properties)domainProperties, (boolean)true);
                DomainHandler.addDomainControllers((Properties)domainProperties);
                dcId = PDCHandler.getInstance().getDCIdFromDB(domainName, pdcName);
            }
            PDCHandler.getInstance().updatePDC(domainName, dcId);
            messageType = rb.getString("adap.AuditReportAction.Successfully_saved_PDC");
            message = "success";
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "General", messageType + rb.handleGetObject("adap.AuditReportAction.audit_entry.pdc_name", new String[]{pdcName, domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Get_PDC_Name", "-"}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            messageType = ex.getMessage();
            message = "error";
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "General", messageType + rb.handleGetObject("adap.AuditReportAction.audit_entry.pdc_name", new String[]{pdcName, domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.Get_PDC_Name", "-"}));
        }
        finally {
            try {
                ClientUtil.setStatusXMLElement(response, messageType, message);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public ActionForward updateGPMC(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        try {
            Boolean b = PDCHandler.getInstance().updateIsGPMCInstalled();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "General", "GPMC Updated", 8, 8, "adap.ADAPUserAuditSeverities.audit_name.update_GPMC", "-"}));
            if (b.booleanValue()) {
                String domainName = (String)session.getAttribute("MONITOR_DOMAIN_NAME");
                ArrayList reportIds = new ArrayList();
                Hashtable<String, Integer> reportTable = new Hashtable<String, Integer>();
                reportTable.put("report_id", 503);
                reportIds.add(reportTable);
                ObjectUpdateHandler.runDailyReport((String)domainName, (Long)1L, reportIds);
                ClientUtil.setStatusXMLElement(response, "Success", rb.getString("adap.AuditReportAction.gpmc_installation_successful"));
            } else {
                ClientUtil.setStatusXMLElement(response, "Success", rb.getString("adap.AuditReportAction.please_install_gpmc"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", "");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "General", "GPMC Updated", 8, 16, "adap.ADAPUserAuditSeverities.audit_name.update_GPMC", "-"}));
        }
        return null;
    }

    public ActionForward runFileUpdateScheduler(ActionMapping actionmapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", rb.getString("adap.AuditReportAction.audit_entry.file_creation_started_manually"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Manual_file_creation_run", "-"}));
        class FileUpdateThread
        extends Thread {
            public FileUpdateThread() {
                super("ManualFileUpdateThread");
            }

            @Override
            public void run() {
                try {
                    FileUpdateScheduler scheduler = new FileUpdateScheduler();
                    scheduler.executeTask(new TaskContext());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        new FileUpdateThread().start();
        String messageType = "Success";
        String message = (String)rb.handleGetObject("adap.fileaudit.generating_files_created_report");
        ClientUtil.setStatusXMLElement(response, messageType, message);
        return actionmapping.findForward(null);
    }

    public ActionForward addToDashBoard(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        try {
            String status = "";
            String layoutName = null;
            AuditReportBean reportBean = (AuditReportBean)form;
            String action = request.getParameter("action");
            int reportCategoryType = 1;
            Long tabId = 1L;
            String selTab = request.getParameter("selectedTab");
            if (selTab != null && selTab.equalsIgnoreCase("fileAudit")) {
                tabId = 3L;
                layoutName = "admp.home.layout.name.file_audit_layout";
            }
            if (action.equalsIgnoreCase("add")) {
                HashMap inputParamsMap;
                String graphName = request.getParameter("graphName");
                String[] interval = request.getParameter("timeInterval").split(";;;");
                HashMap<String, Object> inputMap = new HashMap<String, Object>();
                inputMap.put("GRAPH_TITLE", graphName);
                inputMap.put("GRAPH_OPT_ID", Long.parseLong(request.getParameter("graphOptId")));
                inputMap.put("FIRST_GRAPH_DURATION", Long.parseLong(interval[0]));
                inputMap.put("SECOND_GRAPH_DURATION", Long.parseLong(interval[1]));
                inputMap.put("LOGIN_ID", new Long(1L));
                inputMap.put("VISIBLE", true);
                if (reportBean.get("reportCategoryType") != null) {
                    reportCategoryType = (Integer)reportBean.get("reportCategoryType");
                    inputMap.put("GRAPH_TYPE", (Integer)reportBean.get("reportCategoryType"));
                    inputMap.put("PRIORITY_ID", AuditReportAPI.getInstance().getPriorityId(((Integer)reportBean.get("reportCategoryType")).intValue()));
                }
                if ((inputParamsMap = (HashMap)reportBean.get("inputParams")).get("objectClass") != null) {
                    inputMap.put("IS_INPUT_NEEDED", true);
                } else {
                    inputMap.put("IS_INPUT_NEEDED", false);
                }
                inputMap.put("IS_THIS_REPORT_GRAPH", true);
                JSONObject adsContainerDetail = new JSONObject();
                Credential credential = AuthUtil.getUserCredential();
                adsContainerDetail.put("CONTAINER_ID", (Object)request.getParameter("conId"));
                adsContainerDetail.put("CONTAINER_NAME", (Object)request.getParameter("graphName"));
                adsContainerDetail.put("COMPONENT_ID", Long.parseLong(request.getParameter("graphOptId")));
                adsContainerDetail.put("USER_ID", (Object)credential.getUserId());
                adsContainerDetail.put("MODULE_ID", 1L);
                adsContainerDetail.put("TAB_ID", (Object)tabId);
                adsContainerDetail.put("FIRST_GRAPH_DURATION", Long.parseLong(interval[0]));
                adsContainerDetail.put("SECOND_GRAPH_DURATION", Long.parseLong(interval[1]));
                adsContainerDetail.put("TOOL_TIP_TEXT", (Object)"adap.home.layout.container.duration_last_x_days");
                adsContainerDetail.put("ONCLICK_FUNC", (Object)"LayoutUtil.triggerFunction('ComponentDurationChange', this)");
                adsContainerDetail.put("LAYOUT_NAME", (Object)layoutName);
                status = AuditReportAPI.getInstance().modifyDashBoard(request, inputMap, inputParamsMap, adsContainerDetail);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Home", rb.handleGetObject("adap.AuditReportAction.audit_entry.graph_added_to_dashboard", new String[]{graphName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Graph_added_to_dashboard", "-"}));
            } else if (action.equalsIgnoreCase("remove")) {
                String conId = request.getParameter("conId");
                status = conId != null ? AuditReportAPI.getInstance().removeFromDashBoard(request, (Object)request.getParameter("graphOptId"), Long.valueOf(Long.parseLong(conId))) : AuditReportAPI.getInstance().removeFromDashBoard((Object)request.getParameter("graphOptId"));
                Row row = ReportUtil.getFirstRow((String)"AUDGraphOptions", (String)"GRAPH_OPT_ID", (Object)Long.parseLong(request.getParameter("graphOptId")), (int)0);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Home", rb.handleGetObject("adap.AuditReportAction.audit_entry.graph_removed_to_dashboard", new String[]{rb.getString((String)row.get("GRAPH_TITLE"))}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Report_Graph_removed_from_dashboard", "-"}));
            }
            ClientUtil.setStatusXMLElement(response, status, "");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", "");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Home", rb.getString("adap.AuditReportAction.audit_entry.problem_addorremove_graph_to_dashboard"), 8, 16, ex.getMessage(), "adap.ADAPUserAuditSeverities.audit_name.problem_removed_graph_from_dashboard", "-"}));
        }
        return null;
    }

    public ActionForward searchReports(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            ArrayList<HashMap> resultantList = new ArrayList<HashMap>();
            ArrayList reportsDetails = AuditReportAPI.getInstance().getReportsDetails();
            ArrayList reportsDetailsClone = (ArrayList)reportsDetails.clone();
            JSONObject jsonObj = new JSONObject(request.getParameter("params"));
            String searchString = jsonObj.getString("searchString");
            String range = jsonObj.getString("range");
            String reportName = null;
            String title = null;
            String desc = null;
            String labels = null;
            if (searchString != null) {
                HashMap reportMap;
                int i;
                searchString = searchString.toLowerCase();
                for (i = 0; i < reportsDetailsClone.size(); ++i) {
                    reportMap = (HashMap)reportsDetailsClone.get(i);
                    reportName = reportMap.get("AUDIT_REPORT_NAME").toString();
                    if (reportName.indexOf(searchString) == -1) continue;
                    resultantList.add(reportMap);
                    reportsDetailsClone.remove(reportMap);
                }
                for (i = 0; i < reportsDetailsClone.size(); ++i) {
                    reportMap = (HashMap)reportsDetailsClone.get(i);
                    title = reportMap.get("TITLE").toString();
                    if (title.indexOf(searchString) == -1) continue;
                    resultantList.add(reportMap);
                    reportsDetailsClone.remove(reportMap);
                }
                for (i = 0; i < reportsDetailsClone.size(); ++i) {
                    reportMap = (HashMap)reportsDetailsClone.get(i);
                    desc = reportMap.get("DESCRIPTION").toString();
                    if (desc.indexOf(searchString) == -1) continue;
                    resultantList.add(reportMap);
                    reportsDetailsClone.remove(reportMap);
                }
                for (i = 0; i < reportsDetailsClone.size(); ++i) {
                    reportMap = (HashMap)reportsDetailsClone.get(i);
                    labels = reportMap.get("LABELS").toString();
                    if (labels.indexOf(searchString) == -1) continue;
                    resultantList.add(reportMap);
                    reportsDetailsClone.remove(reportMap);
                }
            }
            request.setAttribute("resultantList", resultantList);
            request.setAttribute("range", (Object)range);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward("searchReports");
    }

    public ActionForward makeThisReportAsDefault(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuditReportBean bean = (AuditReportBean)form;
        HttpSession session = request.getSession();
        String message = rb.getString("adap.AuditReportAction.Failure_to_make_this_report_as_default");
        try {
            if (DBObjectUtil.setDefaultReport((String)request.getParameter("reportId"))) {
                message = rb.getString("adap.ProductConfigServlet.Successfully_Configured");
            }
            ClientUtil.setStatusXMLElement(response, "Success", message);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Report", rb.handleGetObject("adap.AuditReportAction.audit_entry.report_set_as_default", new String[]{rb.getString((String)bean.get("reportName"))}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.set_default_report", "-"}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", message);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Report", rb.handleGetObject("adap.AuditReportAction.audit_entry.failed_to_set_default_report", new String[]{rb.getString((String)bean.get("reportName"))}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.set_default_report", "-"}));
        }
        return null;
    }

    public ActionForward getObjectDetailsFromSID(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuditReportBean bean = (AuditReportBean)form;
        Properties objectProps = null;
        try {
            String domainName = (String)request.getSession().getAttribute("MONITOR_DOMAIN_NAME");
            JSONObject jsonObj = new JSONObject(request.getParameter("params"));
            String sid = jsonObj.getString("accountSid");
            objectProps = ObjectAttributeDetails.getInstance().getObjectDetailsFromSID(domainName, sid, new Long(1L), "SID_STRING", "user");
            request.setAttribute("objectProps", (Object)objectProps);
            request.setAttribute("accountName", (Object)jsonObj.getString("accountName"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward("objectDetails");
    }

    private void getDefaultColumns(long cvID) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"AUDColumnConfiguration", (String)"CV_ID"), (Object)cvID, 0);
            DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDColumnConfiguration", c);
            if (!dObj.isEmpty()) {
                Iterator it = dObj.getRows("AUDColumnConfiguration", (Criteria)null);
                while (it.hasNext()) {
                    Row s = (Row)it.next();
                    int defaultColumnIndexValue = Integer.parseInt(s.get("DEFAULTCOLUMNINDEX").toString());
                    boolean defaultVisible = Boolean.parseBoolean(s.get("DEFAULTVISIBLE").toString());
                    s.set("VISIBLE", (Object)defaultVisible);
                    s.set("COLUMNINDEX", (Object)defaultColumnIndexValue);
                    dObj.updateRow(s);
                }
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(dObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ActionForward getServices(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        String selectedDomain = request.getParameter("domain");
        String u1 = request.getParameter("users");
        String u2 = request.getParameter("usersGUID");
        String m1 = request.getParameter("machines");
        String m2 = request.getParameter("machinesGUID");
        request.setAttribute("users", (Object)u1);
        request.setAttribute("usersGUID", (Object)u2);
        request.setAttribute("machines", (Object)m1);
        request.setAttribute("machinesGUID", (Object)m2);
        ArrayList<String> errMessages = new ArrayList<String>();
        ArrayList<String> usersGUIDarray = new ArrayList<String>();
        ArrayList<String> machinesGUIDarray = new ArrayList<String>();
        Hashtable<String, String> usersGUIDhash = new Hashtable<String, String>();
        ArrayList<String> machines = new ArrayList<String>();
        ArrayList<String> users = new ArrayList<String>();
        try {
            StringTokenizer st = new StringTokenizer(u2, ",");
            while (st.hasMoreTokens()) {
                usersGUIDarray.add(st.nextToken());
            }
            st = new StringTokenizer(m2, ",");
            while (st.hasMoreTokens()) {
                machinesGUIDarray.add(st.nextToken());
            }
            Iterator iter = DirectoryObjectAPI.getInstance().getObjectRows(null, usersGUIDarray, "user");
            for (String uGUID : usersGUIDarray) {
                Row row = (Row)iter.next();
                usersGUIDhash.put((String)row.get("SAM_ACCOUNT_NAME"), (String)row.get("OBJECT_GUID"));
                users.add((String)row.get("SAM_ACCOUNT_NAME"));
                if (((String)row.get("SAM_ACCOUNT_NAME")).equals((String)row.get("NAME"))) continue;
                usersGUIDhash.put((String)row.get("NAME"), (String)row.get("OBJECT_GUID"));
                users.add((String)row.get("NAME"));
            }
            iter = DirectoryObjectAPI.getInstance().getObjectRows(null, machinesGUIDarray, "computer");
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                machines.add((String)row.get("NAME"));
            }
            HashMap resultMap = new HashMap();
            Criteria c = new Criteria(new Column("AUDADUserServices", "USERNAME"), (Object)"*", 2);
            CommonUtil.getPersistence((boolean[])new boolean[0]).delete(c);
            for (String user : users) {
                for (String machine : machines) {
                    resultMap = ADHandler.getComponentList((String)selectedDomain, (String)user, (String)machine, (String)"service2");
                    if (resultMap.get("result") != null) {
                        ArrayList resultList = (ArrayList)resultMap.get("result");
                        for (int i = 0; i < resultList.size(); ++i) {
                            Hashtable tempHash = (Hashtable)resultList.get(i);
                            String[] startTypeValues = new String[]{rb.getString("adap.Reports.AuditReports.user_services.bootstart"), rb.getString("adap.Reports.AuditReports.user_services.systemstart"), rb.getString("adap.Reports.AuditReports.user_services.autostart"), rb.getString("adap.Reports.AuditReports.user_services.demandstart"), rb.getString("adap.Reports.AuditReports.user_services.disabled")};
                            String[] serviceStatusValues = new String[]{"", rb.getString("adap.Reports.AuditReports.user_services.stopped"), rb.getString("adap.Reports.AuditReports.user_services.startpending"), rb.getString("adap.Reports.AuditReports.user_services.stoppending"), rb.getString("adap.Reports.AuditReports.user_services.servicerunning"), rb.getString("adap.Reports.AuditReports.user_services.continuepending"), rb.getString("adap.Reports.AuditReports.user_services.pausepending"), rb.getString("adap.Reports.AuditReports.user_services.paused")};
                            Row r = new Row("AUDADUserServices");
                            r.set("USERNAME", (Object)user);
                            r.set("USERGUID", usersGUIDhash.get(user));
                            r.set("MACHINE_NAME", (Object)machine);
                            r.set("SERVICE_NAME", tempHash.get("serviceName"));
                            r.set("BINARY_PATH", tempHash.get("binaryPath"));
                            r.set("DISPLAY_NAME", tempHash.get("displayName"));
                            r.set("START_TYPE", (Object)startTypeValues[Integer.parseInt((String)tempHash.get("startType"))]);
                            r.set("SERVICE_STATUS", (Object)serviceStatusValues[Integer.parseInt((String)tempHash.get("serviceStatus"))]);
                            DataObject d = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                            d.addRow(r);
                            CommonUtil.getPersistence((boolean[])new boolean[0]).add(d);
                        }
                    }
                    if (resultMap.get("errorMessage") == null) continue;
                    errMessages.add(machine + "  ->  " + (String)resultMap.get("errorMessage"));
                }
            }
            String guidStr = "'";
            if (usersGUIDarray != null && !usersGUIDarray.isEmpty()) {
                for (Object e : usersGUIDarray) {
                    guidStr = guidStr + (String)e + "','";
                }
                guidStr = guidStr.substring(0, guidStr.length() - 2);
            }
            request.setAttribute("guidStr", (Object)guidStr);
            request.setAttribute("filter", (Object)"All");
            request.setAttribute("objectName", (Object)u1);
            session.setAttribute("errMessages", errMessages);
            request.setAttribute("showErr", (Object)"true");
            logger.log(Level.INFO, "Fetch Services Success");
            request.setAttribute("statusMessage", (Object)rb.getString("adap.Reports.AuditReports.fetching_success"));
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Report", rb.handleGetObject("adap.AuditReportAction.audit_entry.user_Services_from_machine", new String[]{u1, m1}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.User_Service_report_Generated", "-"}));
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Fetch Services Failed : " + e.getMessage());
            request.setAttribute("statusMessage", (Object)rb.getString("adap.Reports.AuditReports.fetching_failed"));
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Report", rb.handleGetObject("adap.AuditReportAction.audit_entry.failed_to_get_user_services", new String[]{u1, m1}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.User_Service_report_Generated", "-"}));
        }
        this.report(mapping, form, request, response);
        return mapping.findForward("report");
    }

    public ActionForward filterChanged(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String u1 = request.getParameter("users");
        String u2 = request.getParameter("usersGUID");
        String m1 = request.getParameter("machines");
        String m2 = request.getParameter("machinesGUID");
        request.setAttribute("machinesGUID", (Object)m2);
        request.setAttribute("usersGUID", (Object)u2);
        request.setAttribute("machines", (Object)m1);
        request.setAttribute("users", (Object)u1);
        String guidStr = "";
        if (request.getParameter("filter").equalsIgnoreCase("all")) {
            StringTokenizer st = new StringTokenizer(u2, ",");
            ArrayList<String> usersGUIDarray = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                usersGUIDarray.add(st.nextToken());
            }
            guidStr = "'";
            if (usersGUIDarray != null && !usersGUIDarray.isEmpty()) {
                for (Object e : usersGUIDarray) {
                    guidStr = guidStr + (String)e + "','";
                }
                guidStr = guidStr.substring(0, guidStr.length() - 2);
            }
            request.setAttribute("objectName", (Object)u1);
        } else {
            guidStr = "'" + request.getParameter("filter") + "'";
            request.setAttribute("objectName", (Object)request.getParameter("filterText"));
        }
        request.setAttribute("guidStr", (Object)guidStr);
        request.setAttribute("filter", (Object)request.getParameter("filter"));
        request.setAttribute("showErr", (Object)"true");
        this.report(mapping, form, request, response);
        return mapping.findForward("report");
    }

    public ActionForward saveSearchReports(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuditReportBean bean = (AuditReportBean)form;
        HttpSession session = request.getSession();
        JSONObject jsonObj = new JSONObject(request.getParameter("params"));
        try {
            rb = ResourceBundleMgr.getInstance().getBundle(request);
            Long categoryId = Long.parseLong(jsonObj.getString("categoryId"));
            Integer categoryType = ReportUtil.getCategoryType((Long)categoryId);
            String selectedTab = "reports";
            if (categoryType == 2) {
                selectedTab = "fileAudit";
            } else if (categoryType == 3) {
                selectedTab = "serverAudit";
            }
            Long newReportId = SearchReports.getInstance().saveSearchReportsResult(categoryId, jsonObj.getString("reportName"), jsonObj.getString("description"), (Long)bean.get("reportId"), (String)bean.get("searchCriteria"), (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID"));
            String status = rb.handleGetObject("adap.AuditReportAction.successfully_created_new_repors", new String[]{"AuditReports.do?selectedTab=" + selectedTab + "&methodToCall=report&init=true&reportId=" + newReportId});
            ClientUtil.setStatusXMLElement(response, "Success", status);
            AuditReportAPI.getInstance().setReportsDetails();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Report", rb.handleGetObject("adap.AuditReportAction.audit_entry.success_to_save_report_with_search", new String[]{rb.getString((String)bean.get("reportName")), jsonObj.getString("reportName")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Report_saved_with_searchstring", "-"}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", ex.getMessage());
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Report", rb.handleGetObject("adap.AuditReportAction.audit_entry.failed_to_save_report_with_search", new String[]{rb.getString((String)bean.get("reportName")), jsonObj.getString("reportName")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Report_saved_with_searchstring"}));
        }
        return null;
    }

    public ActionForward getMatrixDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuditReportBean bean = (AuditReportBean)form;
        String forwardName = "matrixReportRows";
        HttpSession session = request.getSession();
        try {
            MatrixReportParams matrixParams = (MatrixReportParams)request.getSession().getAttribute("matrixParams");
            String action = request.getParameter("action");
            if (action != null) {
                Integer fromIndex = Integer.parseInt(request.getParameter("FROM_INDEX"));
                if (action.equalsIgnoreCase("Next")) {
                    fromIndex = fromIndex + matrixParams.getRange();
                } else if (action.equalsIgnoreCase("Previous")) {
                    fromIndex = fromIndex - matrixParams.getRange();
                }
                bean.set("FROM_INDEX", fromIndex);
            }
            if (request.getParameter("searchStr") != null) {
                String searchString = request.getParameter("searchStr");
                bean.set("searchString", searchString);
                matrixParams.setFirstColValList((Map)matrixParams.getFirstColMap(), searchString);
            } else if (request.getParameter("clearSearch") != null) {
                bean.set("searchString", "");
                matrixParams.setFirstColValList((Map)matrixParams.getFirstColMap(), null);
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Report", rb.handleGetObject("adap.AuditReportAction.audit_entry.report_generated", new String[]{(String)bean.get("reportName")}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.matrix_report_generated", "-"}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward(forwardName);
    }
}

