/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.reports;

import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportCategoryHandler;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportParamsAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ExportUtil;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.server.reports.customreport.MatrixExportUtil;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryAPI;
import com.adventnet.sym.adsm.common.server.util.ADSMPersUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.webclient.components.UICreator;
import com.manageengine.ads.fw.reports.favourites.MyFavRepHandler;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONObject;

public class AuditReportBean
extends DynaValidatorForm {
    protected static Logger logger = Logger.getLogger("ReportLogger");

    protected void initializeBean(HttpServletRequest request) {
        try {
            HttpSession session = request.getSession();
            String selectedTab = "reports";
            if (request.getParameter("selectedTab") != null) {
                selectedTab = request.getParameter("selectedTab");
            }
            this.set("selectedTab", selectedTab);
            String rId = request.getParameter("reportId");
            String uvhPattern = request.getParameter("uvhPattern");
            Long auditReportId = rId != null ? Long.valueOf(rId) : (uvhPattern != null ? DBObjectUtil.getUVHValues((String)"AUDReports", (String)uvhPattern) : (selectedTab.equalsIgnoreCase("serverAudit") ? ReportUtil.getDefaultSAReportId((HttpSession)session, (Long)3L, (String)"AUDReports:audit_report_id:10801") : (Long)session.getAttribute("AUDIT_REPORT_ID")));
            this.set("reportId", ReportUtil.isReportAvailable((Long)auditReportId, (String)selectedTab));
            Long reportId = (Long)this.get("reportId");
            AuditReportAPI.getInstance().updateFrequentViewReports(reportId, (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID"));
            ArrayList fileCreationReports = AuditReportAPI.getInstance().getFileCreationReports();
            if (fileCreationReports.contains(reportId)) {
                session.setAttribute("SHOW_LAST_FILE_UPDATED_TIME", (Object)SchedulerUtil.getLastFileUpdateTime());
                session.setAttribute("IsFileUpdateSchedulerRunning", (Object)ADSMPersUtil.getSyMParameter((String)"IsFileUpdateSchedulerRunning"));
            } else {
                session.setAttribute("SHOW_LAST_FILE_UPDATED_TIME", null);
            }
            Integer reportCategoryType = AuditReportCategoryHandler.getCategoryType((Long)reportId);
            if (reportCategoryType == 1) {
                session.setAttribute("AUDIT_REPORT_ID", (Object)reportId);
            }
            this.set("reportCategoryType", reportCategoryType);
            logger.log(Level.FINE, "reportId b4 getting rows ->  " + reportId);
            String substring = request.getParameter("substring");
            this.set("substring", substring);
            HashMap reportMap = AuditReportAPI.getInstance().getReportDetails(reportId);
            String reportName = (String)reportMap.get("TITLE");
            if (((Boolean)reportMap.get("IS_CUSTOMIZABLE")).booleanValue()) {
                AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
                reportName = reportName + " " + rb.getString("adap.common.text.in") + " " + AuditReportAPI.getInstance().getDomainName(reportId);
            }
            this.set("reportName", reportName);
            this.set("tileName", (String)reportMap.get("TILE_NAME"));
            this.set("displayType", (String)reportMap.get("DISPLAY_TYPE"));
            this.set("REPORT_TYPE", (Integer)reportMap.get("REPORT_TYPE"));
            String domainDisplayType = (String)reportMap.get("DOMAIN_DISPLAY_TYPE");
            this.set("domainDisplayType", domainDisplayType);
            this.set("desc", (String)reportMap.get("DESCRIPTION"));
            HashMap tableViewConfig = AuditReportAPI.getInstance().getTableViewConfig(reportId);
            this.set("sortColumn", (String)tableViewConfig.get("SORTCOLUMN"));
            this.set("sortOrder", (String)tableViewConfig.get("SORTORDER"));
            this.set("RANGE", (Integer)tableViewConfig.get("PAGELENGTH"));
            this.set("PAGELENGTH", (Integer)tableViewConfig.get("PAGELENGTH"));
            this.set("selectedObjectsMap", new HashMap());
            this.set("licenseType", (Integer)reportMap.get("LICENSE_TYPE"));
            this.set("BUSINESS_HOUR", "false");
            this.set("reportCategoryId", (Long)reportMap.get("REPORT_CATEGORY_ID"));
            this.set("defaultflag", null);
            String saclObjectClass = "";
            if (reportMap.get("SACL_ALERT_OBJ_CLASS") != null) {
                saclObjectClass = (String)reportMap.get("SACL_ALERT_OBJ_CLASS");
            }
            this.set("SACL_ALERT_OBJ_CLASS", saclObjectClass);
            this.initParams(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initParams(HttpServletRequest request) throws Exception {
        Long favouriteId = MyFavRepHandler.getFavRepId((Long)((Long)this.get("reportId")), null, null);
        if (request.getParameter("favRepId") != null && favouriteId != null) {
            JSONObject jsonObj = MyFavRepHandler.getParamDetails((Long)Long.parseLong(request.getParameter("favRepId")));
            Iterator iter = jsonObj.keys();
            ArrayList<String> list = new ArrayList<String>();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                if (key.indexOf("object_guid_") == -1) continue;
                list.add(URLDecoder.decode(jsonObj.getString(key), "utf-8"));
            }
            HashMap inputParams = (HashMap)this.get("inputParams");
            if (list.size() > 0) {
                inputParams.put("object_guid", list);
                inputParams.put("objectClass", jsonObj.getString("objectClass"));
            } else {
                inputParams.remove("object_guid");
                inputParams.remove("objectClass");
            }
            this.set("inputParams", inputParams);
            HashMap selectedObjectsMap = (HashMap)this.get("selectedObjectsMap");
            if (inputParams.get("object_guid") != null) {
                selectedObjectsMap.put("object_guid", (ArrayList)inputParams.get("object_guid"));
            }
        } else {
            this.set("inputParams", this.getInputParams((Long)this.get("reportId"), request));
        }
        request.setAttribute("message", (Object)this.saveUDCustomPeriod((HashMap)this.get("inputParams"), request));
        this.set("PAGE_NUMBER", "1");
        this.set("FROM_INDEX", 1);
        this.set("searchString", "");
        this.set("searchCriteria", "");
        this.set("xColumnValue", "");
        this.set("criteriaString", "");
    }

    public void initDomainDetails(Long loginId, HttpSession session) {
        try {
            ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
            ArrayList configuredList = authObj.getConfiguredDomainList();
            this.set("configuredList", configuredList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getColumnSearchCriteria(HttpServletRequest request, Long cvId, boolean countOrRow) {
        String searchCriteria = null;
        String columnName = "";
        String tableName = "";
        try {
            String businessCriteria;
            String dbServerName = CommonUtil.getDBServerName();
            String searchString = (String)this.get("searchString");
            logger.log(Level.FINE, "bean's searchString 1: " + searchString);
            boolean search = false;
            if (request.getParameter("search") != null || request.getParameter("reportSearch") != null) {
                searchString = "";
                search = true;
            }
            Boolean visible = true;
            ArrayList columnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvId, visible);
            for (int i = 0; i < columnList.size(); ++i) {
                HashMap columnMap = (HashMap)columnList.get(i);
                tableName = (String)columnMap.get("TABLEALIAS");
                columnName = (String)columnMap.get("COLUMNALIAS");
                String dataType = null;
                TableDefinition tableDefinition = null;
                if (tableName != null) {
                    tableDefinition = MetaDataUtil.getTableDefinitionByName((String)tableName);
                }
                if (tableDefinition != null) {
                    ColumnDefinition columnDefinition = tableDefinition.getColumnDefinitionByName(columnName);
                    dataType = columnDefinition != null ? columnDefinition.dataTypeStr() : null;
                }
                Long columnConfId = (Long)columnMap.get("COLUMN_CONF_ID");
                String val = null;
                if (search) {
                    if (request.getParameter("search_" + columnConfId.toString()) != null) {
                        val = request.getParameter("search_" + columnConfId);
                        if (!searchString.equalsIgnoreCase("")) {
                            searchString = searchString + "&";
                        }
                        searchString = searchString + "search_" + columnConfId + "=" + val;
                    }
                } else {
                    val = this.getSearchString(searchString, columnConfId);
                }
                if (val == null || val.equalsIgnoreCase("")) continue;
                val = CommonUtil.getSearchString((String)val);
                searchCriteria = searchCriteria == null ? new String() : searchCriteria + " AND ";
                searchCriteria = searchCriteria + this.getSearchString(columnName, val, dataType);
                logger.log(Level.FINE, "searchCriteria is: " + searchCriteria);
            }
            if (search) {
                this.set("searchString", searchString);
                this.set("PAGE_NUMBER", "1");
                this.set("FROM_INDEX", 1);
            }
            if ((businessCriteria = ADAPSQLQueryAPI.getInstance().getBusinessSearchCriteria((String)this.get("BUSINESS_HOUR"), countOrRow)) != null) {
                request.setAttribute("businessSearchString", (Object)((String)this.get("BUSINESS_HOUR")));
                searchCriteria = searchCriteria != null ? searchCriteria + " AND " + businessCriteria : businessCriteria;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return searchCriteria;
    }

    public String getSearchString(String columnName, String val, String dataType) {
        if (dataType == null) {
            return columnName + " LIKE '" + val + "'";
        }
        if (dataType.toLowerCase().indexOf("char") != -1) {
            return columnName + " LIKE '" + val + "'";
        }
        val = val.replaceAll("%", "");
        return columnName + " = " + val;
    }

    public String getSearchString(String searchString, Long id) {
        String val = "";
        int index = searchString.indexOf("search_" + id + "=");
        if (index != -1) {
            val = searchString.indexOf("&", index) != -1 ? searchString.substring(searchString.indexOf("=", index) + 1, searchString.indexOf("&", index)) : searchString.substring(searchString.indexOf("=", index) + 1);
        }
        return val;
    }

    public TreeMap getFormElements(Long reportId, HashMap inputParamsMap, HttpServletRequest request) {
        TreeMap inputElement = new TreeMap();
        try {
            ArrayList elementList = AuditReportParamsAPI.getReportFormElements((Long)reportId, (boolean)false, (HttpServletRequest)request);
            for (Object object : elementList) {
                HashMap elementMap = (HashMap)object;
                String value = "";
                String uiCreatorClass = (String)elementMap.get("UICreator");
                Class<?> classToInvoke = Class.forName(uiCreatorClass.trim());
                UICreator creator = (UICreator)classToInvoke.newInstance();
                Long priorityId = (Long)elementMap.get("priorityId");
                Properties attributeProps = (Properties)elementMap.get("attributeProps");
                String inputName = (String)attributeProps.get("name");
                if (!inputParamsMap.isEmpty()) {
                    if (((String)elementMap.get("inputType")).equalsIgnoreCase("multiple")) {
                        ArrayList valueList = (ArrayList)inputParamsMap.get(inputName);
                        if (valueList.size() == 1) {
                            value = value + valueList.get(0);
                        } else if (valueList.size() > 1) {
                            value = "all";
                        }
                    } else {
                        value = (String)inputParamsMap.get(inputName);
                    }
                }
                String htmlText = creator.constructCell(attributeProps, value);
                HashMap<String, Object> tdMap = new HashMap<String, Object>();
                tdMap.put("htmlText", htmlText);
                tdMap.put("new_row", (Boolean)elementMap.get("new_row"));
                inputElement.put(priorityId, tdMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return inputElement;
    }

    public HashMap getInputParams(Long reportId, HttpServletRequest request) {
        HashMap inputParams = new HashMap();
        try {
            ArrayList inputParamsList = AuditReportParamsAPI.getInputParams((Long)reportId);
            HashMap selectedObjectsMap = (HashMap)this.get("selectedObjectsMap");
            for (Object object : inputParamsList) {
                HashMap inputMap = (HashMap)object;
                String inputType = (String)inputMap.get("inputType");
                String name = (String)inputMap.get("name");
                String nameValue = request.getParameter(name);
                ArrayList inputList = new ArrayList();
                if (inputType.equalsIgnoreCase("single")) {
                    if (nameValue != null) {
                        inputParams.put(name, nameValue);
                        continue;
                    }
                    inputParams.put(name, (String)inputMap.get("defaultValue"));
                    continue;
                }
                if (!inputType.equalsIgnoreCase("multiple")) continue;
                if (nameValue == null) {
                    if ((String)inputMap.get("defaultValue") != null) {
                        inputList.add((String)inputMap.get("defaultValue"));
                    }
                } else if (nameValue.equalsIgnoreCase("range") || nameValue.equalsIgnoreCase("all")) {
                    if (!selectedObjectsMap.isEmpty()) {
                        inputList = (ArrayList)selectedObjectsMap.get(name);
                    }
                } else if (nameValue.equalsIgnoreCase("allobjects")) {
                    inputList.add("allobjects");
                    inputParams.put("allObjectSelected", "true");
                } else if (!"".equals(nameValue)) {
                    inputList.add(nameValue);
                }
                inputParams.put(name, inputList);
            }
            inputParams = this.getCustomPeriod(inputParams, request);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return inputParams;
    }

    public HashMap getInputParamsValues(HashMap inputParams, HttpServletRequest request) {
        Pattern sIDPattern = Pattern.compile("RID::([^\\}]*)");
        HashMap inputParamsMap = null;
        HttpSession session = request.getSession();
        try {
            String domainName = (String)inputParams.remove("domainName");
            Boolean isLockoutHistory = (Boolean)inputParams.remove("isLockoutHistory");
            if (isLockoutHistory == null) {
                if (domainName == null) {
                    domainName = (String)session.getAttribute("MONITOR_DOMAIN_NAME");
                    ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
                    domainName = domainName != null ? domainName : ReportUtil.getFirstDomainFromList((ArrayList)authObject.getConfiguredDomainList());
                }
                this.set("domainName", domainName);
                session.setAttribute("MONITOR_DOMAIN_NAME", (Object)domainName);
            }
            inputParams.put("domainName", domainName);
            HashMap inputParamsCopy = (HashMap)inputParams.clone();
            if (inputParamsCopy != null && !inputParamsCopy.isEmpty()) {
                for (Object key : inputParamsCopy.keySet()) {
                    if (!key.equals("object_guid")) continue;
                    ArrayList<String> guidList = (ArrayList<String>)inputParams.remove(key);
                    if (guidList != null && !guidList.isEmpty()) {
                        String objectClass = (String)inputParams.get("objectClass");
                        for (int i = 0; i < guidList.size(); ++i) {
                            String guidStr = (String)guidList.get(i);
                            Matcher match = sIDPattern.matcher(guidStr);
                            if (match.find()) {
                                Row objectRow = this.getObjectRow(match.group(), inputParams);
                                if (objectRow != null) {
                                    guidList.set(i, (String)objectRow.get("OBJECT_GUID"));
                                    this.setProperty(key, guidList, (String)objectRow.get("OBJECT_GUID"));
                                    continue;
                                }
                                guidList = new ArrayList<String>();
                                continue;
                            }
                            if (!guidStr.equalsIgnoreCase("DEFAULT") || !objectClass.equalsIgnoreCase("Computer")) continue;
                            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMDCConfiguration", (String)"DOMAIN_NAME"), (Object)domainName, 0);
                            DataObject dObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMDCConfiguration", criteria);
                            if (dObject.isEmpty()) continue;
                            Row row = dObject.getFirstRow("ADSMDCConfiguration");
                            Row objectRow = ReportUtil.getComputerObjRow((String)domainName, (String)((String)row.get("DOMAIN_CONTROLLER_NAME")), (String)"NAME", (String)objectClass);
                            if (objectRow != null) {
                                guidList.set(i, (String)objectRow.get("OBJECT_GUID"));
                                this.setProperty(key, guidList, (String)objectRow.get("OBJECT_GUID"));
                                inputParams.put("objectName", (String)objectRow.get("NAME"));
                                continue;
                            }
                            inputParams.put("objectName", "");
                            guidList = new ArrayList();
                        }
                    }
                    inputParams.put(key, guidList);
                }
            }
            inputParamsMap = AuditReportParamsAPI.getInputParamsValues((HashMap)inputParams, (Long)((Long)this.get("reportId")));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger.log(Level.FINE, "inputParamsMap: " + inputParamsMap);
        return inputParamsMap;
    }

    public void exportReport(HttpServletRequest request, HttpServletResponse response) {
        boolean data_available = true;
        HashMap inputDataMap = new HashMap();
        ArrayList columnList = new ArrayList();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String strcvID = request.getParameter("cvID");
            Long cvID = Long.parseLong(strcvID);
            String reportType = request.getParameter("reportType");
            if (reportType == "null") {
                reportType = "";
            }
            String searchCriteria = (String)this.get("searchCriteria");
            if ((String)this.get("xColumnValue") != null && !"".equals((String)this.get("xColumnValue"))) {
                searchCriteria = searchCriteria != null ? (String)this.get("xColumnValue") + " AND " + searchCriteria : (String)this.get("xColumnValue");
            }
            HashMap<String, String> addionalSQLPropsMap = new HashMap<String, String>();
            addionalSQLPropsMap.put("sortColumn", (String)this.get("sortColumn"));
            addionalSQLPropsMap.put("sortOrder", (String)this.get("sortOrder"));
            HashMap reportMap = AuditReportAPI.getInstance().getReportDetails((Long)this.get("reportId"));
            String tileName = (String)this.get("tileName");
            if (tileName.equalsIgnoreCase("matrix")) {
                MatrixExportUtil.exportReport((HttpServletRequest)request, (HttpServletResponse)response, (Long)((Long)this.get("reportId")), (HashMap)((HashMap)this.get("inputParamsMap")), (String)searchCriteria, new HashMap(), (Long)cvID, (String)reportType, (Long)((Long)request.getSession().getAttribute("ADAP_SESSION_LOGIN_ID")), (String)"simple");
            } else {
                ExportUtil.exportReport((Long)cvID, (HashMap)reportMap, (String)((String)this.get("domainName")), (String)searchCriteria, (String)reportType, (HashMap)((HashMap)this.get("inputParamsMap")), addionalSQLPropsMap, (HttpServletRequest)request, (HttpServletResponse)response);
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Reports", rb.handleGetObject("adap.AuditReportBean.audit_entry.report_was_exported", new String[]{rb.getString((String)this.get("reportName")), reportType, (String)this.get("domainName")}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.report_exported", "-"}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Row getObjectRow(String matchStr, HashMap inputParams) throws Exception {
        String domainSID = AuditReportAPI.getInstance().getDomainSIDString((String)inputParams.get("domainName"));
        String callerSID = matchStr.replace("RID::", domainSID + "-");
        Row objectRow = DirectoryObjectAPI.getInstance().getObjectRow((String)inputParams.get("domainName"), callerSID, "SID_STRING", (String)inputParams.get("objectClass"));
        return objectRow;
    }

    public void setProperty(Object keyName, ArrayList guidList, String defaultGUIDValue) throws Exception {
        HashMap selectedObjectsMap = (HashMap)this.get("selectedObjectsMap");
        if (!selectedObjectsMap.isEmpty()) {
            ArrayList list = (ArrayList)selectedObjectsMap.get(keyName);
            if (!list.contains(defaultGUIDValue)) {
                list.add(defaultGUIDValue);
            }
            selectedObjectsMap.put(keyName, list);
        } else {
            selectedObjectsMap.put(keyName, guidList);
        }
        this.set("selectedObjectsMap", selectedObjectsMap);
        logger.log(Level.FINE, "selectedObjectsMap is " + this.get("selectedObjectsMap"));
    }

    public String getSearchCriteria(String searchCriteria) throws Exception {
        String xColumnValue = (String)this.get("xColumnValue");
        if (xColumnValue != null && !"".equals(xColumnValue)) {
            searchCriteria = searchCriteria != null ? xColumnValue + " AND " + searchCriteria : xColumnValue;
        }
        logger.log(Level.FINE, "searchCriteria is " + searchCriteria);
        return searchCriteria;
    }

    private HashMap getCustomPeriod(HashMap inputParams, HttpServletRequest request) throws Exception {
        if (((String)inputParams.get("inputDays")).equalsIgnoreCase("customPeriod")) {
            inputParams.put("startTime", request.getParameter("startTime"));
            inputParams.put("endTime", request.getParameter("endTime"));
            inputParams.put("startHour", request.getParameter("startHour"));
            inputParams.put("endHour", request.getParameter("endHour"));
        } else if (((String)inputParams.get("inputDays")).equalsIgnoreCase("Last_n_period")) {
            if (request.getParameter("last_n").equalsIgnoreCase("")) {
                inputParams.put("last_n", "1");
            } else {
                inputParams.put("last_n", request.getParameter("last_n"));
            }
            inputParams.put("time_period", request.getParameter("time_period"));
        }
        return inputParams;
    }

    private String saveUDCustomPeriod(HashMap inputParams, HttpServletRequest request) throws Exception {
        String message = "";
        if (request.getParameter("inputDays") != null && request.getParameter("inputDays").equalsIgnoreCase("customPeriod") && request.getParameter("enableCustomPeriod") != null) {
            String dispName = request.getParameter("customName").trim();
            dispName = dispName == "" ? this.formDisplayName(inputParams) : dispName;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
            dispName = dispName == rb.getString("adap.CustomPeriodSelection.Optional") ? this.formDisplayName(inputParams) : dispName;
            AuditReportAPI.getInstance();
            message = AuditReportAPI.saveUDCustomPeriod((String)dispName, (HashMap)inputParams);
        }
        return message;
    }

    private String formDisplayName(HashMap inputParams) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(((String)inputParams.get("startTime")).replace(" ", ""));
        sb.append(((String)inputParams.get("startHour")).replace(" ", ""));
        sb.append("-");
        sb.append(((String)inputParams.get("endTime")).replace(" ", ""));
        sb.append(((String)inputParams.get("endHour")).replace(" ", ""));
        return sb.toString();
    }
}

