/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.reports.customreport;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.monitor.ActionConstants;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportParamsAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ReportSchedulerUtil;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.server.reports.customreport.CustomReportHandler;
import com.adventnet.sym.adsm.auditing.server.reports.customreport.CustomReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.reports.customreport.CustomReportBeanUtil;
import com.adventnet.sym.adsm.auditing.webclient.reports.customreport.SchedulerBean;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.JSONUtil;
import com.adventnet.sym.adsm.common.webclient.components.UICreator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class CustomReportBean
extends SchedulerBean {
    private static Logger logger = Logger.getLogger("QueryLogger");

    protected void init(HttpServletRequest request) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        ArrayList domainList = authObject.getConfiguredDomainList();
        String[] domainNames = new String[domainList.size()];
        for (int i = 0; i < domainList.size(); ++i) {
            Properties domainProp = (Properties)domainList.get(i);
            domainNames[i] = domainProp.getProperty("DOMAIN_NAME");
        }
        this.set("domains", domainNames);
        this.set("domainName", (String)session.getAttribute("MONITOR_DOMAIN_NAME"));
        LinkedHashMap viewTypeMap = CustomReportUtil.getViewTypeMap();
        this.set("viewTypeMap", viewTypeMap);
        this.getModules(rb);
        this.set("subModuleMap", CustomReportUtil.getSubModuleMap((AdventNetResourceBundle)rb));
        this.getChartDetails(rb);
        super.getSchedulerDetails(rb);
        this.getCriteriaDetails(rb);
        HashMap categoryMap = CustomReportUtil.getReportCategories((AdventNetResourceBundle)rb, (Long)((Long)session.getAttribute("ADAP_SESSION_LOGIN_ID")));
        this.set("categoryNames", categoryMap.get("clientValues"));
        this.set("categoryIds", categoryMap.get("serverValues"));
    }

    public void getModules(AdventNetResourceBundle rb) throws Exception {
        LinkedHashMap moduleMap = CustomReportUtil.getModuleMap((Long)((Long)this.get("viewType")));
        Set strSet = moduleMap.keySet();
        Long[] moduleIds = new Long[moduleMap.size()];
        String[] moduleDetails = new String[moduleMap.size()];
        int i = 0;
        Iterator iter = strSet.iterator();
        while (iter.hasNext()) {
            Long id;
            moduleIds[i] = id = (Long)iter.next();
            moduleDetails[i] = rb.getString((String)moduleMap.get(id));
            ++i;
        }
        this.set("moduleIds", moduleIds);
        this.set("moduleDetails", moduleDetails);
    }

    public void getChartDetails(AdventNetResourceBundle rb) throws Exception {
        LinkedHashMap chartMap = CustomReportUtil.getChartDetails();
        Set strSet = chartMap.keySet();
        Integer[] chartIds = new Integer[chartMap.size() + 1];
        String[] chartDetails = new String[chartMap.size() + 1];
        chartIds[0] = -1;
        chartDetails[0] = rb.getString("adap.CustomReportBean.Select_Chart_Type");
        int i = 1;
        Iterator iter = strSet.iterator();
        while (iter.hasNext()) {
            Integer id;
            chartIds[i] = id = (Integer)iter.next();
            HashMap detailsMap = (HashMap)chartMap.get(id);
            chartDetails[i] = rb.getString((String)detailsMap.get("CHART_DISPLAY_NAME"));
            ++i;
        }
        this.set("chartIds", chartIds);
        this.set("chartId", chartIds[0]);
        this.set("chartDetails", chartDetails);
        this.set("dateFormatIds", new String[]{"${PATTERNREPLACE:XCOLUMN_DAY_BASED}", "${PATTERNREPLACE:XCOLUMN_HOUR_BASED}"});
        this.set("dateFormatNames", new String[]{rb.getString("adap.CustomReportBean.XCOLUMN_DAY_BASED"), rb.getString("adap.CustomReportBean.XCOLUMN_HOUR_BASED")});
        this.set("chartOrientId", new String[]{"Vertical", "Horizontal"});
        this.set("chartOrientName", new String[]{rb.getString("adap.CustomReportBean.Vertical"), rb.getString("adap.CustomReportBean.Horizontal")});
        this.set("displayFormatNames", new String[]{rb.getString("adap.CustomReportBean.Numeric"), rb.getString("adap.CustomReportBean.Percentage")});
        this.set("displayFormatIds", new Long[]{1L, 2L});
    }

    public String getForwardName() throws Exception {
        Long viewType = (Long)this.get("viewType");
        if (viewType == 3L) {
            return "saveSummaryViewReport";
        }
        if (viewType == 4L) {
            return "savePivotalViewReport";
        }
        return "saveTablularViewReport";
    }

    public void getColumnList(AdventNetResourceBundle rb) throws Exception {
        ArrayList columnsList = CustomReportUtil.getColumnList((Long)((Long)this.get("moduleId")), (String)((String)this.get("subModuleIds")), (AdventNetResourceBundle)rb);
        this.getColumnList(columnsList, rb);
    }

    public void getColumnList(ArrayList columnsList, AdventNetResourceBundle rb) throws Exception {
        this.set("columnsList", columnsList);
        ArrayList<String> availableColumns = new ArrayList<String>();
        availableColumns.add(rb.getString("adap.common.text.select_column"));
        ArrayList<String> visbleColumns = new ArrayList<String>();
        ArrayList<String> nonVisibleColumns = new ArrayList<String>();
        ArrayList<Long> availableColumnIds = new ArrayList<Long>();
        availableColumnIds.add(new Long(-1L));
        ArrayList<Long> visbleColumnIds = new ArrayList<Long>();
        ArrayList<Long> nonVisibleColumnIds = new ArrayList<Long>();
        DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDCustomReportColumnsMapping", new Criteria(Column.getColumn((String)"AUDCustomReportColumnsMapping", (String)"CUSTOM_REPORT_ID"), this.get("customReportId"), 0));
        for (Object object : columnsList) {
            HashMap columnMap = (HashMap)object;
            if (dObj.size("AUDCustomReportColumnsMapping") > 0) {
                Row row = dObj.getRow("AUDCustomReportColumnsMapping", new Criteria(Column.getColumn((String)"AUDCustomReportColumnsMapping", (String)"COLUMN_ID"), (Object)((Long)columnMap.get("COLUMN_ID")), 0));
                if (row == null) {
                    if (((Boolean)columnMap.get("VISIBLE")).booleanValue()) {
                        visbleColumns.add(rb.getString((String)columnMap.get("COLUMN_DISPLAY_NAME")));
                        visbleColumnIds.add((Long)columnMap.get("COLUMN_ID"));
                    } else {
                        nonVisibleColumns.add(rb.getString((String)columnMap.get("COLUMN_DISPLAY_NAME")));
                        nonVisibleColumnIds.add((Long)columnMap.get("COLUMN_ID"));
                    }
                } else if (((Boolean)row.get("VISIBLE")).booleanValue()) {
                    visbleColumns.add(rb.getString((String)columnMap.get("COLUMN_DISPLAY_NAME")));
                    visbleColumnIds.add((Long)columnMap.get("COLUMN_ID"));
                } else {
                    nonVisibleColumns.add(rb.getString((String)columnMap.get("COLUMN_DISPLAY_NAME")));
                    nonVisibleColumnIds.add((Long)columnMap.get("COLUMN_ID"));
                }
            } else if (((Boolean)columnMap.get("VISIBLE")).booleanValue()) {
                visbleColumns.add(rb.getString((String)columnMap.get("COLUMN_DISPLAY_NAME")));
                visbleColumnIds.add((Long)columnMap.get("COLUMN_ID"));
            } else {
                nonVisibleColumns.add(rb.getString((String)columnMap.get("COLUMN_DISPLAY_NAME")));
                nonVisibleColumnIds.add((Long)columnMap.get("COLUMN_ID"));
            }
            availableColumns.add(rb.getString((String)columnMap.get("COLUMN_DISPLAY_NAME")));
            availableColumnIds.add((Long)columnMap.get("COLUMN_ID"));
        }
        this.set("availableColNames", availableColumns.toArray(new String[availableColumns.size()]));
        this.set("availableColIds", availableColumnIds.toArray(new Long[availableColumnIds.size()]));
        this.set("allColumns", nonVisibleColumns.toArray(new String[nonVisibleColumns.size()]));
        this.set("allColumnIds", nonVisibleColumnIds.toArray(new Long[nonVisibleColumnIds.size()]));
        this.set("selectedColNames", visbleColumns.toArray(new String[visbleColumns.size()]));
        this.set("selectedColIds", visbleColumnIds.toArray(new Long[visbleColumnIds.size()]));
        Long viewType = (Long)this.get("viewType");
        String[] summaryTypes = new String[]{"count", "max", "min"};
        String[] summaryTypeNames = new String[]{rb.getString("adap.AUDColumnConfiguration.displayname.COUNT"), rb.getString("adap.common.text.max_value"), rb.getString("adap.common.text.min_value")};
        if (viewType == 4L) {
            summaryTypes = new String[]{"count"};
            summaryTypeNames = new String[]{rb.getString("adap.AUDColumnConfiguration.displayname.COUNT")};
        }
        this.set("summaryTypes", summaryTypes);
        this.set("summaryTypeNames", summaryTypeNames);
    }

    public void getCriteriaDetails(AdventNetResourceBundle rb) throws Exception {
        HashMap<Long, String> elementsMap = new HashMap<Long, String>();
        ArrayList elementsList = AuditReportParamsAPI.getCustomReportCriteriaElements((AdventNetResourceBundle)rb);
        for (Object object : elementsList) {
            HashMap elementMap = (HashMap)object;
            String uiCreatorClass = (String)elementMap.get("UICreator");
            Class<?> classToInvoke = Class.forName(uiCreatorClass.trim());
            UICreator creator = (UICreator)classToInvoke.newInstance();
            Long priorityId = (Long)elementMap.get("priorityId");
            Properties attributeProps = (Properties)elementMap.get("attributeProps");
            String inputName = (String)attributeProps.get("name");
            String htmlText = creator.constructCell(attributeProps, "");
            elementsMap.put((Long)elementMap.get("elementId"), htmlText);
        }
        this.set("elementsMap", elementsMap);
        HashMap timeMap = CustomReportUtil.getTimePeriods((AdventNetResourceBundle)rb);
        this.set("timePeriodCV", timeMap.get("clientValues"));
        this.set("timePeriodSV", timeMap.get("serverValues"));
        this.set("TIME_PERIOD", "twfourhours");
        HashMap relationalOperators = ActionConstants.getRelationalOperaions();
        ArrayList logicOperationsList = ActionConstants.getLogicalOperaions();
        this.set("logicOperationsList", logicOperationsList);
        this.set("relationalOperators", relationalOperators);
    }

    public String getProperties(String action, HttpServletRequest request, LinkedHashMap criteriaMap) throws Exception {
        StringBuilder sb = new StringBuilder();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        ArrayList selectedSM = CustomReportUtil.getSelectedSubModule((String)((String)this.get("subModuleIds")));
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID");
        DataObject customDO = this.getProperties(action, criteriaMap, selectedSM, loginId, request);
        Row customRow = customDO.getFirstRow("AUDCustomReports");
        Long reportId = this.saveThisAsNewReport((Long)session.getAttribute("ADAP_SESSION_LOGIN_ID"), selectedSM, customDO, (Boolean)customRow.get("IS_PUBLIC"), criteriaMap, (String)this.get("domainName"));
        sb.append(rb.getString("adap.CustomReportBean.successfully_created_the_report"));
        sb.append("\n");
        customRow.set("AUDIT_REPORT_ID", (Object)reportId);
        if (((Boolean)this.get("isScheduleSelected")).booleanValue()) {
            DataObject scheDo = this.getSchedulerProperties(action, request, reportId);
            Row scheduleRow = scheDo.getFirstRow("Schedule");
            Row scheduleMapRow = new Row("AUDCustomReportSchedulerMap");
            scheduleMapRow.set("CUSTOM_REPORT_ID", customRow.get("CUSTOM_REPORT_ID"));
            scheduleMapRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
            customDO.addRow(scheduleMapRow);
            customDO.merge(scheDo);
        }
        CustomReportHandler.createReports((DataObject)customDO);
        sb.append(rb.getString("adap.CustomReportBean.Successfully_saved_the_custom_report"));
        return sb.toString();
    }

    public DataObject setSchedulerDetails(DataObject dObj, DataObject oldDO, HttpServletRequest request, String action) throws Exception {
        Row schedMapRow;
        Row reportRow = oldDO.getFirstRow("AUDCustomReports");
        Row row = schedMapRow = oldDO.size("AUDCustomReportSchedulerMap") > 0 ? oldDO.getFirstRow("AUDCustomReportSchedulerMap") : null;
        if (((Boolean)this.get("isScheduleSelected")).booleanValue() && oldDO.size("AUDCustomReportSchedulerMap") == -1) {
            if (schedMapRow != null) {
                this.set("scheduleId", schedMapRow.get("SCHEDULE_ID"));
            } else {
                action = "new";
            }
            DataObject scheDo = this.getSchedulerProperties(action, request, (Long)reportRow.get("AUDIT_REPORT_ID"));
            Row scheduleRow = scheDo.getFirstRow("Schedule");
            Row scheduleMapRow = new Row("AUDCustomReportSchedulerMap");
            scheduleMapRow.set("CUSTOM_REPORT_ID", this.get("customReportId"));
            scheduleMapRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
            dObj.addRow(scheduleMapRow);
            dObj.merge(scheDo);
        } else if (!((Boolean)this.get("isScheduleSelected")).booleanValue() && oldDO.size("AUDCustomReportSchedulerMap") > 0) {
            ReportSchedulerUtil.deleteScheduler((Long)((Long)schedMapRow.get("SCHEDULE_ID")));
        } else if (((Boolean)this.get("isScheduleSelected")).booleanValue() && oldDO.size("AUDCustomReportSchedulerMap") > 0) {
            dObj.addRow(schedMapRow);
            this.set("scheduleId", schedMapRow.get("SCHEDULE_ID"));
            if (request.getParameter("isNotificationEnabled") == null) {
                this.set("isNotificationEnabled", false);
            }
            if (request.getParameter("isZipFile") == null) {
                this.set("isZipFile", false);
            }
            if (request.getParameter("isReportsEmpty") == null) {
                this.set("isReportsEmpty", false);
            }
            DataObject scheDo = this.getSchedulerProperties(action, request, (Long)reportRow.get("AUDIT_REPORT_ID"));
            ReportSchedulerUtil.updateScheduler((DataObject)scheDo, (Long)((Long)schedMapRow.get("SCHEDULE_ID")), null);
        }
        return dObj;
    }

    public DataObject getSchedulerProperties(String action, HttpServletRequest request, Long reportId) throws Exception {
        this.set("scheduleName", (String)this.get("customReportName") + "_" + reportId);
        this.set("description", this.get("custReportDesc"));
        return super.getProperties(action, request, reportId);
    }

    public DataObject getProperties(String action, LinkedHashMap criteriaMap, ArrayList selectedSM, Long loginId, HttpServletRequest request) throws Exception {
        DataObject customDO = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
        Row customRow = new Row("AUDCustomReports");
        if (action.equalsIgnoreCase("update")) {
            customRow.set("CUSTOM_REPORT_ID", this.get("customReportId"));
        }
        customRow.set("CREATION_TIME", (Object)System.currentTimeMillis());
        customRow.set("MODIFICATION_TIME", (Object)System.currentTimeMillis());
        customRow.set("DOMAIN_NAME", (Object)((String)this.get("domainName")));
        customRow.set("DEFAULT_REPORT_PERIOD", (Object)((String)this.get("TIME_PERIOD")));
        Long viewType = (Long)this.get("viewType");
        customRow.set("REPORT_VIEW", (Object)viewType);
        customRow.set("MODULE_ID", (Object)((Long)this.get("moduleId")));
        customRow.set("CHART_ID", (Object)((Integer)this.get("chartId")));
        customRow.set("IS_SCHEDULE_ENABLED", (Object)((Boolean)this.get("isScheduleSelected")));
        if (request.getParameter("categoryName") != null) {
            this.set("categoryId", ReportUtil.addNewReportCategory((String)request.getParameter("categoryName")));
        }
        customRow.set("REPORT_CATEGORY_ID", (Object)((Long)this.get("categoryId")));
        Boolean isPublic = false;
        if ("public".equalsIgnoreCase((String)this.get("isPublic"))) {
            isPublic = true;
        }
        customRow.set("IS_PUBLIC", (Object)isPublic);
        customRow.set("ISREADONLY", (Object)false);
        customRow.set("LOGIN_ID", (Object)loginId);
        customRow.set("CRITERIA_PATTERN", (Object)((String)this.get("criteriaValue")));
        if (((String)this.get("TIME_PERIOD")).equalsIgnoreCase("customPeriod")) {
            customRow.set("FROM_TIME", (Object)((String)this.get("fromTime")));
            customRow.set("TO_TIME", (Object)((String)this.get("toTime")));
        }
        customDO.addRow(customRow);
        String[] availableColumns = (String[])this.get("availableColumns");
        String[] selectedColumns = (String[])this.get("selectedColumns");
        String[] colNames = new String[]{"CUSTOM_REPORT_ID", "COLUMN_ID", "COLUMNINDEX", "VISIBLE"};
        if (viewType == 1L) {
            Object[] colValues;
            int i;
            for (i = 0; i < selectedColumns.length; ++i) {
                colValues = new Object[]{customRow.get("CUSTOM_REPORT_ID"), Long.parseLong(selectedColumns[i]), i + 1, true};
                customDO.addRow(this.formRow("AUDCustomReportColumnsMapping", colNames, colValues));
            }
            for (i = 0; i < availableColumns.length; ++i) {
                colValues = new Object[]{customRow.get("CUSTOM_REPORT_ID"), Long.parseLong(availableColumns[i]), selectedColumns.length + i + 1, false};
                customDO.addRow(this.formRow("AUDCustomReportColumnsMapping", colNames, colValues));
            }
        } else {
            Long[] availableColIds = (Long[])this.get("availableColIds");
            for (int i = 0; i < availableColIds.length; ++i) {
                if (availableColIds[i] == -1L) continue;
                Object[] colValues = new Object[]{customRow.get("CUSTOM_REPORT_ID"), availableColIds[i], i + 1, true};
                customDO.addRow(this.formRow("AUDCustomReportColumnsMapping", colNames, colValues));
            }
        }
        for (int i = 0; i < selectedSM.size(); ++i) {
            Row selectedSMRow = new Row("AUDCustomReportSubModuleMap");
            selectedSMRow.set("CUSTOM_REPORT_ID", customRow.get("CUSTOM_REPORT_ID"));
            selectedSMRow.set("SUB_MODULE_ID", selectedSM.get(i));
            customDO.addRow(selectedSMRow);
        }
        if (viewType == 3L) {
            Row summaryRow = new Row("AUDSummaryReportDetails");
            summaryRow.set("CUSTOM_REPORT_ID", customRow.get("CUSTOM_REPORT_ID"));
            summaryRow.set("GROUP_LEFT_COLUMN_1", (Object)((Long)this.get("summaryCol1")));
            if ((Long)this.get("summaryCol2") != -1L) {
                summaryRow.set("GROUP_LEFT_COLUMN_2", (Object)((Long)this.get("summaryCol2")));
            }
            if ((Long)this.get("summaryCol3") != -1L) {
                summaryRow.set("GROUP_LEFT_COLUMN_3", (Object)((Long)this.get("summaryCol3")));
            }
            String summaryType = (String)this.get("summaryType");
            summaryRow.set("SUMMARY_TYPE", (Object)summaryType);
            if (!summaryType.equalsIgnoreCase("count")) {
                summaryRow.set("SUMMARY_COLUMN", (Object)((Long)this.get("summaryColumn")));
            }
            customDO.addRow(summaryRow);
        } else if (viewType == 4L) {
            Row matrixRow = new Row("AUDMatrixReportDetails");
            matrixRow.set("CUSTOM_REPORT_ID", customRow.get("CUSTOM_REPORT_ID"));
            matrixRow.set("GROUP_TOP_COLUMN", this.get("topColumn"));
            matrixRow.set("GROUP_LEFT_COLUMN", this.get("leftColumn"));
            if ((Long)this.get("summaryColumn") != -1L) {
                matrixRow.set("SUMMARY_COLUMN", this.get("summaryColumn"));
            }
            matrixRow.set("SUMMARY_TYPE", this.get("summaryType"));
            customDO.addRow(matrixRow);
        }
        if ((Integer)this.get("chartId") != -1) {
            Row chartRow = this.getChartRow();
            chartRow.set("CUSTOM_REPORT_ID", customRow.get("CUSTOM_REPORT_ID"));
            customDO.addRow(chartRow);
        }
        this.addCriteriaRow(customDO, criteriaMap);
        return customDO;
    }

    private void addCriteriaRow(DataObject customDO, LinkedHashMap criteriaMap) throws Exception {
        Set keys = criteriaMap.keySet();
        Row customRow = customDO.getFirstRow("AUDCustomReports");
        int priorityId = 1;
        for (Integer obj : keys) {
            HashMap detailsMap = (HashMap)criteriaMap.get(obj);
            if (detailsMap.size() > 0) {
                Row row = new Row("AUDCustomReportFilterMapping");
                row.set("CUSTOM_REPORT_ID", customRow.get("CUSTOM_REPORT_ID"));
                row.set("COLUMN_ID", detailsMap.get("columnField"));
                row.set("RELATIONAL_OPERATOR", (Object)Long.parseLong((String)detailsMap.get("relOper")));
                row.set("LOGICAL_OPERATOR", detailsMap.get("logicalOper"));
                row.set("PRIORITY_ID", (Object)priorityId);
                String objectClass = (String)detailsMap.get("objectClass");
                if (objectClass == null || "".equalsIgnoreCase(objectClass)) {
                    row.set("VALUE", detailsMap.get("names"));
                } else {
                    row.set("VALUE", (Object)(objectClass + ";;;" + detailsMap.get("objectGuidStr")));
                }
                customDO.addRow(row);
            }
            ++priorityId;
        }
    }

    private Long saveThisAsNewReport(Long loginId, ArrayList<Long> selectedSM, DataObject customDO, Boolean isPublic, LinkedHashMap criteriaMap, String domainName) throws Exception {
        return CustomReportHandler.saveThisAsNewReport((Long)((Long)this.get("categoryId")), (String)((String)this.get("customReportName")), (String)((String)this.get("custReportDesc")), (boolean)isPublic, (Long)loginId, (Integer)((Integer)this.get("chartId")), (Long)((Long)this.get("viewType")), (Long)((Long)this.get("moduleId")), selectedSM, (DataObject)customDO, (LinkedHashMap)criteriaMap, (String)domainName);
    }

    private Row formRow(String tableName, String[] colNames, Object[] colValues) throws Exception {
        Row row = new Row(tableName);
        for (int i = 0; i < colNames.length; ++i) {
            row.set(colNames[i], colValues[i]);
        }
        return row;
    }

    private Row getChartRow() throws Exception {
        Row chartRow = new Row("AUDChartProperties");
        Integer chartId = (Integer)this.get("chartId");
        if (chartId == 1 || chartId == 2) {
            chartRow.set("XCOLUMN", (Object)((Long)this.get("groupByColumn")));
            chartRow.set("GROUPBY", (Object)((Long)this.get("groupByColumn")));
        } else if (chartId == 3 || chartId == 4) {
            chartRow.set("XCOLUMN", (Object)((Long)this.get("groupByXColumn")));
            chartRow.set("GROUPBY", (Object)((Long)this.get("groupByXColumn")));
            chartRow.set("LIMIT_VALUE", (Object)((Integer)this.get("limitValue")));
        } else if (chartId == 5) {
            chartRow.set("DATEFORMAT", (Object)((String)this.get("dateFormat")));
            chartRow.set("GROUPBY", (Object)((Long)this.get("timeSeriesGroupByColumn")));
        } else if (chartId == 6) {
            chartRow.set("DATEFORMAT", (Object)((String)this.get("dateFormat")));
            chartRow.set("GROUPBY", (Object)((Long)this.get("lineGroupByColumn")));
        } else if (chartId == 7) {
            chartRow.set("XCOLUMN", (Object)((Long)this.get("stackedColumn")));
            chartRow.set("XCOLUMN2", (Object)((Long)this.get("stackedOn")));
            chartRow.set("BARCHARTBY", (Object)((String)this.get("barChartBy")));
        }
        chartRow.set("YCOLUMN", (Object)"adapcount");
        chartRow.set("FORMAT_ID", (Object)new Long(1L));
        return chartRow;
    }

    private void setChartDetails(Integer chartId, Row chartRow) throws Exception {
        if (chartId == 1 || chartId == 2) {
            this.set("groupByColumn", (Long)chartRow.get("XCOLUMN"));
        } else if (chartId == 3 || chartId == 4) {
            this.set("groupByXColumn", (Long)chartRow.get("XCOLUMN"));
            this.set("limitValue", (Integer)chartRow.get("LIMIT_VALUE"));
        } else if (chartId == 5) {
            this.set("dateFormat", chartRow.get("DATEFORMAT"));
            this.set("timeSeriesGroupByColumn", (Long)chartRow.get("GROUPBY"));
        } else if (chartId == 6) {
            this.set("dateFormat", chartRow.get("DATEFORMAT"));
            this.set("lineGroupByColumn", (Long)chartRow.get("GROUPBY"));
        } else if (chartId == 7) {
            this.set("stackedColumn", (Long)chartRow.get("XCOLUMN"));
            this.set("stackedOn", (Long)chartRow.get("XCOLUMN2"));
            this.set("barChartBy", (String)chartRow.get("BARCHARTBY"));
        }
    }

    private void setColumnsList(HttpServletRequest request, DataObject dObj) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HashMap<String, ArrayList<Object>> detailsMap = CustomReportBeanUtil.getColumnsListDetails(dObj, rb);
        this.getColumnList(detailsMap.get("columnsList"), rb);
        this.set("selectedColIds", detailsMap.get("selectedIdList").toArray(new Long[detailsMap.get("selectedIdList").size()]));
        this.set("selectedColNames", detailsMap.get("selectedColsList").toArray(new String[detailsMap.get("selectedColsList").size()]));
    }

    public void setProperties(Long customReportId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        DataObject dObj = CustomReportHandler.getConfiguredReportDetails((Long)customReportId);
        Row reportRow = dObj.getFirstRow("AUDReports");
        this.set("customReportName", (String)reportRow.get("AUDIT_REPORT_NAME"));
        this.set("custReportDesc", (String)reportRow.get("DESCRIPTION"));
        this.set("customReportId", customReportId);
        Row customReportRow = dObj.getFirstRow("AUDCustomReports");
        this.set("domainName", (String)customReportRow.get("DOMAIN_NAME"));
        Long reportView = (Long)customReportRow.get("REPORT_VIEW");
        this.set("viewType", reportView);
        this.set("moduleId", (Long)customReportRow.get("MODULE_ID"));
        this.set("isScheduleSelected", (Boolean)customReportRow.get("IS_SCHEDULE_ENABLED"));
        this.set("subModuleIds", CustomReportBeanUtil.getSubModules(dObj));
        Integer chartId = (Integer)customReportRow.get("CHART_ID");
        if (chartId != -1) {
            this.set("isGraphSelected", true);
            this.setChartDetails(chartId, dObj.getFirstRow("AUDChartProperties"));
            this.set("displayFormat", new Long(1L));
        }
        this.set("chartId", chartId);
        this.setColumnsList(request, dObj);
        this.set("TIME_PERIOD", (String)customReportRow.get("DEFAULT_REPORT_PERIOD"));
        if ("customPeriod".equalsIgnoreCase((String)customReportRow.get("DEFAULT_REPORT_PERIOD"))) {
            this.set("fromTime", (String)customReportRow.get("FROM_TIME"));
            this.set("toTime", (String)customReportRow.get("TO_TIME"));
        }
        this.set("criteriaValue", customReportRow.get("CRITERIA_PATTERN"));
        if (reportView == 3L) {
            Row summaryRow = dObj.getFirstRow("AUDSummaryReportDetails");
            this.set("summaryCol1", (Long)summaryRow.get("GROUP_LEFT_COLUMN_1"));
            this.set("summaryCol2", (Long)summaryRow.get("GROUP_LEFT_COLUMN_2"));
            this.set("summaryCol3", (Long)summaryRow.get("GROUP_LEFT_COLUMN_3"));
            this.set("summaryColumn", summaryRow.get("SUMMARY_COLUMN") != null ? (Long)summaryRow.get("SUMMARY_COLUMN") : -1L);
            this.set("summaryType", (String)summaryRow.get("SUMMARY_TYPE"));
        } else if (reportView == 4L) {
            Row matrixRow = dObj.getFirstRow("AUDMatrixReportDetails");
            this.set("leftColumn", (Long)matrixRow.get("GROUP_LEFT_COLUMN"));
            this.set("topColumn", (Long)matrixRow.get("GROUP_TOP_COLUMN"));
            this.set("summaryColumn", matrixRow.get("SUMMARY_COLUMN") != null ? (Long)matrixRow.get("SUMMARY_COLUMN") : -1L);
            this.set("summaryType", (String)matrixRow.get("SUMMARY_TYPE"));
        }
        this.set("categoryId", (Long)customReportRow.get("REPORT_CATEGORY_ID"));
        if (((Boolean)customReportRow.get("IS_PUBLIC")).booleanValue()) {
            this.set("isPublic", "public");
        } else {
            this.set("isPublic", "private");
        }
        this.set("reportId", (Long)customReportRow.get("AUDIT_REPORT_ID"));
        this.set("criteriaString", JSONUtil.convertListMapToJSON((List)CustomReportBeanUtil.getCriteriaList(dObj)));
        if (dObj.size("AUDCustomReportSchedulerMap") > 0) {
            Row scheduleMapRow = dObj.getFirstRow("AUDCustomReportSchedulerMap");
            super.setProperties((Long)scheduleMapRow.get("SCHEDULE_ID"));
        }
    }
}

