/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.reports.customreport;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditCategoryHandler;
import com.adventnet.sym.adsm.auditing.server.reports.customreport.CustomReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.reports.customreport.CustomReportBean;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.Action;
import org.json.JSONObject;

public class CustomReportBeanUtil
extends Action {
    private static Logger logger = Logger.getLogger("QueryLogger");

    public static LinkedHashMap formCriteriaMap(HttpServletRequest request) throws Exception {
        LinkedHashMap criteriaMap = new LinkedHashMap();
        JSONObject jsonObj = new JSONObject(request.getParameter("params"));
        char[] charArray = jsonObj.toString().toCharArray();
        Integer size = Integer.parseInt(jsonObj.getString("size"));
        for (int i = 1; i <= size; ++i) {
            String[] valArr = jsonObj.getString(String.valueOf(i)).split(";;;");
            if (valArr.length != 6) continue;
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            valueMap.put("logicalOper", valArr[0]);
            valueMap.put("columnField", valArr[1]);
            valueMap.put("relOper", valArr[2]);
            valueMap.put("names", valArr[3]);
            if (!"-".equalsIgnoreCase(valArr[5])) {
                valueMap.put("objectClass", valArr[5]);
                String[] guids = valArr[4].split(",");
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(Arrays.asList(guids));
                valueMap.put("object_guid", list);
                valueMap.put("objectGuidStr", valArr[4]);
            }
            if (!"-".equalsIgnoreCase(valArr[3]) && !"AllObjects".equalsIgnoreCase(valArr[4])) {
                criteriaMap.put(i, valueMap);
                continue;
            }
            criteriaMap.put(i, new HashMap());
        }
        logger.log(Level.INFO, "The Filter Map is " + criteriaMap);
        return criteriaMap;
    }

    public static HashMap<String, ArrayList<Object>> getColumnsListDetails(DataObject dObj, AdventNetResourceBundle rb) throws Exception {
        HashMap columnsMap = AuditCategoryHandler.getInstance().getColumnsMap();
        HashMap<String, ArrayList<Object>> detailsMap = new HashMap<String, ArrayList<Object>>();
        ArrayList<Long> selectedIdList = new ArrayList<Long>();
        ArrayList<String> selectedColsList = new ArrayList<String>();
        ArrayList<HashMap> columnsList = new ArrayList<HashMap>();
        Iterator iter = dObj.getRows("AUDCustomReportColumnsMapping");
        while (iter.hasNext()) {
            Row columnRow = (Row)iter.next();
            Long columnId = (Long)columnRow.get("COLUMN_ID");
            columnsList.add((HashMap)columnsMap.get(columnId));
            if (!((Boolean)columnRow.get("VISIBLE")).booleanValue()) continue;
            selectedIdList.add(columnId);
            selectedColsList.add(rb.getString((String)((HashMap)columnsMap.get(columnId)).get("COLUMN_DISPLAY_NAME")));
        }
        detailsMap.put("selectedIdList", selectedIdList);
        detailsMap.put("selectedColsList", selectedColsList);
        detailsMap.put("columnsList", columnsList);
        return detailsMap;
    }

    public static String getSubModules(DataObject dObj) throws Exception {
        String subModuleIds = null;
        StringBuilder sb = new StringBuilder();
        if (dObj.size("AUDCustomReportSubModuleMap") > 0) {
            int i = 0;
            Iterator iterator = dObj.getRows("AUDCustomReportSubModuleMap");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                if (i != 0) {
                    sb.append(";;;");
                }
                sb.append(row.get("SUB_MODULE_ID"));
                ++i;
            }
            subModuleIds = sb.toString();
        }
        return subModuleIds;
    }

    public static ArrayList getCriteriaList(DataObject dataObj) throws Exception {
        ArrayList criteriaList = new ArrayList();
        if (dataObj.size("AUDCustomReportFilterMapping") > 0) {
            Row filterRow = dataObj.getFirstRow("AUDCustomReportFilterMapping");
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDCustomReportFilterMapping"));
            query.addSelectColumn(Column.getColumn((String)"AUDCustomReportFilterMapping", (String)"*"));
            query.setCriteria(new Criteria(Column.getColumn((String)"AUDCustomReportFilterMapping", (String)"CUSTOM_REPORT_ID"), filterRow.get("CUSTOM_REPORT_ID"), 0));
            query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDCustomReportFilterMapping", (String)"PRIORITY_ID"), true));
            DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            int i = 0;
            Iterator iterator = dObj.getRows("AUDCustomReportFilterMapping");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                HashMap<String, Object> detailsMap = new HashMap<String, Object>();
                detailsMap.put("columnField", row.get("COLUMN_ID"));
                detailsMap.put("logicalOper", row.get("LOGICAL_OPERATOR"));
                detailsMap.put("relOper", row.get("RELATIONAL_OPERATOR"));
                String[] val = ((String)row.get("VALUE")).split(";;;");
                if (val.length > 1) {
                    detailsMap.put("objectClass", val[0]);
                    detailsMap.put("object_guid", val[1]);
                    if ("share".equalsIgnoreCase(val[0])) {
                        detailsMap.put("names", val[1]);
                    } else {
                        ArrayList<String> list = new ArrayList<String>();
                        list.addAll(Arrays.asList(val[1].split(",")));
                        Iterator iter = DirectoryObjectAPI.getInstance().getObjectRows(null, list, val[0]);
                        String names = "";
                        if (iter != null) {
                            while (iter.hasNext()) {
                                Row objectRow = (Row)iter.next();
                                names = names != "" ? names + "," + (String)objectRow.get("NAME") : (String)objectRow.get("NAME");
                            }
                        } else {
                            names = val[1];
                        }
                        detailsMap.put("names", names);
                    }
                } else {
                    detailsMap.put("names", val[0]);
                }
                criteriaList.add(detailsMap);
                ++i;
            }
        }
        return criteriaList;
    }

    public static HashMap<String, Object> getSelectedModuleDetails(CustomReportBean custReportBean) throws Exception {
        HashMap<String, Object> moduleSubModuleMap = new HashMap<String, Object>();
        HashMap<Long, String> subModuleMap = new HashMap<Long, String>();
        LinkedHashMap moduleMap = CustomReportUtil.getModuleMap((Long)((Long)custReportBean.get("viewType")));
        moduleSubModuleMap.put("MODULE_NAME", moduleMap.get((Long)custReportBean.get("moduleId")));
        ArrayList subModuleList = CustomReportUtil.getSelectedSubModule((String)((String)custReportBean.get("subModuleIds")));
        Collections.sort(subModuleList);
        LinkedHashMap subModmap = CustomReportUtil.subModuleDetails;
        for (int i = 0; i < subModuleList.size(); ++i) {
            Row row = (Row)subModmap.get((Long)subModuleList.get(i));
            if (row == null) continue;
            subModuleMap.put((Long)subModuleList.get(i), (String)row.get("SUB_MODULE_DISPLAY_NAME"));
        }
        moduleSubModuleMap.put("SUB_MODULES", subModuleMap);
        return moduleSubModuleMap;
    }
}

