/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.reports.customreport;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.ReportSchedulerUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.taskengine.util.ScheduleUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.validator.DynaValidatorForm;

public class SchedulerBean
extends DynaValidatorForm {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");
    private static final String EVENT_TASK_NAME = "ReportScheduler";

    public void getSchedulerDetails(AdventNetResourceBundle rb) throws Exception {
        Integer[] hourOfDay = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
        Integer[] minutes = new Integer[]{0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55};
        String[] hourlyPeriods = new String[]{rb.getString("adap.ReportSchedulerBean.Previous_Hour"), rb.getString("adap.ReportSchedulerBean.Last_60_Minutes")};
        String[] hourlyPeriodValues = new String[]{"lastHour", "onehour"};
        this.set("hours", hourOfDay);
        this.set("minutes", minutes);
        this.set("hourlyPeriods", hourlyPeriods);
        this.set("hourlyPeriodValues", hourlyPeriodValues);
        String[] dailyPeriods = new String[]{rb.getString("adap.ReportSchedulerBean.Previous_Day00002359"), rb.getString("adap.ReportSchedulerBean.Last_24_Hours"), rb.getString("adap.AudSelectElementAttr.Last_12_Hours"), rb.getString("adap.AudSelectElementAttr.Last_6_Hours")};
        String[] dailyPeriodValues = new String[]{"Yesterday", "twfourhours", "twelvehours", "sixhours"};
        this.set("hoursOfDay", hourOfDay);
        this.set("minutesOfDay", minutes);
        this.set("dailyPeriods", dailyPeriods);
        this.set("dailyPeriodValues", dailyPeriodValues);
        String[] daysOfWeek = new String[]{rb.getString("adap.ReportSchedulerBean.Sunday"), rb.getString("adap.ReportSchedulerBean.Monday"), rb.getString("adap.ReportSchedulerBean.Tuesday"), rb.getString("adap.ReportSchedulerBean.Wednesday"), rb.getString("adap.ReportSchedulerBean.Thursday"), rb.getString("adap.ReportSchedulerBean.Friday"), rb.getString("adap.ReportSchedulerBean.Saturday")};
        Integer[] daysOfWeekValues = new Integer[]{1, 2, 3, 4, 5, 6, 7};
        String[] weeklyPeriods = new String[]{rb.getString("adap.ReportSchedulerBean.Previous_WeekSun_0000__Sat"), rb.getString("adap.ReportSchedulerBean.Last_7_Days")};
        String[] weeklyPeriodValues = new String[]{"lastWeek", "Last_7_Days"};
        this.set("daysOfWeek", daysOfWeek);
        this.set("daysOfWeekValues", daysOfWeekValues);
        this.set("hoursOfWeek", hourOfDay);
        this.set("minutesOfWeek", minutes);
        this.set("weeklyPeriods", weeklyPeriods);
        this.set("weeklyPeriodValues", weeklyPeriodValues);
        Integer[] datesOfMonth = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
        String[] monthlyPeriods = new String[]{rb.getString("adap.ReportSchedulerBean.Previous_Month"), rb.getString("adap.ReportSchedulerBean.Last_30_Days")};
        String[] monthlyPeriodValues = new String[]{"Last_Month", "Last_30_Days"};
        this.set("datesOfMonth", datesOfMonth);
        this.set("hoursOfMonth", hourOfDay);
        this.set("minutesOfMonth", minutes);
        this.set("monthlyPeriods", monthlyPeriods);
        this.set("monthlyPeriodValues", monthlyPeriodValues);
        String fileStoragePath = ReportSchedulerUtil.getFileStoragePath();
        this.set("fileStoragePath", fileStoragePath);
        this.set("BUSINESS_HOUR", "false");
        String[] fileFormats = new String[]{"pdf", "xls", "csv", "html"};
        this.set("fileFormats", fileFormats);
    }

    public DataObject getProperties(String action, HttpServletRequest request, Long reportId) throws Exception {
        reportLogger.log(Level.FINE, "now am in getProperties " + action);
        Integer timePeriod = 0;
        String reportPeriod = null;
        DataObject scheduleDO = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
        Row scheduleRow = new Row("Schedule");
        if (action.equalsIgnoreCase("update")) {
            scheduleRow.set("SCHEDULE_ID", this.get("scheduleId"));
        }
        scheduleRow.set("SCHEDULE_NAME", this.get("scheduleName"));
        scheduleRow.set("DESCRIPTION", this.get("description"));
        scheduleDO.addRow(scheduleRow);
        if (((String)this.get("reportType")).equalsIgnoreCase("hourly")) {
            reportPeriod = (String)this.get("selectedHourlyPeriod");
            Row periodicRow = new Row("Periodic");
            periodicRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
            periodicRow.set("TIME_PERIOD", (Object)1L);
            periodicRow.set("UNIT_OF_TIME", (Object)"Hours");
            Date dateObj = new Date();
            dateObj.setHours((Integer)this.get("selectedHour"));
            dateObj.setMinutes((Integer)this.get("selectedMinute"));
            dateObj.setSeconds(0);
            reportLogger.log(Level.FINE, "start time is " + dateObj);
            periodicRow.set("START_DATE", (Object)new Timestamp(dateObj.getTime()));
            scheduleDO.addRow(periodicRow);
        } else {
            Row calendarRow = new Row("Calendar");
            calendarRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
            if (((String)this.get("reportType")).equalsIgnoreCase("daily")) {
                reportPeriod = (String)this.get("selectedDailyPeriod");
                timePeriod = (Integer)this.get("selectedHourOfDay") * 60 + (Integer)this.get("selectedMinuteOfDay");
                calendarRow.set("TIME_OF_DAY", (Object)timePeriod.longValue());
                calendarRow.set("UNIT_OF_TIME", (Object)"Minutes");
                calendarRow.set("REPEAT_FREQUENCY", (Object)"Daily");
            } else if (((String)this.get("reportType")).equalsIgnoreCase("weekly")) {
                reportPeriod = (String)this.get("selectedWeeklyPeriod");
                timePeriod = (Integer)this.get("hourOfWeek") * 60 + (Integer)this.get("minuteOfWeek");
                calendarRow.set("DAY_OF_WEEK", (Object)((Integer)this.get("dayOfWeek")));
                calendarRow.set("TIME_OF_DAY", (Object)timePeriod.longValue());
                calendarRow.set("UNIT_OF_TIME", (Object)"Minutes");
                calendarRow.set("REPEAT_FREQUENCY", (Object)"Weekly");
            } else if (((String)this.get("reportType")).equalsIgnoreCase("monthly")) {
                reportPeriod = (String)this.get("selectedMonthlyPeriod");
                timePeriod = (Integer)this.get("hourOfMonth") * 60 + (Integer)this.get("minuteOfMonth");
                calendarRow.set("DATE_OF_MONTH", this.get("dateOfMonth"));
                calendarRow.set("TIME_OF_DAY", (Object)timePeriod.longValue());
                calendarRow.set("UNIT_OF_TIME", (Object)"Minutes");
                calendarRow.set("REPEAT_FREQUENCY", (Object)"Monthly");
            }
            scheduleDO.addRow(calendarRow);
        }
        Row taskInputRow = new Row("Task_Input");
        taskInputRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
        taskInputRow.set("TASK_ID", (Object)SchedulerUtil.getTaskID((String)EVENT_TASK_NAME));
        Long time = System.currentTimeMillis() + 120000L;
        if (request.getParameter("testNow") != null && request.getParameter("testNow").equals("false")) {
            time = ScheduleUtil.calculateNextScheduleTime((DataObject)scheduleDO, (Long)-1L, (boolean)false);
        }
        taskInputRow.set("SCHEDULE_TIME", (Object)new Timestamp(time));
        scheduleDO.addRow(taskInputRow);
        Row taskRow = new Row("Scheduled_Task");
        taskRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
        taskRow.set("AUDIT_FLAG", (Object)true);
        taskRow.set("TASK_ID", (Object)SchedulerUtil.getTaskID((String)EVENT_TASK_NAME));
        taskRow.set("TRANSACTION_TIME", (Object)-1);
        taskRow.set("SKIP_MISSED_SCHEDULE", (Object)true);
        scheduleDO.addRow(taskRow);
        Row schedulerRow = new Row("AUDScheduler");
        schedulerRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
        schedulerRow.set("CREATION_TIME", (Object)System.currentTimeMillis());
        schedulerRow.set("MODIFICATION_TIME", (Object)System.currentTimeMillis());
        schedulerRow.set("DOMAIN_NAME", (Object)((String)this.get("domainName")));
        schedulerRow.set("REPORT_PERIOD", (Object)reportPeriod);
        schedulerRow.set("FILE_FORMAT", (Object)((String)this.get("formatType")));
        schedulerRow.set("FILE_STORAGE_PATH", (Object)((String)this.get("fileStoragePath")));
        schedulerRow.set("IS_NOTIFICATION_ENABLED", (Object)((Boolean)this.get("isNotificationEnabled")));
        schedulerRow.set("TO_MAIL_ADDRESS", (Object)((String)this.get("toAddress")));
        schedulerRow.set("MAIL_SUBJECT", (Object)((String)this.get("mailSubject")));
        schedulerRow.set("MAIL_CONTENT", (Object)((String)this.get("mailContent")));
        schedulerRow.set("SENDING_OPTIONS", (Object)((String)this.get("sendingOptions")));
        schedulerRow.set("IS_ZIP_FILE", (Object)((Boolean)this.get("isZipFile")));
        schedulerRow.set("IS_REPORTS_EMPTY", (Object)((Boolean)this.get("isReportsEmpty") == false ? 1 : 0));
        schedulerRow.set("BUSINESS_HOUR", (Object)((String)this.get("BUSINESS_HOUR")));
        scheduleDO.addRow(schedulerRow);
        Row reportMapRow = new Row("AUDReportSchedulerMap");
        reportMapRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
        reportMapRow.set("AUDIT_REPORT_ID", (Object)reportId);
        scheduleDO.addRow(reportMapRow);
        return scheduleDO;
    }

    public void setProperties(Long scheduleId) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
        DataObject schedulerDO = CommonUtil.getPersistence((boolean[])new boolean[0]).getForPersonality("ScheduledReports", crit);
        Row scheduleRow = schedulerDO.getRow("Schedule");
        this.set("scheduleName", (String)scheduleRow.get("SCHEDULE_NAME"));
        this.set("description", (String)scheduleRow.get("DESCRIPTION"));
        Row audSchedulerRow = schedulerDO.getRow("AUDScheduler");
        this.set("fileStoragePath", (String)audSchedulerRow.get("FILE_STORAGE_PATH"));
        this.set("formatType", (String)audSchedulerRow.get("FILE_FORMAT"));
        this.set("isNotificationEnabled", (Boolean)audSchedulerRow.get("IS_NOTIFICATION_ENABLED"));
        this.set("toAddress", (String)audSchedulerRow.get("TO_MAIL_ADDRESS"));
        this.set("mailContent", (String)audSchedulerRow.get("MAIL_CONTENT"));
        this.set("mailSubject", (String)audSchedulerRow.get("MAIL_SUBJECT"));
        this.set("sendingOptions", (String)audSchedulerRow.get("SENDING_OPTIONS"));
        this.set("isZipFile", (Boolean)audSchedulerRow.get("IS_ZIP_FILE"));
        this.set("BUSINESS_HOUR", (String)audSchedulerRow.get("BUSINESS_HOUR"));
        this.set("isReportsEmpty", (Boolean)audSchedulerRow.get("IS_REPORTS_EMPTY") == false);
        String timePeriod = (String)audSchedulerRow.get("REPORT_PERIOD");
        if (schedulerDO.size("Periodic") > 0) {
            Row periodicRow = schedulerDO.getRow("Periodic");
            Date dateObj = (Date)periodicRow.get("START_DATE");
            reportLogger.log(Level.FINE, "start time is " + dateObj);
            this.set("selectedHour", dateObj.getHours());
            this.set("selectedMinute", dateObj.getMinutes());
            this.set("selectedHourlyPeriod", timePeriod);
            this.set("reportType", "hourly");
        } else {
            Row calendarRow = schedulerDO.getRow("Calendar");
            if (((String)calendarRow.get("REPEAT_FREQUENCY")).equalsIgnoreCase("daily")) {
                this.set("selectedHourOfDay", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() / 60);
                this.set("selectedMinuteOfDay", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() % 60);
                this.set("selectedDailyPeriod", timePeriod);
                this.set("reportType", "daily");
            } else if (((String)calendarRow.get("REPEAT_FREQUENCY")).equalsIgnoreCase("weekly")) {
                this.set("dayOfWeek", (Integer)calendarRow.get("DAY_OF_WEEK"));
                this.set("hourOfWeek", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() / 60);
                this.set("minuteOfWeek", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() % 60);
                this.set("selectedWeeklyPeriod", timePeriod);
                this.set("reportType", "weekly");
            } else if (((String)calendarRow.get("REPEAT_FREQUENCY")).equalsIgnoreCase("monthly")) {
                this.set("dateOfMonth", (Integer)calendarRow.get("DATE_OF_MONTH"));
                this.set("hourOfMonth", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() / 60);
                this.set("minuteOfMonth", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() % 60);
                this.set("selectedMonthlyPeriod", timePeriod);
                this.set("reportType", "monthly");
            }
        }
    }
}

