/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.reports.scheduler;

import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.auditing.server.reports.ReportSchedulerUtil;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.reports.scheduler.ReportSchedulerBean;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ModifyReportScheduler
extends Action {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forwardName = "createSchedule";
        String message = null;
        ReportSchedulerBean bean = (ReportSchedulerBean)form;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"ScheduledReports", (ADAPAuthObject)authObj);
        try {
            if (request.getParameter("action") == null) {
                String schedulerId = request.getParameter("scheduleId");
                bean.init(request);
                if (schedulerId != null) {
                    bean.set("scheduleId", Long.parseLong(schedulerId));
                    bean.setProperties((Long)bean.get("scheduleId"));
                } else {
                    forwardName = "viewScheduler";
                }
            } else if (request.getParameter("action").equalsIgnoreCase("update")) {
                if (request.getParameter("isNotificationEnabled") == null) {
                    bean.set("isNotificationEnabled", false);
                }
                reportLogger.log(Level.FINE, "isNotificationEnabled is " + bean.get("isNotificationEnabled"));
                if (request.getParameter("isZipFile") == null) {
                    bean.set("isZipFile", false);
                }
                if (request.getParameter("isReportsEmpty") == null) {
                    bean.set("isReportsEmpty", false);
                }
                if (accessType == 32) {
                    DataObject dataObject = bean.getProperties(request.getParameter("action"), request);
                    ReportSchedulerUtil.updateScheduler((DataObject)dataObject, (Long)((Long)bean.get("scheduleId")), (String)((String)bean.get("reportType")));
                    message = request.getParameter("testNow") != null && request.getParameter("testNow").equals("false") ? (String)rb.handleGetObject("adap.ModifyReportScheduler.Successfully_updated_the_scheduled_report") : rb.getString("adap.ModifyReportScheduler.update_test_now");
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", rb.handleGetObject("adap.ModifyReportScheduler.audit_entry.Successfully_updated", new String[]{(String)bean.get("scheduleName")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.modify_report_scheduler", "-"}));
                } else {
                    message = rb.getString("adap.access_denied.ModifyReportScheduler.modifyschReports");
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
                }
                forwardName = "viewScheduler";
            }
        }
        catch (DataAccessException ex) {
            message = ex.getMessage();
            ex.printStackTrace();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            String stktrc = sw.toString();
            if (message.indexOf("Duplicate entry") != -1 || stktrc.indexOf("duplicate key") != -1) {
                message = rb.getString("adap.CreateReportScheduler.The_Schedule_Name_Already_Configured");
            }
            try {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", message + "\n" + rb.handleGetObject("adap.audit_entry_addn.Schedule_Report_name", new String[]{(String)bean.get("scheduleName")}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.modify_report_scheduler", "-"}));
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
        catch (Exception ex) {
            message = (String)rb.handleGetObject("adap.ModifyReportScheduler.Error_Occurred_while_Updating_the");
            ex.printStackTrace();
            try {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", message + "\n" + rb.handleGetObject("adap.audit_entry_addn.Schedule_Report_name", new String[]{(String)bean.get("scheduleName")}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.modify_report_scheduler", "-"}));
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
        request.setAttribute("message", (Object)message);
        return mapping.findForward(forwardName);
    }
}

