/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.reports.scheduler;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.ReportSchedulerUtil;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.reports.AuditReportBean;
import com.adventnet.sym.adsm.auditing.webclient.reports.scheduler.ReportSchedulerBean;
import com.adventnet.sym.adsm.auditing.webclient.reports.scheduler.SchedulerBeanUtil;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.AlertSchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;

public class ReportScheduler
extends DispatchAction {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public ActionForward enableDisableReportScheduler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"ScheduledReports", (ADAPAuthObject)authObj);
        try {
            if (accessType == 32) {
                reportLogger.log(Level.INFO, request.getParameter("scheduleId") + "      " + request.getParameter("status"));
                String scheduleIdStr = request.getParameter("scheduleId");
                String status = rb.getString("adap.common.text.manage_link.disable");
                if (request.getParameter("status").equalsIgnoreCase("Enable")) {
                    status = rb.getString("adap.common.text.manage_link.enable");
                }
                Long scheduleId = Long.parseLong(scheduleIdStr);
                Row row = ReportUtil.getFirstRow((String)"Schedule", (String)"SCHEDULE_ID", (Object)scheduleId, (int)0);
                SchedulerUtil.enableDisableScheduler((Long)scheduleId, (String)request.getParameter("status"));
                request.setAttribute("message", (Object)rb.handleGetObject("adap.ReportScheduler.Successfully_requestgetParameterstatusd_the_scheduled_report", new String[]{status}));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", rb.handleGetObject("adap.ReportScheduler.Successfully_requestgetParameterstatusd_the_scheduled_report", new String[]{status}) + (String)row.get("SCHEDULE_NAME"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.modify_report_scheduler", "-"}));
            } else {
                String message = rb.getString("adap.access_denied.ReportScheduler.enabledsiableschedule");
                request.setAttribute("message", (Object)message);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.modify_report_scheduler", "-"}));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", rb.getString("adap.ReportScheduler.audit_entry.Problem_while_enabling_disabling_schedule_reports"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.modify_report_scheduler", "-"}));
        }
        return mapping.findForward("viewScheduler");
    }

    public ActionForward addReportInputs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward = "selectedReports";
        try {
            ReportSchedulerBean bean = (ReportSchedulerBean)form;
            HashMap reportInputs = (HashMap)bean.get("reportInputs");
            String id = request.getParameter("reportId");
            String guidName = request.getParameter("guidName");
            if (id != null) {
                Long reportId = Long.parseLong(id);
                String objectClass = request.getParameter("objectClass");
                HashMap<String, String> selectAllMap = new HashMap<String, String>();
                selectAllMap.put("objectClass", objectClass);
                selectAllMap.put("guidName", guidName);
                selectAllMap.put("selectedObjects", "allobjects");
                selectAllMap.put("selectedObjectNames", "allobjects");
                selectAllMap.put("allObjectSelected", "true");
                String allObjectSelected = request.getParameter("allObjectSelected");
                ArrayList<HashMap<String, String>> selectedObjectsList = (ArrayList<HashMap<String, String>>)reportInputs.get(reportId);
                if (selectedObjectsList == null || objectClass.equalsIgnoreCase("share")) {
                    selectedObjectsList = new ArrayList<HashMap<String, String>>();
                }
                if (objectClass != null) {
                    if (!allObjectSelected.equalsIgnoreCase("true")) {
                        if (selectedObjectsList.contains(selectAllMap)) {
                            selectedObjectsList.remove(selectAllMap);
                        }
                        HttpSession session = request.getSession();
                        DynaActionForm objectBean = (DynaActionForm)session.getAttribute("ViewObjectsBean");
                        HashMap selectedObjectsMap = (HashMap)objectBean.get("selectedObjectsMap");
                        ArrayList list = (ArrayList)selectedObjectsMap.get(objectClass);
                        for (int i = 0; i < list.size(); ++i) {
                            HashMap objectMap = (HashMap)list.get(i);
                            objectMap.put("objectClass", objectClass);
                            objectMap.put("guidName", guidName);
                            if (selectedObjectsList.contains(objectMap)) continue;
                            selectedObjectsList.add(objectMap);
                        }
                    } else {
                        selectedObjectsList = new ArrayList();
                        selectedObjectsList.add(selectAllMap);
                    }
                }
                reportInputs.put(reportId, selectedObjectsList);
                bean.set("reportInputs", reportInputs);
                SchedulerBeanUtil.getReportDetails((HashMap)bean.get("categoryMap"), reportId);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward(forward);
    }

    public ActionForward removeReportInputs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            ReportSchedulerBean bean = (ReportSchedulerBean)form;
            HashMap reportInputs = (HashMap)bean.get("reportInputs");
            String id = request.getParameter("reportId");
            Long reportId = Long.parseLong(id);
            String selectedObjects = request.getParameter("selectedObjects");
            ArrayList selectedObjectsList = (ArrayList)reportInputs.remove(reportId);
            if (selectedObjects != null) {
                StringTokenizer objectTokenizer = new StringTokenizer(selectedObjects, ";;;");
                while (objectTokenizer.hasMoreTokens()) {
                    String object = objectTokenizer.nextToken();
                    for (int i = 0; i < selectedObjectsList.size(); ++i) {
                        HashMap objectMap = (HashMap)selectedObjectsList.get(i);
                        if (!objectMap.containsValue(object)) continue;
                        HashMap selectedObjectsMap = (HashMap)selectedObjectsList.remove(i);
                    }
                }
                if (selectedObjectsList.size() > 0) {
                    reportInputs.put(reportId, selectedObjectsList);
                }
            }
            bean.set("reportInputs", reportInputs);
            HashMap categoryMap = (HashMap)bean.get("categoryMap");
            String cateIdStr = request.getParameter("categoryId");
            if (cateIdStr != null) {
                Long categoryId = Long.parseLong(cateIdStr);
                HashMap reportMap = (HashMap)categoryMap.get(categoryId);
                reportInputs = (HashMap)bean.get("reportInputs");
                selectedObjectsList = (ArrayList)reportInputs.get(reportId);
                if (selectedObjectsList == null || selectedObjectsList.size() == 0) {
                    HashMap detailsMap = (HashMap)reportMap.remove(reportId);
                    categoryMap.put(categoryId, reportMap);
                    if (reportMap.isEmpty()) {
                        HashMap map = (HashMap)categoryMap.remove(categoryId);
                    }
                    bean.set("categoryMap", categoryMap);
                }
            }
            ClientUtil.setStatusXMLElement(response, "Success", "");
        }
        catch (Exception ex) {
            ClientUtil.setStatusXMLElement(response, "Failure", "");
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward getListOfObjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward = "dispList";
        try {
            String[] strObjClass = request.getParameter("strType").split(";;;");
            ObjectClass[] objectClass = new ObjectClass[strObjClass.length];
            for (int i = 0; i < strObjClass.length; ++i) {
                objectClass[i] = DirectoryObjectAPI.getInstance().getObjectClass(strObjClass[i]);
                if (strObjClass[i].equalsIgnoreCase("share")) {
                    request.setAttribute("selectType", (Object)"radio");
                    continue;
                }
                request.setAttribute("selectType", (Object)"checkbox");
            }
            String domainName = request.getParameter("domainName");
            String defaultNamingContext = DomainDetailsAPI.getDefaultNamingContext((String)domainName);
            request.setAttribute("domainName", (Object)domainName);
            request.setAttribute("defaultNamingContext", (Object)defaultNamingContext);
            request.setAttribute("objectClass", (Object)objectClass);
            request.setAttribute("action", (Object)"scheduleReports");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward(forward);
    }

    public ActionForward addselectedReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward = "selectedReports";
        try {
            ReportSchedulerBean bean = (ReportSchedulerBean)form;
            HashMap reportInputs = (HashMap)bean.get("reportInputs");
            HttpSession session = request.getSession();
            AuditReportBean reportBean = (AuditReportBean)((Object)session.getAttribute("AuditReportBean"));
            Long reportId = (Long)reportBean.get("reportId");
            HashMap inputParams = (HashMap)reportBean.get("inputParams");
            String objectClass = (String)inputParams.get("objectClass");
            HashMap<String, String> selectAllMap = new HashMap<String, String>();
            selectAllMap.put("objectClass", objectClass);
            selectAllMap.put("guidName", "object_guid");
            selectAllMap.put("selectedObjects", "allobjects");
            selectAllMap.put("selectedObjectNames", "allobjects");
            selectAllMap.put("allObjectSelected", "true");
            ArrayList selectedObjectsList = (ArrayList)reportInputs.get(reportId);
            if (selectedObjectsList == null) {
                selectedObjectsList = new ArrayList();
            }
            if (objectClass != null) {
                String allObjectSelected = "false";
                if ((String)inputParams.get("allObjectSelected") != null) {
                    allObjectSelected = (String)inputParams.get("allObjectSelected");
                }
                if (!allObjectSelected.equalsIgnoreCase("true")) {
                    if (selectedObjectsList.contains(selectAllMap)) {
                        selectedObjectsList.remove(selectAllMap);
                    }
                    ArrayList objectGuid = (ArrayList)inputParams.get("object_guid");
                    String objectName = (String)inputParams.get("objectName");
                    String[] stken = objectName.split(",");
                    for (int i = 0; i < objectGuid.size(); ++i) {
                        HashMap<String, Object> objectMap = new HashMap<String, Object>();
                        objectMap.put("selectedObjects", objectGuid.get(i));
                        objectMap.put("selectedObjectNames", stken[i]);
                        objectMap.put("objectClass", objectClass);
                        objectMap.put("guidName", "object_guid");
                        selectedObjectsList.add(objectMap);
                    }
                } else {
                    selectedObjectsList = new ArrayList();
                    selectedObjectsList.add(selectAllMap);
                }
            }
            reportInputs.put(reportId, selectedObjectsList);
            bean.set("reportInputs", reportInputs);
            SchedulerBeanUtil.getReportDetails((HashMap)bean.get("categoryMap"), reportId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward(forward);
    }

    public ActionForward scheduleNow(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String schId = request.getParameter("scheduleId");
        Long scheduleId = Long.parseLong(schId);
        Row firstRow = ReportUtil.getFirstRow((String)"Schedule", (String)"SCHEDULE_ID", (Object)scheduleId, (int)0);
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            reportLogger.log(Level.INFO, "To run the Schedule Report - Schedule Id is " + scheduleId);
            Criteria crit = new Criteria(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("Task_Input", crit);
            if (!dObj.isEmpty()) {
                Long currentTime = System.currentTimeMillis();
                currentTime = currentTime + 120L;
                Row row = dObj.getFirstRow("Task_Input");
                row.set("SCHEDULE_TIME", (Object)new Timestamp(currentTime));
                dObj.updateRow(row);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(dObj);
            } else {
                reportLogger.log(Level.INFO, "Need to handle if DataObject is empty");
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", rb.handleGetObject("adap.ReportScheduler.audit_entry.Scheduler_starts_now_for_scheduler", new String[]{(String)firstRow.get("SCHEDULE_NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.manually_scheduled_Reports", "-"}));
            ClientUtil.setStatusXMLElement(response, "Success", "Scheduler starts Now.. Please wait some more time to know the status");
        }
        catch (Exception ex) {
            ClientUtil.setStatusXMLElement(response, "Failure", "");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", rb.handleGetObject("adap.ReportScheduler.audit_entry.Problem_starting_scheduler", new String[]{(String)firstRow.get("SCHEDULE_NAME")}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.manually_scheduled_Reports", "-"}));
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward saveDeleteScheduledReports(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"ScheduledReports", (ADAPAuthObject)authObj);
        Boolean status = false;
        String reportLife = request.getParameter("reportLife");
        try {
            if (accessType == 32) {
                Criteria c1 = new Criteria(new Column("SystemParams", "PARAM_NAME"), (Object)"cleanReports", 0);
                DataObject d1 = CommonUtil.getPersistence((boolean[])new boolean[0]).get("SystemParams", c1);
                if (d1.isEmpty()) {
                    DataObject schDo = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                    Row schRow = new Row("SystemParams");
                    schRow.set("PARAM_NAME", (Object)"cleanReports");
                    schRow.set("PARAM_VALUE", (Object)reportLife);
                    schDo.addRow(schRow);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).add(schDo);
                    status = true;
                    reportLogger.log(Level.INFO, "Delete Reports Schedule set");
                } else {
                    UpdateQueryImpl u = new UpdateQueryImpl("SystemParams");
                    Criteria c = new Criteria(new Column("SystemParams", "PARAM_NAME"), (Object)"cleanReports", 0);
                    u.setCriteria(c);
                    u.setUpdateColumn("PARAM_NAME", (Object)"cleanReports");
                    u.setUpdateColumn("PARAM_VALUE", (Object)reportLife);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update((UpdateQuery)u);
                    status = true;
                    reportLogger.log(Level.INFO, "Delete Reports Schedule set");
                }
                String message = rb.handleGetObject("adap.ReportScheduler.audit_entry.Delete_scheduled_Reports_config_successfully", new String[]{reportLife});
                if (reportLife.equals("-1")) {
                    message = rb.getString("adap.ReportScheduler.audit_entry.Delete_scheduled_reports_config_removed");
                }
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Reports", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.delete_scheduled_reports_audit_entries", "-"}));
            } else {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Reports", rb.getString("adap.access_denied.ReportScheduler.saveDeleteReports"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            status = false;
            reportLogger.log(Level.INFO, "Delete Reports Schedule - Unable to set");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Reports", rb.handleGetObject("adap.ReportScheduler.audit_entry.Unable_to_set_delete_schedule_Report_config", new String[]{reportLife}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.delete_scheduled_reports_audit_entries", "-"}));
        }
        HashMap schMap = AlertSchedulerUtil.viewAlertScheduler();
        request.setAttribute("schMap", (Object)schMap);
        if (status.booleanValue()) {
            request.setAttribute("message", (Object)rb.getString("adap.admin.DeleteReports.SaveSuccess"));
        } else {
            request.setAttribute("message", (Object)rb.getString("adap.admin.DeleteReports.SaveFail"));
        }
        return mapping.findForward("success");
    }

    public ActionForward runnowDeleteScheduledReports(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"ScheduledReports", (ADAPAuthObject)authObj);
        String status = ReportSchedulerUtil.delReports((String)"Manual");
        reportLogger.log(Level.INFO, "Deleting Reports " + status);
        PrintWriter out = response.getWriter();
        if (accessType == 32) {
            if (status.equals("true")) {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", rb.getString("adap.ReportScheduler.audit_entry.Success_run_for_delete_schedule_reports"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.delete_scheduled_reports_audit_entries", "-"}));
                out.print(rb.getString("adap.admin.DeleteReports.Success"));
            } else if (status.equals("notScheduled")) {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", rb.getString("adap.ReportScheduler.audit_entry.configure_first_b4_delete_schedule_report"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.delete_scheduled_reports_audit_entries", "-"}));
                out.print(rb.getString("adap.admin.DeleteReports.Schedule_First"));
            } else {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", rb.getString("adap.ReportScheduler.audit_entry.failed_to_run_delete_schedule_Reprots"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.delete_scheduled_reports_audit_entries", "-"}));
                out.print(rb.getString("adap.admin.DeleteReports.Fail"));
            }
        } else {
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", rb.getString("adap.access_denied.ReportScheduler.audit_entry.runnowdelscheduler"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            out.print(rb.getString("adap.admin.DeleteReports.Fail"));
        }
        out.flush();
        return null;
    }

    public ActionForward getDataDeleteScheduledReports(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op = "-1";
        Criteria c1 = new Criteria(new Column("SystemParams", "PARAM_NAME"), (Object)"cleanReports", 0);
        DataObject d1 = CommonUtil.getPersistence((boolean[])new boolean[0]).get("SystemParams", c1);
        if (!d1.isEmpty()) {
            Row r1 = d1.getFirstRow("SystemParams");
            op = (String)r1.get("PARAM_VALUE");
        }
        PrintWriter out = response.getWriter();
        out.print(op);
        out.flush();
        return null;
    }
}

