/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient;

import com.adventnet.sym.adsm.auditing.server.delegation.AuditDelegationHandler;
import com.adventnet.sym.adsm.auditing.server.delegation.GpoHandler;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class DomainPolicy
extends DispatchAction {
    private static Logger logger = Logger.getLogger("DelegLogger");
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public ActionForward setAuditPolicy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"DomainSettings", (ADAPAuthObject)authObj);
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String domainName = request.getParameter("DomainName");
        String message = "";
        String gpoStatus = "";
        request.setAttribute("IsPolicy", (Object)true);
        try {
            String gpoGUIDString = request.getParameter("gpoGuids");
            logger.log(Level.INFO, "gpoGuids is" + gpoGUIDString);
            if (accessType == 32) {
                PolicyHandler phandler = new PolicyHandler();
                StringTokenizer guidTokenizer = new StringTokenizer(gpoGUIDString, ",");
                while (guidTokenizer.hasMoreTokens()) {
                    String gpoGuid = guidTokenizer.nextToken();
                    if (gpoGuid.equalsIgnoreCase("{6AC1786C-016F-11D2-945F-00C04fB984F9}")) {
                        phandler.writeAuditPolicy(domainName, gpoGuid);
                        PolicyHandler.addAuditPolicy((String)domainName, (String)gpoGuid);
                        message = rb.getString("adap.DomainPolicy.Successfully_configured_audit_policies");
                        request.setAttribute("Status_image", (Object)"images/info_icon1.gif");
                        continue;
                    }
                    if (!gpoGuid.equalsIgnoreCase("{31B2F340-016D-11D2-945F-00C04FB984F9}")) continue;
                    message = gpoStatus = GpoHandler.reConfigureGpo((String)domainName, (Integer)4);
                    request.setAttribute("Status_image", (Object)"images/info_icon1.gif");
                }
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", message + "\n " + rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.audit_pol_set", "-"}));
            } else {
                message = rb.getString("adap.access_denied.DomainPolicy.setPolicy");
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            }
        }
        catch (Exception e) {
            message = e.getMessage();
            request.setAttribute("DomainPolicyError", (Object)message);
            request.setAttribute("Status_image", (Object)"images/error_icon.gif");
            e.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", message + "\n " + rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.audit_pol_set", "-"}));
            return mapping.findForward("DomainPolicyWriteError");
        }
        request.setAttribute("DomainPolicyError", (Object)message);
        return mapping.findForward("DomainPolicyWriteError");
    }

    public ActionForward setSystemACL(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"DomainSettings", (ADAPAuthObject)authObj);
        String message = "";
        String gpoStatus = "";
        request.setAttribute("IsPolicy", (Object)false);
        String domainName = request.getParameter("DomainName");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            if (accessType == 32) {
                AuditDelegationHandler delegationHandler = new AuditDelegationHandler(domainName);
                delegationHandler.setSystemACLForDS();
                message = rb.getString("adap.DomainPolicy.Successfully_configured_systemACL");
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", message + "\n " + rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.set_SACL", "-"}));
                request.setAttribute("Status_image", (Object)"images/info_icon1.gif");
            } else {
                message = rb.getString("adap.access_denied.DomainPolicy.setSACL");
                request.setAttribute("Status_image", (Object)"images/error_icon.gif");
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            }
        }
        catch (Exception e) {
            message = e.getMessage();
            if (message.toLowerCase().contains("error while setting object level ad auditing:access is denied - error code:0")) {
                message = rb.getString("adap.domainpolicy.Error_While_Setting_Object_Level_Ad_Access_Denied");
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", message + "\n " + rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.set_SACL", "-"}));
            request.setAttribute("DomainPolicyError", (Object)message);
            request.setAttribute("Status_image", (Object)"images/error_icon.gif");
            e.printStackTrace();
            return mapping.findForward("DomainPolicyWriteError");
        }
        request.setAttribute("DomainPolicyError", (Object)message);
        return mapping.findForward("DomainPolicyWriteError");
    }

    public ActionForward setWSAuditPolicy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"DomainSettings", (ADAPAuthObject)authObj);
        String message = "";
        request.setAttribute("IsPolicy", (Object)true);
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String domainName = request.getParameter("DomainName");
        try {
            if (accessType == 32) {
                String gpoGUIDString = request.getParameter("gpoGuids");
                logger.log(Level.INFO, "gpoGuids is" + gpoGUIDString);
                message = GpoHandler.reConfigureGpo((String)domainName, (Integer)4096);
                request.setAttribute("Status_image", (Object)"images/info_icon1.gif");
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", message + "\n " + rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.set_ws_SACL", "-"}));
            } else {
                message = rb.getString("adap.access_denied.DomainPolicy.setWSPolicy");
                request.setAttribute("Status_image", (Object)"images/error_icon.gif");
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            }
        }
        catch (Exception e) {
            message = e.getMessage();
            request.setAttribute("DomainPolicyError", (Object)message);
            request.setAttribute("Status_image", (Object)"images/error_icon.gif");
            e.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", message + "\n " + rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.set_ws_SACL", "-"}));
            return mapping.findForward("DomainPolicyWriteError");
        }
        request.setAttribute("DomainPolicyError", (Object)message);
        return mapping.findForward("DomainPolicyWriteError");
    }
}

