/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient;

import com.adventnet.sym.adsm.common.server.admin.WrapperUtil;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.webclient.graphs.schedule.GraphGenerationThread;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class HomeAction
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forward = "homePage";
        try {
            HashMap firstTabDetails;
            String url;
            HttpSession session = request.getSession();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
            ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
            ArrayList configuredDomainsList = authObject.getDomainsList();
            if (configuredDomainsList.size() > 0) {
                session.setAttribute("MONITOR_DOMAIN_NAME", configuredDomainsList.get(0));
            }
            if ((Long)session.getAttribute("ADAP_SESSION_LOGIN_ID") == null) {
                session.setAttribute("ADAP_SESSION_LOGIN_ID", (Object)1L);
            }
            if ((HashMap)session.getAttribute("AAA_DETAILS") == null) {
                session.setAttribute("AAA_DETAILS", (Object)authObject.getAaaDetails());
            }
            Long categoryId = DBObjectUtil.getUVHValues((String)"AUDCategories", (String)"AUDCategories:category_id:1");
            session.setAttribute("DEFAULT_CATEGORY_ID", (Object)categoryId);
            Long fileCategoryId = DBObjectUtil.getUVHValues((String)"AUDCategories", (String)"AUDCategories:category_id:20");
            session.setAttribute("DEFAULT_FILE_CATEGORY_ID", (Object)fileCategoryId);
            Long serverCategoryId = DBObjectUtil.getUVHValues((String)"AUDCategories", (String)"AUDCategories:category_id:34");
            session.setAttribute("DEFAULT_SERVER_CATEGORY_ID", (Object)serverCategoryId);
            session.setAttribute("AUDIT_REPORT_ID", (Object)authObject.getDefaultReport());
            if (request.getParameter("updateGraphs") != null) {
                String graphOptId = request.getParameter("graphOptId");
                String domainName = request.getParameter("domainName");
                session.setAttribute("MONITOR_DOMAIN_NAME", (Object)domainName);
                Long optId = Long.parseLong(graphOptId);
                ArrayList<Long> graphOptList = new ArrayList<Long>();
                graphOptList.add(optId);
                new GraphGenerationThread(domainName, graphOptList).generate();
                ClientUtil.setStatusXMLElement(response, "Success", rb.getString("adap.DomainAction.Refresh_request_is_being_processed"));
                return null;
            }
            String selectedDomain = request.getParameter("domainName");
            if (selectedDomain != null) {
                session.setAttribute("MONITOR_DOMAIN_NAME", (Object)selectedDomain);
            }
            if (request.getParameter("tabId") != null) {
                request.setAttribute("tabId", (Object)Long.parseLong(request.getParameter("tabId")));
            }
            if ((url = (String)(firstTabDetails = authObject.getFirstTabDetails()).get("TAB_URL")).contains("selectedTab=report")) {
                forward = "report";
            } else if (url.contains("selectedTab=fileAudit")) {
                forward = "fileAudit";
            } else {
                if (url.contains("selectedTab=serverAudit")) {
                    return new ActionForward("/" + url);
                }
                if (url.contains("selectedTab=alert")) {
                    forward = "alerts";
                } else if (url.contains("selectedTab=support")) {
                    forward = "support";
                } else {
                    if (url.contains("selectedTab=config")) {
                        return new ActionForward("/" + authObject.getConfigTabFirstForward());
                    }
                    if (url.contains("selectedTab=admin")) {
                        return new ActionForward("/" + authObject.getAdminTabFirstForward());
                    }
                    if (url.contains("ComplianceHome.do?selectedTab=home")) {
                        return new ActionForward("/" + url);
                    }
                }
            }
            if (request.getParameter("HomeServiceAlert") != null) {
                WrapperUtil.installAsService();
                forward = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forward);
    }
}

