/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin;

import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;

public class AddOnIntegration
extends Action {
    private static Logger logger = Logger.getLogger(AddOnIntegration.class.getName());
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Properties p;
            HttpSession session = request.getSession();
            ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
            Integer accessType = AdminHandler.getAccessType((String)"productIntegration", (ADAPAuthObject)authObj);
            DynaActionForm addOns = (DynaActionForm)form;
            String message = "";
            String[] protocols = new String[]{"http", "https"};
            addOns.set("protocols", (Object)protocols);
            String pdtName = (String)addOns.get("productName");
            String operation = request.getParameter("operation");
            if (request.getParameter("add") != null) {
                if (accessType == 32) {
                    message = AddOnIntegration.deleteProduct(pdtName);
                    message = AddOnIntegration.save(addOns, request);
                } else {
                    message = rb.getString("adap.access_denied.AddOnIntegration.save");
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
                }
            }
            if ((p = AdminHandler.getAddOnRow((String)pdtName)) != null) {
                Enumeration<Object> e = p.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    try {
                        addOns.set(key, p.get(key));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            request.setAttribute("errMsg", (Object)message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("mainPage");
    }

    public static String deleteProduct(String productName) {
        String message = AdminHandler.deleteAddOnRow((String)productName);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String save(DynaActionForm addOns, HttpServletRequest request) {
        HttpURLConnection connection = null;
        BufferedInputStream is = null;
        ByteArrayOutputStream bos = null;
        String message = "";
        String pdtName = (String)addOns.get("productName");
        String hostName = (String)addOns.get("HOST");
        Integer portNo = (Integer)addOns.get("PORT");
        Properties p = new Properties();
        p.put("PRODUCT_NAME", pdtName);
        p.put("HOST", hostName);
        p.put("PORT", portNo);
        p.put("USERNAME", ClientUtil.scriptEscape((String)addOns.get("USERNAME")));
        p.put("PASSWORD", addOns.get("PASSWORD"));
        p.put("PROTOCOL", (String)addOns.get("PROTOCOL"));
        logger.log(Level.FINE, "Properties : " + p);
        try {
            if (AdminHandler.addProductDetails((String)"ADManagerPlus", (Properties)p)) {
                message = (String)rb.handleGetObject("adap.AddOnIntegration.Successfully_connected_and_updated");
                String serverhost = request.getServerName();
                if (serverhost.equals("localhost")) {
                    serverhost = InetAddress.getLocalHost().getHostName();
                }
                int serverport = request.getServerPort();
                String serverProtocol = request.getRequestURL().toString();
                serverProtocol = serverProtocol.substring(0, serverProtocol.indexOf(":")).toLowerCase();
                if (pdtName.equalsIgnoreCase("ADManagerPlus")) {
                    String invokingServlet = "http://" + hostName + ":" + portNo + "/servlet/ProductConfig?host=" + serverhost + "&port=" + serverport + "&protocol=" + serverProtocol + "&product=ManageEngine ADAudit Plus";
                    logger.log(Level.FINE, "invoking servlet is " + invokingServlet);
                    connection = AddOnIntegration.openConnection(invokingServlet);
                    connection.setRequestMethod("GET");
                    is = new BufferedInputStream(connection.getInputStream());
                    bos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[4096];
                    int length = -1;
                    if (is.available() > 0) {
                        String resultString;
                        while ((length = is.read(buffer, 0, buffer.length)) != -1) {
                            bos.write(buffer, 0, length);
                        }
                        byte[] result = bos.toByteArray();
                        if (result.length > 0 && (resultString = new String(result)).contains("Successfully Configured")) {
                            message = rb.getString("adap.domain_settings.policy_status.statusmsg.successfully_configured");
                        }
                    }
                }
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.AddOnIntegration.configured_jump_to_admp", new String[]{serverhost, String.valueOf(serverport)}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Uumpto_Configured", "-"}));
            } else {
                message = (String)rb.handleGetObject("adap.AddOnIntegration.Unable_to_connect_to_the");
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", "Problem while Configured Jump To settings , \n Server Name : " + hostName + " , \nPort :" + portNo, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.Uumpto_Configured", "-"}));
            }
        }
        catch (Exception e) {
            try {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.AddOnIntegration.unable_configured_jump_to_admp", new String[]{hostName, Integer.toString(portNo)}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.Uumpto_Configured", "-"}));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            e.printStackTrace();
            String status = AdminHandler.deleteAddOnRow((String)pdtName);
            message = (String)rb.handleGetObject("adap.AddOnIntegration.Unable_to_connect_to_the");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (connection != null) {
                    connection.disconnect();
                    connection = null;
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return message;
    }

    public static HttpURLConnection openConnection(String urlStr) throws Exception {
        URL urlObj = new URL(urlStr);
        HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
        connection.setDoInput(true);
        connection.setDoOutput(true);
        return connection;
    }
}

