/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.PasswordException;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.persistence.Row;
import com.adventnet.start.StartupUtil;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.ADSMPersUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import com.adventnet.sym.adsm.start.util.SDInstallUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;

public class ChangePasswordAction
extends DispatchAction {
    private static Logger logger = Logger.getLogger(ChangePasswordAction.class.getName());
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public ActionForward showPersonalisePage(ActionMapping actionmapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String option = request.getParameter("selectedTile");
        String tile = "";
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID");
        try {
            DynaActionForm personaliseForm = (DynaActionForm)actionform;
            String loginName = request.getUserPrincipal().getName();
            String serviceName = ADSMPersUtil.getServiceName((String)loginName);
            Credential cred = AuthUtil.getUserCredential();
            Long loggedOnUserId = cred.getUserId();
            Long accountId = cred.getAccountId();
            logger.log(Level.FINE, "The account Id : " + accountId + " for the login NAme " + loginName + " & Service name : " + serviceName);
            if (option.equalsIgnoreCase("PersonaliseSettings")) {
                tile = "PersonaliseSettings";
                personaliseForm.set("THEME", (Object)ADSMPersUtil.getSyMParameter((String)"THEME"));
                personaliseForm.set("DATE_FORMAT", (Object)ADSMPersUtil.getSyMParameter((String)"DATE_FORMAT"));
                personaliseForm.set("TIME_FORMAT", (Object)ADSMPersUtil.getSyMParameter((String)"TIME_FORMAT"));
                Properties prop = ADSMPersUtil.getLocaleSettings();
                ArrayList labelList = (ArrayList)prop.get("labelList");
                ArrayList<String> localeDisplayName = new ArrayList<String>();
                for (int z = 0; z < labelList.size(); ++z) {
                    String localeName = rb.getString((String)labelList.get(z));
                    localeDisplayName.add(localeName);
                }
                personaliseForm.set("localeName", localeDisplayName);
                personaliseForm.set("localeIds", prop.get("valueList"));
                ResourceBundleMgr.getInstance();
                Long localeId = ResourceBundleMgr.getUserLocaleId((Long)loginId);
                if (localeId == -1L) {
                    localeId = 0L;
                }
                personaliseForm.set("localeId", (Object)localeId);
                ArrayList<String> timeZoneDisplayName = new ArrayList<String>();
                ArrayList<String> timeZoneIds = new ArrayList<String>();
                String[] allTimeZones = TimeZone.getAvailableIDs();
                for (int z = 0; z < allTimeZones.length; ++z) {
                    timeZoneIds.add(allTimeZones[z]);
                    TimeZone tt = TimeZone.getTimeZone(allTimeZones[z]);
                    int offset = tt.getOffset(new Date().getTime()) / 1000 / 60;
                    String displayName = "( UTC " + offset / 60 + ":" + Math.abs(offset % 60) + ") " + tt.getDisplayName() + " (" + tt.getID() + ") ";
                    timeZoneDisplayName.add(displayName);
                }
                personaliseForm.set("timeZoneName", timeZoneDisplayName);
                personaliseForm.set("timeZoneIds", timeZoneIds);
                String timeZoneId = " ";
                if (ADSMPersUtil.getSyMParameter((String)"TIMEZONE_ID").equals("-")) {
                    timeZoneId = TimeZone.getDefault().getID();
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ChangePasswordAction.audit_entry.timezone_successfully_updated", new String[]{timeZoneId}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.time_zone_updated", "-"}));
                    ADSMPersUtil.updateSyMParameter((String)"TIMEZONE_ID", (String)TimeZone.getDefault().getID());
                } else {
                    timeZoneId = ADSMPersUtil.getSyMParameter((String)"TIMEZONE_ID");
                }
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Admin", rb.getString("adap.ChangePasswordAction.audit_entry.personalize_settings_Viewd"), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.personalize_page_viewed", "-"}));
                personaliseForm.set("timeZoneId", (Object)timeZoneId);
            } else if (option.equalsIgnoreCase("ConnectionSettings")) {
                tile = "ConnectionSettings";
                personaliseForm.set("PORT_NUMBER", (Object)SDInstallUtil.getWebServerPort());
                Row row = ADSMPersUtil.getUserAccountSettings((Long)accountId);
                if (row != null) {
                    Integer timeout = (Integer)row.get("SESSION_EXPIRY_TIME");
                    int time = timeout / 60;
                    if (time > 0) {
                        personaliseForm.set("SESSION_EXPIRY_TIME", (Object)time);
                    } else {
                        personaliseForm.set("SESSION_EXPIRY_TIME", (Object)-1);
                    }
                } else if (row == null) {
                    personaliseForm.set("SESSION_EXPIRY_TIME", (Object)-1);
                }
                String[] times = new String[]{rb.getString("adap.LicenseUpgradeAction.Never"), "10", "15", "20", "25", "30", "45", "60"};
                personaliseForm.set("times", (Object)times);
                boolean enableSSL = ADSMPersUtil.checkSSL();
                personaliseForm.set("enableSSL", (Object)enableSSL);
                Integer sslPort = SDInstallUtil.getSSLPort();
                if (sslPort != -1) {
                    personaliseForm.set("SSLPortNo", (Object)sslPort);
                } else if (sslPort == -1) {
                    sslPort = SDInstallUtil.getSSLPortForWebServerPort((int)SDInstallUtil.getWebServerPort());
                    personaliseForm.set("SSLPortNo", (Object)sslPort);
                }
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Admin", rb.getString("adap.ChangePasswordAction.audit_entry.connection_settings_Viewed"), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.connection_settings_Viewd", "-"}));
            } else if (option.equalsIgnoreCase("ServerSettings")) {
                tile = "ServerSettings";
                personaliseForm.set("LAUNCH_DEFAULT_BROWSER", (Object)this.getDefaultClientSettings());
                personaliseForm.set("START_SERVER_ON_BOOTUP", (Object)this.isStartServerOnBootup());
                String usageStatistics = ADSMPersUtil.getSyMParameter((String)"USAGE_STATISTICS");
                if (usageStatistics == null) {
                    usageStatistics = "ENABLE";
                }
                personaliseForm.set("USAGE_STATISTICS", (Object)usageStatistics);
                personaliseForm.set("LOG_LEVEL", (Object)ADSMPersUtil.getCurrentLogLevel());
                ArrayList langlabel = new ArrayList();
                ArrayList langValue = new ArrayList();
                Properties prop = ADSMPersUtil.getLanguageList();
                personaliseForm.set("Countries", prop.get("label"));
                personaliseForm.set("ExportReport", (Object)(ADSMPersUtil.graphValue ? "Graph" : "NoGraph"));
                personaliseForm.set("Countries_value", prop.get("value"));
                Properties language = ADSMPersUtil.getLanguageSettings();
                personaliseForm.set("COUNTRY", language.get("language"));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Admin", rb.getString("adap.ChangePasswordAction.audit_entry.server_settings_viewed"), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.server_settings_viewed", "-"}));
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while loading personalise page", e);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Admin", rb.getString("adap.ChangePasswordAction.audit_entry.Exception_loading_personalize_page"), 4, 16, "adap.ADAPUserAuditSeverities.audit_name.personalize_page_viewed", "-"}));
            throw new Exception("Exception while loading personalise page");
        }
        logger.log(Level.FINE, "Forwarding to Personalise");
        return actionmapping.findForward(tile);
    }

    public ActionForward personalise(ActionMapping actionmapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String tile;
        block65: {
            String option = request.getParameter("selectedTile");
            HttpSession session = request.getSession();
            StringBuffer buf = new StringBuffer();
            tile = "";
            ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
            try {
                Integer accessType;
                ServletContext context = session.getServletContext();
                DynaActionForm personaliseForm = (DynaActionForm)actionform;
                boolean update = false;
                Row userSettingsRow = null;
                String loginName = request.getUserPrincipal().getName();
                String serviceName = ADSMPersUtil.getServiceName((String)loginName);
                Credential cred = AuthUtil.getUserCredential();
                Long loggedOnUserId = cred.getUserId();
                Long accountId = cred.getAccountId();
                System.out.println("account id in personalise " + accountId);
                userSettingsRow = ADSMPersUtil.getUserAccountSettings((Long)accountId);
                if (userSettingsRow == null) {
                    userSettingsRow = new Row("UserSettings");
                    userSettingsRow.set("USER_ACCOUNT_ID", (Object)accountId);
                }
                if (option.equalsIgnoreCase("PersonaliseSettings")) {
                    accessType = AdminHandler.getAccessType((String)"PersonaliseSettings", (ADAPAuthObject)authObj);
                    tile = "PersonaliseSettings";
                    if (accessType == 32) {
                        String dbDateFormat;
                        String dateFormat;
                        String themeDb;
                        String theme;
                        String oldpass = (String)personaliseForm.get("OLD_PASSWORD");
                        String newpass = (String)personaliseForm.get("NEW_PASSWORD");
                        if (oldpass != null && !oldpass.equals("") && newpass != null && !newpass.equals("")) {
                            try {
                                this.changePassword(loginName, oldpass, newpass, request);
                                request.setAttribute("changepassmessage", (Object)rb.getString("adap.TechnicianConfiguration.Successfully_updated_the_password"));
                                String isPasswordChanged = ADSMPersUtil.getSyMParameter((String)"IS_PASSWORD_CHANGED");
                                logger.log(Level.FINE, "is pass changed" + isPasswordChanged);
                                if (isPasswordChanged.equals("false")) {
                                    ADSMPersUtil.updateSyMParameter((String)"IS_PASSWORD_CHANGED", (String)"true");
                                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.TechnicianConfiguration.Successfully_updated_the_password"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.pwd_updated", "-"}));
                                }
                            }
                            catch (Exception ex) {
                                String message = ex.getMessage();
                                if (message.contains("Old password specified does not match")) {
                                    message = rb.getString("adap.admin.ChangePasswordAction.Old_password_specified_does_not_match");
                                } else if (message.contains("Length of the new password is smaller than expected value")) {
                                    message = rb.getString("adap.admin.ChangePasswordAction.Length_of_the_new_password_is_smaller_than_expected_value");
                                }
                                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.pwd_updated", "-"}));
                                request.setAttribute("changepassmessage", (Object)message);
                                logger.log(Level.WARNING, "Exception while changing the password", ex);
                            }
                        }
                        if (!(theme = (String)personaliseForm.get("THEME")).equals(themeDb = ADSMPersUtil.getSyMParameter((String)"THEME"))) {
                            ADSMPersUtil.updateSyMParameter((String)"THEME", (String)theme);
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ChangePasswordAction.audit_entry.theme_update", new String[]{theme}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.theme_updated", "-"}));
                            request.setAttribute("themeMessage", (Object)("Successfully updated your " + theme + " theme."));
                        }
                        context.setAttribute("selectedTheme", (Object)theme);
                        personaliseForm.set("THEME", (Object)theme);
                        ArrayList domainList = DomainHandler.getConfiguredList((Long)new Long(1L));
                        Boolean[] dboptions = new Boolean[domainList.size()];
                        Boolean[] options = new Boolean[domainList.size()];
                        String[] resString = new String[domainList.size()];
                        if (options != null && domainList != null && domainList.size() > 0) {
                            for (int i = 0; i < domainList.size(); ++i) {
                                resString[i] = request.getParameter("logonto" + i);
                                options[i] = resString[i] != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
                                Properties prop = (Properties)domainList.get(i);
                                String domainName = prop.getProperty("DOMAIN_FLAT_NAME");
                                String dom = prop.getProperty("DOMAIN_NAME");
                                dboptions[i] = DomainHandler.getDomainOption((String)dom);
                                if (options[i] == dboptions[i]) continue;
                                DomainHandler.setDomainOption((String)dom, (boolean)options[i]);
                            }
                        }
                        if (!(dateFormat = (String)personaliseForm.get("DATE_FORMAT")).equals(dbDateFormat = ADSMPersUtil.getSyMParameter((String)"DATE_FORMAT"))) {
                            ADSMPersUtil.updateSyMParameter((String)"DATE_FORMAT", (String)dateFormat);
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ChangePasswordAction.audit_entry.date_format_updated", new String[]{dateFormat}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.date_format_updated", "-"}));
                            TimeUtil.setDate((String)dateFormat);
                        }
                        personaliseForm.set("DATE_FORMAT", (Object)dateFormat);
                        String timeFormat = (String)personaliseForm.get("TIME_FORMAT");
                        String dbTimeFormat = ADSMPersUtil.getSyMParameter((String)"TIME_FORMAT");
                        if (!timeFormat.equals(dbTimeFormat)) {
                            ADSMPersUtil.updateSyMParameter((String)"TIME_FORMAT", (String)timeFormat);
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ChangePasswordAction.audit_entry.time_format_updated", new String[]{timeFormat}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.time_format_updatd", "-"}));
                            TimeUtil.setTime((String)timeFormat);
                        }
                        personaliseForm.set("TIME_FORMAT", (Object)timeFormat);
                        String timeZoneId = (String)personaliseForm.get("timeZoneId");
                        if (!ADSMPersUtil.getSyMParameter((String)"TIMEZONE_ID").equals(timeZoneId)) {
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ChangePasswordAction.audit_entry.timezone_successfully_updated", new String[]{timeZoneId}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.time_zone_updated", "-"}));
                            ADSMPersUtil.updateSyMParameter((String)"TIMEZONE_ID", (String)timeZoneId);
                        }
                        Long localeId = (Long)personaliseForm.get("localeId");
                        Long loginId = (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID");
                        if (localeId != null) {
                            try {
                                ResourceBundleMgr.getInstance().setUserLocale(loginId, localeId, request);
                                rb = ResourceBundleMgr.getInstance().getBundle(request);
                                if (localeId == 0L) {
                                    Locale locale = request.getLocale();
                                    ResourceBundleMgr.getInstance().updateLocaleDetails(localeId, locale.getLanguage(), locale.getCountry());
                                }
                                Row row = ReportUtil.getFirstRow((String)"LocaleDetails", (String)"LOCALE_ID", (Object)localeId, (int)0);
                                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ChangePasswordAction.audit_entry.locale_updated", new String[]{rb.getString((String)row.get("LOCALE_DISPLAY"))}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.locale_updated", "-"}));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    } else {
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.access_denied.ChangePasswordAction.personalize"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
                    }
                }
                if (option.equalsIgnoreCase("ConnectionSettings")) {
                    accessType = AdminHandler.getAccessType((String)"ConnectionSettings", (ADAPAuthObject)authObj);
                    tile = "ConnectionSettings";
                    if (accessType == 32) {
                        int time;
                        try {
                            int currentPort = SDInstallUtil.getWebServerPort();
                            int newPort = (Integer)personaliseForm.get("PORT_NUMBER");
                            logger.log(Level.FINE, "New port value: " + newPort + "  currPort: " + currentPort);
                            String message = "Successfully updated the Port";
                            if (currentPort != newPort) {
                                int result = SDInstallUtil.changeWebServerPort((int)newPort);
                                if (result == 0) {
                                    request.setAttribute("portsettingsmessage", (Object)"0");
                                } else if (result == 1) {
                                    request.setAttribute("portsettingsmessage", (Object)rb.getString("adap.Admin.Change_port_values.Port_number_already_in_use_Please_try_some_other_port_number"));
                                    message = (String)request.getAttribute("portsettingsmessage");
                                } else if (result == 3) {
                                    request.setAttribute("portsettingsmessage", (Object)rb.getString("adap.Admin.Change_port_values.Port_number_out_of_range_Please_provide_a_valid_port_number"));
                                    message = (String)request.getAttribute("portsettingsmessage");
                                }
                                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", message + "\n" + rb.handleGetObject("adap.ChangePasswordAction.audit_entry.oldAndNewPort", new String[]{String.valueOf(currentPort), String.valueOf(newPort)}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.ADAP_Port_updated", "-"}));
                            }
                        }
                        catch (Exception ep) {
                            String portsetmessage = ep.getMessage();
                            request.setAttribute("portsettingsmessage", (Object)portsetmessage);
                        }
                        int timeout = 0;
                        int n = time = personaliseForm.get("SESSION_EXPIRY_TIME").toString().length() > 2 ? -1 : (Integer)personaliseForm.get("SESSION_EXPIRY_TIME");
                        if (time > 0) {
                            timeout = time * 60;
                        } else {
                            time = -1;
                            timeout = -1;
                        }
                        try {
                            Integer expiryTime = (Integer)userSettingsRow.get("SESSION_EXPIRY_TIME");
                            if (expiryTime == null || expiryTime != timeout) {
                                userSettingsRow.set("SESSION_EXPIRY_TIME", (Object)timeout);
                                ADSMPersUtil.setSessionExpiry((String)"..\\conf\\web.xml", (String)"..\\conf\\web.dtd", (String)String.valueOf(time));
                                request.getSession().setMaxInactiveInterval(timeout);
                                if (expiryTime != null && expiryTime != timeout) {
                                    request.setAttribute("sessionexpirymessage", (Object)"0");
                                }
                                update = true;
                            }
                            if (update) {
                                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ChangePasswordAction.audit_entry.session_Expiry_time_set", new String[]{String.valueOf(expiryTime)}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.session_expirty_time_set", "-"}));
                                ADSMPersUtil.addOrUpdateUserAccountSettings((Row)userSettingsRow);
                            }
                        }
                        catch (Exception ex) {
                            String message = ex.getMessage();
                            request.setAttribute("sessionexpirymessage", (Object)message);
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.session_expirty_time_set", "-"}));
                            logger.log(Level.WARNING, "Exception while setting the session expiry time ", ex);
                        }
                        try {
                            boolean dbSSL = ADSMPersUtil.checkSSL();
                            boolean formSSL = (Boolean)personaliseForm.get("enableSSL");
                            if (dbSSL != formSSL) {
                                if (formSSL) {
                                    int sslPortNo = (Integer)personaliseForm.get("SSLPortNo");
                                    ADSMPersUtil.updateSyMParameter((String)"SSL", (String)"true");
                                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ChangePasswordAction.audit_entry.Enabled_SSL_Port", new String[]{String.valueOf(sslPortNo)}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.ssl_enabled", "-"}));
                                    ADSMPersUtil.enableSSLPort((int)sslPortNo);
                                } else {
                                    ADSMPersUtil.updateSyMParameter((String)"SSL", (String)"false");
                                    ADSMPersUtil.disableSSLPort();
                                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.ChangePasswordAction.audit_entry.Disabled_SSL_Port"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.ssl_disabled", "-"}));
                                }
                                request.setAttribute("Securitymessage", (Object)"0");
                            } else if (dbSSL && formSSL) {
                                int newSSLPort;
                                int currentSSLPort = SDInstallUtil.getSSLPort();
                                if (currentSSLPort != (newSSLPort = ((Integer)personaliseForm.get("SSLPortNo")).intValue())) {
                                    int result = SDInstallUtil.changeSSLPort((int)newSSLPort);
                                    if (result == 0) {
                                        request.setAttribute("Securitymessage", (Object)"0");
                                    } else if (result == 1) {
                                        request.setAttribute("Securitymessage", (Object)rb.getString("adap.Admin.Change_port_values.Port_number_already_in_use_Please_try_some_other_port_number"));
                                    } else if (result == 3) {
                                        request.setAttribute("Securitymessage", (Object)rb.getString("adap.Admin.Change_port_values.Port_number_out_of_range_Please_provide_a_valid_port_number"));
                                    }
                                }
                                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", request.getAttribute("Securitymessage") + rb.handleGetObject("adap.ChangePasswordAction.audit_entry.oldAndNewPort", new String[]{String.valueOf(currentSSLPort), String.valueOf("newSSLPort")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.port_changed", "-"}));
                            }
                        }
                        catch (Exception se) {
                            String sslMessage = se.getMessage();
                            request.setAttribute("Securitymessage", (Object)sslMessage);
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", sslMessage, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.port_changed", "-"}));
                        }
                    } else {
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.access_denied.ChangePasswordAction.connection"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
                    }
                }
                if (!option.equalsIgnoreCase("ServerSettings")) break block65;
                accessType = AdminHandler.getAccessType((String)"ServerSettings", (ADAPAuthObject)authObj);
                tile = "ServerSettings";
                if (accessType == 32) {
                    try {
                        boolean clientSetting = this.getDefaultClientSettings();
                        logger.log(Level.FINE, "Current clientSetting : " + clientSetting);
                        logger.log(Level.FINE, "UI clientSetting : " + (Boolean)personaliseForm.get("LAUNCH_DEFAULT_BROWSER"));
                        if (clientSetting != (Boolean)personaliseForm.get("LAUNCH_DEFAULT_BROWSER")) {
                            this.clientSettings((Boolean)personaliseForm.get("LAUNCH_DEFAULT_BROWSER"));
                            buf.append(rb.getString("adap.ChangePasswordAction.General"));
                            request.setAttribute("generalsettingsmessage", (Object)"Successfully updated your general settings");
                        }
                        ADSMPersUtil.setGraphValue((String)((String)personaliseForm.get("ExportReport")));
                        boolean startServerCurrVal = this.isStartServerOnBootup();
                        boolean startServerNewVal = (Boolean)personaliseForm.get("START_SERVER_ON_BOOTUP");
                        logger.log(Level.FINE, "Curr val Server start : " + startServerCurrVal + " & New value : " + startServerNewVal);
                        if (startServerCurrVal != startServerNewVal) {
                            this.setServerStartOnBootup(startServerNewVal, request, rb);
                            request.setAttribute("generalsettingsmessage", (Object)"Successfully updated your general settings");
                            if (buf.length() == 0) {
                                buf.append(rb.getString("adap.ChangePasswordAction.General"));
                            }
                        }
                        String usageStatistics = (String)personaliseForm.get("USAGE_STATISTICS");
                        ADSMPersUtil.updateSyMParameter((String)"USAGE_STATISTICS", (String)usageStatistics);
                        ADSMPersUtil.changeUsageStats((String)usageStatistics);
                        String oldLogLevel = ADSMPersUtil.getCurrentLogLevel();
                        String newLogLevel = (String)personaliseForm.get("LOG_LEVEL");
                        if (!oldLogLevel.equalsIgnoreCase(newLogLevel)) {
                            ADSMPersUtil.changeLogLevel((String)newLogLevel);
                            request.setAttribute("loglevelmessage", (Object)"Successfully updated your log level settings");
                            if (buf.length() == 0) {
                                buf.append(rb.getString("adap.ChangePasswordAction.Log_Level"));
                            } else {
                                buf.append(", " + rb.getString("adap.ChangePasswordAction.Log_Level"));
                            }
                        }
                        Properties language = ADSMPersUtil.getLanguageSettings();
                        String oldLanguageSettings = (String)language.get("language");
                        String newLanguageSettings = (String)personaliseForm.get("COUNTRY");
                        if (buf.length() != 0) {
                            buf.append(".");
                            buf.insert(0, rb.getString("adap.ChangePasswordAction.Successfully_updated_the_following_settings"));
                            request.setAttribute("errorMessage", (Object)buf.toString());
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", buf.toString(), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.server_settings_viewed", "-"}));
                        }
                        break block65;
                    }
                    catch (Exception e) {
                        request.setAttribute("errorMessage", (Object)e.getMessage());
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", e.getMessage(), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.server_settings_viewed", "-"}));
                    }
                    break block65;
                }
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.access_denied.ChangePasswordAction.server"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception while personalising ", e);
                throw new Exception("Exception while personalising");
            }
        }
        return new ActionForward("/personalisePage.do?methodToCall=showPersonalisePage&selectedTab=admin&selectedTile=" + tile);
    }

    public ActionForward chooseSkin(ActionMapping actionmapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("personaliseTab", (Object)"chooseSkin");
        return actionmapping.findForward("personalise");
    }

    private void changePassword(String loginName, String oldPasswd, String newPasswd, HttpServletRequest request) throws Exception {
        try {
            String serviceName = ADSMPersUtil.getServiceName((String)loginName);
            logger.log(Level.INFO, " ADAudit Plus Authentication Parameter included");
            AuthUtil.changePassword((String)loginName, (String)serviceName, (String)oldPasswd, (String)newPasswd, (String)"ADAuditPlus Authentication");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ChangePasswordAction.audit_entry.pwd_changed", new String[]{loginName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.change_pwd_failed", "-"}));
        }
        catch (PasswordException ex) {
            logger.log(Level.WARNING, "Exception while changing password ", ex);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ChangePasswordAction.audit_entry.problem_changed_pwd", new String[]{loginName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.change_pwd_failed", "-"}));
            throw ex;
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Exception while changing password ", ex);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ChangePasswordAction.audit_entry.problem_changed_pwd", new String[]{loginName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.change_pwd_failed", "-"}));
            throw ex;
        }
    }

    private boolean getDefaultClientSettings() throws Exception {
        String confFile = "../conf/client_params.conf";
        try {
            Properties props = StartupUtil.getProperties((String)confFile);
            logger.log(Level.FINE, "client settings prop : " + props);
            String launchBrowser = props.getProperty("LAUNCH_BROWSER_CLIENT");
            logger.log(Level.FINE, "Launch Browser value in Conf File: " + launchBrowser);
            return launchBrowser == null || !launchBrowser.equalsIgnoreCase("false");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while getting client startup settings from conf file: " + confFile, e);
            throw new Exception("Exception while getting startup settings");
        }
    }

    private boolean isStartServerOnBootup() throws Exception {
        String startServerOnBootup = null;
        try {
            String startupType = ADHandler.getServiceStartupType((String)"ADAudit Plus");
            logger.log(Level.FINE, "Service startup type retrieved using native call is: " + startupType);
            startServerOnBootup = startupType != null && startupType.equalsIgnoreCase("Manual") ? "false" : "true";
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Caught exception while getting service startup type from the native.", ex);
        }
        String startUpTypeFromDB = ADSMPersUtil.getSyMParameter((String)"START_SERVER_ON_BOOTUP");
        if (startServerOnBootup == null && startUpTypeFromDB != null) {
            startServerOnBootup = startUpTypeFromDB;
        }
        if (startServerOnBootup == null) {
            startServerOnBootup = "true";
        }
        if (startUpTypeFromDB == null || !startUpTypeFromDB.equalsIgnoreCase(startServerOnBootup)) {
            startUpTypeFromDB = startServerOnBootup;
            ADSMPersUtil.updateSyMParameter((String)"START_SERVER_ON_BOOTUP", (String)startServerOnBootup);
        }
        return Boolean.valueOf(startServerOnBootup);
    }

    private void setServerStartOnBootup(boolean bool, HttpServletRequest request, AdventNetResourceBundle rb) throws Exception {
        String startupType = "Automatic";
        if (!bool) {
            startupType = "Manual";
        }
        logger.log(Level.FINE, "Going to change the startup type of service: ADAudit Plus to: " + startupType);
        ADHandler.setServiceStartupType((String)"ADAudit Plus", (boolean)bool);
        ADSMPersUtil.updateSyMParameter((String)"START_SERVER_ON_BOOTUP", (String)String.valueOf(bool));
        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ChangePasswordAction.audit_entry.server_Startup_on_bootup", new String[]{startupType}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.server_seting_changed", "-"}));
    }

    private void clientSettings(Boolean launchDefaultBrowser) throws Exception {
        String confFile = "../conf/client_params.conf";
        try {
            logger.log(Level.FINE, "Launch Browser value from client: " + launchDefaultBrowser);
            Properties props = new Properties();
            props.setProperty("LAUNCH_BROWSER_CLIENT", launchDefaultBrowser.toString());
            logger.log(Level.FINE, "Launch Browser value from client: " + props + " & FILE " + confFile);
            StartupUtil.storeProperties((Properties)props, (String)confFile);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while updating launch browser client flag in conf file: " + confFile, e);
            throw new Exception("Exception while updating launch browser client");
        }
    }
}

