/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin.importlog;

import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.importlog.ImportLogFileUtil;
import com.adventnet.sym.adsm.auditing.server.importlog.ImportLogListener;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.ADSMPersUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.webclient.admin.importlog.ImportLogFileBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class ImportLogFileAction
extends DispatchAction {
    public ActionForward viewImportLog(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            StringBuffer buff = null;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String sortColumn = request.getParameter("sortColumn");
            String sortOrder = request.getParameter("sortOrder");
            String pageNumber = request.getParameter("PAGE_NUMBER");
            Integer fromIndex = new Integer(request.getParameter("FROM_INDEX"));
            Integer range = new Integer(request.getParameter("RANGE"));
            String b = request.getParameter("deleteImportLog");
            if (b != null && b.equalsIgnoreCase("true")) {
                buff = new StringBuffer(rb.getString("adap.AdminHandler.Successfully_Deleted"));
            } else if (b != null && b.equalsIgnoreCase("false")) {
                buff = new StringBuffer(rb.getString("adap.ModifyReportScheduler.Error_Occurred_while_Deleting_the"));
            }
            this.setAttribute(request, buff, sortColumn, sortOrder, pageNumber, fromIndex, range);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("viewImportLogFiles");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward createImportLog(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"ImportLogFiles", (ADAPAuthObject)authObj);
        Integer pathId = 0;
        boolean create = false;
        String forward = "configureImportLogFile";
        ImportLogFileBean importLogBean = (ImportLogFileBean)form;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        StringBuffer buff = new StringBuffer();
        try {
            String action = request.getParameter("action");
            if (action != null) {
                if (accessType == 32) {
                    create = true;
                    forward = "viewImportLogFiles";
                    String reportType = request.getParameter("reportType");
                    String importLogPath = (String)importLogBean.get("fileLocation");
                    HashMap map = new HashMap();
                    if (reportType.equalsIgnoreCase("once")) {
                        map = ImportLogFileUtil.getInstance().checkFolderPermission(importLogPath);
                    } else {
                        importLogPath = importLogPath + File.separator + "*";
                        map = ImportLogFileUtil.getInstance().checkFolderPermission(importLogPath);
                    }
                    if (map != null && map.containsKey("errorMessage")) {
                        buff.append((String)map.get("errorMessage"));
                    } else {
                        if (reportType.equalsIgnoreCase("once")) {
                            ArrayList<String> list = new ArrayList<String>();
                            list.add(importLogPath);
                            ImportLogFileUtil.getInstance().addFileInDB(list, Integer.valueOf(0), reportType);
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ImportLogFileAction.audit_entry.Successfully_Started_fetching_Event_Data_from_file", new String[]{importLogPath, (String)importLogBean.get("reportType")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.fetched_event_data_from_evt", "-"}));
                            buff.append(rb.getString("adap.ImportLogFileAction.Successfully_Started_fetching_Event_Data_from_file"));
                        } else {
                            DataObject importLogDO = importLogBean.getImportLogDO("save");
                            Row row = importLogDO.getRow("AudImportLogPathConfig");
                            DataAccess.generateValues((Row)row);
                            pathId = (Integer)row.get("PATH_ID");
                            CommonUtil.getPersistence((boolean[])new boolean[0]).add(importLogDO);
                            ImportLogListener.getInstance().addArchiveFileInDB(pathId, reportType);
                            buff.append(rb.getString("adap.CreateImportLogFile.event_fetch_happened_while_schedule_run"));
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.CreateImportLogFile.event_fetch_happened_while_schedule_run", new String[]{(String)row.get("EVENT_LOG_PATH"), (String)importLogBean.get("reportType")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.fetched_event_data_from_evt", "-"}));
                        }
                        ImportLogFileUtil.getInstance().enableMetaTableEntry();
                    }
                } else {
                    request.setAttribute("MESSAGESTR", (Object)rb.getString("adap.access_denied.CreateImportLogFile.create"));
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.access_denied.CreateImportLogFile.create"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
                }
            } else {
                importLogBean.initialize(mapping);
                importLogBean.init(request);
            }
        }
        catch (Exception ex) {
            buff = new StringBuffer();
            buff.append(ex.getMessage());
            ex.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.CreateImportLogFile.audit_entry.Error_in_configuring_Import_Logs"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.fetched_event_data_from_evt", ex.getMessage()}));
        }
        finally {
            if (create) {
                if (buff != null) {
                    request.setAttribute("message", (Object)buff.toString());
                }
                request.setAttribute("update", (Object)true);
                request.setAttribute("isImportLogFileList", (Object)"true");
                this.setArchiveFiles(request, pathId, 1, "1", 25);
            }
        }
        return mapping.findForward(forward);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward updateImportLog(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardName = "configureImportLogFile";
        StringBuffer buff = new StringBuffer();
        ImportLogFileBean bean = (ImportLogFileBean)form;
        boolean update = false;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"ImportLogFiles", (ADAPAuthObject)authObj);
        try {
            String action = request.getParameter("action");
            if (action != null) {
                update = true;
                if (accessType == 32) {
                    DataObject dataObject = bean.getImportLogDO(action);
                    ImportLogFileUtil.getInstance().updateImportLog(dataObject, new Long(bean.get("scheduleId").toString()));
                } else {
                    buff.append(rb.getString("adap.access_denied.CreateImportLogFile.update"));
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.access_denied.CreateImportLogFile.update"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
                }
                forwardName = "viewImportLogFiles";
            } else {
                Long schedulerId = new Long(request.getParameter("scheduleId"));
                bean.init(request);
                bean.set("scheduleId", schedulerId);
                bean.setProperties(schedulerId);
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.ImportLogFileAction.Successfully_updated"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.update_import_log", "-"}));
            buff.append(rb.getString("adap.ImportLogFileAction.Successfully_updated"));
        }
        catch (Exception ex) {
            buff = new StringBuffer();
            buff.append(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            if (update) {
                this.setAttribute(request, buff, "AudImportLogPathConfig-MODIFICATION_TIME", "desc", "1", 1, 25);
            }
        }
        return mapping.findForward(forwardName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward changeAdminStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        StringBuffer buff = new StringBuffer();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"ImportLogFiles", (ADAPAuthObject)authObj);
        try {
            Long scheduleId = new Long(request.getParameter("scheduleId"));
            Integer adminStatus = new Integer(request.getParameter("ADMIN_STATUS"));
            if (accessType == 32) {
                ImportLogFileUtil.getInstance().changeAdminStatus(scheduleId, adminStatus);
                Row row = ReportUtil.getFirstRow((String)"Schedule", (String)"SCHEDULE_ID", (Object)scheduleId, (int)0);
                if ((long)adminStatus.intValue() == 3L) {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.CreateImportLogFile.audit_entry.Successfully_enabled_import_log_schedule", new String[]{(String)row.get("SCHEDULE_NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.modify_import_log", "-"}));
                    buff.append(rb.getString("adap.NetlogonLogAction.Successfully_enabled"));
                } else {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.CreateImportLogFile.audit_entry.Successfully_disabled_import_log_schedule", new String[]{(String)row.get("SCHEDULE_NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.modify_import_log", "-"}));
                    buff.append(rb.getString("adap.NetlogonLogAction.Successfully_disabled"));
                }
            } else {
                buff.append(rb.getString("adap.access_denied.CreateImportLogFile.change"));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.access_denied.CreateImportLogFile.change"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            }
        }
        catch (Exception ex) {
            buff = new StringBuffer();
            buff.append(ex.getMessage());
            ex.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.CreateImportLogFile.audit_entry.Problem_enabling_Disabling_import_log_schedule", new String[]{ex.getMessage()}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.modify_import_log", "-"}));
        }
        finally {
            this.setAttribute(request, buff, "AudImportLogPathConfig-MODIFICATION_TIME", "desc", "1", 1, 25);
        }
        return mapping.findForward("importPathList");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward deleteScheduler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        StringBuffer buff = new StringBuffer();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"ImportLogFiles", (ADAPAuthObject)authObj);
        try {
            Long scheduleId = new Long(request.getParameter("scheduleId"));
            Row row = ReportUtil.getFirstRow((String)"Schedule", (String)"SCHEDULE_ID", (Object)scheduleId, (int)0);
            if (accessType == 32) {
                ImportLogFileUtil.getInstance().deleteScheduler(scheduleId);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.CreateImportLogFile.audit_entry.successfully_deleted_import_log_scheduler", new String[]{(String)row.get("SCHEDULE_NAME")}), 16, 8, "adap.ADAPUserAuditSeverities.audit_name.delete_import_log", "-"}));
                request.setAttribute("deleteImportLog", (Object)true);
                buff.append(rb.getString("adap.AdminHandler.Successfully_Deleted"));
            } else {
                buff.append(rb.getString("adap.access_denied.CreateImportLogFile.delete"));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.access_denied.CreateImportLogFile.delete"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            }
        }
        catch (Exception ex) {
            request.setAttribute("deleteImportLog", (Object)false);
            buff = new StringBuffer();
            buff.append(ex.getMessage());
            ex.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.CreateImportLogFile.audit_entry.probllem_while_deleting_import_log_scheduler", new String[]{ex.getMessage()}), 16, 16, "adap.ADAPUserAuditSeverities.audit_name.delete_import_log", "-"}));
        }
        finally {
            this.setAttribute(request, buff, "AudImportLogPathConfig-MODIFICATION_TIME", "desc", "1", 1, 25);
        }
        return mapping.findForward("importPathList");
    }

    public void setAttribute(HttpServletRequest request, StringBuffer buff, String sortColumn, String sortOrder, String pageNumber, Integer fromIndex, Integer range) {
        try {
            int count = ImportLogFileUtil.getInstance().getPathCount();
            ArrayList list = new ArrayList();
            if (count > 0) {
                list = ImportLogFileUtil.getInstance().getImportLogList(sortColumn, sortOrder, Integer.valueOf(count), fromIndex, range);
            }
            request.setAttribute("RANGE", (Object)range);
            request.setAttribute("list", list);
            request.setAttribute("count", (Object)count);
            request.setAttribute("PAGE_NUMBER", (Object)pageNumber);
            if (buff != null) {
                request.setAttribute("message", (Object)buff.toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ActionForward viewArchiveFiles(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        StringBuffer buff = new StringBuffer();
        try {
            Integer pathId = new Integer(request.getParameter("PATH_ID"));
            Integer fromIndex = new Integer(request.getParameter("FROM_INDEX"));
            String pageNumber = request.getParameter("PAGE_NUMBER");
            Integer range = new Integer(request.getParameter("RANGE"));
            this.setArchiveFiles(request, pathId, fromIndex, pageNumber, range);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward("viewArchiveFileList");
    }

    public void setArchiveFiles(HttpServletRequest request, Integer pathId, Integer fromIndex, String pageNumber, Integer range) throws Exception {
        int count = ImportLogFileUtil.getInstance().getArchiveFileCount(pathId);
        ArrayList list = new ArrayList();
        if (count > 0) {
            list = ImportLogFileUtil.getInstance().getArchiveFileList(pathId, Integer.valueOf(count), fromIndex, range);
        }
        request.setAttribute("RANGE", (Object)range);
        request.setAttribute("list", (Object)list);
        request.setAttribute("count", (Object)count);
        request.setAttribute("PATH_ID", (Object)pathId);
        request.setAttribute("PAGE_NUMBER", (Object)pageNumber);
    }

    public ActionForward changeArchiveStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"ImportLogFiles", (ADAPAuthObject)authObj);
        try {
            String noOfDays = request.getParameter("noOfDays");
            Integer val = 3;
            if (noOfDays.equals("0")) {
                val = 4;
            }
            if (accessType == 32) {
                String scheduleIdUVH = "Schedule:schedule_id:UVH@5001";
                Long scheduleId = DBObjectUtil.getUVHValues((String)"Schedule", (String)scheduleIdUVH);
                ImportLogFileUtil.getInstance().changeAdminStatus(scheduleId, val);
                if (!noOfDays.equals("0")) {
                    ImportLogFileUtil.getInstance().updateTaskInput(scheduleId, noOfDays);
                    ImportLogFileUtil.getInstance().updatePeriodic(scheduleId, noOfDays);
                }
                ADSMPersUtil.updateSyMParameter((String)"IMPORT_LOG_ARCHIVE_DAYS", (String)noOfDays);
                if (noOfDays.equals("0")) {
                    ClientUtil.setStatusXMLElement(response, "Success", rb.getString("adap.ObjectDetails.view_props.user.common.statmsg.disabled"));
                    Row row = ReportUtil.getFirstRow((String)"Schedule", (String)"SCHEDULE_ID", (Object)scheduleId, (int)0);
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.CreateImportLogFile.audit_entry.Successfully_disabled_import_log_schedule", new String[]{(String)row.get("SCHEDULE_NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.modify_import_log", "-"}));
                } else {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.CreateImportLogFile.audit_entry.Successfully_updated_imported_log_archive_days", new String[]{noOfDays}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.modify_import_log", "-"}));
                    ClientUtil.setStatusXMLElement(response, "Success", rb.getString("adap.AuditReportAction.Successfully_Saved"));
                }
            } else {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.access_denied.CreateImportLogFile.change"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
                ClientUtil.setStatusXMLElement(response, "Error", rb.getString("adap.access_denied.CreateImportLogFile.change"));
            }
        }
        catch (Exception ex) {
            ClientUtil.setStatusXMLElement(response, "Error", ex.getMessage());
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.CreateImportLogFile.audit_entry.Problem_updating_import_log_file", new String[]{ex.getMessage()}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.modify_import_log", "-"}));
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward runArchiveFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"ImportLogFiles", (ADAPAuthObject)authObj);
        try {
            if (accessType == 32) {
                Integer fileId = new Integer(request.getParameter("FILE_ID"));
                Row row = ImportLogFileUtil.getInstance().getImportFileRow("FILE_ID", (Object)fileId);
                Integer pathId = (Integer)row.get("PATH_ID");
                HashMap<String, Object> map = new HashMap<String, Object>();
                String filePath = (String)row.get("FILE_NAME");
                if (pathId == 0) {
                    map.put("FILE_ID", fileId);
                } else {
                    Row pathRow = ImportLogFileUtil.getInstance().getLogPathRow("PATH_ID", (Object)pathId);
                    filePath = (String)pathRow.get("EVENT_LOG_PATH") + File.separator + row.get("FILE_NAME").toString();
                    map.put("FILE_ID", fileId);
                }
                map.put("FILE_NAME", filePath);
                ImportLogListener.getInstance().readArchiveLog(map);
                ClientUtil.setStatusXMLElement(response, "Success", rb.handleGetObject("adap.DomainAction.Successfully_scheduled_the_event_collection_file", new String[]{filePath}));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.DomainAction.Successfully_scheduled_the_event_collection_file", new String[]{filePath}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.evt_collection_scheduled", "-"}));
            } else {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.access_denied.CreateImportLogFile.run"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            }
        }
        catch (Exception ex) {
            if (ex.getMessage() != null) {
                ClientUtil.setStatusXMLElement(response, "Error", ex.getMessage());
            } else {
                ClientUtil.setStatusXMLElement(response, "Error", rb.getString("adap.admin.importlog_path_Exception_text"));
            }
            ex.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.CreateImportLogFile.audit_entry.Problem_running_import_log_file", new String[]{ex.getMessage()}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.evt_collection_scheduled", "-"}));
        }
        return null;
    }

    public ActionForward viewImportPathList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String sortColumn = request.getParameter("sortColumn");
            String sortOrder = request.getParameter("sortOrder");
            String pageNumber = request.getParameter("PAGE_NUMBER");
            Integer fromIndex = new Integer(request.getParameter("FROM_INDEX"));
            Integer range = new Integer(request.getParameter("RANGE"));
            this.setAttribute(request, null, sortColumn, sortOrder, pageNumber, fromIndex, range);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("importPathList");
    }
}

