/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin.technician;

import com.adventnet.sym.adsm.auditing.server.reports.AuditReportParamsAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.admin.TechnicianHandler;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.admin.delegation.TechnicianAuditHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class TechAuditReports
extends DispatchAction {
    private static Logger logger = Logger.getLogger(TechnicianHandler.class.getName());

    public ActionForward report(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object resultantRows = null;
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            DynaActionForm bean = (DynaActionForm)form;
            JSONObject jsonObj = new JSONObject(request.getParameter("params"));
            String loginName = jsonObj.getString("LOGIN_NAME");
            String objectClass = jsonObj.getString("OBJECT_CLASS");
            String searchCriteria = TechnicianAuditHandler.formSearchCriteria((String)jsonObj.getString("SEARCH_STRING"));
            searchCriteria = TechnicianAuditHandler.addActionInCriteria((String)searchCriteria, (String)jsonObj.getString("ACTION"));
            String inputDays = jsonObj.getString("TIME_PERIOD");
            HashMap<String, String> inputParams = new HashMap<String, String>();
            inputParams.put("inputDays", inputDays);
            if (inputDays.equals("customPeriod")) {
                inputParams.put("startTime", jsonObj.getString("START_TIME"));
                inputParams.put("startHour", jsonObj.getString("START_HOUR"));
                inputParams.put("endTime", jsonObj.getString("END_TIME"));
                inputParams.put("endHour", jsonObj.getString("END_HOUR"));
            }
            HashMap inputParamsMap = AuditReportParamsAPI.getInputParamsValues(inputParams, null);
            inputParamsMap.put("userId", TechnicianAuditHandler.getUserId((Long)jsonObj.getLong("USER_ID"), (String)jsonObj.getString("OBJECT_CLASS")));
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Admin", rb.handleGetObject("adap.TechnicianRolesConfig.audit_entry.technician_audit_log_was_generated_for_user", new String[]{loginName}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.tech_report_viewed", "-"}));
            int count = TechnicianAuditHandler.getAuditRowsCount((String)searchCriteria, (HashMap)inputParamsMap);
            ArrayList auditList = new ArrayList();
            if (count > 0) {
                auditList = TechnicianAuditHandler.getAuditRowsList((String)searchCriteria, (HashMap)inputParamsMap, (int)jsonObj.getInt("START_INDEX"), (int)jsonObj.getInt("LIMIT"), (int)count, (Boolean)false);
                request.setAttribute("COLUMNS_LIST", (Object)TechnicianAuditHandler.getVisibleColumns());
                request.setAttribute("AVAILABLE_COLUMNS_LIST", (Object)TechnicianAuditHandler.getCustomVisibleList());
            }
            request.setAttribute("AUDIT_ROW_COUNT", (Object)count);
            request.setAttribute("AUDIT_ROWS", resultantRows);
            request.setAttribute("ROWS_LIST", (Object)auditList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward("TechAuditReports");
    }

    public ActionForward exportReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            DynaActionForm bean = (DynaActionForm)form;
            JSONObject jsonObj = new JSONObject(request.getParameter("params"));
            String loginName = jsonObj.getString("LOGIN_NAME");
            String objectClass = jsonObj.getString("OBJECT_CLASS");
            String action = jsonObj.getString("ACTION");
            String searchString = jsonObj.getString("SEARCH_STRING");
            String searchCriteria = TechnicianAuditHandler.formSearchCriteria((String)searchString);
            searchCriteria = TechnicianAuditHandler.addActionInCriteria((String)searchCriteria, (String)action);
            String inputDays = jsonObj.getString("TIME_PERIOD");
            HashMap<String, String> inputParams = new HashMap<String, String>();
            inputParams.put("inputDays", inputDays);
            if (inputDays.equals("customPeriod")) {
                inputParams.put("startTime", jsonObj.getString("START_TIME"));
                inputParams.put("startHour", jsonObj.getString("START_HOUR"));
                inputParams.put("endTime", jsonObj.getString("END_TIME"));
                inputParams.put("endHour", jsonObj.getString("END_HOUR"));
            }
            HashMap inputParamsMap = AuditReportParamsAPI.getInputParamsValues(inputParams, null);
            inputParamsMap.put("DOMAIN_NAME", TDHandler.getDomainName((Long)Long.parseLong(jsonObj.getString("USER_ID")), (String)jsonObj.getString("OBJECT_CLASS")));
            inputParamsMap.put("userId", TechnicianAuditHandler.getUserId((Long)jsonObj.getLong("USER_ID"), (String)jsonObj.getString("OBJECT_CLASS")));
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Admin", rb.handleGetObject("adap.TechnicianRolesConfig.audit_entry.technician_audit_log_was_exported_for_user", new String[]{loginName}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.tech_report_viewed", "-"}));
            TechnicianAuditHandler.exportReport((HashMap)inputParamsMap, (String)searchCriteria, (String)loginName, (String)jsonObj.getString("EXPORT_TYPE"), (HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward resetColumns(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            DynaActionForm bean = (DynaActionForm)form;
            JSONObject jsonObj = new JSONObject(request.getParameter("params"));
            Boolean status = TechnicianAuditHandler.resetColumns((Long[])ReportUtil.jsonArrayToLongArray((JSONArray)jsonObj.getJSONArray("VISIBLE_COLUMNS")));
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.TechnicianRolesConfig.audit_entry.technician_audit_column_reset_successfully", new String[]{jsonObj.getString("LOGIN_NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.tech_report_viewed", "-"}));
        }
        catch (Exception ex) {
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL")}));
            ex.printStackTrace();
        }
        return new ActionForward("/TechAuditReports.do?methodToCall=report");
    }
}

