/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.api;

import com.adventnet.sym.adsm.auditing.server.config.ServerConfigAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.InheritedHostHandler;
import com.adventnet.sym.adsm.common.server.MSHandler;
import com.manageengine.ads.fw.service.util.ProductUniqueSeqGenerator;
import com.manageengine.ads.fw.util.CommonUtil;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONObject;

public class ConvertExistingHost
extends DispatchAction {
    private static final Logger LOGGER = Logger.getLogger(ConvertExistingHost.class.getName());

    public ActionForward switchHostAndInheritedHost(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String reqSource_seqNumber = request.getParameter("SEQUENCE_ID");
        LOGGER.info("Request recived from : " + reqSource_seqNumber);
        LOGGER.info("FORWARD_FROM  : " + request.getParameter("FORWARD_FROM"));
        JSONObject responseObj = new JSONObject();
        try {
            String isUpdateAction = request.getParameter("UPDATE_ACTION");
            if (reqSource_seqNumber == null) {
                this.loadResultData(responseObj, "SEQUENCE_ID Not FOund", false);
            } else if (isUpdateAction != null && isUpdateAction.equalsIgnoreCase("TRUE")) {
                this.disableHostBasedOnCount(request, responseObj, reqSource_seqNumber);
            } else {
                this.handlerConvertHost(request, responseObj, reqSource_seqNumber);
            }
        }
        catch (Exception exp) {
            this.loadResultData(responseObj, exp.getMessage(), false);
        }
        LOGGER.fine("responseObj  : " + responseObj);
        CommonUtil.setResponseText((HttpServletResponse)response, (String)responseObj.toString());
        return null;
    }

    private void disableHostBasedOnCount(HttpServletRequest request, JSONObject responseObj, String reqSource_seqNumber) throws Exception {
        String meberserver_count = request.getParameter("LICENSE_COUNT");
        String workstation_count = request.getParameter("WORKSTATION_LICENSE_COUNT");
        int count = 0;
        if (meberserver_count != null) {
            count += this.updateMachineByType(meberserver_count, 16, reqSource_seqNumber);
        }
        if (workstation_count != null) {
            count += this.updateMachineByType(workstation_count, 4096, reqSource_seqNumber);
        }
        this.loadResultData(responseObj, "Total Disabled Count : " + count, true);
    }

    private int updateMachineByType(String meberserver_count, Integer machineType, String reqSource_seqNumber) {
        try {
            int count = Integer.parseInt(meberserver_count);
            LOGGER.fine("Disable action count : " + count);
            return MSHandler.checkAndUpdateServers((int)count, (int)machineType, (String)reqSource_seqNumber);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return 0;
        }
    }

    private boolean handlerConvertHost(HttpServletRequest request, JSONObject responseObj, String reqSource_seqNumber) throws Exception {
        String hostName = request.getParameter("HOST_NAME");
        String domainName = request.getParameter("DOMAIN_NAME");
        String is_inherited = request.getParameter("CHANGETO_INHERITED");
        String status_Message = "";
        String current_enabled_count = request.getParameter("CURRENT_ENABLED_COUNT");
        String current_licensed_count = request.getParameter("CURRENT_LICENSED_COUNT");
        String requestInitiatedBy = request.getParameter("ADD_REQUEST_INITIATED_BY");
        String deviceStatus = request.getParameter("DEVICE_STATUS");
        Integer machineType = MSHandler.getMachineType((String)hostName, (String)domainName);
        LOGGER.fine("Host : " + hostName + "  DomainName : " + domainName + "  machineType : " + machineType + "  is_inherited : " + is_inherited);
        if (machineType != null) {
            ArrayList list = DomainHandler.getComputerId((String)hostName, (String)domainName);
            if (is_inherited == null || is_inherited.equalsIgnoreCase("null")) {
                status_Message = "unknown action";
                LOGGER.fine("Request recived from  : " + reqSource_seqNumber + "  with " + hostName + " for unknown Action");
                this.loadResultData(responseObj, "Unknown Action", false);
                return false;
            }
            if (is_inherited.equalsIgnoreCase("TRUE")) {
                LOGGER.fine("Request recived from  : " + reqSource_seqNumber + "  to convert " + hostName + " host to inherited device");
                status_Message = InheritedHostHandler.convertToInheritedHost((ArrayList)list, (String)domainName, (String)reqSource_seqNumber);
                this.loadResultData(responseObj, status_Message, true);
            } else if (is_inherited.equalsIgnoreCase("FALSE")) {
                LOGGER.fine("Request recived from  : " + reqSource_seqNumber + "  to convert " + hostName + " host to Local device");
                Integer licenseCount = MSHandler.getLicenseCount((Integer)machineType);
                int enableCount = ServerConfigAPI.getConfiguredServerCount((int[])new int[]{machineType});
                if ((machineType & 0x10) == 16) {
                    enableCount += ServerConfigAPI.getPrintServerCount() - ServerConfigAPI.getPrintMemberServerCount((int)16, (boolean)false);
                }
                if (requestInitiatedBy != null && requestInitiatedBy.equals(ProductUniqueSeqGenerator.getCurrentSeqNumber()) && Boolean.valueOf(deviceStatus).booleanValue()) {
                    LOGGER.info("Request initiated from local device");
                    --enableCount;
                }
                if (licenseCount > enableCount) {
                    status_Message = InheritedHostHandler.convertToLocalHost((ArrayList)list, (String)domainName, (String)reqSource_seqNumber);
                    this.loadResultData(responseObj, status_Message, true);
                } else if (current_enabled_count != null && current_licensed_count != null && Integer.parseInt(current_enabled_count) < Integer.parseInt(current_licensed_count)) {
                    LOGGER.info("current_enabled_count -" + current_enabled_count + " , current_licensed_count " + current_licensed_count);
                    status_Message = InheritedHostHandler.convertToInheritedHost((ArrayList)list, (String)domainName, (String)reqSource_seqNumber);
                    LOGGER.info("License count condn not satisfied, Based on remote device licened count local device is converted to synced device");
                    this.loadResultData(responseObj, "Unable to perform requested action, but based on the license count local device converted to synced device", false);
                } else {
                    this.loadResultData(responseObj, "License limit Reached , raised request was rejected", false);
                    LOGGER.info("License limit Reached , raised request was rejected [new parameters are not recived - current_ENABLED_count ]");
                }
            } else {
                status_Message = "unknown action";
                LOGGER.fine("Request recived from  : " + reqSource_seqNumber + "  with " + hostName + " for unknown Action");
                this.loadResultData(responseObj, "Unknown Action", false);
            }
        } else {
            this.loadResultData(responseObj, "Server was not a member server or workstation in requsted product", false);
        }
        return true;
    }

    private void loadResultData(JSONObject responseObj, String status_Message, boolean status) {
        try {
            if (status) {
                responseObj.put("sSTATUS", (Object)"SUCCESS");
                responseObj.put("STATUS_MESSAGE", (Object)status_Message);
            } else {
                responseObj.put("eSTATUS", (Object)"FAILED");
                responseObj.put("STATUS_MESSAGE", (Object)status_Message);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }
}

