/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.api;

import com.manageengine.ads.fw.license.LicenseManager;
import com.manageengine.ads.fw.util.CommonUtil;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONException;
import org.json.JSONObject;

public class GetHostAndLicenseDetails
extends DispatchAction {
    private static final Logger LOGGER = Logger.getLogger(GetHostAndLicenseDetails.class.getName());

    public ActionForward getHostDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int index;
        String reqSource_seqNumber = request.getParameter("SEQUENCE_ID");
        LOGGER.info("Request recived from : " + reqSource_seqNumber);
        String[] wrkstation_hostKeys = new String[]{"WorkStation"};
        String[] wrkstation_countKey = new String[]{"NumberOfWorkStations"};
        String[] server_hostKeys = new String[]{"MemberServer", "DomainController", "FileServer"};
        String[] server_countKey = new String[]{"NumberOfMemberServers", "NumberOfDomainControllers", "NumberOfFileServers"};
        JSONObject responseDetails = new JSONObject();
        JSONObject licenseDetails = LicenseManager.getLicenseDetails();
        responseDetails.put("LICENSE_RAWDATA", (Object)licenseDetails);
        JSONObject components = licenseDetails.getJSONObject("COMPONENT_DETAILS");
        Integer workstation_count = 0;
        Integer server_count = 0;
        for (index = 0; index < server_hostKeys.length; ++index) {
            server_count = server_count + this.returnChildJsonvalue(components, server_hostKeys[index], server_countKey[index]);
        }
        for (index = 0; index < wrkstation_hostKeys.length; ++index) {
            workstation_count = workstation_count + this.returnChildJsonvalue(components, wrkstation_hostKeys[index], wrkstation_countKey[index]);
        }
        responseDetails.put("SERVER_HOST_COUNT", (Object)server_count);
        responseDetails.put("WORKSTATION_HOST_COUNT", (Object)workstation_count);
        responseDetails.put("HOST_COUNT", server_count + workstation_count);
        responseDetails.put("DOMAIN_COUNT", (Object)this.returnChildJsonvalue(components, "Domains", "NumberOfDomains"));
        if (licenseDetails.has("LICENSE_TYPE_CODE")) {
            responseDetails.put("LICENSE_CODE", licenseDetails.get("LICENSE_TYPE_CODE"));
        }
        if (licenseDetails.has("LICENSE_TYPE")) {
            responseDetails.put("LICENSE_TYPE", licenseDetails.get("LICENSE_TYPE"));
        }
        CommonUtil.setResponseText((HttpServletResponse)response, (String)responseDetails.toString());
        return mapping.findForward(null);
    }

    private Integer returnChildJsonvalue(JSONObject obj, String key, String childKey) throws JSONException {
        JSONObject jsonObj;
        if (obj.has(key) && (jsonObj = new JSONObject(obj.getString(key))).has(childKey)) {
            return jsonObj.getInt(childKey);
        }
        return 0;
    }
}

